function Fig3DE_sim_cross_before_fusion()

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%This script simulates SV fusion with step calcium concentration and 
% determines the number of crosslinks formed prior to fusion for different 
% choices of number of slots (Figure 2DE and Figure 2 - figure supplement 2)

Allost_IO = 1;

Calciums = [0.5 1 50 100 200 400];
fitslots = 6;

n_runs = 10000;
t_lim = 1e4;


state_before_fuse = NaN(length(Calciums),n_runs);


for fitslot = fitslots
% fitslot = 3;






    for Ca_ind = 1:length(Calciums)
        Calcium = Calciums(Ca_ind);

        if fitslot == 1
            parinitno = 51;
        else
            parinitno = 16;
        end

        resultsfilename = ['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross' num2str(fitslot) '_parinitno' num2str(parinitno) '_KDcato2ions2.mat'];

        load(resultsfilename, 'par');


        nsyts = par(8);
        nslots = par(14);

        [SS_eq] = steady_state_newmethod(par, 1, 0.05);

        cum_SS = cumsum(SS_eq);

        QMatrix = MakeQMatrix(par, Calcium);
        fus_state = length(QMatrix(1,:));


        states_all = NaN(n_runs,1e4);
        tvec_all = NaN(n_runs,1e4);

        parfor k = 1:n_runs

            disp(['Calcium:' num2str(Calcium) ', Fitslot = ' num2str(fitslot) ', Allost_IO = ' num2str(Allost_IO) ', SV number: ' num2str(k)])
%             states = NaN(1,1e4);
%             tvec = NaN(1,1e4);

            SS_p = rand(1,1);

            init_state = find(SS_p<=cum_SS, 1, 'first');
            state_cur = init_state;
            t_cur = 0;
            nofus = 1;
            cur_ind = 1;
            while nofus && t_cur<t_lim
                ps = rand(1,2);
                a_vec = QMatrix(state_cur, :);
                a_vec(state_cur) = 0;
                a_0 = sum(a_vec);

                tau = (1/a_0)*log(1/ps(1));
                a_cum = cumsum(a_vec)/a_0;
                react = find(ps(2)<=a_cum, 1, 'first');

                t_cur = t_cur+tau;
                state_before = state_cur;
                state_cur = react;

                if react == fus_state
                    nofus = 0;
                    state_before_fuse(Ca_ind, k) = state_before;
                end

            end 
        end
        save(['./Outputs/Figure_results/Figure3/cross_before_fusions_individualruns_fitslot' num2str(fitslot) '_Allost' num2str(Allost_IO) '_MORECALCIUM.mat'], 'state_before_fuse', 'Calciums')
    end
end
