function Fig3DE_sim_cross_before_fusion_linearCA()

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%This script simulates SV fusion with linearly increasing calcium 
% concentration and determines the number of crosslinks formed prior to 
% fusion (Figure 2 - figure supplement 2)

Allost_IO = 1;

ramp_times = [100 75 50 25 10 5 1 0.001];
fitslots = 6;

n_runs = 10;
nves_per_run = 1000;
t_lim = 1e4;
min_step = 1e-4;

Ca_bas = 0.05;
Ca_max = 100;

state_before_fuse_all = zeros(length(ramp_times),n_runs, nves_per_run);


for fitslot = fitslots
% fitslot = 3;






    for Ramp_ind = 1:length(ramp_times)
        ramp_time = ramp_times(Ramp_ind);

        if fitslot == 1
            parinitno = 51;
        else
            parinitno = 16;
        end

        resultsfilename = ['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross' num2str(fitslot) '_parinitno' num2str(parinitno) '_KDcato2ions2.mat'];

        load(resultsfilename, 'par');


        nsyts = par(8);
        nslots = par(14);

        [SS_eq] = steady_state_newmethod(par, 1, Ca_bas);

        cum_SS = cumsum(SS_eq);

        QMatrix_test = MakeQMatrix(par, 1);
        fus_state = length(QMatrix_test(1,:));

        state_before_fuse_init = zeros(1, nves_per_run);


        parfor k = 1:n_runs

            disp(['Ramp time: ' num2str(ramp_time) ' Fitslot = ' num2str(fitslot) ', Allost_IO = ' num2str(Allost_IO) ', run number: ' num2str(k) ' of ' num2str(n_runs)])
%             states = NaN(1,1e4);
%             tvec = NaN(1,1e4);

            SS_p = rand(nves_per_run,1);

            init_state = zeros(1,nves_per_run);
            for l = 1:nves_per_run
                init_state(l) = find(SS_p(l)<=cum_SS, 1, 'first');
            end
            state_cur = init_state;
            t_cur = 0;
            no_fus = 0;
            cur_ind = 1;
           
            while no_fus<nves_per_run && t_cur<t_lim
                
                Ca_cur = (t_cur>ramp_time)*Ca_max + (t_cur<=ramp_time)*((t_cur/ramp_time)*(Ca_max - Ca_bas)+Ca_bas);
                
                QMatrix = MakeQMatrix(par, Ca_cur);
                
                ps = rand(1,2);
                a_vec = QMatrix(state_cur, :);
                a_vec(a_vec<0) = 0;
                a_0 = sum(a_vec(:));

                tau = (1/a_0)*log(1/ps(1));
                
                if (tau > min_step) && t_cur<ramp_time
                    t_cur = t_cur + min_step;
                else


                    a_cum = cumsum(a_vec(:))/a_0;
                    react_init = find(ps(2)<=a_cum, 1, 'first');
                    ves_no = mod(react_init-1, nves_per_run)+1;
                    react = ceil(react_init/nves_per_run);
                    
%                     [ves_no_1, react_1] = ind2sub(size(a_vec), react_init);

                    t_cur = t_cur+tau;
                    state_before = state_cur;
                    state_cur(ves_no) = react;

                    if react == fus_state
                        no_fus = no_fus+1;
                        state_before_fuse_init(ves_no) = state_before(ves_no);
                    end
                end
            end 
            state_before_fuse_all(Ramp_ind, k, :) = state_before_fuse_init;
        end
    end
    
    state_before_fuse = NaN(length(Ramp_inds), nves_per_run*n_runs);
    for k = 1:length(Ramp_inds)
        cur_st = squeeze(state_before_fuse_all(Ramp_inds,:,:));
        state_before_fuse(k,:) = cur_st(:);
    end
        
        save(['./Outputs/Figure_results/Figure3/cross_before_fusions_individualruns_fitslot' num2str(fitslot) '_Allost' num2str(Allost_IO) '_LINEARCALCIUM.mat'], 'state_before_fuse', 'Calciums')

end
