function call_Fig2figsup2()

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%This script calls simulations of release latencies and peak release rates
%for figure 2 - figure supplement 3 (varying each free parameter)


n_rep = 1000;
varRRP = 1;
varSyt = 0;
varSlot = 0;
smallRRP_IO = 0;
lambda = 2;
Lplus = 423;
excludeOutl = 0;
allost_IO = 1;

fitslot = 3;
simEPSCs = 0;

load('generic_functions_bestfit_slot3_fitchoice6_exclude0_Lplus423_lambda2_varyparams1_paramfact1.mat')


[delay_medians_all, delay_2_5q_all, delay_97_5q_all, rates_est_mean_all, rates_est_q2_5_all, rates_est_q97_5_all]  = deal(zeros(length(Calciums), length(param_inds), length(param_factors)));


for k = 1:length(param_inds)
    for l = 1:length(param_factors)
        param_no = k;
        param_fac = param_factors(l);
        
        
        [delays, delay_medians, delay_2_5q, delay_97_5q, Calciums_delay, par] = simulate_delays(n_rep, varRRP, varSyt, varSlot, smallRRP_IO, fitslot, excludeOutl, Lplus, lambda, allost_IO, param_no, param_fac, nsyts, fitslot, simEPSCs);
        [peak_rates, rates_est_mean, rates_est_q2_5, rates_est_q97_5, Calciums_rates, par] = simulate_peak_release_rate(n_rep, varRRP, varSyt, varSlot, smallRRP_IO, fitslot, excludeOutl, Lplus, lambda, allost_IO, param_no, param_fac, nsyts, fitslot);
    
        delay_medians_all(:,k,l) = delay_medians;
        delay_2_5q_all(:,k,l) = delay_2_5q;
        delay_97_5q_all(:,k,l) = delay_97_5q;
        rates_est_mean_all(:,k,l) = rates_est_mean;
        rates_est_q2_5_all(:,k,l) = rates_est_q2_5;
        rates_est_q97_5_all(:,k,l) = rates_est_q97_5;
        foldername = './Outputs/Figure_results/Figure3/Figsup2/';
        filename = ['Results_fitslot' num2str(fitslot) '_excludeoutl' num2str(excludeOutl) '_Lplus' num2str(Lplus) '_lambda' num2str(lambda) '_varRRP' num2str(varRRP) '_varSyt' num2str(varSyt) '_varSlot' num2str(varSlot) '_smallRRP' num2str(smallRRP_IO) '_VARYPARAMS.mat'];

        save([foldername filename])
    end
end






