% function [] = plot_quick(delay_medians, delay_2_5q, delay_97_5q, rates_est_mean, rates_est_q2_5, rates_est_q97_5, delay_medians_orig, delay_2_5q_orig, delay_97_5q_orig, rates_est_mean_orig, rates_est_q2_5_orig, rates_est_q97_5_orig, Calciums_rates, Calciums_delay, par, par_orig)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This scripts plots figure 2 - figure supplement 3


delay_inds = 11:length(Calciums_rates);

plot_choice = 0;
% fitslot = 3;

plot_delays = 1;
plot_rates = 1;

load('ExpData_PIP2.mat')

color_vec = {'k', 'b', 'r', 'g', 'm', 'y', 'c', [0.5 0.5 0.5], [0.6350, 0.0780, 0.1840], [0, 0.75, 0.75]};

if plot_rates
    
for k = 1:length(param_inds)

    figure%('Position', [10 10 0.63076923076*560 0.63076923076*420])


    loglog(ExpRateCa, ExpRate, 'ks', 'DisplayName', 'Experiment')
    hold on


    for l = 1:length(param_factors)
            Ca_here = Calciums_rates;
            loglog(Ca_here, squeeze(rates_est_mean_all(:,k,l))*1e-3, '-', 'LineWidth', 2, 'Color', color_vec{l}, 'DisplayName', ['Factor ' num2str(param_factors(l))]) %['Cost type: ' num2str(cost_type)])
    end

    title(['Vary param. no.: ' num2str(k)])
    ylabel('Max fusion rate [ves/ms]')
    xlabel('Calcium conc. (uncage) [\mu M]')

    ylim([1e-4, 1e4])


    set(gca, 'FontSize', 12, 'TickDir', 'out')
% legend show
% legend('Location', 'northwest')
% title(['Maximal fusion rates, SLOTS = ' num2str(fitslot)])

end
end

%%%DELAY

if plot_delays

for k = 1:length(param_inds)
        
    hold off

    figure
    load('ExpData_PIP2.mat')
    loglog(ExpDelayCa, ExpDelay*1e3, 'ks', 'DisplayName', 'Experiment')
    hold on


    for l = 1:length(param_factors)
        Ca_used = Calciums_rates(delay_inds);
        loglog(Ca_used, (delay_medians_all(delay_inds,k,l)+par(12))*1e3, '-', 'LineWidth', 2, 'Color', color_vec{l}, 'DisplayName', ['Factor ' num2str(param_factors(l))]) 
    end

    title(['Vary param. no.: ' num2str(k)])
    ylabel('Release latency [ms]')
    xlabel('Calcium conc. (uncage) [\mu M]')

    ylim([0.1 100])
    xlim([1 100])

    set(gca, 'FontSize', 12, 'TickDir', 'out')
end
end