%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script plots the max slope of peak release rates against number of slots 
%%%%(Figure 2 panel C)


% Calciums = [0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1,1.25,1.5,1.75,2,2.5,3,3.5,4,5,6,7,8,9,10];


for fitslot = 1:6

%     if fitslot == 1
%         load(['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross1_parinitno51_KDcato2ions2.mat'], 'par')
%     else
%         load(['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross' num2str(fitslot) '_parinitno16_KDcato2ions2.mat'], 'par')
%     end
    
    load(['Results_fitslot' num2str(fitslot) '_excludeoutl0_Lplus423_lambda2_varRRP1_varSyt0_varSlot0_smallRRP0.mat'])

    if fitslot == 1
        rates_sample = zeros(6, length(Calciums_rates));
    end
    
    par(23) = 0;
    
%     [rates_est_crude, nves_draws, max_rate_time] = est_rates_crude_new_Ca(par, Calciums);
    
    rates_sample(fitslot, :) = rates_est_mean;
end

logrates = log(rates_sample);
logconc = log(Calciums_rates);

rate_slopes = zeros(6,length(Calciums_rates)-1);
for k = 1:6
    logr = logrates(k,:);
    rate_slopes(k,:) = diff(logr)./diff(logconc);
end

max_slopes = max(rate_slopes,[],2);

figure
plot(1:6, max_slopes, 'o-k')
set(gca,'TickDir', 'out')
xticks(1:6)
xlim([0.5 6.5])

