%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script plots the best fit parameters against number of slot 
%%%%(Figure 2 panel F shows the parameter f)

[f_vals, alphas, gammas, PIP2s, Lplus, ds] = deal(zeros(1,4));
M_vals = [1:6];

count = 1;
for fitslot = [1:6]   
    if fitslot == 1
        load(['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross1_parinitno51_KDcato2ions2.mat'])
    else
        load(['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross' num2str(fitslot) '_parinitno16_KDcato2ions2.mat'])
    end
    
    alphas(count) = par(1);
    gammas(count) = par(3);
    PIP2s(count) = par(4);
    Lplus(count) = par(6);
    f_vals(count) = par(7);
    ds(count) = par(12);
    count = count+1;
end


figure
plot(M_vals, alphas, 'o-b', 'LineWidth', 2)
xlim([0.5,6.5])
legend('Alpha')
set(gca, 'TickDir', 'out')
xticks(1:6)

figure
plot(M_vals, gammas, 'o-r', 'LineWidth', 2)
xlim([0.5,6.5])
legend('Gamma')
set(gca, 'TickDir', 'out')
xticks(1:6)

figure
plot(M_vals, PIP2s, 'o-g', 'LineWidth', 2)
% hold on
% plot(M_vals, M_vals.*PIP2s, 'o-c', 'LineWidth', 2)
xlim([0.5,6.5])
legend('PIP2')
set(gca, 'TickDir', 'out')
xticks(1:6)

figure
plot(M_vals, Lplus, 'o-', 'Color', [0.7 0.7 0.7], 'LineWidth', 2)
xlim([0.5,6.5])
legend('L+')
set(gca, 'TickDir', 'out')
xticks(1:6)


figure
plot(M_vals(2:end), f_vals(2:end), 'o-k', 'LineWidth', 2)
legend('f values')
xlim([0.5,6.5])
ylim([0 1500])
set(gca, 'TickDir', 'out')
xticks(1:6)

figure
plot(M_vals(2:end), f_vals(2:end), 'o-k', 'LineWidth', 2)
legend('f values')
xlim([0.5,6.5])
ylim([0 1500])
set(gca, 'TickDir', 'out')
xticks(1:6)

figure
plot(M_vals, log(f_vals), 'ok', 'LineWidth', 2)
legend('f values')
xlim([0.5,6.5])
ylim([4 16])
set(gca, 'TickDir', 'out')
xticks(1:6)



% figure
% plot(M_vals, ds, 'LineWidth', 2)
% legend('d values')