%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script plots the cost value against the choice of fixed f value
%%%%(Figure 2 panel H)


load('20210602_ResultsfittingdifferentfixedFvalues.mat')


lambda = 2;


Results = res;

% costs = Results(:,14);

% k_on_Ca_choice = unique(Results(:,1));
% k_on_PIP_choice = unique(Results(:,2));
% PIP_conc_choice = unique(Results(:,3));
% f_choice  = unique(Results(:,1));

f_vals = Results(:,1);

cost_mins = Results(:,14);
cost_colors = zeros(length(f_vals),3);

for ind = 1:length(f_vals)
    f = f_vals(ind);
    

    cost_min = cost_mins(ind);
    
    [rgb_vec, ~, ~, ~] = cost_colorcode(cost_min);
    cost_colors(ind,:) = rgb_vec;
    
end


figure

semilogx(f_vals, cost_mins, 'k-', 'LineWidth', 2)
hold on

for ind = 1:length(f_vals)
    color_vec = cost_colors(ind,:);
    semilogx(f_vals(ind), cost_mins(ind), 'o', 'MarkerEdgeColor', color_vec, 'MarkerFaceColor', color_vec)
end

set(gca, 'TickDir', 'out')

% [neg_inds] = find(cost_mins<0);
% 
% 
% figure
% 
% semilogx(f_choice(neg_inds(2:end)), cost_mins(neg_inds(2:end)), 'k-', 'LineWidth', 2)
% hold on
% 
% for ind = 2:length(neg_inds)
%     new_ind = neg_inds(ind);
%     color_vec = cost_colors(new_ind,:);
%     semilogx(f_choice(new_ind), cost_mins(new_ind), 'o', 'MarkerEdgeColor', color_vec, 'MarkerFaceColor', color_vec)
% end
