function Plot_SS_various_Mslot

fitslots = 6;%1:6; 

Ca_0 = 0.05;%[10 50 100];
if (length(fitslots) == 6) || (fitslots == 6)
    noCross_cats = 6; %0, 1, 2, 3, 4-6, >0 cross
elseif fitslots == 3
    noCross_cats = 5; %0, 1, 2, 3, >0 cross
end
    
nVes = 1;
nsyts = 15;

Steady_PIP2 = zeros(length(fitslots), noCross_cats);


for maxCross = fitslots
    
    if maxCross == 1
        parinitno = 51;
    else
        parinitno = 16;
    end
    
    
    resultsfilename = ['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross' num2str(maxCross) '_parinitno' num2str(parinitno) '_KDcato2ions2.mat'];

    load(resultsfilename, 'par');

    [zeroPIPind onePIPinds twoPIPinds threePIPinds four_to_sixPIPinds] = deal(0);
    
    for k = 0:(nsyts)
        zeroPIPinds(k+1) = indCal(nsyts, maxCross, 0, k, 0);
    end

    for k = 0:(nsyts-1)
        onePIPinds(k+1) = indCal(nsyts, maxCross, 0, k, 1);
    end

    for k = 0:(nsyts-2)
        twoPIPinds(k+1) = indCal(nsyts, maxCross, 0, k, 2);
    end

    for k = 0:(nsyts-3)
        threePIPinds(k+1) = indCal(nsyts, maxCross, 0, k, 3);
    end
    
    ind_temp = 0;
    
    if maxCross>3
        for m = 4:maxCross
            for k = 0:(nsyts-m)
                ind_temp = ind_temp + 1;
                four_to_sixPIPinds(ind_temp) = indCal(nsyts, maxCross, 0, k, m);
            end
        end
    else
        four_to_sixPIPinds = 0;
    end

    
    cross_inds = indCal(nsyts, maxCross, 1, 0, 0):indCal(nsyts, maxCross, maxCross, nsyts-maxCross, 0);
    
    
%     for Ca_ind = 1:3
%         Ca = Calciums(Ca_ind);
    
    
    [SS_eq] = steady_state_newmethod(par, nVes, Ca_0);

    SS_zeroPIP = sum(SS_eq(zeroPIPinds));
    SS_onePIP = sum(SS_eq(onePIPinds));

    if maxCross > 1
        SS_twoPIP = sum(SS_eq(twoPIPinds));
        if maxCross >2
            SS_threePIP = sum(SS_eq(threePIPinds));
            if maxCross >3
                SS_fourtosixPIP = sum(SS_eq(four_to_sixPIPinds));
            else
                SS_fourtosixPIP = 0;
            end
        else
            [SS_threePIP SS_fourtosixPIP] = deal(0);
        end
    else
        [SS_twoPIP SS_threePIP SS_fourtosixPIP] = deal(0);
    end
    
    steady_cross = sum(SS_eq(cross_inds));

    if (length(fitslots) == 6 ) || (fitslots == 6)
        Steady_PIP2(maxCross, :) = [SS_zeroPIP SS_onePIP SS_twoPIP SS_threePIP SS_fourtosixPIP steady_cross];
    elseif fitslots == 3
        Steady_PIP2(maxCross, :) = [SS_zeroPIP SS_onePIP SS_twoPIP SS_threePIP steady_cross];
    end
    
end


if (length(fitslots) == 6)
    hist_cats = {'0 PIP2 bound', '1 PIP2 bound', '2 PIP2 bound', '3 PIP2 bound', '4-6 PIP2 bound', '>0 crosslinks'};
    bar(Steady_PIP2')

elseif fitslots == 3
    hist_cats = {'0 PIP2 bound', '1 PIP2 bound', '2 PIP2 bound', '3 PIP2 bound', '>0 crosslinks'};
    bar(Steady_PIP2(3,:)')
    
elseif fitslots == 6
    hist_cats = {'0 PIP2 bound', '1 PIP2 bound', '2 PIP2 bound', '3 PIP2 bound', '4-6 PIP2 bound', '>0 crosslinks'};
    bar(Steady_PIP2(6,:)')
    
end



set(gca, 'XTickLabel', hist_cats)
if length(fitslots) == 6
    legend('Mslots=1', 'Mslots=2', 'Mslots=3', 'Mslots=4', 'Mslots=5', 'Mslots=6')
elseif fitslots == 6
    legend('Mslots=6')
elseif fitslots == 3
    legend('Mslots=3')
end
    
ylabel('Fraction of steady state SVs')




%%%%%%Release probability of SVs





Ca = 50;
Ca_0 = 0.05;
t_vec = 0:1e-6:1e-2;

if length(fitslots) == 1
    maxCross = fitslots;
else
    maxCross = 3;
end

if maxCross == 1
    parinitno = 51;
else
    parinitno = 16;
end

resultsfilename = ['./Outputs/Figure_results/Fit_results/combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross' num2str(maxCross) '_parinitno' num2str(parinitno) '_KDcato2ions2.mat'];

load(resultsfilename, 'par');

SS_eq = steady_state_newmethod(par, nVes, Ca_0);
SS_eq(end+1) = 0;

[QMatrix] = MakeQMatrix(par, Ca);


P_funcs = zeros(maxCross+1, length(t_vec));

for k = 0:(nsyts)
    zeroPIPinds(k+1) = indCal(nsyts, maxCross, 0, k, 0);
end

for k = 0:(nsyts-1)
    onePIPinds(k+1) = indCal(nsyts, maxCross, 0, k, 1);
end

for k = 0:(nsyts-2)
    twoPIPinds(k+1) = indCal(nsyts, maxCross, 0, k, 2);
end

for k = 0:(nsyts-3)
    threePIPinds(k+1) = indCal(nsyts, maxCross, 0, k, 3);
end

if maxCross == 6
    for k = 0:(nsyts-4)
        fourPIPinds(k+1) = indCal(nsyts, maxCross, 0, k, 4);
    end
    for k = 0:(nsyts-5)
        fivePIPinds(k+1) = indCal(nsyts, maxCross, 0, k, 5);
    end
    for k = 0:(nsyts-6)
        sixPIPinds(k+1) = indCal(nsyts, maxCross, 0, k, 6);
    end
end


for k = 1:(maxCross+1)
    SS_eq_used = zeros(1,length(SS_eq));
    
    if k == 1
        SS_eq_used(zeroPIPinds) = SS_eq(zeroPIPinds)/sum(SS_eq(zeroPIPinds));
    elseif k == 2
        SS_eq_used(onePIPinds) = SS_eq(onePIPinds)/sum(SS_eq(onePIPinds));
    elseif k == 3
        SS_eq_used(twoPIPinds) = SS_eq(twoPIPinds)/sum(SS_eq(twoPIPinds));
    elseif k == 4
        SS_eq_used(threePIPinds) = SS_eq(threePIPinds)/sum(SS_eq(threePIPinds));
    elseif k == 5
        SS_eq_used(fourPIPinds) = SS_eq(fourPIPinds)/sum(SS_eq(fourPIPinds));
    elseif k == 6
        SS_eq_used(fivePIPinds) = SS_eq(fivePIPinds)/sum(SS_eq(fivePIPinds));
    elseif k == 7
        SS_eq_used(sixPIPinds) = SS_eq(sixPIPinds)/sum(SS_eq(sixPIPinds));
    end
    
    
    
    [fused_over_time] = P_function(QMatrix, SS_eq_used, t_vec);
    
    P_funcs(k,:) = fused_over_time;
    
    
end

total_ves_used = 0;
for k = 1:(maxCross+1)
    SS_eq_used = zeros(1,length(SS_eq));
    
    if k == 1
        SS_eq_used(zeroPIPinds) = SS_eq(zeroPIPinds)*4000;
    elseif k == 2
        SS_eq_used(onePIPinds) = SS_eq(onePIPinds)*4000;
    elseif k == 3
        SS_eq_used(twoPIPinds) = SS_eq(twoPIPinds)*4000;
    elseif k == 4
        SS_eq_used(threePIPinds) = SS_eq(threePIPinds)*4000;
    elseif k == 5
        SS_eq_used(fourPIPinds) = SS_eq(fourPIPinds)*4000;
    elseif k == 6
        SS_eq_used(fivePIPinds) = SS_eq(fivePIPinds)*4000;
    elseif k == 7
        SS_eq_used(sixPIPinds) = SS_eq(sixPIPinds)*4000;
    end
    
    total_ves_used = total_ves_used + SS_eq_used;
    [fused_over_time] = P_function(QMatrix, SS_eq_used, t_vec);
    
    noFus_from_SS(k,:) = fused_over_time;
    
    
end



disp('Number of ves fused in total:')
sum(noFus_from_SS(:,end))





figure
hold on
for k = 1:(maxCross+1)
    plot(t_vec*1e3, noFus_from_SS(k,:))
end

xlabel('Time [ms]')
ylabel('No. of fusions')
ylim([0 2000])
legend('0 PIP2 in steady state', '1 PIP2 in steady state', '2 PIP2 in steady state', '3 PIP2 in steady state')
title(['No. of fusions after PIP binding, ' num2str(Ca) ' M calcium step function'])



figure
hold on
for k = 1:(maxCross+1)
    plot(t_vec*1e3, noFus_from_SS(k,:))
end

xlabel('Time [ms]')
ylabel('No. of fusions')
xlim([0 0.1])
ylim([0 20])
legend('0 PIP2 in steady state', '1 PIP2 in steady state', '2 PIP2 in steady state', '3 PIP2 in steady state')
title(['No. of fusions after PIP binding, ' num2str(Ca) ' M calcium step function, zoomed'])




figure
hold on
for k = 1:(maxCross+1)
    plot(t_vec*1e3, P_funcs(k,:))
end

xlabel('Time [ms]')
ylabel('Release probability')
ylim([0 1])
legend('0 PIP2 in steady state', '1 PIP2 in steady state', '2 PIP2 in steady state', '3 PIP2 in steady state')
title(['Release probability, ' num2str(Ca) ' M calcium step function'])





