function [EPSCs, fusetimes, t_vec, nves_draws] = Fig4_simEPSC(Calcium, n_draw, Allost_IO)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%This script simulates EPSCs with constant calcium (step) and fixed RRP 
%%%%size of 4000 SVs

%INPUTS
%Calcium - Calcium concentration used (step function)
%n_draw - number of EPSCs simulated
%Allost_IO - Whether to use best fit parameters from fitting with or 
% without allostericity (0 or 1)

%OUTPUTS
%EPSCs - Simulated EPSCs
%fusetimes - Simulated fusion times
%t_vec - time vector (time points corresponding to the EPSCs).
%nves_draws - number of SVs in each EPSC simulation


if Allost_IO
    load('generic_functions_bestfit_slot3_fitchoice6_exclude0_Lplus423_lambda2.mat')
else
    load('generic_functions_bestfit_slot3_fitchoice6_exclude0_Lplus423_lambda2_A1_nofit.mat')
end
    
    
Ca_0 = par(10);

timestep = 0.02e-3;

% nves_mean = par(11);
% nves_sd = par(23);
fit_choice = par(15);
t_max = 0.1;

if fit_choice>=100
    SS_eq_proto = steady_state_LOU(par, 1, Ca_0);
    SS_eq_proto(end+1) = 0; %Fused state
else
    SS_eq_proto = steady_state_newmethod(par, 1, Ca_0);
    SS_eq_proto(end+1) = 0; %Fused state
end

if Calcium >= Ca_0
    SS_eq = SS_eq_proto;
elseif Calcium < Ca_0

    if par(15) < 100
        SS_eq = steady_state_newmethod(par, 1, Calcium);
        SS_eq(end+1) = 0;
    else
        SS_eq = steady_state_LOU(par, 1, Calcium);
        SS_eq(end+1) = 0;
    end
end

% [delay_mean] = delay_integral(QMatrix)
% delays(k) = delay_mean;

% k_gamma = (nves_mean^2)/(nves_sd^2);
% thet_gamma = (nves_sd^2)/nves_mean;

nves_draws = ones(length(Calcium), n_draw)*4000;

nves_max = max(nves_draws(:));

p_draws = NaN(n_draw,nves_max);

for k = 1:n_draw
    p_draws(k,1:nves_draws(k)) = rand(1,nves_draws(k));
end
    
    %     beta_vals = betainv(p_draws, 5, nves+1-5);

p_vals = sort(p_draws, 2);


[mEPSC, t_mEPSC, ~] = calc_mEPSC(timestep, par);

t_vec = 0:timestep:t_max;
[EPSCs, fuse_vec] = deal(zeros(n_draw, length(t_vec)));

Ca_ind = find(Calciums==Calcium);

t_vec_fus = tvec_fus_cells{Ca_ind, 15, 3};
P_function = P_cells{Ca_ind, 15, 3};

fusetimes = NaN(size(p_vals));

[P_uniq, uniq_inds] = unique(P_function);
t_uniq = t_vec_fus(uniq_inds);

t_max = t_uniq(end);

for k = 1:n_draw
    k
    
    fusetimes(k,:) = interp1(P_uniq, t_uniq, p_vals(k,:));
    fuse_inds = ceil(fusetimes/timestep)+1;
    
    noNaN_inds = ~isnan(fuse_inds(k,:));
    fuse_inds_used = fuse_inds(k,noNaN_inds);
    for m = 1:length(fuse_inds_used)
        fuse_ind = fuse_inds_used(m);
        fuse_vec(k,fuse_ind) = fuse_vec(k,fuse_ind)+1;
    end
    
    EPSC = conv(fuse_vec(k,:), mEPSC); 
    EPSCs(k,:) = EPSC(1:length(t_vec));

end


t_shift = 1;


save(['./Outputs/Figure_results/Figure4/EPSCs_Allost_IO' num2str(Allost_IO) '_Calcium' num2str(Calcium) 'RRPfixed4000.mat'], 'nves_draws', 'Allost_IO', 'par', 'EPSCs', 't_vec', 't_uniq', 'P_uniq', 'fit_choice', 'Calcium', 'Ca_0', 'mEPSC', 'SS_eq')

color_vec = {'b', 'r', 'g', 'k', 'm', 'c', };
ind = 0
inds = [1 5 3]

figure
hold on
for k = inds
    ind = ind+1
    plot([0 t_shift], [0 0], 'LineWidth', 2, 'Color', color_vec{ind})
    plot(t_vec*1e3+t_shift, EPSCs(k,:), 'LineWidth', 2, 'Color', color_vec{ind})
end

if Allost_IO == 1
    xlim([0 10])
    xticks(0:2:10)
    plot([8 9], [-50 -50], 'k')
    plot([9 9], [-50 -40], 'k')
else
    xlim([0 100])
    ylim([-0.25 0])
    plot([70 90], [-0.1 -0.1], 'k')
    plot([90 90], [-0.1 -0.15], 'k')
end

xlabel('Time [ms]')
ylabel('Current [nA]')

set(gca, 'TickDir', 'out')
