function Plot_Fig4_paths
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script plots the individual SV paths (Figure 4 panel B+E)
%%%%with or without allostericity (set by Allost_IO).

Allost_IO = 0; %0 or 1 with or without allostericity

load(['./Outputs/Figure_results/Figure4/individualruns_Allost' num2str(Allost_IO) '.mat'])

ves_inds = 1:4;

figure
hold on

color_vec = {'k', 'b', 'r', 'g', 'm', 'y', 'c', [0.5 0.5 0.5], [0.6350, 0.0780, 0.1840], [0, 0.75, 0.75]};

for k = ves_inds
    end_ind = find(noCross_over_time(k,:)==1000, 1, 'first');
    nofus = 0;
    
    if isempty(end_ind)
        end_ind = find(~isnan(noCross_over_time(k,:)), 1, 'last');
        nofus = 1;
    end
    
    plot(tvec_plot(k,1:(end_ind-1))*1e3, noCross_over_time(k,1:(end_ind-1)), '-', 'Color', color_vec{k}, 'LineWidth', 2)
    
    if ~nofus
        plot(tvec_plot(k,end_ind)*1e3, noCross_over_time(k, end_ind-1), 'o', 'Color', color_vec{k})
    end
end

xlim([0 4])
ylim([0 3.5])
xticks(0:4)
yticks(0:3)