%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% This script plots the results for different number of nsyts with and
%%% without upregulation of PIP2. 
%Used for plotting Figure 5C, Figure 5 supplement 1 E and F


%% load file with AP-evoked responses

load('20210705_APEvoked_Nsyt.mat')


%% Get mean amplitudes

%nsyt
for i = [1:15]
  EPSCs_temp = EPSC_single_cell_nsyt{i};
    [As, am_i] = min(EPSCs_temp);
    Am = mean(As);
    [~, indx] = min(abs(As-Am));
    EPSC_example_nsyt(i, :) = EPSCs_temp(:,indx);
    Amplitudes_nsyt(i) = Am;
    std_nsyt(i) = std(Am);
end

%PiP up
for i = [1:15]
  EPSCs_temp = EPSC_single_cell_nsyt_pipup{i};
    [As, am_i] = min(EPSCs_temp);
    Am = mean(As);
    [~, indx] = min(abs(As-Am));
    EPSC_example_nsyt_pipup(i, :) = EPSCs_temp(:,indx);
    Amplitudes_nsyt_pipup(i) = Am;
    std_nsyt_pipup(i) = std(Am);
end

%% plot example traces
%Example traces 

% different nsyt
colorvec = [0.5 0 0; 0.8 0 0; 1 0 0; 1 0.3 0.3; 1 0.5 0.5; 0.8 0.5 0.5;...
    0.5 0.5 0.5; 0.3 0.3 0.3; 0.1 0.1 0.1;0.1 0.5 0.1;0.1 0.6 0.1;0.1 0.8 0.1; ...
    0 0.8 0;0.3 0.8 0;0.5 0.8 0];

figure(); hold on
for nsyts = 1:15
    plot([1:length(EPSC_example_nsyt(1,:))]/50, EPSC_example_nsyt(nsyts,:), 'LineWidth', 2, 'Color', colorvec(nsyts,:)) 
end

xlim([0 6])
yyaxis right
plot(ca_signal(:,1)*1000, ca_signal(:,2), '-k', 'LineWidth', 2)
ylim([-200, 60])
yyaxis left
ylim([-12, 4])

plot([3.5, 4.5], [-10, -10], '-k', 'LineWidth', 2)
plot([4.5, 4.5], [-10, -8], '-k', 'LineWidth', 2)
yyaxis right
plot([4.5, 4.5], [20, 40], '-k', 'LineWidth', 2)
set(gca,'XColor', 'none','YColor','none')
yyaxis left
set(gca,'XColor', 'none','YColor','none')

%%plot example traces PIP2 Up
nsyts = 3;
figure(); hold on
 plot([1:length(EPSC_example_nsyt(1,:))]/50, EPSC_example_nsyt(15,:), 'LineWidth', 2, 'Color', colorvec(15,:)) 
 plot([1:length(EPSC_example_nsyt(1,:))]/50, EPSC_example_nsyt(nsyts,:), 'LineWidth', 2, 'Color', colorvec(nsyts, :)) 
 plot([1:length(EPSC_example_nsyt(1,:))]/50, EPSC_example_nsyt_pipup(nsyts,:), 'LineWidth', 2, 'Color', 'b')
xlim([0 6])
 plot([3.5, 4.5], [-10, -10], '-k', 'LineWidth', 2)
plot([4.5, 4.5], [-10, -8], '-k', 'LineWidth', 2)
set(gca,'XColor', 'none','YColor','none')

legend('#syt: 15', '#syt: 3', '#syt: 3 PIP2 fitted')
legend('box', 'off')
legend('Location', 'southeast')

nsyts = 8;
figure(); hold on
 plot([1:length(EPSC_example_nsyt(1,:))]/50, EPSC_example_nsyt(15,:), 'LineWidth', 2, 'Color', colorvec(15,:)) 
 plot([1:length(EPSC_example_nsyt(1,:))]/50, EPSC_example_nsyt(nsyts,:), 'LineWidth', 2, 'Color', colorvec(nsyts, :)) 
 plot([1:length(EPSC_example_nsyt(1,:))]/50, EPSC_example_nsyt_pipup(nsyts,:), 'LineWidth', 2, 'Color', 'b')
xlim([0 6])
 plot([3.5, 4.5], [-10, -10], '-k', 'LineWidth', 2)
plot([4.5, 4.5], [-10, -8], '-k', 'LineWidth', 2)
set(gca,'XColor', 'none','YColor','none')
legend('#syt: 15', '#syt: 8', '#syt: 8 PIP2 fitted')
legend('box', 'off')
legend('Location', 'southeast')

%% plot overview results

%plot amplitudes nsyt
figure()
plot([1:15], Amplitudes_nsyt_pipup/Amplitudes_nsyt(end), 'b', 'LineWidth', 2)
hold on
scatter([1:15], Amplitudes_nsyt_pipup/Amplitudes_nsyt(end),60, 'b', 'filled', 'HandleVisibility', 'off')
plot([1:15], Amplitudes_nsyt/Amplitudes_nsyt(end), 'k', 'LineWidth', 2)
scatter([1:15], Amplitudes_nsyt/Amplitudes_nsyt(end), 60, colorvec, 'filled', 'HandleVisibility', 'off')
hold off

xlabel('# of synaptotagmins')
ylabel('Normalized amplitude')
legend('Fit PIP2', 'OR', 'box', 'off', 'Location', 'southeast')
ax = gca;
ax.XAxis.MinorTick = 'on';
ax.XAxis.MinorTickValues = 1:15;
xticks([5, 10, 15])
box off

