% function [] = plot_fig5
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script plots the release latencies and delays with different expression levels 
%%%% of syt (Figure 5A)


Allost_IO = 1
% delay_ind_new = [32 36:37 39:85];


% Calciums_rates = Calciums_rates;
% varSlot = 0; varSyt = 0; varRRP = 1;

plot_choice = 0;
% fitslot = 3;

plot_delays = 1;
plot_rates = 1;


load('ExpData_PIP2.mat')
ind = 1;

color_vec = {'k', 'b', 'r', 'g', 'm', 'y', 'c', [0.5 0.5 0.5], [0.6350, 0.0780, 0.1840], [0, 0.75, 0.75]};



if plot_rates
    figure%('Position', [10 10 0.63076923076*560 0.63076923076*420])


    loglog(ExpRateCa, ExpRate, 'ks', 'DisplayName', 'Experiment')
    hold on

    not_fit_inds = 1:length(ExpRate);
    not_fit_inds(delay_ind) = [];
    % loglog(ExpRateCa(not_fit_inds), ExpRate(not_fit_inds), 'rx', 'DisplayName', 'Not fitted to')


    %    loglog(ExpRateCa, rates_est_crude_alex*1e-3, '-', 'LineWidth', 2, 'Color', color_vec{1}, 'DisplayName', 'Manuscript parameters') %['Cost type: ' num2str(cost_type)])

%     Ca_here = Calciums_rates;
    %     Ca_here = ExpRateCa
rates_est_means = zeros(15,length(Calciums_rates));
    for k = 1:15
        load(['Results_fitslot3_excludeoutl0_Lplus423_lambda2_varRRP1_varSyt0_varSlot0_smallRRP0_fig6_nsyts' num2str(k) '.mat'])


        loglog(Calciums_rates, rates_est_mean*1e-3, '-', 'LineWidth', 2, 'DisplayName', num2str(k)) %['Cost type: ' num2str(cost_type)])
    
    
        rates_est_means(k,:) = rates_est_mean*1e-3;
    end

        ylabel('Max fusion rate [ves/ms]')
        xlabel('Calcium conc. (uncage) [\mu M]')

        ylim([1e-4, 1e4])

        if ~Allost_IO
            ylim([1e-4, 1e6])
        end

        set(gca, 'FontSize', 12, 'TickDir', 'out')
        legend show
        % legend('Location', 'northwest')
        % title(['Maximal fusion rates, SLOTS = ' num2str(fitslot)])

    
end

%%%DELAY
hold off


if plot_delays


    figure%('Position', [10 10 0.63076923076*560 0.63076923076*420])

    load('ExpData_PIP2.mat')


    loglog(ExpDelayCa, ExpDelay*1e3, 'ks', 'DisplayName', 'Experiment')
    hold on


%     Ca_used = Calciums_rates(delay_inds);

    release_latencies_medians = zeros(15,length(Calciums_delay));
    for k = 1:15
        load(['Results_fitslot3_excludeoutl0_Lplus423_lambda2_varRRP1_varSyt0_varSlot0_smallRRP0_fig6_nsyts' num2str(k) '.mat'])
        delay_inds = 11:length(Calciums_rates);

        loglog(Calciums_delay, (delay_medians(delay_inds)+par(12))*1e3, '-', 'LineWidth', 2, 'DisplayName', num2str(k)) 
        release_latencies_medians(k,:) = (delay_medians(delay_inds)+par(12))*1e3;
    end



    ylabel('Release latency [ms]')
    xlabel('Calcium conc. (uncage) [\mu M]')

    ylim([0.1 10000])

    if ~Allost_IO
        ylim([0.1 562.3413])
    end

    xlim([1 100])

    % hold off
    legend show
    set(gca, 'FontSize', 12, 'TickDir', 'out')
    % title(['Delays, SLOTS = ' num2str(fitslot)])
end