%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% This script plots simualted APevoked responses for different mutants
%%% setttings
% Used for plotting figure 5

%% Load file with the AP-evoked responses

load('20210524_AP_evokedEPSCs_differentlevelsofMutant_aoff2')

%% Compute mean amplitudes and select 'average' trace
%average trace is trace with amplitude closest to mean amplitude

%Homozygous Ca-binding mutant
for i = [1:15]
    EPSCs_temp = EPSC_single_cell_coffhomo{i};
    [As, am_i] = min(EPSCs_temp);
    Am = mean(As);
    [~, indx] = min(abs(As-Am));
    EPSC_example_coffhomo(i, :) = EPSCs_temp(:,indx);
    Amplitudes_coffhomo(i) = Am;
    std_coffhomo(i) = std(Am);
end
%homozygous No Ca-binding A-on mutant
for i = [1:15]
    EPSCs_temp = EPSC_single_cell_conhomo{i};
    [As, am_i] = min(EPSCs_temp);
    Am = mean(As);
    [~, indx] = min(abs(As-Am));
    EPSC_example_conhomo(i, :) = EPSCs_temp(:,indx);
    Amplitudes_conhomo(i) = Am;
    std_conhomo(i) = std(Am);
end

%nsyt
for i = [1:15]
  EPSCs_temp = EPSC_single_cell_nsyt{i};
    [As, am_i] = min(EPSCs_temp);
    Am = mean(As);
    [~, indx] = min(abs(As-Am));
    EPSC_example_nsyt(i, :) = EPSCs_temp(:,indx);
    Amplitudes_nsyt(i) = Am;
    std_nsyt(i) = std(Am);
end
%homo No Ca binding A-off mutant
for i = [15]
  EPSCs_temp = EPSC_single_cell_coff2homo{i};
    [As, am_i] = min(EPSCs_temp);
    Am = mean(As);
    [~, indx] = min(abs(As-Am));
    EPSC_example_coff2homo(i, :) = EPSCs_temp(:,indx);
    Amplitudes_coff2homo(i) = Am;
    std_coff2homo(i) = std(Am);
end

%heterozygous expression
%Ca-binding mutant mutant 
for i = [1:14]
    EPSCs_temp = EPSC_single_cell_coffhet{i};
    [As, am_i] = min(EPSCs_temp);
    Am = mean(As);
    [~, indx] = min(abs(As-Am));
    EPSC_example_coffhet(i, :) = EPSCs_temp(:,indx);
    Amplitudes_coffhet(i) = Am;
    std_coffhet(i) = std(Am);
end

%No Ca binding A-on mutant (Het) 
for i = [1:14]
    EPSCs_temp = EPSC_single_cell_conhet{i};
    [As, am_i] = min(EPSCs_temp);
    Am = mean(As);
    [~, indx] = min(abs(As-Am));
    EPSC_example_conhet(i, :) = EPSCs_temp(:,indx);
    Amplitudes_conhet(i) = Am;
    std_conhet(i) = std(Am);
end

%No Ca binding A-off mutant (het)
for i = [7]
    EPSCs_temp = EPSC_single_cell_coff2het{i};
    [As, am_i] = min(EPSCs_temp);
    Am = mean(As);
    [~, indx] = min(abs(As-Am));
    EPSC_example_coff2het(i, :) = EPSCs_temp(:,indx);
    Amplitudes_coff2het(i) = Am;
    std_coff2het(i) = std(Am);
end

%overexpression  Ca binding mutant
for i = [1:5]
    EPSCs_temp = EPSC_single_cell_coffover{i};
    [As, am_i] = min(EPSCs_temp);
    Am = mean(As);
    [~, indx] = min(abs(As-Am));
    EPSC_example_coffover(i, :) = EPSCs_temp(:,indx);
    Amplitudes_coffover(i) = Am;
    std_coffover(i) = std(Am);
end
%over No Ca binding A-on mutant
for i = [1:5]
    EPSCs_temp = EPSC_single_cell_conover{i};
    [As, am_i] = min(EPSCs_temp);
    Am = mean(As);
    [~, indx] = min(abs(As-Am));
    EPSC_example_conover(i, :) = EPSCs_temp(:,indx);
    Amplitudes_conover(i) = Am;
    std_conover(i) = std(Am);
end

%over nsyt
for i = [1:5]
  EPSCs_temp = EPSC_single_cell_nsyt_over{i};
    [As, am_i] = min(EPSCs_temp);
    Am = mean(As);
    [~, indx] = min(abs(As-Am));
    EPSC_example_nsyt_over(i, :) = EPSCs_temp(:,indx);
    Amplitudes_nsyt_over(i) = Am;
    std_nsyt_over(i) = std(Am);
end
%over No Ca binding A-off 
for i = [5]
  EPSCs_temp = EPSC_single_cell_coff2over{i};
    [As, am_i] = min(EPSCs_temp);
    Am = mean(As);
    [~, indx] = min(abs(As-Am));
    EPSC_example_coff2over(i, :) = EPSCs_temp(:,indx);
    Amplitudes_coff2over(i) = Am;
    std_nsyt_coff2over(i) = std(Am);
end

%heterozygous expression rescue
%Ca binding mutant 
for i = [7]
    EPSCs_temp = EPSC_single_cell_coffhet_rescue{i};
    [As, am_i] = min(EPSCs_temp);
    Am = mean(As);
    [~, indx] = min(abs(As-Am));
    EPSC_example_coffhet_rescue(i, :) = EPSCs_temp(:,indx);
    Amplitudes_coffhet_rescue(i) = Am;
    std_coffhet_rescue(i) = std(Am);
end
%No Ca binding A-on mutant  
for i = [7]
    EPSCs_temp = EPSC_single_cell_conhet_rescue{i};
    [As, am_i] = min(EPSCs_temp);
    Am = mean(As);
    [~, indx] = min(abs(As-Am));
    EPSC_example_conhet_rescue(i, :) = EPSCs_temp(:,indx);
    Amplitudes_conhet_rescue(i) = Am;
    std_conhet_rescue(i) = std(Am);
end


%homozygous expression rescue
%Ca binding mutant
for i = [15]
    EPSCs_temp = EPSC_single_cell_coffhomo_rescue{i};
    [As, am_i] = min(EPSCs_temp);
    Am = mean(As);
    [~, indx] = min(abs(As-Am));
    EPSC_example_coffhomo_rescue(i, :) = EPSCs_temp(:,indx);
    Amplitudes_coffhomo_rescue(i) = Am;
    std_coffhomo_rescue(i) = std(Am);
end
%No Ca binding A-on mutant 
for i = [15]
    EPSCs_temp = EPSC_single_cell_conhomo_rescue{i};
    [As, am_i] = min(EPSCs_temp);
    Am = mean(As);
    [~, indx] = min(abs(As-Am));
    EPSC_example_conhomo_rescue(i, :) = EPSCs_temp(:,indx);
    Amplitudes_conhomo_rescue(i) = Am;
    std_conhomo_rescue(i) = std(Am);
end


%% plot examples homozygous expression

figure() %No Ca binding A-on mutant
plot([1:length(EPSC_example_conhomo(15,:))]/50, EPSC_example_conhomo(15,:), 'LineWidth', 2, 'Color', 'r') 
hold on; 
plot([1:length(EPSC_example_nsyt(15,:))]/50, EPSC_example_nsyt(15,:), 'LineWidth', 2, 'Color', 'k') 
plot([3.5, 4.5], [-10, -10], '-k', 'LineWidth', 2)
plot([4.5, 4.5], [-10, -5], '-k', 'LineWidth', 2)
xlim([0 6])
ylim([-14, 0])
legend('mutant', 'wt', 'Location', 'east', 'box', 'off')
set(gca,'XColor', 'none','YColor','none')

figure() %Ca binding mutant mutant
plot([1:length(EPSC_example_coffhomo(15,:))]/50, EPSC_example_coffhomo(15,:), 'LineWidth', 2, 'Color', 'b') 
hold on; 
plot([1:length(EPSC_example_nsyt(15,:))]/50, EPSC_example_nsyt(15,:), 'LineWidth', 2, 'Color', 'k') 
plot([3.5, 4.5], [-10, -10], '-k', 'LineWidth', 2)
plot([4.5, 4.5], [-10, -5], '-k', 'LineWidth', 2)
xlim([0 6])
ylim([-14, 0])
legend('mutant', 'wt', 'Location', 'east', 'box', 'off')
set(gca,'XColor', 'none','YColor','none')


%% plot examples heterozygous expression

figure() %No Ca binding A-on mutant
plot([1:length(EPSC_example_conhet(7,:))]/50, EPSC_example_conhet(7,:), 'LineWidth', 2, 'Color', 'r') 
hold on; 
plot([1:length(EPSC_example_nsyt(15,:))]/50, EPSC_example_nsyt(15,:), 'LineWidth', 2, 'Color', 'k') 
plot([3.5, 4.5], [-10, -10], '-k', 'LineWidth', 2)
plot([4.5, 4.5], [-10, -5], '-k', 'LineWidth', 2)
xlim([0 6])
ylim([-14, 0])
legend('mutant', 'wt', 'Location', 'east', 'box', 'off')
set(gca,'XColor', 'none','YColor','none')

% figure()
% plot([1:length(EPSC_example_conhet(7,:))]/50, EPSC_example_conhet(7,:), 'LineWidth', 2, 'Color', 'r') 
% hold on; 
% plot([1:length(EPSC_example_nsyt(15,:))]/50, EPSC_example_nsyt(15,:), 'LineWidth', 2, 'Color', 'k') 
% plot([3.5, 4.5], [-0.3, -0.3], '-k', 'LineWidth', 2)
% plot([4.5, 4.5], [-0.3, -0.05], '-k', 'LineWidth', 2)
% xlim([0 6])
% ylim([-1, 0])
% legend('mutant', 'wt', 'Location', 'east', 'box', 'off')
% set(gca,'XColor', 'none','YColor','none')

figure() %Ca binding mutant
plot([1:length(EPSC_example_coffhet(7,:))]/50, EPSC_example_coffhet(7,:), 'LineWidth', 2, 'Color', 'b') 
hold on; 
plot([1:length(EPSC_example_nsyt(15,:))]/50, EPSC_example_nsyt(15,:), 'LineWidth', 2, 'Color', 'k') 
plot([3.5, 4.5], [-10, -10], '-k', 'LineWidth', 2)
plot([4.5, 4.5], [-10, -5], '-k', 'LineWidth', 2)
xlim([0 6])
ylim([-14, 0])
legend('mutant', 'wt', 'Location', 'east', 'box', 'off')
set(gca,'XColor', 'none','YColor','none')


%% plot examples overexpression

figure() %No ca binding A-on
plot([1:length(EPSC_example_conover(5,:))]/50, EPSC_example_conover(5,:), 'LineWidth', 2, 'Color', 'r') 
hold on; 
plot([1:length(EPSC_example_nsyt_over(5,:))]/50, EPSC_example_nsyt(15,:), 'LineWidth', 2, 'Color', 'k') 
plot([3.5, 4.5], [-10, -10], '-k', 'LineWidth', 2)
plot([4.5, 4.5], [-10, -5], '-k', 'LineWidth', 2)
xlim([0 6])
ylim([-14, 0])
legend('mutant', 'wt', 'Location', 'east', 'box', 'off')
set(gca,'XColor', 'none','YColor','none')

figure() %Ca binding mutant
plot([1:length(EPSC_example_coffover(5,:))]/50, EPSC_example_coffover(5,:), 'LineWidth', 2, 'Color', 'b') 
hold on; 
plot([1:length(EPSC_example_nsyt_over(5,:))]/50, EPSC_example_nsyt(15,:), 'LineWidth', 2, 'Color', 'k') 
plot([3.5, 4.5], [-10, -10], '-k', 'LineWidth', 2)
plot([4.5, 4.5], [-10, -5], '-k', 'LineWidth', 2)
xlim([0 6])
ylim([-14, 0])
legend('mutant', 'wt', 'Location', 'east', 'box', 'off')
set(gca,'XColor', 'none','YColor','none')


%% Example plots rescue - Het


figure() %No Ca binding A-on
plot([1:length(EPSC_example_conhet(7,:))]/50, EPSC_example_conhet(7,:), 'LineWidth', 2, 'Color', 'r') 
hold on; 
plot([1:length(EPSC_example_conhet(7,:))]/50, EPSC_example_conhet_rescue(7,:),'--', 'LineWidth', 2, 'Color', 'r')
plot([1:length(EPSC_example_nsyt(15,:))]/50, EPSC_example_nsyt(15,:), 'LineWidth', 2, 'Color', 'k') 
plot([3.5, 4.5], [-10, -10], '-k', 'LineWidth', 2)
plot([4.5, 4.5], [-10, -5], '-k', 'LineWidth', 2)
xlim([0 6])
ylim([-14, 0])
legend('mutant', 'rescue', 'wt', 'Location', 'east', 'box', 'off')
set(gca,'XColor', 'none','YColor','none')

figure(); % Calcium binding mutant
plot([1:length(EPSC_example_coffhet(7,:))]/50, EPSC_example_coffhet(7,:), 'LineWidth', 2, 'Color', 'b') 
hold on; 
plot([1:length(EPSC_example_coffhet(7,:))]/50, EPSC_example_coffhet_rescue(7,:),'--', 'LineWidth', 2, 'Color', 'b') 
plot([1:length(EPSC_example_nsyt(15,:))]/50, EPSC_example_nsyt(15,:), 'LineWidth', 2, 'Color', 'k') 
plot([3.5, 4.5], [-10, -10], '-k', 'LineWidth', 2)
plot([4.5, 4.5], [-10, -5], '-k', 'LineWidth', 2)
xlim([0 6])
ylim([-14, 0])
legend('mutant', 'rescue', 'wt', 'Location', 'east', 'box', 'off')
set(gca,'XColor', 'none','YColor','none')


%% Example plots rescue - homo


figure() %No Ca binding A-on
plot([1:length(EPSC_example_conhomo(15,:))]/50, EPSC_example_conhomo(15,:), 'LineWidth', 2, 'Color', 'r') 
hold on; 
plot([1:length(EPSC_example_conhomo(15,:))]/50, EPSC_example_conhomo_rescue(15,:),'--', 'LineWidth', 2, 'Color', 'r')
plot([1:length(EPSC_example_nsyt(15,:))]/50, EPSC_example_nsyt(15,:), 'LineWidth', 2, 'Color', 'k') 
plot([3.5, 4.5], [-10, -10], '-k', 'LineWidth', 2)
plot([4.5, 4.5], [-10, -5], '-k', 'LineWidth', 2)
xlim([0 6])
ylim([-14, 0])
legend('mutant', 'rescue', 'wt', 'Location', 'east', 'box', 'off')
set(gca,'XColor', 'none','YColor','none')

figure(); % Calcium binding mutant
plot([1:length(EPSC_example_coffhomo(15,:))]/50, EPSC_example_coffhomo(15,:), 'LineWidth', 2, 'Color', 'b') 
hold on; 
plot([1:length(EPSC_example_coffhomo(15,:))]/50, EPSC_example_coffhomo_rescue(15,:),'--', 'LineWidth', 2, 'Color', 'b') 
plot([1:length(EPSC_example_nsyt(15,:))]/50, EPSC_example_nsyt(15,:), 'LineWidth', 2, 'Color', 'k') 
plot([3.5, 4.5], [-10, -10], '-k', 'LineWidth', 2)
plot([4.5, 4.5], [-10, -5], '-k', 'LineWidth', 2)
xlim([0 6])
ylim([-14, 0])
legend('mutant', 'rescue', 'wt', 'Location', 'east', 'box', 'off')
set(gca,'XColor', 'none','YColor','none')

%% overview figure homozygous expression

figure()
plot([1:15], Amplitudes_coffhomo([1:15])*-1, '-ob', 'LineWidth', 2, 'Markerfacecolor', 'b')
hold on
plot([1:15], Amplitudes_conhomo([1:15])*-1, '-or', 'LineWidth', 2, 'Markerfacecolor', 'r')
plot([1:15], Amplitudes_nsyt([1:15])*-1, '-ok', 'LineWidth', 2, 'Markerfacecolor', 'k')
plot([0:15], ones(1,16)*Amplitudes_nsyt(15)*-1, '--k', 'LineWidth', 2)
xlabel('# syts')
ylim([-1 20])
ylabel('Amplitude (nA)')
set(gca,'TickDir','out');
box off
legend('Ca-binding m.', 'a-on m.', 'WT ref', 'WT', 'box', 'off')

%% overview figure het
figure()
plot([0:15],[Amplitudes_nsyt(15)*-1, Amplitudes_coffhet([1:14])*-1, Amplitudes_coffhomo(15)*-1], '-ob', 'LineWidth', 2, 'Markerfacecolor', 'b')
hold on
plot([0:15], [Amplitudes_nsyt(15)*-1, Amplitudes_conhet([1:14])*-1, Amplitudes_conhomo(15)*-1], '-or', 'LineWidth', 2, 'Markerfacecolor', 'r')
plot([0:15], ones(1,16)*Amplitudes_nsyt(15)*-1, '--k', 'LineWidth', 2)
%plot([0:14], Amplitudes_nsyt([15:-1:1])*-1, '-ok', 'LineWidth', 2, 'Markerfacecolor', 'k')
xlabel('# mutant syts')
ylim([-1 20])
ylabel('Amplitude (nA)')
set(gca,'TickDir','out');
box off
%legend('Ca-binding m.', 'a=1', 'a-on m.', 'WT', 'box', 'off')

%% overview figure over

figure()
plot([0:4,8], [Amplitudes_nsyt(15)*-1, Amplitudes_coffover*-1], '-ob', 'LineWidth', 2, 'Markerfacecolor', 'b')
hold on
plot([0:4,8], [Amplitudes_nsyt(15)*-1,Amplitudes_conover*-1], '-or', 'LineWidth', 2, 'Markerfacecolor', 'r')
plot([0:4,8], [Amplitudes_nsyt(15)*-1, Amplitudes_nsyt_over*-1], '-ok', 'LineWidth', 2, 'Markerfacecolor', 'k')
plot([0:8], ones(1,9)*Amplitudes_nsyt(15)*-1, '--k', 'LineWidth', 2)
xlabel('# additional syts')
ylim([-1 20])
ylabel('Amplitude (nA)')
set(gca,'TickDir','out');
box off


%% additional plots mutants rescue

%adjusted calcium signal
figure()
plot(ca_signal(:,1), ca_signal(:,2), 'LineWidth', 2, 'Color', 'k') 
hold on
plot(ca_signal(:,1), ca_signalAP4(:,2), '--', 'LineWidth', 2, 'Color', 'k')
plot([1e-3, 1.5e-3], [15, 15], '-k', 'LineWidth', 2)
plot([1.5e-3, 1.5e-3], [15, 35], '-k', 'LineWidth', 2)
xlim([0 2e-3])
set(gca,'XColor', 'none','YColor','none')

%effect of rescue heterozygous expression
figure()
X = categorical({'Ca-binding m.', 'a-on m.'});
X = reordercats(X,{'Ca-binding m.', 'a-on m.'});
Y = [ Amplitudes_coffhet_rescue(7)/Amplitudes_coffhet(7), Amplitudes_conhet_rescue(7)/Amplitudes_conhet(7)]; 
b=bar(X,Y);
b.FaceColor = 'flat';
b.CData(1,:) = [0 0 1];
b.CData(2,:) = [1 0 0];
ylim([0 2])
ylabel('normalized amplitude')
set(gca,'TickDir','out');
box off

%effect of rescue heterozygous overexpression
figure()
X = categorical({'Ca-binding m.', 'a-on m.'});
X = reordercats(X,{'Ca-binding m.', 'a-on m.'});
Y = [Amplitudes_coffhomo_rescue(15)/Amplitudes_coffhomo(15), Amplitudes_conhomo_rescue(15)/Amplitudes_conhomo(15)]; 
b=bar(X,Y);
b.FaceColor = 'flat';
b.CData(1,:) = [0 0 1];
b.CData(2,:) = [1 0 0];
ylim([0 2])
ylabel('normalized amplitude')
set(gca,'TickDir','out');
box off

%% supplementary figure - No Ca A-off mutant

figure() %homo
plot([1:length(EPSC_example_coff2homo(15,:))]/50, EPSC_example_coff2homo(15,:), 'LineWidth', 2, 'Color', [1, 0, 0.5]) 
hold on; 
plot([1:length(EPSC_example_nsyt_over(5,:))]/50, EPSC_example_nsyt(15,:), 'LineWidth', 2, 'Color', 'k') 
plot([3.5, 4.5], [-10, -10], '-k', 'LineWidth', 2)
plot([4.5, 4.5], [-10, -5], '-k', 'LineWidth', 2)
xlim([0 6])
ylim([-14, 0])
legend('mutant', 'wt', 'Location', 'east', 'box', 'off')
set(gca,'XColor', 'none','YColor','none')

figure() %het
plot([1:length(EPSC_example_coff2het(7,:))]/50, EPSC_example_coff2het(7,:), 'LineWidth', 2, 'Color', [1, 0, 0.5]) 
hold on; 
plot([1:length(EPSC_example_nsyt_over(5,:))]/50, EPSC_example_nsyt(15,:), 'LineWidth', 2, 'Color', 'k') 
plot([3.5, 4.5], [-10, -10], '-k', 'LineWidth', 2)
plot([4.5, 4.5], [-10, -5], '-k', 'LineWidth', 2)
xlim([0 6])
ylim([-14, 0])
legend('mutant', 'wt', 'Location', 'east', 'box', 'off')
set(gca,'XColor', 'none','YColor','none')

figure() %over
plot([1:length(EPSC_example_coff2over(5,:))]/50, EPSC_example_coff2over(5,:), 'LineWidth', 2, 'Color', [1, 0, 0.5]) 
hold on; 
plot([1:length(EPSC_example_nsyt_over(5,:))]/50, EPSC_example_nsyt(15,:), 'LineWidth', 2, 'Color', 'k') 
plot([3.5, 4.5], [-10, -10], '-k', 'LineWidth', 2)
plot([4.5, 4.5], [-10, -5], '-k', 'LineWidth', 2)
xlim([0 6])
ylim([-14, 0])
legend('mutant', 'wt', 'Location', 'east', 'box', 'off')
set(gca,'XColor', 'none','YColor','none')

%Overview figure
figure()
X = categorical({ 'homo', 'het', 'over'});
X = reordercats(X,{ 'homo','het', 'over'});
Y = [Amplitudes_coff2homo(15), Amplitudes_coff2het(7), Amplitudes_coff2over(5); Amplitudes_conhomo(15), Amplitudes_conhet(7), Amplitudes_conover(5)];
b=bar(X,Y*-1, 'FaceColor','flat');
b(1).CData = [1, 0, 0.5];
b(2).CData = [1, 0, 0];
ylim([0 5])
ylabel('Amplitude (nA)')
legend('A-off', 'A-on', 'Location', 'northwest', 'box', 'off')
set(gca,'TickDir','out');
box off

