%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% This script plots simualted Paired pulses for variable PIP@
% Used for plotting figure 7
%%
load('20220214_WT_pairedpulsestimulus.mat')

amplitude_1_WT = min(EPSC_single(1:400, :));
amplitude_2_WT = min(EPSC_single(400:800, :));

[diff, index] = sort(abs(amplitude_1_WT - mean(amplitude_1_WT))+abs(amplitude_2_WT - mean(amplitude_2_WT))+abs(amplitude_1_WT./amplitude_2_WT - mean(amplitude_1_WT./amplitude_2_WT))*10);
for i =1:5
    figure()
    plot([1:length(EPSC)]/50, EPSC_single(:, index(i)))
    xlim([0, 20])
end

EPSC_wt = EPSC_single(:,index(5)); % select example trace
%%
load('20220321_WT_pairedpulsestimulus_variablePIP.mat')

amplitude_1_WT_varPIP = min(EPSC_single(1:400, :));
amplitude_2_WT_varPIP = min(EPSC_single(400:800, :));

[diff, index] = sort(abs(amplitude_1_WT_varPIP - mean(amplitude_1_WT_varPIP))+abs(amplitude_2_WT_varPIP - mean(amplitude_2_WT_varPIP))+abs(amplitude_1_WT_varPIP./amplitude_2_WT_varPIP - mean(amplitude_1_WT_varPIP./amplitude_2_WT_varPIP))*10);
for i =1:5
    figure()
    plot([1:length(EPSC)]/50, EPSC_single(:, index(i)))
    xlim([0, 20])
end

EPSC_wt_varPIP = EPSC_single(:,index(1)); % select example trace

%% Bar Plot Amplitude of first pulse
n = size(EPSC_single,2);
figure()
h= bar([mean(amplitude_1_WT)*-1, mean(amplitude_1_WT_varPIP)*-1]');
hold on

errorbar(h(1).XEndPoints, [mean(amplitude_1_WT)*-1, mean(amplitude_1_WT_varPIP)*-1]', [std(amplitude_1_WT)/sqrt(n), std(amplitude_1_WT_varPIP)/sqrt(n)]', 'LineStyle','none','Color','k','LineWidth',2)
xticklabels(["WT" "Wt variable PIP"])
ylabel('Amplitude (nA)')
box off
set(gca,'TickDir','out');

%% Bar Plot PPR
figure()
h= bar([mean(amplitude_2_WT./amplitude_1_WT), mean(amplitude_2_WT_varPIP./amplitude_1_WT_varPIP)]');
hold on

errorbar(h(1).XEndPoints, [mean(amplitude_2_WT./amplitude_1_WT), mean(amplitude_2_WT_varPIP./amplitude_1_WT_varPIP)]', [std(amplitude_2_WT./amplitude_1_WT)/sqrt(n), std(amplitude_2_WT_varPIP./amplitude_1_WT_varPIP)/sqrt(n)]', 'LineStyle','none','Color','k','LineWidth',2)

xticklabels(["WT" "Wt variable PIP"])
ylabel('PPR')
box off
set(gca,'TickDir','out');


%% PLOT Calcium and PIP2 transients
% Calcium signal complete 2
 t = Ca_signal_pp_complete(:,1);
 t01 = 4e-4;
t02= 0.0104;
tau2 = 0.154;
 A = 0.4;
y1 =  exp(-((t-t01)./tau2))*A.*(t>=t01);
y2=  exp(-((t-t02)./tau2))*A.*(t>=t02);
Ca_signal_pp_complete2 = Ca_signal_pp_complete;
Ca_signal_pp_complete2(:,2) = Ca_signal_pp_complete2(:,2)+y1+y2; 

% PIP2 signal
tau = 1/450;
t0 = 0.011;
t = Ca_signal_pp_complete2(:,1); 
PIP = (par_int(4)/1-par_int(4)/3)./(1+exp(-(t-t0)./tau))+(par_int(4)/3);

figure()
yyaxis left
plot(t, Ca_signal_pp_complete2(:,2))
ylabel('[Ca] (uM)')
yyaxis right
plot(t, PIP)
yline(par_int(4), '--')
ylabel('[PIP2] (uM)')
xlabel('time (s)')
ylim([0 1.2])
xlim([0 0.02])
box off
set(gca,'TickDir','out');
%% Pplot example EPSCs

figure()
plot([1:length(EPSC)]/50, EPSC_wt, 'k', 'LineWidth', 2)
hold on
plot([1:length(EPSC)]/50, EPSC_wt_varPIP, 'g', 'LineWidth', 2)
plot([12, 14], [-12, -12], '-k', 'LineWidth', 2)
plot([14, 14], [-12, -10], '-k', 'LineWidth', 2)
xlim([0 20])
ylim([-12, 0])
legend('wt', 'varPIP', 'Location', 'east', 'box', 'off')
set(gca,'XColor', 'none','YColor','none')

