% function [] = plot_quick(delay_medians, delay_2_5q, delay_97_5q, rates_est_mean, rates_est_q2_5, rates_est_q97_5, delay_medians_orig, delay_2_5q_orig, delay_97_5q_orig, rates_est_mean_orig, rates_est_q2_5_orig, rates_est_q97_5_orig, Calciums_rates, Calciums_delay, par, par_orig)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%This script is used for quick plotting of the release latencies and peak release 
%%%% rates from preloaded data file. Settings were changed within the
%%%% script depending on the purpose.




delay_ind = [36:37 39:85];

Allost_IO = 1
% delay_ind_new = [32 36:37 39:85];

delay_inds = 11:length(Calciums_rates);

% Calciums_rates = Calciums_rates;
% varSlot = 0; varSyt = 0; varRRP = 1;

plot_choice = 0;
% fitslot = 3;

plot_delays = 1;
plot_rates = 1;

orig_data = 0;

if ~orig_data
    rate_col = 'r'
else
    rate_col = 'b'
end

rate_col = 'b';
del_col = rate_col


nopatch = 1;

% if ~plot_choice && ~fitslot
% load('exact_model_combifit15_nsyt15_leaveout1_lambda5_nves4000_CaCoop2_maxCross3_nvessd2000.mat', 'par')
% elseif fitslot == 1
%     load('combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross1_parinitno28.mat','par')
%     load('fig3_bestfit_slot1.mat');
% elseif fitslot == 2
%     load('combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross2_parinitno37.mat','par')
%     load('fig3_bestfit_slot2.mat');
% elseif fitslot == 3
%     load('combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross3_parinitno35.mat','par')
%     load('fig3_bestfit_slot3.mat');
% elseif fitslot == 4
%     load('combi_fitresult_nsyts15_fitchoice6_exclude0_leavelow0_lambda2_nvesmean4000_nvesSD2000_likelirates0_maxcross4_parinitno35.mat','par')
%     load('fig3_bestfit_slot4.mat');
% end

load('ExpData_PIP2.mat')
ind = 1;

color_vec = {'k', 'b', 'r', 'g', 'm', 'y', 'c', [0.5 0.5 0.5], [0.6350, 0.0780, 0.1840], [0, 0.75, 0.75]};

% if varSlot && ~varSyt && ~varRRP 
%     plotcol = 'b';
% elseif ~varSlot && varSyt && ~varRRP
%     plotcol = 'g';
% elseif ~varSlot && ~varSyt && varRRP
%     plotcol = [1,0.7,0];
% elseif ~varSlot && ~varSyt && ~varRRP
%     plotcol = [0,0,0];
% elseif ~varSlot && varSyt && varRRP
%     plotcol = [0.7,0.7,0.7];
% elseif varSlot && ~varSyt && varRRP
%     plotcol = [1,0,1];  
% elseif varSlot && varSyt && varRRP
% end

% display_names = {'Initial', 'lambda = 0.9', 'lambda = 1', 'lambda = 1-25', 'lambda = 1.5','lambda = 2', 'lambda = 3', 'lambda = 5', 'lambda = 10', 'lambda = 20'};

% t_max = 0.1;


if plot_rates
figure%('Position', [10 10 0.63076923076*560 0.63076923076*420])


loglog(ExpRateCa, ExpRate, 'ks', 'DisplayName', 'Experiment')
hold on

not_fit_inds = 1:length(ExpRate);
not_fit_inds(delay_ind) = [];
% loglog(ExpRateCa(not_fit_inds), ExpRate(not_fit_inds), 'rx', 'DisplayName', 'Not fitted to')


if plot_choice
    size_rates = size(rates_est_crude);

    if size_rates(2) > 1
        rates_est_sample = rates_est_crude;
        rates_est_mean = mean(rates_est_sample,2);
        rates_est_q2_5 = quantile(rates_est_sample, 0.025,2);
        rates_est_q97_5 = quantile(rates_est_sample, 0.975,2);
    end
end


if ~plot_choice
%    loglog(ExpRateCa, rates_est_crude_alex*1e-3, '-', 'LineWidth', 2, 'Color', color_vec{1}, 'DisplayName', 'Manuscript parameters') %['Cost type: ' num2str(cost_type)])
   
    Ca_here = Calciums_rates;
%     Ca_here = ExpRateCa
    loglog(Ca_here, rates_est_mean*1e-3, '-', 'LineWidth', 2, 'Color', rate_col, 'DisplayName', 'Rates (deterministic)') %['Cost type: ' num2str(cost_type)])

    if nopatch
        loglog(Ca_here, rates_est_q2_5*1e-3, '--', 'LineWidth', 2, 'Color', rate_col, 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])
        loglog(Ca_here, rates_est_q97_5*1e-3, '--', 'LineWidth', 2, 'Color', rate_col, 'DisplayName', 'Prediction interval') %['Cost type: ' num2str(cost_type)])
        loglog([Ca_here(1) Ca_here(1)], [(rates_est_q2_5(1))*1e-3 (rates_est_q97_5(1))*1e-3], '-', 'LineWidth', 0.5, 'Color', rate_col, 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])
        loglog([Ca_here(end) Ca_here(end)], [(rates_est_q2_5(end))*1e-3 (rates_est_q97_5(end))*1e-3], '-', 'LineWidth', 0.5, 'Color', rate_col, 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])
    else
        patch([Ca_here fliplr(Ca_here)], [rates_est_q2_5'*1e-3 fliplr(rates_est_q97_5'*1e-3)], rate_col, 'LineStyle', 'none')
        alpha(0.3)
    end
    
    if orig_data
        loglog(Ca_here, rates_est_mean_orig*1e-3, '-', 'LineWidth', 2, 'Color', 'r', 'DisplayName', 'Rates (original)') %['Cost type: ' num2str(cost_type)])
        if nopatch
            loglog(Ca_here, rates_est_q2_5_orig*1e-3, '--', 'LineWidth', 2, 'Color', 'r', 'DisplayName', 'Rates (original)') %['Cost type: ' num2str(cost_type)])
            loglog(Ca_here, rates_est_q97_5_orig*1e-3, '--', 'LineWidth', 2, 'Color', 'r', 'DisplayName', 'Rates (original)') %['Cost type: ' num2str(cost_type)])
            loglog([Ca_here(1) Ca_here(1)], [(rates_est_q2_5_orig(1))*1e-3 (rates_est_q97_5_orig(1))*1e-3], '--', 'LineWidth', 0.5, 'Color', 'r', 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])
            loglog([Ca_here(end) Ca_here(end)], [(rates_est_q97_5_orig(end))*1e-3 (rates_est_q2_5_orig(end))*1e-3], '--', 'LineWidth', 0.5, 'Color', 'r', 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])
        else        
            patch([Ca_here fliplr(Ca_here)], [rates_est_q2_5_orig'*1e-3 fliplr(rates_est_q97_5_orig'*1e-3)], 'r', 'LineStyle', 'none')
            alpha(0.3)
        end
    end
end


if plot_choice==1
    Ca_here = ExpRateCa;
%     Ca_here = ExpRateCa
    loglog(Ca_here, rates_est_mean*1e-3, '-', 'LineWidth', 2, 'Color', plotcol, 'DisplayName', 'Rates (deterministic)') %['Cost type: ' num2str(cost_type)])
    loglog(Ca_here, rates_est_q2_5*1e-3, '--', 'LineWidth', 2, 'Color', plotcol, 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])
    loglog(Ca_here, rates_est_q97_5*1e-3, '--', 'LineWidth', 2, 'Color', plotcol, 'DisplayName', 'Prediction interval') %['Cost type: ' num2str(cost_type)])
    loglog([Ca_here(1) Ca_here(1)], [(rates_est_q2_5(1))*1e-3 (rates_est_q97_5(1))*1e-3], '--', 'LineWidth', 0.5, 'Color', plotcol, 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])
    loglog([Ca_here(end) Ca_here(end)], [(rates_est_q2_5(end))*1e-3 (rates_est_q97_5(end))*1e-3], '--', 'LineWidth', 0.5, 'Color', plotcol, 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])


    if isempty('rates_est_mean_orig')
        loglog(Ca_here, rates_est_mean_orig*1e-3, '-', 'LineWidth', 2, 'Color', 'k', 'DisplayName', 'Rates (original)') %['Cost type: ' num2str(cost_type)])
        loglog(Ca_here, rates_est_q2_5_orig*1e-3, '--', 'LineWidth', 2, 'Color', 'k', 'DisplayName', 'Rates (original)') %['Cost type: ' num2str(cost_type)])
        loglog(Ca_here, rates_est_q97_5_orig*1e-3, '--', 'LineWidth', 2, 'Color', 'k', 'DisplayName', 'Rates (original)') %['Cost type: ' num2str(cost_type)])
        loglog([Ca_here(1) Ca_here(1)], [(rates_est_q2_5_orig(1))*1e-3 (rates_est_q97_5_orig(1))*1e-3], '--', 'LineWidth', 0.5, 'Color', 'k', 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])
        loglog([Ca_here(end) Ca_here(end)], [(rates_est_q2_5_orig(end))*1e-3 (rates_est_q97_5_orig(end))*1e-3], '--', 'LineWidth', 0.5, 'Color', 'k', 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])

    end
end


ylabel('Max fusion rate [ves/ms]')
xlabel('Calcium conc. (uncage) [\mu M]')

ylim([1e-4, 1e4])

if ~Allost_IO
    ylim([1e-4, 1e6])
end

set(gca, 'FontSize', 12, 'TickDir', 'out')
% legend show
% legend('Location', 'northwest')
% title(['Maximal fusion rates, SLOTS = ' num2str(fitslot)])

end

%%%DELAY

if plot_delays

hold off

figure%('Position', [10 10 0.63076923076*560 0.63076923076*420])

load('ExpData_PIP2.mat')




loglog(ExpDelayCa, ExpDelay*1e3, 'ks', 'DisplayName', 'Experiment')
hold on
% loglog(ExpDelayCa(2), ExpDelay(2)*1e3, 'rx', 'DisplayName', 'Not fitted to')

if ~plot_choice
%    if par(15) >= 100
%         ExpDelayCa_used = ExpRateCa([30 36:37 39:85]);
%         loglog(ExpRateCa(delay_ind), (delay_medians_stoch+par(12))*1e3, '-', 'LineWidth', 2, 'Color', color_vec{2}, 'DisplayName', 'Medians') 
%         loglog(ExpRateCa(delay_ind), (delays_naive+par(12))*1e3, '-', 'LineWidth', 2, 'Color', color_vec{3}, 'DisplayName', 'p = 5/n_{ves}') 
%    else
       Ca_used = Calciums_rates(delay_inds);
       
        loglog(Ca_used, (delay_medians(delay_inds)+par(12))*1e3, '-', 'LineWidth', 2, 'Color', del_col, 'DisplayName', 'Medians') 
        if nopatch
            loglog(Ca_used, (delay_2_5q(delay_inds)+par(12))*1e3, '--', 'LineWidth', 0.5, 'Color', del_col, 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])
            loglog(Ca_used, (delay_97_5q(delay_inds)+par(12))*1e3, '--', 'LineWidth', 0.5, 'Color', del_col, 'DisplayName', 'Prediciton interval') %['Cost type: ' num2str(cost_type)])        loglog(Ca_used, (delay_97_5s_stoch+par(12))*1e3, '--', 'LineWidth', 2, 'Color', color_vec{3}, 'DisplayName', 'Prediciton interval') %['Cost type: ' num2str(cost_type)])
            loglog([Ca_used(1) Ca_used(1)], [(delay_2_5q(delay_inds(1))+par(12))*1e3 (delay_97_5q(delay_inds(1))+par(12))*1e3], '-', 'LineWidth', 0.5, 'Color', del_col, 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])
            loglog([Ca_used(end) Ca_used(end)], [(delay_2_5q(end)+par(12))*1e3 (delay_97_5q(end)+par(12))*1e3], '-', 'LineWidth', 0.5, 'Color', del_col, 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])
        else
            patch([Ca_used fliplr(Ca_used)], [(delay_2_5q(delay_inds)+par(12))'*1e3 fliplr((delay_97_5q(delay_inds)+par(12))'*1e3)], 'b', 'LineStyle', 'none')
            alpha(0.3)
        end
        
        if orig_data == 1
            loglog(Ca_used, (delay_medians_orig(delay_inds)+par_orig(12))*1e3, '-', 'LineWidth', 2, 'Color', 'r', 'DisplayName', 'Medians') 
            if nopatch
                loglog(Ca_used, (delay_2_5q_orig(delay_inds)+par(12))*1e3, '--', 'LineWidth', 2, 'Color', 'k', 'DisplayName', 'Medians') 
                loglog(Ca_used, (delay_97_5q_orig(delay_inds)+par(12))*1e3, '--', 'LineWidth', 2, 'Color', 'k', 'DisplayName', 'Medians') 
                loglog([Ca_used(1) Ca_used(1)], [(delay_2_5q_orig(delay_inds(1))+par(12))*1e3 (delay_97_5q_orig(delay_inds(1))+par(12))*1e3], '--', 'LineWidth', 0.5, 'Color', 'k', 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])
                loglog([Ca_used(end) Ca_used(end)], [(delay_2_5q_orig(end)+par(12))*1e3 (delay_97_5q_orig(end)+par(12))*1e3], '--', 'LineWidth', 0.5, 'Color', 'k', 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])
            else            
                patch([Ca_used fliplr(Ca_used)], [(delay_2_5q_orig(delay_inds)+par_orig(12))'*1e3 fliplr((delay_97_5q_orig(delay_inds)+par_orig(12))'*1e3)], 'r', 'LineStyle', 'none')
                alpha(0.3)
            end
        elseif orig_data == 2
                        loglog(Ca_used, (delay_medians_orig+par_orig(12))*1e3, '-', 'LineWidth', 2, 'Color', 'r', 'DisplayName', 'Medians') 
            if nopatch
                loglog(Ca_used, (delay_2_5q_orig+par(12))*1e3, '--', 'LineWidth', 2, 'Color', 'k', 'DisplayName', 'Medians') 
                loglog(Ca_used, (delay_97_5q_orig+par(12))*1e3, '--', 'LineWidth', 2, 'Color', 'k', 'DisplayName', 'Medians') 
                loglog([Ca_used(1) Ca_used(1)], [(delay_2_5q_orig(delay_inds(1))+par(12))*1e3 (delay_97_5q_orig(delay_inds(1))+par(12))*1e3], '--', 'LineWidth', 0.5, 'Color', 'k', 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])
                loglog([Ca_used(end) Ca_used(end)], [(delay_2_5q_orig(end)+par(12))*1e3 (delay_97_5q_orig(end)+par(12))*1e3], '--', 'LineWidth', 0.5, 'Color', 'k', 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])
            else            
                patch([Ca_used fliplr(Ca_used)], [(delay_2_5q_orig+par_orig(12))'*1e3 fliplr((delay_97_5q_orig+par_orig(12))'*1e3)], 'r', 'LineStyle', 'none')
                alpha(0.3)
            end
        end
%    end
end

if plot_choice==1
       Ca_used = ExpDelayCa;
       
        loglog(Ca_used, (delay_medians_stoch+par(12))*1e3, '-', 'LineWidth', 2, 'Color', plotcol, 'DisplayName', 'Medians') 
        loglog(Ca_used, (delay_2_5s_stoch+par(12))*1e3, '--', 'LineWidth', 0.5, 'Color', plotcol, 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])
        loglog(Ca_used, (delay_97_5s_stoch+par(12))*1e3, '--', 'LineWidth', 0.5, 'Color', plotcol, 'DisplayName', 'Prediciton interval') %['Cost type: ' num2str(cost_type)])        loglog(Ca_used, (delay_97_5s_stoch+par(12))*1e3, '--', 'LineWidth', 2, 'Color', color_vec{3}, 'DisplayName', 'Prediciton interval') %['Cost type: ' num2str(cost_type)])
        loglog([Ca_used(1) Ca_used(1)], [(delay_2_5s_stoch(1)+par(12))*1e3 (delay_97_5s_stoch(1)+par(12))*1e3], '--', 'LineWidth', 0.5, 'Color', plotcol, 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])
        loglog([Ca_used(end) Ca_used(end)], [(delay_2_5s_stoch(end)+par(12))*1e3 (delay_97_5s_stoch(end)+par(12))*1e3], '--', 'LineWidth', 0.5, 'Color', plotcol, 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])

        patch([Ca_used fliplr(Ca_used)], [(delay_2_5s_stoch+par(12))'*1e3 fliplr((delay_97_5s_stoch+par(12))'*1e3)], plotcol, 'LineStyle', 'none')
        alpha(0.3)
        
        if isempty('delay_medians_orig')
            loglog(Ca_used, (delay_medians_orig(delay_inds)+par(12))*1e3, '-', 'LineWidth', 2, 'Color', 'k', 'DisplayName', 'Medians') 
            loglog(Ca_used, (delay_2_5q_orig(delay_inds)+par(12))*1e3, '--', 'LineWidth', 2, 'Color', 'k', 'DisplayName', 'Medians') 
            loglog(Ca_used, (delay_97_5q_orig(delay_inds)+par(12))*1e3, '--', 'LineWidth', 2, 'Color', 'k', 'DisplayName', 'Medians') 
            loglog([Ca_used(1) Ca_used(1)], [(delay_2_5q_orig(delay_inds(1))+par(12))*1e3 (delay_97_5q_orig(delay_inds(1))+par(12))*1e3], '--', 'LineWidth', 0.5, 'Color', 'k', 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])
            loglog([Ca_used(end) Ca_used(end)], [(delay_2_5q_orig(end)+par(12))*1e3 (delay_97_5q_orig(end)+par(12))*1e3], '--', 'LineWidth', 0.5, 'Color', 'k', 'HandleVisibility', 'off') %['Cost type: ' num2str(cost_type)])
        end
%    end
end


ylabel('Release latency [ms]')
xlabel('Calcium conc. (uncage) [\mu M]')

ylim([0.1 100])

if ~Allost_IO
    ylim([0.1 562.3413])
end

xlim([1 100])

% hold off
% legend show
set(gca, 'FontSize', 12, 'TickDir', 'out')
% title(['Delays, SLOTS = ' num2str(fitslot)])
end