(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1873010,      35542]
NotebookOptionsPosition[   1850599,      35144]
NotebookOutlinePosition[   1851109,      35163]
CellTagsIndexPosition[   1851066,      35160]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Derivation of the governing equations", "Section",
 CellChangeTimes->{{3.8055302149266057`*^9, 
  3.805530230412078*^9}},ExpressionUUID->"37aa7202-bb16-4cc8-aa39-\
f59867f2aa12"],

Cell[CellGroupData[{

Cell["Position of the fish in the global coordinate system (xf,yf)", \
"Subsection",
 CellChangeTimes->{{3.8055302740598965`*^9, 3.805530292855936*^9}, 
   3.8211983632853823`*^9, {3.821199567712057*^9, 3.8211995768588777`*^9}, {
   3.8212001831688585`*^9, 
   3.8212001841173115`*^9}},ExpressionUUID->"cbf9992f-03ba-4ba7-b216-\
8413168c5581"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rf", "=", 
   RowBox[{"{", 
    RowBox[{"xf", ",", "yf"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.805439455766244*^9, 3.805439475790583*^9}, {
  3.8148725247239122`*^9, 3.8148725251546474`*^9}, {3.814950804728565*^9, 
  3.8149508127190294`*^9}, {3.8149716991786213`*^9, 3.8149716997463207`*^9}, {
  3.821198384701939*^9, 3.8211983897353706`*^9}, {3.821200180500371*^9, 
  3.8212001892312765`*^9}},ExpressionUUID->"c792d707-b530-4a00-a94a-\
8d5866d9c441"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Unit vectors defining the swimming directions and its orthogonal vector, so \
that vperp = Cross[k, vuv]\
\>", "Subsection",
 CellChangeTimes->{{3.805530411019726*^9, 3.805530439668866*^9}, {
  3.805530477478544*^9, 
  3.805530536851179*^9}},ExpressionUUID->"9a8fc702-7ced-4be7-b0a8-\
77417e30e498"],

Cell[BoxData[
 RowBox[{
  RowBox[{"kuv", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.805530542002988*^9, 3.8055305502694654`*^9}, {
  3.805530762595978*^9, 
  3.805530762926701*^9}},ExpressionUUID->"43fc171d-94a1-459c-afa7-\
c42e2783bf1e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"vuv", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vuvn", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8054400257746425`*^9, 3.8054400670641336`*^9}, {
  3.805514221665697*^9, 3.8055142328647738`*^9}, {3.8055305523381014`*^9, 
  3.805530553417569*^9}, {3.814950757816456*^9, 3.814950758303155*^9}, {
  3.815210905740901*^9, 3.815210924050461*^9}, {3.8211983952745466`*^9, 
  3.8211984040476713`*^9}},ExpressionUUID->"5a286d42-48de-4cdc-924a-\
66e4237ff510"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vperp", "=", 
   RowBox[{"Delete", "[", 
    RowBox[{
     RowBox[{"Cross", "[", 
      RowBox[{"kuv", ",", 
       RowBox[{"Join", "[", 
        RowBox[{"vuv", ",", 
         RowBox[{"{", "0", "}"}]}], "]"}]}], "]"}], ",", "3"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8055305601797495`*^9, 3.805530625995818*^9}, {
  3.8055307658114586`*^9, 3.805530768552726*^9}, {3.814950765026327*^9, 
  3.8149507654470863`*^9}, {3.8211984070519953`*^9, 
  3.8211984089998803`*^9}},ExpressionUUID->"129bb9ab-299a-4a4d-ade7-\
6e0edea4720e"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Velocity potential generated by the fish at the generic position r = (x,y)\
\>", "Subsection",
 CellChangeTimes->{{3.805531086984949*^9, 3.805531121049476*^9}, 
   3.8157570361038165`*^9, {3.8211991696092176`*^9, 3.8211991857344136`*^9}, {
   3.821199550663995*^9, 3.821199563935116*^9}, {3.8212002243091574`*^9, 
   3.8212002256108923`*^9}, {3.8230098774190087`*^9, 
   3.8230098817469397`*^9}, {3.82793403005231*^9, 3.827934054815433*^9}, {
   3.8279341097264757`*^9, 3.827934124362281*^9}, {3.827934289583695*^9, 
   3.8279343089200287`*^9}},ExpressionUUID->"bf2bb5d2-9c1f-4c9d-a9d4-\
2a1146594861"],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.827934140007215*^9, 
  3.8279341400105543`*^9}},ExpressionUUID->"069967ea-7116-45e4-b704-\
2dc300c8a7e3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Phi]f", "=", 
   RowBox[{
    RowBox[{"-", "v"}], " ", 
    SuperscriptBox["r0", "2"], " ", 
    RowBox[{"(", 
     FractionBox[
      RowBox[{"Dot", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", "-", "rf"}], ")"}], ",", "vuv"}], "]"}], 
      SuperscriptBox[
       RowBox[{"Norm", "[", 
        RowBox[{"r", "-", "rf"}], "]"}], "2"]], ")"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8055313595063844`*^9, 3.8055313982272406`*^9}, 
   3.8124601254827147`*^9, 3.8157570411680484`*^9, {3.8211991951563735`*^9, 
   3.8211993077823114`*^9}, {3.821199655518627*^9, 3.821199695897733*^9}, {
   3.8212002286688156`*^9, 3.821200292788488*^9}, {3.827934148362327*^9, 
   3.827934205446808*^9}, {3.827934653053136*^9, 
   3.827934654045342*^9}},ExpressionUUID->"6c5bc90a-98b1-41a5-b2af-\
9d055bdd9a72"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Advective velocity field generated by the fish at the generic point (x,y) \
(note the verification of Eq. (25) in Appendix 1)\
\>", "Subsection",
 CellChangeTimes->{{3.805531086984949*^9, 3.805531121049476*^9}, 
   3.8157570361038165`*^9, {3.8211991696092176`*^9, 3.8211991857344136`*^9}, {
   3.821199550663995*^9, 3.821199563935116*^9}, {3.8212002243091574`*^9, 
   3.8212002256108923`*^9}, {3.8230098774190087`*^9, 
   3.8230098817469397`*^9}, {3.828089966091629*^9, 3.8280900844680157`*^9}, {
   3.845632055196958*^9, 
   3.8456320707295723`*^9}},ExpressionUUID->"bf2bb5d2-9c1f-4c9d-a9d4-\
2a1146594861"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ufcalc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FullSimplify", "[", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"\[Phi]f", ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Element", "[", 
          RowBox[{"x", ",", " ", "Reals"}], "]"}], ",", 
         RowBox[{"Element", "[", 
          RowBox[{"xf", ",", " ", "Reals"}], "]"}], ",", 
         RowBox[{"Element", "[", 
          RowBox[{"y", ",", " ", "Reals"}], "]"}], ",", 
         RowBox[{"Element", "[", 
          RowBox[{"yf", ",", " ", "Reals"}], "]"}]}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"\[Phi]f", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Element", "[", 
          RowBox[{"x", ",", " ", "Reals"}], "]"}], ",", 
         RowBox[{"Element", "[", 
          RowBox[{"xf", ",", " ", "Reals"}], "]"}], ",", 
         RowBox[{"Element", "[", 
          RowBox[{"y", ",", " ", "Reals"}], "]"}], ",", 
         RowBox[{"Element", "[", 
          RowBox[{"yf", ",", " ", "Reals"}], "]"}]}], "}"}]}], "]"}]}], 
    "}"}]}], ";"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.805439455766244*^9, 3.805439475790583*^9}, {
   3.8153407411089025`*^9, 3.81534074448001*^9}, {3.8153407881280265`*^9, 
   3.8153407928633165`*^9}, {3.8153408282630205`*^9, 
   3.8153408573893456`*^9}, {3.8153409690644655`*^9, 
   3.8153410219370785`*^9}, {3.8153410597894125`*^9, 3.815341138553333*^9}, {
   3.8153412261861596`*^9, 3.815341255118599*^9}, 3.815757688239406*^9, {
   3.8157738908721046`*^9, 3.815773915390069*^9}, {3.815774169348751*^9, 
   3.815774176088893*^9}, {3.81577450422408*^9, 3.815774506126973*^9}, {
   3.8158115542276354`*^9, 3.815811571932497*^9}, {3.8158398738904705`*^9, 
   3.8158399025430727`*^9}, {3.815839936262585*^9, 3.815839942139187*^9}, 
   3.815841426023661*^9, {3.816617120196209*^9, 3.816617126570574*^9}, {
   3.8279352372575207`*^9, 
   3.827935237975298*^9}},ExpressionUUID->"6c7a7ee9-950d-4099-8797-\
8a55507f4aa6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Uf", "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["r0", "2"], " ", "v", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", "xf", "+", "y", "-", "yf"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"x", "-", "xf", "-", "y", "+", "yf"}], ")"}], " ", 
          RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"x", "-", "xf"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"y", "-", "yf"}], ")"}], " ", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"xf", "-", "x"}], ")"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"yf", "-", "y"}], ")"}], "2"]}], ")"}], "2"]], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["r0", "2"], " ", "v", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"x", "-", "xf"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"y", "-", "yf"}], ")"}], " ", 
          RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", "xf", "+", "y", "-", "yf"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"x", "-", "xf", "-", "y", "+", "yf"}], ")"}], " ", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"xf", "-", "x"}], ")"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"yf", "-", "y"}], ")"}], "2"]}], ")"}], "2"]]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8055313595063844`*^9, 3.8055313982272406`*^9}, 
   3.8124601254827147`*^9, 3.8157570411680484`*^9, {3.8211991951563735`*^9, 
   3.8211993077823114`*^9}, {3.821199655518627*^9, 3.821199695897733*^9}, {
   3.8212002286688156`*^9, 
   3.821200292788488*^9}},ExpressionUUID->"6c5bc90a-98b1-41a5-b2af-\
9d055bdd9a72"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Uf", "-", "Ufcalc"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.827935242650424*^9, 
  3.827935248701159*^9}},ExpressionUUID->"ba53e9bc-1a2c-4e2c-ae28-\
9a9438bd1258"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.8279359988609943`*^9, 3.8280896734578667`*^9, 
  3.828089737392226*^9, 3.8280898828451433`*^9, 
  3.8280902902744246`*^9},ExpressionUUID->"24a10b40-9e4a-43c7-acfd-\
b40e6da6338b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Velocity potential generated by the interaction between the fish and the wall \
at the generic position r = (x,y) (note the verification of Eq. (26) in \
Appendix 1 for arbitrary parameter choice)\
\>", "Subsection",
 CellChangeTimes->{{3.805531086984949*^9, 3.805531121049476*^9}, 
   3.8157570361038165`*^9, {3.8211991696092176`*^9, 3.8211991857344136`*^9}, {
   3.821199550663995*^9, 3.821199563935116*^9}, {3.8212002243091574`*^9, 
   3.8212002256108923`*^9}, {3.8230098774190087`*^9, 
   3.8230098817469397`*^9}, {3.82793403005231*^9, 3.827934054815433*^9}, {
   3.8279341097264757`*^9, 3.827934124362281*^9}, {3.827934289583695*^9, 
   3.8279343089200287`*^9}, {3.827934343674775*^9, 3.827934352685927*^9}, {
   3.828090135927821*^9, 3.828090163559233*^9}, 3.828090293099326*^9, {
   3.8456321182838435`*^9, 
   3.8456321230904427`*^9}},ExpressionUUID->"bf2bb5d2-9c1f-4c9d-a9d4-\
2a1146594861"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rdnp", "=", 
   RowBox[{"{", 
    RowBox[{"xf", ",", 
     RowBox[{"yf", "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], " ", "h"}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"rdnm", "=", 
   RowBox[{"{", 
    RowBox[{"xf", ",", 
     RowBox[{
      RowBox[{"-", "yf"}], "-", 
      RowBox[{"2", " ", "n", " ", "h"}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"runp", "=", 
   RowBox[{"{", 
    RowBox[{"xf", ",", 
     RowBox[{"yf", "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], " ", "h"}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"runm", "=", 
   RowBox[{"{", 
    RowBox[{"xf", ",", 
     RowBox[{
      RowBox[{"-", "yf"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], " ", "h"}]}]}], "}"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.827934377863954*^9, 
  3.827934377878446*^9}},ExpressionUUID->"de1ebfe0-970a-4104-b29d-\
14537c224fb1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Rho]dnp", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{"r", "-", "rdnp"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Element", "[", 
        RowBox[{"x", ",", "Reals"}], "]"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{"xf", ",", "Reals"}], "]"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{"y", ",", "Reals"}], "]"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{"yf", ",", "Reals"}], "]"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{"h", ",", "Reals"}], "]"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{"n", ",", "Integers"}], "]"}], ",", 
       RowBox[{"h", ">", "0"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Rho]dnm", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{"r", "-", "rdnm"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Element", "[", 
        RowBox[{"x", ",", "Reals"}], "]"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{"xf", ",", "Reals"}], "]"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{"y", ",", "Reals"}], "]"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{"yf", ",", "Reals"}], "]"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{"h", ",", "Reals"}], "]"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{"n", ",", "Integers"}], "]"}], ",", 
       RowBox[{"h", ">", "0"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Rho]unp", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{"r", "-", "runp"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Element", "[", 
        RowBox[{"x", ",", "Reals"}], "]"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{"xf", ",", "Reals"}], "]"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{"y", ",", "Reals"}], "]"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{"yf", ",", "Reals"}], "]"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{"h", ",", "Reals"}], "]"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{"n", ",", "Integers"}], "]"}], ",", 
       RowBox[{"h", ">", "0"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Rho]unm", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{"r", "-", "runm"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Element", "[", 
        RowBox[{"x", ",", "Reals"}], "]"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{"xf", ",", "Reals"}], "]"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{"y", ",", "Reals"}], "]"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{"yf", ",", "Reals"}], "]"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{"h", ",", "Reals"}], "]"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{"n", ",", "Integers"}], "]"}], ",", 
       RowBox[{"h", ">", "0"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8279344693105164`*^9, 
  3.827934469310769*^9}},ExpressionUUID->"2019321a-c1d9-4c6b-9c56-\
dba79c6f7578"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Phi]id", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "v"}], " ", 
     SuperscriptBox["r0", "2"], " ", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         FractionBox[
          RowBox[{"Dot", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"r", "-", "rdnp"}], ")"}], ",", "vuv"}], "]"}], 
          SuperscriptBox["\[Rho]dnp", "2"]], ")"}], "+", 
        RowBox[{"(", 
         FractionBox[
          RowBox[{"Dot", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"r", "-", "rdnm"}], ")"}], ",", "vuvn"}], "]"}], 
          SuperscriptBox["\[Rho]dnm", "2"]], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]}], "//", 
    "Simplify"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.827938713521961*^9, 
  3.8279387401642036`*^9}},ExpressionUUID->"b9a68e70-bba1-4b51-a076-\
c3ed28549902"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Phi]iu", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "v"}], " ", 
     SuperscriptBox["r0", "2"], " ", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         FractionBox[
          RowBox[{"Dot", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"r", "-", "runp"}], ")"}], ",", "vuv"}], "]"}], 
          SuperscriptBox["\[Rho]unp", "2"]], ")"}], "+", 
        RowBox[{"(", 
         FractionBox[
          RowBox[{"Dot", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"r", "-", "runm"}], ")"}], ",", "vuvn"}], "]"}], 
          SuperscriptBox["\[Rho]unm", "2"]], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]}], "//", 
    "Simplify"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.827938754250287*^9, 
  3.8279387715152683`*^9}},ExpressionUUID->"ea0c8ad6-f2af-4aa8-a0c7-\
c8dffa1f2173"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]i", "=", 
    RowBox[{"\[Phi]id", "+", "\[Phi]iu"}]}], ";"}], ";"}]], "Input",
 CellChangeTimes->{{3.827934487759964*^9, 3.827934630758194*^9}, {
  3.8279346645520067`*^9, 3.827934696895278*^9}, {3.8279355095727243`*^9, 
  3.8279355110300417`*^9}, {3.827935600648274*^9, 3.827935603777377*^9}, {
  3.827938777721774*^9, 
  3.827938783329533*^9}},ExpressionUUID->"80917a94-7c4f-439f-b4c5-\
539ebc21e91e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Phi]irev", "=", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SuperscriptBox["r0", "2"], " ", "v", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["1", "h"], " ", 
       SuperscriptBox["E", 
        RowBox[{
         RowBox[{"-", "I"}], " ", "\[Theta]"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["E", 
            RowBox[{"2", " ", "I", " ", "\[Theta]"}]]}], " ", "\[Pi]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Coth", "[", 
             FractionBox[
              RowBox[{"\[Pi]", " ", 
               RowBox[{"(", 
                RowBox[{"x", "-", "xf", "+", 
                 RowBox[{"I", " ", 
                  RowBox[{"(", 
                   RowBox[{"y", "-", "yf"}], ")"}]}]}], ")"}]}], 
              RowBox[{"2", "h"}]], "]"}], "+", 
            RowBox[{"Coth", "[", 
             FractionBox[
              RowBox[{"\[Pi]", " ", 
               RowBox[{"(", 
                RowBox[{"x", "-", "xf", "-", 
                 RowBox[{"I", " ", 
                  RowBox[{"(", 
                   RowBox[{"y", "+", "yf"}], ")"}]}]}], ")"}]}], 
              RowBox[{"2", "h"}]], "]"}]}], ")"}]}], "-", 
         RowBox[{"\[Pi]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Coth", "[", 
             FractionBox[
              RowBox[{"\[Pi]", " ", 
               RowBox[{"(", 
                RowBox[{"x", "-", "xf", "-", 
                 RowBox[{"I", " ", "y"}], "+", 
                 RowBox[{"I", " ", "yf"}]}], ")"}]}], 
              RowBox[{"2", "h"}]], "]"}], "+", 
            RowBox[{"Coth", "[", 
             FractionBox[
              RowBox[{"\[Pi]", " ", 
               RowBox[{"(", 
                RowBox[{"x", "-", "xf", "+", 
                 RowBox[{"I", " ", 
                  RowBox[{"(", 
                   RowBox[{"y", "+", "yf"}], ")"}]}]}], ")"}]}], 
              RowBox[{"2", "h"}]], "]"}]}], ")"}]}]}], ")"}]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{"x", "-", "xf"}], ")"}], " ", 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{"y", "-", "yf"}], ")"}], " ", 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", "xf"}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"y", "-", "yf"}], ")"}], "2"]}]]}], ")"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.827934895408152*^9, 3.827935094389656*^9}, 
   3.827935125270527*^9},ExpressionUUID->"25b70bea-f64f-41a6-8691-\
22c616c98857"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]irev", "-", "\[Phi]i"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r0", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"v", "\[Rule]", "3"}], ",", 
     RowBox[{"h", "\[Rule]", "10"}], ",", 
     RowBox[{"x", "\[Rule]", "0.3"}], ",", 
     RowBox[{"xf", "\[Rule]", "0.5"}], ",", 
     RowBox[{"y", "\[Rule]", "2"}], ",", 
     RowBox[{"yf", "\[Rule]", "4"}], ",", 
     RowBox[{"\[Theta]", "\[Rule]", "0.6"}]}], "}"}]}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.8166165236299453`*^9, 3.8166165860521927`*^9}, {
   3.8166166180738506`*^9, 3.8166166262641773`*^9}, {3.8166169181988106`*^9, 
   3.8166169935676994`*^9}, {3.8166171042103724`*^9, 3.8166171104308133`*^9}, 
   3.827935225964312*^9},ExpressionUUID->"51ceb1d5-d6c0-4590-a401-\
66323b5b0d39"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "5.551115123125783`*^-17"}], "+", 
  RowBox[{"8.326672684688674`*^-17", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{
  3.8166165910833173`*^9, 3.81661691284988*^9, {3.8166169877080297`*^9, 
   3.8166169941483297`*^9}, 3.8166171119958925`*^9, 3.821211965945037*^9, 
   3.8255800403254967`*^9, 3.827938804109586*^9, 3.8280896803564205`*^9, 
   3.8280897439476533`*^9, 3.828089889503274*^9, 
   3.8280902978048725`*^9},ExpressionUUID->"35d0f786-0bda-411a-8c37-\
80259cf2dfdc"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Advective velocity fields generated by the interaction between the fish and \
the wall at the generic point (x,y) and at the very location of the fish \
(note that the walls are placed at 0 and h)\
\>", "Subsection",
 CellChangeTimes->{{3.805531086984949*^9, 3.805531121049476*^9}, {
  3.814950878350466*^9, 3.8149508793109155`*^9}, {3.814973353183139*^9, 
  3.814973354535365*^9}, {3.821199762603872*^9, 3.8211997695036497`*^9}, {
  3.8230097846230273`*^9, 3.8230097850131683`*^9}, {3.823009889610059*^9, 
  3.823009956010789*^9}},ExpressionUUID->"0d2f5f94-9790-4372-a07a-\
cbf169f89b1d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UwallGEN", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"\[Phi]irev", ",", "x"}], "]"}], ",", 
     RowBox[{"D", "[", 
      RowBox[{"\[Phi]irev", ",", "y"}], "]"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.821200027912462*^9, {3.8212003059647236`*^9, 3.8212003250488586`*^9}, 
   3.8212003627058525`*^9, 3.821200619406752*^9, {3.8279362357738943`*^9, 
   3.827936335385936*^9}, {3.827936394172037*^9, 3.8279364085603533`*^9}, {
   3.827936477317552*^9, 3.827936928363134*^9}, {3.8279373304327908`*^9, 
   3.827937354263484*^9}, {3.8279374001780148`*^9, 3.827937422517189*^9}, {
   3.827938658355089*^9, 
   3.8279386618456087`*^9}},ExpressionUUID->"4c00c8b3-772c-441d-a4ca-\
3cce44f22d16"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Uw", "=", 
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{"Limit", "[", 
     RowBox[{"UwallGEN", ",", 
      RowBox[{"y", "\[Rule]", "yf"}]}], "]"}], ",", 
    RowBox[{"x", "\[Rule]", "xf"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8212011144042816`*^9, 3.8212011854421015`*^9}, {
  3.821201298753559*^9, 3.8212012994445906`*^9}, {3.8212014657657814`*^9, 
  3.821201468129343*^9}, {3.8212016098025336`*^9, 3.8212016133403955`*^9}, {
  3.821202547869811*^9, 3.821202595473366*^9}, {3.8279369872045918`*^9, 
  3.8279369926030817`*^9}, {3.827937542364542*^9, 3.827937572908043*^9}, {
  3.827937737835534*^9, 3.82793774331172*^9}, {3.8279378971302757`*^9, 
  3.8279379293396072`*^9}},ExpressionUUID->"36a20898-fabd-4d53-83e5-\
5452cf449886"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Theta]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Theta]"}]]}], ")"}], " ", 
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox["r0", "2"], " ", "v", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"Csc", "[", 
           FractionBox[
            RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], "2"]}]}], ")"}]}], 
     RowBox[{"24", " ", 
      SuperscriptBox["h", "2"]}]]}], ",", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Theta]"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Theta]"}]]}], ")"}], " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     SuperscriptBox["r0", "2"], " ", "v", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          FractionBox[
           RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], "2"]}]}], ")"}]}], 
    RowBox[{"24", " ", 
     SuperscriptBox["h", "2"]}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.82120257598775*^9, 3.821202614896306*^9, 3.8212836213833184`*^9, 
   3.8213711571873302`*^9, 3.821457868920051*^9, 3.8215200083670464`*^9, 
   3.8216044336512685`*^9, 3.8218883865307026`*^9, 3.8222991955061016`*^9, 
   3.822331899536928*^9, 3.8225076211175604`*^9, 3.822647558778148*^9, 
   3.822752461664624*^9, 3.822766779907466*^9, 3.8230097190038295`*^9, 
   3.8235054036046515`*^9, 3.8235960933251886`*^9, 3.823788520785945*^9, 
   3.8240274835439863`*^9, 3.824123380438239*^9, 3.824224417186801*^9, 
   3.824243768028077*^9, 3.8242955439054084`*^9, 3.8245421762368107`*^9, 
   3.825431293477501*^9, 3.825596733367066*^9, {3.8279369767204523`*^9, 
   3.8279369936190357`*^9}, {3.8279375381814833`*^9, 3.827937573761965*^9}, {
   3.827937739019712*^9, 3.827937745470574*^9}, {3.8279379015517597`*^9, 
   3.8279379299184103`*^9}, 3.827938687807571*^9, 3.828089685436432*^9, 
   3.8280897485941916`*^9, 3.828089894482639*^9, 
   3.828090302601629*^9},ExpressionUUID->"c97f1c18-87ba-48c4-b107-\
bd09bc6ef60f"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Velocity along the walls, confirming they are streamlines (vertical velocity \
component should be zero) and streamlines in the channel, with illustration \
for a parameter choice\
\>", "Subsection",
 CellChangeTimes->{{3.805531086984949*^9, 3.805531121049476*^9}, {
  3.814950878350466*^9, 3.8149508793109155`*^9}, {3.814973353183139*^9, 
  3.814973354535365*^9}, {3.8152141795678196`*^9, 3.8152142097515235`*^9}, {
  3.821200720606655*^9, 3.8212007246517434`*^9}, {3.821200944007371*^9, 
  3.8212009473311777`*^9}, {3.827938287914712*^9, 3.827938301014512*^9}, {
  3.828090220036234*^9, 
  3.828090229914936*^9}},ExpressionUUID->"2c29da64-4b94-4b55-a549-\
2a76d564f653"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Uf", "+", "UwallGEN"}], ")"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "]"}], ",", 
   RowBox[{"h", ">", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8054429535392632`*^9, 3.805443063385191*^9}, 
   3.8054430982956114`*^9, {3.805443144957147*^9, 3.8054431547937756`*^9}, {
   3.805443194032325*^9, 3.805443235066763*^9}, {3.8055313829619217`*^9, 
   3.8055313947230873`*^9}, {3.8148714226472135`*^9, 3.81487147864624*^9}, {
   3.814871869323143*^9, 3.814871923083482*^9}, {3.8149508710136285`*^9, 
   3.8149508895450583`*^9}, 3.814961527013486*^9, 3.815138170179143*^9, {
   3.8152115969822674`*^9, 3.8152116850558896`*^9}, {3.8152142139871197`*^9, 
   3.8152142144338636`*^9}, {3.815214882444521*^9, 3.8152148930964265`*^9}, {
   3.815214932319935*^9, 3.81521505221535*^9}, {3.8211985861670237`*^9, 
   3.821198672804449*^9}, {3.821199318856798*^9, 3.8211993292310915`*^9}, 
   3.8211997369547772`*^9, {3.821199783804006*^9, 3.8211997857236443`*^9}, {
   3.82119986717701*^9, 3.8211998687020545`*^9}, {3.821200380944766*^9, 
   3.8212003815748687`*^9}, 3.8212004700916514`*^9, {3.821200529807084*^9, 
   3.821200531024926*^9}, {3.8212005653477125`*^9, 3.821200565747815*^9}, {
   3.821200698228557*^9, 
   3.8212007073589644`*^9}},ExpressionUUID->"6b342097-f257-4bb1-ae22-\
06986d9a692b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Theta]"}]], " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     SuperscriptBox["r0", "2"], " ", "v", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Theta]"}]], " ", 
        SuperscriptBox[
         RowBox[{"Csch", "[", 
          FractionBox[
           RowBox[{"\[Pi]", " ", 
            RowBox[{"(", 
             RowBox[{"x", "-", "xf", "-", 
              RowBox[{"\[ImaginaryI]", " ", "yf"}]}], ")"}]}], 
           RowBox[{"2", " ", "h"}]], "]"}], "2"]}], "+", 
       SuperscriptBox[
        RowBox[{"Csch", "[", 
         FractionBox[
          RowBox[{"\[Pi]", " ", 
           RowBox[{"(", 
            RowBox[{"x", "-", "xf", "+", 
             RowBox[{"\[ImaginaryI]", " ", "yf"}]}], ")"}]}], 
          RowBox[{"2", " ", "h"}]], "]"}], "2"]}], ")"}]}], 
    RowBox[{"4", " ", 
     SuperscriptBox["h", "2"]}]], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.814961527517185*^9, 3.814971834698059*^9, {3.814973339221134*^9, 
   3.8149733576725597`*^9}, 3.8149736454308715`*^9, 3.815061635998472*^9, 
   3.815137920550193*^9, 3.8151382829685493`*^9, 3.8152116920148687`*^9, 
   3.815211770130172*^9, 3.8152150588025603`*^9, 3.8153119627985067`*^9, 
   3.8153145037386894`*^9, 3.8155980537195234`*^9, 3.8157543184961896`*^9, 
   3.817721218942799*^9, {3.8211986035061436`*^9, 3.8211986243430357`*^9}, {
   3.821198654649237*^9, 3.821198673167408*^9}, 3.8211993353346434`*^9, 
   3.8211993757860756`*^9, 3.8211997042862635`*^9, 3.8211997376789823`*^9, 
   3.821199787031289*^9, 3.821199884501792*^9, 3.821200389501573*^9, 
   3.821200475030445*^9, 3.821200535336113*^9, 3.8212005704189982`*^9, {
   3.8212007025988655`*^9, 3.821200713414824*^9}, 3.8212836285310984`*^9, 
   3.8213711658867903`*^9, 3.8214578845298877`*^9, 3.8215200155981207`*^9, 
   3.8216044416485014`*^9, 3.8218883915532575`*^9, 3.822299200560465*^9, 
   3.8223319065804014`*^9, 3.8225076273619146`*^9, 3.8226475702383733`*^9, 
   3.8227524728419*^9, 3.8227667850515766`*^9, 3.82300972755678*^9, 
   3.823505415458963*^9, 3.8235960980519056`*^9, 3.8237885304706745`*^9, 
   3.824027488575071*^9, 3.824123385218376*^9, 3.824224431044448*^9, 
   3.8242437725472937`*^9, 3.8242955530292835`*^9, 3.8245421839561453`*^9, 
   3.825431312057914*^9, 3.8255967715661416`*^9, 3.82793815668427*^9, 
   3.8280897500479703`*^9, 3.8280898958961806`*^9, 
   3.82809030392343*^9},ExpressionUUID->"36c0fceb-0f9b-4841-a433-\
ec76ea6c8df6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Uf", "+", "UwallGEN"}], ")"}], ",", 
     RowBox[{"y", "\[Rule]", "h"}]}], "]"}], ",", 
   RowBox[{"h", ">", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8054429535392632`*^9, 3.805443063385191*^9}, 
   3.8054430982956114`*^9, {3.805443144957147*^9, 3.8054431547937756`*^9}, {
   3.805443194032325*^9, 3.805443235066763*^9}, {3.8055313829619217`*^9, 
   3.8055313947230873`*^9}, {3.8148714226472135`*^9, 3.81487147864624*^9}, {
   3.814871869323143*^9, 3.814871923083482*^9}, {3.8149508710136285`*^9, 
   3.8149508895450583`*^9}, 3.814961527013486*^9, 3.815138170179143*^9, {
   3.8152115969822674`*^9, 3.8152116850558896`*^9}, {3.8152142139871197`*^9, 
   3.8152142144338636`*^9}, {3.815214882444521*^9, 3.8152148930964265`*^9}, {
   3.815214932319935*^9, 3.81521505221535*^9}, {3.8211985861670237`*^9, 
   3.821198672804449*^9}, {3.821199318856798*^9, 3.8211993292310915`*^9}, 
   3.8211997369547772`*^9, {3.821199783804006*^9, 3.8211997857236443`*^9}, {
   3.82119986717701*^9, 3.8211998687020545`*^9}, {3.821200380944766*^9, 
   3.8212003815748687`*^9}, 3.8212004700916514`*^9, {3.821200529807084*^9, 
   3.821200531024926*^9}, {3.8212005653477125`*^9, 3.821200565747815*^9}, {
   3.821200698228557*^9, 3.8212007073589644`*^9}, {3.827938268601675*^9, 
   3.8279382694536552`*^9}},ExpressionUUID->"6b342097-f257-4bb1-ae22-\
06986d9a692b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Theta]"}]], " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     SuperscriptBox["r0", "2"], " ", "v", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Csch", "[", 
         FractionBox[
          RowBox[{"\[Pi]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "\[ImaginaryI]"}], " ", "h"}], "+", "x", "-", "xf",
              "+", 
             RowBox[{"\[ImaginaryI]", " ", "yf"}]}], ")"}]}], 
          RowBox[{"2", " ", "h"}]], "]"}], "2"], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Theta]"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"Csch", "[", 
            FractionBox[
             RowBox[{"\[Pi]", " ", 
              RowBox[{"(", 
               RowBox[{"x", "-", "xf", "+", 
                RowBox[{"\[ImaginaryI]", " ", 
                 RowBox[{"(", 
                  RowBox[{"h", "-", "yf"}], ")"}]}]}], ")"}]}], 
             RowBox[{"2", " ", "h"}]], "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"Csch", "[", 
            FractionBox[
             RowBox[{"\[Pi]", " ", 
              RowBox[{"(", 
               RowBox[{"x", "-", "xf", "-", 
                RowBox[{"\[ImaginaryI]", " ", 
                 RowBox[{"(", 
                  RowBox[{"h", "+", "yf"}], ")"}]}]}], ")"}]}], 
             RowBox[{"2", " ", "h"}]], "]"}], "2"]}], ")"}]}], "+", 
       SuperscriptBox[
        RowBox[{"Csch", "[", 
         FractionBox[
          RowBox[{"\[Pi]", " ", 
           RowBox[{"(", 
            RowBox[{"x", "-", "xf", "+", 
             RowBox[{"\[ImaginaryI]", " ", 
              RowBox[{"(", 
               RowBox[{"h", "+", "yf"}], ")"}]}]}], ")"}]}], 
          RowBox[{"2", " ", "h"}]], "]"}], "2"]}], ")"}]}], 
    RowBox[{"8", " ", 
     SuperscriptBox["h", "2"]}]], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.814961527517185*^9, 3.814971834698059*^9, {3.814973339221134*^9, 
   3.8149733576725597`*^9}, 3.8149736454308715`*^9, 3.815061635998472*^9, 
   3.815137920550193*^9, 3.8151382829685493`*^9, 3.8152116920148687`*^9, 
   3.815211770130172*^9, 3.8152150588025603`*^9, 3.8153119627985067`*^9, 
   3.8153145037386894`*^9, 3.8155980537195234`*^9, 3.8157543184961896`*^9, 
   3.817721218942799*^9, {3.8211986035061436`*^9, 3.8211986243430357`*^9}, {
   3.821198654649237*^9, 3.821198673167408*^9}, 3.8211993353346434`*^9, 
   3.8211993757860756`*^9, 3.8211997042862635`*^9, 3.8211997376789823`*^9, 
   3.821199787031289*^9, 3.821199884501792*^9, 3.821200389501573*^9, 
   3.821200475030445*^9, 3.821200535336113*^9, 3.8212005704189982`*^9, {
   3.8212007025988655`*^9, 3.821200713414824*^9}, 3.8212836285310984`*^9, 
   3.8213711658867903`*^9, 3.8214578845298877`*^9, 3.8215200155981207`*^9, 
   3.8216044416485014`*^9, 3.8218883915532575`*^9, 3.822299200560465*^9, 
   3.8223319065804014`*^9, 3.8225076273619146`*^9, 3.8226475702383733`*^9, 
   3.8227524728419*^9, 3.8227667850515766`*^9, 3.82300972755678*^9, 
   3.823505415458963*^9, 3.8235960980519056`*^9, 3.8237885304706745`*^9, 
   3.824027488575071*^9, 3.824123385218376*^9, 3.824224431044448*^9, 
   3.8242437725472937`*^9, 3.8242955530292835`*^9, 3.8245421839561453`*^9, 
   3.825431312057914*^9, 3.8255967715661416`*^9, 3.82793815668427*^9, 
   3.827938308932125*^9, 3.8280897586191044`*^9, 3.828089904062359*^9, 
   3.82809031161561*^9},ExpressionUUID->"baae5b1d-a131-4233-848b-\
b9a345e8e647"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StreamPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"Uf", "+", "UwallGEN"}], ")"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r0", "\[Rule]", "1"}], ",", 
      RowBox[{"v", "\[Rule]", "3"}], ",", 
      RowBox[{"h", "\[Rule]", "2"}], ",", 
      RowBox[{"\[Theta]", "\[Rule]", "0"}], ",", 
      RowBox[{"xf", "\[Rule]", "0.5"}], ",", 
      RowBox[{"yf", "\[Rule]", "0.5"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", 
    RowBox[{"1", "/", "3"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8172904324649467`*^9, 3.817290590003111*^9}, {
   3.8172906200884466`*^9, 3.817290645099496*^9}, {3.817290724212309*^9, 
   3.817290738759456*^9}, {3.817290792699273*^9, 3.8172907937928505`*^9}, {
   3.8172909395781965`*^9, 3.8172909412088804`*^9}, {3.81729097130244*^9, 
   3.8172909887437143`*^9}, 3.817292983825917*^9, {3.8172930267927823`*^9, 
   3.817293098588103*^9}, {3.8172931972667985`*^9, 3.8172932047322884`*^9}, {
   3.821200613567034*^9, 3.8212006762871943`*^9}, {3.8230097466209717`*^9, 
   3.823009773878857*^9}},ExpressionUUID->"030667e1-cd6a-4ad0-802c-\
23b225c9c0b4"],

Cell[BoxData[
 GraphicsBox[{{}, {
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.7435202190886607, 0.43386259687131784`}, {
       0.7606159567803055, 0.422879972599233}, {0.7748281479615865, 
       0.41274307391782483`}, {0.8086119333308026, 0.3846791433519672}, {
       0.831971626825688, 0.360466250640696}, {0.8492471029758039, 
       0.33884661832539453`}, {0.8891856386139779, 0.2671343919911845}, {
       0.9008926245707682, 0.1998053736502339}, {0.8897098475420904, 
       0.14609910906648707`}, {0.8588512766377809, 0.10214076757842577`}, {
       0.8243731453372412, 0.07668787932041593}, {0.7778383732424192, 
       0.05654210951140405}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.7659742859375073, 0.05312000955179437}, {
       0.7009549429057597, 0.03800115151492326}, {0.6223878110344045, 
       0.028891330885916573`}, {0.5756383815658116, 0.02607107760386703}, {
       0.5250447819567969, 0.024640347644674012`}, {0.47330915334882284`, 
       0.024655178706611852`}, {0.42313363688335165`, 
       0.026171608487954887`}, {0.3596534932905774, 0.030416790125304405`}, {
       0.30645939299945235`, 0.03685279095984571}, {0.27413175412321483`, 
       0.0441170212800763}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.2620439822683546, 0.046833222087325765`}, {
       0.22678801070003618`, 0.05475546777363285}, {0.1637524675778613, 
       0.08364368242516607}, {0.12642379517399835`, 0.11750968132194411`}, {
       0.10501616203067786`, 0.15770926224216905`}, {0.0980911648990818, 
       0.20555802744833726`}, {0.10085701851029286`, 0.23472787873777742`}, {
       0.10939374430596499`, 0.2673054184400706}, {0.12593648244451658`, 
       0.3043756719250566}, {0.13894566880956358`, 0.3260537947954081}, {
       0.15645619989550116`, 0.3498765251476417}, {0.1807690041488689, 
       0.3766490591629063}, {0.1965498917159972, 0.39146478893083264`}, {
       0.21617292413192304`, 0.4076540524082251}, {0.21954511190776355`, 
       0.4100375444281537}}]}, 
     {Arrowheads[{{0.02, 1.}}], ArrowBox[CompressedData["
1:eJwV0H001XccB3BPN3JlGzOtm6ciJiwPIVNvFtGDeRg57Mww11WetnnIQ7Yi
lZIpz80yYyIsEQ6WM504TFFdD3Ove79fN1225iEZxpX9+uNzPud1zudz3p/z
MQiN9eEqyMnJOTP1pr+2nmm4xn2EGZ0KPbsmAR5IBXavFgeQ0X8o+DMnIQJ5
C70bcY/Rr/ll9JxQiLBwddaWiieIyKjl3MscR97emB0/fcBHdVvTxSsuIiTy
u73mFIdw9Hgw906FCEa6aX7N7GFcLuyY7WSLwV2fOO0VMoIgXdf4jLNijPN7
jTkqo5jt446ym8XQkC9YMR4cxZjLiR02M2KUOLd7XH/4J3hPRSyeGUGCspV1
qf8YBPZ9bTlHCRynBi22yQngYnkz4HE0QUt2wKgZEWCtuMPJvIAgM3fYQbZd
iL30jIdvGYGJb4D7kRAhxquUY1ZqCKoCzc02/yqEITt41qaZ4GF5JPHdNA5J
+y1Xqy6CUDM128rYcTh5rL3eM0CQlPmJ+9fD41jtLHgROEZwkuMUcklPhPBc
aTuXEuQUqUx3JIlwaaUzS2OawH3ep3CuVYTmNC3P1n8IbnToGM8oiaF089Om
gZcE+0MMVUX7xFDnlvh2LhKUL7J17VPFyKqwOChbJkgOz6mvrhLj8P15ha7/
CE79VXOFIxIj1mFhT9saQXt/Y9jghhhBjQ6cdhnBtElIiTLzJzvrKY5wnSD4
tP/n29wJVA5GaJ94TbAyZEOL4pm5rDl9ow2Cf2ULjl3XCCJ36nhGMdaYqiG7
bhP0/JYuuMrY2PGQ1G+U4MD5/J2/Mzbf/cOIInMHKyXBdJLx0s+PWt9WpahO
inVdZ1wCnwj9XRQHelOMNeUoSi7GrMxZUdTertowYBzFabXQ+JhCc/6jBXvG
fKv3+7/1ovAyPMnzZczKi+5Z/4KiMCL5winG2fZ+/Pl4imL9M6Z3GK9Ocbui
L1O0LJUKVhlrWz/oMS2leCkKCHGQp4j7UN1jpIbZ/0o4FPfGKZFtUX9QNKrm
eqorUORuOCc2SCh8jGyK8xhXegcifYmiqr7bRk2RYvr+3wNFRhPovzX7o6cS
k7O1Ma3efQLLMcd1eSyKnPeypf7cCQwfkw8K20SxvHxhfrV6AmmHV7uVN1MU
KPSNxAknoFWS8o03m8Kt6eq5FiUJvp9sS+Juoag7ayrlh0mQrvPCX6JBIZtO
rb9XJwHvLdusOm2KyWPJdwumJJCxvpthb2fyFu/21kY/Q4Pi9VqeMYW3ie+T
6KfPYDkqTYi1pNC68U67zHASRol8tzoHCvv43ecqhZNIaykvtfWh8DBQc8vj
Pkd56vDWUB6F3eC7emUjz5Ffnr/PKJUi5ZX7Eb0yKarGlvav/ULxP7FdFsQ=

       "]]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.7190398654161563, 0.5228498782880733}, {0.7220330092753334,
        0.5234893491206316}, {0.7500038060944203, 0.5311599253485191}, {
       0.772175152879574, 0.5384119117168787}, {0.7907010263670374, 
       0.5453903861538325}, {0.8321363662577276, 0.564406388210647}, {
       0.862998702196266, 0.5824851384775681}, {0.8876094869200942, 
       0.5999493630146152}, {0.907941755744562, 0.616947437137831}, {
       0.9452206341721293, 0.6561179812080818}, {0.9715414039550316, 
       0.6935869355441074}, {0.9904471708439291, 0.7296330163237963}, {
       1.0037962075983669`, 0.7644080861537943}, {1.0193284244471348`, 
       0.8412206004911783}, {1.0189747064386505`, 0.8673764472729909}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.0188071768528435`, 0.8797645023696691}, {
       1.0183686152303175`, 0.912194150643244}, {1.0050120959744693`, 
       0.9776507278068293}, {0.9817332233378082, 1.0377137196345168`}, {
       0.9501369449847359, 1.092401614266243}, {0.9112478982712455, 
       1.141568261176968}, {0.8659226740092396, 1.1849896130089914`}, {
       0.8150178630106206, 1.222441622404613}, {0.7442479522969909, 
       1.259962069305058}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.7330724175205903, 1.2652333603895696`}, {
       0.6510537178826078, 1.2930810463760987`}, {0.561176218484916, 
       1.308829904873404}, {0.4694710025650442, 1.3110385971723337`}, {
       0.37873092615720927`, 1.299637251081958}, {0.29157001284004197`, 
       1.274881873009364}, {0.25172232590589527`, 1.2564366856782359`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.2404792450541533, 1.2512323501585325`}, {
       0.21038417826951245`, 1.2373015755692092`}, {0.13764788903574035`, 
       1.187531016157043}, {0.09479816967777382, 1.1476819731998456`}, {
       0.05737302208925421, 1.102845384580967}, {0.026114980405476877`, 
       1.0531644818219374`}, {0.012128027900942003`, 
       1.0271276344359592`}, {-0.000013589284560722887`, 
       0.9999867529445307}, {-0.007720614711043759, 
       0.9726414079395006}, {-0.013471520130026421`, 
       0.944198995569379}, {-0.020398145322275206`, 
       0.8852311964408448}, {-0.01918167516344226, 0.8626996456312095}}]}, 
     {Arrowheads[{{0.016740819277214335`, 1.}}], 
      ArrowBox[{{-0.0185137601969711, 
       0.8503284749170847}, {-0.016984515717274853`, 0.8220036948602629}, {
       0.0000990058458574996, 0.7542085403866968}, {0.0250499453386359, 
       0.7009513612355467}, {0.06617601219479659, 0.6442948426584634}, {
       0.09564929890364159, 0.6145312656425012}, {0.13648395997541662`, 
       0.5835078813644151}, {0.1990936246394222, 0.5502402382356817}, {
       0.22100019445734864`, 0.5413576139503559}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.9271987308691622, 0.3934567366285158}, {0.9592684176610204,
        0.37809942880549896`}, {0.9859847865223734, 0.3651074918837324}, {
       1.0090021652901107`, 0.35395706616637007`}, {1.0817147499176987`, 
       0.3213677948346284}, {1.137023632396667, 0.30178018411423696`}, {
       1.184136879455711, 0.29013608291636606`}, {1.2264853312061823`, 
       0.283959096553654}, {1.2887071679050148`, 0.28127777964356565`}, {
       1.345314161158261, 0.2850397031374557}, {1.3974544836373854`, 
       0.29314521068190114`}, {1.4006370408275537`, 0.2938716558726983}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.4127155669292117`, 0.29662868007498905`}, {
       1.4458682637884748`, 0.3041960593100803}, {1.5329526522307637`, 
       0.3320652461550434}, {1.6083195677434066`, 0.36508033627903613`}, {
       1.6934056104450614`, 0.4117174376196943}, {1.7659746019895681`, 
       0.4604199436360275}, {1.8272304740814624`, 0.510834809702932}, {
       1.8441574934593687`, 0.5279694995589825}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.8528643986954334`, 0.53678322615167}, {1.8783771584252797`,
        0.5626089911953043}, {1.921301454150602, 0.6151533156778533}, {
       1.9573438664469736`, 0.668067512963437}, {1.9868888861088752`, 
       0.7212818917991772}, {2.010321003930787, 0.7747267609321945}, {
       2.02831334608673, 0.8283049518596544}, {2.041308130447092, 
       0.8819412778786869}, {2.0493434853509047`, 0.9355990204363589}, {
       2.051789673417437, 0.9777368597037541}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{2.0524333632942615`, 0.9901063405311679}, {
       2.0509594172659513`, 1.0428360750485886`}, {2.044941447500384, 
       1.0963469829085235`}, {2.034116561634392, 1.1497324330953644`}, {
       2.0181976914618707`, 1.2029506741449358`}, {1.9935015152821003`, 
       1.26386813132287}, {1.961535406712803, 1.3244759693236605`}, {
       1.921715611186587, 1.3847017432323938`}, {1.875900750510775, 
       1.4408851263254228`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{1.867506681536727, 1.4499789165080834`}, {
       1.8144678500729403`, 1.5034885013642494`}, {1.744140324794534, 
       1.5616575822213326`}, {1.7039810633882853`, 1.590336260470661}, {
       1.660181206232449, 1.6187095372563456`}, {1.61203449727876, 
       1.6466378730055349`}, {1.5588346804789515`, 1.6739817281453786`}, {
       1.5000226183840106`, 1.700689936159888}, {1.4560319576800538`, 
       1.7182215598941286`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.4445230632953314`, 1.7228082063031906`}, {
       1.4349603456447635`, 1.7266192417603474`}, {1.362808016291706, 
       1.7515978796127945`}, {1.2825413746704233`, 1.7753460717491316`}, {
       1.23892542599267, 1.7866649794035663`}, {1.1927531863280274`, 
       1.7975637501047426`}, {1.143948035926667, 1.8079610140757758`}, {
       1.0924333550387608`, 1.8177754015397811`}, {1.0377000346362601`, 
       1.8269478559162675`}, {0.9795849571136934, 1.8354014700676289`}, {
       0.9635626566045221, 1.8374028982382489`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.951269011272997, 1.838938560864976}, {0.9185304898550954, 
       1.8430280983813097`}, {0.854979000244501, 1.8497195952447545`}, {
       0.769116728936299, 1.856799914237947}, {0.6794253188484957, 
       1.861971634526418}, {0.5871101830769243, 1.8650951872354362`}, {
       0.49337673471741833`, 1.8660310034902698`}, {0.45680839408944596`, 
       1.8655442861426168`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.4444203034848086, 1.8653794031181745`}, {
       0.3997486601113693, 1.8647848324211003`}, {0.3077496456001685, 
       1.8613624231581083`}, {0.25206080035162015`, 1.8581901437236357`}, {
       0.19776950067293744`, 1.8542682968376196`}, {0.12059871700404654`, 
       1.8473051978274002`}, {0.04745142605550631, 
       1.8391381319227522`}, {-0.021672372172683266`, 
       1.8297670991236756`}, {-0.04908816708830401, 1.8253136327294974`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.061317061811866136`, 
       1.8233271511462734`}, {-0.08677267768052221, 
       1.8191920994301702`}, {-0.14804047830240208`, 
       1.8076781771342214`}, {-0.20566676187271438`, 
       1.795490376527813}, {-0.2596515283914591, 
       1.7826286976109458`}, {-0.3099947778586364, 
       1.7690931403836199`}, {-0.3611479319942136, 
       1.753803262390269}, {-0.4091511612035323, 
       1.7380833834035463`}, {-0.4957078448433941, 
       1.7053536224499841`}, {-0.5364648506137198, 1.6875623028869309`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.5477562551010355, 
       1.682467504467572}, {-0.5882116491827958, 
       1.663190670646396}, {-0.6675357006635607, 
       1.6196488513652478`}, {-0.7127159855331641, 
       1.5909129772058137`}, {-0.7542250084455253, 
       1.5618881816001762`}, {-0.8262292683985192, 
       1.5029718260502902`}, {-0.8655144091108042, 
       1.4648402754264063`}, {-0.9007346282259114, 
       1.426476912970911}, {-0.9345257517877975, 1.3815605846970926`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.9419739100593907, 
       1.3716602355314444`}, {-0.958980301664592, 
       1.349054752565086}, {-0.9960744122671186, 
       1.2853161194410943`}, {-1.0254506445600602`, 
       1.2213917515000947`}, {-1.0471089985434168`, 
       1.1572816487420885`}, {-1.0610494742171885`, 
       1.0929858111670747`}, {-1.0653370539506335`, 
       1.065601919234494}, {-1.0683765186774983`, 
       1.0382222062877289`}, {-1.0676130409650277`, 
       0.9882418008343912}, {-1.0627086669468975`, 
       0.938071733559319}, {-1.057966757126754, 0.9043424479060485}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.0562419561984466`, 
       0.8920739094031067}, {-1.0556566089713901`, 
       0.8879103245656501}, {-1.0443091830811293`, 
       0.8377662321347881}, {-1.0284760829517396`, 
       0.7876756941584147}, {-1.0079670022588472`, 
       0.7376749485282128}, {-0.9824227541744894, 
       0.6878223786160944}, {-0.9514841518707051, 
       0.6381763677939719}, {-0.9167114406176928, 
       0.5913449116385371}, {-0.8758255695449976, 
       0.5449761732083162}, {-0.8282038234434298, 
       0.49919564578824993`}, {-0.8029502124975152, 0.4784955174598967}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.7933685956305963, 
       0.4706415634585018}, {-0.7732234871037994, 
       0.45412882266327864`}, {-0.7315505603369008, 
       0.42416322991596206`}, {-0.6937337082959112, 
       0.40027406776558455`}, {-0.6525991692272721, 
       0.37706895510254984`}, {-0.6076757809357227, 
       0.3548438704543968}, {-0.558680546127173, 
       0.333825765737923}, {-0.505131792942403, 
       0.3146194459852808}, {-0.4465478495221932, 
       0.29782971622862275`}, {-0.38213758126023994`, 
       0.2850667866875211}, {-0.3430288231775125, 0.28114316621678853`}}]}, 
     {Arrowheads[{{0.01567349627366023, 1.}}], 
      ArrowBox[{{-0.33070151890727684`, 
       0.27990641859925147`}, {-0.3111098535502404, 
       0.27794086758154835`}, {-0.2728294511092221, 
       0.2771409450359746}, {-0.23204922278124065`, 
       0.2794479384825923}, {-0.18793064840332482`, 
       0.2859275978219095}, {-0.14007297194131035`, 
       0.2978480109794073}, {-0.08388923098250102, 
       0.3179932922437345}, {-0.050936411729773166`, 
       0.33230395992549966`}, {-0.011525629116254718`, 
       0.35100842520422865`}, {0.03905308450513442, 0.37594387206315116`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{3., 1.3292104786258343`}, {2.996738245936309, 
       1.3355300717320244`}, {2.9506614136719316`, 1.404614347809237}, {
       2.8927559071288322`, 1.4737339771419573`}, {2.8553037159429566`, 
       1.5117330937312516`}, {2.8131073959429997`, 1.5497244454177843`}, {
       2.765389535937795, 1.587705752032224}, {2.711372724736176, 
       1.6256747334052404`}, {2.6496286676684693`, 1.6636300719791597`}, {
       2.644672333148372, 1.6662823466410686`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{2.6337488487288936`, 1.6721278118387986`}, {
       2.5787290700650027`, 1.701570450196308}, {2.53400311972323, 
       1.7230029102549265`}, {2.4851607050148203`, 1.7444129919439}, {
       2.4314289616315694`, 1.765793868170638}, {2.3720350252652755`, 
       1.787138711842551}, {2.305598374697108, 1.808434935737438}, {
       2.230738488708238, 1.8296699526330988`}, {2.1851156172103026`, 
       1.8413953916478556`}, {2.170897464732431, 1.844767527607242}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{2.158842680480039, 1.847626574978087}, {2.1358386850876, 
       1.8530824596433504`}, {2.08225368698473, 1.8647204168253655`}, {
       2.023706617546291, 1.8762985233996838`}, {1.9591184644090385`, 
       1.8877965327531347`}, {1.8874102152097274`, 1.899194198272548}, {
       1.8172975177351613`, 1.9090851376833853`}, {1.7390946970205714`, 
       1.918837163157942}, {1.6963911875342257`, 1.923644747950781}, {
       1.66992270454613, 1.9263804280677914`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{1.6575991649033446`, 1.9276541415022608`}, {
       1.6505285414097899`, 1.9283849338228816`}, {1.601506758647264, 
       1.9330577207742439`}, {1.5493258392466478`, 1.937663108804868}, {
       1.4929328416826881`, 1.9421617100750908`}, {1.4312748244301283`, 
       1.9465141367452485`}, {1.364351787488973, 1.9507203888153426`}, {
       1.2921637308592195`, 1.9547804662853716`}, {1.2398367280152962`, 
       1.9574305680745347`}, {1.1840567071500807`, 1.9599670183933102`}, {
       1.1632147652175784`, 1.960808703571707}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{1.1508356677032936`, 1.9613086235375836`}, {
       1.1247490285449393`, 1.9623621116244845`}, {1.061839052481238, 
       1.964588142150843}, {0.9946587820332783, 1.9666152888678359`}, {
       0.923014906041014, 1.9684154230607804`}, {0.8475448134342984, 
       1.969963377697268}, {0.7688858931429872, 1.9712339857448886`}, {
       0.6873867465669764, 1.9721757974943315`}, {0.6554143276900988, 
       1.9723981820362748`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.6430254395322006, 1.9724843530960494`}, {
       0.6036270051301247, 1.9727583893778062`}, {0.5185906027982322, 
       1.9729881335751847`}, {0.43326147353709943`, 1.972871402266337}, {
       0.3491838440124516, 1.972390621106147}, {0.2674537067300677, 
       1.9715473729694883`}, {0.18838264441582822`, 1.9703767658662161`}, {
       0.14748121466024888`, 1.9695905284410238`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.13509431517669118`, 1.9693524183305884`}, {
       0.11228223979561025`, 1.9689139078061864`}, {0.043500993788858876`, 
       1.967303709054623}, {-0.02157770469885685, 
       1.965511864320217}, {-0.08312309738204085, 
       1.9635504705346878`}, {-0.14130442597519713`, 
       1.9614316246297554`}, {-0.19629093219282961`, 
       1.959167423537139}, {-0.24825185774944222`, 
       1.9567699641885576`}, {-0.34377393373762366`, 
       1.9516236584503797`}, {-0.36008208407526887`, 1.9505829946206161`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.3724461240840272, 
       1.9497940143279116`}, {-0.4296351797172912, 
       1.9461446377632075`}, {-0.5072716478167801, 
       1.9404407085596431`}, {-0.5775445612783006, 
       1.9345424604203654`}, {-0.6413151433440624, 
       1.9284804829260533`}, {-0.7184661560573569, 
       1.9202267824471457`}, {-0.7882629038504692, 
       1.9118361292095856`}, {-0.8514776667119097, 
       1.903326510891709}, {-0.8654838483228732, 1.901225623412376}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.8777359716591461, 
       1.8993878396946302`}, {-0.9088827246301886, 
       1.8947159151718522`}, {-0.9616135292343317, 
       1.8860325294347522`}, {-1.0105149948409529`, 
       1.877296381300026}, {-1.098175805141195, 
       1.8596887899603145`}, {-1.1750291008499425`, 
       1.8419569137290268`}, {-1.2432945209664308`, 
       1.824128948520341}, {-1.3042646698530453`, 
       1.8061774194276352`}, {-1.359197608506281, 
       1.7881150398616288`}, {-1.359886994049453, 1.7878676813565224`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-1.371548240552807, 
       1.7836835081731484`}, {-1.4096502452806243`, 
       1.770012123525798}, {-1.4565127070827932`, 
       1.7519041601727858`}, {-1.540360487606405, 
       1.7156757556224462`}, {-1.6125277137487102`, 
       1.6794351526250715`}, {-1.674801149181302, 
       1.6431876775951229`}, {-1.719369675021215, 
       1.614146417654488}, {-1.7602518056851006`, 
       1.5851139032542672`}, {-1.804587909115806, 1.5487202799684345`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.8141640415094415`, 
       1.5408596398151126`}, {-1.8309568814847916`, 
       1.5270751110750678`}, {-1.8894025122126235`, 
       1.469062011717165}, {-1.938074833500845, 
       1.411065315840199}, {-1.9781711885852546`, 
       1.3530807399778124`}, {-2.010888920701651, 
       1.2951040006636485`}, {-2.036747079087451, 
       1.2371273178666864`}, {-2.05648894347429, 
       1.1791444032758764`}, {-2.068124562383363, 1.1264376987982063`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-2.0707953136107147`, 
       1.114339803810976}, {-2.0752509906367838`, 
       1.0941566013448087`}, {-2.0823252565575086`, 
       1.0091834680618095`}, {-2.0824081439699054`, 
       1.0034595273919467`}, {-2.0824394675818407`, 
       0.9977358125515167}, {-2.076224924870932, 
       0.9358254724482556}, {-2.0637503224024836`, 
       0.8736178560031056}, {-2.0479182908743354`, 
       0.811407824445411}, {-2.0253714012267903`, 
       0.7491929626626279}, {-1.9955190475015985`, 
       0.686972112820166}, {-1.967959951744627, 0.641541148493627}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.9615343215203707`, 
       0.630948544873101}, {-1.9577706237405126`, 
       0.6247441170834354}, {-1.910906940358338, 
       0.5625030072231937}, {-1.8537088077698807`, 
       0.5002428150101987}, {-1.8175564182668775`, 
       0.4664687769847314}, {-1.7767329264948044`, 
       0.43267663801315026`}, {-1.7312383324536618`, 
       0.39886639809545543`}, {-1.681072636143448, 
       0.3650380572316466}, {-1.6013304503618842`, 
       0.31858440131863186`}, {-1.5889337383710935`, 0.3122738863432161}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{-1.5778927572727852`, 
       0.3066535027595758}, {-1.5557382680934295`, 
       0.2953758159146389}, {-1.5063320262398605`, 
       0.27217939221232235`}, {-1.4230371374383979`, 
       0.23786729011510654`}, {-1.3759615117293238`, 
       0.22075697235123123`}, {-1.325267098481354, 
       0.20367714344384408`}, {-1.239310793473544, 
       0.17815020022821945`}, {-1.1910268309866336`, 
       0.16546993693519738`}, {-1.1392056618443867`, 
       0.15284514585203549`}, {-1.1103293404789145`, 0.14664713112379169`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.0982160427428391`, 
       0.1440471324319372}, {-1.052014573413166, 
       0.13413044727846685`}, {-1.0033375747004805`, 
       0.12491425385252766`}, {-0.9512729396564121, 
       0.11579216433381868`}, {-0.8598594093631073, 
       0.10185767426943149`}, {-0.8090676130612067, 
       0.09515488240373812}, {-0.7548857959891403, 
       0.08862839264904486}, {-0.6967102043047082, 
       0.08254066120980702}, {-0.6339370841657106, 
       0.07715414429047993}, {-0.6078579700498882, 0.07534046817940877}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.5954986343049712, 
       0.07448093622254434}, {-0.566566435572146, 
       0.07246884189106349}, {-0.4945982585240173, 
       0.06848475401155793}, {-0.41864461458319013`, 
       0.06586134726521392}, {-0.34068784574637223`, 
       0.06594138254121262}, {-0.2642854372698137, 
       0.07075784099155157}, {-0.21007418133354216`, 
       0.07967068142526565}, {-0.1607766790274787, 
       0.09649801340863529}, {-0.1383238566057156, 
       0.10916937972302845`}, {-0.11651038045733378`, 
       0.12624608779995763`}, {-0.11408748183691561`, 
       0.12872102323067944`}}]}, 
     {Arrowheads[{{0.004209882206728422, 1.}}], 
      ArrowBox[{{-0.1054205675463579, 
       0.13757407761436985`}, {-0.09416713535762695, 
       0.1490692007723948}, {-0.06913040408778778, 
       0.1798485593413574}, {-0.03925448724564668, 0.2181192896605876}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{1.0284188561364582`, 0.26223849021890777`}, {
       1.0669944657438513`, 0.2238575660368045}, {1.1158678037220713`, 
       0.18005046790101906`}, {1.1716101236355956`, 0.14508041689823084`}, {
       1.2491326089093986`, 0.12058745663442394`}, {1.3032237855764817`, 
       0.11336486349819855`}, {1.3577182743947949`, 0.11066824925301451`}, {
       1.4377171668675173`, 0.11196480453515119`}, {1.4768997470865064`, 
       0.11462763223447392`}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{1.4892604239688452`, 0.11546765738342311`}, {
       1.5140451855669472`, 0.11715201684458364`}, {1.5640538982670495`, 
       0.12235947576642217`}, {1.6116262872671758`, 0.12817207644213577`}, {
       1.6994620941675003`, 0.14161270305518814`}, {1.778464423158207, 
       0.15669941160213605`}, {1.8495450911295839`, 0.17265771700137486`}, {
       1.9135291810644712`, 0.18928803655668516`}, {1.971687878338662, 
       0.20632124229768295`}, {1.97517769433358, 0.20745843430051567`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{1.9869572520765109`, 0.21129692288606697`}, {
       2.032297804625258, 0.22607160265071238`}, {2.0880540340723117`, 
       0.2459974298144873}, {2.1389565666798216`, 0.26609872378900756`}, {
       2.1850054024477883`, 0.2863754845742732}, {2.26650739187491, 
       0.3272283625193235}, {2.336525410763496, 0.36832901959192094`}, {
       2.3848669107855685`, 0.40074590905323804`}, {2.427570450277872, 
       0.4322477812336156}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{2.437202586147306, 0.4400368286306176}, {2.4684818597701446`,
        0.4656716576824507}, {2.503755308732648, 0.49818051685034626`}, {
       2.5137758497260396`, 0.5080280955254147}, {2.5234883668990324`, 
       0.5178769000334996}, {2.565189477573299, 0.5692130190852794}, {
       2.600540514281515, 0.6208591843543189}, {2.633066727850994, 
       0.6725152029319797}, {2.6599432951430027`, 0.7241909281268838}, {
       2.6815878044026906`, 0.7758810529823296}, {2.6984178438752098`, 
       0.8275802705416159}, {2.7032165677553897`, 0.8478711182770717}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{2.70606791870945, 0.8599277253029822}, {2.7106461741233896`, 
       0.8792863476821469}, {2.7184855557100587`, 0.9309970512813269}, {
       2.721958970933743, 1.0180616344664375`}, {2.7133711490505346`, 
       1.1051224049048707`}, {2.692138780213946, 1.1921832556420966`}, {
       2.6576785545774877`, 1.2792480797235841`}, {2.6349816522630585`, 
       1.3227829827531394`}, {2.6263287275411065`, 1.3367274026109763`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{2.619796346657314, 1.3472545092994028`}, {2.607965099356166, 
       1.3663208810881873`}, {2.576628895856808, 1.4098617747287276`}, {
       2.540973041764986, 1.4534056636747603`}, {2.5040967687920013`, 
       1.4926582541108893`}, {2.461650030804778, 1.5319032201139933`}, {
       2.413632827803314, 1.571140561684072}, {2.360045159787612, 
       1.610370278821125}, {2.319722646659364, 1.6368322476198847`}, {
       2.2748883488897396`, 1.6632424286376508`}, {2.2547330983229155`, 
       1.6740084306031406`}}]}, 
     {Arrowheads[{{0.011872552470632815`, 1.}}], 
      ArrowBox[{{2.243805186740314, 1.6798456151713463`}, {
       2.2255422664787394`, 1.689600821874424}, {2.1716843994263626`, 
       1.7159074273302042`}, {2.1283632543406408`, 1.735143817580777}, {
       2.0807156606595485`, 1.7543006098448621`}, {2.0287416183830858`, 
       1.77337780412246}, {1.9724411275112523`, 1.7923754004135701`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.0892484132998617`, 
       1.9525872115563399`}, {-1.1412935034445344`, 
       1.9486915300167096`}, {-1.1899576565820893`, 
       1.944785363740932}, {-1.2771431518358467`, 
       1.9369415769809362`}, {-1.3287804115492998`, 
       1.9317231559718369`}, {-1.377035855712893, 
       1.9264979887583489`}, {-1.4634012973905102`, 
       1.9160274157182045`}, {-1.5175828403938576`, 
       1.90864416215196}, {-1.5680294201779494`, 
       1.9012584285054912`}, {-1.5817605066488896`, 1.8989958086836045`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.5939848440089994`, 
       1.8969814722304075`}, {-1.6577176900883648`, 
       1.8864795209718812`}, {-1.7115003050020934`, 
       1.876471718250227}, {-1.7615248794999658`, 
       1.8664656009847027`}, {-1.8502999072481423`, 
       1.8464584228220442`}, {-1.9046733927039463`, 
       1.8325897623755139`}, {-1.9550920589378478`, 
       1.8187279861007903`}, {-2.044064933739946, 
       1.7910250860667651`}, {-2.074848495137499, 1.7801065996576022`}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{-2.0865249727669344`, 
       1.775965121007441}, {-2.0988705577259714`, 
       1.7715863196125146`}, {-2.1494284572830544`, 
       1.7521613379737608`}, {-2.237801083110391, 
       1.7133527291427457`}, {-2.2905982058383088`, 
       1.6866500510014588`}, {-2.3389490492227925`, 
       1.6599676140729045`}, {-2.382853613263844, 
       1.6333054183570832`}, {-2.4223118979614626`, 
       1.6066634638539936`}, {-2.475843605848658, 
       1.566378355297466}, {-2.515212032607186, 1.5332921560333062`}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{-2.524643299513801, 
       1.5252616889495418`}, {-2.5659069597648645`, 
       1.4859826234100089`}, {-2.6024386057938753`, 
       1.4458720000790795`}, {-2.6355060541084883`, 
       1.404246696719473}, {-2.664693762091533, 
       1.3626478197689704`}, {-2.7114299570629163`, 
       1.279529345095277}, {-2.7444030259236203`, 
       1.1964855088285877`}, {-2.7653688038892392`, 
       1.1134852437394922`}, {-2.766513362282912, 1.1034992299029498`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-2.767924126938118, 1.09119062647575}, {-2.774879103155164, 
       1.030510027635029}, {-2.7734857359167835`, 
       0.947541338322238}, {-2.7670343986505674`, 
       0.8956931631804241}, {-2.756235859140527, 
       0.8438429566177846}, {-2.7409012624175997`, 
       0.7919889824386366}, {-2.7208417535127234`, 
       0.7401295044472972}, {-2.6956830850147826`, 
       0.6882609318603614}, {-2.665051009512665, 
       0.6363796738944245}, {-2.654272057738532, 0.6210703930886375}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-2.647139615545734, 0.6109402280550928}, {-2.628516375589971,
        0.5844897516107573}, {-2.5852390002579866`, 
       0.5325954328845948}, {-2.5285047124924955`, 
       0.47539564943066925`}, {-2.5264184897849726`, 
       0.47346562497722433`}, {-2.524319558842151, 
       0.4715356255411624}, {-2.4727781094799197`, 
       0.430186365203839}, {-2.413376374907929, 
       0.38859272849569326`}, {-2.348802288642427, 
       0.34697855678186157`}, {-2.2738834989899024`, 
       0.30532331505665805`}, {-2.266483403389969, 0.3016692105792695}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-2.2553747270905875`, 
       0.29618384038975515`}, {-2.2316622091527334`, 
       0.28447480004064796`}, {-2.185089480987262, 
       0.26360503172350713`}, {-2.134165314493488, 
       0.2427140101052355}, {-2.0788897096714116`, 
       0.22180173518583307`}, {-1.9902473032461252`, 
       0.19239390971378373`}, {-1.939975121379394, 
       0.1776785374699247}, {-1.8857356204099374`, 
       0.1629555255541761}, {-1.796745053269487, 
       0.1416352929509916}, {-1.7865145095419945`, 0.13946240663412418`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-1.774395649919931, 0.1368884570034653}, {-1.746548000893251,
        0.13097383729812254`}, {-1.6925497693130076`, 
       0.12031148874440235`}, {-1.6043387720049018`, 
       0.10487463293569846`}, {-1.5548093344203338`, 
       0.09716373569595703}, {-1.5016639375487553`, 
       0.08945785889928928}, {-1.4126045289371785`, 
       0.07800688486132121}, {-1.36267178711856, 
       0.07229903295915391}, {-1.309137020291388, 
       0.06660293780153106}, {-1.2844549542829016`, 0.0642743744566898}}]}, 
     {Arrowheads[{{0.006205633631954638, 1.}}], 
      ArrowBox[{{-1.2721205359278236`, 
       0.06311071682561076}, {-1.2209045494949802`, 
       0.05827888189589289}, {-1.1716295048727268`, 
       0.0541480829486647}, {-1.1189152541011063`, 0.05003810333849711}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.0505718020800248`, 0.4595434597405309}, {1.099633290801782,
        0.4655828230977637}, {1.1408006722003197`, 0.47452853762500624`}, {
       1.21016939208124, 0.49706015596359787`}, {1.2665297040590964`, 
       0.5238440232865215}, {1.3129764513811508`, 0.5536070556386707}, {
       1.3526044772946628`, 0.585076169064938}, {1.3858961641343144`, 
       0.6179669383171854}, {1.4145650133646477`, 0.6516516612948412}, {
       1.4453411713484918`, 0.6945856211780224}, {1.4549644871592762`, 
       0.711021093505212}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{1.461224483325262, 0.7217124181772206}, {1.4707021435636776`,
        0.7378991282091645}, {1.5065148836025757`, 0.8252011726800245}, {
       1.5252614551604928`, 0.9124697361732472}, {1.5290290482162843`, 
       0.9989384330817733}, {1.523177907293048, 1.0611964272401944`}, {
       1.5104427625346908`, 1.1226546715166261`}, {1.4905867705500593`, 
       1.1830554329014118`}, {1.4831565648734635`, 1.199187676445066}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.477973657769683, 1.2104406515714063`}, {
       1.4633730879479998`, 1.242140978384894}, {1.426935608465797, 
       1.3024086263816785`}, {1.3821221800077284`, 1.360783075043911}, {
       1.3285110114152523`, 1.4169140376526248`}, {1.2655041602222847`, 
       1.4702841856597995`}, {1.1922071603265785`, 1.520358904617558}, {
       1.1327843370866182`, 1.5527682486099517`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.1219076850209448`, 1.5587003995758946`}, {
       1.1079662902831282`, 1.5663040682196254`}, {1.061277202109018, 
       1.5874352486954304`}, {1.0112945041815946`, 1.6071826586520985`}, {
       0.9583693503233525, 1.6253308606875074`}, {0.9028528943567848, 
       1.6416644173995332`}, {0.8135064767835105, 1.6625444156811644`}, {
       0.7185360846903053, 1.6783130879045138`}, {0.6693313695773718, 
       1.6841620436923326`}, {0.6461173462349853, 1.686180962402388}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.6337747485912572, 1.6872543955141792`}, {
       0.6194996035917422, 1.6884959018615797`}, {0.5690407867334164, 
       1.6913146624122564`}, {0.5179549190023947, 1.6926183253443607`}, {
       0.46677838762827406`, 1.6923906760887761`}, {0.4160475798406523, 
       1.690615500076385}, {0.36576249563952956`, 1.687292797307186}, {
       0.31592313502490565`, 1.6824225677811804`}, {0.23542971768122387`, 
       1.671353754510979}, {0.15892454827405278`, 1.656913616592929}, {
       0.1413652555522042, 1.65260073790674}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.12933367510426425`, 1.6496455649566062`}, {
       0.08640762680339269, 1.6391021540270305`}, {0.01787895326924352, 
       1.6179193668132843`}, {-0.046351887253483055`, 
       1.5940185130160016`}, {-0.1059753096898754, 
       1.568052850699495}, {-0.16099131403993347`, 
       1.5400223798637638`}, {-0.21139990030365716`, 
       1.5099271005088089`}, {-0.2734381842866439, 
       1.4665177068774193`}, {-0.31192517743515047`, 1.434755986363537}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.32148065294428313`, 
       1.4268702484123483`}, {-0.3284225661156977, 
       1.421141375150378}, {-0.3763530457908187, 
       1.3737981053276864`}, {-0.4172296233120065, 
       1.3244878974093433`}, {-0.4652268521841249, 
       1.2498061005258159`}, {-0.5006306538207956, 
       1.1726552693955312`}, {-0.5238564304842828, 
       1.0935199986501714`}, {-0.532453382054876, 
       1.0535102777645908`}, {-0.5380202679024233, 
       1.0132430109340187`}, {-0.5378220876008618, 0.9958053218088835}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.5376812928882772, 
       0.9834169340167064}, {-0.5375650797635622, 
       0.9731914558784989}, {-0.5340307471961331, 
       0.9328064365472085}, {-0.5203915939008181, 
       0.851756789545101}, {-0.49279929246340365`, 
       0.770441562169143}, {-0.44905506926037503`, 
       0.6896342059943069}, {-0.3918479670799177, 
       0.6176080595358342}, {-0.35540026606952785`, 
       0.5828486151138724}, {-0.3220808172727365, 0.5564494428344559}}]}, 
     {Arrowheads[{{0.013894563747693362`, 1.}}], 
      ArrowBox[{{-0.31232514170421677`, 
       0.5488189150801337}, {-0.2630364337947169, 
       0.5174895404769452}, {-0.20251245513571728`, 
       0.48926104708646206`}, {-0.12632900437336542`, 
       0.4667188367558332}, {-0.07846790146238385, 
       0.45905647599800226`}, {-0.01954979187642416, 0.4552992388641294}, {
       0.012591782151556668`, 0.455356151411846}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{-0.5671273013607888, 
       1.8562151307936468`}, {-0.6205712425286938, 
       1.8449916426543083`}, {-0.6699702629643175, 
       1.8335460201247138`}, {-0.7594519257200005, 
       1.8102503803480268`}, {-0.8384458031636226, 
       1.7865564842737118`}, {-0.9082902673716499, 
       1.7625283024361087`}, {-0.9703236904205484, 
       1.7382298053695573`}, {-1.0171377349338104`, 
       1.717994037599482}, {-1.0387315038349647`, 1.7079154271236103`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.0499580744544956`, 
       1.7026755714609858`}, {-1.0606568137850712`, 
       1.6976820741799257`}, {-1.1378100745015884`, 
       1.6568295603923713`}, {-1.2040887878060667`, 
       1.615746815529557}, {-1.2617982689344718`, 
       1.5745083911141455`}, {-1.3121380817148522`, 
       1.5331470341103688`}, {-1.3563077899752571`, 
       1.4916954914824587`}, {-1.3948707498770383`, 
       1.450162467160462}, {-1.4286565475062027`, 
       1.4085641018332182`}, {-1.4353202176898994`, 1.3991188385309552`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.4424622968852598`, 
       1.388995465574887}, {-1.4620671354518955`, 
       1.3612070461069976`}, {-1.4908305666804686`, 
       1.3138407190253796`}, {-1.514946841191923, 
       1.2664651205883644`}, {-1.5344159589862576`, 
       1.2190802507959522`}, {-1.5496972667075892`, 
       1.1716887361232606`}, {-1.561250111000034, 
       1.124293203045407}, {-1.5731704092982641`, 
       1.0294900816742154`}, {-1.573766656325705, 
       1.0168245726552836`}, {-1.5741083017224025`, 
       1.0041612146649588`}, {-1.5694800356967744`, 
       0.9477219500232129}, {-1.5650990053542155`, 0.9224476265497149}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{-1.5629830273436496`, 
       0.9102404724055561}, {-1.5596583286715378`, 
       0.8910601647791592}, {-1.5470913282273404`, 
       0.834405629269708}, {-1.5290337409452228`, 
       0.7777655932294627}, {-1.5051106434954704`, 
       0.7211512713114623}, {-1.4749471125483697`, 
       0.6645738781687462}, {-1.4378132610258203`, 
       0.6080521219716035}, {-1.3929792018497218`, 
       0.5516047108903228}, {-1.3490618384096833`, 
       0.5046819195119469}, {-1.327589637567255, 0.4851006135730471}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.3184353625614302`, 
       0.47675248657603825`}, {-1.2977558390064514`, 
       0.45789405280987355`}, {-1.2380974560136833`, 
       0.4112761019500829}, {-1.1691229418050348`, 
       0.3648630580985549}, {-1.0886465440124535`, 
       0.31885461159176676`}, {-1.0428199147603623`, 
       0.2961357927980435}, {-0.9926978078477351, 
       0.27364831594081407`}, {-0.9376663053192924, 
       0.25146882808952886`}, {-0.8900159629273783, 0.23440220380976337`}}]}, 
     {Arrowheads[{{0.01988394904698465, 1.}}], 
      ArrowBox[{{-0.8783523217415778, 
       0.23022471059859537`}, {-0.8769334895903065, 
       0.22971653638564554`}, {-0.8095749569200255, 
       0.20858554860993284`}, {-0.7344448175969497, 
       0.18836615321847386`}, {-0.6611244106659483, 
       0.17209589185000806`}, {-0.5805818929739317, 
       0.15841207407845398`}, {-0.4922161643789783, 
       0.14798877621571907`}, {-0.39542612473916455`, 0.1415000745737104}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.12921327302288782`, 1.7689984775217495`}, {
       0.056054588148813866`, 1.7563480286198123`}, {-0.013277390364885719`, 
       1.7417987194033095`}, {-0.07836660163841046, 
       1.7258127307406947`}, {-0.13921304567176035`, 
       1.708390062631967}, {-0.19581672246493537`, 
       1.6895307150771268`}, {-0.24857490595980195`, 
       1.6695531673143356`}, {-0.2978848700982264, 
       1.648775898581755}, {-0.3436529573469065, 1.627242972785833}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.3546127527904743, 
       1.6214661049753887`}, {-0.3861601403057492, 
       1.604822198207226}, {-0.4333167025667438, 
       1.5770763024778032`}, {-0.4767890938301489, 
       1.5486942167673607`}, {-0.5526813633641913, 
       1.4900214754034176`}, {-0.5932781539238323, 
       1.45242374454927}, {-0.6297244824995807, 
       1.4142900060201382`}, {-0.6620203490914361, 
       1.3756202598160217`}, {-0.6901657536993991, 
       1.3364145059369206`}, {-0.7159648572652901, 1.2928697582720832`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.7222799543396089, 
       1.2822108875916411`}, {-0.7290661344121805, 
       1.2707569043897224`}, {-0.7594157227089116, 
       1.2045319944495683`}, {-0.7812145185895925, 
       1.1377397761164583`}, {-0.794462522054223, 
       1.0703802493903922`}, {-0.7997779052464118, 
       1.0303083486976272`}, {-0.802319477898106, 
       0.9902108716444151}, {-0.7986006308418878, 
       0.9450693556890024}, {-0.7912627747996346, 
       0.8997457339756908}, {-0.7689506856261104, 
       0.8091529764180071}, {-0.7670440691162489, 0.8041138803010991}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.7626597712522892, 
       0.7925263910354932}, {-0.7518534995378956, 
       0.7639659324678661}, {-0.7305104075357941, 
       0.7189430723061878}, {-0.7045564462543167, 
       0.6742019161709192}, {-0.6736266523279746, 
       0.6298599843000072}, {-0.6399682525836724, 
       0.5891254208366141}, {-0.6008286495331823, 
       0.5492807606297457}, {-0.5556221395126097, 
       0.5105705149044436}, {-0.5037630188580606, 
       0.4732391948857491}, {-0.44405800278599117`, 
       0.43813531197521327`}, {-0.43670399838561047`, 
       0.43486077828101666`}}]}, 
     {Arrowheads[{{0.007679720638858159, 1.}}], 
      ArrowBox[{{-0.42538609510531156`, 
       0.42982123062490174`}, {-0.3743639913238946, 
       0.40710250639182977`}, {-0.29191133907066424`, 
       0.38272979672679686`}, {-0.24412723421235272`, 0.3746644614988473}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.699535736503551, 0.6190123513177742}, {0.7074300849016673, 
       0.6390338546356512}, {0.7124359749723994, 0.65739775761357}, {
       0.7168108173955894, 0.693962819376894}, {0.7147762397495498, 
       0.7257141719829346}, {0.7084565558608983, 0.7536874713292231}, {
       0.6988953844690468, 0.7784459988651616}, {0.6618349924867774, 
       0.8340806621152977}, {0.6143550900695381, 0.8720743451349716}, {
       0.5611244188858047, 0.8946670611152276}, {0.5335077984926035, 
       0.9022790546421244}, {0.5056030212099752, 0.9063340109926836}, {
       0.47745267907222644`, 0.9036157598765131}, {0.44947411490412537`, 
       0.8973342948644843}, {0.41956472144004636`, 0.8863429106558564}}]}, 
     {Arrowheads[{{0.013723142214468718`, 1.}}], 
      ArrowBox[{{0.4079359016672236, 0.8820694429852567}, {0.3952667104540819,
        0.8774136498678384}, {0.3462136787644342, 0.842201869379223}, {
       0.3066103371497348, 0.7897480846477802}, {0.29524016552488347`, 
       0.7649101875462925}, {0.28709078060512105`, 0.7366759243332183}, {
       0.28319285073199685`, 0.7044842172054154}, {0.28558821402567885`, 
       0.6673193302383509}, {0.2901673089787185, 0.6466676287233539}, {
       0.2982113952762516, 0.623950019626859}, {0.3115672065999327, 
       0.598427153344586}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.01999999999999999, 1.}}], 
      ArrowBox[{{1.6409629206457805`, 0.05047967847824843}, {
       1.7198688926015557`, 0.05497626040910236}, {1.7919540359095079`, 
       0.05992021845763104}, {1.857218350569636, 0.06531155262383445}, {
       1.91700332331261, 0.07097442332764164}, {1.9726504408690988`, 
       0.07673299098898162}, {2.0241597032391034`, 0.08258725560785442}, {
       2.0715311104226233`, 0.08853721718426004}, {2.13412411081015, 
       0.09735520832703332}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{2.1463921567930417`, 0.09908350893806829}, {
       2.1571580894832225`, 0.10060019448625979`}, {2.2328291083039127`, 
       0.11279788617157098`}, {2.2999630165655054`, 0.12510271133254044`}, {
       2.3605995196498757`, 0.13747566825293947`}, {2.4218699334217213`, 
       0.15123822104176027`}, {2.4783852030580285`, 0.16501434983035984`}, {
       2.530145328558798, 0.17880405461873813`}, {2.5771503099240296`, 
       0.19260733540689517`}, {2.6288075351415636`, 0.20962059005790845`}}]}, 
     {Arrowheads[{{0.016312279491019318`, 1.}}], 
      ArrowBox[{{2.6405749406062236`, 0.2134961730941423}, {2.661037349383834,
        0.22023544663894834`}, {2.7341888305733986`, 0.2478795051829223}, {
       2.7433067431171807`, 0.2515991133426291}, {2.7522740048768517`, 
       0.25531891223973924`}, {2.815092517632822, 0.285344682172004}, {
       2.871233174398186, 0.3155496468967967}, {2.924628169361241, 
       0.3457549385225155}, {2.9725318407196775`, 0.3759608839500866}, {3., 
       0.3952036749131073}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.7467019580012053`, 
       1.774779714937616}, {-1.7995594486201483`, 
       1.7542099096397878`}, {-1.8484452561253044`, 
       1.7336609996577257`}, {-1.935295681590949, 
       1.6926204954634168`}, {-2.009240953991525, 
       1.6516474619997226`}, {-2.0722687929204175`, 
       1.6107311589116766`}, {-2.1159763332894, 
       1.5787005623466546`}, {-2.155839719700137, 
       1.5466929215827077`}, {-2.173906606275625, 1.5297514407632615`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-2.182944037557755, 
       1.521276960775603}, {-2.2240340306468767`, 
       1.4827465074580406`}, {-2.2793660517425725`, 
       1.4188671336707288`}, {-2.32435010896916, 
       1.3550300173538259`}, {-2.360158283047979, 
       1.2912241059208256`}, {-2.3879626547003676`, 
       1.2274383467852212`}, {-2.408243848055482, 
       1.163662249695325}, {-2.4216718081676705`, 
       1.0998860170537281`}, {-2.4218832594273896`, 1.0981135148440637`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-2.4233508259880363`, 
       1.0858115546900668`}, {-2.4275431199141995`, 
       1.050669412441494}, {-2.4295753708830072`, 
       1.0014536586616751`}, {-2.429582975653762, 
       0.9981333129892582}, {-2.4295732525083586`, 
       0.9948130122393332}, {-2.4223803185710704`, 
       0.9295143083999999}, {-2.4081918797641433`, 
       0.8638641366343784}, {-2.3902152975395925`, 
       0.7982073851985874}, {-2.3646624284797957`, 
       0.7325374744224572}, {-2.3307644339315523`, 
       0.6668485642301121}, {-2.298475234645219, 0.6175170661062708}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-2.2916902570748756`, 
       0.6071509648811045}, {-2.287752475241664, 
       0.6011348145456763}, {-2.2339730218149194`, 
       0.5353782606105937}, {-2.1677725430561106`, 
       0.46956093766630813`}, {-2.122740356222267, 
       0.4317961141381356}, {-2.0706379198183384`, 
       0.3939732355870996}, {-2.011465233844326, 
       0.3560923020132003}, {-1.9452222983002283`, 
       0.3181533134164376}, {-1.9092096616864922`, 0.30000744509878297`}}]}, 
     {Arrowheads[{{0.012107013367363818`, 1.}}], 
      ArrowBox[{{-1.8981456376579544`, 
       0.2944325596706875}, {-1.869803418957509, 
       0.2801516234014367}, {-1.7815148308092839`, 
       0.242130094136719}, {-1.7313141652923454`, 
       0.22313218400803642`}, {-1.6762296466816802`, 
       0.20414614822961635`}, {-1.618785995651964, 0.18617947987759184`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{1.6252219779135153`, 0.22192961934325012`}, {
       1.6829921941386692`, 0.23726510239443266`}, {1.7358857217319867`, 
       0.2540942034903787}, {1.7846856838692342`, 0.27187072220518455`}, {
       1.8301752037261754`, 0.2900484581129461}, {1.9112229165991421`, 
       0.3276075815073368}, {1.9811862153281994`, 0.3662769726868927}, {
       2.042222454890659, 0.4055620306649556}, {2.0722538304416163`, 
       0.4280435718102898}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{2.08217183316834, 0.43546820628972077`}, {
       2.0953505846955784`, 0.4453338431201425}, {2.1420590605683603`, 
       0.4854121940726426}, {2.179898226986176, 0.52209904062812}, {
       2.213953262606187, 0.5588708525400803}, {2.2707109414527946`, 
       0.6326693724334493}, {2.3143524306202226`, 0.7067005355755229}, {
       2.346898063620513, 0.7808571237890745}, {2.363534786601433, 
       0.8329806408425557}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{2.366432190001352, 0.8450215978604534}, {2.376310518124626, 
       0.8879674545044997}, {2.383853139651542, 0.9415186626338091}, {
       2.3866200240283635`, 0.9950672326108496}, {2.386739842254058, 
       1.0119951194264452`}, {2.3864025884735063`, 1.0289157283127766`}, {
       2.3768382318237937`, 1.0930156247826068`}, {2.360338942257482, 
       1.1574065633128259`}, {2.340067116911914, 1.2217575875753774`}, {
       2.312250220007834, 1.2860287833025943`}, {2.292042397835786, 
       1.3218939116545967`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{2.285960759217989, 1.3326876898143967`}, {
       2.2761008854780074`, 1.3501871330600983`}, {2.2308317472552, 
       1.4141996194135118`}, {2.17480602048045, 1.478006555034935}, {
       2.106386920294795, 1.5415482525964679`}, {2.048583159268067, 
       1.5867916417169952`}, {1.9809236287145975`, 1.6317128865667998`}, {
       1.9250027277167852`, 1.6631947425589093`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.9142067889970542`, 1.6692725449907317`}, {
       1.9018389137973404`, 1.6762353023679957`}, {1.8575216700657144`, 
       1.698322985382276}, {1.8097595996792488`, 1.7202822043426969`}, {
       1.7578677408020358`, 1.7420366973868862`}, {1.7006723466168916`, 
       1.763443526387334}, {1.6373092308806223`, 1.7844309073271158`}, {
       1.5669793754333874`, 1.8049648721673213`}, {1.4884603294307581`, 
       1.8249224677765503`}, {1.4484714582665354`, 1.8336102050805863`}}]}, 
     {Arrowheads[{{0.0055977263429928545`, 1.}}], 
      ArrowBox[{{1.4363646914756534`, 1.8362404471058853`}, {
       1.4001387933853933`, 1.8441106639199207`}, {1.3516934769435325`, 
       1.8533255496560073`}, {1.300144046874965, 1.8622584409804168`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-3., 0.35208676923235865`}, {-2.9822665385131417`, 
       0.34107189398998367`}, {-2.9305518000850688`, 
       0.31212006581461194`}, {-2.8730162595907993`, 
       0.2831599143327459}, {-2.808286909781364, 
       0.2541948646441052}, {-2.7557652508253443`, 
       0.23309712741832353`}, {-2.7539076228578456`, 
       0.23238499833859871`}, {-2.752043769762842, 
       0.231672873667828}, {-2.69146960743536, 
       0.21083072898908745`}, {-2.623352116015727, 
       0.18986973083050782`}, {-2.550082693641086, 
       0.16889612380649943`}, {-2.542352912798612, 0.16695392044936233`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-2.5303372127282393`, 
       0.16393482670134854`}, {-2.466509409356429, 
       0.1478972990516336}, {-2.4198511363245454`, 
       0.13738470032133843`}, {-2.368601532468559, 
       0.12685833775074754`}, {-2.3127605977884698`, 
       0.11631821133986091`}, {-2.2523283322842778`, 
       0.10576432108867853`}, {-2.1605417583184723`, 
       0.09163214667310815}, {-2.1087230617061445`, 
       0.08455911480113444}, {-2.052954092007532, 
       0.07748145315303502}, {-2.042965960833555, 0.07636038560039436}}]}, 
     {Arrowheads[{{0.010832943890834591`, 1.}}], 
      ArrowBox[{{-2.0306540816434766`, 
       0.07497850063797121}, {-1.9610791776830276`, 
       0.06716941543979454}, {-1.9092861998809336`, 
       0.062009979412970664`}, {-1.8535895416522785`, 
       0.05684826527267769}, {-1.7634670068910956`, 
       0.049442312463974625`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{-1.8156238761015688`, 
       1.9430874947133492`}, {-1.871125139590209, 
       1.9379384705150757`}, {-1.9227475397786025`, 
       1.9327918413281417`}, {-2.0143557502546465`, 
       1.9225057679882918`}, {-2.0696158710702925`, 
       1.9154938497371634`}, {-2.1209877433648754`, 
       1.9084862322917509`}, {-2.212066742390851, 
       1.8944838998180726`}, {-2.273308143192863, 
       1.8838088485270041`}, {-2.306622214752322, 1.8775279254708126`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-2.318796910768063, 1.875232549213038}, {-2.329848616352053, 
       1.8731488977959834`}, {-2.381688161868423, 
       1.8625040476250105`}, {-2.4288267797419714`, 
       1.8518742980140852`}, {-2.5131780783157436`, 
       1.8306425668473305`}, {-2.5870793578285087`, 
       1.8094361706706719`}, {-2.652089968736912, 
       1.7882435568802393`}, {-2.710419630218995, 
       1.7670530713158525`}, {-2.7666404410633603`, 
       1.7444127624054646`}, {-2.7684408817862676`, 
       1.743648572738519}, {-2.7702353226649925`, 
       1.7428843857879055`}, {-2.7920608548948462`, 1.732292707699992}}]}, 
     {Arrowheads[{{0.009169047064385842, 1.}}], 
      ArrowBox[{{-2.803206895215806, 
       1.7268836633847737`}, {-2.834064466210279, 
       1.711908841460324}, {-2.8909585180537163`, 
       1.6807656294409765`}, {-2.9450121567977106`, 
       1.649630198214006}, {-2.9933849693428214`, 1.6185103285717903`}, {-3., 
       1.6137723996572153`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.244862799421716, 
       1.7327744764233022`}, {-1.308164013494902, 
       1.7034376889229355`}, {-1.3562216687463422`, 
       1.6786941750139948`}, {-1.400544595583807, 
       1.6539301635453707`}, {-1.4779862640168095`, 
       1.604340647929073}, {-1.5431810504139745`, 
       1.554690381436115}, {-1.5988209863953653`, 
       1.5050006034285703`}, {-1.646224080130867, 
       1.4552799193542385`}, {-1.6486052780369511`, 1.4523541429663203`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-1.6564257280591894`, 
       1.4427451608823465`}, {-1.6867083397903648`, 
       1.4055369346609206`}, {-1.72086678401175, 
       1.3557690415977057`}, {-1.7495633792594947`, 
       1.305977020348392}, {-1.77923820611042, 
       1.2424638811336135`}, {-1.801929033086383, 
       1.178989671522487}, {-1.817635860187385, 
       1.115554391515012}, {-1.826358687413425, 
       1.0521580411111888`}, {-1.827061699882959, 
       1.0436403175465274`}, {-1.8276495921468927`, 
       1.0351232655911993`}, {-1.8259292126453952`, 0.9893341565338973}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{-1.8254640566899005`, 
       0.9769537039905724}, {-1.825413495668854, 
       0.9756079868945857}, {-1.8174881701461925`, 
       0.9158316198594302}, {-1.8065731977325996`, 
       0.8560564849869776}, {-1.7896789315371453`, 
       0.7962838144399312}, {-1.7664147241608794`, 
       0.7365168063994434}, {-1.736389928204854, 
       0.6767586590466665}, {-1.698799694624653, 
       0.6170127081629238}, {-1.6528391743758617`, 
       0.5572822895295378}, {-1.6299911126112465`, 0.5319990257129474}}]}, 
     {Arrowheads[{{0.018673574197198988`, 1.}}], 
      ArrowBox[{{-1.6216844949181661`, 
       0.5228070684816796}, {-1.619074207564215, 
       0.5199185703461721}, {-1.580523863509561, 
       0.48255513738331735`}, {-1.5371881422118991`, 
       0.4451919906409737}, {-1.4890670436712299`, 
       0.40782913011914124`}, {-1.412826053017114, 
       0.35703473699697147`}, {-1.3691121885992652`, 
       0.3316985455751326}, {-1.321669411454223, 
       0.3064030242461245}, {-1.2390931313861793`, 0.26798075235551405`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.7082842204800235, 
       1.7360105747340957`}, {-0.7689539586044929, 
       1.7105154498707964`}, {-0.8236448884643197, 
       1.6846699449378408`}, {-0.8732638543944994, 
       1.658554607903557}, {-0.917948946356652, 
       1.632178249178083}, {-0.958793652496269, 
       1.6056069148528258`}, {-1.0068326005009756`, 
       1.5710502416908287`}, {-1.0497997109056871`, 
       1.5362840148902968`}, {-1.0884616055226164`, 
       1.5013642819169755`}, {-1.1208270852606022`, 1.468627180156737}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.1289630765576768`, 
       1.4592953328389089`}, {-1.1817935888361748`, 
       1.3959009873227999`}, {-1.2280939960834951`, 
       1.325125460625975}, {-1.264157702434151, 
       1.254158946713048}, {-1.2912767463852166`, 
       1.183169820535892}, {-1.3094511279366914`, 
       1.1121580820945072`}, {-1.318680847088576, 
       1.0411237313888935`}, {-1.3199354077230758`, 
       1.0223884326875021`}, {-1.3202732169299658`, 1.0132304456109154`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.3204077322925858`, 
       1.0008562762464686`}, {-1.3164699882515618`, 
       0.9503621707170935}, {-1.3076430482069568`, 
       0.8968754809522453}, {-1.2963600302515563`, 
       0.8434030611416937}, {-1.2801648564745662`, 
       0.7899591812397356}, {-1.2587610702596852`, 
       0.7365671501841471}, {-1.231852214990613, 
       0.6832502769127046}, {-1.1988814242567414`, 
       0.630048638904668}, {-1.1592918316474619`, 
       0.5770023136392973}, {-1.1367181229131107`, 0.551323156910886}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.128538371725782, 
       0.5420181235550162}, {-1.1186000506811233`, 
       0.5307125952199802}, {-1.071166167438426, 
       0.4847176831172584}, {-1.0161869219465895`, 
       0.43909407287183255`}, {-0.9528590542328329, 
       0.3939182600244031}, {-0.9018552495685325, 
       0.36233252565703866`}, {-0.8445467752935536, 
       0.3314668665888192}, {-0.780177548849783, 
       0.301491494823933}, {-0.7160149717173375, 0.2757905117777195}}]}, 
     {Arrowheads[{{0.0071644167125452084`, 1.}}], 
      ArrowBox[{{-0.7044380971438671, 
       0.2713910277058562}, {-0.6266172313085061, 
       0.24542596641822223`}, {-0.5341307359127995, 0.22168751004141235`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{3., 1.7982314739649476`}, {2.986508325401614, 
       1.802699460185836}, {2.9373628203565247`, 1.8177008266406733`}, {
       2.8836298177853155`, 1.8327012818114994`}, {2.824566268770125, 
       1.8477007253745403`}, {2.816243309510286, 1.849723047255729}, {
       2.8078047573175886`, 1.8517449886045527`}, {2.764201678016156, 
       1.8613535929931018`}, {2.7171203281263216`, 1.8709814331929555`}, {
       2.667910523555321, 1.8806064153139024`}, {2.6144438096219877`, 
       1.890225681277035}, {2.5558324797970093`, 1.8998372105959254`}, {
       2.516824175759814, 1.9056312651674243`}}]}, 
     {Arrowheads[{{0.01646515267933737, 1.}}], 
      ArrowBox[{{2.504569434383975, 1.9074515093960251`}, {
       2.4911888275510736`, 1.9094389827841447`}, {2.418904568147605, 
       1.9190269926673187`}, {2.337371416850026, 1.9285972350710723`}, {
       2.267795429057122, 1.935857330733271}, {2.188910757854284, 
       1.9430914005200213`}, {2.098925845412754, 1.9502930198380812`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{2.1536758916291263`, 0.17472467413053916`}, {
       2.2166738437620634`, 0.19257385162486254`}, {2.274561011870687, 
       0.21048890621254301`}, {2.327337395954997, 0.2284698378935806}, {
       2.3750029960149925`, 0.2465166466679753}, {2.459430239162742, 
       0.28271952330901584`}, {2.5322711364146344`, 0.31900916394784445`}, {
       2.595194176696727, 0.3553765484771288}, {2.609272785378263, 
       0.36463859641249746`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{2.619622990226813, 0.3714477986296083}, {2.65056257286849, 
       0.3918023595105658}, {2.714338692591696, 0.4398187036831195}, {
       2.769022925609676, 0.48785022021867824`}, {2.8158603905164066`, 
       0.5358922247138521}, {2.8560962059058665`, 0.5839400327652516}, {
       2.8610597582864408`, 0.5903973842113762}, {2.865919389536417, 
       0.5968545790747442}, {2.906123427752992, 0.6657621226099749}, {
       2.9370134764041564`, 0.7351876446482896}, {2.9384840641326373`, 
       0.7390806346961686}}]}, 
     {Arrowheads[{{0.018401772372194224`, 1.}}], 
      ArrowBox[{{2.942862156401993, 0.7506704700410499}, {2.966068418740994, 
       0.8121028800799344}, {2.9847790922386426`, 0.8889975712149266}, {
       2.993629590776381, 0.9658770581169146}, {2.993104008233488, 
       1.0427466808495465`}, {2.9830505723776044`, 1.1196172583080248`}, {
       2.9633175109763705`, 1.1964996093875517`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-3., 0.7349067887798153}, {-2.990030017754411, 
       0.7112669176523779}, {-2.9525801921500987`, 
       0.6440547254280092}, {-2.905179365325798, 
       0.5768296631347136}, {-2.8746319128441127`, 
       0.5401393359105143}, {-2.873540466705124, 
       0.5389009727525401}, {-2.8724447367092387`, 
       0.5376626144033972}, {-2.822358636615215, 
       0.48917859135022257`}, {-2.7635403565302297`, 
       0.44037253503801443`}, {-2.6989684285557307`, 
       0.39153598110308846`}, {-2.67157123044202, 0.37392728616543536`}}]}, 
     {Arrowheads[{{0.014813797641094147`, 1.}}], 
      ArrowBox[{{-2.661149056615968, 0.3672287588660946}, {-2.622889204802205,
        0.3426384319227269}, {-2.5795177702404652`, 
       0.31815768417296175`}, {-2.5312363381982816`, 
       0.2936434877267455}, {-2.4780449086756566`, 
       0.26909584258407815`}, {-2.4199434816725893`, 
       0.24451474874495976`}, {-2.3299023677541664`, 0.2113363785177046}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-2.3121451096706203`, 
       1.7891765244116353`}, {-2.40246098077033, 
       1.7559898770649776`}, {-2.459441695416829, 
       1.7319622286211422`}, {-2.5116840548876196`, 
       1.7079674459841563`}, {-2.5591880591827025`, 
       1.6840055291540204`}, {-2.6019537083020774`, 
       1.660076478130734}, {-2.677174686904513, 
       1.6122789885181437`}, {-2.7412517365857374`, 
       1.5645369921598185`}, {-2.74785142847088, 1.5587483928163532`}}]}, 
     {Arrowheads[{{0.018101665936032733`, 1.}}], 
      ArrowBox[{{-2.7571655359387, 1.5505789756205952`}, {-2.795648497745913, 
       1.5168255138940987`}, {-2.8424394649472635`, 
       1.469119402540884}, {-2.8750376850637993`, 
       1.431025473154843}, {-2.876071382305531, 
       1.4297396496636137`}, {-2.8771008073818325`, 
       1.4284538298696094`}, {-2.915559270081699, 
       1.3700767576819586`}, {-2.9468857400307162`, 
       1.311376189819606}, {-2.9749907899065895`, 
       1.2526842755603194`}, {-2.996652999636176, 1.1940096685071666`}, {-3., 
       1.1814256954494882`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.8263959124586069, 0.6770327471270645}, {0.8359154937201636,
        0.7009267711868136}, {0.8510938531732233, 0.7857124470774235}, {
       0.8428404264410451, 0.8570857272427163}, {0.8194771911525417, 
       0.9178865816124789}, {0.7861716996528126, 0.9695790150265526}, {
       0.7458251271547749, 1.0126922486776226`}, {0.6998339279079215, 
       1.0473346588779135`}, {0.6495945561617452, 1.073614621939649}, {
       0.6382215144320043, 1.0771602313833926`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.6263937787792446, 1.0808475942037417`}, {
       0.5768857739055457, 1.096281991948195}, {0.5014466497211516, 
       1.1040187212842236`}, {0.4259723964739665, 1.0968071521855054`}, {
       0.3885620756490677, 1.0894561891479988`}, {0.35215994824354996`, 
       1.0784283806408066`}, {0.31920802399288994`, 1.0606468101620243`}, {
       0.28787197190224745`, 1.039180445605708}, {0.23001843537996786`, 
       0.9888664657439429}, {0.19330163790585636`, 0.9366950351518578}}]}, 
     {Arrowheads[{{0.011674289117199359`, 1.}}], 
      ArrowBox[{{0.18617127851815377`, 0.9265634039780213}, {
       0.18393057205173965`, 0.9233795516289109}, {0.15532916169211947`, 
       0.8412349064079554}, {0.15119959119601162`, 0.7739856700049283}, {
       0.16782965115466675`, 0.6947009207775335}, {0.18898529553621818`, 
       0.6493869734205353}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.011603399090823082`, 1.}}], 
      ArrowBox[{{0.6000871033925151, 0.6054946322499277}, {0.5844503262330668,
        0.6533606310002814}, {0.5568545659793281, 0.6813214006984111}, {
       0.524586508915853, 0.6955695085217435}, {0.5077689613436024, 
       0.699612905927549}, {0.49093252070756516`, 0.7008050173713755}, {
       0.47434490164726034`, 0.6966551101916192}, {0.45806657219636276`, 
       0.6894945964663138}, {0.42772503851498805`, 0.6684082421606081}, {
       0.40488809972027967`, 0.6312542644312372}, {0.40125955442367023`, 
       0.6187910166624709}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-2.3801336959162436`, 
       1.9567789870967585`}, {-2.4388223656177748`, 
       1.95270370461823}, {-2.4926176770971527`, 
       1.9486348374367435`}, {-2.541519630354376, 
       1.9445723855522983`}, {-2.6291133550100043`, 
       1.9364591706904262`}, {-2.7060734323923064`, 
       1.9283565030485084`}, {-2.774043702144389, 
       1.9202596488370447`}, {-2.835347665520755, 
       1.9121638031896009`}, {-2.873034094859122, 1.9067241108187267`}}]}, 
     {Arrowheads[{{0.004701428044178383, 1.}}], 
      ArrowBox[{{-2.8852958656187826`, 
       1.9049518833700931`}, {-2.8865076576246853`, 
       1.9047697463287196`}, {-2.8881098550035373`, 
       1.9045283083598943`}, {-2.9599288999829882`, 1.892280726847071}, {-3., 
       1.884644671672506}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.015240245291881954`, 1.}}], 
      ArrowBox[{{0.6212114495580772, 0.39701668491178305`}, {
       0.622083218565695, 0.3838920008144817}, {0.6214565077972717, 
       0.37202179952533015`}, {0.6105917795461193, 0.3333081153298243}, {
       0.6023161932126768, 0.3171971798282373}, {0.5924495518432054, 
       0.30363130724575094`}, {0.5803071563838484, 0.2939389763886056}, {
       0.5672374070769091, 0.28598579431129784`}, {0.5399788550903697, 
       0.27352963151510085`}, {0.5111086530679643, 0.2678009544308355}, {
       0.4818134799836419, 0.2685890053195203}, {0.4237903359038511, 
       0.2923626544209356}, {0.410945318607598, 0.3032119762106981}, {
       0.39948782458923465`, 0.3163311899231421}, {0.38970612078882877`, 
       0.33193880345965976`}, {0.37833708435679125`, 
       0.37298535121348786`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000007`, 1.}}], 
      ArrowBox[{{2.2542387286623917`, 0.03662089795037158}, {
       2.340157986785773, 0.041723213441400314`}, {2.4160659762862995`, 
       0.04685123901439722}, {2.4834411769833404`, 0.052000603216849815`}, {
       2.5443940735990354`, 0.05716453187174842}, {2.6363527450878372`, 
       0.06589046453249037}, {2.7167478105883855`, 0.07462348916676884}, {
       2.747945774930864, 0.07846188048743462}}]}, 
     {Arrowheads[{{0.009798545390833486, 1.}}], 
      ArrowBox[{{2.7602422451633073`, 0.07997475690773267}, {
       2.787768622191556, 0.0833614203936815}, {2.8516045319882255`, 
       0.09210207283232609}, {2.8597276606895146`, 0.09328083146228024}, {
       2.86774602273496, 0.09445961586784406}, {2.938663774104726, 
       0.1063648983949789}, {3., 0.11785798850123834`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{2.1535218942598577`, 0.3677137911626709}, {
       2.1950547738719024`, 0.3945139726914209}, {2.26743344004937, 
       0.4484151707853997}, {2.327930053746643, 0.5025969376737673}, {
       2.3789120198790217`, 0.5569387287689408}, {2.4213676397188846`, 
       0.6114157212163811}, {2.4567161932022996`, 0.665986256029127}, {
       2.483211591428917, 0.715132649517323}, {2.4874037420212662`, 
       0.7244854861413905}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{2.492471108880131, 0.7357909612909866}, {2.5052414385619297`,
        0.764282019643545}, {2.522805734601339, 0.8134343664077928}, {
       2.5359044795471437`, 0.8625896898100662}, {2.544831912847023, 
       0.911744127380621}, {2.5498822739486555`, 0.9608938166497129}, {
       2.551055562852042, 1.0100387576173417`}, {2.5483517795571813`, 
       1.0591789502835076`}, {2.547111452185138, 1.072307512998551}, {
       2.5455952682310103`, 1.0854323935107033`}, {2.5299854919761016`, 
       1.1500171793366043`}, {2.5070215009044765`, 1.2149242870793218`}, {
       2.5063109034562725`, 1.216626534367439}}]}, 
     {Arrowheads[{{0.019894138880162317`, 1.}}], 
      ArrowBox[{{2.5015382337586325`, 1.228059539186719}, {2.479937083913753, 
       1.2798054310930107`}, {2.4446118150848317`, 1.3446346476486433`}, {
       2.39990950420076, 1.4093880793952516`}, {2.3446939610445843`, 
       1.4740418689818686`}, {2.2765230970480186`, 1.5385503106461007`}, {
       2.2366636365214814`, 1.570732886346425}, {2.192954823642775, 
       1.6028676986255546`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-3., 0.09531443628845836}, {-2.9747456257229907`, 
       0.0914704885206437}, {-2.9014876758557553`, 
       0.08149361977468314}, {-2.853123838364016, 
       0.07550911682332316}, {-2.8514283517803394`, 
       0.07530710046053073}, {-2.8497282801838146`, 
       0.07510508500173552}, {-2.8073559340143244`, 
       0.07039975718167683}, {-2.7618082776825865`, 
       0.06568302565807967}, {-2.714327713419227, 
       0.06096565742824196}, {-2.6629813332926258`, 
       0.05624701578592321}, {-2.6069908216713826`, 
       0.051526743938319824`}, {-2.5455778629241, 
       0.04680448509262823}, {-2.507218370796721, 0.04414758185103807}}]}, 
     {Arrowheads[{{0.009671899632857939, 1.}}], 
      ArrowBox[{{-2.494858794394199, 
       0.043291517372929314`}, {-2.4773580692622423`, 
       0.042079360205183956`}, {-2.400947052897275, 
       0.03735049023232251}, {-2.332813543369247, 
       0.03357712120896316}, {-2.255589753708181, 0.02979837734164717}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-2.181480320773616, 
       1.6504446152627739`}, {-2.252298943420317, 
       1.6044861070706928`}, {-2.3121989334944013`, 
       1.5586027860630987`}, {-2.350743544792129, 
       1.5250695878310172`}, {-2.3857963743639474`, 
       1.4915577535971698`}, {-2.4454266883298517`, 
       1.4245981771241771`}, {-2.493123689302485, 
       1.3577013920790733`}, {-2.524760203655664, 1.3017423598562774`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-2.5308574883318706`, 
       1.2909574122524294`}, {-2.530921191192218, 
       1.29084473389681}, {-2.5597631674652144`, 
       1.2240170821595966`}, {-2.5805935915876383`, 
       1.1572073164496415`}, {-2.59377316925253, 
       1.0904062419755325`}, {-2.5997799663535983`, 
       1.0236052474076625`}, {-2.5981142141038505`, 
       0.9483286507665042}, {-2.5979075320753786`, 
       0.9457886339718724}, {-2.5976906434360494`, 
       0.9432486380704638}, {-2.584854616903291, 
       0.8771745101191646}, {-2.5645733402274784`, 
       0.810722513580547}, {-2.5644592078205535`, 0.8104119137204876}}]}, 
     {Arrowheads[{{0.019928797640467566`, 1.}}], 
      ArrowBox[{{-2.5601860614466116`, 
       0.798782975879596}, {-2.540151057992135, 
       0.744259730143171}, {-2.507446764637731, 
       0.6777753729082783}, {-2.4653681856490226`, 
       0.6112600993441604}, {-2.412823046510767, 
       0.5447045669191095}, {-2.3474031993049547`, 
       0.4780787425865408}, {-2.30896220470746, 
       0.4447282085624681}, {-2.2667004961135735`, 0.4113525932998696}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.8575653214919068`, 
       1.6365001194833226`}, {-1.9025180800004549`, 
       1.606864870322054}, {-1.9432524562761433`, 
       1.5772498407911386`}, {-1.9797684503189736`, 
       1.547655030890577}, {-2.043203362831259, 
       1.4885037623108799`}, {-2.095880888662515, 
       1.4293887569133306`}, {-2.1392153679153716`, 
       1.3703008087056552`}, {-2.17462114069246, 
       1.311230711695581}, {-2.190207651359734, 1.2784451095693852`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-2.1955270338106843`, 
       1.2672560012232756`}, {-2.202700110341792, 
       1.2521677214799838`}, {-2.224312672093305, 
       1.193102096677519}, {-2.2411700278628013`, 
       1.1282601953093105`}, {-2.251114584057671, 
       1.0634251697491777`}, {-2.251552104876142, 
       1.0590533316626196`}, {-2.251959281955452, 
       1.0546815905841938`}, {-2.2510885912428202`, 
       0.9906987113852573}, {-2.243680207539087, 
       0.9263927017242883}, {-2.2328336711899577`, 
       0.8620837659533216}, {-2.215110829550036, 
       0.7977689779623595}, {-2.2100461401985156`, 0.7847804013632639}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-2.205545247239417, 
       0.7732377007342436}, {-2.1900288305006974`, 
       0.7334452962319138}, {-2.1571048219233173`, 
       0.6691096792424964}, {-2.115284370444355, 
       0.6047526635284595}, {-2.0635130426902695`, 
       0.5403647856241549}, {-2.0226116748733376`, 
       0.4978676905523053}, {-1.9747461155178627`, 
       0.45531252116126136`}, {-1.9199163646238449`, 
       0.4126992774510232}, {-1.896264514180582, 0.39636667926228486`}}]}, 
     {Arrowheads[{{0.004703192160774998, 1.}}], 
      ArrowBox[{{-1.8860698040303467`, 
       0.38932680282919707`}, {-1.858122422191284, 
       0.3700279594215907}, {-1.7874615619515932`, 0.32730155773586017`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-2.940018478895236, 
       1.0880199084031503`}, {-2.945865521119212, 
       1.0176973285490005`}, {-2.9439178893722198`, 
       0.9473738196604586}, {-2.9387728360744885`, 
       0.9036571556914857}, {-2.938319238396435, 
       0.9007060732496422}, {-2.9200746863981832`, 
       0.8325972552488505}, {-2.8935453777547746`, 
       0.7640553119423701}, {-2.8622719507118597`, 
       0.695495729581675}, {-2.8215102868699335`, 
       0.6269008691125512}, {-2.8163909604605455`, 0.6201240047875407}}]}, 
     {Arrowheads[{{0.008502744677234058, 1.}}], 
      ArrowBox[{{-2.8089232498765253`, 
       0.6102383953539363}, {-2.7696537996003974`, 
       0.558254263974655}, {-2.7050959022746537`, 
       0.4895394476076431}, {-2.6671028040837514`, 0.4551419736692534}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.9833459295339921, 0.5385448888730809}, {
       1.0176001888748623`, 0.5530448133304917}, {1.0728267968658738`, 
       0.5835718091185961}, {1.1153593242358895`, 0.6152807432166789}, {
       1.1763397435887386`, 0.6797149385603509}, {1.2185331213038222`, 
       0.7440063049153451}, {1.247390697693452, 0.8076500098134868}, {
       1.2642827901078053`, 0.8703319319689672}, {1.2685471373336914`, 
       0.9119167611088443}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.269810968201945, 0.9242413181709421}, {1.2705797158970595`,
        0.9317379500959775}, {1.2646032167854084`, 1.021807941788176}, {
       1.2422472453189262`, 1.1076061067205203`}, {1.2045751073365059`, 
       1.1884841874670213`}, {1.15265010867704, 1.2637939266016907`}, {
       1.1214427167986531`, 1.2991033968631502`}, {1.0868719701614808`, 
       1.332506239318776}, {1.0613225128091837`, 1.3537196373785862`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.0517906127286891`, 1.3616338559815768`}, {
       1.048937868765523, 1.3640024539685678`}, {1.0076404126107805`, 
       1.3935920408125257`}, {0.939904260220308, 1.4335978376945735`}, {
       0.8652875467245769, 1.467936714907292}, {0.7846022748280229, 
       1.495935388300103}, {0.6986604472350819, 1.5169205737224283`}, {
       0.608960841261837, 1.5303957361789682`}, {0.5933176454043971, 
       1.5313260074602026`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.5809503065432833, 1.53206146971949}, {0.5170022342243714, 
       1.5358643406744226`}, {0.4607319491728738, 1.5352746632397514`}, {
       0.4051856337136261, 1.5317227026510891`}, {0.3503632878466282, 
       1.5252084589084358`}, {0.29626491157188006`, 1.5157319320117917`}, {
       0.24354932547307784`, 1.5035064855064717`}, {0.19287535013391752`, 
       1.4887454829377915`}, {0.1442429855543991, 1.4714489243057507`}, {
       0.09765223173452253, 1.4516168096103497`}, {0.09738888711135459, 
       1.4514822253312694`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.08635688549218946, 1.4458442367258186`}, {
       0.03726139273578356, 1.4207536105371188`}, {-0.01800381571058836, 
       1.3864618783556513`}, {-0.06814339360459315, 
       1.3487416130659473`}, {-0.11315734094623076`, 
       1.307592814668007}, {-0.16282056795637173`, 
       1.2508547482568806`}, {-0.2035825269691304, 
       1.1900768724578539`}, {-0.23520179502552924`, 
       1.1257171335517724`}, {-0.24706170256105542`, 1.096676328098542}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.2512099009169628, 
       1.085009664784391}, {-0.25975146222586115`, 
       1.0589825655440122`}, {-0.26575823600709914`, 
       1.0247961137570984`}, {-0.2692585120862565, 
       0.9898977064123093}, {-0.2707819199971294, 
       0.9189633497613716}, {-0.2605375339350387, 
       0.8459230135853443}, {-0.23633652111459863`, 
       0.7711757209014954}, {-0.20008445039659384`, 
       0.7039755034277799}, {-0.1448992359593598, 
       0.636683559987561}, {-0.13616011388043192`, 0.6288500805232945}}]}, 
     {Arrowheads[{{0.003340549182322256, 1.}}], 
      ArrowBox[{{-0.12693466612087645`, 
       0.6205806737201334}, {-0.10784239479991467`, 
       0.603466950628934}, {-0.060631107611174094`, 0.5712900681296461}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.2053320309215145`, 0.3794500944390804}, {
       1.2500673344626174`, 0.3846220438451524}, {1.3285173829346275`, 
       0.4017517357142424}, {1.3951890894233137`, 0.4253164341031932}, {
       1.4521361353083173`, 0.4536558836190697}, {1.5020436062223306`, 
       0.484586108689241}, {1.5459043196068967`, 0.517320923178753}, {
       1.5848516800623178`, 0.5511323666592856}, {1.6196576790004027`, 
       0.5855549446577765}, {1.6334581097549037`, 0.6026109012439274}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.641251054347116, 0.6122422038465437}, {1.6768455923245653`,
        0.6562335042086337}, {1.708812786720221, 0.7075372501787032}, {
       1.7350512196892045`, 0.7590291294689289}, {1.7555608912315173`, 
       0.8107091420793116}, {1.7703418013471581`, 0.8625772880098506}, {
       1.7797394473755048`, 0.9035558703042774}, {1.7860780373173268`, 
       0.9444219281948263}, {1.7853113410981063`, 1.0010810162684292`}, {
       1.778985778664957, 1.0577794938180705`}, {1.776733399512389, 
       1.0716924184878072`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{1.7747534776629195`, 1.0839223769795783`}, {
       1.7698344536454562`, 1.1143071416962842`}, {1.7550316034532527`, 
       1.1704931302316437`}, {1.734390448074746, 1.2262496295030987`}, {
       1.7077242074963357`, 1.281488809589599}, {1.674614199898816, 
       1.3360876411164835`}, {1.6346417434629807`, 1.38992309470909}, {
       1.5876487552509577`, 1.4415658591689926`}, {1.531616240235727, 
       1.491878427929136}, {1.523742941550838, 1.4978049801414532`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.5138446279853273`, 1.5052558434336687`}, {
       1.4665441984172882`, 1.5408608009895206`}, {1.3924326297956413`, 
       1.5885129783501464`}, {1.3430611730621045`, 1.6159318097925566`}, {
       1.2887392145138814`, 1.642141542728131}, {1.229466754150971, 
       1.6671421771568689`}, {1.1652437919733736`, 1.69093371307877}, {
       1.0955538075315094`, 1.712942597288011}, {1.070808621369679, 
       1.7193690085563518`}}]}, 
     {Arrowheads[{{0.011226448286042938`, 1.}}], 
      ArrowBox[{{1.05881722109821, 1.7224832170866}, {1.0198802803758, 
       1.7325952765787682`}, {0.9382232105062448, 1.7498917509510408`}, {
       0.8505825979228432, 1.7648320204048291`}, {0.7856036082814698, 
       1.7736218201837752`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.8010812436361543`, 0.3683043132572407}, {
       1.8461283822460823`, 0.39469827461244117`}, {1.8867375759761629`, 
       0.4217072305196555}, {1.9576453714073812`, 0.47678220586757725`}, {
       2.016807872540407, 0.5327413191784569}, {2.064844056329153, 
       0.5874117460834928}, {2.1057916366362814`, 0.6422390020888287}, {
       2.1396506134617934`, 0.6972230871944646}, {2.1473322149964327`, 
       0.7130454489428234}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{2.1527430794075846`, 0.7241906058086814}, {
       2.1664209868056883`, 0.7523640014004006}, {2.1870292372846802`, 
       0.8075872146124592}, {2.2024018455154826`, 0.8628181967364632}, {
       2.2125388114980966`, 0.9180569477724123}, {2.217440135232522, 
       0.973303467720307}, {2.2183456369738037`, 0.9952125021868771}, {
       2.218476484090583, 1.0171050371315482`}, {2.210399315047707, 
       1.0794660336544506`}, {2.195762193026001, 1.1420619724479628`}, {
       2.1775994383778174`, 1.2045916668441679`}, {2.177505830025945, 
       1.2048233196944755`}}]}, 
     {Arrowheads[{{0.01767581944820243, 1.}}], 
      ArrowBox[{{2.172864139410324, 1.2163101244490322`}, {
       2.1523854184766784`, 1.2669888724457585`}, {2.11948708424742, 
       1.329204511340468}, {2.078271386614877, 1.39118950561603}, {
       2.0274593826783947`, 1.4528579175917544`}, {1.965772129537318, 
       1.514123809586952}, {1.9108378800244303`, 1.560132805323379}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{2.822402288387534, 0.7005759537153966}, {2.8536811640174804`,
        0.7703747038491}, {2.8759712271261133`, 0.8401683367105786}, {
       2.890028620487774, 0.9099590564300046}, {2.896099042979376, 
       0.9797502678414324}, {2.8944666288570176`, 1.0495422370295628`}, {
       2.8873815284004367`, 1.1064800376638364`}, {2.875025463216748, 
       1.1634156718601218`}, {2.8692934276624196`, 1.181654177241283}}]}, 
     {Arrowheads[{{0.019999999999999993`, 1.}}], 
      ArrowBox[{{2.865578858643403, 1.1934733968535676`}, {
       2.8571324860719867`, 1.2203485287565319`}, {2.83343664973219, 
       1.2772779974911788`}, {2.829856852345632, 1.2849400594267337`}, {
       2.826164145962719, 1.2926010887545938`}, {2.791020937134317, 
       1.3498465002409792`}, {2.7480533437806973`, 1.4074029680745213`}, {
       2.7003019935479067`, 1.4649554445707098`}, {2.642983129556775, 
       1.5224999383921913`}, {2.57377735016264, 1.5800290240805022`}, {
       2.570714534907817, 1.5822347261740766`}}]}, 
     {Arrowheads[{{0.005711128397407009, 1.}}], 
      ArrowBox[{{2.560661023067458, 1.589474814220241}, {2.5338470915726985`, 
       1.6087850043277951`}, {2.4903652537208414`, 1.6375352761771798`}, {
       2.4419062839574117`, 1.6662776776654316`}}]}}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{3., 1.6144245609946102`}, {2.9976795931835225`, 
       1.6160865494215746`}, {2.9556490332837893`, 1.6435288019515988`}, {
       2.9497296013257226`, 1.647230013226598}, {2.943733348061411, 
       1.6509308257557331`}, {2.889184623200007, 1.680768748849341}, {
       2.827652783174548, 1.710747610628161}, {2.7615096712681018`, 
       1.7407271871460828`}, {2.686144015599683, 1.7707081931422086`}, {
       2.5984705440400355`, 1.8006891991944793`}, {2.549192020908738, 
       1.815579265416884}}]}}}},
  AspectRatio->NCache[
    Rational[1, 3], 0.3333333333333333],
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm]},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "TransparentPolygonMesh" -> True},
  PlotRange->{{-3.0972969590480606`, 
   3.0972969590480606`}, {-0.0972969590480607, 2.0972969590480606`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.8172904464483643`*^9, 3.8172904754869337`*^9}, {
   3.817290509704429*^9, 3.8172905966612864`*^9}, {3.8172906307300415`*^9, 
   3.817290653258271*^9}, {3.8172907304490275`*^9, 3.817290744204835*^9}, 
   3.8172907996545095`*^9, 3.8172909446100426`*^9, {3.8172909793940287`*^9, 
   3.817290991945172*^9}, 3.8172929847310786`*^9, 3.8172931067993107`*^9, 
   3.817293213963773*^9, 3.817646031761448*^9, 3.8177216153717537`*^9, 
   3.817722473741862*^9, 3.8212006512333727`*^9, 3.821200682031401*^9, 
   3.8212836360414295`*^9, 3.821371183716861*^9, 3.821457898364238*^9, 
   3.8215200234076576`*^9, 3.821604453361253*^9, 3.8218883968466153`*^9, 
   3.8222992059203424`*^9, 3.8223319185323725`*^9, 3.8225076325144196`*^9, 
   3.8226475809646854`*^9, 3.8227524849389243`*^9, 3.82276679140746*^9, 
   3.823009980346203*^9, 3.823505430704644*^9, 3.8235961030196953`*^9, 
   3.8237885413999624`*^9, 3.8240274940663824`*^9, 3.8241233914646835`*^9, 
   3.824224446141206*^9, 3.824243777448612*^9, 3.8242438917853427`*^9, 
   3.824295562991311*^9, 3.8245421915571313`*^9, 3.82543132588354*^9, 
   3.825596805078966*^9, 3.8279381626034937`*^9, 3.8280897608186693`*^9, 
   3.828089906717835*^9, 
   3.8280903138407745`*^9},ExpressionUUID->"63116d3e-ef6f-4afd-a7a7-\
2a7005f39f19"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Advective velocity fields from the background flow and streamlines in the \
channel, with illustration for a parameter choice\
\>", "Subsection",
 CellChangeTimes->{{3.805531086984949*^9, 3.805531121049476*^9}, {
  3.814950878350466*^9, 3.8149508793109155`*^9}, {3.814973353183139*^9, 
  3.814973354535365*^9}, {3.815138181273883*^9, 3.8151381871442375`*^9}, {
  3.8212009518455777`*^9, 3.821200952099865*^9}, {3.828090242973968*^9, 
  3.8280902524747095`*^9}},ExpressionUUID->"5a7aed8e-04c9-4219-a117-\
140c1f16f4e1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ub", "=", 
  RowBox[{"U0", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], "-", 
     RowBox[{"4", " ", "\[Epsilon]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"y", "-", 
             RowBox[{"h", "/", "2"}]}], ")"}], "/", "h"}], ")"}], "^", "2"}], 
        ",", "0"}], "}"}]}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.8054429535392632`*^9, 3.805443063385191*^9}, 
   3.8054430982956114`*^9, {3.805443144957147*^9, 3.8054431547937756`*^9}, {
   3.805443194032325*^9, 3.805443235066763*^9}, {3.8055313829619217`*^9, 
   3.8055313947230873`*^9}, {3.8148714226472135`*^9, 3.81487147864624*^9}, {
   3.814871869323143*^9, 3.814871923083482*^9}, {3.8149508710136285`*^9, 
   3.8149508895450583`*^9}, 3.814961527013486*^9, 3.815138170179143*^9, {
   3.815138204511809*^9, 3.8151382071648426`*^9}, {3.815138241870607*^9, 
   3.8151383178442183`*^9}, {3.8152100635929155`*^9, 
   3.8152100639037375`*^9}, {3.821200734386749*^9, 3.821200775419338*^9}, {
   3.821200818981752*^9, 3.821200819198984*^9}, 
   3.8215202486249027`*^9},ExpressionUUID->"e9f4a164-a195-4842-8a9a-\
1e1f84066568"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"U0", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            FractionBox["h", "2"]}], "+", "y"}], ")"}], "2"], " ", 
        "\[Epsilon]"}], 
       SuperscriptBox["h", "2"]]}], ")"}]}], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.8215202490006084`*^9, 3.821604453604581*^9, 
  3.821888396942918*^9, 3.8222992059958725`*^9, 3.8223319186894016`*^9, 
  3.822507632566205*^9, 3.8226475811043096`*^9, 3.8227524851333475`*^9, 
  3.822766791497667*^9, 3.823010016565323*^9, 3.8235054395312495`*^9, 
  3.8235961031084585`*^9, 3.8237885415296183`*^9, 3.8240274941754656`*^9, 
  3.824123391579362*^9, 3.8242244463716483`*^9, 3.824243777543169*^9, 
  3.824295563189184*^9, 3.824542191697645*^9, 3.8254313264194407`*^9, 
  3.8255968053603396`*^9, 3.827938191802951*^9, 3.82808976098223*^9, 
  3.8280899068685884`*^9, 
  3.828090313996006*^9},ExpressionUUID->"a3cc52be-cd1d-42a7-8a87-\
d31c127f1437"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Ub", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"U0", "\[Rule]", "0.032"}], ",", 
      RowBox[{"\[Epsilon]", "\[Rule]", ".46"}], ",", 
      RowBox[{"h", "\[Rule]", "0.13"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", ".13"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<y\>\"", ",", "\"\<Example of a velocity profile\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.815212955257843*^9, 3.8152130142591057`*^9}, {
  3.821200785744781*^9, 3.821200844514832*^9}, {3.8215199883256783`*^9, 
  3.8215199886539364`*^9}, {3.8215202994855146`*^9, 3.821520320662918*^9}, {
  3.821520428014797*^9, 3.8215204626946387`*^9}, {3.823010006654992*^9, 
  3.8230100725235524`*^9}, {3.8235053601031947`*^9, 3.8235053725897126`*^9}, {
  3.828089627765818*^9, 
  3.8280896293878126`*^9}},ExpressionUUID->"0dd38033-59a0-452b-9b99-\
9c5b9a0a1e9f"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt2Hc0lv//B3D5lLSQrSiiRIiWkXqWlNEwU2lYX6X6GBENRRRZGbc97ysk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       "]]},
     Annotation[#, "Charting`Private`Tag$3286#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.017280001201632627`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["\"Example of a velocity profile\"", TraditionalForm], None}, {
     FormBox["\"y\"", TraditionalForm], None}},
  FrameTicks->FrontEndValueCache[{{Automatic, 
      Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
      Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{
     Automatic, {{0.0175, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.02, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.0225, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.025, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.0275, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.03, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.0325, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.015, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.0155, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.016, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.0165, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.017, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.018, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.0185, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.019, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.0195, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.0205, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.021, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.0215, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.022, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.023, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.0235, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.024, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.0245, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.0255, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.026, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.0265, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.027, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.028, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.0285, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.029, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.0295, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.0305, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.031, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.0315, 
        FormBox[
         InterpretationBox[
          StyleBox[
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.032, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.033, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.0335, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.034, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.0345, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.035, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}}}, {Automatic, {{0., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.025, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.05, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.075, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.1, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.125, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-0.025, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-0.02, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-0.015, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-0.01, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {-0.005, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.005, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.01, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.015, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.02, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.03, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.035, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.04, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.045, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.055, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.06, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.065, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.07, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.08, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.085, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.09, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.095, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.105, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.11, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.115, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.12, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.13, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.135, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.14, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.145, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}, {0.15, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
        0.}, {
         AbsoluteThickness[0.1]}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 0.13}, {0.017280001201632627`, 0.03199999965121947}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.815212992715415*^9, 3.8152130146808357`*^9}, 
   3.8153119631748476`*^9, 3.8153145038543806`*^9, 3.8155980537863145`*^9, 
   3.8157543187255793`*^9, 3.817721219071454*^9, {3.821200776682062*^9, 
   3.821200845009152*^9}, 3.8212022444965677`*^9, 3.821202451505419*^9, 
   3.821202636937358*^9, 3.821283636295594*^9, 3.821371184167468*^9, 
   3.8214578986893764`*^9, 3.821520023628068*^9, {3.8215203138475885`*^9, 
   3.821520321218341*^9}, {3.821520429163769*^9, 3.8215204632638845`*^9}, 
   3.821604453736246*^9, 3.821888397000868*^9, 3.822299206049859*^9, 
   3.822331918814767*^9, 3.8225076326089544`*^9, 3.8226475812299795`*^9, 
   3.8227524852824326`*^9, 3.8227667915679455`*^9, {3.8230100138162436`*^9, 
   3.8230100188200235`*^9}, 3.823010073269285*^9, 3.8235054404260807`*^9, 
   3.8235961031792684`*^9, 3.8237885416542845`*^9, 3.8240274942577972`*^9, 
   3.8241233916727934`*^9, 3.824224446519643*^9, 3.8242437776190376`*^9, 
   3.8242955632779465`*^9, 3.8245421917662544`*^9, 3.8254313266665325`*^9, 
   3.8255968056421623`*^9, 3.82793819289566*^9, 3.828089761056032*^9, 
   3.828089906972307*^9, 
   3.828090314090767*^9},ExpressionUUID->"dee860c0-9f84-4081-8b2b-\
04346485d1d9"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Gradients of the velocity fields in the global coordinate system (U is Eq. \
(7) and UREV is used for the computation of Eq. (8))\
\>", "Subsection",
 CellChangeTimes->{{3.8055314215086265`*^9, 3.805531466952278*^9}, {
  3.82809038246935*^9, 3.828090411812262*^9}, {3.8280905238666115`*^9, 
  3.8280905463282475`*^9}},ExpressionUUID->"79b175f2-b88d-4de3-bde9-\
993e124a9fe2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"U", "=", 
  RowBox[{
   RowBox[{"Uw", "+", "Ub"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "xf"}], ",", 
     RowBox[{"y", "\[Rule]", "yf"}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.815138194285493*^9, 3.8151382016505737`*^9}, {
   3.8212010580124173`*^9, 3.821201103985366*^9}, {3.821201647354354*^9, 
   3.8212016767058816`*^9}, {3.821203496162004*^9, 3.8212035072170057`*^9}, {
   3.828089863218028*^9, 3.828089866635334*^9}, 
   3.828090526222562*^9},ExpressionUUID->"2fea7b61-f2c4-49f7-a7c5-\
0968993fea05"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"U0", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             FractionBox["h", "2"]}], "+", "yf"}], ")"}], "2"], " ", 
         "\[Epsilon]"}], 
        SuperscriptBox["h", "2"]]}], ")"}]}], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Theta]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Theta]"}]]}], ")"}], " ", 
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox["r0", "2"], " ", "v", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"Csc", "[", 
           FractionBox[
            RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], "2"]}]}], ")"}]}], 
     RowBox[{"24", " ", 
      SuperscriptBox["h", "2"]}]]}], ",", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Theta]"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Theta]"}]]}], ")"}], " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     SuperscriptBox["r0", "2"], " ", "v", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          FractionBox[
           RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], "2"]}]}], ")"}]}], 
    RowBox[{"24", " ", 
     SuperscriptBox["h", "2"]}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8280905265626526`*^9},ExpressionUUID->"4311b189-0ec2-48a6-ae5c-\
9bb1066b74c7"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"UREV", "=", 
   RowBox[{"UwallGEN", "+", "Ub"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GradUREV", "=", 
   RowBox[{"Limit", "[", 
    RowBox[{
     RowBox[{"Limit", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"UREV", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"UREV", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "y"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"UREV", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}], ",", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"UREV", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "y"}], "]"}]}], "}"}]}], 
        "}"}], ",", 
       RowBox[{"y", "\[Rule]", "yf"}]}], "]"}], ",", 
     RowBox[{"x", "\[Rule]", "xf"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.824226913651553*^9, 3.824227040643757*^9}, {
  3.8242270734047985`*^9, 3.8242270863759003`*^9}, {3.8242272205444984`*^9, 
  3.8242272301344194`*^9}, {3.8242273087795677`*^9, 
  3.8242273135284133`*^9}},ExpressionUUID->"b98c687b-3264-425a-a64d-\
9cd610d8afd2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Bias on the fish from the hydrodynamics (Eq. (8))", "Subsection",
 CellChangeTimes->{{3.8055315331114902`*^9, 3.8055315513228188`*^9}, {
   3.8055319915570817`*^9, 3.8055319965524645`*^9}, {3.8153154227762704`*^9, 
   3.8153154602874746`*^9}, {3.823010626316663*^9, 3.823010626662695*^9}, {
   3.8242262809085617`*^9, 3.824226296354628*^9}, 3.8242271990013657`*^9, {
   3.824295574254281*^9, 3.824295578762314*^9}, 3.8280897892030735`*^9, {
   3.8280905711263742`*^9, 
   3.82809059617128*^9}},ExpressionUUID->"1b41f998-c616-4d2b-8717-\
5b378cedd250"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[CapitalOmega]", "=", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dot", "[", 
     RowBox[{
      RowBox[{"GradUREV", ".", " ", "vperp"}], ",", "vuv"}], "]"}]}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.824227281445531*^9, 3.824227283649027*^9}, 
   3.824228747257251*^9, {3.8279384221951103`*^9, 
   3.827938422916789*^9}},ExpressionUUID->"81b0a8ff-86ce-44ab-aebd-\
e668f52fb1f2"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "16"}], " ", "h", " ", "U0", " ", 
      RowBox[{"(", 
       RowBox[{"h", "-", 
        RowBox[{"2", " ", "yf"}]}], ")"}], " ", "\[Epsilon]", " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "-", 
     RowBox[{
      SuperscriptBox["\[Pi]", "3"], " ", 
      SuperscriptBox["r0", "2"], " ", "v", " ", 
      RowBox[{"Cot", "[", 
       FractionBox[
        RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        FractionBox[
         RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], "2"]}]}], ")"}]}], 
  RowBox[{"4", " ", 
   SuperscriptBox["h", "3"]}]]], "Output",
 CellChangeTimes->{
  3.8242272862188563`*^9, 3.824228755128106*^9, 3.824243856551587*^9, 
   3.8242955861355305`*^9, 3.824542213252367*^9, 3.825431373083994*^9, 
   3.825596883462761*^9, {3.827938417906796*^9, 3.827938424164844*^9}, 
   3.828090599341777*^9},ExpressionUUID->"e59162d8-fb8f-44d8-a4be-\
834c9e72e3f4"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Feedback system based on local circulation, with only the bottom half capable \
of sensing (note that the K here incorporates r0 and l with respect to Eq. \
(9))\
\>", "Subsection",
 CellChangeTimes->{{3.8055315331114902`*^9, 3.8055315513228188`*^9}, {
  3.8055319915570817`*^9, 3.8055319965524645`*^9}, {3.8153154227762704`*^9, 
  3.815315496475273*^9}, {3.822756570170831*^9, 3.8227566031266365`*^9}, {
  3.825166652870926*^9, 3.8251666758057084`*^9}, {3.8251667489387374`*^9, 
  3.8251668534293313`*^9}, {3.825431596126466*^9, 3.825431612948655*^9}, {
  3.828089816228507*^9, 3.82808981677807*^9}, {3.8280906083488626`*^9, 
  3.828090675822214*^9}},ExpressionUUID->"de7aaef4-7931-49ff-b06d-\
9a7c21a44b4c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"vort", "[", "y_", "]"}], "=", 
  RowBox[{"-", " ", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ub", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", "y"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8227527626502113`*^9, 3.822752790089136*^9}, {
   3.8227532701173053`*^9, 3.822753273345586*^9}, {3.8227557804250593`*^9, 
   3.82275578287951*^9}, 
   3.8242243273289566`*^9},ExpressionUUID->"32e2705c-011a-4ea0-8e83-\
8273057f9983"],

Cell[BoxData[
 FractionBox[
  RowBox[{"8", " ", "U0", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["h", "2"]}], "+", "y"}], ")"}], " ", "\[Epsilon]"}], 
  SuperscriptBox["h", "2"]]], "Output",
 CellChangeTimes->{3.824224328130146*^9, 3.8242244608836184`*^9, 
  3.824228760039102*^9, 3.8242438592354383`*^9, 3.824295586163465*^9, 
  3.8245422132855372`*^9, 3.8254313731468287`*^9, 3.82559688366398*^9, 
  3.8280906782035666`*^9},ExpressionUUID->"e336d554-85c8-4fe8-a043-\
5bd33d0e3468"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[CapitalOmega]1feedback", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"K", " ", 
     RowBox[{"vort", "[", "y", "]"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"y", "\[Rule]", "yf"}], ",", 
      RowBox[{"x", "\[Rule]", "xf"}]}], "}"}]}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.8054433340359793`*^9, 3.8054434126379213`*^9}, {
   3.805444057799914*^9, 3.8054440929183054`*^9}, 3.805531452600999*^9, {
   3.8055318936802607`*^9, 3.805531895061591*^9}, {3.815315500120554*^9, 
   3.81531550544339*^9}, {3.8153155514413476`*^9, 3.8153155517357235`*^9}, {
   3.8153156469190245`*^9, 3.815315659033388*^9}, {3.8153156897530975`*^9, 
   3.815315689891796*^9}, 3.8157541465182633`*^9, {3.815754212064299*^9, 
   3.8157542172196894`*^9}, {3.8212026947637978`*^9, 3.821202701270759*^9}, {
   3.8212033053160048`*^9, 3.821203314090239*^9}, {3.822752681207218*^9, 
   3.822752741916895*^9}, {3.822752783306731*^9, 3.82275280911211*^9}, 
   3.822752849482691*^9, 3.8227532611012554`*^9, 3.8227559846295133`*^9, {
   3.8251665837008*^9, 3.8251666129151115`*^9}, {3.8254312438349047`*^9, 
   3.8254312440384903`*^9}, {3.8254316161751766`*^9, 
   3.825431620261198*^9}},ExpressionUUID->"99c2d43a-0f0b-456a-8c24-\
fceb7787ba7a"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"4", " ", "K", " ", "U0", " ", 
    RowBox[{"(", 
     RowBox[{"h", "-", 
      RowBox[{"2", " ", "yf"}]}], ")"}], " ", "\[Epsilon]"}], 
   SuperscriptBox["h", "2"]]}]], "Output",
 CellChangeTimes->{{3.805443348472967*^9, 3.805443413803772*^9}, {
   3.8054440648494277`*^9, 3.8054440940859118`*^9}, 3.8055142395025597`*^9, 
   3.805514363306446*^9, 3.805515167770255*^9, 3.8055315711309795`*^9, 
   3.805537411819643*^9, 3.8055378525365524`*^9, 3.805556608396994*^9, 
   3.805560506823824*^9, 3.8056057133686953`*^9, 3.805625954330659*^9, 
   3.8056288136410933`*^9, 3.8056303521287546`*^9, 3.8057022175614843`*^9, 
   3.8077286226965303`*^9, 3.8077306637992964`*^9, 3.8142994926438694`*^9, 
   3.8143553108509316`*^9, 3.8143882365410676`*^9, 3.81487248537538*^9, 
   3.8149510166163025`*^9, 3.814957391477314*^9, 3.8149718355695553`*^9, 
   3.8149733399906797`*^9, 3.814973646036525*^9, 3.815061636778019*^9, 
   3.8151379210269146`*^9, 3.8151383295392303`*^9, 3.8152118748132434`*^9, 
   3.8153119651021814`*^9, 3.815314505413456*^9, {3.8153156603280025`*^9, 
   3.8153156903166604`*^9}, 3.8155980549043593`*^9, 3.8157543204260297`*^9, 
   3.8177212208150034`*^9, {3.8212026973131323`*^9, 3.82120270174471*^9}, 
   3.8212033146761007`*^9, 3.821203543564314*^9, 3.821283644324932*^9, 
   3.821371202220807*^9, 3.821457912694564*^9, 3.8215209092062283`*^9, 
   3.821604466977191*^9, 3.8218884029498672`*^9, 3.822299212963642*^9, 
   3.822331926148288*^9, 3.822507638010438*^9, 3.8226475934409003`*^9, 
   3.822752497954723*^9, {3.8227528677123985`*^9, 3.8227528713399916`*^9}, 
   3.8227532616757174`*^9, 3.822756006115634*^9, 3.8227667977846794`*^9, 
   3.8230106388260365`*^9, 3.8235054633398857`*^9, 3.8235961085464363`*^9, 
   3.8237885539410267`*^9, 3.8240274997516794`*^9, 3.8241233971363688`*^9, 
   3.8242244610779805`*^9, 3.8242287601390953`*^9, 3.824243860176346*^9, 
   3.824295586306076*^9, 3.824542213470667*^9, 3.825431373405327*^9, 
   3.8254316211980047`*^9, 3.825596883793215*^9, 
   3.8280906790493145`*^9},ExpressionUUID->"3dbe42ff-fbb8-4ddf-a049-\
dec3f969030b"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Analysis of governing equations", "Section",
 CellChangeTimes->{{3.821283654646096*^9, 
  3.821283668118924*^9}},ExpressionUUID->"de155fe0-aa37-4baa-af88-\
503a92d2f551"],

Cell[CellGroupData[{

Cell["3D equations for xf, yf, and \[Theta]", "Subsection",
 CellChangeTimes->{{3.798278590652874*^9, 3.798278602984374*^9}, {
  3.808153400857582*^9, 3.808153414320389*^9}, {3.8081537159108133`*^9, 
  3.8081537273540177`*^9}, {3.8212839605705924`*^9, 3.82128396519608*^9}, {
  3.8230106621512833`*^9, 
  3.8230106710105224`*^9}},ExpressionUUID->"7f73b979-91a0-437c-b44b-\
59b8160f2c07"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"v", " ", "vuv"}], "+", "U"}], ")"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.8212837121279097`*^9, 
  3.8212837147224693`*^9}},ExpressionUUID->"48e08968-e2d9-48fa-8717-\
6797ef25e0c9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"U0", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"h", "-", 
            RowBox[{"2", " ", "yf"}]}], ")"}], "2"], " ", "\[Epsilon]"}], 
        SuperscriptBox["h", "2"]]}], ")"}]}], "+", 
    RowBox[{"v", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Theta]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Theta]"}]]}], ")"}], " ", 
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox["r0", "2"], " ", "v", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"Csc", "[", 
           FractionBox[
            RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], "2"]}]}], ")"}]}], 
     RowBox[{"24", " ", 
      SuperscriptBox["h", "2"]}]]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Theta]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Theta]"}]]}], ")"}], " ", 
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox["r0", "2"], " ", "v", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"Csc", "[", 
           FractionBox[
            RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], "2"]}]}], ")"}]}], 
     RowBox[{"24", " ", 
      SuperscriptBox["h", "2"]}]], "+", 
    RowBox[{"v", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8212837097470226`*^9, 3.8212837155193167`*^9}, 
   3.821284059664033*^9, 3.821371202307002*^9, 3.8214579136669655`*^9, 
   3.8215209094585695`*^9, 3.8216044676045213`*^9, 3.821888403296999*^9, 
   3.8222992134667816`*^9, 3.8223319264827785`*^9, 3.8225076382602744`*^9, 
   3.822647593995861*^9, 3.8227560166813917`*^9, 3.822766798096859*^9, 
   3.8230106807649784`*^9, 3.823505479349143*^9, 3.8235961088313227`*^9, 
   3.8237885545341077`*^9, 3.824027500046956*^9, 3.824123397428425*^9, 
   3.824228768931134*^9, 3.8242439009074807`*^9, 3.824295597109314*^9, 
   3.8245422141945024`*^9, 3.825431374475329*^9, 3.8254316294208975`*^9, 
   3.825596884958392*^9, 
   3.82809069615821*^9},ExpressionUUID->"491620c1-147d-413b-9883-\
0a8e75e103a2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"\[CapitalOmega]", "+", "\[CapitalOmega]1feedback"}], ")"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.821283727546935*^9, 
  3.8212837289101315`*^9}},ExpressionUUID->"931efe91-7d76-4290-bb1e-\
c3d0c439e2b5"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"16", " ", "h", " ", "K", " ", "U0", " ", 
     RowBox[{"(", 
      RowBox[{"h", "-", 
       RowBox[{"2", " ", "yf"}]}], ")"}], " ", "\[Epsilon]"}], "+", 
    RowBox[{"16", " ", "h", " ", "U0", " ", 
     RowBox[{"(", 
      RowBox[{"h", "-", 
       RowBox[{"2", " ", "yf"}]}], ")"}], " ", "\[Epsilon]", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}], "+", 
    RowBox[{
     SuperscriptBox["\[Pi]", "3"], " ", 
     SuperscriptBox["r0", "2"], " ", "v", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"Cot", "[", 
      FractionBox[
       RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       FractionBox[
        RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], "2"]}]}], 
   RowBox[{"4", " ", 
    SuperscriptBox["h", "3"]}]]}]], "Output",
 CellChangeTimes->{3.8212837296271486`*^9, 3.821284059802663*^9, 
  3.8213712027179594`*^9, 3.8214579141931252`*^9, 3.8215209096576157`*^9, 
  3.8216044679817753`*^9, 3.8218884034495907`*^9, 3.822299213757189*^9, 
  3.822331926629583*^9, 3.82250763838958*^9, 3.8226475943808317`*^9, 
  3.822756017029462*^9, 3.822766798311161*^9, 3.8230106809849377`*^9, 
  3.823505479628759*^9, 3.8235961090106277`*^9, 3.823788554949815*^9, 
  3.8240275002212043`*^9, 3.824123397608018*^9, 3.824228769163514*^9, 
  3.8242439020694356`*^9, 3.8242955982016497`*^9, 3.82454221469548*^9, 
  3.825431375578105*^9, 3.825431630286231*^9, 3.8255968861393175`*^9, 
  3.8280906964524293`*^9},ExpressionUUID->"21fca52c-e3b3-4e08-8ea0-\
1a4592571f3b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f3D", "[", 
   RowBox[{"xf_", ",", "yf_", ",", "\[Theta]_"}], "]"}], "=", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"v", " ", "vuv"}], "+", "U"}], ")"}], ",", 
     RowBox[{"{", 
      RowBox[{"(", 
       RowBox[{"\[CapitalOmega]", "+", "\[CapitalOmega]1feedback"}], ")"}], 
      "}"}]}], "]"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.8212837586976643`*^9, 3.8212838068509493`*^9}, {
  3.8212839688019104`*^9, 3.8212839691231956`*^9}, {3.8246722987067275`*^9, 
  3.8246723023730288`*^9}},ExpressionUUID->"dadf0ebc-d924-4153-9aa9-\
8a1a3136ffd6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"U0", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"h", "-", 
            RowBox[{"2", " ", "yf"}]}], ")"}], "2"], " ", "\[Epsilon]"}], 
        SuperscriptBox["h", "2"]]}], ")"}]}], "+", 
    RowBox[{"v", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Theta]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Theta]"}]]}], ")"}], " ", 
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox["r0", "2"], " ", "v", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"Csc", "[", 
           FractionBox[
            RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], "2"]}]}], ")"}]}], 
     RowBox[{"24", " ", 
      SuperscriptBox["h", "2"]}]]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Theta]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Theta]"}]]}], ")"}], " ", 
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox["r0", "2"], " ", "v", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"Csc", "[", 
           FractionBox[
            RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], "2"]}]}], ")"}]}], 
     RowBox[{"24", " ", 
      SuperscriptBox["h", "2"]}]], "+", 
    RowBox[{"v", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"16", " ", "h", " ", "K", " ", "U0", " ", 
       RowBox[{"(", 
        RowBox[{"h", "-", 
         RowBox[{"2", " ", "yf"}]}], ")"}], " ", "\[Epsilon]"}], "+", 
      RowBox[{"16", " ", "h", " ", "U0", " ", 
       RowBox[{"(", 
        RowBox[{"h", "-", 
         RowBox[{"2", " ", "yf"}]}], ")"}], " ", "\[Epsilon]", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["\[Pi]", "3"], " ", 
       SuperscriptBox["r0", "2"], " ", "v", " ", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
       RowBox[{"Cot", "[", 
        FractionBox[
         RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], " ", 
       SuperscriptBox[
        RowBox[{"Csc", "[", 
         FractionBox[
          RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], "2"]}]}], 
     RowBox[{"4", " ", 
      SuperscriptBox["h", "3"]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.821283797432561*^9, 3.821283807251161*^9}, 
   3.821284059853527*^9, 3.821371202975767*^9, 3.82145791424051*^9, 
   3.8215209096765656`*^9, 3.8216044680401564`*^9, 3.821888403476503*^9, 
   3.8222992137920017`*^9, 3.8223319266503983`*^9, 3.8225076384124084`*^9, 
   3.822647594421249*^9, 3.822756017062375*^9, 3.822766798400828*^9, 
   3.823010681010603*^9, 3.8235054796507006`*^9, 3.823596109035575*^9, 
   3.823788554987718*^9, 3.824027500254713*^9, 3.8241233976455297`*^9, 
   3.8242287691890645`*^9, 3.824243903792128*^9, 3.824295599333873*^9, 
   3.824542214810232*^9, 3.8246723043065543`*^9, 3.825431375725711*^9, 
   3.825431630342082*^9, 3.8255968863410807`*^9, 
   3.8280906964753685`*^9},ExpressionUUID->"c8239a17-879d-47a7-bcca-\
72c5e3d51275"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"f3D", "[", 
    RowBox[{"xf", ",", "yf", ",", "\[Theta]"}], "]"}], ",", "xf"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8212838644908533`*^9, 3.8212839023924437`*^9}, {
  3.8212839715511947`*^9, 
  3.8212839718480606`*^9}},ExpressionUUID->"168d5913-c8b1-4082-8c99-\
fabdeeb6ec85"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.8212839026570883`*^9, 3.8212840598924246`*^9, 
  3.8213712030402145`*^9, 3.8214579142853956`*^9, 3.821520909690527*^9, 
  3.821604468081507*^9, 3.8218884034964504`*^9, 3.8222992138195057`*^9, 
  3.822331926668318*^9, 3.8225076384313803`*^9, 3.822647594453165*^9, 
  3.822756017090806*^9, 3.8227667984603987`*^9, 3.823010681024669*^9, 
  3.8235054796746364`*^9, 3.823596109056552*^9, 3.823788555010651*^9, 
  3.824027500319343*^9, 3.82412339767913*^9, 3.82422876921029*^9, 
  3.824243905084902*^9, 3.8242956007177954`*^9, 3.824542214847825*^9, 
  3.825431375776575*^9, 3.8254316303949404`*^9, 3.825596886427154*^9, 
  3.828090696499304*^9},ExpressionUUID->"6bc24e3f-7e1a-4625-bafc-\
4d8493e3c0e2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"f3D", "[", 
     RowBox[{"xf", ",", "yf", ",", "\[Theta]"}], "]"}], ",", "yf"}], "]"}], "//",
   "Simplify"}]], "Input",
 CellChangeTimes->{{3.8212839147866497`*^9, 3.821283919662975*^9}, {
  3.8212839746253223`*^9, 
  3.821283975158662*^9}},ExpressionUUID->"225b1870-6a45-4cd5-859b-\
b485bc23ebd1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"16", " ", "h", " ", "U0", " ", 
      RowBox[{"(", 
       RowBox[{"h", "-", 
        RowBox[{"2", " ", "yf"}]}], ")"}], " ", "\[Epsilon]"}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Theta]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Theta]"}]]}], ")"}], " ", 
      SuperscriptBox["\[Pi]", "3"], " ", 
      SuperscriptBox["r0", "2"], " ", "v", " ", 
      RowBox[{"Cot", "[", 
       FractionBox[
        RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        FractionBox[
         RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], "2"]}]}], 
    RowBox[{"4", " ", 
     SuperscriptBox["h", "3"]}]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Theta]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Theta]"}]]}], ")"}], " ", 
      SuperscriptBox["\[Pi]", "3"], " ", 
      SuperscriptBox["r0", "2"], " ", "v", " ", 
      RowBox[{"Cot", "[", 
       FractionBox[
        RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        FractionBox[
         RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], "2"]}], 
     RowBox[{"4", " ", 
      SuperscriptBox["h", "3"]}]]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"8", " ", "K", " ", "U0", " ", "\[Epsilon]"}], 
     SuperscriptBox["h", "2"]], "+", 
    FractionBox[
     RowBox[{"8", " ", "U0", " ", "\[Epsilon]", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}], 
     SuperscriptBox["h", "2"]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[Pi]", "4"], " ", 
      SuperscriptBox["r0", "2"], " ", "v", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", 
         FractionBox[
          RowBox[{"2", " ", "\[Pi]", " ", "yf"}], "h"], "]"}]}], ")"}], " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        FractionBox[
         RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], "4"]}], 
     RowBox[{"4", " ", 
      SuperscriptBox["h", "4"]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.821283915599403*^9, 3.821283920516355*^9}, 
   3.821284059936305*^9, 3.821371203941387*^9, 3.8214579150297966`*^9, 
   3.8215209099192066`*^9, 3.821604468802699*^9, 3.821888403845485*^9, 
   3.8222992143219767`*^9, 3.822331926957801*^9, 3.822507638692428*^9, 
   3.8226475950283604`*^9, 3.8227560174900565`*^9, 3.8227667988021927`*^9, 
   3.8230106812737756`*^9, 3.823505480006339*^9, 3.823596109337161*^9, 
   3.823788555540236*^9, 3.8240275006392493`*^9, 3.824123397939467*^9, 
   3.8242287694083242`*^9, 3.824243906658925*^9, 3.824295602028485*^9, 
   3.8245422154537263`*^9, 3.825431376454114*^9, 3.8254316312047033`*^9, 
   3.8255968878539968`*^9, 
   3.8280906971022005`*^9},ExpressionUUID->"a7447647-ad53-4f46-9e15-\
c8be55ce119d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"f3D", "[", 
     RowBox[{"xf", ",", "yf", ",", "\[Theta]"}], "]"}], ",", "\[Theta]"}], 
   "]"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.821283924645194*^9, 3.8212839283215404`*^9}, {
  3.821283989768609*^9, 
  3.8212839940095778`*^9}},ExpressionUUID->"73275d49-93b1-4acc-b8aa-\
ed2db1b64b70"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Theta]"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Theta]"}]]}], ")"}], " ", 
     "v", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"12", " ", 
        SuperscriptBox["h", "2"]}], "-", 
       RowBox[{"7", " ", 
        SuperscriptBox["\[Pi]", "2"], " ", 
        SuperscriptBox["r0", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "12"}], " ", 
           SuperscriptBox["h", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["\[Pi]", "2"], " ", 
           SuperscriptBox["r0", "2"]}]}], ")"}], " ", 
        RowBox[{"Cos", "[", 
         FractionBox[
          RowBox[{"2", " ", "\[Pi]", " ", "yf"}], "h"], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       FractionBox[
        RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], "2"]}], 
    RowBox[{"48", " ", 
     SuperscriptBox["h", "2"]}]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Theta]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Theta]"}]]}], ")"}], " ", 
      "v", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "12"}], " ", 
         SuperscriptBox["h", "2"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", 
         SuperscriptBox["r0", "2"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"12", " ", 
            SuperscriptBox["h", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["\[Pi]", "2"], " ", 
            SuperscriptBox["r0", "2"]}]}], ")"}], " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"2", " ", "\[Pi]", " ", "yf"}], "h"], "]"}]}]}], ")"}], 
      " ", 
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        FractionBox[
         RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], "2"]}], 
     RowBox[{"48", " ", 
      SuperscriptBox["h", "2"]}]]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"32", " ", "h", " ", "U0", " ", 
        RowBox[{"(", 
         RowBox[{"h", "-", 
          RowBox[{"2", " ", "yf"}]}], ")"}], " ", "\[Epsilon]", " ", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["\[Pi]", "3"], " ", 
        SuperscriptBox["r0", "2"], " ", "v", " ", 
        RowBox[{"Cot", "[", 
         FractionBox[
          RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          FractionBox[
           RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], "2"]}]}], ")"}], " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}], 
    RowBox[{"4", " ", 
     SuperscriptBox["h", "3"]}]]}], "}"}]], "Output",
 CellChangeTimes->{3.8212839290915847`*^9, 3.821284059984177*^9, 
  3.821371204890648*^9, 3.821457915859187*^9, 3.8215209101362286`*^9, 
  3.8216044694584465`*^9, 3.8218884041808987`*^9, 3.822299214643997*^9, 
  3.82233192728214*^9, 3.8225076389767914`*^9, 3.82264759560485*^9, 
  3.822756018142311*^9, 3.8227667993180647`*^9, 3.8230106817702465`*^9, 
  3.8235054806715393`*^9, 3.8235961099053307`*^9, 3.82378855650415*^9, 
  3.8240275010822816`*^9, 3.8241233983648047`*^9, 3.8242287696581197`*^9, 
  3.8242439084408755`*^9, 3.8242956040162477`*^9, 3.824542216076844*^9, 
  3.825431377260127*^9, 3.8254316320471888`*^9, 3.82559689043847*^9, 
  3.8280906975914087`*^9},ExpressionUUID->"c6b9322a-2efd-4b53-a4fe-\
41b8128b5b39"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Simplification to 2 D, since axial coordinate is given by other two variables \
(\[Alpha]=\[Epsilon] U0/v,
\[Rho]2=r0^2/h^2, \[Eta]=y/h, tND=h/v, bl=BL/h)\
\>", "Subsection",
 CellChangeTimes->{{3.8212839839317646`*^9, 3.8212840323472605`*^9}, {
   3.822756166438156*^9, 3.822756210105573*^9}, {3.8227562795522385`*^9, 
   3.822756288585524*^9}, {3.8227563718042917`*^9, 3.822756394239072*^9}, {
   3.8227564326599884`*^9, 3.822756438962731*^9}, 
   3.823010689441888*^9},ExpressionUUID->"62b9a25c-9c27-4a6c-81c0-\
24059b0be9fc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f2D", "[", 
   RowBox[{"yf_", ",", "\[Theta]_"}], "]"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"f3D", "[", 
      RowBox[{"xf", ",", "yf", ",", "\[Theta]"}], "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}], ",", 
    RowBox[{
     RowBox[{"f3D", "[", 
      RowBox[{"xf", ",", "yf", ",", "\[Theta]"}], "]"}], "[", 
     RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.821284037628783*^9, 
  3.821284091645812*^9}},ExpressionUUID->"454c1729-2d9a-4f4f-96cd-\
07057cbdadd3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Theta]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Theta]"}]]}], ")"}], " ", 
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox["r0", "2"], " ", "v", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"Csc", "[", 
           FractionBox[
            RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], "2"]}]}], ")"}]}], 
     RowBox[{"24", " ", 
      SuperscriptBox["h", "2"]}]], "+", 
    RowBox[{"v", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"16", " ", "h", " ", "K", " ", "U0", " ", 
       RowBox[{"(", 
        RowBox[{"h", "-", 
         RowBox[{"2", " ", "yf"}]}], ")"}], " ", "\[Epsilon]"}], "+", 
      RowBox[{"16", " ", "h", " ", "U0", " ", 
       RowBox[{"(", 
        RowBox[{"h", "-", 
         RowBox[{"2", " ", "yf"}]}], ")"}], " ", "\[Epsilon]", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["\[Pi]", "3"], " ", 
       SuperscriptBox["r0", "2"], " ", "v", " ", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
       RowBox[{"Cot", "[", 
        FractionBox[
         RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], " ", 
       SuperscriptBox[
        RowBox[{"Csc", "[", 
         FractionBox[
          RowBox[{"\[Pi]", " ", "yf"}], "h"], "]"}], "2"]}]}], 
     RowBox[{"4", " ", 
      SuperscriptBox["h", "3"]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8212840600741873`*^9, 3.821284092067171*^9, 
  3.8213712049674416`*^9, 3.821457915914039*^9, 3.8215209101818123`*^9, 
  3.821604469525076*^9, 3.821888404208077*^9, 3.8222992147026377`*^9, 
  3.8223319273084545`*^9, 3.822507638996909*^9, 3.8226475956347685`*^9, 
  3.8227560560392275`*^9, 3.8227667993848248`*^9, 3.823010701601904*^9, 
  3.823505480743292*^9, 3.8235961099352455`*^9, 3.82378855658592*^9, 
  3.824027501120304*^9, 3.8241233984563065`*^9, 3.824228777240508*^9, 
  3.824243912985772*^9, 3.8242956146859665`*^9, 3.824542216196082*^9, 
  3.8254313774101686`*^9, 3.82543163908683*^9, 3.825596890659943*^9, 
  3.8280907364279957`*^9},ExpressionUUID->"dc23f3cc-95eb-4815-9977-\
edd9b773b57b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f2DND", "[", 
   RowBox[{"\[Eta]_", ",", "\[Theta]_"}], "]"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "\[Theta]", "]"}], 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["\[Pi]", "2"], " "}], 
         RowBox[{"12", " "}]], "\[Rho]2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox[
            RowBox[{"Csc", "[", 
             RowBox[{"\[Pi]", " ", "\[Eta]"}], "]"}], "2"]}]}], ")"}]}]}], 
      ")"}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", "\[Alpha]", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", "\[Eta]"}]}], ")"}], 
      RowBox[{"(", 
       RowBox[{"K", "+", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}], ")"}]}], "-", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["\[Pi]", "3"], " "}], "4"], "\[Rho]2", " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}], 
      RowBox[{"Cot", "[", 
       RowBox[{"\[Pi]", " ", "\[Eta]"}], "]"}], 
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"\[Pi]", " ", "\[Eta]"}], "]"}], "2"]}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.8212849597208276`*^9, 3.8212851187030735`*^9}, {
   3.8212852808367815`*^9, 3.821285289645157*^9}, {3.82128534148769*^9, 
   3.821285422929249*^9}, {3.821285653097086*^9, 3.8212856540328455`*^9}, 
   3.822756335974723*^9, {3.8227564465288506`*^9, 3.82275645876832*^9}, {
   3.8230106936914883`*^9, 3.823010706078105*^9}, {3.824228859481691*^9, 
   3.8242289056298857`*^9}, {3.825431499790526*^9, 3.8254315000959225`*^9}, {
   3.825431637002267*^9, 
   3.825431637327095*^9}},ExpressionUUID->"c483075f-6571-45d2-ba4d-\
9cad20f3bfb1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{
       FractionBox["1", "12"], " ", 
       SuperscriptBox["\[Pi]", "2"], " ", "\[Rho]2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox[
           RowBox[{"Csc", "[", 
            RowBox[{"\[Pi]", " ", "\[Eta]"}], "]"}], "2"]}]}], ")"}]}]}], 
     ")"}], " ", 
    RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], " ", "\[Alpha]", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", "\[Eta]"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"K", "+", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     SuperscriptBox["\[Pi]", "3"], " ", "\[Rho]2", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"Cot", "[", 
      RowBox[{"\[Pi]", " ", "\[Eta]"}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"\[Pi]", " ", "\[Eta]"}], "]"}], "2"]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8212854235398264`*^9, 3.8212856544982586`*^9, 3.821371205248222*^9, 
   3.8214579159803796`*^9, 3.821520910200282*^9, 3.821604469575647*^9, 
   3.8218884042356825`*^9, 3.8222992147281275`*^9, 3.8223319273339033`*^9, 
   3.822507639015729*^9, 3.8226475956656885`*^9, 3.822756479015307*^9, 
   3.822766799407381*^9, 3.8230107321271906`*^9, 3.8235054807732315`*^9, 
   3.823596109968157*^9, 3.823788556615839*^9, 3.8240275011559825`*^9, 
   3.8241233984974585`*^9, {3.8242288808297663`*^9, 3.8242289061695538`*^9}, 
   3.8242439152304087`*^9, 3.8242956172553124`*^9, 3.82454221624125*^9, 
   3.8254313774615803`*^9, 3.8254315021627717`*^9, 3.825431639956456*^9, 
   3.825596890751079*^9, 
   3.828090736463929*^9},ExpressionUUID->"7e78b011-3ec9-41a9-9b9a-\
e2e2dcab12c8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"f2DND", "[", 
      RowBox[{"\[Eta]", ",", "\[Theta]"}], "]"}], "-", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"f2D", "[", 
          RowBox[{
           RowBox[{"\[Eta]", " ", "h"}], ",", "\[Theta]"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], "/", 
        RowBox[{"(", "v", ")"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"f2D", "[", 
          RowBox[{
           RowBox[{"\[Eta]", " ", "h"}], ",", "\[Theta]"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}], "/", 
        RowBox[{"(", 
         RowBox[{"v", "/", "h"}], ")"}]}]}], "}"}]}], ")"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Rho]2", "\[Rule]", 
      RowBox[{
       RowBox[{"r0", "^", "2"}], "/", 
       RowBox[{"h", "^", "2"}]}]}], ",", 
     RowBox[{"\[Alpha]", "\[Rule]", 
      RowBox[{"U0", " ", 
       RowBox[{"\[Epsilon]", "/", "v"}]}]}], ",", 
     RowBox[{"bl", "\[Rule]", 
      RowBox[{"BL", "/", "h"}]}]}], "}"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.8212854307225504`*^9, 3.821285510779167*^9}, {
   3.821285556149107*^9, 3.8212856240505*^9}, {3.8227564864400434`*^9, 
   3.822756504939775*^9}, 
   3.8230107377942753`*^9},ExpressionUUID->"1237e049-5a2b-467b-ae85-\
0476d0ce67b8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.821285468258097*^9, {3.8212855039049797`*^9, 3.821285511111929*^9}, 
   3.821285556883319*^9, {3.821285605094593*^9, 3.8212856244426174`*^9}, 
   3.8212856552691483`*^9, 3.8213712053260093`*^9, 3.821457916024263*^9, 
   3.821520910215225*^9, 3.821604469604441*^9, 3.821888404260597*^9, 
   3.8222992147491245`*^9, 3.8223319273551903`*^9, 3.8225076390390697`*^9, 
   3.822647595758442*^9, {3.822756480296301*^9, 3.8227565052983665`*^9}, 
   3.8227667994281015`*^9, 3.823010738565297*^9, 3.823505480801507*^9, 
   3.823596110001069*^9, 3.823788556649748*^9, 3.8240275011918836`*^9, 
   3.824123398531593*^9, {3.8242288817770925`*^9, 3.8242289067449675`*^9}, 
   3.8242439161810155`*^9, 3.824295623150324*^9, 3.824542216276155*^9, 
   3.8254313775772457`*^9, 3.825431509592414*^9, 3.825431641318981*^9, 
   3.8255968908745184`*^9, 
   3.8280907364918203`*^9},ExpressionUUID->"f0e85548-5e43-48d5-be1d-\
829ccb90576c"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
2D equation centered around zero, so that we shift \[Eta] up of 1/2 (the new \
coordinate is called \[Xi] as in the paper; note that we verify Eq. (10)). We \
also plot some of the key functions to support the claims in the text\
\>", "Subsection",
 CellChangeTimes->{{3.8212839839317646`*^9, 3.8212840323472605`*^9}, {
  3.8212888912782707`*^9, 3.821288905563458*^9}, {3.823010772591675*^9, 
  3.8230108052952805`*^9}, {3.8280907884616437`*^9, 3.828090797365692*^9}, {
  3.828090830183835*^9, 
  3.8280909078443007`*^9}},ExpressionUUID->"0b4d4cde-29ef-467f-adf7-\
8eff66489937"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f2DNDcent", "[", 
   RowBox[{"\[Xi]_", ",", "\[Theta]_"}], "]"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "\[Theta]", "]"}], 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["\[Pi]", "2"], " "}], 
         RowBox[{"12", " "}]], "\[Rho]2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox[
            RowBox[{"Csc", "[", 
             RowBox[{"\[Pi]", " ", 
              RowBox[{"(", 
               RowBox[{"\[Xi]", "+", 
                RowBox[{"1", "/", "2"}]}], ")"}]}], "]"}], "2"]}]}], 
         ")"}]}]}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"4", " ", "\[Alpha]", " ", 
      RowBox[{"(", 
       RowBox[{"2", "\[Xi]"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"K", "+", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}], ")"}]}], "-", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["\[Pi]", "3"], " "}], "4"], "\[Rho]2", " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}], 
      RowBox[{"Cot", "[", 
       RowBox[{"\[Pi]", " ", 
        RowBox[{"(", 
         RowBox[{"\[Xi]", "+", 
          RowBox[{"1", "/", "2"}]}], ")"}]}], "]"}], 
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"\[Pi]", " ", 
         RowBox[{"(", 
          RowBox[{"\[Xi]", "+", 
           RowBox[{"1", "/", "2"}]}], ")"}]}], "]"}], "2"]}]}]}], 
   "}"}]}]], "Input",
 CellChangeTimes->{{3.8212849597208276`*^9, 3.8212851187030735`*^9}, {
  3.8212852808367815`*^9, 3.821285289645157*^9}, {3.82128534148769*^9, 
  3.821285422929249*^9}, {3.821285653097086*^9, 3.8212856540328455`*^9}, {
  3.8212889125000544`*^9, 3.821288992463581*^9}, {3.822756553866395*^9, 
  3.8227565543990803`*^9}, {3.823010793306551*^9, 3.823010812007594*^9}, {
  3.824228935391329*^9, 3.8242289748303633`*^9}, {3.8254315180766244`*^9, 
  3.825431518339157*^9}, {3.8254316458778925`*^9, 
  3.825431646180925*^9}},ExpressionUUID->"a55b3f5c-c4f8-4769-a7fc-\
5cf104b9f734"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{
       FractionBox["1", "12"], " ", 
       SuperscriptBox["\[Pi]", "2"], " ", "\[Rho]2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox[
           RowBox[{"Csc", "[", 
            RowBox[{"\[Pi]", " ", 
             RowBox[{"(", 
              RowBox[{
               FractionBox["1", "2"], "+", "\[Xi]"}], ")"}]}], "]"}], 
           "2"]}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
   RowBox[{
    RowBox[{"8", " ", "\[Alpha]", " ", "\[Xi]", " ", 
     RowBox[{"(", 
      RowBox[{"K", "+", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"]}], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     SuperscriptBox["\[Pi]", "3"], " ", "\[Rho]2", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"Cot", "[", 
      RowBox[{"\[Pi]", " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], "+", "\[Xi]"}], ")"}]}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"\[Pi]", " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], "+", "\[Xi]"}], ")"}]}], "]"}], "2"]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8212854235398264`*^9, 3.8212856544982586`*^9, 3.8212889931273456`*^9, 
   3.8213712059233093`*^9, 3.8214579194686384`*^9, 3.8215209112838078`*^9, 
   3.821604472308486*^9, 3.821888405791363*^9, 3.822299216579919*^9, 
   3.822331928632657*^9, 3.8225076401243267`*^9, 3.8226475982427125`*^9, 
   3.8227566223849463`*^9, 3.8227668009005737`*^9, 3.823010813850893*^9, 
   3.8235054808396373`*^9, 3.8235961100359783`*^9, 3.8237885566936307`*^9, 
   3.8240275012296906`*^9, 3.8241233985653367`*^9, {3.8242289421682463`*^9, 
   3.8242289753081727`*^9}, 3.824243917626236*^9, 3.824295625200302*^9, 
   3.824542216322206*^9, 3.8254313776317425`*^9, 3.8254315188445153`*^9, 
   3.825431646734044*^9, 3.8255968909788814`*^9, 
   3.828090842514846*^9},ExpressionUUID->"60466528-2598-4fba-ad8a-\
99266468a3bc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f2DNDcent", "[", 
    RowBox[{"\[Xi]", ",", "\[Theta]"}], "]"}], "-", 
   RowBox[{"f2DND", "[", 
    RowBox[{
     RowBox[{"\[Xi]", "+", 
      RowBox[{"1", "/", "2"}]}], ",", "\[Theta]"}], "]"}]}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.8230108231661043`*^9, 
  3.8230108519046116`*^9}},ExpressionUUID->"a3fc5b76-7d0e-4fab-af91-\
8fd420654f98"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.8230108460263767`*^9, 3.823010852473641*^9}, 
   3.823505480866565*^9, 3.823596110063901*^9, 3.8237885567235537`*^9, 
   3.8240275012637978`*^9, 3.8241233985986505`*^9, {3.824228943267435*^9, 
   3.8242289760057697`*^9}, 3.8242439185196924`*^9, 3.8242956285275636`*^9, 
   3.824542216369573*^9, 3.8254313776833134`*^9, 3.825431520201277*^9, 
   3.8254316480127153`*^9, 3.825596891057785*^9, 
   3.8280908435932226`*^9},ExpressionUUID->"b966d50b-3928-4335-9c9a-\
af52f99c0ff1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[Pi]", "2"], " "}], 
      RowBox[{"12", " "}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"\[Pi]", " ", 
           RowBox[{"(", 
            RowBox[{"\[Xi]", "+", 
             RowBox[{"1", "/", "2"}]}], ")"}]}], "]"}], "2"]}]}], ")"}]}], 
    ")"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Xi]", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}]}], "}"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Theta]\>\"", ",", "\"\<\[Xi]\>\"", ",", 
      "\"\<effect of wall on ydot\>\""}], "}"}]}], ",", 
   RowBox[{"Contours", "\[Rule]", "20"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "Hue"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8247150249663005`*^9, 3.8247151409935646`*^9}, {
   3.824715192671945*^9, 3.824715221617838*^9}, {3.824715272567954*^9, 
   3.824715352855175*^9}, {3.8247153896386304`*^9, 3.8247154011886415`*^9}, {
   3.824715446035857*^9, 3.82471549049403*^9}, {3.8247155733458633`*^9, 
   3.8247155927370443`*^9}, 
   3.8247158021555586`*^9},ExpressionUUID->"08ce9476-892a-4aee-b516-\
6fd47c432478"],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx0nQmcj9X3x2fMbgazmC0iES2yE5L72FNURLRTUVkrRAtli0hlqRBlyZIl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   "], {{
     {Hue[0.], EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtU0lrlEEULDIoQTPd+YZMnM9JxBmV6EFFbxGNmIgJSNwwYMBBiIrgwQVE
L3p0QcUFPUg8uWBO7uTmSb0LIrnoDzBBcQti3KuoPnxUz5vq96ree10bObzj
UBOAYX4Fft+KwCSxHoFHGdBgsDsHBirA2CxgvA78JecK4/0BaOH3mOf9xL3k
neX5E++d4u9x8k8Sn8z3+Xkr83QA18npLAG/iuavJ2dtyXm6y8A/xq/y3Mf4
q3bgPfU8qAG/M8ffVq1J2nqJa/i7q5k5iHer1vaV3N7gs/QuC+a8IS5stccJ
5n4a7Os4sSlY2ybixQ7rka77bfRBToH8W/Q/PRe4Q/zBvGfIeR2cSzknO4Fd
uTUvYJ2eYI64B6LjX3i+RH1bGK/MA25Ee1lMbnvJGtSnezVzxP2Z5qL59KVe
SeNM0Tk/E8+RN8h4ZM4XuX0tKrueOOJuZ84Rco7lrqe6DWIl+O7N6P/E2cBe
bs2tfypzr8XvqVu3tF3IvBOqpZqajWZUKNm/6mqGyqv8o0SUzdE8R1N8J+vv
q7jP6rf6KL9j3J1qcK3d5J5OHm/Txx/WPd/C+RI3p9lphsXoPAeDP52PEj9k
9iJPE8G7px2cSvGh3HsgLyeCd1d7+4zYzHrv5gCziR8z39W+a6fF2UbtK4L7
tpr1h5JmaV+S+qw5r4vOszR4TvIiTxuj7yqH9kyaH7IPe9KbUk3ttPb5O+NH
gvfwcnQ93V0ZPDOdX5I7nXZGu7O87P5ovwaC+693NpNy6t30l+1F73UwvWu9
b/VdXhrEVdE9v0b8D5GgmvM=
         "]], PolygonBox[CompressedData["
1:eJwlln1o1lUUx2/NSKz9Hl2bsRdrTz7Pk26mgiMTSs2YhJk2FQ0VF4WUmS3U
IC2VzVWUWiFSIUXlyjRDc2oEEZoUM4Ne6OWvSGbWbGVSWFS26vPh/PGFc37n
3nPvPS/f88vf2Tbn/gtTSs+DQeCS2pSOZSlV5lJqrE/pkatS6kDeCNYhryik
dLI8pSdZM214Sn8UU2rClsCJupS2Ya/EthK9J896cDtyC98WVKQ0o5TSZvQt
YCby3OqUDmLrAHdXpXSE/SuQHwbN6L/ifxxrL0bfOTSlSejdyO+DETUp7WJ9
Cfkp8AD3+fLylLqy+KZtPW/Is/837vwMeg/v+wnbbL5VcH4z/o6jzwe93G8x
62uw1YFW5FGsWYCcAxehD7B+IvIkcAr9Y973IPJI0IvtZvApvq4Gbw/Dxn1e
yiKGxtIYGst2MBnfz3KnKuyr0Y/j6x30xeifgDHcdTt6dRY5MTevVaZ0n+9l
/a3sb9EH8iDw5gjiyppT2BvAe5x/lP1bkbeBr5E3cH5nLs707OtBF/pesBRf
H3DfV7CtAuc5q4/3NGLr119t5MTcrAVTkVfzrRf5ITAKvXBFSkOMlT65T443
TUOeCi7Afzn6FN8OhiA34f8t9tZ5H+7b7Z2y8KnvCfhcg3zSM2sjh+bSmBrb
W8j5JuQb8Zfhbw/2xize4FvO8oaVWdSEtVHJ+seRq1g/lvw1YL8L/XVQwV3m
cccd2CaA34vRA/bCY9gvHR573PsReo77nLuSc9GXo79cGd+01YAXChEjY2VM
jM1p6v0w+mj0/fjq4Yx/0P8Ek+mfLew5Ux45NbeVvGk6crM5Rh8MZiH3sX57
bfjQ19P2DPcrYZ+fi5q1dvvxP8a92J8YGjVurS+xv7F34//eXPSsvds6ktii
HwDPYe/kW195xNhYWyPWyqtgOrZhvGdvFjVqrbZw3mnkMrCB867ljp8hfw4m
Iq8hHhvtDe9QHTVpba7D3zxqsx08mosatVYH2HM2izf4FnvEXrHn7D1jbKy9
g3dpY80vWfS4vS7nyD3GxNh8z51yWXCW3GVMja05MTd3kIOBLDhH7pHD5LJV
4Fg+3uTb7Al7Ywc1XpYLDpFLZlNjLyK3yVGF4Ai54jrwH/ZNfOsnnpehN9QH
Z8ld9ry9v4g1P2YRQ2NpD9lL1oS1YQ7N5RmwFPss7tSC/SZQVgqOlCvP26/Y
29nzQ3nkwFyYA3MhR8lVrnGtNWgt2qP26jXoR+jHQ+y/AfkoWAjfHuS85bmo
GWvHGeAs8AzP2o2Pv9D/NefFqGlr+29woBicL/fXgiX1ERNjc0j/xH8fPpeh
3wPGlYLj5Lpl2A/jfzDrd2aRQ3NpjVqr+51RpYDyPtCGvIs7f8jaN8DYYvSo
veoMchbJQXKRNW6td6EvQl8IRpdiRjgr7Al7w5gbe2vMWpMz5A7v5N2WULPr
5XrQVIozPXsPGF8Mjpar5Ty5z5gYG2Nm7Jw5zp6fuc/mQuTAXJhjc23NWDsV
4JticJ7cJ8fKtcbM2Jkjc2WP2qtyhtzhzHH22GP2mmd4ljVpbTpTna1ysFws
p8gtcqrc6pt8m5wpd07Bx1r08eBcMWaks9J/BP8VvKN3dWY5u4ypsZ2L/m1F
cKxcO8f+z8fMdHZ+Bzpro+asvXflx2Jwntxnj9grcobcYcyN/Uy+fZXFjHHW
yHFyXSvYnY8Z46yxZ+1dZ7azuwA66uMNvmUruK0UM8fZYw/YCzOwf5HFP4D/
As5YZ61nevYJUJ+Lfw7/PexJe9OZ4myx5q19/zH815BT5Bb3uPd/LUlX0w==

         "]], PolygonBox[CompressedData["
1:eJwlkktIlGEUhl+SQkq/aeK3LJWcyVugaLiaqBlIUUm85AWGxAxJxIWXamFF
baYwMcIubl2k4AVBzdSNRgW1bVHhSnJRixLBFhKIFD4/Z/HCec73nvOd8/1/
qL23oeeApDx0EE2HpLaA1Ipqk6QJ+GNQaicuJ1eBPHKH0Pph6SL81UmXc6UP
OVIv8U10n2Y30qWsY9IItdXk/qHrmVJhhvSZuNUXZ/P0Hw9LO0ekPnKjqO6E
9CRoMzTDj5F3XKqn5xK9H8Dd6D13JnHHc3xV8LZ/D/2bT0oD5KLwImqEo8y4
QrzqrEdlmvQW7yZciZ7h3+XOEnwz8DeUnyydxzPGvjWcp5NrYedxOIV5BuAm
Z2eD1H5nlkZ4OGD7vGKveh73BfwSDaUwH7lrzLOML+bvRm0bvB20eI3cT/SU
e9+xXxdxP5pk5ir23/Ok23CZs73FHn89m/8SuVv+O8BX6blE/CdV+oUtDs+G
LO5kli40B59Js95v8C6gCPtfyLDdz8IP0V080bB9r1z4HrUx+BG+H/AXZ++9
xQ4RvK+Ja/w6VApv8N1FTYezszLe6X/Y3uMc+TjqZpbJU9JvrDvM/AnvFNxE
voHzYmf/4RU4kS3lkAsHzJ99lF08++9SyTn//U9LBdx9h7oKZ/9hEdyJEnCB
s384mX77kWdr7A==
         "]]}]}, 
     {Hue[0.04085237558315841], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtk8tvzFEUx7/RGs00mJlOYh5kHpmOxl49EiVECG20jASpoa1aECRskNZU
SyIaiT+ADY2qhYrXopvWSj3+ACTEY4dESG08wufmnMXJ93vPPffc7/2e36/Q
e2Ln8XmSuog64mVB2t4o7WgiB/8dlSrg9aTUB79WlPakpbMLpH3gPfbWUN9A
/UHWA+QLMenLMukDfCIj3aRmJTU3wDHn7xPSqqxUbpBawaG8dIr+I3m7I9y1
H15bKt1BWIn6EeraqL8IjhIb4JfBW/RspecEGCXecnYheJ9YS/4huAttp9Gz
G7ziZ7/FCde5BH61JJ3k7DnuXe3aHpEfzFu+BiZZz8A/wluIdfDl4HwiB28p
S/XOI2A+Zu8ahv/ISQn4dzCCn5/rpY28dYZ7/0SkzhR3s36F5iNJ8zH4eSlr
PgadQe+g1wyAs0U728XZTcQv+BS5Lc7f5My74OEZ3t5HPkKfHnCvz7E7bV4H
z3vBqbh52Ihvm9OmM+jtZ6+ffB8452+ZJH/btY2DR1m/RtsQGla4P6O872/R
+nSWLQKfa5a2us5paj4lbI7j3Ps1brO+kLXvLOj8R/1i9t7RcxE4nLWZZvBp
lvU2zj4tWK/Qs6Nse6Gmkjavw70NaPzZbJ5UqFlP/jFn28Bn3qeD7/lYyeYY
ZvvC/4vnYMw1TKOx232rgu0pm0WYSdXz7fQ/4P9FFSz7LMJ3HW2y7/MB/Sb9
P7oLHvIZPeH+WtH8PA+OZcyHMLcerzmcshmH94b5h/eE/nXgf75yi6s=
         "]], PolygonBox[CompressedData["
1:eJwtlltMl2Ucxx+VEtMmf+QQKAQI/1BQa+mFBqEQeCyU2WrRsjKsm5Q2vVDa
OmnLxLrLpraVoqWpJSTVBc4El3cdVnqRZbkOiutkpSsV+3z2vBef7d37f97n
d/7+/qWPrmpZOTyEsAUyoHZ8CDWwNjeEdTC/IoR50JsK4UO4xvO6kSEcuSGE
H0tC6CkPoRtW880amM43t/stzx3QzvlV8CnPx+FcQQhn4SDfdkNxdghF8PCE
EB6B69L4kY5nPFvOXRNhJnfMgpezQtgIbTyvgDn8NhvKi0OogN/w8VdYzreP
wR58ewfa80J4CuqwcSf08O0H3undic/6fol3F+E0Z76Hafg4FcbiexZU81wF
Y7jrRthZFMIOaOSbpsSntiRmY3+COx+HzNIQRsE27tgKrfz2IGTjYwq24uM2
aOHdEniGGJ+F97j7AGzmt1dgMWebYZAYz8MxGIAc7s4tjTEa60ec/RjOkNsf
oIqcVsMQtq/CIDbOwybO1FLLNujkeSHvFsBVGILj1q4i5szcjeOObFg2kZpB
VU4IkyGbM+MSfM6EUTASn64vjXd691RyMQXy8Ckf7oIG6OTuzXAHvs1KetBe
PExsfbCIb++Gw9CX+KRvDcRaD8/h+/NwAF/2wwjeZSQ1slYvccdGmIftudBd
SA/AjrIQ3oKd0OUz374JC4hxIewn9/tgOrZmwFpyv3dECJfJVwtxreBMGzRh
ey7M4veZUA8N8B82/4UuYtkFZ0ri7DhDXdh/g2+2l8cesBecEWfFHJvrk/h+
As7hw2BR7Al74xd8OQsr8eFJuI8c3g97ebcHvoAv4V5iWgoPwTIoyA/hJtiE
T53Qgo0l6RijsTrDznIlOZoEWZwdCxs4+2IqzoCzoM/6fo07h8qiD/qyhhhW
wxzO1MNsfusdje+ISyPvJ2NrEnyHr6ezY4/YKz8R088wDJsBrmDrKjTx3JjM
uLP+B7X5Hb7Cp6/zY4/b69XYmmK/QN/4mHNz78w4O8ZorHX2ckXsAXthC2de
S8UZdpaXlsbaWuN/OHcJWxcTm9o2JmMbSGbPmlrbCzz/lYo5NtfTsTUjHWMw
lm84cwrm0+PzJkTNU/tq8a2mPPaQveRMOptqnFrXlfRmM7Euhk+46wjcg5/N
ycw7+2qm2nkb395aEWfIWcqld3LyooapZW9z5+6sOEPO0ut8swVegPXpqHlq
X0Mym99y5hTsIvbdcBDb76dij9vrxmisaoBacAwfB+Ayz1dyokaoFdrQlhqv
1v/JnRdgeUnUHjWokudWZuKBwlgja7WB3KxXl4hhETwNHfAu7/bBSThRHnvc
XleD1WI1T+2zR+wVd4C7wB3iLinCRnFh9FFf7Tl7T01QG46So/6saENbxmRs
7jR32yHe9UI/HE180BdrbK1HYDsj0Ti1zppbezW/NdF4td6esXfsMXttODka
lo41ttba0JY5MTdqkFpkz9q77lB3aUeSGzVBbehLZmGAGvUXxB3qLlVj1doa
ey871tzar4L2dNQEtcGesXfcSe6m0dw1ZnzUhMpEw9XyXnJ+qCza0JYapBal
uesWuJkcFsNn3PV5XpxRZ9UespfUALVADVaL7Ql7wx61V9VUtTWTu0al4453
17sT3Y3u1Mxkx7hrrKm19T+J/01eVQNSUfPUPmMwFne4u9z/AD2JZqqd7gh3
hZqn9mlT2+5sd/ffFVHL1LS6slhja+1OdbdOc8clM+gsmmNz7X8M/2uocWqd
/zH8r/E/p1xhMw==
         "]], PolygonBox[CompressedData["
1:eJwtk1tI03EUx09u2ZhUbrPWFNsmOssie8ksyESpzG1tWkEPkuK0oqigMkq8
To3o/tDlKeimVpBGpYFQWT10hXrqAllavaRdKHrqYn3+nP/Dh/Pn/M75nsvv
9/dXby/fliAi+TARggGRUghBzC5yOkXk+XSRZ9DjF1mUJHIVWw6/OS/D7vKI
1MH+NJGGSSKVfH9xiHyFDnwFNpHPfEfwR2HDDJFE4mqwV9DvgevoLEb7GvZ4
psgJmEsPc+ASvjzOPjhFqn3aVwW2EqrgJtr90G7WasOuoc4eaqzGbpwmsgni
aLZCHucB4vKxd8h7i95UakygVgKM4RuFtaZGnLh9xixwjrgF9HIBW8N5DL7h
L0TvIHFuvkfIuZgqMi9LJBfa6HEnNXzJIi/Y40sI4w/BZHSGOBsgz4rfAr3s
w4nvh5c+0kU+QXeq6o6l68zG7IeYpZa4Wr4PpGkPh7G30LoNw07t9Tw1ZjNX
DoxT8y98JGeQ3BTiom7uBu5m6r3EuJf5xObCDfNe7C6RzfT1iu/GDPbM2VLI
RmcJOjnYN+gOQZI5kx3bjmYHhMkvJfchvnfEDMMAOr8SRUqo18d3P2SjGYBZ
4EXDim6iT7+3olPEforhPru8B1Fy/6ARwraQ/5oazdiTxJ6CELFBmOLXe07G
dpvvqQt7hPmPOjTWyHmML8jZU2yfQ9/JQnZaQr8rIYJ/FVjo77KFc3ZcZvYw
SP4y3tlysLn0X+n16x6NfTYzxw56OEZcHfve7dY9GPtoMs8asRW8qXruYR12
JjN6wcbuR63cHbONwz/owtcJ4YDucQV9FJNTBAXGPqlfiI24dKYn9DJCrfdZ
WtvooSFD77QJ+92r7+4n9gy6Z6GeWfbCeo/+21Ue/TeNf/SBX+/0kV81De24
+dZbfPo+jHfSat7LFvT+A1fYpF8=
         "]]}]}, 
     {Hue[0.0892136257281258], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlElszXEQx8dapaKv7/373vPaeu/x2kQIEgdCNTQqgloiliDaUmtTIeFg
qe1gSbiJgyWK4GILoiHpJj0Id3EQQpDYEieJxPL5Zn6Hf2b+85/5zsx3Zv65
ll0r2geb2TGeITy3K80+jzBbUW02NWtWN9Ls9Riz8xPMeoeZHcmbXUJP4VOa
MZs+1uwh9nmR2TaebvSVabPHMbONAC4smL0tM8sMNZsI5lfwfxH7BVkP1uNR
ZiXo8Rx+5CpDfud9FLERGI3lZs3o/ejfQmxp3GxKwX2S2N+DXwF+Q8HrUD01
VfREfbX4f8VnMTGr8ZmLfVvKrAWfywnyh35vIu/wXlRktiXl/ct+ll438b5n
uNmypFkTvfUTu588HTxN1PAU/BJyJfG/gP+TmNuXUM/qrHMV4/ta6uzCPp+e
hmZdryHPaGo7CP6ZcegZ91fc4qTnXYT8QA095G2LPLdqqMV3ZtbnsgtbLz6b
0K/Rx/Oc+5+jnhdpt19NOKfi7QqYRwM/R5Cd9P8J/Xqlz0nzeke928NMK8De
HPlMG8FrS/tcOirwKzi3S+KeT3kfkH9LiE0SG4X5DpC/I+/97kuGuvG5iF5H
3gnoO6jzZc7t2rt29GL25F/e90k1PAKnM+Fz/AlvH8IOTAKjPfIaxFln0rna
h+14xmO1m3PDnjREzqn8B8izNcx3L7YT+NfBySlkV9hncdBQ5fVrbpqf5rim
zPdJ9VzIO67wl1PDj5jjnARnVsb5n1bwXRRvjXF/l117PbLc+e8jtrLc+xpA
P5R1f/GtPmXX7t8PO3wL2ZPwOlVv43jqhfNm4gZX+7x6sC9SDvQi+l0QduYG
ccVhh4synk/4afIX53yOum/tlvy1U61Zx29CDuS9X/0PNEvNbnfkvItP8bow
7VzpDmrpfVox33IeL5wWZHPab0e3dQ/MMSVmd5GDyp1b3W590v3V3yv+TXPQ
JxPbmvL73YqsJsdv7EvBb0v4Xn3E3hdzHsRHd7jT0/Q7NuWcxMVPtefSfj0N
Ps/QV4X7VR/CEuaMrO+3+NGtXAo7IAxhCfManPwNnIv7W2Fe+vckgo++Lwv3
fj3vt6EdOwz+OvIdoK8NyDcF578G+87Ql+5GPIrP2VV+J7qXEQmfq/wVdzXv
e6X/cX/gQXc8rtTx16d95+TzJ/L/l3oXT/8B0W/OCw==
         "]], PolygonBox[CompressedData["
1:eJwtlntM1WUYx5+MO5hcDgcOP64nDutiWls6hbgkaNogCZfVxCVkupUzcdOt
RMUUWirVf9FqrQvkpZoiJGWbVGKD/7qssNtWullWWyZtOgvr891z/viMl/N7
L8/7vM/3+75l7U+2bJxhZq9BAtSUm1XDugqz9TA7ZHYr5MTMQtB2o9ka6OPb
y7CE3woZeD7F7K0iH6Ox9zDHUlgZNXsAHoE1MBGYjUMOfULQDXtgE3RARbFZ
DI4w11FoCps1QmaZWRZcyzKbhh+Y40fYl2m2F9YRx3o4B2ehq9RsF6xgTAts
iZhthbX89ijcBDfDLbn8hTkwF+Yzdh68xBp9MESfY9BJDNvhDmK8HdJyzNLh
NHOOQTljYzDCno/DqgKzVohl8w2eos/T0Muc+yGXucLwHn3fhdN5Zp/B3eSo
DhbTdwm0s/baNLNZGWaraXfx7eNE5oQnOJdvZ5nV8j2f/M8kH/OJbV6Fn5nO
bjZjaviex/eMwM9EZ5OqPcAF9vornOTbKPxcaPYTNBDzYpji2yU4QI4PwovE
/gJEiLUASuhTDG2MaYdE2glwjbn+g8OsdQg62OtmWM5ZXCWetuvNPmGeZeRs
KQyRq2H4hTXOw2XWvBLzNbX2SdqjcB85f5B660wiP8V+Zjq7PNbMz/Y1tNaH
rHmi3HOu3KsGVAs7Cn1txdDM/zMYe12u15Rq6xgMQiVjqiK+J+1NOVAukgPP
pXI6Se6nyfG/IZ9Dcymnyu0r9HsV+otcG9JIUdhjVKzLmPPeQs+RcvU7c/8B
PbS7oZm174fn6dML1YypgS7aOwu9plRbu8hNV6afoc7yb2KfgsvEdAWmiSlg
7c3kq5Hz6iEn3eWuKWlLGpFWdsMeSCYnaeTnJPWVSvsgHCjzM9fZVzFfJdwJ
8+A030YT/UwaOZtB/j8KKbRT4S9iuAhfs/Y3sJoYW6EFVsS8hlRL0oS0MUJ9
H4+6pqStx6RZ2EdO9kMyMSZBPbE3hD2HyqVqULX4EWNPxOfQXPIseVcqpMFv
zHUh4pqWtvey5nOQSQxZkEHs6WWeI+VqZ6nXmva3vdTPSGclz5H3DNNnCLYQ
29bAc345vmftfQNzpaabfUBOVxLfbvo+AwvouzDwnCv3k+zlTNhjUCw9xPRs
ltewavk2+s4J3CPkFao51Z40Iq1Is9KuPEPekcS3ZOhkzLbAPUneJA+Tl8lz
5D3fl5h9B/X55DPfz0hnJc1Ku2Ps8RQ08q0p3z1X3iuNS+vSrLSrPup7hjGT
5e758v636TsQeE2qNvujXouqyTdpZwbuXfKwuaVeU6otxazYHw+51+kMdkTd
o+RVV5nrHxhjrVPxNbV2K3vfloxPp5o9THtBqY+XZy6kncjeE+ASe56CEmIv
LvAz1Fkmod3ECq8R1Yo8Xd5eSY6roIHf6iPu0fLq3hKPTWtsCHlNq7alSWlT
d47unkXEXB94DaoW5XHyumY0sjzH7yzdXbozdHfU0q6Lo7Y8Ul4pD5AXSIPS
omJSbNqD9iLPlnfLM+Qd0qC0qDtLd5c8Sd4kDUqL58jJWehn7AA0xf1Vmp6g
djPwr5F0r2HV8g3kbmbYNSPtfEH787BrXtp/ndpJp9Y/Zfwbea5RaVU1r9ov
zHdvkccU0K4jxloYJpb34UjU7zrdefWMP0xMh+BP4rhY5BqQFgbjXq0aUC2o
xlRr8uzK+BnprKQhaamf2AbgrmKvDdXIqoi/GfR22AQdcdTWG0VvFWlC2pCn
yFukcWldbwa9HRSzYj8M78T8jaO3ju5g3cXSjLQzrrdP1N88evvoDaW3lN5Q
ffE3kN5CKSHPtXK+KOp3nu6+cZiIo7ZyptxVB55r5bwq8BgUy5fwFTyU7d6j
OTey//8Bz5NmkA==
         "]], PolygonBox[CompressedData["
1:eJwtkktIlFEUx/+VzuiM5bxH/RzHkRwNjGyR1KIkRVoEvmjTQnRGR3eGgasW
vehhRdsEm0WpWIGllBQtUhShoEWtClskDRRkZY+F4Krf5c7ixznf+c79n8e9
ifSZ7uGdkhqgEIbKJLdbehySCiLEoA1e7OK7WnKBG7I10l3owS8tkebwu8ql
TtjwS0eLpIuONBqWlhHuI57wSTXgRtsFLZx57pVasW/gtdGg/jPyV/Hvk9OP
f4LYWlz6BO3o9NLLZbSvwFXHahrt6/jN1L2GLafnygIpF5BmEtIDaCXeAqv0
99kjBYml0U7BYH7uDHYuJj2B23ulb+jN449z5g5M4n8ldg87XSFNwWl6OljM
zFXSCj330d9Lcr3ol4BDbxVwirxXzDPITgIJ20MYW5hkHzBCfIn/b4l1BNkl
pNjvAHkZbL/xYSZm+5rFHqqVmsBH7haxDWIP6ekR3GLWm3DDsT2lqO/HLyMv
y2wBvoNQV2V3fpz6tfhJ+I3OJkTNHJz9ib+f2sfopQG7m/3ugSPoHYYFv72X
Reaf4O7S6GVD9o2YtxIhNwwHONuMRiP2gmPfySXH7sfs6WRUOuti1vy9mPvx
sw8fLFIjRY12dPZxvh7qqu0bWSKvk5xttJPc+flK9OEjuR/ge8zu5we2h5nP
cddx6r3j33sYy7+dX9QY4H8GJtmhh3ohYl+ok4N/vMG/8CduZ9zB2WnqTsE6
dR3enCdi92r2O8Geo+gWo+/ljjzw1MzC2WH2/R/fPHMq
         "]]}]}, 
     {Hue[0.1375748758730933], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlX1o1WUUx0+zuddy92773bvd3d27N21GmSDReqFiUxvTtU0YRS+w0Ypi
aS/Ml8GGQ5kZGon/BEPK2TKkaMrIsJctmob9F0UMQrCUXGL5MhIhyD7H7/PH
5Tz3eb7Pec73nO85v5reTV0bc8xsit8ifpcazNryzW6mzMYTZvsXm3WVmj1W
bbaSdU/c7GIFZ3lmi5eaFXG27HbOWP9WZbaZuzfwkSoxu4C/7fjZw28IfB/3
OsA/Bf71crODwf8H2I8qzc6CeStjFvH/Wq5ZLDLbETNbR2BF7M3x9ibwa1l/
js8neGsGu5TYlhXww77BnQIwR+rNeolnA5hMXG97DLvBT5fxDv6bWJ8Bf5E4
t+JzmpjvKjb7odZsDfgB8I+zHgZTjM/TYGZqzLqJvw0e8Uhxerxzgfvv2E7u
buHuKP6fhdcp1seJJx/8FfCLsY9Ui+8E5+/CcYH9j/Hdz28QP8Vps/NJ4gBz
YQn+ubOKGHZmdd/9zHJeDH436+/g1BFpPVumtz2GdmJZG7jE4dcXl59r+N/A
3RH2BzmfhOfVIrMD2DvxcxU/9/DWtsD9bzBPh3x2YbPE/Ql3t6WUO8/hEDV9
LaG6R8Q2VS9MBuy5rPgeYj2YFcc7iOF6Snq7jP0pkjY6XSMhb89j88D/Rzyr
OU9EylUl9o+gw/PY9xPi5fxuBp+5rN8jt0+in/vRZBN+mgvNHsAeY78OzL1g
+5LSWC/2wYCZJ+f/xqSxaTDNCWnvM/IzWq88e+6/zYqj52MuIe31E1uMM2O9
nvVf8LyBnyvYcw3i6H1wHa1fxk8OmJFQL9dOT7lyWFWivvL+KgC/NdR3hvq2
RtLwCda/4ieHmMdZz8ChCT+NxLU8JY4rUtK643cQ+xFibcRnCT6HU8qz5/vF
8K73birU1/l57V0D3gdvx6QN18iJ0EcDrHMjcXmJ9w+mlXPP/dcB4/FmEtrf
x34srZqOs94fauTn3ydVX6/zdOjxP8lZFHptb0z8PQ+u9+1osQdMB/luS6pG
PifaI+Xf6+Czw+s7wt1OuJXT419Rx+64dOg957PMtRSvUR96DBVel+B/lDx8
Wq88DLG/Oq5+95lXFPrlMO8fhdc8+5Npac55HWa9qFLaeAVsYVrveh8Uhl6e
8F7MShuukUtp6dn73meuz9559h7KqnZvUqtmOIwx9/LKpDn37+9sLJdmfDa/
kJUeerDHa8X9S+zJWs2609iFBvW1z8s1zKVV+GwvFWfnvoKcHQu87q5Wrn1/
GPw3QW9n0GBPmLE+7yeJKZ/1y0nNUJ8/LZzXlWhW+NytDeuBcvWe16iNWs0n
xfEW1xC/8ygO35pXOb8t6G0ho9x5DndR3zHu7yMPB7A7OTvLOgV+LvTIL9iV
JZp7W4hneZ38Ow/n5hzPxzUHfR6OYT+MSUuPwuu+bJj5vF/Ku43gm9k/WqMa
/Ripb72PfBb2k4efyefejL4rnvNT2Fnwrfg/VaPvmeu2Bbu5QrHdms3h2/dP
Rnr12n2BbYnUOz4XK5PiWJXU2x7Dc/hYX6Z9z8EzFfpmPVwtjbpWl0Sard77
3dhdKdXCazIRvsU+s2OlqoXXZCHMK+/11lL59O/h6qCZFuxoRvt+vq5UHE+C
mQozwXt9T0Y5eQf7P1NsJ7w=
         "]], PolygonBox[CompressedData["
1:eJwtlm1MlWUYx68ggQOYwHk/hwMeFJz0Ym5qa5pKOCcgtqyh2WgdloOc6aAF
y0VJL2gv9rI+WVqbkmm1RS+WlY1CsGV9s6W11Wy5ZK5VWDb7IPX7dz0fftt9
nue+r7f7f13PyXZsXbslz8x2wZVQkTYrh3DSLAKDdWZPQDf0wMVqs9X5Zr9P
M/ub9eEKs7YCsz/4XRTjd8rsfRgrMxuH72abnYa2GrN10MR6FRRjqwSmImaX
IS9qlg9V2MjAeMLsOPQRw0Ch2dwis62sx9j7JL4Mn0PlbkO29hDzXpiHzxx7
O+CxSo9BsbRiaw10sbezzmNQLGtmkfN0bGOvMc4Znu3E/hSsII6z+NyH/xeL
zTaXeQ7K5W7Iwa1hs/UUbgHnX+X8P8R3CSbhAqyIu235uAVfHZCD3cTwErRw
vo3z89mzvMrsWs5cA5Fasyj8NNNsBN9niOFAyu9EdxMi1+K010S1UYy/sL6P
HOdgbyW/z7K+n5rO5fcl9vyWMdufcluyGaZ+wzyb4N2ckFkd/g+R40EYwfdn
tR7j7kAD0sIU9i7DavJqhRzx3Vjo+amWX/DseNzvVHe7DH0shcWcWQLfz0AT
MJ3Yr5LW4q6fSer9FPFcyHgtFXN52Gsm2/JRz3oh8S+Am7HVCA3EuByaWDfD
B6wPw5vwFrzCHU2W+B20UI9tgZ6kj1rieg1/QxnXnLSXZs+ZAq+Pat+Y9vrq
TC9nr8ZHPcyD6wOf8i3NS/uHsHUQPoQjGc9Rua7D1npoxkYT3IHvDVBCjMVw
jppPQJJnCWhGuy1wjJqMwmbdLSSILw734nMTjKPXsaDH1GvtSdeSNHUn635y
Ki1w/b6H/7yY924R+Qyrl4itn/V5WmoH6028D7F/GnrIr3INS8vfck+n4t6j
6tUpYvoXruPMrCLf/zH+y8J+d7rDX8m/h9y64Uv2nYAiKIRTaOA0nNA73SG5
NlT6Hu2NoLVogNa5oHdaY977mgGD+OuPeuzKoYN8U7z/k3cb2HOUOj6HzWcr
XYPSYi7o3UXYvAEqst47uuNw1nvi/37jfEozCJvjUIufOthR7rNOmpV2H5/p
uWoGDLDuI/betGtEWtklTQfxpNi/Flt9+DtHzLmo93AoqIlqo5qrlqppPb/3
lfss0kz6lHt4Bo08DZ3UrKvWe0q9tRAWQQXvHsD+y9jIMp93Vnu/r6IHjpHf
I+x5GD7B7lFYUuVa0ftR3v+c8NmhGbKFfW/XeO+oh4ZZj/L+84TPAM2C24nh
NhjA76NlPoM1i9t5dhcMEfN++Iq8v056jIr1IekO+lj3QifvuuB1nh2Av4jt
IjSEfTZpRr2b8RwUq2IerPYcles23hfzvjDiv1WDlUnPSftVg5vItTvqd/UC
Oe2Ju+akPc0MzQ75lG/NcM1yaURa0UzWbNY3pSOYB/PLfEZHgh5WL6sn1Bs/
kMOPMJHxflQ9S8M+c3Re36jtld4zum/1XE/M77Qz6JmeYAaPBD2iXlEPq5el
2fNJ15S0Jc0/L21mfNarB99gHnUlvNfV81dgf0bMZ630q293KOyxKcZ3sv6N
k33NjAfZuz3tWpVmB9LeU/InTVfEfAZqFmpmaXZ1JtyX/iNsZL2M/JbO9m+u
vr1741573cFJzn9EzEfgHmxsjPrM1uw+Cd8EGmoPNCatlWb8rnXHjTU+UzVb
9Z9F/13Uo+rVxeoN+A/J8DB2
         "]], PolygonBox[CompressedData["
1:eJwtk1lI1FEUh38Ylms27jqOSxr2EvVgkAuU5li5TDSBYPSitGho9qJWpGG9
FJkhPRqVtqhRD4WkYaCZMyL1GDkVRrRp0WZCCEH0Xe48fJwz939/Z7tnsuqa
vUdDJBVAKHyMlRbCpPsuaRCGoMch7V4h9eHfhFtwZo3UCV/WSTu5/9Ap+ddK
66MkHzYvVdoM8zFS2SrpQ7LUmCA1wQK6eVhG24o2kCYl8n2e/If4noSfDKPk
GYEBl80/jD1BnrvEG85Bi98Gq+OkaLiYIb0Il7qwWznXSsmTKE1S/1OY4zwf
7QSxb8TTC7zkLCRCeoMt5dwNDRDGvXrsVe5cg/oU6TC0UN9XQmdT/2wSerhD
LeHkCuC/Je8chDLHCnr7g1+SLhWDhxrzqM+NP8PdKDT30Prxp2HCaWf5l1pv
4w/AdvKVQC6aXLTFcbYeU1cvc16MxMd6Ob9MvD7itHK/DT5T/yfYkkkceizI
tP2ZPsfQJPBWe+jDwYx+8/ib+P6K93oNidSQANeTbNx+bBH9F0KpmQPz2YH1
EKsKZoJvP068FuKdI944NY4S4xE85+4z6I+38w4w72r2w0+c/dht7EIxdAff
sDHe1m56eJ9m98TNTLvxL4Gfcx+kkGuJXNP40ezHSe5Vc28XucrhB2fLnH13
2X5MX/v4XgNutP/QOlx2L81++rLQMtMprJc8e9EuUdcgfQ1BgNnMwgZmtYg2
khjH0DXDFWbUw6x6saPB+Y5gfdThh4UY+w75mfa+0T2mnjGzn/R7nnjHiVeF
vhIqjGXvz/K9iBoKISPV7r/TzC5Ya2Wc3S+zZ6XpdsfK0u1/wvw32tmjUzCS
Y+fdgX+E3A2QxtzeUXMV+Q/y+wB4qLWNe15sEzRCB7OoZRad2Aooh4xYO58a
/Cni/KL+COp/gj8JdejaiVNr9MQ9DRvJnY3mgcPuktmpn077X/lGfxeYcRf8
BwFVqe4=
         "]]}]}, 
     {Hue[0.18593612601806075`], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtk01IlGEQxwcttVV8XXV3XV+219WLdYo6BFoqYUkYSF4Kby1WGmnRB5nh
R0XRITp0ldwIC4KggoKKikxRoxClKPsmiFSCoA+N6NJvmufwMPPOO/Of//zn
eZKpfc2dGSKym5PJ2VMiUr5UpK1YZIiTGRJ5H4i8jolczxK5WiSSxj+PvxU/
HBZ5QH4qItLByQZj1hO5SzxEzuGoSCOYf/EHy0XeBYb5Advni6zL4eCPJq1W
MZ5Ts4b8C/TZuBx/mcgGbA711eRP4nv0rlwiMkX+pzLj7NPnC6cBoHOB1Wjt
GNj5Lr+eWBj/Dzg/EiL91I9SG4dvtsPXPqm4xXsixk95biK+nl7DxA8QLyan
hV6FzDHhZn/I7I/hUMXHKHa+lDmId9PrFzmD+Mfx05wecNJwa46bhjv538Xs
ucx+Hz5ZvuXcZA/PIsZf5y6g9hh8POwAGuHK/ojtQHG2xU1r1TxN7Wd4hODT
UWJ5mj8Hz3zf+LzBH+dfNTlj2AnnvyXeHTMdVCe9E6rzCfSoKjOdVe97hSLb
6VVMbi36rkbzGuwOx0fn0x7aKxw1HVXPteC8cLtuBaPO1TYy48oKuOSJNGFH
0KKS/Fr4HvFtR0exNb7F67C97i71YE+COwXOqcD2pPs6hD3N9zTxkaTtSff1
lPgjzzSZxr+YNN02M9ek00r/L1JbxL1dCGwf/3eH/nHyPpK/hdhl/FWADmFL
XDyKPRvY7vQO3nC1GcwdDRu3b+DMeHZPcuC/1+2rEzsMn4Zc9Eab7wm7tz+x
42h9Dfwn2LC7Dy1oOOPe6SvsLeLzxO8k7M2obl3gX4pZX+2/wulcic2NGgfl
0uTi9TG7Q6pJO3xmCw3zdsLutOYvkL+LHffCuR370rP7P0L+lVK7M/pGQ769
F303OrNyOIjGeeiyCOYcsYoCw2kjp8+9TX2L+mb0/vwGuz9hOB7xgSLTYSJm
e9X9ngnsn+Z8pf8/4a2tfA==
         "]], PolygonBox[CompressedData["
1:eJwtlm1MlWUYx+8pIW8J58B58HCAw0GhlpaoS5vhENRILEosED/otNpEAU23
RFuZSNIHe7M+5aRW+bpqrSZmQWETbGBNlxW0VVtp4NqyVeKqTfv9d90bv+3h
PPd93df1v6+XJ7FuU13rBOfce5AEt0ScK4XyEucWQFvUuW2wCTZDNOTc6Zuc
S0927onAud6wcz0Q5jkb2uPOFfP+fKpznTxn5LIWdrGvHWJT7P053nfw/gw2
B6J2ps4OYaMLP1ZiP2DftUz7f22ac/VFrM1yrh9qsfMAnCnmN7gzz7m5sLLI
1mrP5JhzK/Kdq4Oj7DkGHfiwO2Q+ybfOUuf2wBbYCtfwKZv9T+FjMvt/xJ8f
oI2126GVM9MmOcef+wJ/72LPPLg9x7k7YDTT3mnNRda+ylmvQJy9RXAvsVZD
GF+ys2yP9kbQOoCaac4thXRsZsBogXPjKWavGXvX8GkcrsAf8D1rR6ABDVbC
b2iwirUH8OEyz+v4bW2x+Shfc3JNW+nzN/7PgOlQBrNgebZz+3g/B74m7ibO
/C/Z9HgfP6fwWy7kQSywmBTby8S4T3eM1rtgD/fQWWR3ortZhO3FsIM92+F3
NLgCP0ljH5Ni0xqtrcSPKtiNRu3QzbsTcAMfrsNE1iTBAuUqzIV5MESsgz4n
lBu1+HZ/rt257v5f9v4Df8JfkEfuRmEZPt8HfZz1WZbZkK0ynmfCbt51wHR8
uA1mQhmMsHcYqnW3sJDnirD5JN9SYnYXupM0nh3vboQsZsUuDaTF02iyM7Az
dNYszpwN96D/EljOcx20srYlahq3e5/leyOsgm7sH4cUbKXCOGddDVnMiv0G
Pl2PmCbSppu7OZ5nNaXaOsxZZT5/0tn/XNxqWTV7KM96gHrBrzAatRxWLidU
93HzUb72oF0vhGMWu2pStXmKHO+DQRiCU/jUBw9y1nK4mmlny4eD+NLEmvWw
BbZCi68/1UQG+ZFUSC4U2p3obj7XGVCErwnYT86/5mtctX4Snz4qtp6j3vNs
3HqR4tuA7UemUjNTbY/21vt+ohieoRZfT1gtqCbeSFiMPd6mbI96bS7CpajV
iGpFPVK98tGw1ZZqrAv9P8TmBzCdGGbAeeWMszUXAtNIWlVyt1W6a97XROzO
dHcBPkZKzWf5PsvXsnJauf08d7E3yzRs8hpKy0G0GopZT1Rv1J3obsYy7fxq
4p1P7L9w5s/wIryk89F8NnpVp7MnYTWgWign1gXwMDYeKrGaVe3qt3Lf89T7
zuHbrUlmfxS9B7AxJ9V65umE1bRqWzWiWllcaOu1ZgnPQxFbq/8X8f9lbIzB
3fhaXmQ9U73zAD51+RgVqzSSVk2wvtR6rHrtCPc/DN/Cd3HrWepdqnnVvmzI
1mpiWlNiM0ezRz1CvaIFmrOsp6m3zS80baRRRaH1MPUy3bHu+hS2+uAwHIEn
OWsH3My7yfAptdALS7FVA5exPQbDaD/ia7zRzzTNNvVc9d6D7D0E7+LjO3AB
voEq5U6J5YxyRzNdsz1G7uTnWY9Qr0iGSYFpKm2l+dmIzZQGP0M0SxaiWcU0
01BansBWtz9TZyuHlcsXubtLsIYzVkM9NMCX5MDZqGku7TXzNPvSIaPEYlbs
H6PBJzm2R3srfSzSSFrVYGMZbMTHDepnrK2FdN6lFZim0vYttHkzZJpK256Q
fbvoG2ZnxGpUtdrs7zKJsybCBnzYGNiM1axVDamWFJNiO8oZxwpMQ2mpnqPe
MyGw/qBviHHiK2BPPmym1h+HAbTr9zNbs1t3prsrZF88sBpTrWmGaJaoRlQr
qsmvItZj1WsVo2I9kGu9Qu/389yCjebAYlAsR3yuaQZoFmiGdvscVC4+hs1e
/E3DxsmQ1YBqQTNHs0c9Wb35NNr1QxbPmYHNGM2aFeR2HWzDTlvEepR6lXJC
ubE1MNs6IxSymabZpm9KfVu+ELf4lG97eW7UN5zPGeWOam617ynqLaqBYd+T
1JsyfO6oRlQr8lG+vq2aCNkd6i41IzQr/gdag3/Y
         "]], PolygonBox[CompressedData["
1:eJwtkk9IFEAUxj+K3FJhd13dXbV1Xfei5SE6JKSph8BM66CH1JuCopVmWLkl
rlSi9+omFJgRRtAlIYzKTfEPJNSllNKO6jGlIgL1N8wcfnwzb+Z9M+/NxNqu
NfQckFQKh6ArV0p6pLhPWgtK6zAZkF6lSSsh6SrzbtiJSP8OS37WNsPSFszC
aXI/ors50h4MsTcJS+S+xGOM/S/InYQ3sIXHRpZUny39ZD1M7mXyrsBFYhdg
OCp9PiLdR6/j0wvBsN2fiz5m/oDxE7Qdrw6Yct6v0Yd+6RHE8qRCuJ0vlbPm
KZKeEZ+AKmLFxCrRMs4+BYOMK4gNoZUF0knuUI224t8GUeoqgHnuUE7di2gt
/OcudegKe1ah2nnPck43/e2B8/ShFmZiUk2GlEIvEX/HI7Ry9lH6H4HvXuu9
gF+Is8LmTejDwXTuTW8+kbMMN8hJkTtODxrwbYQd1rfhW8i+3yp6i/wMxgl0
hrVUtq3F1LRJr/6Y90DfEp+Gm+xLZ39f0PbV9Hfbvf0vtCxqe5SkxiZ62wyL
7q0X0F089qDO1Awt5A+w30euN2LHfnSc3jyFD9T5HtZcjT+MfyE9gD5X4xnG
Hu6TBnPuz32lTxOMTzB+jnpZ88E9PO/Cb3wC+P1FE/j0Q6f76x3oOe5aA2dh
PlMqifNPGCdgkL1znHvHzN3f6UePEy+F4rjNORa3dzc1jHLOF/7LSNS+s3nv
APfJgiA+TfRnml7sA0NHgLo=
         "]]}]}, 
     {Hue[0.23429737616302826`], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtll1slFUQhg9aqAW1222/7Xa3u19bIEL0ohaQxlgkSAoK4acQCUa5QANC
FQWJAhLAglEvJV6YiKJWjV76H5SqaPhRwBox/As3kAZFDSlRxJj6vL7nYnNm
55szZ84778yc5qWPda26JoTwPb9r+V3NhbCTNVsfwrFSCJuGhbAEeV0SwuKK
EBbUhnAJfR/Gy7IhDCDvRl6K3Ind6hEhvIpueyGELZX8b7Cd7F/je4r/y8ND
eAebWXx7Epsbke9tCuHIdSH8VR3C5pLlTawrsdmMzUbW3Zy9dVQIVS0hjEDe
wFmlfAh3x3MnIp9A3on/wboQXm9Gh/1O1l34xSSsSUOYib/pI/HD/9uI82P+
78fnBvZuwmg962nsCtz3S3wOyRc+D9R7v/z04W9bTQi/o58jrDinv8rfqvD3
I/L1fHshtbwCH1tT6+bUOT7FeZW1uxzCfeA8N0Mc3PMV9u9qsb/W6DPJ2P4f
7nIX9qeRD5KTw4nlecTSB84jibkIxg9mnZfv+L65GMJ72ExG3pBzTh/F3znl
leQfRz6LvBX908iN9eaAuHBn2THczjoAFj/j5wf89GOzBfs12Lfxu4j9tsYQ
PuDchQR8A9/PsH8y8gru1BjzXkY/g7vtAq9q7j6NPM4j5un4XNZgjolrD2e9
9yz7vkW/A0z6WUewt4e9FazjiWkcsY1j7WhyTu9g7U8c5zPEeyjiI8x+IddV
8GojvLqQNw8GkSvKvkt3zrlTLoX5UOL8fpM3dsKwgzWDXSVxvoX+Fv6/i34d
GB+OcZ5JzQntlQ/hInxawenxBtfFOtZ9iXOkXHVlzIFOfM4omvPifkVi7omD
h/BzHj912N4az9X5q2KNTGVfB/ITyK3I2/i2AP9j0A1FfTvrkcT1uDzrehbm
a9EN1Jk/n6Pf02z+3cP3USWf28K9KiP+zWA5pWj/b8O9L9jbhdyL/BXxHRef
ucu5OmP1ET5vLhpn4T2haPsW4llZNucPIE8ba04uwn9tzvGI1+0x/qmsTWXj
LF4sj9i+iP3s2E8m4Xsg4iy8F2WM1bRmn6GzctiPyRjbNvUH/l9E/z5rW8R2
P+cMj/g/jzyXeIZBjK6c7WQ/H0zm15hv4p36hfrGuNH01MhD1c340e5RM+HF
b2VzfiKxzE2N1cEm16Rq87x4zh1y6oepa0y4/Yu+KnLvE9VH7F1/4K87cW+Z
Dd4NeffG1Zx1sNGYCJvGgmu8Y6zzJPyrye39GXO7NXUvEP6fFhyTYtuDrjvv
2hiFbmWUn03NCXGjFptZifcqh2/E3nuKOD8s+b6qdZ2tGG5KPCeEifq35oH6
w/Yazwnx86GsMdLeLnRXOKuOGv9bPTzyQXzvrXevUM+YF+tIPbUt5uI0+qP0
6x3EWQl+PY2uF9XN2oit+tmBvGPQjBIvhc+SxPUjnncWPQuVo1XsOxmxUh9V
npSvHuIvoV+P/0Xse6lge81SxaF4UmKryRg31fQMzhvi3E7WZnw9wF32ZD07
xeGX8XEpcfwV9c6T8tWeeB5oLlwm70/VuL+pz4m74rC4f7TR9sqzeCP+qIdN
ws+b1Hh76vqUfjBx3Srv+7B/JO8epTmvsxXDYLVnmPgm3s1JzUPxcX3G+dU8
yce3xCnsFxd81mSdVXTMmmlfV3sOH8NPb949M7DvQuzVvxZ8ns49XO06VD2q
dpfHd8XRxH1K/eo5/G+J7we9KWoj5/+PK+r1vuiL74G9id8uuuMUzYG854Xm
qnzJZ0/q+BTnSWI7lXPPXFjrXqke9SffJ8Q5qJ70U7TX/bJxnl5BzpRcj3r7
fBb3qs+ph4pje8F1Tb3rV28czQPx+RgxnEjd9zRn/gNGbFoS
         "]], PolygonBox[CompressedData["
1:eJwtlnto1WUYx5+Vbl5m52w797OzzXlJKUo0s6vNEjW1ptMkjUpmRFuk6Ib3
vGyK9UehYhBMEhIjlYIKnSM1Z3gJF5Z4adM0KDPFyuH1n7DPl+f94wvP77zv
+7zf5/Z9T//aeTVz7zGzbaAHuJY2+xesTJitAn8Wm10EO3JmO8HMSrOXQS2Y
A7Ls6cPBLZxNYV9JmU0oMOvN98m42cGsWTv4HGwHYwaaVYG6wWb14Cf2/NrT
7N18s0iJ2XW+C/C3mfPd2B2DzI6BZ0vNngNfYn8BToHToBE0aA++O0BTkVmi
l9l0/BUmzZLckQBzBpi9Ae7HZ3OeWQscjxBnU7nZccie6Wv2VsysZ9bPx/qY
3WGtbwWxsBd31hYhN2Vmu/ieAse/se9EPHbl4FLM79Td/xDTGrhsgPN6UEUO
x4DXuL/mXrO7rI8nX2fJRddAz6lyO5ff3gE9MnAB/YI/cRK3W9x3E2wjz5+B
m/i7AVZTmyZwH1gIv/nwXwb3qcRwle9fiLka+8Oo2QegjpzVgwwc02Ahdy4C
kxUD3JZyZxr/dXyf6O05eJvv/8jZKnw18H0Xey13NHLXVXIwAr972f8taMBX
I5hO7NPADtZ2giPEejjErNgfZu9DIAGXJNidcb6LacpJxDWRO58HneSuCyzW
/QV+33D8rQHNoJXc7AF/secS2EUedoNcymNRTNUx70H14i1ivg3KqWFG/YbP
Cuz36JV1oAE0DvYZ0Cy00Jubwfly36sz57AnJryWqul+/M8mhtfBS2AG+IPY
fw89oF6og/8o+Mzk/JvYrRmPVTG3YTfGfU3zswD7es7naR/+u7G3wP2TrN8x
O9yhu5pDLqpYW8n+aewfjW0J70X10NfFXmPVuh2uB2PeI+qVi2zti/+LcFqR
5zm+hH0Fn5dBJ9y7wA9wOgr204PfgdNx5yaOmn3t6QwxK/ZExmdNM1eCPb3E
41MOtiZ9pjXbrcSwJ/RkXZhpzfYZcjwrz3Peib0h47UXv43YsahzVwzLieV4
2vfqzBTWlqc9H+pR9ao0QFrQQm03g4Pc0R40RlojTZI2TaQ3J4FxWc+lfIzP
eg+rl3VGZz/OOBflbBP2avKxKu4zpdmSJkmbpEHSohpyn5fvPtew71DMbf02
lbXDUZ9V9YNmoTrMo2bwfeLPUsMMmEzOXgCj6dm9nB/G+jPSI+66Da6BbrAf
TUkUeg3qyzwmxVYIl36gg/Whha5pL+K/F9/NaGETKMBeQo1W5Hu9zsOvKu2z
r5wXRb1mrUGTpc3ScGn5OTh3EN8yemppzjVL2lWTdO0cAt+h8CkJ9ZPPCfjO
IzYDF+D+G5if9PldwnqOvYuS7l9vxtQi12xpt/SpPuVvkt6mx4jt8VDjljDT
mu1+cCwc5D2t3m7nrlfxdwN/pcT3ZJnnUjk9DP8T4GdwkrVTYGTW9VXzPgL7
FWowK2ictO5CwnOlnBWTi2FZj02a+QB2BL5t8P2UO0aS766Ez7pm4mzC31i9
tdIwaVl3qKU0W9o9ZIBrz3z8D8XewR3bS/zN0NvxSMrXtGc49vcpn3+9p6cj
ntMLoUfUKz0qvdaq+V78zEh7rpXzBeT6iZAPvZHt/T2nyq00W9odZ08s6W+Q
3iL1lHpLGrUlaHJr+A+g/wJPMYNj+7heXIZbWdJzrze0FHsev81NucZIaw7F
/e0VB9XmwTLvHfXQNzmfgcmhBqrFVzF/u/Ve5uteYj4Q8RqqlsOirh/Sg3UV
rrHKvzg9zXcxPVUEavl9Dlhb7r2lGWzGLkh4LvUfpTd2JOe9oJ6IYp8N/wcU
01HimFLks6CeVe/+GPHzqsnWlGuWtEvnj8F/X5hX6VcNXNsqfXb1m9b0pupt
FUdxHVXuvaSeGsf62LjnRvP8KPrRHvREM65ZPxbmXb8diHoOlAvpW1Opv5l6
Ozfh+yOwschj0YxUwL866tzER9qiNzsRZkqzdaTS79Yduut//u58FQ==
         "]], PolygonBox[CompressedData["
1:eJwtkr1P01EUhl+whRaGFigU2oL8iEMHF4hDB5qAQ/lYjA42DgaDbpI2JCQi
kNKPf0EnSFqIGspm4gLUD2QhmuBQJSnqpibGQQZio4s8N7fDk3N/595zznve
1plN30g1S7oEbngbkPbheo/U1CJdIz7ukB7BYFC6Tc4hrvRLXo/0MyQtcV6G
+EVpFBJD0k67NEE8GKQnOLzLk2shd7dbmoVkn/SwVbpJvMP9DCRhEUEnfvow
+z+ipol7aKrAGRTJ1dBQ7pK2IcbMTa90q9HD9EpRn2lCG7W/6X8KGTRW0Zwl
+vj2gxc9BXR5iEcD0gfI9UpfmXGExjc+/IARRyqRc5FTJ95AjHOZ3GrY7m32
f0euckGao0cK0nCV2i3eDXMXoi4Mn9D1Ee5xfsn7Knd1PP4D/xo7vqDvMnsU
2CMSsj4aP41uo/9XyP4GD0wd9W0uaZd+Abzphs+cr7BbiflT6JiGKPtF8eoy
8Tv3PyCPHzmo+6w/hX7rg/FjMWy1j9B/Ha/X4DBovXCT+8vOgTbpudFMXQnc
6HLBffbLon2BHZ4x+yk8gVZ0fuP9OLPHIN7w8Thi602fomO1bxA7mZnhf7fE
3Cxvc/Aara/gPecv1Gbpe0KvGkzybp73CeI5AohpOQ==
         "]]}]}, 
     {Hue[0.28265862630799565`], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlVtsVGUQxz+RLVQx27N7zvbstrvbbVMxGCVpkaAGA4kpxEgvgJcHSLwl
pmhKJNUGd2uk6IP65C3xmmiaqKEqXoi3mGI1QFqhIBcTW2KDctG24C0QjD74
G//fw8nMmTPff/4z38yc0j2b1/bMcc7t4rmU52zBub5q535Dnk45l5/r3FXo
qbRzi9CnMs511jj3+jznDmad+wifBHaH/RfvP5R37g2eU/Od+7vo3FfYF2D/
F58TVc41JZy7kvfX8DmJz6vIbZHwLc7CEjwuc64ZORTrrGHMS+tcAds6cIfg
2YncWYsP5OsC55aC/wLPMO+DtdLXc24TOXThP9wIX49zJzjbiX0UDgPIPvwX
cq4TnBpya0N/DHscCN/i9Hic+5FVYL0Cz28anJtJCGc+uPX4bSBuwfA4n6RW
FWJ96Gu1FL07JY4PoZfwO8/5F4nThp7FZ4LvZZ4xfPbnqCVPFfYGYp3LKU4J
vZe7eBv8BLbneY6jb6onbh3f4TOXGk6CncI+CtYa6rUD/pc0kW9GeeWIWyKP
4WrdzVgsPg18n6UOg5ydQY5nde+N5N5K3AH0J+HwaUp8jFc5K3s/spfz1eB/
GTp3O++34XNvpDuwGnaAsTotew9534ffWerWSvxvyWEL/Cvgt8SyL0HOxuqT
Bdg/T4r35ei3xKrbZEo1tdrOIFcRa5BYy8n7O/BeSqiOaTj+mFB9T+R01w9T
h0V51WkrOA3k2czZYkE8jE8I5zHPbRTZEaqn87H6wPqhjM8/sXrpWvB+iMTH
7vx9ni78E+T7ZkkzYrNS8rFWUI/FefGy+/8pVM9Y70yDOQXn78HrCoRvPXuA
sw9y9hCyP1a/Wd9tLGgeR7EdiZTvsYwe0w9jK+dVlwoygHcvZ1dwVzdlpY+T
469+rg0vTbw74P8Ztud8vz2L3AvWBJg34tMSic9B9MNp7ZNz6CdD1f8t+LT7
PtzP/ezzZ9eQU1SrWboQCcvseyL1nPXeoaz62+JW4785Vn+PRZoZ6wHrhd99
3/aQ06Mp3and7Zyc5qUKuYvzzeS+pE79ZH1VBqfJ7x/bQ+/5/WN7aH2g+k/B
+SL8y+gJzr4bSj8eamZsdnbGytPyvZDUzNs9fpDSecM5ZpxDcf6CvFvrxOc6
5B98m8bnr0jzb/1QsTmrVSyLeT5SraxmvYH8/8S2mvNXg7M30Ewf8XO9ytvb
kKlAs2kzujLQLv1/p+Z117b77W7sjkaoYXugOl/D93bs71CfQqg7truublQt
jNsV8Bkg35A6b0d+HWrP2L7Z7WdkGNkXaO5s19Z4PuMZ4Rr+zeyokaRmdRs4
G6nDPvS7kbOc34PPdIP2uO1z+z/051Xzn8Ho8P+IrqJ2kOG3ZbQ3bV+dAeeG
ovbD9UXtStuZzeRxl4+1DPtEjXSz2f61/TGF3uH3p+Vne9D2XsX6Dj6L0Q/A
fTKjf9IE8qmidoXtDJsrm6+V+J/h/WU4X0xqL1vNby0qhsX6mLtY6+fd9sqG
SDvTdmdLXrO8ju9bamW3Xbs1UG88kdd/xXryE/QHYvVCd6haW02SfD/tOZxC
dvt/nP3rlvv6LCPm47H+I7vhORqpH2z+6jOakRF4PuLv1Hbq0Uh9bnvrmaL6
8OmidqvN4yg+/wE1iivE
         "]], PolygonBox[CompressedData["
1:eJwtlmlsVVUUhbdAa1HgvXf7pg6vpbTFSKIgCHFIjAWiJgqUAlakgggGoQnE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         "]], PolygonBox[CompressedData["
1:eJwtkr1Pk1EUxp9gWy0haaW1LbTlbSuNqAPaFixOThRJxQgDi2A0TmpKNCYO
MPjxHzBqWGAgYSNxgSgmJMhXEOKiaUpwqIMRlEQnHPB3c9/hl/O+997zPOec
e9P3xgYrDZI6wAs3WqQydMWl7Cnp7WlpLCJVwNsqzZ6UGogfWb/IfolzDzj/
EApuTp6Y4f8svElKddamiNejUj+I/GP2ipBm7xzn4+g1nZBu4jMIQ7DTJj3y
S7kz0irfa1Ak9wr85vsZe59D0iL/CzAPK43SfkpK4nPbJyWIR2j9g8uOdAmK
6M2Qe5XvbFo6IGeNWiLkR+E9mu/An7H+W3j53N6fBqVtNHfcXkxPhRgaeN0P
SxvorMM2THH+E3G3WaqBg04WvTTxG3l7MI7ea/w/UPNX6voCVWrtRq9GvIvv
KjpVztU5/x3K1D2HzoBjZ2Fm8sudxwGxYO4ProWsX6rN1mRq60OzBL3gZ95B
5n4HzVGo4DGD1z7nLpBzHjog6ZF+UH83fl1mfo6taQRfL3m3qNVD/BOQ/sIr
5hFmfzlg+zF9+fGpsTZJzmP0n0AW2qE3bt9SH7HHsXdTYvYB5hkM27dl3tgE
vERjnJh3Z56L2dmaGZs7NnfdTC3D7IWI6wm80N5M2Hdt3vdSys7ch4cHvPCz
xfZ+SHyOxouI7cX0tAWd7E3j9R84JW/Z
         "]]}]}, 
     {Hue[0.3310198764529631], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlnlsVHUQx38iPTnK2+6yu6/dfbvlEDGcRaKReFFORaCFxKgIqAkSBEQK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         "]], PolygonBox[CompressedData["
1:eJwtl3lslFUUxR92r8B0psss7UzpCuICBcQECAq2EZRFKSiyFgSxgiAUiAWq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         "]], PolygonBox[CompressedData["
1:eJwtks9L03EYx98M3ZyClcstne4HunnTQC9ZKG1CdCnYLuswf11SCSV1Hbp1
1IOEEtl/EM0mHoK8mOeBstihxgraKhHnoiRB0KDXl88OL57n+3ye5/m8n+f7
CU7OxWZtksJQD8Nt0hDsd0iLDdIe9tAjVeukZLs0AZPwLyhdwOlVaZWz1y5p
NyB9gB14SaxMXeaa1O+Q3mLTsAGH1DfQ+8kVqYRfBn+n9IzYdIv0mJx5K98r
vYEz8u5wtoWf8Rr/HdZ9WfJAFb3HUIEV7p3g3k1qio1SHRpD5IZh3WXO7a3S
kk9ahrzH6LehwQ4O6KamC3rgFz2+02sE/y9+B/rusZP7kCX3D7PFOD9H7wXk
iKfQ9wmbRNsotJOXJu8p/jfuK8EA/U7oZ6NfCW1lOCD+EwrkbXNWZI8F9vKb
fp+xY5yNwyN0x53SLPYhTMFH4jlYoPYFte8DRo+lq5fa5/S43mn2au23AnfR
VMUusLd5eIXOr8SamGcK/QlqZrBOvhthDX8VIi1mxjz+Tb80CDf85o008x6+
XJJu0SdL74BbCrrNP7b+dYo+Dmp/4Efxq+Qdo/UIKhAhdhvi9Ntgxhg2zEwh
6K/trA/7gO8ERGv/ZTho3pb1xnbRV+COJebddpm3uMeOctaefEaPpWuz9jZz
6P0P5nN5PQ==
         "]]}]}, 
     {Hue[0.37938112659793055`], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNWGtwlNUZPiYkeyfZ7Ca7WdjLl3QQJHIJbUESILZeMMyI0EBbwSGk5VYT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         "]], PolygonBox[CompressedData["
1:eJwtmAlwldUVxy8k5G1g8sJL8vLgvZeXaIABCYsUhRRwDFpxSsQGFMMS4kBg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         "]], PolygonBox[CompressedData["
1:eJwtkC9PQnEUht+x6XAOJ+AG3I0rFE0a9Av4GWwSYBIJ2kxKYgRmVjEpBA3q
pgGQS9A5A6NBAmfRIFk2nQHwufvd8Oyce37vfc+fZHZ/e88naQlmYJKU8vPS
dViq2FIVjuFgVtqNSGXq59Alv6PWSEg1qENmUUrDxrJ0OSetE0MYB2GI/gH9
FrVn/J7gEZ8culfyAuyQl4greKxCFCIw9mb6Izr8P0LXIkYtKQYtcGCN2gVv
Afp9ef3emKsPA5iGpG+/9B6XTtCfQod+9+g+0DeZx4E8tSM4C5uZirbp4/az
LKP/RD/Bbwz9uLlPltqLbXZqu/swewpu8bmBnnezK942vRstMGuX755tbuje
8pc9D9n3h/gPaKFE/A==
         "]]}]}, 
     {Hue[0.42774237674289806`], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmUlNWVxz/sbpruqsLurqK7qqG6lkYFZIsiIjricsY9wriLIiCbhoiC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         "]], PolygonBox[CompressedData["
1:eJwtmHucznUWx3/MDGOGPDPPM+aZGc9tZpQiCRuVUG0lFbq6bci4tAm5RmHo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         "]], 
        PolygonBox[{{7845, 2403, 7847, 5028, 5029}, {5029, 5028, 7838, 2400, 
         7837}, {8125, 2548, 8127, 5047, 5048}, {4857, 4856, 7820, 2394, 
         7819}, {7998, 2468, 8000, 5054, 5055}, {7884, 2411, 5051, 7873, 
         7874}, {5055, 5054, 7978, 2463, 7977}, {5048, 5047, 7883, 2411, 
         7882}, {7642, 2289, 7644, 4856, 4857}, {7844, 7843, 5037, 2403, 
         7846}, {7892, 7891, 5138, 2468, 7999}, {7821, 2394, 5018, 7806, 
         7807}}]}]}, 
     {Hue[0.47610362688786545`], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHeYFFXWxqt7RsJMz+cMPWSY0NWDumZBdA1rWMGwSBR0zSQFFRNmUBAD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         "]], PolygonBox[CompressedData["
1:eJwtmHucz1Uax8/MyBhDmYvMmN/8bt/f2FwKpbJRXtVuUm0sLV5a9AqlbZdl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         "]], 
        PolygonBox[{{9326, 3415, 9888, 9868, 9869}, {9440, 9439, 8797, 3017, 
         8808}}]}]}, 
     {Hue[0.524464877032833], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3mYVNW1xW9VV3dLV5c23Q3dND1WFSgoAr4kBB8QYzQKRHkkDihqokkc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         "]], PolygonBox[CompressedData["
1:eJwtmHeU1dURx3/Lvl228ALbYNn+3u8BAoKCIopiO/GcBMReUIwRjwnYk3CO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         "]], 
        PolygonBox[{{5807, 5806, 7960, 2454, 7962}, {5773, 5772, 7848, 2404, 
         7850}, {7927, 7926, 7932, 2430, 5081}, {7931, 2430, 7930, 5772, 
         5773}, {6428, 6427, 7964, 2455, 5124}, {8129, 2549, 8128, 5806, 
         5807}, {5123, 2454, 7961, 6427, 6428}, {7975, 7974, 8130, 2549, 
         5257}, {5082, 2431, 7934, 7926, 7927}, {5038, 2404, 7849, 6364, 
         6365}}]}]}, 
     {Hue[0.5728261271778003], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgmUVdWVhi/UAEVVSb2BV69e8aZ6pSQCIihNoxE0GjtMdkRsY0QcIogs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         "]], PolygonBox[CompressedData["
1:eJwtmHm8z2UWx793zcXVvb/fz11+9/7We69mpiKVlAlJyxSaF2maCkVRTEVZ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         "]], 
        PolygonBox[{{7833, 2397, 7832, 4864, 4865}, {7823, 7822, 7834, 2397, 
         5023}, {4865, 4864, 7650, 2292, 7652}, {7853, 2405, 7852, 4859, 
         4860}, {4860, 4859, 7868, 2408, 7871}, {8545, 2814, 7349, 7798, 
         7799}, {7908, 2415, 7907, 5057, 5058}, {5058, 5057, 8136, 2552, 
         8139}, {5044, 2408, 7870, 7809, 7810}, {7895, 7894, 7910, 2415, 
         5060}}]}]}, 
     {Hue[0.6211873773227679], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1WHtwlNUVv5uEJJvdPDabzW42++0r0QEpyKNNS4s2j8JIDbSGVMHyqGBF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         "]], PolygonBox[CompressedData["
1:eJwtmHlw1dUVx28W4CVkeS/bS17ykrwkhCoiVGZAZoSyFAttsBVEkQq0gBtY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         "]], PolygonBox[CompressedData["
1:eJwtkD9LglEUxh//FJZLZPCCqGVLRW02NdlXcGgKTIWEFGurLagPUEkNLukH
yBJ6HbTUQa2+QU1BUJtNZrO/l+vw45x77nPOee6Npg8TBbekBZiC24C0OyNd
R6QLuIQ+tR58kz9OSwNLskPSgU+KzXMflF6gi6ZA7ye6d/gA17J06mcwsbEk
NeF+UapCZk66mpXuqG0x58EjPTP3Fd5gLyolIQU7zN1Es01PHIoR4/OG2Ebb
gi4c4alPXMXPiuOJPf/oesQae4rsy9E/RPMHFTRl8OJ9RO9PWDpn5hk0IUtv
jbsKlKFE7YQ/yFnmLc6b9smPqT2RZyd5B52Nvg5fYdOT587N2QNrQfOXv5bx
6fitT/bZxHU8bsAY0W5CTA==
         "]]}]}, 
     {Hue[0.6695486274677354], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlntsVFUQxg8WSoUC3e0+2m237XahaQvEGMEAESJoBQIkxghtqFVsFUKq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         "]], PolygonBox[CompressedData["
1:eJwtlmlslFUUhi8txYLFzkw7nel0Ou102lKgRPyBFJFokcoWEmNkUWQRCBHL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         "]], PolygonBox[CompressedData["
1:eJwtkk9I02EYx786y2X+aYu0abMNpJzOm4fcQVqRoOmlayiSQoroCp2amyf1
3EUHegiiU9HWAg3NuiQIHoMIPKmI0GrlwHDzEPT58f4OH56H5//zvK//UeTB
WLGkG3AOnlyTHjqlCHLOI83DxSvSYomUviyt1UsfYAr/JMSgn/hZZMgvnZRJ
bcjwJekOrGBfhtXrUu6C1Iuvq07qhB2XtE98NbYN/OuwRY9leq2hF9O7CL7W
Sn9LmYv4z1elW+jfqqTb1fSBGLYZaPBKC8wy4Za+0DOC3oY+Sv4Y5OEU/oHb
mpl60+ySckitxD1Dn6k3sVZOCNtT4rap9bNGykAAe4r+cXbrwD+NP4//F2Qh
Qf4SvGCP5+zh4XYvydkjp5J+SfZJeczc1vxH7BHGt8v8UWomuMemTxqg1yDE
yXHR48ye3drhD/7f0I3vmNxj9Lvs/oq4e15zM+t2H6m5AZ/sm20i39nv8Jac
1/AGUpCEtM/sU2CPRrgJ7fabVrLrMPMMwQE9TojbQ55Ss4faBfsNrLfoo8d7
662RXcx4H5pqzbtmyW9GD8J3ah5SZ8Vr5rTmbeEGQXDQuxufE+km1gWPa8w/
rEA/7zb+Uvw/+EsZyHvMzUeIK6CfQQW9y2GcuF7io8ggO+XY6Qh7I3oA/gPm
UnSc
         "]]}]}, 
     {Hue[0.7179098776127028], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlntM1WUYx5+JeKlEfodzOIfL4aKGN1puWepmubwMpv+0LiBotrRamVBt
NjTU+QdBaubSUkPb+ic315q1ijLXVuYoVrYaZBFi2SZLUCjTSLLs8+z7/nH2
vL/nfS7f5/qe0tVP3Vs/ysza+GXw60mYnc00qywy6+X8K+eGlNmxiWZTbjDL
KjGbO9ns1E1mc6Dzwvl4vlluqVn5OLOlBWZ3JM0uonsNG6Vxs8PoLkF2fhq5
sWbN2PyUu3HItKDbm23WAX8t5+fwXT3ebAO0Af5h+Fnwb8fm42PMvokJy2fI
lKH/JTZLR5tdgj+CXIzzFHA+lGsWEdTX+O8B14FM3WWALw69GZkn8uW3vdDs
BfS7kO+EtyMtnZ3QxoBnT45suc292F4Wmb0Df1Wx2cykYlnC/b48s1rs7yK+
tdwdRaYSfiMxf47uX9Bn8XcGvxOw8Qu2suCnOU/IV7wx6F3E+toY6XSj8y/2
70Z2T5Bvx+aaIsX+I/ct4O+EvwDMZZFwvg+u6dRliHyVQ1/h7gxx7YZ+ALY/
wHYUOkQu2pEZhK4DWw0yT0JHEqqj17O2WPGuLBbP7Xge3Z/7bcb/fu66kdkH
Xc7vCOeMycLt+D8B5y3EdoQYF3HfHBeGNs5VnM8R71Rk1qdU23p4A3HV7j14
2xLK7QPUYnuJcM6hRx4k3j5kzk4yOx16uCpSjjxX1fivjtTPC9Oqn+dnKrzz
Celewf5wTPn0vH7Md4rzqZhwOZ6ZozUbbv8n9N5FZjaxfMd8HALPKvDcB54T
6KxGZxp5y+f+XKZ6azH+pkC/wv/itHjed3ciV4f8AmgjMheQ/xv7WyPl+lVk
X4+Uw07OB/PVP95HVwJmn4NjAbNj99p7jNPRmw2mJuSfpzdPxlQ3nwOP2WMf
wNfThZJpztMsuc3biLUoUg69Tz0Xbv96rvaC5/NndN9Oqlcfpi7FQd779J5J
mn3fASXc3YruEPwvsBNxnouNJnRnIl8T6pM3Vv00iM5Bvv8jtxfD+QI0Ab6l
3O8i3prQY134eSmtPulHZh2xzfMehj7q+4jzI9BEjmo4Db/1YfaPE/f32DFw
Hoirhzwn/cS1JZIv93k+LsyO/beEanqOWK6Pl67P/+836ttrXJOSL/c5kKt5
7ofWBWx92N5QqJ7ZDC1LSq8i0m7yGl0D42BCO2B9TDuvO+y9UXnK26K09p3v
tsvIz89VjX5Avn2i+m8HWLanlNsT8FrjwtpKrAdCL7VCh/MV76ZIttxmB3Ym
lqh2hxKaPZ/BTUnNpOf8H2y+jMxu7HwIrsdCzk9H2o++N1ZAX0S+AJmdKe16
z//RQs2Dx14ZaRc73+vTlKee9N6sjRSv90t52CEzoF3g2Yj9P+nVtjxh+Aja
ktJb42/OWwnh9x6sAtsssC0v0A5yO1uytR99T84oVT28Lg3QNaXa//4OLExq
Bn0W9xZrL/je8h3ge977w+vk9fJ9vzn0j+d1WYHeR38nNwb7vjN6wPoG+r3Q
nNCf3js+G26vHXv3Z0vmNDKTQ658l1Sk1YcrOY9w9yYyz2Rr5/pcVIPxauAP
QytCvL6DhxPaM1cT6mO308f5ZKT8VIP3UpFyexlama3cep193tx+B7wVoS7e
j/52+k7bBubhlHLuvdMc3qZvud+aVP/4O1kX3hrf5f4/wGdoFvf/A0ZBPaE=

         "]], PolygonBox[CompressedData["
1:eJwtlllslFUUx2/Y2oLpzDedrS3TmS50sW7VsqqYAAUCL0aNQCmgqIgEasKq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         "]], PolygonBox[CompressedData["
1:eJwtkTtMk2EUht8ooqBgC0opJdWm0BbCYAItkICbMLA5UDqZlEu4CMYEAjgw
qZuJlwmIxgUJC2WhhIEEkHAZGEy8DFQDi4NCCGJCINHwfPn+4ck5//m/7z3n
e08g+ej+wAVJEbgEj13S1GXp1Cv1eKReeFMoxXOkJ35pEIagGgJZ0kmBVEMe
hW/c+Qo/3VL9FemhT1oplZZhFbbQ/Y7+Amdek6eJH2Aa4kVS/kXJz9028gRk
qL/n3I6ja/Sbbkn3oLJESvGvmXzMZfMqar+Y9zekqR8x8zxxnfk34NN1ZuXc
XDHvIz+Dd/R5Cyde++4z4hI667nS4W3pI/ma0eXM3Wxpn7h/UzqAGG+Pwojf
+tMekGq5H4NjaqPU/hBrg8x/DU+IO8yagUXHjx600+QL0IZfd/BtGw9eovEK
2umXhApqbvx5QJ6iPgt51H6gMYlGJ2/ugALyGWrDLvs+884I9SSzh4l9Prub
fuI49yfcto/p18cMCfOPOMZ3FXkL53LRvApheoegmTtlzBIk/w//jDdo99Oj
0WP3afaa4VwMjU40wnyHzJ6dN7YSQ2iWQyW+HeL3F/7/dXz7zL4a+NcIe9R2
YdHZ6fMb7JE+3fSLemx/M0eHz/brIkbQqvDaPZl9vWDnPnzZxI98x6M84lPu
PYMadlMNqyV2V3VB29vMEKdvir4J4jkf0HqA
         "]]}]}, 
     {Hue[0.7662711277576701], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lmls1FUUxZ8iYAXstNOZTmc60+IYcAvBQC2ihIikkIiGlFpkEaLYL4oF
WTSaWEQFWVNQ3CBBrRGJxKB8EAkuQUkEFEJJCIsgoJioDRiWxEBY/B3P88M/
781999313POm7+MzGluvDSF08nXj21seQvq6EAal/Wm/D9k32RBO9wzhzmII
tyFPIv8R+cdVIbQj38x6usL6ncg/S4XwMAZvRb4TeRP7dWUh9K8M4UP8XCwN
4QBn73H3COss7nyHThf3RtaGMOqGEEaw/pGyXOddFfa7i/1XyMciX43Nrdjq
g805NSFs4M7I7vhnv606hOdJ7kgihCfxO++aEJ5h/wLySezHse/A9xRsdmBv
faV9zcD+EnTOYHMkOiOQt/YgXuQNCct1Pgz5OvZXqEcJvz/A7wDOy/MhnEJe
JIbl2F9Ijmlkb+KjFJ1x5DE4YZ1W7k3PuQ6qR0vO9VRdP8X+cPzOxu/6Mtdz
L3f3c7YWnX705Fds/obNCZyPLXh/HNmYnq4hbsLT1Y5hJfe+jn2cTGzbiekS
+mu4OzsTQm/kryNvxd82fB3Dzr1p6wwnlvq08z1JvSf1DeEy9sezXsVm8npy
xd7PKd+VjSFgZX9vcmXdg97+khCakyEsJY5X8DWvyj1T777H5kTiOImvk8op
5f1Z4pqIziH69RO9bSaOEuQNFf6034fO1rxreBCbTUX3vZG1LsbQzHq4l2OQ
P2FCOvXIF1W75uu5u6LGPWrC9lvsD6LfWmFb0p9Grv+kjGFheWCchU3EMJf6
L2f/BjmuIJ6j1KQ9b4wKq0/R2zp0BmBzEGuvrOvQht+qvHskvBzPG6vCbGPG
ue8i3hMFY1sYfzRnPAgXGxQ3dzexfp5xTUYT89vod7C/P+F8lJcw+By/52Oz
Bfsv6QNjFUn3QLU5jM7cjPt4Pu8Zlq8n8Lkma18bkR0rdR1uoQa7M87xduo0
NemZeh87E2pdh8voXs57vmaCjW/z1te9tjLjRzi6ErEU8LWj1Pg9hZ1hEYfC
rGJSbNPLHbfi758xttTfVfRtKBcXE+c7VZ4xzVp9wmfSaWfdi50m4mzg3tGI
B3FGW8TnAtZFxHOIfQ9xV5V5bBnxTBPuwf9d5caosPo78gMZx6l4R+FjHb4a
WOur7Gsy9e7ie5X6t+FzVuSZ1fh5MWG5zhdn3UfhvTlnv/L/UM69605vixnn
3oZOU8KcJm7rjPxwXH2L8hZiGB25Sz5fUwzcXcC6KmJVmF0Z9+rbhWrjeWOt
Z1U1acT/2qzxKZxejBjoZN1cMAf2Vt/x9wX6w9AtZp2X8sumjElhcwI16kYM
41ln5hyzYi/y+x90+qfNfeLAv9lvFlcS25Zqc5VmU5i+r8b2h2AzFe2XpfxO
aDYvsN/BvgU7A8m3Pem8PunHjNVY/t95jWu1RbOYtY505UvcodkQB2ked5LL
s3GOSrKukfTFAXMil95Y6zdPvcvkzWvCyVLOZyRcwzPkey5jvr6KzuiImXSF
cS/8/5U2N4mjplKnU2nX5CNkg/9/g0o9V5ovvWPCtPD2IDbeTduXfAr7dZED
x/czn8zH11R0umNzWtrYUl4vp30mnTPYPFuwTWFZb5tmqk6YjTqyN6DS9VyW
9f8A/R+4lPLbI357JGfuEId0oLM9vkd6l1qy7u+X9LcrbQ55LOm+qr+tOeNJ
uDpf8P8P9VccLI5T3+9hLk/EN1HvoThOuahXSzKW6838IeE+il/PxXjEo3cU
jb2b0+YX8cwD2OmZMrb7sE6Jb9+aar/3kgv7+g+hmMV/wpbwsCppLCq23ZX+
r6B+qW/7Yn2GIlsYayiOvzvmuOcmOKnac6E3/8+IB/HiL5X2q7jGFNzTUQW/
f3oHt4GlfwGMVXE6
         "]], PolygonBox[CompressedData["
1:eJwtlnlsVVUQxgcLtAXkta/t21/7ylN2iQul0mgwWqBGNAZKI4gKKIkLFBMw
QKKAYbEIBmwVVBSkLMYtUTBUg1ExSEGRsIrgHgEjBJBNwu7vc+4fXzL3njkz
c2a+mXPKx04cWn+Nmb0D2oKqYrP+IOd6vsHvcbNluWYvdTBblTE7WmL2dY7Z
EP6djZmNiprVsrFPvllFqdmwArMH27j+GvQby8w6oRtqZ7YIedd1ZjvBIXAY
9MRHD/AqPheDqVmzKSDT1awcfIKPdeBiyOwSqO9iNgGcYO8/4E58DO7g8ZxG
7xt0NoFfiPNX8DrxvAYa8DEP1BBjBbFu5Aw/sT4GH6PBJGxNDmzKtnKgXKSI
JQnCoAg0odsIpoMZYE/abDc4Gzb7N+xn0FkGsjYInMHf+lzP0SnkzhnPx7Xk
egNx9iv13Gl9B3auEOtlkCHWcrCVf1vAKWyfBoeI+SC5nNXeLF1EbfhG/f8c
VGN7Hzr1rF1C57aI2QLWazlrDv9G8L2SPc3ah7wczAVzwFr+rQOPIrdDdzh7
PmLvc+TiWbCas6wB+Qmz56nvLM7QMeE5U+6UE+UmQqxzWXuGeBqI57Gk21rI
v3FJtyFbqrFqXc+/2W2cY08jz+DM00E9axPBEvg3j7WZxDQTrh0o8dyphqrl
Z2nn23J0NiBPj7qu9lSRmL7Y2NvJ7Djfm4j3nlKvvfYPKXWOi+vnOcMFkCk0
KwNN5OEVMBC5GnyHvA18i839bdzeF9ibg7/Z+BsAjrHeLeb+xfc6eHCUMx0B
8ZRZAlSy/5h5fl4kP6PK3JZsjkS+t8S5IM70x349Nn7Md85MxvbPcT+rzlyL
rY1p/76fM32J3Jv69wKPc5YnwNJC54I4cQexHibGQ+Awfv4CXROee9Ugi3wL
Md4M+oMq0Cvrts9hozdyDfHkI4/D3pPEe5J4ZrB3kfoP+amk6yum8cjVxHiS
807lvI0Zz4lyozMtZn9L3Lmh9ZdZnx11bovjI4k9lnb+ilNx5LeJ+eG2znlx
Xz0g/T/R/4PvJmrZCH7A9z7wRsL9K76lyKvjXivZaEb+lDOOzzO7iv+x5fRR
MB/2gu3lPnM0e+bjewHY3sVr0wtO7ULeUez8Vs+MjjjnVVvVOIx+T+z3ACFq
UgAWEePCEueYuLY14JPs7enikCwfI8jPBOwf6Oj1nxTzmarZqppNSzknxc0a
bN0NliAvFg+Ru4M8YsjVXEH3aspjln35bMV3H3JyA7gLX9VlPnMywUzWbB4Z
8dmhGmwlljf5txSsYG8zuEJu1nDWCPk8Xuw+5EszTLNMNVAt1NPq7X5hz7Vy
3oJeOciAVaytBmfZcwas4F8zGFHotVWNxQ3NdM32KeRiasx1pPsueC/lHBKX
VPOaAp/Jms2aoZqlN2W93zQTKrLOSemLgw3sPw6OpTxnyt1FfF0A/fBdCfaQ
o93gK/5tDHpIvbSZPLSGfOZr9uvO0N1RF8yfaVyyteofYhkcdh/ytbDMuaYa
q9aaOZo9m5Fbi/3OVb3V78MLfGaIX+qHCewfU+RcFqc/JL4CcS3ld57uvgFR
73/V6PaozzjNOuVYuV5Gft8q9DtMd5lmVDywIVtz4j7rxee+6LcQ73rQit8t
oCritZf9SuSDAR/kcx/1GZr0/boz7kP+njNtK3aOiqt6Q+juVj//TR6vpv1b
b4zLyEcivqYzHo0458Q9zSjNqhDc7ZzwO0x3WXvOsj/X51OfqPeAeuF9bH8A
TkQ8V5rZGeI/z78ibK/Ex7kSf5PobaI3ht4a6in1lmqu2j+SdK6o5x9K+h2l
u0pvCL0lboy6b8XwAnF1i/js1Ez8HPsLEr6uGToPeW3cZ5P4OohzdY94LIqp
Z8R7YlXQc+q9PLiTG/Y7RXeL3kh6K2WCXqoKZrdmjmZPRXDfqAbz8TUsmL+6
o7LkvjLr3BRHb0V+IOncUr/XIe+KeayK6beQvxn0driArYugOeHx6w5Yhrwz
5Lra83HM31wNwUzWbG6ipo1p7yn11n/zfZFv
         "]], PolygonBox[CompressedData["
1:eJwtkk1I03EYx786dRrqpmtbviz7kzd1l8AOXXpZ6tmLkGCyIWSK0kFUlIky
fMnEaoMSSVBBKD2Ei6JbC2sdHHTtMBV8IfBUHsRM6/Pnv8OH59nze16//xnB
3uaebEnVkAvrlyRXjnR4UYrjv4OucukhfKyUuvOlDvx2D/l50n3sJrkpuOmV
eojdxr4qkRbgZZk0ZZdeYGfd0lM4KpV+w7XLkr9Aqsdep6Ye/vLuYf533t8w
7zXMw9kFqdXgjTkr1DRWSXXs4YcA/h0IO6VIlnQLf4y9RvH7iRWT44BvLikJ
DVVWjybsKXv9gUfkjZA/R12SGV+hBd/GPffMmIMYTKPHHkLtsucZv9PoEfNJ
zyEKCeKfYIJ5P7h7EvuE+DTMgIv8c2IhGET4tNPS1tQ4xf1L9C6nfok9lyEG
M+hxggaNaNIEcWLrUEjeIvlb1FWz4zH+VWwA3e/CGu+rcIXcCHdMkDeM1kMQ
zfQdZ+4OObvUPua2DW76Ai2GpXkbtoaZteAEB9wwrD3d1A1Q0w/b+Amb1Idf
lNmrgJ3t5OeDKqzbw+zlRm8PdPKnewBv+Q4B8iNo/str+eP474l/gF7qP9P7
J333ue8Aguzwj/1ChnWPeZfZ0+w967O+yzPsf84Jazc=
         "]]}]}, 
     {Hue[0.8146323779026376], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlFtI1FEQxoeuRtnmbrv/vbSuiwlBWVSEQVAZQoUWaBeE0MCeJNKHKHqo
l6ArYppIhpCRSQUWUUG+dPEhrEDZ1FKEzFILErKCerC0fsMc8Djj/L/zzTeX
Y7KiuqRqlohUcWZznsVFJtJEOrF7s0XWpovsx+ZyuhaJFGM7gyKDc0X6EyLv
wiJb5+Nj0zJEhvAvRkUOJ0XWzBPZ4xdJ8W0L8T7s55DIJuLVxJ86nlrw7fgp
/BVwDDjOMZ/Ihahx1mBfBkQecfcxeY8sFckBfwm/Cxw/8iVo3xTzwxPpDpkG
1bLa1bIPez5qebWOO+CugClXbvJuINcD7NGw8WuebPxRrQU/wGlbILKNPEkX
z8IGYyIHuOtFRD74rN7esPVL+9ZBrvwskULi34m3eaa5WTW42lu4ey9qecfB
ViaMR/u3yvGsxJ5V/cRPZooMw3MfDQ/RX8LfG9G2G9vA3QH8FLVn0dNXcNaR
ZxKudO4eD1vftQ9PiLdy/y483fDVx62WUMRmrJidcMyAv4nmGr4XoK+b+DXu
fuTkzhGJw9HAtzYw0xSXYsaVcObBGQsYphhtTeAXg/nqszsaH9cekMMPvpG5
ffIZz7qQ9Uh7NcGvEZ9pCMSsR9qrHGppjFiN9WCHHf8LsO2e6czOMN169y/x
cMz4NY/WoJjrQcOpPwW2TvebHl7G1gaNX/PonHRet4lFwZ3ivZRR6zHX2xNh
y60aRsCc8wyvOx5x+DD2asJq194U0Zc8chVm2lx1vhXMbpeLlwZst3QuMbSX
Lrc9/wl3fsJ2siBhM1adTWDfu90Y8mwPdB8aE7Yfuid9xA45nm+ezVv5Bf5R
13N9W2X8vR7NB7E73PvSt5jgTBOfoZZeziT+W+yYe+O34GzCD+D30dfBDOMp
j1ltWmPHMpHNS+gvfiv5f/uNpz9uM9BZtARNn+bVus+4/T+NjaJhCvwvsK89
2+Ee7I2IcbZhp+Om8x82N2Q7oHv0J2g7oDurb1LfZjP1vUna7HRPJ/z2//A5
mB7iRQtFttO//4NW0AM=
         "]], PolygonBox[CompressedData["
1:eJwtlmtMlmUYx681RKgJ78vr+wIvInJyJql5QBRWy0rIZVqYh6SVUrpZTXBl
sw+JWZpIpSjKTM2mgqfqQ4cPVrMvNc/GYUv70nSVblmaQn1Q037/XffGb7t5
n/u57+v4v57C+obapXeZ2aeQApsKzH5KNysdYPZqjtm8QrO5cF+W2SjYGDPb
AAeHmx2C0hzfq3daeTeWZ7aXc+oGmsVZ3ywxuwH/RMz+hQ0Fvv8s+9tYv1Fs
tgIKOasIFibMFsDpwWZnYETUrIv9sVSzdn5vKzXbDGc5+xzMwqYxPDvHniNx
s7XZZmvgL/ZegWlRf6Y9p/h/S4HfLRs+S7oP8qUNn7bE3Ef5ugSbX4JK9kyG
M0VmP0JenvtWf7fZ/GFme/BpN4wfYjYB8iAJEYjC5Uwz/uxx3pnC/t+xcVSK
/3+d2N3KJUawDds+hDX4/A7MxaZ5UMW6ElLweQD8x2Ed5vc/w3kV+Lok1X+7
ydmb+W0TrOPuZmjjzCyeH8ffYcSiN+qxVEwPxN1H+ao7dbdskC0N+NQIs7Cx
Fk6wPglRYhOBOO8mIJ11GlwmLn9CFXdWwkgogyeHmk1Kd58vxN0n+fYWd62G
e7lrBIyEMpis/bCUsxryPKbjw5k6O40zBsIgyIAp+P8QfIRfu6IeE8VGOWrN
N0vlrAGwmrPfhj28sxueJ9cL4Fv2fAPnyMHPsI+zqlI9Zx2sj2HjUZjPu3Vw
gvVx6OSufVGvAd2n+Odg7w5+2x51m2TbPnztHO41rlqfy29zoJozahRvYroN
msntehiX8LOU00nsm8qzRyOeU+W2kz0dsAN2Qg2+Tb+HOiDG01ln40sC1rG3
GS7g03nYy7oDbmV6f5YTny9zPOaK/UlyeAp6Cz1fGezpZr2YflkEhznza3iO
mLWneox+470vOPtzqMbGGmjC5pVQyboKGrJ8r97Zz++lvFMCU4lRNfyR6XcN
wp6r2LMix9f67Rfy9Ag2Pwx9/N4Pl6jVi7CUXmyARmLaAAuJcT20E9OtUM26
Bi7FPZey4SL39vJuTzhDZ/Xj0400v3M559fgXzU8wXszYBW+NUGttAa6Obtr
sGuUtKqNOzZDE6ySJlKjB6GO2D0Lx4jB0Yj3kHqpiJwVwkgogwpyNhG6sKMb
qjizEipgElzn7mvQB/0wh7NmRzwnys3H7NmVcA2RllzDp79LXDOkHRb0Sjm/
jY59B0dgLDEbV+x36m75LN/lo3ydATNDT6u3k0HbnhrqvawaqWX9esiXYpiM
eQ6Ui9ewYTmcj3sutV9aII2V1j5GXUyDB7H9AfgeG37Id82Udqon1Bsf4NP7
uV7Tqm2DOzy/zbM7MIF3x0OPahdm4VMtvICPLya9BlQLQ/gtv9g1V9qrmvgV
2z7h7EOhhlXLyrlyL82X9kcgE9Zyx7vSD+7eHXKsXO8MvagZoFmQjn1pwUbZ
qhqoCzNUs1Q+y/crPL86xDVUWhqFLGkbPZEKo+mVMdle46p15VS51QzVLJUN
skUzU7OzUGuIcWcWFFMbJbC9wP1VzrYVuIZJy6Rh0rKZIdfSSGmlYqbYvQyv
JD2HyqVqXLWumlHtlMNEOMFdx6EPn/qzXGOkNapR1apmlmaXvgH0LaAcKBcx
GFzsM1WztQd6i7wGVAvSUGlpb3imHjoWNEZasx5fW2BeLGgfGnia+K7irqZS
1wRpg/ZorzRUWloWek8aIa2YDU/DFmK/Ne4xU+zK2Tsx4jNMs0wzT7NPM0Sz
JDPUhjRWWquYK/bZnJWA0TwbA61xn72awV3481WOa6/6cVTCZ6xmrXpcva47
dXcL6/cCLUGDpEU90B00XdqeEWahZrBmsWpAtaAZoVmhGapZ2gjL8lzDD4eZ
p9nXH7RFPaBeUA+pl6RB0iLlVLmVRkmrNCM0K+7n2diEf2PoW2M/7x7I9ZpR
7SyCxUnvUfWqNE/ap5pX7atH1CvLgm3dwTd90+nbTjlULvXNoW+PI0G7VlJD
b5b4TNVs1cxsDt+E+jY8QIz3R12jpdX/A0ouhUU=
         "]], PolygonBox[CompressedData["
1:eJwtk9tLk2Ecx78EuUVFueWcqzcdGhTVVpm5iuxkFlQ3mvPKjKJA6PgHVCQ4
K8qMNL1qolgbFEQH8CaqK1PaEDNdQnVRd1JRWReB1efleS4+fN/n9P19n8Mb
Pnqm9vQcSRtgLrQskS7B90LpSZ50rEyKhqQIVBdLA/MkP+OHl0rlXqkRTeVL
aXjhSNP0PUczQSkL/UVSu0fqQ/sKaIMP8iFDjQfUGEFP+aSTsH+5VEmNg2gS
zzswjt83fMfQKHMjcI08U/h6GZ+i/RCfD6gHX6/rHZYOzCcDGvdLDfCGPNtZ
83GRtDIgrQqYjG7W1aXS0AJpLfrW1vtNnmG+Rxyz3vXp5AwmyXcLTbOnFDTZ
s8iR5Ta1u6COM/pEpjDev1j/h/EZx+zR3etVm/8KGid3A8TIUwmfybeDsQnW
jgfN9yS6jbEqeEfNHLy05z2N3w97X/vIFaB2IeyFGhiz+25mLEs7A934+Jnf
g9aQew+85jtKXwbdZe96JxrjLjbDCbIeh8Fl1Mevle+bjE8wrwM9hG89NJLn
PLmKyHfdvX9IunfCA6suwRt2wzP6cvRdxieP+h7ooraPDJ3oEF6vYOtiaQv0
4DPM/HbW1XNP6xdSE62FOrfNmnXwiP1WkO8peo4sZyHF+XTjm0bbmJOAx37z
bt7Td4TvJui1Oe/T1xIy+0ygNxjrgMEC807WUK8MjxXwl33Ost9Zx9Rya2bt
2+5nTZI5vTBDnp/wz84vZuwee74LQcecWQj9ytwvMGD/nSr2HsOvGb9RvMsZ
2wibyFABcXsWETRFvlHytzG/FRJQEjRvsRS9QPsi/Ae+vpke
         "]]}]}, 
     {Hue[0.8629936280476052], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtln1o1WUUx09mupXiXu5+d7vb3e6d9w4sN9fF1xR7MyVJc9pWsrXedWo2
FhQEQX/EtFUqZoqp6SStdMPsRZJoEP2TGNtaC/8wCia9sWgDUXAZ0efbef74
cZ77POc553vO+Z7z3PST7Wufm2RmfXw38jWlzZ7KM+usMNtTZrZ9qtlb5WbL
C80u3GSWjcy6KlxnT8rs7rhZAxcPcb4xYXZO+hmzN7nbyXp+ATa4M32KWQHn
s1lfw85J/GyqMjubb7YiZjZcbXbrNLPBarcr+/dx99lg82lkX9JslP0X0Elw
/w3sDHL3Cr6OoXMZ+WXQ+QLZxP2j7B/H3r18dZPNjpSY/Vzm+5eQ3YWOf0HW
bAxs4+RgW9w/rT9EvwVfG7DZQ9xD2B1jvaDS7B3wXwT/QeTz5OgO9v/A3h5+
N+Pr4WKzhdj5G5y5yH9rvx97HTG/ewDdb1m/js56bJwG026wfYZ8u9wxLCGO
rUVmi8jhVfxPZB1PL3jWgmMRdhok+eawvgebHegvQf9f9POJfRLrJjCsC/rN
YOnmd4z9ATDGwTAGtsusl2B3DfZj2NhJ/GNgWAyGZ6jryHSzLcimjOs31ph9
n/QcHlHsQX8h+p+XOGc+pl6l+JuNfq7G41ceHmGvhe9R1u+i+3Wwo5r8Evl+
K+e3Bc7MQs4B3xR0pqLzWMbj7cs4J1T30SLHJGwxYtoZ9BuRmVLsEm8Ncj12
V98CdrCsJCeXyHkvHDtQ5tjur/SYFcsrca+BanEUnOcKnKvibH/g7XfILVXu
Sz6bwfEyeJZV+33ZSeG3K/TFdmQvvq8T1yLiKk66fhe16ox5njcTV2fg/4aE
f1qrJ36Ke0+pt2aF/Axjf2HkNhcjt4U+VU93428Hd/fBqR3c/5F1O3hfC715
Cl+1rCe4ewY7jTHP1W50rpR676iH2kLPbkR+lPD9ymLvDXHyvQqPQbHEkz47
/p8hZc4J5WGnMKS8vr/C5aUht+q/c6EX9qrWCa+juFmI3VXYLEfexd3lN5vd
iRxKex2H045VmLPgPVDifBPvLpR6TpSbJyKfG0PYHGB/Kdi+AudAzPd1Lm6p
jn3YyAtr8a6Vs8nYr8DXrpDDrVWeL+Xtds5XFHj/fkq8cyPvfc2AeWF9jDwX
h15TfPNnmv0Af3LIzSnH04bchI884mpLOy/Fz980b0Psf87w39rv4XwwxJJL
OeeU/1jSZ67q+yr+P6l2m7J9nrjq0FlDLX6PfFbs4u61pK+1p3mkWmwHc3Pk
a9XH0HmJu/nIf8p8hmiWnAo495KTevqnFp7kkD3Evx+dk3GfEepxvRu9Yf9x
arSO+OvhfCNyf6iRanIi7ng0z2pneoyqW1fGdfQO1AXezkt5bVSjlsi5JY5p
xpwPvFIciaTPww8KfR6JJxE6V8M7spq98azPQM3CCcXJ+nrS3y312mH8nyh0
X63k6Tg498kmcjC8Ef3IosDbv7L+xij2b9g/k/Z5PgKeXaFH9N5WFXtPqecS
YWa+KD6HWa18j/N7JfqjM7yHxUPxUbiF/yK43s845zVjVlW6L70her81k8/C
7WlFjk0Y9UbqTRzBfkOJc3IO+V4c3oK5yMNhhuwH70OR51BvSy7wVvztzngt
VJP+4Ev/HW4InLme9bdT+bmC/9MZj+tg5LkQzkP4ebDc+bkOuSDlvaMe6gjv
bLvOQ++oh4RJ2DTnHihyX/LZG+ZSPXv/Afo4RWc=
         "]], PolygonBox[CompressedData["
1:eJwtln1M1WUUx88ML2AZweVe7uVyebn3Qn/wojXWJrrabI1kMy2oINOauGxj
BbXlVmulsjJhQhZgw7eaDERdrzZbraw/ag10yUAn+k+ZrdYLlMsycdXnu3P/
+I7nPs/zO8/3nPM951C2vv2+J+eZWT/IAMvyzZaC+eVmAXDXTWatWWYbQHeR
2Q+lZl8sMLuQafZ2oVl+3Ox5zvZkm2XzXXbILAvcCHJAqsTPdCfI3dVJ/i40
OzPf7Bjn11Jmc+Av3vkbdGJzK3g1aLYTlOX6excD2IqYDbDXD1bkmTWA3Xwz
CLrg2g32gb3gAHtD4IModuBay/tHWC+H4zH4/MzvT+HzBPzOcx64zqyN9b1p
frezV836cKH7Kg7i0pEwawd/wPkSyI9xH4RAGGxi7xnQVwFPMFtgNgOa2WsB
eXDOBWF8LwC7wAAow7dExGOsWItzPfzvxkY9iMOlGExhYxL8CH4Cd4ThCr7E
l6/ACBznEasu4juGr1uIxWbQwbdPgSbebgSf8eZxEIVzBFzIMfs+xzmJWx4I
gglsdGMrA5uj2H6D37vynZO4rcPWWtBDbHtBkr2EgB9JMILvA3y7FnFdDHvM
FDtpTFo7A+fTYAyMx/0bfTsM5xEwALcdxGIWbfaJJ2+8lek5VC6P8NbhCteE
tLEKzveAOvK2tNB9kC9j8BgH5/BhKK2HR7HXzZ0u8KByBMojrjXlW1rvhPNC
fgd4L1CMZkKuFWmmh+9muN/Augr/BkOuSWlzFh9+B1O8NwlGOTsE9oY8ForJ
MO9dijqfPt7rIN/nxbHAayg7XUOqpWxsLgCPl7o2pVHV0jQ+nI15jpVr3dHd
X9n7DfRjfxv3Z4hfD3aq4FRZ5BqUFm/Oc72pxl9mv7/E9b7yerNTZc5J3PLh
O0gsDF/+Yy/BW0lwC3v/oI+NnJ/A1ndo6NscrwnVxrqg+7tM+sGvy+R4ScDj
VRj0mlQuFIM/WTeztybD76wk3u3YqON8EfFfwu+D5HoEPIvvz6VrQrWRD0Lg
NPmYinhNqDZug+tLmd6D1ItuLXCu4vwmOtxADr/mfDHxbEy6JmrT9fcufP6N
O/caOJUEvcZV6wWcRaKu0eF0z1HvqcN+G/fnsD+s/oBGZzKc/yMp5yzuqhHV
yiFsjIKzxHUanGM9DX5RDkEVNivLveZUey9i44WUx0CxeDjstaka3Z7yHMi/
K/yu5GyResYN7t+d2KnHh2q4zODjRNz3dKYYbCQWJ4jXODjO+nPVUNh9kU+T
2O7nfl+5a07aW4MeHyr1HqJeMofNa1ker3cKPUaKVYyzIrAv5dzEUbkY4vfV
tH3F7r2Ez4Ys9Pc+69fQ7E5withM5LompU1p5HXy+U36tzTbUOw1qlqtgcMq
3lsd87X2PuGt4qBzU06vwPVgyHuLesx+eLZgrxlU42sN2JbyXqqe2hT2GSct
SVPbo25TttUjXuG8J+a1pprrjfkM0CzYDLaAtjL3TT6e5P6miNeCesgs68dK
vLepxz1AHj6O+6zSns46eX8raJV2wUcht6V+oNmlma3ZrZmq2bqi2GOlGClW
e6JeW9objHoNJ9Iak9ZOxl0b0shi9buUa1c1+HTMZ45mj2agZuHusPcG9Yij
pc5J3DTzNPta8Lm5wjmLezjo/orDh2U+4zXr1cPVy3tLPTfqGTtYLy/x91VD
Qb4fgvMBAb+HQBMxa4y4ZqVdaUxakyalzVZsrq/wmazZfDT9/4B6nnrf/UnX
v2qkJuk+yBf1o8tRn5manbIhW6oBaVWarQ37/xxd6ZpQbewPub5UA1eJ5f+G
y08F
         "]], PolygonBox[CompressedData["
1:eJwtk0tIlFEYhl/MTEspb03eyvG2KJWQItSw2iREaTpaM1gSRWUJhcugRRcG
SdPI0LxRiBZoES1bREpQiVKjjkoqRVaL8DJaRKUG9fycWTx8/3/Od77zfpdj
P3mx+EKApN2wGtzx0qlg6Qa2O0bqgZVU6RJrSpD+bcCGS5kRUgacT5Gmw6TT
2Fv41oMNv8v4l7FfYZeC10mVWAf/JdAbLb2A+lhpao1Uh82FHPAkSVtDpbfY
IxulgCAplnjHOVcOexKl/WulfdjFTdJ3GLRJA/AOovB/ipZvaMxBQ1WcNIIm
L7RukSZDpBZsXKQUD33c2QtZydIo9xahq4scO2EHNThMjAXyv8r5K+AgXiZr
A8RP4+6v3FcaJTVx7i60QxvMrjc696Kz0l8jN37ONMkFE5x/D+XECyRGObl2
ca4TTqCrmbVH5LOIhgUISTA9OEgNemxm/zE2mRgp8Bu9vyzd+J7BbwnN88Se
gzjWDrEWytntEWb/GP1wgguiIkyeufhtg3TwoLWWgWhGl5f4o1DKfUGr6Cff
NdSsNtbU0Kpl0WYpm9o6sMPsD0EjZ2uIMUisndRhie8M1j5Rm2l4Ql3CyOMD
cSdhymb6ZPVrGjqYjY/YQmIWgBetBcySi/uqWXezf9PfF6s/g9RoAH6Sj498
PHyfpdfP0HUOO0S/hmGG/Rn2n7M/wblJcKHFCT/Q4Atk9vh+zf4raCeXIvJ+
yfd8qqllODVqpd5t0IBvP1rc1OMaXIcv5PcZssh3mbx3kX8Pve2G+9xXh/+9
GKPH0uWFP/il4+9Ew1HIjzLaK9A+h+ZZ6ENDHmc9+LcQqxlmuOcAaz7Wsjm/
QpxxvkdhDLKoXQZx8qlbAf6FkMS6HRLBx5O+w9qQ/+31k5OD9RJ4k2ByH8GO
wTg0oLua+xqxtznXEG1m0JrFZfb/WvOXYN6m9Ubb/O+uinw68F3gvjxrVjnf
ZfXb39dhu8nHyush+TcxGw9s5j1Z76os0sxYsX8erLn4D1+Cvr8=
         "]]}]}, 
     {Hue[0.9113548781925727], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlMlLlWEUxg/NI3av3uu9Xr1TVyOooKIiWjQTRaRYRqUERaDRDP0FSqsG
my3ToHFhq1pkwyJoUZDWxVCjgihqFU1uGqhFv4fzLl7O+c53huc857xvbueB
+v2jzKyVM5qTT5g9G2vWETNrT5ktn2B2Avk6YrYbh56k2Sm+m9GL2BrRp6HP
rzYrR0/if7Xg/+SzAfvXqFl6jNk79JMh5w/+L42bZbEPUfNVyD++xux0zGNP
U+tH1H3WENvJ99HxZl3ILeVmh8fxXWH2ktgW/OvwqSa+F72BuG/k7aOXi+Q7
XuH2R+iXk+7fgz4S8s8hrq8KrGAbRjZnOZPAhFxC7F3y1OKfo1YJsbewPc+7
Xf9VQ7Ve5uCEnPfxaadOF/Z+7DfBeybm3Ipj9ay6i+EgCScV1G2k1sEysxn4
LAPP9pBnMz4j1F2Jzzl8z6ZcP5/yGMVWohcSjk0YNQ/NZR5yXdps4URmArbV
YL432Wwyde6gT5tidhsZD7MrQ1qN56kltj9wshHbtYLXqsDnVMFncYkeT4ZZ
bEW2cVrRj2V99prjC/AMhRl1pByTsFVj+0X+v+T8ibxYcK7awLM38K85aG+0
P3Ozvh/ak+GI4xPOBH0lc87tWTieCW//iG3I+bfs58F5oeAz6sU+mzwZcn7H
dzBgK8LJ+pjPtC7mR/pmeB3MeaxyDOUcp/C25r1f9a2ZaXYHyHOD2BfoTfT7
Leq1VHMV//rh/3Ded1e8NRD7iV6a8NlW6jzK/pA6+bBvmklH6KUGPNdD/uv0
tbXUY2uZ84Oc11LNneB7P9VsB7Iz7KfuRG3oax7+h8K+jST8zuiO7M/43RAn
4qay1HvsxP4l3OU3Sd9p8dAd8/3QnrRTqzvp2MTBrLjjGSD/Wmo9YA/3Zvwd
0RyPVPo90Z5r3zcFDC30UYj4nvSU++5qh9eCuRh2Uvf1MecL+hPkhxLeFua+
IOv4hPMz+f5UeR7la8k4t3o/bpUHDsHZG/N9q5vu91/5n1b5myIetL/FhOcU
B7sCt230tCzrPOiu95X5zg9EfDbKfyXm74vuu94zvUHqUb1OyHrvb6mzMe08
i2/NUjNtRP8d7ki61PEJZwtxR7Puo90ZCO+t3s5F2Ffg87HE8yp/U9RnrFkv
5f/2uPOvd12z0Yya4aY+8K93dE/G57UP+R8WI+Ln
         "]], PolygonBox[CompressedData["
1:eJwtlntM1WUYxx8tNdAmnnM4cLjIOXI49ocIalErnSW2srsmNBCnXRTNFmhW
W/1RYoWAqUGSqPOyaZpC4ibdTFdr6w9v60JracupS7GFUq07bX2+e35/fLbf
5X2f53mf65t4rG7O00PNbDdcC1tiZi0jzMrSzDp4npIymwzRsFkWrI2bNQw3
q2FxS9y/6V9Pwuw9qIYqmBgyK4HMiFkEFiTNFsLuDLNdcLXIbKDI92jvuajZ
ebiXPffAQJ7ZL3BwnFnGKLPadLP3M81uROcdPMeuQ3eu2Qbe18PrsA6uZ+8o
CLE3DM+j8znYyBnaoQGdq2B5odkKSGWbHRtmNvoasyTPX2HL8WF+virONQed
s6GEtaVwA7LHw2vIboTP881+xpY466dj/1+c7U/4Gx3/wEwoh9ocsyXQg42H
4Hd8+wdkIisCE5BVDLOw8W4Yi64CuJ9/98EQ9AyFSTyXhtzH8rXOoLM8zp4n
Ur5Ga/9F5yDMxkcPwWF88DEchSOwgm/PwEz8+8FIsw85/zzkruT9BO9jOU9/
yG2SbSGew3CaPd/lug/lywujzWYQjxx8EOP7Rb79CDX4bj68Be1hj6li+yqy
lqJrkD2V2J+Bb0dDOv9GBui5H1lXYCs+3RJ1n8l3PfjsUMxjoFgoxop1Pzqv
wGrZT/zGQ33Ez6yzr0FGE7zJ3jZoRXYbNPPcBI2wBn4K+dnlg2eRdYFv52EG
ssqhCx93pvxMOptyXLm+CB2LoZVvb4R9jdbOGuu1pJraHHMZknWEGB2F+gKz
OlhPbmyAdP6lRdwm2ZbJmki+f9M/xUCxyMJn2QF6DkMEetnzNfwAZ2E/Pt4H
27BtO0zBh5PhSVgGl/nWB/WcdTmcQtdJKMXuSVCR8FgpZt+OMZuGDVNhOL4e
UeQ5rFx+gLM+CHcVeS2oJj5DTh8+vxT1GlWtTslCP+xA5074BnoDG2TLy/AS
7EXWOynXIV2DfPsPypB1E+xSL4FK1lSkvMeo17xILbwAhXxLwkHWdCc9h5RL
W6nNLdCCzLWwucD7mfJlecRrRrVjnHXIGK9B1WImRKECGXMhjbOkwwFkvwtn
ONP3kE4M0oKcVm6v4V9j0vdobxLZhTABiqGZf02Qg59zE+4T+WYia0uiLlOy
JVOyc3K91lRzZei/jX+3wtvs2QPz2VMTdZnNwTf960R2F5xg7fEs94l8U8v5
C4jXSnywpMB7qHqpali1rJxQbvzK2t+S3rPVu6dSc9MC9Kwepl6mGClW6oHq
hV3868zznqXepR6sXrxKvTjlMiVbOaXcUswUu0L2JPN8ZiwIepZ6115074Ft
sL3Ie5h6WR+xugxPsWYZVCGjOuU9WL1YNsgW5ZRySzmiXOlA56aI91z13hi1
mx32mafZVxzESmu0dnugWzNMs0w1vyjQKd3qMeo1ygnlRrVsUZ7CI0nPKeWW
ckC5MD3uuaeedXvc12itcroy6Onq7ZphmmU72bsDbmbvLUHPU+9TTiu3NWM0
a1pZ25b0mlRtnmbPGWhn7cYi7+Hq5XUR168aaCDONXw7xXuG5gHPj8JC6KbG
D0IDrIJjyDoOhxOeO8qhj3iuCfks0Uy5c5zXWEugU7o10zXbNdM02yRDsjSj
NKs6YBPsQMfOmMdUsVVP6w16dGNgg2zp4qydcBHfXYIv0fkFzGWWV2S7zd3B
zNDs0AzXLC8PZvMAtXA1y2OkWJ0Neqd6vnp/ddjvAroT9Ca8x6rXqoZUS9XY
WpXrNa5afwVbVuf4DNAskM/l+4WBL08SoxPwCWs+DdCz7hi6a6hHq1erR6pX
Lo373Ud3oMVxP5POJhmSpR6oXqgeoF6gmCv2skG2zAvsV3wfpp8P6m4AB/jX
DfmcKS/hPUO9Y1+Wx145sJ/nSK7ftXTnOsesz074XUl3pljCa1S1qppUbWpm
a3brDqa72P/XYoGA
         "]], PolygonBox[CompressedData["
1:eJwtkstLFFAUh3+Ylo+imZyZ5uU4IxoE4ascFWphtTFaCQ0oFiiR4yN1UX+B
YAvRMUctI8OpXSqFi6ygFrUIcpyxoNbZIlsU6qYHuei73Fl8nMO59/zO495I
91DbYJ6kE1AAl0ulTph3S2kCnyLSpF9KwPVy6WWR1OqSYl7pGefrFdIGfIA7
ASm+T3rgk+7iz8H2Eak8H32P9BitReiqlL4ckq5it49KO7AVlr7BInUOo1Hh
lGbReU+NJL00OaRmCJDvh6zL1vrIvWvkOQ5KK/TQy1kfdByT2mHEZWt1U8uH
nheC9OUvlB4Rm8E/hz+NPY3+GfhVJv0j9ge7Rd/foQaqoYFaLcXSKWwxFEGM
+At6KcRvqpIa4R25P9FIYx+a2viegK1v+hhkl6vkjDPvEP4wPMV/AqFSW/83
uQO5nfdjJ9hTIofxL8GN/byPiVXaelly1iEDVezGQY2/Zh7YgzlqR9G7EJKW
qLUMUfo+y0yN2AZmiXrsHsw+Uuw+wxvMk1dHTi3Uh+zbX3TbXZudxyN2njbe
+zV1XsFN3iNdIp3nDZLMPmVAp4d7t/HfcucHPb/BLtBrClbRWUP7Htpe9uCD
fvrqgzj00OdA2P4F8ycm0GlBYxJbRzzEX8vyN+vxT8JnNHupd4WZgmiXwY7T
5iTISdLPNGSctq81em0n3gFfydmE+5yPHaBndrxM/hI0Ew9Ta5d5U5wvwGzu
L+2idSsojUKMu3v0fJx7JWg/N/tgLy5mdsN/viaCSQ==
         "]]}]}, 
     {Hue[1.], EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlEtIlFEUx09PdWS+rxkd9HOccsTCFlFmkGaBlVGWVggWaVEaTS9T22it
KgvUkpqyEukBbSowoYKeglCLWkRBUUFaSBlEBD02tSnodzjf4vI/99zzftx4
Y0tN80QROcSZxAk4IjcgLroif2Mi4ykiM0Mi/VGRilSRPnB2WGQAmc5ckaeO
yTwBF3GOwS8Dw5yUKSLbsJMBHYDeCX4OiuQFRELwH+WI3IP/fJrICG9F2H8H
1mA/gcyeuMgC7vPhfwAPOyY/7JhvjaEQ2SM+X9/zifUxul/y8F0gMoa/SKbI
dvwtTBdpBAW5M+hWgqu4f0K+UvNFtgv+KPx/0N3QS6EvueYrzbGjdDW8CdC9
0CvA1T6tvIO8rcfXATA7YvyMsOWjeSWI7TX0OmTqMkTuo3OcGj4AN6HzbbJI
KvQtDx10G6j5SXTa0U2CrTNEhtJEmsF65JZjZz96FX5emt9113K/Bj6Mm8wQ
2MJ9MXQrGImZr3Tqs4N7CfwEuBb929i5A72RGo5gp67A4tM4y+B3c94jfxyc
B38H8lvBX2GzM4ivmoj1RfuczKK2U0VOgSfIoY1cesBnIdPtINcm7rvg7wVv
5thc6Qz+8edQed+jlmM6ftIdi+0qMVRxxtFdA77Mp3/42pAtEgybvOrdJaYy
Ysui5h70R+SzwZWu0cXYu+xazUs1V8/qE6A+Qb8mCc0x1+g12I651tPpYBIf
XcRZyjz3e1arC+BwzHZhOXbqozbPm8ElyPUgcy5qddH6NNHTia7ti+7Nad6W
Id8LljgWm8aY9ONUnsah8fSRV4O/g7qLOmca226dN8/4X6l3s2t12Af+Ctmc
X+G9Lm67XxS2WDXmcfhv4jbPW7BfmWmxJenFYI7lqLmm5tleB8Cznu3RT2wn
Cszm3LAdpdXPmGN+dc+K0SlHtwgciNue/kD2kmf10ToV+n/OHXhZrsl/C9oc
aH+nRWzHdNfm0J/abJsBnYVY3GbjLfG0u7Z3ba7JqXwEvSJ/hnWW1/l/oP6F
HeiPIt9C3l6G7c497P0J2j4WYqc103bhKLLVfi90RnR/lNbZ+R20mZ/l2qxo
X2pdmxWdmfPkNeb3SHtVF7X/8EXI5k/nUPdV/wLt+2jIdkZj7vLsv9aYq/D1
KmR/WpQ4yx3rhf5tFX5PdR67XMurE/wPgpjOEw==
         "]], PolygonBox[CompressedData["
1:eJwtlWtszncUx4+iT136+/epKm1VladeiLpOXTqJLRMhyxRrNoJM02UNYm7L
XohrvHhUl7WjtbpkK2vm1liXmWQbEbxT9koIgkwMQfe4lchk+3xzvPjmf87v
/H7nfs6/uOrzuSvSzGw96AHOFpqlR2YXgtmMErOt+WbnoAPYkTB7j7OT0M3c
GTPMbGqOWTV8E3iKPIV8FLJ0+NYss5Y8s23deZfBmwKzb/qZVQXXKd3Vw83a
uP89WI2+Jt4/QfYY1EG/AhOQZcG/RF8C/iB0HHSLm+WjswN6CDiA/UfZZh9B
b+LN2qHug3x5Dr7jbQtvhgWPUbH+yJuh8HtB+QCzUvxZguxj+E503UfeqNjB
Jei9uWYN0GWgHb4VFENv0xmyFvjB0HvAePTVwt/PNPsKfhHy65z9AD0SHEPW
AJ4jb4b/C/l++CLo82AAsd3A59zIY1Jso7mTDG5DtmRDtgoVH3xf7v7ey6x3
T7M06Pp8p3W2sshjVKzyWb6PQ/9R6Db5C92BfD/0FyCnP31A/k7w/nW6WeVA
swrONiLbAN6HvkQ+J0DfABUl7rN8H4jtt4Z4zVS7XeA19pZxVtPbbBoYDx0j
37O4OxH5ZXT9i44y+G4grdB7UL04H6SyXYd0fQtiyKYOMnsRvOfUe3n027Hg
OVQuZ3N2HXoKcsPWAnAI+ihYjrySfNYhv0cNkqov/vaEL0XeWeI1Uq3qVWPu
tvH+18h7WL38AXeuQI8Df8a9B9QLedwpI74/eL9YsYE5BT5DmqWzoIbadOHv
aegR3D/O/VL0HQre4+p1xahYNWOatYvkJIO7/+Dv1+i6y5sz5LI2hm/oO46+
I8zbUtAOnctM7eR+IyiCno3/DZHblO2D6O+CfiZ75PI2ZzHqvZX3N6GrsHEk
8pwpd6qRajUPvrKYWUF+OPI7uvsluJ3pM63ZTqLjU3Q9YLnUQn8WvB+T9NMC
6IXUdC7fLO5fw5cHmd4b6pHONzEq1l3I56GvCfwcuQ3ZWhG8N9Wjm4PvEO2S
FPQW9DWTs5rgOVVuM4L7Ip/GQk/irD34TtBuuMY3iexd9tUd+UqPrw0+s5pd
1Uy10w7ULkzF/X6S/NdT3y3491PkPspX5Vy53w5mwr8TfB/Wcf+3NztLu0s9
q949EVyXdE4L3hPqDe0c7R7FpNgegqvYm86OWxd5DpXLVfAbI99Z2l3rsN8C
/4tqiP3JwXtDPbKPs/LgtVbNs4P3rHpXO1W7VTtWu1YzqdlMkYPW4DVX7ddw
5xb8J+BUwmdes68dpV21vMhrrZrPzPEdrF2snlPvaYdql2rnaPfsKPDcK/6d
5COBzxWRx6BY9E/Qv0Ezqln9O/i/RTm9Cd1Y4LkV/zjuM6xZfoqs3yDfWdpd
fTgbO9h7Xr0vG7KlM8k0Y5q1e8SwG3kv+K5C30HaRdXwo7hfHvnsaQbfjvwf
qH+haqBaaGdod2gHaBeoZqqd/nH617Vh/7/g/zj96zqwEYu8J9WbldirgP6Q
s5LhPgOaBd3RXdVUtb3DPGxKeI+p19Tz6v3/ATjLJLI=
         "]], PolygonBox[CompressedData["
1:eJwllElIlWEUhk82OOX9vXr1KteLXlOrRZFaFA0gdaXJKUtLTVLLJkyNTIsW
RVqZWWhFZtGwsQK9mxYaCi5a1CIoiGzQslITJbAi0lXU83EWL5zzfu8Z/nO+
7/eUVeVW+omIF8wFQXEicUEiYyEizTaRvEiRxCSRHRY22M9ZbpiIzyOyKlik
HC4e3cMEkWK0l7G3wo2ic6O5ES3S6C/SA98ArkeIDCWKhKKxW1orgJpCjdX4
a8FTuHi7yA/qrKTGXrhSsARNKqjArjZazqLDRerjRT5iX4RzUqOdXu4BN3aZ
pTk66WWKfLvgjsJtgOuFS6Z2GvWccJFgmN6CHSLf54gU4J8C6eRPo+557CZL
a1Wj6fFoD1Umlrw3qfnWrt+eAbcF+BPXQo06uBlmegvdBHNaCr/PzNPSOf6i
twriu/Az0HTN5gw/lHldxfbC1YAg/MpYkb5Akfloc8yOiM2h72HszXAj1HpN
H/nU6MB/AAapvZN8Lo+eb4KbhGuCi4L7CrfRfBs5ssm1zSXyDnsPKKf+C7t+
n/nOWnTZ9PyGuGLmn4N9Em4hGCe2MFzP6/ATwRjcK+JTiP0G1geItJL/Nnej
ibvxBO4PvbSSfwjdYeq1ENdq6vANfm6RWWZW6B5zlhmmOza7PmFp/QF6aSOn
l9zj8CvAALkKnCJ3sQtB4zzy4ncww3P4vaCZ+nfoI5UeffifQAo5ilz6Leab
Flm6vyvssZG6E/T6AV0yukJ0L+1qD8K9B1nEhceI/Db7sOn+Qui5mfha8kwT
fx++3qmzMTNKsvTsEhoH/R3nPB1cIzYKf5oZBKJ5BjdKzzP4/fRSYt4e/Gdy
luBP0ksDMaXwX8Ax+qvh/p5BU2LuI4/c69DapocLcEPM7yyaKofajZbedXPn
+zz6VopsOkczz+QwvZ/Z+P+AL0bftXnfqTa9S9HE5YHt5MkEnegXE5do1/6f
mztuZs33t4XrXrPwu9H6qLtsATvG7ofroedc8udHifxlh5Vwp0EO3G6X7mu5
TXdqdusk3xp6rrT0X2H+GRFhOsstaGbAOnoe4R22Yx+xVN9Nv4fi9B/nhosF
B/AjHDrfR5a+J/OuDG/Op+APoq/AL0zQdxZs+gA/mdV/IzS7hw==
         "]]}]}}, {{}, 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVkr9LQnEUxU9T8SSw1NRMSNOooSWnBqGlNStwMR2K5oyWhpZ4DplKKJkl
GdEg1BDVYC39B0VB9AOyKaKaxBZbGvo0HM73vnvOuff73vPNJ2cW2yRlwVpA
Oh6UVgekABzok46C0gGoWqUmHOaZo1sagW2wyyHZwY1TOsdf6ZFq/VLLLUXI
qHdJcx561DUwhGcd7zAc9UnP9NvRPcFe6gT+DDkezvc8m2LmI7xDRhkckvFN
vc05zE771FXmx6lnQQj9KAii+fVKZ73SD9wCX2Tn2W0TfKBJ2MhmTpl5Kb+0
ZJfG2SUJm9Qp7pRDmwXv6GPoH9Dvor+E3dQh9E74gvqN/AK9PXYqgxNmf+L1
s4vQRchw/ftAkZ1LaMa4Q569m2iK1FucC+COehL9LRyjTpMbJd8grwPU6cV5
hxPsaWFfB/cz4AwZaWCCa7zTeK/wbuA9hV+5k8FsK7Dgb9DvhG18kwaZFfbJ
wSXwQs+El/kfFth/BX8JNsEfvWFVkg==
         "]], LineBox[CompressedData["
1:eJwNkb1LQmEUxh9bXPtSUyu1tM3sokgQTgUhFsgNjZzKwb4uWmj/QbtSQziF
RjSE/0CBEK0lBLXW0NRQKS0RBf2GH8857znvc857byBfMos2SQfwFJTeYH9C
+kITw5I9JP0Rf/dLP8StUckYlHIBKYIWqFmQm5Ly6AZ0XeToKmQ5d+CzTtyG
spcZA9KjW3qBV5in3h6TFtAKs9/xfWaW4ZeisAsWbMI2FGCH+SZ9IfwzaNEn
7UHNIyXxsYir7FGDNbim/wo+6A1z5xO9JD9lpyj1BhpxSjG8XezYJHez2xnq
IY9zHqd+Tj5H/wXa4n4Pn2n8uugiO9/yjgbvmyW+I16hVqW3Q2yMS0sOKQ3Z
EemBt2bQe77tDXubnM9M8h24u0V+zL1D9GiIWficoCnm9PgHy2gfnr/02pgX
RMNQ5+1Jen34OOEf1vRHdA==
         "]]},
       "17.1`"],
      Annotation[#, 17.1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwNkT0sQ2EUht8uVn+31VKliqmp5iZN4yeRsIhI/KQVNwaJkF6aqkhMxo6C
MIhJOohB7sJiaoiBgabEz2CQYGlEQiwiDJ7hyXvue853vvOdG5zOji24JK2A
OyQFYKBd2jGkcJsUAlVLv6irURqqkT790iC6XSs51G6iuXppq1VKof3UdtBn
1C2d8n1VJSW80nWLVIRuvGFyZkCKQpG+JbiEB7iAOD3y3HtGfA69HumeHp2o
E5T2uaurTtpDY3jxZum1UvI1SJPEftTrkzyoAc/kYvgRavOcMTm7ix7QK4x3
Q+9Uk2TDBLlVZkyi65DGy8AGXhZdQ0+YP8EObM7PwRHvOoRj/BHebnPXPJhQ
ovc7tY/M84YuU1fgTX3s+AXvCW6hzHuXmLXAXFNgkE+y33FiCz6YZQbN4Vv4
aeJZiNDTYoYo6vBvftjdNzv/I1dB3EP9F/Ei95bRO/gHnhpMgQ==
         "]], LineBox[CompressedData["
1:eJwVkr0vQ2EUxh9jRYK22qoq/VCLyWRowmBhQJAmTZtG2EkXg0U6UI3QpFUf
bTUkDdIKhpr8Bzo0xFImA6YSg4RY/AxPfveec57znvPe65pfml5skpREq17p
zCeteCQP9Dik0z6pgIpt0gf0EzMbpQFohNYOyYSqVukKf84iVXqlr05pgh6P
7dJcFzneK6gfzzregEtagyVidWoi+BzEwjBBHzvPNbP0QK5E/wJ1+/Q5grtw
B/mZ6ZhckVgRlpmhhLx4frqlX3Rpl5wm6ZvnN3onmW0LvbBLmPghvhM8eThC
fBh92qQoZ2d7mImaGacUgpMwCO+Z7YD6d+qy0EZskF0t8JrcM+fkmSmLxvDU
iI3Dc2Z5pX8ZupjRi9+H9ujhhmk4xE7b7JZEafwpmPonuTs8VeYKEotzR7Oc
Y6BfAEa41yR1ITjq5huxr4HaBLE4iqFb/FN4b/Bu4LmAT+xuoHcrasbbIN8C
jXybBneUY55NmEF1cjEY5f9YYN9l/BkYQ38cqlg2
         "]]},
       "15.200000000000001`"],
      Annotation[#, 15.200000000000001`, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVkc0rRGEUxh8LYeXjzrjDGMwwStM1mcQwpViQjWLCTVZoapCbP8BmajYW
spGNspDVrJXka6Pk21yUHTYWikg2Fvwsfj3nnvec55z7vsFJZ3i+QNIieBqk
APQ3SWseKRKWQvBbxmFAKoH3GmmgQlo1pBx1K2imWspCCuZgGpL4jEALtEMM
Dsmf4ZX0SSeoG5KuoIv8oJe5eN0wo6NW+mLGKfEd5GGjXOoxpXX0mO/uSukW
n3uIEyfApacNjVMXQ59LJZ9fGq+X/KhZJXlRAx45s6jZpr8VPac3gjb/+5C7
hnQdO3EPY/gtsWMxs6PEReg++y6TO0CT9M4GpQt6+zgLozvkh/hnCy7xOmLn
V+oe2GGPeBdS+I9yD1vs90Q+Dwvs5kAnd9DLucH8KHNM9JPZdqP0hk6hGXI2
b5BFZ/i28LfZYwJyvNMmfOP/w1kh75ig7oPY4c5fUBf+AK6pSjY=
         "]], LineBox[CompressedData["
1:eJwVks8rw2Ecx98u4sJ+sLFhv11c5bJSkpyQSZQsdsccKBdbKRprtbZptkQt
ZiUX/4RW1rTLUm5cENJcJHk5vHo/z3vv5/P5PPs+rtBaYLVJUhy2vVKxX9ry
SG7U3SOd+6RjKBikQfZ+GACjSbJ0SiYoW6UKnFqkn24ph4bJf7JuwCVcwzje
AWfH0JRTirEu4deNUtDOGr3rkJY5X0GzaA2vRI8TchfoLn3e8IepUcAr4C2Z
6YHvIfvdSxZvlPqNLsnBb79468xbIhNk/8j5IuszyJN9aZdGyH+QzzukI7CT
m+6TAjAJNRezQZb8M/l3sptgI/dF/RXqT5CbZ39Lbg5NUafKOoNe2aQnevg4
k2Q/y/0OqeVi74QIs/i5UwIvw72SaJX7ZJj1huwCWkaLeDb6LdIvQc7KOkZd
M+ql7hA14vhRmOE/nYJm5trhvIEZ9tAHet1DCz3aoJVar+Ts/98VctTY55un
oY4fRcO8iRBvYoM3kkaj8AdCg1e0
         "]]},
       "13.3`"],
      Annotation[#, 13.3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVkcsrhGEUxh8l2bkMn9u4fAxpaCIxTCmKaSxsvphJdqNZSH38AVJKopRE
s5mykNUspZCiKeWu8TXFjoUsRWLh/rP49Zz3vOec572Y0UnLzpI0A646yQ3B
BileJHnrJRN+8qVft5RbKT2hoUJpzSUlqVtG58ul6Sopakq77MdYT8AYWMwb
gjC0QysckD9jplUqHaNOrXQFXeQHi/FnZhqvDma+4nVK/I5m0PUCqadESqBH
rLsN6YY5D3mSnzgADrVtaBr1U/vJzFVqv6kZqZFWiI0yLlzB3fBcYv3F3jZz
tqCF3nN6vWgj3LHnkA/yJmHmLf73gI84h3MsEKfwyFRLA6wv6OlHPWgz922C
S/oP8UnBLd776B7E6BnmDTY51z35a5jiXDZ0cv9e9vvAh4eBf4j4hPfZQV/w
nyUX4R/m0HEPfpw7wj+MQpK/2IA35n+wl81fBqh7JrZ570fUgT9mvlAc
         "]], LineBox[CompressedData["
1:eJwVkc8rg3Ecx98O4qL9YLONsachucplRy0OJI0clIYzHoXahdWEIVnbxEpo
2lpx4m/Qcpjc3BYJBzkwN4nXDq/e3+f9/fz6Ph9j1gwt1Ehah9UOKd8lRfyS
gRqtUq5TOoasVerlOwA9YLVLDodkg1KzdN4onTqlH7eUQU3iPzlX4AKuYABv
h9wgmvRJcc4F/HCLNAUFm3TfJE2TX0IP0W68S3ps0WMDPvBy5GSr4Ifpe4ae
QJCa/VBxSX9e6RcWmbNAnom+kvtGXNEiPaNfxL2gXmo8oaNt0iN6w30ZjXC/
At/UmSN/iPthGIQ7Q5ogL90u7cM88y4Rm+ScgHG+D6gxhvrx15ghwLuPmDuB
7+NdaeYpcj+J3qJ5PBe93LBHnBON8x476qdmH/m7+FEI8b9GoJZZYuRbPNIm
es1MZXrV0aMB6pn7nThPdWeQocY2+0zBA34UNdn3DPteZv8pNAr/mI5QwA==

         "]]},
       "11.4`"],
      Annotation[#, 11.4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVkUsohFEYhl9ZWGIYt3GZMcwkKWUYyqTcZtbYkCzYaNxWFsisxEIilw1Z
2ChZIEWKopRx2UxDsxkLC6sJpZHGZXj+xdP7ne8933vOf35b/1jHaIqkGTDZ
JQu0OaS1bKmiXLLCb4aULJTSiqQX1GuSEuieVRovllaypCl0wCbV4R3jnYC/
QHpk9oI6irrJrgcXXOKdQW+J1AN3ZF2z575U6mbtwYuT+Q7ufPblSrXUNUaP
M4Lc5QMNo5uZUjN+hHVjjtRE7YEktcvQdOmV7wnh/5i5I70vdJnZVViCRTBz
ToCsP85eYD0P38we5kkx5m+M72buE5xGBl4IDvB9+H7uHWRPNd4cGefsC9Pz
kXnLXVpRO+qEU7x11kMWaRginB2FLt5gkvfqRLd5kwnqB/oO8uwwTT9GfgBt
IbuKnhdthyv+wxE6y12eeKdd5vdZD5ZJldyrj/+zQd4ObEGcjAReKv+4gZk3
6hHe/xkNwT9nq1l+
         "]], LineBox[CompressedData["
1:eJwVkTlIQ1EQRa+VBCVxiUvikh9cPmksRBCxtEltEY2NaxrBLybB38hHxIBE
QRLBiAFBUSxEFJsUlkqwsLZQRBEVjYiVjZUnxeXO3Hnvzrw3wan5YatC0gpY
6pSOuiW7QzJgo1U67JLyYL9G6iUfACHgqZMGg9IQeq5d8jdIB/XSXqP055MW
0GebpOc2ND81cIaeh3dBHI8wZzKGVEA/BrEWaQaEiM/xm8ZrHNx6pW3YrJVO
0A36/JAnmOGUHpPkX+Ql8E39xiN9wr/N6HCccx/wG/V3uEh9ndor8Rieq3hE
4RfyNPo19Udim/gJtrj/AId55z18RT0ZkC5hN/MnOWeVZ0SLwCa5l5mW8c3x
lk3uBPDfon+R+ggcBRvoJvUIbx4FGeI5/iWNZz9/YxH3wSl0B1Txby6wiBbD
24bd5Cm8LuhXjV+BGXvQXdytZO4Svr7yvsAO+hq7zII7dAe22PUEu06w+yzs
gH8fjk9a
         "]]},
       "9.5`"],
      Annotation[#, 9.5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVkU0ow3EYx7+sXJl38zJ7bWYXMW0lpYyDi1woceAg5eWiLKzclRMHc3GU
Ay4US2k0OZDEoqUcpKyZw9RGEx+Hb5/n/32e3/M8v9/fMjY7MFMgaQUZbZIJ
dTultXLJ5ZDMKF8i/dRJRfVSCvaUSjm42yjNNUgLKIi8+If4kyYpBmdgFJ6i
BD389I7itcIz+MH5NOozSqNmaRj1WyULswPUDPFtgIOwg/q7MinDnPYaaquk
NuIsM8fhQ7X0iLoqpRMYQccoTv4Xr5P6H+iF13jvzEghP9/LzF/nblf4hlrJ
wU555oXws3AJfkM7/ie8pG6V+iTnWzi/SD5XIZ3ju/j+Kpb2mf1G/gLPRxyD
zeQCePfcZxPewjAMc2cnuV76ONkxQq8N4ml2eYVx7ptAT8hGnyDvGULzqMki
eZAbOdjN+r8vb52kn4fYjQLMifF2B/AIPfNeO9xlj3jCTg09Rzgfpt822kIZ
euTIFfL/feyYJp5izxd4g/4AzbZcBg==
         "]], LineBox[CompressedData["
1:eJwVkc8rw2Ecx98ctGh+bDYbtvkOazs4uElKjVLcFF9CakmJIZnL7GR9Z6Hs
YhJFtCMpLf+EUnJbIadpOZKb1w6v3s/z/nw/7+f5Ph8jtjG5XiNpD5I90k1I
2umWAmigU7rulc7gslnqZz8AYWh0SIOGFMU/8Utel3TllC7c0q9X+oOVNunN
h9dODW7x7C1Sgv5z9kEyHvGKUIASteUO8lnfkRcjK4L3QE4ILeA1dZHvkX4g
CdtkfONX+LaCHuEdwhfrj6C0QF+Z2jw6xl2yfP/C2fvoKPsRqOW8OerP+Bb+
MF4GjaIm/if902iJTIvsoWodNVulfEA6hQj7MLh4g1nUie5y7yk0S5+P/ndy
/OgMeoAX4lyT/33CO2a9yrusgcHZFvtN1ml0nG/cvPUEWs8dbZDg3ZfId7C2
Q5rMe85qILfIPPqo2+ivI6tMn6c6M8jjZ5hnDl7xU2iceS8y7y3mn0NT8A/W
L0nb
         "]]},
       "7.6000000000000005`"],
      Annotation[#, 7.6000000000000005`, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVkk0ow3EYx78TNzEvw7wM2zAvuykvJy83Oak5qEXKQcJBlJdyc1BOSiYl
J6kRWZjEYSYHtTIHOXDQQqyYl9EoH4dPn9/v+f2f3/P8nv6lvcMdQwZJc2C0
SWZoLZfms6WKMskCCaP0UyilFElPOA7vsFUibcCIRRqH2kypp1Sqx2ecN+LB
fKkBH7MPwhGcEvPh9gwpSn4bdhdL3XBikiY4/8yVkuglnCW5iHfCKzVewEg/
XZz3sXbjGb65zpMi6VJTjnSJD9n7YYmePeClhwUcwnvEy6mbXCBNUzvNTC3W
BgiTm6D+738P8A1fcEH8DbvI+8Cp5EyQG2NtI7bKnUHunqXGA7OroS8njLKu
wpVg4psb7jnHy8RbcDMEyDvg3U7e48dW3rADPvCQtwj31Npl76LeNp5ifpMw
Bg5mHuG8GvfzBjvfnDAvB66ER/Kr8TMOMqsr6gTwPt/csl6nfy9ssveBhzvX
YAVizDpuZzb8B3X0HGU9YJXucAj+AJUuXmw=
         "]], LineBox[CompressedData["
1:eJwVks8rA2AYx7+zg8uwYRs2az+Mi4ObJOIwtnARtRx22A5kshYOfhbLj0it
FeXCGqXUlssu+AeUiHalKOWgOO7GZ4dP3/d9nvd9vs/79HqiifF5g6QMrLRJ
5+3Skk9yoS6nlPNLJ3BmlrrYd0MH9HukHhgkfuSSThukNJpF43ap3CzNoO+t
kpFYtkX6ZF1rkfLkTOgCdRYhbJVGyeds0itxB3WcEHNIUajCI8+ZKWIFNE69
S7TglXz06oXvOukOAm7JDOUm3gNtePogQt0R9KBe2qDvfbSPeyFiH9QJVvqk
rxJ9vMAQ+1/q+TkTYG0g90z8CQbZ/5AbxmeA9R8+Yeo/ktuu1CW2gscy9LJ2
gwfi5DaZyRt+W+hVo7SOrsIF7PKmIH576CxnD1Ebb95HDcxggllMgpVYIzzg
mWFmAXzTaJJZJiBFryHO3ZO308MYaxNnDPje0PMtxPCzEJtGi8wzRb1rtIh2
4mWkTjV8cdeO1sAx8R3+QhpKxNfQOfqN8FeS/J00ugb/wnhQ6Q==
         "]]},
       "5.7`"],
      Annotation[#, 5.7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV0rtvyFEYh/FvxUTqfim96X1jkBCTxOUf6OjSRiuGSvRCWwZiaBPEhETd
OkoQCRraAa22GCQm0gRpomkMQrQRpSw+HZ4857zvOe95z/n9Kppa648VJHmI
5VVJEXbVJpfWJLU1SSn+rkj+lSSLS5OvPIefOCreUZZ041BF0ojtq5LXck/x
aZO6PI4xPMPLjclWawaMJ51xeX1yBWNrk1FMqfnL/DN3W9uJcuuG1iWDOKXm
SRxx5rnVyWE+zyP2DGN0Q/ICIzhr393yZKf8Vb2/c+5QUfKe+8zv8Rn5Zuue
iDfxafN553TKd+EEjqNQvY6VyS137EeZHnq91Ty3i//mNv7DPeKlfNO6G+iw
/4BYq3wD78MH99rPbXJ1CzkusacYS521BO1i1+2/hj7M2POlMpnlH/qcwaCe
qxfu7S4N7tCIKvNKHDTukt/B3bzIW9V6i3ANF3AP31Gnl5vM9/Cws3bzc+7U
Txe6MeZdxrFXrl4PW6zfjMdiE77XA36EZc4rxLT7thQnr9S/qO8LehgzrrP3
u/7eGI+qNa3GOE/wJD6iWb378gPo86/cRj9mxeeq3cF/uU29b8Ytak/xW/wH
47B0pg==
         "]], LineBox[CompressedData["
1:eJwV0k9oz3Ecx/HX5s9phY39Y9iwizIOlgsNpcYoo7Ti4s8QthXS2lyWMcV+
bfl7sSaiJA6b2qg5Kg7iwAkHIZyc/Xvs8Oz1ef/5vP98v5/a/Z2tHUVJxtC9
PLldn5xaltTQmkXJ6IrkBm7NTRrYjajH+tpkHZr4hxcnV1DASFlykxbRzzXJ
8Yqk2HmkOplJv/BNzHeuTGahbUGyB2/UGS1PqtytRrP8NfKf802hpC55yf4m
9kHfE84faQd9osc4ri9NrmGySl/+NrmNtKDPILpxqTRpMcMnM+ygg+yt9DLd
aO/tzpvoafc201L1Xs1J7uu/V7335jo6z/x6HKEXzDCA8xhWo5+ewzb3Dov/
okP8reruxi6088f9Q/SdegeWJPem99PnoHOT2S6adQAb5J9Vrxc9qGN/l/MD
P/FA7i/fp0+PYr1mIBjj/yc+TovYa+1zkt3KPqPXTto8vS9a0MO+K95L79DV
8ivs20AraacaXXiq1zOs4t9i9jKxUgzxvfYPB2kBf/2PP3hhx5aFyWM5xfo+
ci90Qq128Yf8v80+RcfE+ujk9Bkr1Sv21mbjqxrltARX+fu9yQLe8vfQY3bY
5812ecMF2oP/a81oRQ==
         "]]},
       "3.8000000000000003`"],
      Annotation[#, 3.8000000000000003`, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV0ttPz3EYwPHH4oYUOSfV76cys5w2IxT+AEzlwoapuZAL5kY5XKCLpqbh
QjaaVsxh5lDYctpaMrMZFyTHaWiLG6cuHDZeLt57fz/P5/k8z/P5fr+Jyu2l
24ZFRD/SpkdMwoqCiCPjI/LzI7Lwc0zEr6yIlGkRgzyEb9gqviM7YieuW9/C
TbwVv8LtuIT5GRGXeSA9IjElIhc5mDku4ugkvbArM6IGO5Gr9+pkxLnciLOY
nYgoRJ1Yl9wa9e+I38YNNVLEl4+N6JgQ8dj6k3mecLp4HX93dgg/kObsUjVG
8zwzzEXJ/zP29vAg7+ZsNYq4xp3Pm7+aL/AeNTeYbzev5xfoQ+HkiALO4P3u
sA8f5Jx25rCa1TlqYZ2cZ3iKWXKr9eg0T5u7tGJqXkQmitzntfOLuck3WSu2
yswbeSWX8zHxRfZfyVvIrdZt6NQvqW6lmVv038SnuIK/eEfN+p7ECbSJbxbP
k9/hbCPfU6/Bc5U+3WbbwvXW3eLtfBXv9Evo089JLuFB8xfzEvulnstQjlrr
Fr0q3Hmvd1Csxxzv/aPna2qmqj/gOV+vr2p9Q4X3f0DeaPE/nMq/OWn+BO7K
rbUuUfeQusfVaeTn+vWhV82R9prk9UyMuI9U61FY5ny2eiPkr/GdylCOerkN
GC6eZb4UzpR32dku7sFBsRn8EA/QZYb3Zh1AL97gJSr1v2i/HU3+/TNoxhfx
Id/uLxao9ZmrzN7Pj/APHUWMTA==
         "]], LineBox[CompressedData["
1:eJwV01tMz3EYx/EnymHNWQeV6HiRsbGZrTnMFeuwyYVjVzZMF7K6YC6YyVyo
v1GUSLlDYZYNG82V05xvnBYVhVvNjC54dfHe5/s83+fw/T7f3y9vR+3GvUkR
8QMHCiMuFUfUF0Tk0JyciK6iiFZ0zIxYwl6OIqzMi1iBNfynciOakUA72hBz
IobmR3zBQGbEIIZwZ0bE1AURn+xPoZ/pRP4JKM+KKMN6DPBn5kc8XMinTzke
Wz9Cr563MyJu0afsJ3gmfpr4klkRN9MivrFT1f9Oi/lr6YAaQxjEZLmj6c5A
6+Qvmuc+Ykbs1dNhWkcLsyOuqdnqfGdxBkvYo3JqaAWtRLrZZSDF7NLoXPxS
f6f6x/keOEOjetes95lPtbmcnx2xnbbTJv1+mk26WmlIsC/w33OuTvZFdMu9
isPoUW+Z/s3W59GOaj3L9Kuip9lL7XeLO2R9GVdwQZ0ObNP3nPpbaRtt1O+3
81aIz5pr3jSbVtJ6TFdzLfud9Ul1UtSewZdME+y3/J30Ijaot0u9KrqbLhbT
Ym55ZpmPHnYB7fA+x+Q1iCt1jqN0v/gD4+9kbxBd9ie502Yz24JNqDHHbP5h
mkW/0lxvPh+9vos97CT9+mmT/RPO/dKdX+G1WqvsleK++/YhrP/JWy0/Wc+P
8tb5Bp+Lf4E/9v7iA/9v/d/TMdok9yq9iet8/ercsO7B2Pjb0T4cwV30okT/
JP9PCkbMII2mooW/wX+WwBv+g7Rm/E39h7XmnKAH8R8tMY6c
         "]]},
       "1.9000000000000001`"],
      Annotation[#, 1.9000000000000001`, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV1MtXVWUYx/EXFAm0tUqQZAkHDjcFBRUkM/MPaNrUUY5qYmNmrdU0rbR0
4iwrEFerWl4wxMgypcxCo6KozMS8I8RFDrc+z+DLdz/PfvbvvPvd7J3d89pL
e/NSSi/6c7kupet4pSalu7ytNKVFnsTYUykdqUjpKA7h06qUuvGy/nAmpREM
YRQ30F+S0kXnB9CA8+jHx2UpreVyrCtPqSKM9earuBqV2GUNL+Cc/FL1GpTg
GZQh39oOOX8YB/Ee3sVx+Zt5C1rQiq3IyX+Wt6MN7diGPvlNvBGNaMYmzJp/
3n3vxJO1Ke3g59AtfzkXYM5cIa/AtPliXol5/SJ+AmflJ85DTn8Z52Mq1sPb
sUp+e+w3jsl/rJ7FY/NznMOk+UVeinP6CzyPXvmTPIUZ/Rmexn/mW+W1xZrU
W3kLuuTfVz+Ia8yP8UNMmJ+I6+J6/XF+hM/l3+Y7sQb9e3wX4+Zb5G1GsbqZ
N6FT/nX135Fp/h++EVnmb/G/8Rv6o3wTZ+TnZ+0LlqrtEydkMKeeRw6LWMA1
8yOu+yPWIOcv/hNj8pv8/kYUqRt5Az6ynp/UQzFj/hf+Oe7Z/G/8e6xNf5h/
RY/8H3kwZvSv8dXYL/MN8tbHc1XXcx0+lH9JPYD75r/jb+PY/BX+Ia7V/54v
47T8r/kC7ulf5G/i2HyNvFoUqrNcjQ/kn1X3xTMw/wWfi2dg/jx/Fcf6X3I/
TsnviX3Fbf3eeIZxrfmMvKr4f1VXcgWOyj+hPhnPxvzpyMAt83XqemRRixqc
lF/JGVSgGlXxnM2/wwewH2/jLbwvfzWX4GmsQSlGzK/wHheiIN5rvTJ8Eu+L
Og9LviPL4l3HkPkF9SKmMY8c3pTfyV3xDVrr+8LdcW61e+c+vI4efIbGyPf9
Wo7RddbCxTio/0Z9SvswqN/Br9qH3Q0p7bVP+7gD/wMCi+Ez
         "]]},
       "0.`"],
      Annotation[#, 0., "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV09tPz3Ecx/E3ceMwpVA6Kplhw2YuZcyUCzmMjBvLL+uq5IIuNDfkUKaD
QxExyhxHLlywucGFmXGhTJJD/oA2EbPx+F089/q83+/P+/3+fN7fz3deZe2W
mgkR8R3r5kfULIgop2n0WnZEojhiJ46nRjxhv8BdPMR9ZPH/mRfxD9fzInrR
kyQ94hLtxsWkn32VdiExO6KzMOJ0RsTb/IgWmpoZMQOfCiKG0DA3opB/t3iJ
9SrszYmowmW+V3it99ZZETfsq5Bbqce9ORHZfDko4t+sz3y6he4R73fO9xhA
ivxu/mG1PmMfXy0OzIwozo04SI+Id4nlu+uttIg8mosW/Razq+wvty9BN9Ku
IvfGO3nNdKI9080zhZ5i9/OXOM80vv3WG5DFLqWZtIz+NJ8T6rWrt805ztDt
tNNcOtCjznUcwk37l6rdYr1JzTJ32kU72J1oxTLxW/Y1WPfiBi6ocxGPsyLO
q9+kXzo7A6MzIk6yz/JX6HuO7qC1vt0duU3m+FS9RuuEfj+cNzX5ZjCJL53O
xAa1ypDQf5Quoa3m1oZ23GYXmOU+9b7pV0dH6Aq6yLnq5ExWf1T9SfSj2BAG
UW1PljN8pVN8ny+0Mfnd1ZzK/5L9TP5z9Mnt8y4e0GXe0XKUqlGG9fjtXqly
3stZLbYGa/FLzjgG+Mfs6afj9JH5DCffKgaTmM0H/E7OUfwUDuMYjmKhvsv1
WYkR9/2LMbTx1/i36vGGne2fqza/K7QZ9fgPWOmNSg==
         "]], LineBox[CompressedData["
1:eJwV011MjmEYwPGr2ZiPqQglqSSKsClmheaEg0qpk6YVk+lIjGnaDEfUgTnR
hk3z2jgjy0kzH9OsA18jytiUrTYZyhknPn4d/Pe/7+u57uu67ud93twDR2pb
kyJiBM9XRoyicUVEC7atiihOi8jMj0jFZIq8ZRET6MIQBrFffEN2RAneLY8o
5+14vDCikNciH/PUKuBPyRHLMyKysBQF8jqXRHTg+NKIYziKLPkV8outN+Kg
Xs1IiD2UO6TvcA4jSW6ZmctTI3oXRbxU86tZXvF88TM8mRvxE1OY62ymGnN4
vRnWoUzOhGft/IVPcpYaW7g1K+LmgojDfIvb1WzQ8yTv5fcYRlG6u3IqnzHz
aYzJueHMRTVPmL0N9XLeYhBr5Lbp0WeehLtcR4bfIR2b3Oej85u5Ky+iTqzS
zI1cwbV8SbzE8w/yivm6fQJ9+uWqu8/M3fo38jVu4inv6Kq+V3AZCfFm8Tz5
d529wP3qdVq36NNvtkPcYf9EvIfvYES/bH1GOYe38oT5y7jU893W1ajBWftu
vZrcud07KNWjyHsfs76n5mz1x61n6PVdrR/4hlPyCjz/zav5F+eYPxt19oXq
jar/GeNqpOlxTrzS2Sq8ER/EFrF/zlb5TapRg5lyU/ScxX+nvxXrP5zMtxe7
7/Q7wHk97os9mv720CfnmW/jBfoxgKdo0H+Hnjuxx7e6D/XoER/wH3qNXfYP
uBcf8R9W44Wi
         "]]},
       RowBox[{"-", "1.9000000000000001`"}]],
      Annotation[#, -1.9000000000000001`, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV0ktI1FEUgPHTKolK7WmGlZW9gyik2qhBUBj0QoJoYY6obcaKNCnC0bKC
EiwoghYVlknQUxdlrcPHRhAKiqiFC23XIsIcnfq5+PjuOffcc8+d+RcmTh+t
nxURvdi7NiK5LuIg53Dn8ojqoojjuJ4T8UH8Ec/Rg1fIk/9bGJHB4xURLxZG
dPMTfsAjSyPeror4Y79bboIfyW9w9mVuRGleRBlql0TUYFS/UzxbTRYu5Uds
cm5Arh/1eiUxz95m+bm8hTtXRlxcZAa+wOVrIg5gH8rF51eL+az97eqnuFc8
yT2c5gym0bgg4pe7nsn/FI9jDAUFEefM34BGbBQ3mz2FErUJNYPZEV3uqrL+
ZPZKb5y0f5IPqz+CQ+iYucM7quT3c0q/FtySb+UruIyE/Yzz1fxZvxPe+1T/
IffkOlfmfQ3eU8q79C3hFj2KrVt5N/8w205Oic/o1Yar2OFchX413Lcs4o5+
d/Haf/YGdfJfzVDLX3hM7aD1HPf3+X3eY6t4j7my7c3HDblh/2HF4ohjmNIn
jXdm+G6Gf2a4pz7DCflvchPW7c7e16uZr6EN6/XZ5t5ijPpe0viN2/JJ32QT
hsX5vtU6737IN9GE/6hzc7Y=
         "]], LineBox[CompressedData["
1:eJwV0k1MyHEcx/FPNpaDjUIP8pCHmJkDM2MdunA0c4mkmk1FqVkdjFE5YB4O
CEdOMhtbm4dDHhbrIDOzuoQwZp1y8TBHrw7vvX+/78Pv4f/7Vx7s3NNRkGQQ
o6uTz6hfmTSjuirZtDApX5PMx/T8ZLIimUI/xvEejeIblyebMbYsKdJTY/y8
OFnPUyXJhxXJ0/JkntwGsUm+JH4ZjxYlD/HVOr/Mv/AxtZ2oUPdycTKMbmt0
ockevdZu4D5+qmcIL8rsiWfo0XfXPtXyZ5eKFyX3StXwOfMBPinfNFMn3sgn
zP/Zp02+HUdwGIXW61iQ3KhMbqLcGc6sSv7yUfHf3M5/uE+8jK+r60er/n1i
bfIHuBYT7rWXm+Wq+BCX6inBHHvNRovYNf1XcQUf9fzwJp942jl/4rEzz3Lv
++6y3x3qUWAe1Bl3yW/lbu5T38I93My9fIrv8Gke4HW8Rf1aLuZNzrEZr32T
URwX32X/22pv4S3GvdWYc49ju/NtQ9TN1V+Ib+7duiS5IH4R5+WG9JVZ5/vM
mxk/8UZvvOUQD/MIXqHO2jXuvgO7/WcNqMUD8RH/4zvsNB/iQUzgP3GBbyg=

         "]]},
       RowBox[{"-", "3.8000000000000003`"}]],
      Annotation[#, -3.8000000000000003`, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVkk0ow3EYx787SLa0zdvMZjYviyiGnMTBuEmplUhmCashpqWYA+UwFy7C
QXFaeUtKclYTjeTkoOTmMBcHEfFx+PT9/Z7n+T3f5//094SmeicNktaho1KK
eKVu1IzuOqRQldQHKxbpgvsl7MMJHIGN+I9HSuZLey7pAH2wSdkl0j167pbO
4IMaA7Ea3mRxPrZKXs7tdintlO5grEiapyaMnpLPoZ8RGqnzwa9ZGiyUTMSC
6FCeNIB2VUj96DZ+EzAFyQJpFn0ql6JokFpnqeQAL0wzwwxUc54jl8K3B8/P
YqmWWBczZ/Cr43xF7hq+yTVwr8TvjZyP8w3xNPyQa+L+jF8z2kpNnL4xPBbR
FmIB+rvQMpihPgO5+LTBBf1ewc07DxzSZ4FvGmGfy2iAb15Cxb797KITrMQs
kKLvKjvzM0eAmjC7HAcj8Sj7NaFPeG78z8ksj5yD7CRDbhjdwiNOn000gXrx
qGfuZnjB5wveYY14hH8hBrfc7fwjo8y6gyYgBn/DTVSN
         "]], LineBox[CompressedData["
1:eJwNkrlLwnEYxp+WxIZMy0o7TCu3ztUgqBxqCUWCiA4EqaEDqqGG2oKCaIla
Wwu6pkAzcGiRwKMICjNSQwSNlv6APsOH5/u+3+c9foczuOZfrZJ0BPEuKQsz
LikEHrc00CDZuiUTVOqkj1apCMfwAimYIz/owA+1+J/bJTNaapKCdvxopkN6
h3viHnyjZqlMPIL6iQNwZ5U2uf/Dr04pXS+Nk5+ACj3LYGKWj/t5zgF0F89T
M3uZJGcj+6DXxJdw0Cbtw7lF2kPD6AV5F3N/mbPFbKNN+uFcgSS1RbQEefiG
AiTIf6I+6r5QAzUb1GY5O8id0fOG3tvMyPHcRvaqgXXOBrQaFvC80idDboed
+4kHIETch/aCF98JnMIQsQcenFIUOnneQ7wJ3kUKkmAGC6xwtwxL0IW3wG5u
dLFFsrJjFE8zaoccvWPsnEcj7BGjJoym0ThM836HqR2DSb7tLEzBFflH/oEE
eIkj6C28wT8n8FsX
         "]]},
       RowBox[{"-", "5.7`"}]],
      Annotation[#, -5.7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVkU8og2Ecx78WkxLzb17G/pjXSqFwU4rTDiZtioNalANvbaEd2HYw7TAO
DnJwUM4cXDg4K5pYUmorJeftpBSRfBw+fZ/f9/n9vs/zPq9vKR6OVUnKwGSv
ZPVJU2gDeuKSFk1pDrIO6Yr6Gk7hs0m6RJ34Pz7po1U6a5HiTsnWKdnhsV3a
YP+3g3DqAP3V9JroOF6hS5pAx5qlO9Z5CFFfkD1Kj591tE0KkunAK6CN6MK/
x1kx8mvQeUOqRd2oB/Y80i7McKc0daBbSqG3zIWYfyJnGh3A3+LsfnQTzXPH
MP43vYN4Q5DEv8dPocPUEfZLzM+irz3SM5kZ+negyPqFvRK6Qv8aXhkqUO8l
C99g7px7u9AIvVk8k+8M8r03eBbrJKTBS8YBZ6/yLnXsreMdUR9CkbtEyang
lWGbrGPewE5ezk0m7z7CW9vIeCP7C95hH9/ifybggdrgPy/7mUVzkIA/g/JK
pA==
         "]], LineBox[CompressedData["
1:eJwVkU0ow2Ecx787rJxmbAxts/9mlBPJwsnLTmKJlGQHWsllLijKTSlHV3Jw
NUYOZuWlXGY1yWVh8tafvLSD3Dj4OHz6/p7v8/09v+f5/42J6cG4RdIyZOqk
Aoz6pRh01EtNTqkqKNngwy7duiUTVqG7XMqjUfzmWvLQDnZ6Qmi0RhoH0yVd
k0lRp+HTJ71DV5k0RG4AIszz0hcOSP2sLWgf2kb+yiEVvVJrNXnOaqR+Y3YU
Pa+SsuCrlJLoNmzBKfu/eB7yP6gDTeG9MMMEF+t55i95pAP8InMM7vSKzuE/
orOoifrw79F9covkn+m30T/D/leFtINvZf1dKm0y+4n9PbwQ9S5awl4CrwAb
9N+gabx16jXopY7htZC/I2/wrk7enOW9F+BnfYmu4E1Rx2ESAobUAEFwcT8n
LPCdHzjvhDsfg5XvekRf7v8MyMAImR563MyK8P/GYBgS+Gf85xyEWR+iScjD
Hzv5VZk=
         "]]},
       RowBox[{"-", "7.6000000000000005`"}]],
      Annotation[#, -7.6000000000000005`, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVkc8rw3EYx987zEVisxljGF/+AEspFy7bgRpLO0qmxld9l/Utlx32ram5
KHJwUA5OnB0okhWFaeXXigNnJ0pREq8d3r2f5/18Pu/n+Tyf8GwmYbkkOWDU
kMx+aQxugHfapZk+KQkKTdIheQnsgS+PdAD70X/C0qdP2m+WrBbJHZRs9EpA
ysK/bdIfGAIjwINW7pB8cK5buiYeRx/ELwJ6iKf9UgyvKDjG24a99EyhJ6ln
8a6jX6hVilNf7ZIW4EXyejyPGjmDdgKfc2e4U7qAU17pCs5w7hI+pZ4nviGe
wH8Z30m4Qu6gn1G/JX6g/x2c5v4j/EbtHi5Rr8JP1J/BFDPt4jHPuZfazOQO
9WDNm7zEjHE4AQroBm+J8uYYMIlzYIX5I+wmzV7W2eUGWELfgjdBNcR+6GFx
5h09j9c2fdz4FXmngT7An7iY4RXfb/AB1tBN/tIGZfIAfzzXy124CGzwD4LR
Tv0=
         "]], LineBox[CompressedData["
1:eJwVkc8rg3Ecx99qlMPabLZhj22PECdaEw4OKKIYS0kcxI3iKE0U/gEHR0XK
ZaVIfkRqHEam3ZZGuSy0krQsnLwcXr2/nx/v7+fzfB9zaj4yVyRpHRK10iOM
1UjT0F4vNZVLnjrJCjm7lDGkLGxAp0NKoxPkm/1Sm0vqQHvx2vC1/Odgsgof
PVmP9ICeEJ/BAQxTD8NdQIpTS+IdJG6l9uGT3iFUKUXwNnJugBfmxqqlN/QY
3SyTTOpxYsMt+Tgb8MvZgX7bpFf2OadeYEcXuS90Fe8arMAy2JmzwF05Zi8R
R6GAd6+C3fEf4c/j+wQLd+Sp3cMudTHrkLqVfLGXmXzDD2xzx47Ju1Lrpy+D
9tCzRb4PDZELwhN5P98WgFv2SMEQ7zFLHEYveZcZzjfk3eznhEXyz9wRRa95
vxJ6LHDhlErRFP1Bdk2go/R0sYeXOQP8s3EYgRj5K/5tErqJT9F9SMMfFaFT
LQ==
         "]]},
       RowBox[{"-", "9.5`"}]],
      Annotation[#, -9.5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVkc8rg3Ecx99qN7LNGA+G+XVxWY6yWbnoIYXkqB5aHrP58UgzB9poJ3+B
2kWKv8BBLc9BrSZRLi6ctJzQinLh5fDq9f1+vp/P5/v5Pk/YWp9N10nKQbxf
sgclEzfgYoe0OCDNQ94nXbJ34Ry+/NJPs1SDp1bpIiClgpKnXUr+u0saIi8C
UUOagAA9erul+pC01yM14kniPuyFU3qW6GdSf4Ud7CdmtUgL5IWo3+Quo02a
4jxJfBrn6XkEq8RX2OdYF8BkJjcsjTDLGMTAapKq3LVGbhrK9Ch5pQoe5/wW
e6m7x1XO7/A15w/4kXmWqS8yQwJ/0qcGb+SN8p4obJG3DXP0yOAEc9vwTO0u
dVk4IG7wrh1iLvPO4Bt8RizG94pDmppcJ++gZ4R3H7IexhniG1CFV0gRy1L/
znofn3BvmTt+6efhHjHnC/2+4QOOybf5nw5U2Af5z0t91OECOPAHiQFNaQ==

         "]], LineBox[CompressedData["
1:eJwVkT1LQmEYhu+WLBC0NDO19PQdSNCSDQlxiCgKA4O+lsAfUGPR0gf9gIh2
G8pBcIjIKJDSwAKpreRUtESEtBaOdTlc3O/H/dzPe55jJNbiq3WS1qHYLb3A
YqeUgJFeadAteXokO1SckhWQPmAfxpqlaIsUgS2/NBqUJqiLoEs+aQUWwKR2
Gk+WdZGMWa90g5bw3sEw5+Pcmy7prF0Kd0ifZKdZf6Hn6GGTFGqVDtAU+6BH
uifn1SF5Wfshh9eFXqFuvD9k7uCt4pkPSdusHW3SN/0qsMn+l7sTco7BSW2W
2kbUBs/c3XL+R06MvD1629FdtMo31vPNp8wnSU7SkI5gCr9FxiS+gS6pH645
e8P/Dg/0t9BybVacx5lDjhlc1mbBXR+9oswrwPsKvNlAbdw1wCNz2aBnGM8Q
+Ogzw39YhjlIk5WntgQm+ws0A0/wD4nzSOM=
         "]]},
       RowBox[{"-", "11.4`"}]],
      Annotation[#, -11.4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVkj1LAmAUhU+49a2lWdqHWA0t0lqBEUVYBCVNDYGCIKIpSmhBRR9IkPQD
Cgkk6h8ERYGgFLU21FIQiDkZCAUt1dPwcO69nvfc91Ud/qh3pU7SAbj7peCg
5EEb0KxNWh6QFmGnVbqgz8M5fBql73apBk8d0jOELZKhSwr9a480hM8FY53S
NJjIcPRK9d3Sep/UhM4wXzJJRuocmTfkeTh/ha6il8wCZsmLz4fayYixy2KV
rBBiNod3j1wb/Ru5Z9xhn77gkNKop417U8+i49zLx74K+xrpI5wpwXsLNVlF
fLcwgW8KJqEZX4acQyjjHWFHBX8M/zF3ycIjd13Ad0IdIL9GvpG+gn8UfwJv
lZmF9+TwePksySzIu5y86YXzKeYbzPzMttBrvCnmed43jxbRU2ZuvtMCGsG3
beeN5LvI2KUeRpPMo1CGEoSZrXG+Sr2J3rPnDn7IM7Dnl6xXMr/gAzL4g/zm
cXigN/Nf8DulIzQNcfgDjQFUNg==
         "]], LineBox[CompressedData["
1:eJwVkD1LQnEUxp8aQrqQab5bam8OSuCiLUJcSoSkIodelqC2lhoaoiEh+gAR
7rUUIjREZDiIZmiBNEbcgpZo6AvUGP0cfjznnnOe8z/3jG7t5nd6JO1Be0J6
g9UxaROmo9KUS3JPSgZ8D0rWsPQJJzDjlNJuKQWHQakAawFpA1bAxDNPrULc
xrvokxpoh9mPkCQ/S90ckm5GpHhI+mJmmbgKt1B0SGGvdIpe8h3y4GXOE3iJ
A1DD40Q99DnQd7s00N0lQh51+aV+1AYWNYOeEn47WsFrQ/ugRe4B/thpgVnH
vGmgR+hPWPqFXvquuck2fefoGf+RI7aYk6V3DpbGpRjUyX/guaDvmR0s4lfI
kF/mDjW81e4tqEV5M829gtykyd4R9IB99yFOLQF+3shx93XIQ5kZ93g6YPJ9
h17BC/wDSg9Ccg==
         "]]},
       RowBox[{"-", "13.3`"}]],
      Annotation[#, -13.3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVkE8ow3EYxh8KYWo2M2z+bMxRuZE/tbAoFlZK2mHCUsua4qBoC5NwcVM7
kDisHHARh9VEObrIxWk50BTloOTPZ4enz+/3vO/7fN/v1zEZHp3Lk7SLupuk
YLPUD0tgwib5XZIPxYzSC0zhfZdLx/ATflVIH+jBKiWZm6+ULmEL9TPqHdVS
L3I7JQ8soreHb0OtFHJIYyZpAH8c9jFb1EA/XCWjnYwU/RfkTFkkL31xvBEY
g1FkY68ZatYqaRbaYQ0yM3NYI2XIO4JddVKa8zrhBPN+dM85p3jFZqmV+5bC
OTIyzIfgDbVBPDczXuiBZXCnnjp7PdPXRn47CtOf4A0icJieTO7N8NfQI+dk
ua8RP8ku73y/IQs77jNzgBaZC7LTAnRypw3utomm8bZhAK5Qu2LmmrMN7Bbn
jYbILufbC9PUQrk+OzvgRaGLd13C8/G/CHvIMvNtQoXc+RXvnB2XmT8h75Zd
fsjP56xf8p7oLyDjD2a50xa7BWEE3eFVkBFolPbgOoqgf73rVFY=
         "]], LineBox[CompressedData["
1:eJwVkL0rBGAcxz8GyZWX4xzOyzkvJyIGbrmSvAxeBwOLgYuYMJnsSpFRifKW
K4NTdIMBxSCjAZlM/oBbLMrH8On7PN/fy/N7frHU6tRKHrAmj83wLtONMCeJ
OHSEINQCAfkuhR/1qxaGy2BH7VOTFdArGzWQtX42Av3mjehde360bqIKnu35
JD16A8Za6yEumTq4krRk5VwS1u8F4cjzqdSFrbVHtZqOwa6xSCVsq2G97gb4
KIEiZ5jxHFTLq6FQLZA3Y536xeZuWRO0dlM9s1dA78Hev840rj8mKe+LsiT5
xnNRyFOXvR+6k33/cSAZuZRBayabYN43FqRN7s09MffFOY7VT3sM6d2an/3f
hX6Lbyb9a9SdXLu7dWdt1+uSKnc76o6jakrNmZd2l3fqs/Tr3agX8ip/y9dA
ZQ==
         "]]},
       RowBox[{"-", "15.200000000000001`"}]],
      Annotation[#, -15.200000000000001`, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVkE8oA3Acxd80DJf5M8sQY+Yk3ESLtiSxpuVA7bAkifLnQBG2NitNuYly
5bBy8CeJw+Swohxc5OKgnbBCOSgxPg6v93u/3/u97/v97CPT/imDpA3gckhj
TqkHLoB3KqVAg+QHYbP0BCfZ+yqW9uAP+LNMegd3VinBvdly6Qxu4vyQ8/YK
yQO66qRuOA+vm7UJ/oWn7NJQidTIPGMt58BDRoSMNjJOyOhl7ikcRcfAADkZ
dIS1jV6D6HELncnKB334s6AMT5q8XZs0jCcAavDfkn+Az1QqtTC3ED5GbzLz
GvaiH7m/zN0QmOdtK3SdoHMn/kk4jN7Cf4Pfhz/9/0d4o+Ce/JdqOoIEs99g
K12a8bSCDnq7wCKdg3Sy02kN/YpnFL3OOg6SaC/+c7iIOTHm9ZNtZn3BXg5d
LmEf2skfhqokB7xAhp+9OdhNTgqPBZ2L/5m9IzoukbNPXoq3ffMeA11+8D3g
N5KRhTPMjtNtDJ4BV+yVkhGsl7bhVTAD/gABR1Sv
         "]], LineBox[CompressedData["
1:eJwNkD0oBGAYx3/Koqhzvr+O053vWNxypUt0iAFlkrgTk5hMdqV8jAZuwOVK
YTjdYLCc4WaLUnJRdhar3/Dr/7zP8/yf93nfcHpncbsC2JJiBF5lqRtWJdYD
g/VQF4Uq+Q7An1puh8kgHKljarwBRmWvDQr6l1shYd+0ubxxUd9cM5ScuaAm
zY9LNAT3HXCsZ9G7bo1j+k5r4co4afzp/CFrX2ouDCfWWprgUG1ohJEuCHhv
xhnBFjhTqz0Pma+xfmBfwP59Nau/7JwB532ol+6TlXnr6+6Vkk25882Ven87
4UcuPM/qyajn9q84Oy1rsiHr0ie98u7O1/ZNOedN74T6qKcgz+4X8d1xe0L+
S95dd92139ywNLnTjH8aUlPqr305/+5JLUnC3IN6Iy/yD4fDPwg=
         "]]},
       RowBox[{"-", "17.1`"}]],
      Annotation[#, -17.1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVkM8rw3EYx19yUdRsMfNjGCMsLnZZaSktEvmRk4Sk3Lg4uSu1cXSQA1tW
Kz9q2lGYg7OLk8jBH6Dk7OXw6v18n+f9PN/n88Q2dha3a4AteemDktxKugOe
1TspNsK3um4uGoIpNawON8OA7LZDOW6tDVL6es09tUKlR28E7q3N9sNFE7xZ
H+qGrLmcrBmvyKrM6JmWM30/XXCj1obhSt10zqP+uRYoOPdc3t1hUH8hBnnZ
D0LA+oHaYF/CmfXudmJf0H1O1YDfI+abrGf1RfQfqUX7S5Jw3qdzM+6Zj8Kx
taTxpfGCtUNnXBvHO2Hcd2bkwdy8+1W9U9kbTJpL27NsXLG25z9HzaVkzNk5
7zehfqi/+r7sq1ND/7fxrUn/s+r7luTV/qr8ASaQO8M=
         "]], LineBox[CompressedData["
1:eJwVkU0ow3EYx79raClvawjR5mU5CCeiRXaQEMZElBUtp5kDB3lZYxdKOYhy
VlbKW5LLykFNHFzk4iClsGgllBg+Dp++v//zfJ/v7/lttmF/95hB0hL47dIC
rIOnRDKj0QLqZZIXFjOlGJqgZjRLN+h3FoPZ0pdFOs2Vtkul6Rxp3yo95klJ
ZFhs9PA14Z+g5uLbDe9kuekboYPvEzwGzhmc06GNnBB5qZzToB1/BM8yOXF0
hKwX1IMOwRR7OOjVQzXeSgjnS1vwVChdk2flDfPsdkfvgsxzWOOOQLEUhAbu
n0VnYJL3rNCbw3+L/wxvFFapHaCHUIV/F92BS/KLyO9nlwH4Zeae2QTaCil4
TDDKnj30eyHG/p3oMxpi7yO0BW8t5xoIcpeTXB+aTFY599mhj9/fR9YPeyag
i9obc43/bwAnmXWwR14FOcfMj5MTRq94V5z/6wNe6W/S/0Qj6AMZAd7gQgdh
g5qJ7GbmvKgD/QMxbVco
         "]]},
       RowBox[{"-", "19.`"}]],
      Annotation[#, -19., "Tooltip"]& ], {}, {}}}],
  AspectRatio->1,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{
     FormBox["\"\[Xi]\"", TraditionalForm], None}, {
     FormBox["\"\[Theta]\"", TraditionalForm], 
     FormBox["\"effect of wall on ydot\"", TraditionalForm]}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic, "GridLinesInFront" -> True},
  PlotRange->NCache[{{0, 2 Pi}, {
      Rational[-1, 2], 
      Rational[1, 2]}}, {{0, 6.283185307179586}, {-0.5, 0.5}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.824715062422659*^9, 3.8247151416122713`*^9}, {
   3.824715215539781*^9, 3.8247152231637497`*^9}, {3.8247152756684575`*^9, 
   3.824715354320746*^9}, 3.824715402894766*^9, {3.8247154515694027`*^9, 
   3.8247154918035793`*^9}, {3.8247155808555636`*^9, 3.8247155942693152`*^9}, 
   3.8247158032205715`*^9, 3.825431379140621*^9, 3.825431650898919*^9, 
   3.825596893471863*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>", "ImageResolution" -> \
120.],ExpressionUUID->"32a395fe-965b-4bda-b77b-95559e8b9f11"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cot", "[", 
    RowBox[{"\[Pi]", " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], "+", "\[Xi]"}], ")"}]}], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Csc", "[", 
     RowBox[{"\[Pi]", " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "2"], "+", "\[Xi]"}], ")"}]}], "]"}], "2"]}], "/.", 
  RowBox[{"\[Xi]", "\[Rule]", 
   RowBox[{"1", "/", "4"}]}]}]], "Input",
 CellChangeTimes->{{3.824716193394388*^9, 
  3.824716203864878*^9}},ExpressionUUID->"e46d72d2-08bd-4339-b832-\
08dc209f3974"],

Cell[BoxData[
 RowBox[{"-", "2"}]], "Output",
 CellChangeTimes->{{3.824716200248605*^9, 3.824716204466573*^9}, 
   3.8254313793198404`*^9, 3.825431651153496*^9, 
   3.8255968936185303`*^9},ExpressionUUID->"68ea436f-ef7d-4711-85cc-\
e1ade6633fc3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "4"]}], " ", 
     SuperscriptBox["\[Pi]", "3"], "  ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"Cot", "[", 
      RowBox[{"\[Pi]", " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], "+", "\[Xi]"}], ")"}]}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"\[Pi]", " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], "+", "\[Xi]"}], ")"}]}], "]"}], "2"]}], 
    ")"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Xi]", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}]}], "}"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Theta]\>\"", ",", "\"\<\[Xi]\>\"", ",", 
      "\"\<effect of wall on \[Theta]dot\>\""}], "}"}]}], ",", 
   RowBox[{"Contours", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "Hue"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8247150249663005`*^9, 3.8247151409935646`*^9}, {
  3.824715192671945*^9, 3.824715221617838*^9}, {3.824715272567954*^9, 
  3.824715352855175*^9}, {3.8247153896386304`*^9, 3.8247154011886415`*^9}, {
  3.824715446035857*^9, 3.82471549049403*^9}, {3.8247155733458633`*^9, 
  3.8247155927370443`*^9}, {3.8247156324987507`*^9, 3.8247156645139666`*^9}, {
  3.824715736960385*^9, 
  3.824715788314334*^9}},ExpressionUUID->"da3bd7b8-9988-4117-82a2-\
425ffcbdbc24"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    GraphicsComplexBox[CompressedData["
1:eJy0vWd0V8X3xpvQm5JCEkAQQaogINJF5yAoXUCBHyJFFAGVLogISFFQQJoF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     "], {{{
        EdgeForm[], 
        Hue[0.], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJwtlVtsVVUQhof2ILDXPvuc0u5zSMuL8RIT8EkwGCNaHzQkJCTQEj31Egua
GEMFJICJ0pioxGCMxAtW0kbFuwSUgtGAbamUUw0vbYGQoFzKrYIJDxpBouI3
+ffDyj971sysmX9mrX1j+7OLO2rMrJtVy9odmW1F0QsmBbNNKGcVzb7iuxX9
fjCXmF3Kmb3TYHYRuWWy2bw6syt5+X6KfBHfhchfovsXn0+w/w+M2OtF3of+
odhsC7596KrYz55EXHR3cN4KbIbQb8/Ld2m9WT4QFzkGP8P+OPk+lpIHcTvQ
/wV2srdwitkG8CQ2n2OzH5sZyO9Ryyi4JZZ+M/raVPZPoevPq8ZGzk+CaiyA
M6mznjxryKeLPF69gVig8T0dfZ7988SpmWp2FhwnzhvEuZU4FlTvdXIb5vsY
chW8s6icB+u0XJ6HLo51Vgm/14M4eQnfD5A3k+eH4KmieGjm3B5kTGyCutqJ
8wi+y8AycQJ+JXBRophex65IffkYnJvxPAhuqpeN267l+0m4+hV5QaIaO9lv
yThxbrqmmx3C5jgxeznjCDn8Qu0biDtK/H5wbTY/PkdNQXMyExyNlOdNyAPI
M5Abkf+IxNsOcFmkfqWxfNz3dvB6XrXfR42XyG0FNrvIoaGo3nkPR8ri7Xfv
c1k8lMnh3aJyq+BXoZ6V9LENXF3Qud435915KION2cy8wFkNQTw0xZo/zyFB
HiH2NeI8h+5t5B54qIBpZu9+73PuHuy3grV8H0XOBfHu/Pu831aU7xC4F24n
EfPmvO6Ycz5e1Bx4XWNBvfccnI9Kdu5OcHuD8tkBVrO58lm7HOmst8DD+C9h
Vv8J6p/3cX5B99bv7zA4jb0T2E8N4td53k1enfhjau3gkUj9nRK05zarsC0X
ZdMMP0uDamkF10Sa1SWR3gWfw8sYrmcvZbafB+8tKJ+nifFF0BwOY7+PdRqb
PnQ/MWcXkJfTx8Ox3gF/D3z+fA6/icWjc7Ia+eFEfff+D+A/ju+fPm9B78Az
xD7PaoaTEXRDxDmHzTB4JSjmRrCNOGfRH0B/NdP7/ouRchhEvsZ6fBo68GDQ
m1AF17FuQT8R9Ab5XDU55wXl5jneVRAPh+CwNVXtfherWZy/fWZS5T+Qqk7P
4RxyF2sv+q/htT+r0Wudy+phDuc4b6zJxPkZrJQ0A2Pcj23eP+w/CnoTnRN/
O78NirkHfDOVTQfxX0sU5zd03UG1Owd9qXrUD25jhjZy7mxyfJCz7sf+gZLe
Sr8X/q443673ufG76rPt/4Ef8D9FnHuck7zevSfQ5WLx5m/D/JL4cZ58Vnxm
/E36Psj3O/DROt0d/1+dSGTvfn6fPY7/E15BnyOHiVT3wTk5Sfw27FqQ7/Z5
jJTjGHgm0llHg+bGuXo56M743enG/mAqTnw2DwTN0o/g/08SDSA=
           "]], 
          PolygonBox[CompressedData["
1:eJwtln1M1WUUxx9ertLvx/Xe2+UCl5ULM4LFtLksW+WSZm7FKu1lAW2UQUVb
vJYzpLaaiEQ651tNEltIwzRsWTOdlZAwttSlhrrasESCmb2YuNJe7PPduX+c
/c7znPM7zznn+Z5zntzFNYuqk51zXVAq9F7cuQ9957ZDb8P3e849CKWmOTfI
3nfsfc73Pmjq1c6FcpzLS3duGvQ3suJs5/agfzfyKxHnlrL+nfV56GX4rXyL
OTCJs16E/4R/PkK3Fb4IeQ/rnazXQPNizu1ivx39Lpz7F3428ueQ3QMFOL+A
9TPwldD18EnQE/Al0HVR5zLxy0/EoFh62T8z2bnT0JfwX0Gj8GNQP/xOdDrw
rS3FuSH4Hmh1su2thx/O5Fxs5kNxYn8Nny+x/yz/zuTsAHvTkRVAU+GT2P8U
37MDzu1HbxD9BezNh0L438f3e2c+HIC/I+TcI+T6YaiUs67FZgX7T0EziGcx
NlBxj+LTdvhTnunqnyHfztTZTezP4ayKKRab7PeTz+nY/Bq9duRtQXQw9iP8
EvZqOOtW5AfhP4A2sh7ne8NV7JGPEfQOY7uB72WoBft16DShsxvahP117L9A
vMehlMQd6i6FKWHrLBTBRg50Dr4BWqn7h65BdxI+LcdGGet/sJ/BuoX1Qta/
sv4CTL0VsPtZgu934e8hZO+gsxbdN7H3vm93pLuaE3auGl+GofGgYVbYbYOW
olsLLfMtBsUyig9D5DeZfP4E38reVsWG/Vb+H8BmOfmo5PxhcluCT2O6f2g5
Z/7nGVZXTKJOEnegu8hFdhFbMXw+zjqb9bYs7hTbLQGriY/ZH0XHR9bF/hvw
ab75rhg2ID/GujDJ7vxb+Fn4tIb9KP+UZ1kOlItuZBv4v9czrAiDwqJqWLWs
+Abg7yWeIvh50PxMw7SwrZpWbQ96FqtivqwcZXC/KfbPgkw7U2frTnW3jxPv
KP8UorsNvpQcHeX8XZzvRawmVZu6I93VFc9k0nlVucP/Tr77kA8hX8d6s2eY
FDaFWWFXd6K7Uc6V+zrWZXHDrLAbZH8MvgZ/a33zSb614kMB63zlHf4oe/f7
hjlh7wD/1XlWo6rVAN+TqdYDLrBfhc2X1FugzciP+JY75eQg8pvChk31i3z4
h8DQenTWQq/HrWepdz2v/1RfMbsP9aebsXeOGNPSreZV+9KRbpV6g7ARsV6i
+9yE/d9Chh1hqBPZBDYWoXsndD5iMSrWb4QDZO1h+1eYyIBvRn6jbxgWlldx
dpVnMSrWvaxrPOtx6nWNrCvhb1ePyDaf5Nu77G0MGmaFXfUY9ZrCdPOtA3pa
GCXeLcg6oJXo1kPN8CugKLJjWYZtYfwI/CXfsKqa/CvRA9UL1fPV++vTLde6
n/qQ9WD1Ys0IzYrBmPU+9dgB+NPsnfGtBlWLE77Ngm7kFzTzola7quEdxDOL
f1azvwp6JW49Sb1JM0azRjNLs0t3rLsWJoSNXKgT/jD4a/Stx6rXKmfK3W3Q
CLlvYn0R2QS0DL43Zr7Ip76Y9Vj1WmFS2FzI+hB8njAbsZwr9z2suxVbzPIl
TDVPMcwJe52J2tKM1KxUT1VvPYG9Yt9qQLWgmaTZtBf5A9k2wzXLi6A+1ju4
kzh+pEAj2HosarnSjP4zaDEpNtmUbfVM9c4TujPwsC9o9V5LjkujZkO2TiI/
Bf9D0GaHZsjssMWk2PQm0NtAPUG9QW8QvUVU86p9YVLYlI/yVZgVdj9jPdc3
TAvbyplyJ8wL++rJ6s2qOdWeZoJmQ0Ni1skn+aYeq1472bf61gyaCf8kOmXq
HapxzrrFN6wL8zMSGBAW1HPUezTDNMtUo6rV3Z7lQjlx7OWErTY147PChglh
Q2forPGQvZ1U82fh88KGffWowbDVvGpfMSv2cv4p8ewNpreYZoJmg3qqeuv+
mGFNb6Iy8FKNzi+evcn0NlNPUm/SG6qbu29k/YdnNmV7bsjeBnoj7Mm0N6Pe
jj8jr0D3f87lcOQ=
           "]], 
          PolygonBox[CompressedData["
1:eJwllFtI02EYxl91Wu7bXHMundZFpzsjCooGRXURHZCgmhXYASd55zYKKi3z
pkyxk11kFtqJIkMiyLJlKoEHDIs0rCAKE8vcgiioC+mi38d78cCe5/+8x+/7
tiAc3RFJFZE1IB08dIt0zRJ5YkSOg1hApDFP5J9TZBF8L6awV2QxvpQMkV1G
v1nPPL9IPfwMGCPXI5fIfrSP/G5Buw4OwLfgvUPMY6O1mtFGyLkKfhIUoaWh
lRHfSr2VaNP4w8S1eESu0XAHvAFsQrsEMvAsA0349xBX7tI8NWgJfGV4rpKz
E15t+8gUGZgrsht9nO9jaKHZIiVoqfTiI4+LHAZ8ZQfl6O/xvAPDaSLr6KMA
XOG3A08AtOeKlFKjkbo38F0g72by+9Bq4afAPXbR5NJ+bF/5aHnUMtS87BOJ
wrvRa9ltMzyXGgaeS8wk3yboZZp86fQ6BF8BBoj9lCVykF7a4K/AWvqN4j3C
70rgp6cguYZz9Pcxo3Pb+avxnYO/NJq3nlw/0PKpWQCy7cWgRh1aK56bRmcM
cgcqif9FHofdjYOcaFP43MRlgYTV5og8oO4MM43gXYi3lHyrQYjcBfD76FvJ
lSSmMEXkLNp5Ox+zrvdqHredDd92fEG0+fC38ArmTtJzP1oFvp9oy/nWBx+k
9ge0dPhv9Cpi+8g5Sf8vjN5Dex+/0/dnfJlof9BOoG0Dz+zujd6HBs6jxqf7
8KPF+VaEpw0UwpcanSdBLzNoO+GHjc7dnqPnZM/rL3ERag3Ce+nlC708d+rZ
2zvQxj3KYw9+l96vfI/uy+6t2Oi768rmjKkzTmwcrc7WCujMdvanRr91+/UO
2rvYC0Z5O3fJN8FekvQQMtqn7bfMq+971Km7tTveyD3awJ34hhZDizJHMd43
cI/RHPvwxfEt4U0dRasCr3P0bdo3egveQS8X6aWE+WL03+nU927fvT13e/79
8Cl8Q/gibo25jXYaHAro+7f/Az1Gd9aD7z+mZals
           "]]}]}, {
        EdgeForm[], 
        Hue[0.14715889775128943`], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJwtlVtsVVUQhhd4oeLeZ5/bPqXeogLqQ7W0auiFQhMvqImaoEJtldKW8CJw
eiERqoTEUGnVh7ZUUYRgYkCbgIpEvLVYCC00NRjCg4mxRbkcQeKDPmiiMfH7
nfWwsubMmfln5l8zs29ryS9bP9M5d5hzFWdxwrlJFNMxvznvX+Pc6ZRzhwLn
1sxy7iZ050qc24FxceTcBGcGcg9+4znnhrHZic3SOc7Nv9q53fxfhf8z4LRy
57POXbjWuYewPYWcw/5L5AXYHwbnEr6PIn+A73HkJfg/X0RsbG5ADmY7N1Ts
3CrOxeucGyFuZ4nlXIvchvwE8iehc+/EhiO8EeR3yeE4OcSR5f9/HdTVRA4Z
/u/gdwLf9fg2Eq8L+xX4tnKAdmuwncDuIJiPodtPDiH53AheX2z1qu4TxNiF
73jKuBOHjRnn3uJ0U/s32PYSo4xYvcSsQD43w7mzyCuI+zm53YvNQuRqav+e
4AW9B/JF7iYwG8H8Ks3Nf2fAGUW/IGWYr4FXi+8i7Kf4/1fOWjCHyK07YQ99
QTkk7O02E/cYv8/Dw9HYOBJXY9zbOJ3IvSmrWbVXIu+j5lLkR9A1+3w+4j27
+L2bECeSzr2M3E8+l/QWvnZxcCVh/aC+GPdcXY6Na3H+LTgtyOrLVjj/Om34
itOP/hBczQPzSGw2sl0ZWM5t4G/G/gvq6uJe5Pv5CJityD8g34H+Oc/bXciz
wM3hW8T9qudnQ9r6Uv25mFqbiNWHvJK7gtOJfIWYdUXWz+J3V2Q9UE3tVeT3
C3n2wO125DpivYnck7SerMrYDMj3Ye6FkfX/Vu4n05an8h2KDKc6tF7R+74e
Wm2qsZr/O6itAM6n6JbmTG5H15a1vC6Ds6zIalFviQtxolmvikyXB/vvhPG8
L2u4wn8RzFf8vPTDT7ufL83Zj9jdAuYObO6L7e0GxSGnA3kuft1e3poyf+Hk
0C/3NarWj0PDrMmYv3C2oJ8b2lvXoFvLeQObKXQj/DeTGoe574ysP3v8jpFe
PoNJ69V6bFpSplPvlAfWM7/jV5GydxmMLLZyOAh+A/LTyMPI9djvwX4A39GU
9fMm7OsC2wkZ4qzyNi9hM4HNHvJYHdi8if/6OdbHiluqfRPYjGhWjmas/5vR
TSdsf2qPaq40X83wepo9cyt75gz3SGi5pYi7M2k5XE/M0aRhtmtevE2Arj5n
b/8sdz60/bY9tn5SXz1FLWdj2+03c/8WWZ7iaV3WOBSXd6etb9W/g76fxd8D
OZuBB7mnQ3sjvZX6SX1VqW9E1npbPf4eOLXYL8H+u5TVuBf9fnwfx/ftjM2k
ZrOUu9zvxvnYRr5ecT/P16u61/m6Amw2+v0jjv9C/wL9sBzMMf+d2pYwXsSP
uPwjsrgHQut79b/261hs/bk6YRyJq1Pof44sN+0P7Wvldr7E9oX2xkkwNoL1
GXwOgJGPjBNxo/kXbwPIx/C/Bx5uh4efPG+byL0sab00yT2OfwGck9yDsX2n
stz3J81efn/6/PeqdjD/wWYKmy2R5aN9pn5V3xZC40hcqRcOeM6FoR4St/rW
aV/LvpI4fZHtHH1bJn1uGwL73otP8dqQs11Ro97h/KsZhIcPi+3d9W2fjX8x
3DYkbJaEo7kp+FjlSXtj8VmG7j/eaSRI
           "]], 
          PolygonBox[CompressedData["
1:eJwtlmlslUUUhoeWttDc/fbe3otQQSqKIpXFQqEQWoxGI2tkrYgiYlDZEyhb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           "]], 
          PolygonBox[CompressedData["
1:eJwt0stLlGEYxuGHotJQy3MWRJHQJoSoLMLyb0jQ0sgOmyghMaM2tetci2yh
pIYLJaMTZLnsNEPNuMyKFjUUhAaZ60AJuj6+Fj/ud97ndD/vfBuPdbecWhIR
9ViGG3UR11FfE9FQFJEpi9i0KuK04KXyiPY1ER0YWB3Rjw7xWrFiscmKiOfo
qYqYXa6GNuuzR5+9tLU6og1HSyKG1eTUNOqxE+PO95DHiNgUzSKDXeJ9TL52
vs/LODr1ubUi4gjN+53DnL697ra6K5Jbo097Weoz8TvI2x184Wu9vK90f2VE
F69/StP5iY+C803zdqjJIIsHtRElKyPWmnNezgUct9MhuzW7OyHnJM7wMOId
D9CXcl7hKnp5uUJbvV0bWrAPF8vTt71MP+gzjXUoNeuhmdv13Ia34kPyOvUd
cx7FFufkv5uXX7DzYrITfep+ApXqrB+DdAjDuC0+Ka+PflP3HVPu88jhbvIt
0DHeRnHtv/fN8s65P4uCpk32brL/NI8beH1Pf5s5jxfiM8URh9398i3NIWfe
rLnv6Ec5n/DM+//19hNV6XeTfD+f1e7Wu1HvfnUDdekuyU4zapeK/axOfSf+
3zj/0DdLH+vzCE9wkOcFvf4BjZBv3g==
           "]]}]}, {
        EdgeForm[], 
        Hue[0.22556803158433625`], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJwtlntM1WUYx1+V1Na5/c7vcICZf5CVq5nBoFUIs4tuLiXDLdQ2TMvSQSCk
DGZTUiuYtdrSSSDLpjJL1xxYuWlKRltimWRabWXhWKLz0gXLLlp9vnveP357
nvO8z/16cp9YNqdmpHPuM75RfL0J505kOHcq6tx3EeeOXufczZnOvRN37g7o
C8Gf5G0J+C3wLoeeCb4c3iHexoF3g7cknZsBfoL3M3wPgw8Bs5FZCD4OODNq
+Jo0uuHfh61JwEL0rBjjXAEwl690tHNFoXOfI/MWPtaj/y7Pcwm8AJlsgsgH
LoHnNXR2gD+HzFpk1wAbo8aTQq41hxgI9puYcxuht8NfjA/Pppz7Fx/eR/Zj
3krheRneWug/oWcaPPkBccHzHu9pbD2O7EPoeAn6XOhzsp27Aj0Cvgg9HZ4n
BLbxVYDPgH8jfnyA/xuAdRmGy79y5B9DtiUwXdJ5P/hkn5+vibc8aXWZBxwg
pzORfx09F8EfAd8Ofwk2ysCbsVkcNfol3nt4S4OviFhdpWcuemp4S0GvBv4W
N9lW8jaPmIfhOUoO6nyta4EfoacNeq/ihqdsrHPz05ZH5bNBdUbvMDFVAOvj
3i5wmbdVhw9xn5PjgeVFeALaeXhmg58D3sbvpeCTgAfxaSu16AEWI1OOD7vw
7Rj4VvAvgBfROwB+PMv8lv+t+NCbtB6eiJ0j0ENynkcOnoqa/tvRvwP5FuUE
/UUp65NvqfUVvpXgndA64jYri5XDhM1CHzA/aj2/C7tfxg3XHJyEby86P8VW
Od967E4lT/UJy9U2eA4kLZYp2D+TY703Cnx+YP3wKPBv78O7KZsxzdop9DWR
j+no7MCnMfDhhuvEfgsxrOPtReACr0f9pbqqvr/Cc9r3Ty96GmNWr/HgP/Jd
RecPwJuQzUN2QmC5lp8X4O1ATwv6K2LWN6rpJ8Q0Enw1fhbBP+x7Sf142eet
AN93hObn1IjlS7n6ivdopsVyDTud8LyK/u3AGn5fw243eTpPfmah6AB2R3hb
e6G3YrsbPWPVA55HvNcHRtd7cczyVRtaHpXPf7JtXhWv4r/ge29K1HaTdlQO
srUZFq9i6PP9czhlPST8LLH08zsL/BjwkN+lVdi/MbDdpR1WkrCZLwb2YWs6
eD46GvyMaEZLs213PR/azlXfvs37IX5vg94cs/q3jTafm+L2WztYfa/+byAn
/diogr5UOzttu3E9+P6o5US50a4U/WnlLzSdXcBXfP/MzrYcKVeD8Oz0t0Dz
pDqpXleBa6GPh/4CsJrfg8iew89nPF4F7PF7dQM8+2NWo9+xMxQx2XXQ//J9
Pi1leVF+Dit2L5uAfk9od0H3YXfU8HtD0yWdB+H90+9h7eNq4lwMHqJngLcy
8ILAaqBaFCZtDjWPjQmzLR809+p19XxXymZYs3yrdmZgM1eL7z/zDUJfrbsD
vRp8JfCsvzW6OZn+FugmTFDz4/M++BdETE9hwmYxb7TdgkqvX3a24MN9shtY
LVXTvITNrWR0B/r8LpqYsNnTXHyI/q6kzc4e4INpwzVPR3zvTUZfXsTmUXNZ
6W+o+mVEYPnUPJ1OWCyKqcTfuwcCm2fNRGVotVGNVOd2fjcTy+bQ9rt2e6Ab
jh9/ILsZ3+/0/ZkP7I+bLfXFKp/DnVl2z3S/fuF9t7/RuTi7KWm7/Y2k6ZLO
Lujfw3MZvB16ddTmtihht1y+ab9qXyg/Lm73Xjr3IOdCy/9/SdtNyskNmlN/
F3QfeuM2y5pp3QnROwPzVT6neT8Zs1zphtzt/7csQt+qpPVJE3CLz8ObwE1x
45fc/+g5TVo=
           "]], 
          PolygonBox[CompressedData["
1:eJwtl3uQj2UUxx+r32/N9Hv3fX+X/dll3EnpYkW2XMpYZgyTrGZ0c9tcx3WF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           "]], 
          PolygonBox[CompressedData["
1:eJwtkktIlFEUx8/4ajNPZxzdJGiWBjWNJfgAwaZNVFOOWWb0MG1n02x04Qxa
Gc18QYShow7tlKk2uminoamYiKDMKoOgiIHcFbQodNXvcu/ixznfuef8z/nO
vVW9sY6HBSISgGJoLxW5An1OkZclIlmvSMgj0sVhEnvEJVIDz4g/5fwFtp3c
CNQRrwWLvJvkd2On3SLvi0Q+OETs+A6Y8olMQh4/XiiyT20XPbepuW76qzku
Er8Aj+kxSq8EdpnvS9TY0Hai4YJ+pcV5FDuBZhqW6bcEHvzb9M9gV6nJ0GMF
O8SccRihT57YMDYOCXhNnxR6t9Q/8X0cvuD30fcHOiH6nIN1fB/aMXS+0es7
pNGegEdG97dd5DMs4p8kZlHzHPbI/Qn1+P1o5LDHqGsj7yj2FGdBsNFX4Ky5
g1Z1BxDEt4h/oveGS8+t5m/BLz+EHvM9MXsLV6DBmQ2umbu5gy2mvgQGiQ/A
JjVearew98pFemDJ7DuHbg81d2GRXEF3AVtJ7mEoJB4mb5X8PXIv808tzH8V
vxM+MssMNUmn7jVo9qr2e6JU7yeAfUXuGATRO0+s3qP3pfbWjEYYjSavvmN1
1zfMu/nKjrM+/Z4O6PEG/61P34m6mwfo3Ccvik1RF2G+P/SZ42xevRN03Ort
Veh3bdFj3KX/aQ29aj979+tdq52niM2St+LV/6f+cwftGXrksE3kNsKueTeT
nP9ixgH221Cm34h6K/+I/4UsvkXtO+wZiOCfVm+JszT8B/+TeYk=
           "]]}]}, {
        EdgeForm[], 
        Hue[0.303977165417383], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJwtl3uw1VMUx3/pnnPR+Z3f7/x+55aiSzWFS2SU8X6M8Sj+SF6D4oZ7bxLF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           "]], 
          PolygonBox[CompressedData["
1:eJwtl3mMltUVxu8wq2W+5f2+D5hPURlGUAYxA0pq2VoFlap/yLgQZCkuDAgI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           "]], 
          PolygonBox[CompressedData["
1:eJwt0L8rxHEcx/G365wyOMelGAhlFxPJgAws7k+wMLHyD8h8yikKSZGFYiI/
BmVjQEZGxaI4VwaP63vDs9fr+3q9v5/P+/vtnl0sLKQiIo96pJnJdMRDNuK8
KeIC17jCmqxH125msC2il1+XPemeMd8cMYetlohvh23SHfk2+nLJuffmGzxn
UHLOVyaiSA9R4Y/oh+4TvyhjX/arO8gnebU/4f9kx3TFPe/uW6WP1X0wIn/W
j9E68ykUa/v32+XU8xm69HfmbvhmPocCP4POWtdBd51ddsceXfKNy9io7V8x
O85P4KfVt+NSdqtrlA1jCC9NyU6j/Bv/ioFc8h9L1f+ST97J0indNP4BrqI+
AA==
           "]]}]}, {
        EdgeForm[], 
        Hue[0.38238629925042983`], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJxFWGlwVuUVfgnfIpp7v7t9QWXrgtJSEapkqKWioYJpR0qzlUUJ1SFRtJVW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           "]], 
          PolygonBox[CompressedData["
1:eJwtmHlw1dUVxy/Jy3ssedvv914Iu2xSqSyiTG2BIEgoMFglISDIog6B1rXY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           "]], 
          
          PolygonBox[{{5190, 5189, 3832, 1777, 5263}, {5143, 1735, 5145, 3314,
            3315}, {5138, 5137, 3776, 1735, 5144}, {3355, 3354, 5684, 2105, 
           5683}, {5125, 1732, 3772, 5110, 5111}, {5071, 1708, 5075, 4044, 
           4045}, {3315, 3314, 5103, 1727, 5102}, {4045, 4044, 5124, 1732, 
           5122}, {5204, 1754, 5206, 3354, 3355}, {5685, 2105, 3798, 5179, 
           5180}}]}]}, {
        EdgeForm[], 
        Hue[0.4607954330834766], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJxNnHe4VNXVxs9t3Jnr3Lll7swZioDGAogUFYgNFNHEHhUVNImhqIkoiKgY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           "]], 
          PolygonBox[CompressedData["
1:eJwtmnm81eP2x7/n7HM6+5x2p3POPt/97FNpkNKgokEuUj9DocHlVzS594oy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           "]], 
          
          PolygonBox[{{5078, 1709, 3742, 5068, 5069}, {5240, 1768, 5242, 3606,
            3607}, {6585, 6584, 6214, 1929, 6590}, {5222, 5221, 3822, 1768, 
           5241}, {3642, 3641, 5077, 1709, 5076}, {3607, 3606, 4968, 1658, 
           4967}, {5065, 1706, 5067, 3641, 3642}, {6195, 2475, 6685, 6675, 
           6676}}]}]}, {
        EdgeForm[], 
        Hue[0.5392045669165234], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJxNnHm4VMW1xc8du/va3Klvn9MMDojgPIPiHIMIDuEhRk0AZ4xgAA2iIg6I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           "]], 
          PolygonBox[CompressedData["
1:eJwtmneA1cURx3/w4Brvjrt7Zd/ROwgCQQWlWGLEAki1RbEhBlCKURQriGAX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           "]], 
          
          PolygonBox[{{6692, 6691, 6205, 2476, 6696}, {3813, 1759, 5218, 5202,
            5203}, {5092, 1714, 5091, 3648, 3649}, {3649, 3648, 5080, 1711, 
           5082}, {6206, 1928, 6567, 6557, 6558}, {3600, 3599, 5217, 1759, 
           5219}, {5084, 5083, 5093, 1714, 3746}, {4961, 1653, 4960, 3599, 
           3600}}]}]}, {
        EdgeForm[], 
        Hue[0.6176137007495702], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJwtWGtwldUV/by5uVfK/R73e9wAI23E2opRZ8pYEIISJyhVbCIBBZEU82gl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           "]], 
          PolygonBox[CompressedData["
1:eJwtmHmQVNUVxt8MswDT3dPdr3tgiARMoexWQhAUEUixCww6wyaEfZKwpEyp
EDTKqqUiAglrJIAlFRABQVAxDImApSkgJavsS8IOI0sAWWSpyu/L13981ee+
e+655557z9YPDvtd6XPZQRC0ygqCHH57pIOgO9hWHATbwflkENTOC4In84Pg
ZioI1iaC4JcsOArWQX/JtyhzDRm/Fg2CtyNBMBUMYe1Q0AI6F7n7qwRBn8Ig
yIvzHd4tbLYSejnYBP0YMq4i6zDjs4yvsSgHeUNZE2M8kHE5+52qGQQnwTFw
HPwdXY+zdisyK6APsP4U/JP4do+9W4Toz1xb0BL6TfZ4A9xF9j2wFP5/wN8X
ZEHvQ8b3rN2LzmtY348z9AW1sMOPwATWXsQel8G1WBAMRodBoAl6NgXPgnxk
vQGmRL1Ga3sgowSc0Zi1rdjjesrfNNcFdAU72f8yc6vZvzr6JJARB2fZ4xz4
kG+bkb22WhDcLgqCH4pMf8T51rN2Rdy2LQTD0WUCa8aDzZxlCzjO/suwZQ3k
H4OezLdJ4GN41oJd7DUeWVtZ/x7yxqLTGFAAbwTkYMNm6D8GpDj/Dua+AQtZ
twjks+drVXynZUXWWbpXgu/APu5wKfsXsr49/BeR+Ra6LOfbJehX+PYA+0dY
n8teU/lWyVwM3OFsjfnWCBTrTsCRhNfqjfZl7a2I+Wfo/PAf5ttbyLsINjDe
n9m/JvzPMPebmN9yQ/hjzJ1hPBL9L2s99zMXneeAX7HXr0FRrSBIgyyQXctv
VG91OvxDkb8Hnt0Zm8g2DeFpAM5jiwugFP7iPN/BQfa7Bs9V0Jw9HgVr2L8D
+xfIHpxzPTx/hC7ARk9ytnGMZ6PvVXhegt7M2k3F9ln5rnxWvvsV+Bo8H/PZ
26FfDfjf49tiMIq9RoNZ0H8qtk1l20U8jCrVfYel6HuCNSvZvy4690f3m2AB
8sYirzf87bjvffD+nvEx7PU9Op6F/2XG7bFHJesvJOyz8t1P+LaNuXIwKGod
pev70EtAfWQ+DPL5VhU0g/+38D6FT2RzvpK4bdEGHXpCrwJfMt8fdGb9Xsb3
s22jC4y7sfdToA561gWfM/9NjmWOYv7bpN9iL/BPxjPgeYS1XTjTTOhqccvu
x/zWqGOYYtlEzrg4YR+Tr0kH6XKZb5fAp5z1MzAq4nn5rHz3Mvv9BFkdOM/d
lH1Svikfk68dz8S2CHtFQYS3UwDqgYdq2cfkaxPgnQhS2KpNnmPwz9BlUcK6
tQdLufteyJ6ba3vXYf8H5DucrxWoHdrmsn0pssqkA9/GgHHgpdDfSjMxULGw
HP0P5trGsnUJ422MDzG+HHeMUKyQD8gX/sX+28EOzrQTFPEtXeyYptjWhTvt
DNow1xZc4dt8vVdsXML+RzP+LZsNiNpn5DuKoWWMnwY18uzT8u1RvNnprJ1P
TNwOvQ7ZO7DNQmT2C72H9pIPyBfuoNurzI/HPl0VO9F9Y47f9GboDknnDsWk
9knbXLaXztJ9I3RFxgflix8g44sc58j73EdJofdWDmzKXq2Ttn0t8AT0XNCZ
vd5Eh3bIO4qO9Riv5UwnoB9P+61Lx1bQ95ExOd85TrluTtKxQjFjFvQLSdtO
+fh5xXrWbIV/cFXiGvYoY01b5hegT2ncMUexRzFNsW1X2rnkEmt2Q1eJWjfl
ZOXmrNC+rjf0MnMbQseCe4wn897uot94+Fugfz5zS5HxerZ1+AD6zwnHZvnY
fNEJx06Np0NPwSeusPY6WAi9IeVcMAWd87BlOePR0CeYH5Eyj3iPg4HK6zGP
O3Henpx3UcrxXPOLobsh4zrjBozPMN4D/17oPeDnjCfpDOiym3GzlHOwcvEl
xhMZZ4EA3ONs98HVmOdUE6g22Aj/zhznnFGKFWnXJrOYPwA9tdB3VcH4O9Y3
YE190Ag0BitD381s5lfJtsifDz0PrGb8gvbL9rc1jHuFjlWKyTcUT8EA6GXM
f83cOzHTS8FXoffQXimQTjmm1MvkKOWqFUnnPtlsOfQhdL6d7xiiWJKWD+X5
DeotJjPxp4DxFtWC+EAEJEAS7EefIcwnJZOzvxp1PTaOb+WZGKNYc5e7vwey
M/XFi2AQ9HC9N+iWoBp0J87TMeYYpVh1hjs+XeQcqlzajW9D85yzlLsaJRwL
ZRPZZmTSviGdQ3jngNlgBpgJRsPTMLP+JGtHRv1WlDOUOz7l26ps17CfJJwz
lDtUow7jfB2R0TeT3w8wX8F8GbzP8q1z6ByiXCKeToy3Rz2nHP8Z/HPT1k82
ngddHLOtdP7qigdJxw7ZqEpoG8lWurNz6LeINcOkCzzbor4T3Y1ixA3mf1ro
sc6v3FGNcS7jHLAR3oqUacVc1VY9mG/MuJFiAHMHkV+Z7TdxOO0crVytO9Bd
jCWWjKnpmKjYODLiWrNEe6Sdw5XLZeMbyiXo2Dvfd9YdfW4lbfs+fKsK7zvs
OS1Ts6t2rxnze7jCGSs5Txjz+WUP1abqIdRLKCecVB6K2ZebEw+aoN815h/P
dw12Wm89ZVu14NuVlHOycvNw5P9Y/Unab1cx7AC6to6YVzlduV01vGp52bw2
/H3Yr3fMPi3fVg+hXkIxprnqfdADdAFdwfvw/iJTr5azvg42fyTXOfZUxD2U
eqnZ0HPA20nnB9XD01Q7Rx07JaM+a/vDsyRwThnI3T3KHt/mOaYptmkP7aUa
WbX1/2uMqH1Wvjsk5Vgp/y9LuSdRbzKdO50BBiB/XjX3XBuxzeDQvYDe5B+i
7oHUC5WiSxl4DBktM3eou1QOUi6SDMkqCP22FRO6os91xtdCx1jFWvV86v3U
n7VDfk3GD+W6x+pX6Jim2JaHzGkxxxDFki/QdVNNxyDFItWUqi1vI7Ndvnuc
WynX9Krt1QOpFzqf8ltXjjiX8p7aWzl9Wdw9osaqkRfysDsyfiXHNa9q39Zp
957KsU9AL0CHdzM9hHqJ2fB/nOOa6bB6r5R7ScUIxYo9zP87xz4n3xuZcq5T
zvsL43cTtrX2XJBwzaLaRTlXuVc+I9+ZhwlvJl2DqxZXDbSWucZR9wKyoWyp
O9XdqkZTrfZw1L2QaqC/xl2zqXZLI6so6Rik+5IPyhfl0/Jt1V/tQ9eYqjVl
42eQNzBqX1LNr9pfNb/mlSMrGJ8O/Zb1ppfEXDOrdtZ/CPov4XzcsU0+Ll+v
Grq20HvJC/3G9NZKQE8wKPN+VQOoFvgInrl5zpnKnZ8jc33EPbF645mZ2C+f
le+OSjm2yN5nGR/hfHc4S92sIPgP6y7EPa/zKzdVpv32zmDvoxHrIF2qs7Yg
5p5Xva96AvUGR+LmVY16FPqHuM8vf1Tv2jP0fweqgf8btQzJ6oZe3TPolokh
iiUjIq519R+G/stQj6leUz2dert1cffyivGK9apZVLsohyqXNi1ybNzFeQo5
S26hay290b+lfOe6+9mZXHkxdO2iGmZH6DVaq5gTU2wvdG+qN7wk4f9Y9F9L
J+jOYEXo2kZ38iL7pxK2rXJKGnpH2rWn/gMZwfyHoWsn/SfzXMw9nHo5+ZR8
SzWRaiPd0RjmG6ddiyqGNoFenfRd6s7WJF3jqdZTTNwb838IxZmeRL2JYoZi
h96I3or+E9F/I+ph1cueSvq/A+UQ5ZKToWt1vd9D6HUz7lyrHKtc+3SRa1HV
tN2K3COpV1IN8aDeR9K9tWok1UqyUadMz6reVTFfsV//Mem/pv8B7dqwHg==

           "]], 
          
          PolygonBox[{{3827, 1775, 5252, 5175, 5176}, {5155, 1737, 5154, 4055,
            4056}, {3306, 3305, 5113, 1730, 5115}, {5690, 2107, 5689, 3356, 
           3357}, {5099, 1722, 5098, 3305, 3306}, {4056, 4055, 5087, 1713, 
           5090}, {3767, 1730, 5114, 5106, 5107}, {3357, 3356, 5223, 1761, 
           5225}, {5141, 5140, 5157, 1737, 3779}, {5193, 5192, 5691, 2107, 
           3801}}]}]}, {
        EdgeForm[], 
        Hue[0.6960228345826169], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJwtl3mIV1UUx6/Ob94v6feb937v/WaKNhus1BKjol0y0xb3iAyltBptGUda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           "]], 
          PolygonBox[CompressedData["
1:eJwtl3uQl2UVx5+9/H7I8Lu977v742bB6iCgRFONqJMT2CLbcllMpGACVxbF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           "]], 
          PolygonBox[CompressedData["
1:eJwtkD9LwlEUht/ERDDN8udvFcmhKGjMWgX/FQYNNdXQB6gvUHMlTrUpIlar
0qbNioOfIMVaCgpaBK0lDR+5Dg/vve95ufecEz49PzhzSLJgHraWpIhTKixK
nz7pC944v0J2WfomlEPXyKXIdfAfyDxCFSpwgxeitklmgbsH9vjgxSXto8OA
NIA5zg28Z+p3vNnn7Vv02C+dQAu/TX2dXBBsSNpSzC3togPqQ7jG75O7Qkde
aQzbnKOQm9V+yH3AOxSnPeCV0J7P9JXhnII0dPE6sGObXeSZ54j7IaxapqcN
NDub849ZatTq8B8wM43ROPcE3JP9xStb5v9pH01owIpl9tjlrUtmvoAqOxix
iyd0Ap5dQXc=
           "]]}]}, {
        EdgeForm[], 
        Hue[0.7744319684156638], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJw1lWtsVGUQhkfYFoE9e86e3a4lIUpBE02U/gGRKIWiBYQWucUUKBIbIRi1
xRLRAo2teIlbSmsMJmpCtwUxpVKJBFOoBEXBBIMKRYW2qOBiNCZ4K8YbxWcy
nz9O3vfMmds338ycgsrqRVXDRGQ/z3CeVFJkPuRYTOTHMSIPwc+DE/JE7ssV
KUqI1Hki12NUnxKZFoocyRGZDg7y3jVS5HdwNu9HkZ+NivTyvAu/Edn4PNMv
gp+JGlfZDl9kFPFXIZvlbEvAXvLJHyFyOzqVfNuBztRApA39myMiGfADnmL4
reTVA39VzxEXaSXXNDlvBy8iL0MnCx4OzfYm9L/H5zliVSNrJdYieJazf4J9
Bn4cXBexc+mZq0LTXwtmse2Dr4EvyBd5llgvEWsL73Ox+ZpY9dhXo/M0OAV9
VORv5FvRuYS8BSwOLMYMcDd6LyLvANvVFwYPks8GeAN8HnHexOYvdBZS59LQ
8pqrteU8TdRqGbXayfuf6OwC+3y704/wc2fU6vwI/gZ5r0U+Bz/PwIfw8zx8
km+5dcEbXP5jkQVgz0jTi15nfDS4lxivk38d+UfiFutnemY1fBXyleR1Ep0Y
+fdqbZLWVwPEnOmZ/BTyb7GZhzwLNuGrE9tcfExNWp6a7/vurg/7Vi+tWxm2
+znXWPgo8inFppxc54DjAsthPFhIXR6nPhfR3Qs/Aa+F74Yfh3eAp9E7j/46
bC+7+mj8TqfzGPpvO9susDhldZ4BTnT+bwOXYjPAucqTllcm1+p2iLq3wTfj
uyZi96v30ZMwnYMJq5fmXEAuH2Mf4vMYeMrNwklwmfN/AT9XArub1dShHtm9
I2xOrvBtE/l3IC9N2VleoLbz4SXXUjdwyOksJ+chano/cQV/s8ihHN4C3+bZ
/W6ET/dM56pvs6Qz9Rt+JnvW8wPISuAhefQTd33ccnmSuv3CM07PjE6jb7wJ
PBCzex/k7Bd4L0X+Hdjvm0+dp32e9YP2xVrPalcE73a2ad/6W3tPd9gDfEuj
8zK2heQwW/uZ79fkWX0E7ItZH2o//uHuWuvUHNgZ9ay6d7Tmv5L7RmLkI/+S
7xsCq4n2/vDAajUM3JWwGddZzwnsbnXm3kLvH3LoDK2/NeerfN/j5AeItcn5
1ziT47aLdCd9jo6H02J0zsDj8K/ANDpL0VnCTliRZ/qTdOZC67VK8L3A9uEK
csgGdl7d65mk7ZAb8NkX2n0NgJ+5WJ+CPfh6BZ1D4Gu+2WrNdLeqz278nXD7
SvdWt2f/iGnUoCVh+3Ab+IWbqZ882ym6W5pD+6+oz3583pUwW/3P5MSthq3E
zCBv5KUNbHc7X/f3QXfvujPujlnf16ATcXeh/Tvk5kLnY6LbvXo/l8ZYnxyN
2Rn0LFVR6z/1qT2lfaP9UxHYbOiMVIBNPPvoh2bdsbq/8H8L+S74/y505/AU
wgvAJ3gehid9+6/oHbVT+8D1ofbj4nzbV5vRfdQz/1uRp3negW8Bl2NzjgPM
pH4eed4BjyZs/pTrP0BnW3v4G3Kuc730FOeq8MxPI34afNtHui91L+i5/o1Z
D2n+C+O2y3SnvcH3MrdLNccaN8s600eIvZO4H4JnXU/eQ5xa959aD/6A38XY
Tonb/0BrrrVf6WbzOfTbUtaH+k/7D3HPLGo=
           "]], 
          PolygonBox[CompressedData["
1:eJwtlmdslWUUx59Ay7zvfe9923vbYlGGCioj7BEFQQ1QwSIgS2YNgrKLAaUQ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           "]], 
          PolygonBox[CompressedData["
1:eJwtk0toU1EQhgdbbdXcNPemj2zTlYIm+Eo2VmkwJtpq4gMbpVURFaShVVCh
FReSgG0qJhUUdaMFNyUgYn2gVhdKFaRFpFiqVlz4WOlSN2rqN5y7+JjJnDP/
+e85k+Ch3p09C0QkAgth2hHxLhKJWSKT5FNQIf8HSVskw6ZtxEs+kWF47xGZ
oLaZfXHH5AliK8RgZb3ICnjpFdleJVJNr9C3p1qkSLyH7n3I1ol0wzjrV9B4
QmwLiJzDS5+f8/ldgXXscWpEXqHZjX4W0uQpmOOMw5zx1Wfqut4Ln9DrIYbo
T5CHiefRGYAd5HuppYke+i14i1aAM6aJOfryUGwQGaOWxatN7jSY79PvHMHf
ED4P0ruE+mIYhdfsLxM/ur6uc15/k8gZmMdjG7VHrFXon4dhyKNTInZQz0AJ
X0X4xj2fQC+EXhqdFHyBdu4xiqef8ANm0A1QO8tazn2vdmKQ381wkvwYtVO2
2a99E+7bfGB9FXe+GpLUEnDab96gn3jcvcvvHuNJvWXwE6+lv1FkC2yFHH0j
9IzT8xTNZ7CR3uf0ztI7hMcLcI36VYiis4u1CHEtftbAcvIYtWW2mUGdxVbq
FrpvyD/T34fnX5w1wDsN6ptRb4LL7j2mA+bt9A1fULtFreA1Z6uHjM4MtX31
xrf6TzYa3d/sa2bPEe7yKB6W4tMDYQjBbnduCsQZ9N/BJp0N9GbJ/7LnD1xE
o4zGGGsteEixvt5v/jv6H9K70TsKohNGL6/+uNO7vHWnZWZJZ+oA9QK9N+iN
oB+FUXoG6SkTa9Cq9Zm51Pm8DVNo3NE5ZP0m+yZtMzc6P3P0O+jFLeNdv2E/
c9kFhTozm4858yHrD6Ck98V3VPnM2ephg/umLcT/Lb2RlQ==
           "]]}]}, {
        EdgeForm[], 
        Hue[1.], 
        GraphicsGroupBox[{
          PolygonBox[CompressedData["
1:eJw1lVtsVVUQhhelULr3Od3n7PYcMVGjDUYCARNTRExKA15jYtIitg3SiyRG
YlouhligIYEWjVRqrQm11CA0yINoiYr1UgV80UQaikCklEu8FRMFvFSBB5X6
Df/yYWVmr/2vmVkz/8y6bdnKRStynHNfsiay1qSd28bGhaRzM3KdW5zvXMT3
b6H0X5FXWJXol5GtgXOnOfccsr7AuWGwC2PnxgudS09Cppxr4d8wmO/A/8zq
Rq9ib8ck2RnizB/sL0L+jpzGWs2/25FVGeeeIbDmlOLpZX8HuG/4Xsn3POSn
xLwFTEPk3H7iLuf/P+gHWePorcR1a0p+38He1UBnu5Afga8AM4X/s4qcK8J+
Nfhy9ItgkuirkspBEj+rvf5nljyhL0C/m/1rxNrIXf5F7suVbvc5jI/lxPY6
+1ND2b8l4dyrKeFKydO7xFSb51yckT/zW4HN5hucG8POGfaK8fX+BOdK2A8s
j2BC5GXi2MO91mGzbIpz81lP4y8Vyk6K/ThULQqRncTzI3YuoZeSnwGw7cit
xLMXfFms2lzPFfJCKPu16L3gznN2LrHMwy6u3DD4a0nFs4WcPVEk/z8Q82fY
/Jr9A8R8L3iu4nLYW1IkX+bzHva5uhvCzqEiceF+zs7B1wfYWW72I2EM+xL6
dva7sNkQC2PYt8ldFaAAeY3zDxFcBbk5E6pGbxB/a774uRdbj/BvK/hq8Bsi
cf4S97hSoH37PxroLkPY2FwgLhmnjAfGAeOCcc64l0DOxlYTeX6F/xnkHdzx
GLhGz3/rg/PY2g/+LHpOQjFNQG7ifA77bfhpYQ2wH1D/DwPxvR95vEj1srr9
RXy7uONG5IKsar8QOT2t+pYQ20/4GrRacLYuJb2TnCWwuw/8C1nVzGr3Lf9v
9Pw0nloNrBYh2DlJ2TTbG9D7iG0sKw7Z/lLsD4AfZb8W/CZwPfi6ORJXjDPl
kXrSerOfvc2x7nsM/4Np5Won/yem1I/Wl+cj1cvmSrfnvHE//T+3kaewk5rs
3ElkX6xZYTNjvZ8/D3N2W6jeaSPO2fiaic3nsT8X/En0OjAzwawBPyMUt4xj
N+H/qOUL+0eQQUI2rZ/sbnbHs5H63zi2HX0klP3t+HqN9SZ1r0H2BeqFnFCc
M44tQa7wHDYurw3El4PIxYE4X4ccxe904j8U6T7X5yr3awjE5XOhamJ8sO+d
geIx7h+L1afWr6X+vnbvEwnN7V3YbA01fy4i2/08bwo0E60Wb6XFG+NPR6xa
Wk0Ps78soTn+bKHmu/H8e+SDseabzbn6fM0lm4NH0prhT3Hu8UCx1SMrA82H
J61XAuX/VKDcWQ5bsPlxUjO1rFDL9E/YOx3rrM0Y83PV+/rcz3/r3cqs+m5W
Rv1pfboqVs9b79u7Vxzp3WlF3xgo5yPIc4HOWu/2ZmV/D2e/8vPB5sSIx59G
bgo1i34J9ZZYT3US732+p2zOvRiJJ8ZH63XrR8vdo2nx3GbqJD9HJqfFUavd
NPx2BzprXGvy9bJ3uC0tDt+J7cFAvTAGpiRS/JYDe5utpx5AjqbUR/bW9WWU
57XksMf3i/XNEc//E8hq4zSYjaHeUXsjGsGPh+Kd8THwc3gr8j2fE8vlSd+n
Z5G7I73l81Oa0y/nqV65aeXK3uF+/447MHdNpdbY+KJA2I48xRf7d7Mjo/lr
c7gYfJfNL+weR9ZkhF+KbPd3tLs6P3ttBrdldK/H0Js9D42PNottRtmsOhqK
x38jD1DLHuKsAb/ec9i4vM73rPXuf8kjQsc=
           "]], 
          PolygonBox[CompressedData["
1:eJwtlnmwzmUUxx+vrfv83nvfe1/X6zKUVKMymqY0bYOUtKgsU2nsS4tRljEV
MmZwh5EsqWw34haJMLiUJS0ymcgWdY1QtiRCEs000ec73/vHM7/zPL9zznOW
7znnubbv4M6DUiGEzawarMP1QziQhJBJh3ASunndECqqhzCsZgi3QG/kbCX/
z0TOSuBhdWA/nn2d/BBmsr+a/TWsOdAnciHUQlcP9hHZ/tkQVqPvxmohHOO8
Dzy/ITuANYP9cfZPwHsX63SRl+h7WBUl5hHvUPb90DeH75TaIaxCXxl0OWdL
+U6Apw38z0AX1grhKnx7jbNz6LuXs46sP/jfqjCEm3E8QxCGYP+BrPnz4N8P
/Sg+T4N3KmsMukcj8w96BrHWYcuQrGMjnwZB34+/rbnsBfbdiokTMg3ha8Q6
C/07erpg7yz0n4TeiD27uP91+DdAb4dvKLr/Zb3JXTfVCaErfL1YxchPxZ6e
yC9AfjL0L/A8njhmil0p8s8j+zL7/vB3ZQ2CHsh6qr59lu/KmXLXhW8af1EZ
RiDXA/mymrbps0LbIFtehK99fedAudAduus5VnlNx/CDDPFjleHLUfJxB/Gc
VNf+zkT/ROhJ8PdHtiU6PkVX0wbIcnYDq6CBY6xYl8MzD/lmnDVLm0e8irli
3waer5A/nTgeC9F/Cnoe9zfFlrrYVJN4lpCTdpw/zNoN/xLO5qZs83boBdzx
Pvoq+L+Fu5sUOhfKT2PoPVnHR/jZDT0Z/ev5P5v1BnRX+VSFvyboalFkeipn
PfjXIt+x6Mwdt3H/3egcjH1zub8vvvSsRx0AtmbYNCFjG2WrMCAsdK9rXcJ4
N+hN2LgqcQ2qFoexJkIPgf9r+EekHQvFZAX8RwqMxSXc2RU8fgRfp5TxPRJ6
XL7v3gZPL2xriL5+6OvNag72Gmbsq3I6Bt/Wwd8Z/gHsl2Vtk2x7iABd5q4z
yD2ZZzxMQf8R9jvgf5qzi1UYEpZeUg1CP4iOSv4vh78d9DucLeJfbfw4lXOO
levWrMvcvzQ6N8rR3uieot6iGlGtHEpcy7LhLPSdyL8CX2P0XYC3gDvaJo6Z
YneQ7xL0zcf+nyWLf+Oia0q1FYhJx5Tr4zKx+E+1lGd7F8N3HhuX5VnHMf6f
Sxwf8VxO3IPUi9RD1Esi+V7Pv0r412BTMes8+zbIzIPvQHS/LeTsBDKHE/Mu
x76juluYj+5x6nXVkC+tuv8KZ38njrXwdbtinzj/rZDfpZgjvyG6JlQb3aPx
qfw+C12DGrtOtcYqgV6esy2yqQX+fRON/xRrC/R70bYLD9uic6LcqH8sgx6e
dq+aDs8o5PdH9371y0PQp/L9TzXxQ6Fzrtyr5lX7vaJjrxwsgj6Gz3n826/8
QB+Jxq4wPCs6ZrJXZ79Cr4mud2Fe2Nedq6vm2U/Q43OOrXIyFvy+ytl+7vsR
/k3RS7Tq50PoDHf2TIwRYeVzvrtT7jmTRBc7NorR98WOaVlVv6iMzrnyKZ4x
GWNO2BNmhV3NUM3SvsoPd+2LlpU+xX524n7TFpkZ0KXYfCXlnr0R/H+RcXx1
9mXGmJF/qsEjVTqlWzWuWhcmhI3e+L8zMYaFJdXk8Yx7sHrxev7tqu+eoN6g
GlWtymf5fpw734KuzLpXaobug96Rdf7UQ3dCpxJjQ/bemrgmVZt6I+itoBpX
ra9FV/sSzwjNCs1szW7NQM1C5UC5GFlo7AmD0/Ntg2xRDidHz0DNQr1J9DaZ
mjU2hBFhe3Y0dtSDs9jQKede1h+eRfDOzli3anQktTsw7f6jmfYx9Tw65/yp
B4zi/lpFnj3CxGRsa501doShltDnE9urHvEndMs67iXar0U+qedcKWdp6KF1
XMs6e6DAOqVb9VCRbxtl6yX4y7HlvpzzqTdIG+iFWf/Tmf79lTPWZPMF6Ouz
tk3x2oNvj+WMLWHsYoFrXFgVZgdCb47GljC2MrpHqFeox6rXroiuZ9X8zOge
JPtV35c0o6KxpZ4V0n7D6S2nN4HeBqpx+SYfh0fPEM0S1fAn0IuLXMvaa5YL
Q8KSbJJtM6Lvkg2yJVXoWSeZ6tCN8PeRxG8ivY00gzSLdKZ/Hcjp24lnrGat
Zqpmq958evvNzzhWwlg59HfwrE4sI1m9IfSW0Jn+6c2lt5feGHpr7GW/IfEM
0izSDFH+FRPF5pq03wrqydP0Dkxcm8rxVvYTo98Xyo96QZ9o/1Rveuuqp6m3
qV8fhH43saxmtN7K6mHCo2bCt9C9o+tV9am34OjEbzXhewz01iL7qhrfVuQe
oF4gH+TL2MS51nujFPp/Poa8hw==
           "]], 
          PolygonBox[CompressedData["
1:eJwlkMFKAlEYhQ9hoHMHdZwhZsAaFNvkopdop0FpL6APYAiu2roI3LXKRQ8i
tW5b4NICFWaREAW9QH7Dvzjwc+53zv3vbQxve6MDSVV0iM4r0oSh7aQvTxrE
0mtZ6jGnvlRHP4l0g/+Od+aMnwXSmpJdQZrjPaJ7uA1aMdfIZSXpuWx+fr5E
F0WpeyRNyY/paeG90dunfwdXIVdF3/Rm9D+EUgSXwL3AXcXG5hnn7P5Luv5h
AziPbCm/m64O3AIudHZ2R9cH+/yxVwTzib+Fe4JLmU+d7dTkT64D2yFw9u78
/b+wx+ROfNupALMHRkMrzA==
           "]]}]}}, {{}, 
       TagBox[
        TooltipBox[{
          Directive[
           GrayLevel[0], 
           Opacity[0.5], 
           CapForm["Butt"]], 
          
          LineBox[{3155, 5514, 5516, 5386, 5547, 3181, 5548, 4128, 4130, 3852,
            3948, 4539, 4541, 4284, 3165, 5053, 3715, 4030, 3716, 4032, 4031, 
           3300, 4712, 3893, 4716, 4718, 4720, 4496, 5422, 5421, 5718, 3892, 
           5806, 4751, 4753, 4191, 3461, 4398, 3976, 5982, 3770, 6624, 6628, 
           4351, 5119, 3656, 4986, 6219, 4606, 6337, 3257, 6272, 3267, 6519, 
           4622, 6612, 6608, 3487, 6529, 5450, 6209, 6561, 6253}], 
          
          LineBox[{5877, 3193, 5552, 5394, 5519, 5517, 5549, 3192, 3965, 3565,
            4468, 3563, 4309, 4153, 3170, 4978, 3651, 5311, 3652, 5899, 5900, 
           5766, 3714, 5898, 3253, 3969, 3722, 4740, 5329, 5330, 3901, 3981, 
           3979, 4502, 3868, 4481, 3869, 4060, 3381, 4392, 3380, 6194, 3781, 
           6638, 6639, 4356, 5165, 3672, 5009, 6224, 4632, 6353, 3277, 6288, 
           6475, 6480, 4637, 6490, 6485, 3492, 6599, 6604, 5455, 6594, 6589, 
           6263}], 
          LineBox[CompressedData["
1:eJwV0s1LlGEUxuFTWUQ0jjlWo7gpBImQNtFoYKZgi0jQDBQ1tCRwlbaWQHAh
ii2KPhAEFZEoaCWi/guKhQgVKpSihFQQJa1k8JrFj/s85z7nPB/ve+Fh793H
RyLiOfJLIspxGT/PRbwsjqhIRZTSNFKJiL10xG/8ORMxT0dPR3TzXtMH1leS
ESO8e+ImmsiPaCyK2CnQq24LG3L95yPG1F5T88rcfn7L2YgPhRGL1jX2XaDV
9AXvlnw96tClf1fvDv4651N1A3Qf//DEOmFuH72hd1rdI+dbkXuPdzgpP88/
Ro/iOn/d7E18xld8QZX8Kl3DCj7hIyrls+aG3jlzDsSz9Jn1CfOPY0JumS6h
UZzhT9FJrOkvM6fTXTK0GjUY1d/mvbbl22md+9TiJmb4U/QtbaLZXI0368B9
XLXPRXu0iVtxW81/NXfokHf/ZvawmVk1DWqbfaPBXI/zjIvfoEfdoLPNin/x
dul3JPUkeUW45Jucoj9yb04z/LR/Jg+HLhhUdQ==
           "]]}, "64.`"], Annotation[#, 64., "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Directive[
           GrayLevel[0], 
           Opacity[0.5], 
           CapForm["Butt"]], 
          
          LineBox[{3566, 5551, 5550, 5393, 3436, 5518, 3562, 3964, 3963, 4310,
            3564, 4469, 3860, 4308, 4467, 4466, 4470, 3191, 5392, 5377, 5376, 
           4979, 3856, 4350, 4349, 4710, 4709, 4706, 5051, 5050, 3968, 5058, 
           5059, 4739, 5331, 5430, 3313, 5332, 3312, 3980, 3900, 4480, 4479, 
           4482, 4059, 4748, 4062, 3748, 4393, 3379, 6193, 4058, 3780, 5142, 
           3782, 5164, 3671, 5008, 5013, 4631, 6352, 3276, 6287, 6474, 6479, 
           4636, 6489, 6484, 3491, 6598, 6603, 5454, 6593, 6588, 6262}], 
          
          LineBox[{5833, 5515, 3420, 5385, 5545, 5546, 3545, 4129, 3423, 4454,
            3851, 3947, 4540, 3182, 4280, 4374, 4027, 5052, 4029, 4385, 4384, 
           3372, 4033, 4711, 5318, 5319, 4715, 4719, 3302, 4495, 3301, 5423, 
           4714, 4752, 4750, 3328, 4188, 4755, 4190, 3758, 4399, 3975, 5981, 
           3978, 3768, 5108, 3769, 5118, 3655, 4982, 4985, 4605, 6336, 3256, 
           6271, 3266, 6518, 4621, 6611, 6607, 3486, 6528, 5449, 6208, 6560, 
           6252}], 
          LineBox[CompressedData["
1:eJwV0s1L1FEUh/FvVEQwY6Xp9LIwjSIi2qm9kY1kTaIZ0SJ3NZsWQe2FNq0E
oRciiYK0IYTQRUS47R9wEUGgFgQmIWm0qDaV1GcWD88959x7zr3zm7bqzYs3
1iUZw/pdSQmdO5IfO5MvLclmPtCUNHFDnWLySX0JK9uSV3y7kFxTG7N+grYt
Sb9aBWv2j2xPfjUkR/knV/Q9h/MYwFBz0mHvuPqSeo3X+EVj8pcnxK36PBdP
4hiG5C5jdGsyZ367HiflOzHuvk+x17rmLm94n/OL1p8xiFnzDjs3aV8X/5a7
o9cffm3vXetu/ideMeetHmXxLPfwO16Vn+fT4vfcyx/4m/wG58+I7/EMb+Ip
MzfycfOum1vDVe/rlqtymU9hQI9+9KFoTwFH9JjgZyjLn8W8PvftP1F/a/39
XJGfxhT2ODOs/tL6Fi+b0eUOj7xpuJQ85gW5Pvf9yINc4Av2XKr/PupXfM+H
5lR931GeEX9XW+VlNJpRUtuNQ+Y/4K++6UH/o/0o4j+9v1Ra
           "]]}, "48.`"], Annotation[#, 48., "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Directive[
           GrayLevel[0], 
           Opacity[0.5], 
           CapForm["Butt"]], 
          LineBox[CompressedData["
1:eJwVjj1vAVAUhl+mDr7qoyEGaSxNmPovqnTwFYOJGmjSDiJqrLFNWCTM/ASD
SBeJdNFBsDBYtFV+AGLzGJ4895x7znvvdeYl+myQFIe0SdrbpQuXdMCrS+nJ
LO04G+nd2qQCdQ/n8Z9TurdKvziM//EG1hChnjI3gTY5IepXXIYK5GFLxoz7
R/J/eNtHL8g7AcjSe7NIfYdUZC6B97hKf4fj1F3u6+TWoMluC3LkZeFA3hF/
MP8OS2Y6zC/wit059vPPIT0XDsANJM+Z3Dfgir2xW/omq4bvPNIDeOmncAza
/OULjyDCvwf4E0rMnwDxjzY6
           "]], 
          
          LineBox[{4941, 4844, 4845, 4572, 3419, 4846, 5371, 4126, 3421, 4275,
            3422, 4282, 4283, 3946, 3546, 4281, 3696, 4028, 3697, 4375, 3371, 
           4376, 3928, 3929, 3458, 4943, 3568, 4717, 3567, 4942, 3754, 4722, 
           4721, 4713, 4883, 4882, 5313, 4341, 4756, 4754, 4189, 3757, 3977, 
           5099, 3306, 5115, 3767, 5107, 5121, 5117, 3654, 4981, 4984, 4604, 
           6335, 3255, 6270, 3265, 6517, 4620, 6610, 6606, 3485, 6527, 5448, 
           6207, 6559, 6251}], 
          LineBox[CompressedData["
1:eJwV0r9L1VEYx/FHS1H8Uf66mCjokCHiaPlruKAmkmjmrvgD4y66uIguTkG4
WDlUJESiYpFYCbpILdEfkIiBLhIXExxqzKDXHd58zud5nu/nnHPPrRubfjCV
FRHPkV0VkUBzZcTvGxE/ExF59FZZRCktylAUcaJ/il8lEdt0oTBiUm/Z+gVq
r0Xc0+vBpflH5RGLaMGfYj259zGAv/yw+gpe4ZR/TTdKIzaRvq5v/2xcQata
OzqwKLtGrRot/CyfZT1Dj2UknWNf/TO+YFVWvV6xcz20z6D+JP2QuQf+8etm
1pA0N6E2qjaGr/x3GZ30QL3TPlcrIlLu3mV9rHeCQ71u/i6+mc2X1UPf0XE5
m/QtcvHR7CfUOsMb83X0Qr1fzg+5T6133SMn83uq5dI9foTmmJ+Tm8ycCV1Y
4u+o30YvX0DzMY4zWVtq7zFvnbbXSzkpeTW+a/MWR2q9fD/6UMAPON8QmsyO
eNtnzjXqrR/THf5C75ymUSInoVeFRns+oWdyG/ynbqIQ/wF1TVEt
           "]]}, "32.`"], Annotation[#, 32., "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Directive[
           GrayLevel[0], 
           Opacity[0.5], 
           CapForm["Butt"]], 
          LineBox[CompressedData["
1:eJwVzy1Lg2EUh/EjGnXzZRNnU5CBaPEFq2uCswxEmBgcBldmEbNRw1bEDzDB
tyCCcQ4sFg2Cik6GIILNb2Dyt3BxPefc59z3/xkr7RQqXRFRxEdfRH4oYhnf
A3rq38GIdy4nI7ZxkY5oqU/5HGcoD0es90bc+m6igYWEvc4sLt1XUb/5vjY3
l4p4Uc/yK8/zPs/wM0+5bxpJ8wns2Sliw/s3zo9lWtTvlqPdH9HDm3xlp8Q1
2as40M9y3c6W/qG9P27Lk9P74RP+7PwvvtDyxrgcE0hhElmsmqs5P0LaPU8j
EY8yVXkpE7GCUf01LqDu7Xt+QF7WO25g1/w/HnA2Vw==
           "]], 
          LineBox[CompressedData["
1:eJwNkLtOAlEURbclUUFghkhF+AOph9gRa4GEntICEhhChQ3fgBWRWh6SWFBA
QgiNFYgVr4YSiDYWvE1Yxcqau8+5555MMJmOpi4kxWFjSEuPlLiW5m6pzbkD
Dpf0cSN9kVdMaYS35Dt4vJIC1OJ4Sm0GE0g7JZMZBiyozclssnevlMNNnMEN
nMVVXIcaLCHKzBi8UbO4G4YTc8Zk/9ik59Mn+fALtRIU2avPTiH2Ncjv8IZ+
ixm/nJt4iH9gDSvm7PEB/kDcPeEIfTbOw5H9u7dSi94C7mHbL13yn77xAMq8
+4wf2OGenle+n/AZWzg6AA==
           "]], 
          LineBox[CompressedData["
1:eJwV0k1IlFEUgOEzEBmT1Uw65UQRRYRo7aLox1VYVjjWTESbzMxomEXtI0oi
grCFkRtD2wm2q0gXrZXQRT+bCLKNqZhQMdbCctPzLV7ee+4595z7Xb5d3TeL
N1IR8QKpbRE5HGiIqOYj5rZE1PDeuogs1yZsiPgqP4vvWee4tzbimtyA9SB2
boo4LXcCq+of1Ef04RDu4x6GcAldKGF+Y8RVzvAV8xYzEXXWa6zr+TLf0mtQ
z6dJb/lW/DH7OL/MRbzCRXUr6grusF+uWe1BviB+Zj2MEf2aeFLdpPpH4gnu
4yU9ZtR/0XMGWecq3mEaZfsj9lIY2qoXiskbqSnxW/1G5aq+Y3ZzxFnxJ3PO
8Tfxsv05Loo/2y/xvPi3/R3OnRcPmz/FP+39wjEzK3guv2LGX4yr2e2uH/gj
3qEsfs9pdXedq4rv8DL38hs9T/rGaR4zexwt+o7JFZzpQL/cYT2O4J/cKXur
XOPcOqzFbTU9nNc3zQ3Jm6nLcUWvBe7hMq5je9LTnY+iTdyOM0irK7hDEfu8
X6f/5olZXf6jh/xa/ENuiReQ0Scnl0eTuY95Uc9G/+serMd/z7RkHA==
           "]]}, "16.`"], Annotation[#, 16., "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Directive[
           GrayLevel[0], 
           Opacity[0.5], 
           CapForm["Butt"]], 
          LineBox[CompressedData["
1:eJwV0klsTWEYBuCvy9Kig1bLpi2p6mBhZVqYItRYFmhDYkEktIYKdqihRJpG
GqEigi4shIaGJggbCQuRRiQtG8PGsHF7kQ60nrN48t77nu98/zm5t2RnU11j
RkT0sSEronVqxDlOc5YzrNe3yFMc5yQnWKcfK4gYp4WMQkuonhSRmhIxyIrJ
ETXTIubywky1rGKte7ea3UanvkHWMydb5ka8otwZL+Vf+Y9Rxhmj0xkj5kfp
df+wHKLZmbfsfqc7zHPdMyrNb5Kbuayvkxu57/kqknNp01cls8mM+UGZ5qE+
JX9y0P4b9r/VHeKJ7jEV5mvlGi7pV8tVdNtfIku5oJ8py5IZ89/lD3r03+RX
9tt/3f4+3QF6dY8oN79MLqdDv1Qu4a79RbKY8/oZcnoyY/6z/JK8o/6T/Eij
/dfsf6Nrokf3gFnmF8pFXNQvkPO5Y3+OzKVVny/zkhnz7+WH5B31A7KfvfZf
tf+1bh/dunvJO5vP8j2bTCYygS77B/2eaVL85hft5gfynUE/O8xup9b+K/YX
mBnKidiTF7GbQvNHzR1jF0dopos22llJJx1kmt/i/gYqPcNt/8mbNBZ5N/uf
+vzHtWGZpsj/crZrNcxzXqlMeZ4Rudj1smLvw38tKX6V
           "]], 
          LineBox[CompressedData["
1:eJwV0stLVHEYBuBPxyLNdGasdKxFFnQli3ARraKLy4gWLVrVeClvBd2IsEli
sk3lpstC7CoqUhBIRBFlA2UamkRIRLTsbygo6JnFwzvnne/3nQPnNGRPHTpZ
EhGfubciooVWsrTTxt7KiBOyg+N00ck+fWltRIL8yohFsoyuqohkKiLFnuqI
tXUR6yiYaZBr2O/sA7MPGdc/lo8YdTblOk0VSar5aX69e/6qiTiSjuhbFtHt
dw9/3KfWf8NmDiYj/trzj6POZTnGoL3bdNsZcN0otzLh+XrlpeL99Zdljkbz
72SB8/oFRuzP2R+ev4RXuoQsZcp8q9k2BvUtMstz+/PyKsP6a7K/+Bzm38sP
XNB/Y8z+PvuX2FfOa91SWcG0+W6zPQzpu2QnL+y/Lm8woh+QN9lhflrOcFH/
nXH7r9iftC/FG12NTPPJ/Fmz57ivPyNP89L+W/I2Y/q78g5N5mflHL36Hzyx
P29/nX0ZJnWrZD3z5je73sIGNrGRgv0ZWU8dq4tn2Gk+453miv/JyeV6+cw9
Dhffgb6Ej97/DNPscuarXGCWL8wz5x4J5xfz23WlLOeA+ZzrPGW+qSnP+db+
ftmUsY8KfbPczaBv7qmcoNmzjMohOsz/B4KobIE=
           "]], 
          LineBox[CompressedData["
1:eJwV1WtMlmUYB/C7MrAph+RoSw4bIFjL0KK+lG6peOqgK6uNlpGdFr6AmGhm
hIyVlit1LVBHrCJzLl1lljZtDZeUVK6h5DzVzOyDCh9Kio6/+8OP//tez/Vc
9/087/O+FFbXzk9cFkJ405+G3BD2jA1hP3OyQuiR3XSmhDBPLmDsmBDmykpe
0f/V6BC+kZnqGzJCWMe9qSGUZIZQRgZFFHI0LYRTjv/Icc5yhqn6f5DH6OeK
7BAuZ2F6CLvML7CXbufnyyb1PDnFOQVeFzKO/FjnkDUmyhu5gUmU06c/zz7z
+SKeI6+l1Ro7rHFSbRWHc0L4jgr9m+Rmtqm3yzb2mr9MNtKpvkIup1d/tnk5
fK6eFe8JLeZvN/+42kp69R5isv4NciNb1dfL1/jU/ISspUO9Xtbxtf5U89LY
p54iR9Ns/jbzj8W90KP3IOX618qX6VJfI19it/mPyyfYov6UfJIe/UnmJfOZ
+pVyBE3mbzW/X62RA3q7mah/tWzhbfVm+QK7zC+Xk+L1qN8UrzWupX+R94/x
KP+p/cs887vMz/WZDl/tun3+CZo9c1WeqXNelzp2Wk9mvK9kkEM275n7bryH
bPe+S77DXP2l9l/GAfXr5ASm2V+GdcZQ49yReq+iVU+yTGKOc5+PzxorWcVz
zFZfIZ9lGctpZJb6UvkM9TSwhJnqtbKOGhIsplJ92Hp/sZp/+Jvr7WfA/Rjk
Dvsssd/xdDtWLIuY4dz77HEB7eoPyPspc78edL8OUmyNL+WQ/INL8d7yJ+3W
uKR/iE+c/7v8jQZrvmV2n9pS9qvtY4L+u+U9vKF+l7yTD+yvWJawTr1Ujo89
+i/KAT5WvyDPU29+p/nfqy1hr9oeSvVXypm8rj5DTmen+eNkXnyG1QtkfuzR
/4s8x0fqZ+XP8ftifof5h9Xq2B3Xj/vTP0VOjd819dvlbbxvfpbMZo16rsyJ
PfpPydPxGtVPyhMsNn+L+d+qJfgwHqdI/y3yVtarV8ib47NofopM5UX1dJkW
e/Qflf3xGtWPyD6eNn+T+b1qNeyIe4zXrD/Z+5GMICl+N+kw/4LP8yLnGWSA
V+N8v5X9HOEhvVVMM7/N/Cw9Q579at+rhaTpf0RfNfN5mCo200wLFayllWHP
2XTnzyLPHto8kxtZ5P9Bk/k7vf7VsZ/kCUbpH+VYOsXWS5Jn7GdQTo6/kdf4
58P/WhrplQ==
           "]]}, "0.`"], Annotation[#, 0., "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Directive[
           GrayLevel[0], 
           Opacity[0.5], 
           CapForm["Butt"]], 
          LineBox[CompressedData["
1:eJwNjr9KQnEYhl+JFinNc1TKMgiiG7CDDpEiQS0qRqLLIQiiTceGytkpvIAG
r8BE8gpq0nSSlob+DIUuOpVHiXyGh4f3fN95f9/WWem46JJUgN6y9G5IKdz3
SWn8QR77pY0VKUO+C0iPeMC3IewuSRdQY/4TlH6hxc6mR3rGXWjDObmDHa90
zX8j8hUe4xvcpDNpSk/4nrcbYNH7wOyQ7iO4ZRalIwYTZkm+OXjKjTNw4JId
mx6D3j+yD3+x58F5ut5wFufgBNbZj3CzBXvkBOzDAntxbjiAHW62V6UKb52u
SWVcJ38ze8Uv4KZHzBZhm/er+JPOcEgy4Z88B4mCNiQ=
           "]], 
          LineBox[CompressedData["
1:eJwVkD1LQgEUhp82hcq8lZpNugSRBM3R2BC5iB9Im1AEUg1BQ0u/wCKaokhD
qC2IGpttkP6AYGMNRUh0Ibeehof3nPO+95x7b6a2V9gdAaoSTsF7AOUx6MWh
pL7Z/zi/n4AX+1ICIjEoqs0kXEmgdyf1Ueg6r0tg5tVZ/x/nH9PQGIfOJByr
z2rXfQveubFvqi2p+NyK+Zz1olqwH5qrmn90x4OsuTPUW1fzcmn2Qo7MbZmb
dV9cTauf+tvWCetDv+NL3VQPZF/a0pATWZVzOZOIuYo7N2Ted7hNwbXszMCp
t5+sQ71f9VtS3p7Ty8mS9zLqwP8wVJf1s2mIyh9YSzXW
           "]], 
          LineBox[CompressedData["
1:eJwV0j1IlWEUwPGjIVhqlpapdykpR7XEwSGFoCChxbTU0aFcUmgIBLOhD0Fr
LqLEPohChdC0G1RbIfiFV4UcrLTJBkkKoojqd4c///ec5zznnPfe90B7V2Nn
RkSMoqM44l5JxBMc3xsxxiO4mxdRn85he0FELVfjuvq3uRHveZv81cKIyzi1
MyJ7T0QOfoqzOBOz+RHz4gXMYFDdMtfyNP/Ypac+bXxf7uDuiGtmD/BNtMiP
FEWc5X/mfuC/fNSut9wbdqfNjGa5LuTI56LcnUOYdV5hj0t8mOe5kue4ikfd
Sam/IH5qnyXPi6gRv+RXSOKMug79Hnh+iCGk7PmIz5l/HgviDTu18KrdT+rX
gEXxV/lW/iT/2tw32OHOhPdZkn+szzL/kv+NRvMqnLXymrN1fEa3vRJ6lGLd
2Re53vSu5lzhJPfwZPp/4XGewAtsoEnPZjx3VuduPTLMXZHL5FI1U94zwXec
3Uaf/Ds7Vdu3RP4I/1F/TI8t8SSv8jds4ru99qkvRgH2I4HT6vqc96PQ7zHj
G5pSO8Ap7vF9lcl/5BU8M/cGN9nhhJqk54v8H4CQaWY=
           "]]}, 
         RowBox[{"-", "16.`"}]], Annotation[#, -16., "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Directive[
           GrayLevel[0], 
           Opacity[0.5], 
           CapForm["Butt"]], 
          
          LineBox[{3122, 4810, 4811, 4563, 4928, 4929, 3521, 4088, 3390, 4259,
            3936, 4257, 4258, 4085, 4525, 4526, 3612, 5021, 3613, 4333, 4661, 
           3287, 4234, 5302, 3843, 4658, 3844, 5303, 3934, 4856, 3446, 4647, 
           4650, 4651, 3471, 4917, 4916, 4656, 4862, 4860, 4956, 4325, 4770, 
           4769, 4217, 3809, 3991, 5206, 3354, 5684, 3798, 5179, 5183, 5181, 
           3586, 4414, 4419, 3877, 6236, 3207, 6494, 3197, 6317, 4582, 6362, 
           6357, 3337, 6399, 6404, 4899, 6543, 5857, 6684, 6674, 6654}], 
          LineBox[CompressedData["
1:eJwVj7tqQlEQRbdFooXee33ERwofjSiksbayECKIEIkWKcVbKBIrW/9AiFaW
qcQIopUR7ES7/ICNfkCQEBC0iyvFYs+efZiZk6i1y68OSSW4uZNabukWffRL
O69U9EgHn/SF2qZUB5t+AT+zpDkY8ElvCQ1DqvCmiZr4FO+m5FtmbGANOfJ9
QOqQGezpok/0o9Qx6OEr+Gcog0XPBBu+mbWkt4A5M47s+UAn//PgD99Hx3Ch
zqNDGIATX+WmF0hzwygsvUMrIr3x7xX1ieyM/kKIO5JkD5Bhdxz9CTIXzZIn
7iUXXAEiKSyc
           "]], 
          LineBox[CompressedData["
1:eJwV0j1IlWEUwPFTCEpkpRV5BQtxUnBpanLKLGiw6xBiWIp0nfxqSNRBJZUa
bQiRoAZBsCHBjyWzwWgwlYhAEL8KZ/UmLoH2e4c//+ec55zzPM97b2lze7rt
TES8QaYoYjwVMYHbVyOmeQpj+RFVSQ55hRG3+CZeqF84H/GVz8oPXo7ow/0L
EblXIs7hWPxJnGP9/WLET/Eav5P7xcP6RvD3klqz6rkBrwsiRjGU1OCD+lq9
h+7yTH2WH4i7+CM/t98oX+7eFUjp3TXvsdyieRvqMnKdaEcH7pj7nhfsf8Y9
8a57/sFv3BVvcw3v8BMzZtQ1cRmfyO2b3yzeMufQOtfZB/zQ2dnkXdix16Lm
yPpUT6Xep+I5zvAqr6HbOXviFese71kS93KJ/kr569wg9yj5JuI67z7ivuQc
Toun1Q+I+9GNIrlrWHLuP3Pfyo2j1XpW7ahZ+/az7ptS80WugG+gGGnxsP2X
KNS37Lf+pvYV/+Be/4NS+U1ex6R7DHGd71CtZt66k/8DinFeKA==
           "]]}, 
         RowBox[{"-", "32.`"}]], Annotation[#, -32., "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Directive[
           GrayLevel[0], 
           Opacity[0.5], 
           CapForm["Butt"]], 
          
          LineBox[{3522, 4076, 3387, 4230, 3388, 4078, 4524, 4083, 3389, 4231,
            3502, 4087, 4520, 4084, 3123, 4970, 5020, 3677, 4155, 3678, 4157, 
           4156, 4660, 4659, 4657, 4864, 4863, 3382, 5018, 5019, 4649, 4654, 
           3286, 4233, 4920, 5409, 4922, 4655, 4767, 4766, 3358, 4213, 4771, 
           4216, 3808, 4403, 3989, 5688, 3990, 3797, 5178, 3800, 5187, 3585, 
           4413, 4418, 3876, 6235, 3206, 6493, 3196, 6316, 4581, 6361, 6356, 
           3336, 6398, 6403, 4898, 6542, 5856, 6683, 6673, 6653}], 
          LineBox[CompressedData["
1:eJwNkD2rQXEcx78WBg/3uDhxFxRdZTHrlsUgUvKQbLISr8ErMIk7yOKk3EEy
iMHiDdzdziIpRTaf4dPn9/j/nU601St3bZKKsPNKIUPqm1LBLU2I89jEW3oG
zpH/4j124zE4IeOS5j4phf+ZrX5IZzjBN7OHT2lBHMcz5iwoEdchFpCO7A15
p+2XOlChvoYVRNlfUhP7G3IbXpFfPNIf/uHelnoTz8kteNLL4hceYTuu0W9A
gn0rKE2hHZIG3N4R3+k98A1MbsbpJSHFt4bxlf/yxGn6kS/JAW9RlivT
           "]], 
          LineBox[CompressedData["
1:eJwVkU8og2Ecx787yMVrm/lbkj9xcNB2wMmJm5PdlZFZtHmVKe9qpVFTLhIt
KRelnJBcaLOsHV7Kq5TLSkrNiZM4UD7v4dPn+X3f3/N7nvd9u6YXwwmPpC2I
tkr7bdIRjDZJp/gEcoY04mZQ2yAN4xBk6L+uk0rYQ74WkFIwXi95G6U8/qK+
wo5XirRIQWb1+aVDsieyLPsecZrMghQMUWegyuw75rzjIPexWSfpLzAzD2l6
zvA5TJJPQQS+fdIPGDxf4tkv+/7AYIbJrARnzMMCFOkL0Bdn/cLdStRx6gRU
qHupZ7CNTXcevFL3U8/iGPuWyZLwRh0kj2EHV7FFXqQnybn3ZO2sb8luuFcZ
91B3w4B7BvUK93/grg6kWKfhk7279HzgQd5hlSwHe1DDvihzD1jP4Qu+a4je
bXd2s7SDC2Q+5hVxB57AG5yfBT/7bP5fmdmb2MEW/7aTvIKf4Zgz1nGYs8fo
uWRt4n9zGlSi
           "]]}, 
         RowBox[{"-", "48.`"}]], Annotation[#, -48., "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Directive[
           GrayLevel[0], 
           Opacity[0.5], 
           CapForm["Butt"]], 
          LineBox[CompressedData["
1:eJwNjz1vgWEYhQ9LF19VBJtYOjC0S+MjEXaLgURMjRUjiZlYuuibGEgYiEFE
/AaTuQNbSQxEJBhMJK7h5Hru+5znvM8b+K5kyiZJadR3SAe7dEQTq3SGw1fp
BD8s0gV23qQrnOLf4Ag/x24Ml6hIrsc+SleJjIVdBf66JQO5UI25DTfkFnAL
Czbp3SmFUBi1uB+hd0Y2BuewS3aAl/BIWc5VMnHOBt4n3zHo+WJe0dXxSXu0
JZNy8XPskmQyXqkJg2TznBu8t0CuDifMO7w1/EMv9D6gGT/AG37gP/1+v+RA
d+YnvY4vXA==
           "]], 
          LineBox[CompressedData["
1:eJwVjjFLglEYRh+FTEGzT/3EEpQoFFya1UXMPVL4aEqxTciiX+HkJLqIU0oN
LoaDmtDWVhD0C5waRBB00MXjcDjPfd/Lc+9Z+TFftUm6gaxbCh1LYfj0SCZu
gx8y7Lz415AMPGXvxhPsYtYiO/EhdL3SD/6GAjnFnTdcMqVX/EfXFznmk+6P
pGtswS006HkISP/Mn3AuKF1BlTxg/4yH+B3b99288cF5CmnyOW+NyUVyjzsb
evp4G5JmdDfJB8zu2FvMajhOzwu5A5UTqc7/RuQluxVegEnvBbsEXPqlCJ7z
rzVOso+eSg7YAV4rLK0=
           "]], 
          LineBox[CompressedData["
1:eJwV0c9L03Ecx/H3CDypW/5KDyMKQ4RARyNBRoe8BaF50S6RQQQRrdjAFoyF
RcnyYBCMvAqCegiETlKtxNiQCAy6lOsQ2CH8H3x0ePL6vF/v9+f9fn++3zO3
8tP3ExFRxe3+iDcDEau43Bvxlq6j1hGR+++hrSviIh3Fgvrt9ogdGvyr9El3
xJXOiM6eiMTJiCN1//Ced/NUxIhe5/gZuin+nowYQJm3Ie5zfuW8QJ9hDE29
Giia8VyfCu+v/bbMPqCPeGn6Gy1cEn9Qn6MP7HNDXTZlTxyYe0//Fs3r81Cu
zh9EE0P4I1eQK8h9EQ/jPJK8eXx0vyi3xxtBBofulOTqcjsY482p+WT+C3vs
yi3SJs3YsUGP5Pe9ed67xsWPaRkVvNYjq+4CZvoirmMWX72rJv+LrtC75tzh
V80fdWdZn7Piz2a99N0PcYKfVj/FW7LPpP+UcrdJd+2wSL/RktrT/J/0B9b0
fEqv2WFCzTvnPD0GpKhP6g==
           "]]}, 
         RowBox[{"-", "64.`"}]], Annotation[#, -64., "Tooltip"]& ], 
       TagBox[
        TooltipBox[{
          Directive[
           GrayLevel[0], 
           Opacity[0.5], 
           CapForm["Butt"]], 
          LineBox[CompressedData["
1:eJwVjztLgnEUxp8wFy9d9M0bJEguLc46OmjiVhB4QcULQovip7CGBgcdDCdB
CcIhHAQFp6RGwU/QqBEEtjj5c/jxnPN/nnPe8wZK9bvakaRbiNok95nkg7ld
MtAX6IL1XCp7pCoZ04W0pM86pQzMyFroMydSh2waHZxKCfJFshH8R69UoM7D
EG/FngX1J3xAhZkvNMlMmF1r+lfqFNQNKeaS4nADDfqxQ3pHN+Qih9ugBC3y
Qb43xS/Sj8i8wY73b25rUx8zk8O7562JPkGfugcP3PnMbRPqP9636C8Y7LzC
u4YQ/3yJ/nDLPxrG9/skM+wBvgYuOQ==
           "]], 
          LineBox[CompressedData["
1:eJwV0c9L03Ecx/F3gbc2y1qzGoEgIXQwJoYRFXUTosJLUodJhOBlgoH4YyEG
IWu3DpHXIFggguiloA6ytR1iUNElhWL+wF//Qz12ePF8v9+f9/v1fu+7rifj
Q/ljEbFATzsj3p6LeEe3UxHLWKY3iYjrrRq1dUT0Yy/N6/90ImId/52KuItz
pyMGkxGJMwzVjvQdUC4dkeXzR7xFS/IL7RE/qJMKes/jB/UUNvWksSy/wnfP
PS/5buMu7dCK3Zu4ihl8ZuaGns/iCr8q9Z10H/XTX/uneU1RzswM1tTrdIma
3ifsnPBWlffQZUqqTdIXfsPeXpsbwVkstG4zN9Da4/0q1vAr7buj6J7n7sqK
D83U+Bzhd7/rJz0669uqPcaHvL75btfk42YGsCH/6O2meEO86PuP2XFLPqpe
tLuot4Td8lfiHTpuf0b/fftL/pN7vNvN1rFi/wI2cErvRfXf+Ive83mBD9x7
R8+aOI//AW2fUUU=
           "]], 
          LineBox[CompressedData["
1:eJwNj71vgVEcRh+LqbyaF8Gku7kbYWokXUhIxKa7lsHQmc3gI5QmLBLDG4O/
wFek6WzpVCQGYjEaSDjDybnPvc/v5t6n3Hsyb5P0Che/ZAQkP6y9UpUcNCUb
vvoku0Na4T/YPUoW/nyQspyXcYZcYb8MCdZRfGMm5pa2LmlPrw3P3N1kv8W6
gcPkf6dUopPySBHymvyDv8kFeh8wptslx7l7ibN0ZngBc9gYUh1/8RYTF5nJ
M1Nj/cJMj/Nf3jSEM/tp/jbCHdyFNkzpTiBH/417QjCgf2LWonvEB+jz1juA
PzJb
           "]]}, 
         RowBox[{"-", "80.`"}]], 
        Annotation[#, -80., "Tooltip"]& ], {}, {}}}], {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {0., 0.}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, AxesLabel -> {None, None}, FrameLabel -> {{
        FormBox["\"\[Xi]\"", TraditionalForm], None}, {
        FormBox["\"\[Theta]\"", TraditionalForm], 
        FormBox["\"effect of wall on \[Theta]dot\"", TraditionalForm]}}, 
     DisplayFunction -> Identity, AspectRatio -> 1, AxesLabel -> {None, None},
      DisplayFunction :> Identity, Frame -> True, FrameLabel -> {{
        FormBox["\"\[Xi]\"", TraditionalForm], None}, {
        FormBox["\"\[Theta]\"", TraditionalForm], 
        FormBox["\"effect of wall on \[Theta]dot\"", TraditionalForm]}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, "GridLinesInFront" -> True}, 
     PlotRange -> NCache[{{0, 2 Pi}, {
         Rational[-1, 2], 
         Rational[1, 2]}}, {{0, 6.283185307179586}, {-0.5, 0.5}}], 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{{}, {}, 
             
             RasterBox[{{{1., 0., 0.}}, {{1., 0.8829533865077366, 0.}}, {{
              0.6465918104939825, 1., 0.}}, {{0.1761370074957016, 1., 0.}}, {{
              0., 1., 0.29431779550257886`}}, {{0., 1., 
              0.7647725985008593}}, {{0., 0.7647725985008589, 1.}}, {{0., 
              0.294317795502578, 1.}}, {{0.1761370074957016, 0., 1.}}, {{
              0.6465918104939821, 0., 1.}}, {{1., 0., 0.}}}, {{
                Rational[-15, 2], 
                Rational[-225, 2]}, {
                Rational[15, 2], 
                Rational[225, 2]}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[-225, 2]}}, {{7.5, -112.5}, {-7.5, -112.5}, {-7.5, 
                112.5}, {7.5, 112.5}, {7.5, -112.5}}]]}, {
              CapForm[None], {{
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], -92.04545454545452}, {
                    Rational[
                    15, 2], -92.04545454545452}}, {{-7.5, \
-92.04545454545452}, {7.5, -92.04545454545452}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], -71.59090909090907}, {
                    Rational[
                    15, 2], -71.59090909090907}}, {{-7.5, \
-71.59090909090907}, {7.5, -71.59090909090907}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], -51.136363636363626`}, {
                    Rational[
                    15, 2], -51.136363636363626`}}, {{-7.5, \
-51.136363636363626`}, {7.5, -51.136363636363626`}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], -30.68181818181817}, {
                    Rational[
                    15, 2], -30.68181818181817}}, {{-7.5, \
-30.68181818181817}, {7.5, -30.68181818181817}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], -10.227272727272718`}, {
                    Rational[
                    15, 2], -10.227272727272718`}}, {{-7.5, \
-10.227272727272718`}, {7.5, -10.227272727272718`}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], 10.227272727272736`}, {
                    Rational[15, 2], 10.227272727272736`}}, {{-7.5, 
                  10.227272727272736`}, {7.5, 10.227272727272736`}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], 30.68181818181819}, {
                    Rational[15, 2], 30.68181818181819}}, {{-7.5, 
                  30.68181818181819}, {7.5, 30.68181818181819}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], 51.13636363636364}, {
                    Rational[15, 2], 51.13636363636364}}, {{-7.5, 
                  51.13636363636364}, {7.5, 51.13636363636364}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], 71.5909090909091}, {
                    Rational[15, 2], 71.5909090909091}}, {{-7.5, 
                  71.5909090909091}, {7.5, 71.5909090909091}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], 92.04545454545453}, {
                    Rational[15, 2], 92.04545454545453}}, {{-7.5, 
                  92.04545454545453}, {7.5, 92.04545454545453}}]]}}}, {
             Antialiasing -> False, 
              StyleBox[
               
               LineBox[{{7.500000000000001, -112.5}, {7.500000000000001, 
                112.5}}], 
               Directive[
                AbsoluteThickness[0.2], 
                Opacity[0.3], 
                GrayLevel[0]], StripOnInput -> False], 
              StyleBox[
               StyleBox[{{
                  StyleBox[
                   LineBox[{{{7.500000000000001, -92.04545454545453}, 
                    
                    Offset[{4., 0}, {
                    7.500000000000001, -92.04545454545453}]}, {{
                    7.500000000000001, -71.5909090909091}, 
                    
                    Offset[{4., 0}, {
                    7.500000000000001, -71.5909090909091}]}, {{
                    7.500000000000001, -51.13636363636363}, 
                    
                    Offset[{4., 0}, {
                    7.500000000000001, -51.13636363636363}]}, {{
                    7.500000000000001, -30.681818181818176`}, 
                    
                    Offset[{4., 0}, {
                    7.500000000000001, -30.681818181818176`}]}, {{
                    7.500000000000001, -10.22727272727272}, 
                    
                    Offset[{4., 0}, {
                    7.500000000000001, -10.22727272727272}]}, {{
                    7.500000000000001, 10.227272727272737`}, 
                    
                    Offset[{4., 0}, {7.500000000000001, 
                    10.227272727272737`}]}, {{7.500000000000001, 
                    30.681818181818194`}, 
                    
                    Offset[{4., 0}, {7.500000000000001, 
                    30.681818181818194`}]}, {{7.500000000000001, 
                    51.136363636363654`}, 
                    
                    Offset[{4., 0}, {7.500000000000001, 
                    51.136363636363654`}]}, {{7.500000000000001, 
                    71.59090909090911}, 
                    
                    Offset[{4., 0}, {7.500000000000001, 
                    71.59090909090911}]}, {{7.500000000000001, 
                    92.04545454545453}, 
                    
                    Offset[{4., 0}, {7.500000000000001, 
                    92.04545454545453}]}}], 
                   Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], StripOnInput -> False]}, 
                 StyleBox[
                  StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "80"}], TraditionalForm], 
                    
                    Offset[{7., 0.}, {
                    7.500000000000001, -92.04545454545453}], {-1, 0.}, 
                    Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "64"}], TraditionalForm], 
                    
                    Offset[{7., 0.}, {
                    7.500000000000001, -71.5909090909091}], {-1, 0.}, 
                    Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "48"}], TraditionalForm], 
                    
                    Offset[{7., 0.}, {
                    7.500000000000001, -51.13636363636363}], {-1, 0.}, 
                    Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "32"}], TraditionalForm], 
                    
                    Offset[{7., 0.}, {
                    7.500000000000001, -30.681818181818176`}], {-1, 0.}, 
                    Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "16"}], TraditionalForm], 
                    
                    Offset[{7., 0.}, {
                    7.500000000000001, -10.22727272727272}], {-1, 0.}, 
                    Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["0", TraditionalForm], 
                    
                    Offset[{7., 0.}, {7.500000000000001, 
                    10.227272727272737`}], {-1, 0.}, Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["16", TraditionalForm], 
                    
                    Offset[{7., 0.}, {7.500000000000001, 
                    30.681818181818194`}], {-1, 0.}, Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["32", TraditionalForm], 
                    
                    Offset[{7., 0.}, {7.500000000000001, 
                    51.136363636363654`}], {-1, 0.}, Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["48", TraditionalForm], 
                    
                    Offset[{7., 0.}, {7.500000000000001, 
                    71.59090909090911}], {-1, 0.}, Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["64", TraditionalForm], 
                    
                    Offset[{7., 0.}, {7.500000000000001, 
                    92.04545454545453}], {-1, 0.}, Automatic, {1, 0}]}, 
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]]}, StripOnInput -> False]}, {}}, {
                    Directive[
                    Opacity[1]]}, StripOnInput -> False], "GraphicsLabel", 
                  StripOnInput -> False]}, "GraphicsTicks", StripOnInput -> 
                False], 
               Directive[
                AbsoluteThickness[0.2], 
                Opacity[0.3], 
                GrayLevel[0]], StripOnInput -> False]}}, PlotRangePadding -> 
            Scaled[0.02], PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 225}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{"Hue", "[", "#1", "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "102.02892965294143`"}], ",", 
                   "102.02892965294141`"}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "80.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "64.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "48.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "32.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "16.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0.`", ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"16.`", ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"32.`", ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"48.`", ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"64.`", ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}]}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"Charting`TickAnnotations", "\[Rule]", "None"}], ",", 
           RowBox[{"ScalingFunctions", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"Identity", ",", "Identity"}], "}"}]}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.824715062422659*^9, 3.8247151416122713`*^9}, {
   3.824715215539781*^9, 3.8247152231637497`*^9}, {3.8247152756684575`*^9, 
   3.824715354320746*^9}, 3.824715402894766*^9, {3.8247154515694027`*^9, 
   3.8247154918035793`*^9}, {3.8247155808555636`*^9, 3.8247155942693152`*^9}, 
   3.824715666314657*^9, {3.824715739354943*^9, 3.824715789628072*^9}, 
   3.8254313809788814`*^9, 3.8254316536096783`*^9, 
   3.825596896130368*^9},ExpressionUUID->"a2c45a93-0cd1-4689-a057-\
90e6c02a9f1b"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Extra term for x (not used in the paper)", "Subsection",
 CellChangeTimes->{{3.824672455710767*^9, 3.8246724658210077`*^9}, {
  3.828090933866617*^9, 
  3.82809093880412*^9}},ExpressionUUID->"cd0c1417-e871-43a1-94a3-\
653f85f276ca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"fNDcentx", "[", 
   RowBox[{"\[Xi]_", ",", "\[Theta]_"}], "]"}], "=", 
  RowBox[{
   RowBox[{"\[Alpha]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", "/", "\[Epsilon]"}], "-", 
      RowBox[{"4", 
       SuperscriptBox["\[Xi]", "2"]}]}], ")"}]}], "+", " ", 
   RowBox[{"Cos", "[", "\[Theta]", "]"}], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "2"], " ", "\[Rho]2", "  ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"\[Pi]", " ", 
           RowBox[{"(", 
            RowBox[{"\[Xi]", "+", 
             RowBox[{"1", "/", "2"}]}], ")"}]}], "]"}], "2"]}]}], ")"}]}], 
    RowBox[{"12", " "}]]}]}]], "Input",
 CellChangeTimes->{{3.824672473669222*^9, 3.8246725151045465`*^9}, {
  3.8246730190715427`*^9, 3.8246730275725136`*^9}, {3.824673203254073*^9, 
  3.8246732135764856`*^9}, {3.8246733696824017`*^9, 
  3.8246734265874043`*^9}},ExpressionUUID->"31242526-efb6-4e61-afab-\
decf2bea224c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Alpha]", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", "\[Epsilon]"], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["\[Xi]", "2"]}]}], ")"}]}], "+", 
  RowBox[{"Cos", "[", "\[Theta]", "]"}], "-", 
  RowBox[{
   FractionBox["1", "12"], " ", 
   SuperscriptBox["\[Pi]", "2"], " ", "\[Rho]2", " ", 
   RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"3", " ", 
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"\[Pi]", " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], "+", "\[Xi]"}], ")"}]}], "]"}], "2"]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{{3.824673427306346*^9, 3.8246734351706696`*^9}, 
   3.8254313814067135`*^9, 3.825431654573841*^9, 3.8255968963043737`*^9, 
   3.828090931049711*^9},ExpressionUUID->"8a2ce25b-bda1-4172-a819-\
e1102fa159d0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[Pi]", "2"], "   ", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", 
          SuperscriptBox[
           RowBox[{"Csc", "[", 
            RowBox[{"\[Pi]", " ", 
             RowBox[{"(", 
              RowBox[{"\[Xi]", "+", 
               RowBox[{"1", "/", "2"}]}], ")"}]}], "]"}], "2"]}]}], ")"}]}], 
      RowBox[{"12", " "}]]}], ")"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Xi]", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}]}], "}"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Theta]\>\"", ",", "\"\<\[Xi]\>\"", ",", 
      "\"\<effect of wall on xdot\>\""}], "}"}]}], ",", 
   RowBox[{"Contours", "\[Rule]", "20"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "Hue"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8247150249663005`*^9, 3.8247151409935646`*^9}, {
   3.824715192671945*^9, 3.824715221617838*^9}, {3.824715272567954*^9, 
   3.824715352855175*^9}, {3.8247153896386304`*^9, 3.8247154011886415`*^9}, {
   3.824715446035857*^9, 3.82471549049403*^9}, 
   3.8247158086768274`*^9},ExpressionUUID->"6f86d1da-cbee-4fa4-995e-\
7f4de1c3e4c7"],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx0vQmcj+X3/z+LMZaxzMZMtJB2FUULct9KWVOyixSlpCgVrYQUlaIi0qKF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   "], {{{}, 
     {Hue[0.02172643315921652], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlWtslFUQhqetLRdR5Hy7293t7rbbtEBpFMVAqaSIIqSiiSmKmlQJUfrH
iCUxGhViMRhRE2MVRH8JKhAvUUooChI1AQMColWRpEq5iP6hASkXhUCMz/B+
P07es2fnzJl55535io90zn2i1Mw2scpYS1Jmq32TN0sWzI4PM/uWsx2R2T1X
mS0OZpNYN3PpGzCVNbsBmxZsX+H3/AqzN8GKKrO3OE9y9yfursRnHziM8z9x
vzlh9l6QzVrwXdZK9peC7Nz+fj8L8j/g+zqzVexL8LErKLYtQb7c5wDn7/D7
Ts43go9ltT9QbfYkdyePNDtVY7ab/3qGm30HPlU0u428plSazeXdi6PM2sDu
a83msD+P3za4eLSEN3hnJnceIrbfwYDftSPMrqvW2x7D8py4cw6fJvcueGnH
ZjmYzSsej+uF+Nz/d+48x9eSZs3x3nm9npiPsu/Dd0OjWf8Y3sFnNt772X/1
irmcuxuJbxs+B8jpU343EMOycWZDvLuFfGenxdeVmoK/BcWfBcfWif8R+H+Z
3w9Tx9nw8Dn7DnLvA79izcDP12B5SjxUkPveIP97wI9Yn+DnY3BiJE7y7G9l
P404XwrShNf9xipxfPco6eZ7bIaT137w5Fiz9dfAP9iSVy6e0yJWK3UcU1RM
HttE8C6vJTY57q4J0snPYGVaPnsbzJZydze6PZSXhtymFj8dMT/O033ceR4/
afzsjzXp2vw1SAPd4C1B8SzEZhec74XDH+GhkFcenRmzIm9dJq+RxH+hTrn/
C6brle8SbHL4+QN+qvDzJeum0WY7wc8SOn8dLa2vVl416GE69vPY93sNk9qf
Kygfz6vLuUmqN1dztiijOi7Gz7JI8TwAXsjq/MWCtOUaO0xfDMWcO/ddvHEM
TvaBk+mNi3D+Ya3Z2Uja+xvsDbrbwv72SD5dO0eCdHgYXFetvWuzEIlb5/jM
BLPt+OlIx7rkrVb42RrUcz1gTUF6W0H8iZxqPYifZzPqzwXjzUZH4sfr38P9
U9w9T5ytkfq6PJKGPK9BcENSPei92JjS3W78rYpkU4mfhZV6199vi2fCUvCD
WAONYHNaM2QeftqD+v00NqeD9DAEroj7yLlpT2mmHSGP6Sn1yAy4/4G3tsLD
cfjIYvcFdw9xr8l5vpo5wX5Ntc7fB8/E883n3Pys+NzH+cEq9bXPbI/D4zkR
Scducy/2/9TKj/v7K6FcfLbtDNLPDu/fjOxnEmON9yF8juO8JFLflYLNrEvE
NtU1lVWP+PzYhv8yztvIaVP8LfBvguv7is7ZRyn1nc/yN/Li2fl+Lqd4PC7X
rmt4VlI94HenktecuMe95gdi7bkGt2fUjz4nmoLm/GWwNyUbn6N7Esplc055
er7NQVw7J+fAk1Wqi9fnbJCWGrzXiqqp93ohaKb5bDuRkCZdm42xNnxOdKKN
o9S0iflcFilfn0mP1+sb+nZROnA9LEiJa+fc63kw6LvwKrgh/vb5N3B8UPxe
k8H43TuId0JRdff6ez+73rzvPU+3z+c1O5w313t/jerldfP55bxNC1q+fybS
fPHZMinSN95r8UvQN89n/pRIc8TnyYORZpDbH0vqe+A2pbz1P7RoOaE=
         "]], PolygonBox[CompressedData["
1:eJwtlntMl2UUx4+igpfMnld/Cv5AwLuAJmpoqeGAmUar2Wg1zaQ0IxtWpok4
SnJrTWWiLtdam3M1b0UXakh2cak1p11ItGjLgWgzNW0WlLq1Pl8Pf5y95/Kc
53nO91yeN+Px5fPKu5vZDqgHdDoyO3Cb2dYEsyb4y+lmU/qYfZJktiTVbG2W
WW0w+xSqipt9nW22mXU1UD38YzlmCQPNukHF8E9BPeBHsf5efDMzzLYlmn3D
oWsHmd2B3wLOmngre8L/yx7NfJ9n/YODzYqQH0F+Anl7zOz8KO6GvAR6GNsR
9uyj9dAGbIdYU8bafORp2Kuh1+BvR1fC2qF8zxBnUz/uh/5X5PGJrovDj2SP
RyOPSbHV4VOPfiJycabZS4P87u34jCOW5mFmc+D/wP8ocdZz/pOsn876qfhX
4f9G8DvoLocij/V+wP4Kfs8Yl4VBT3znEfNzwTEQFkWcN4nztnJGS7pjImxO
Yb+OvX2c2f6ufM2POUbCajf22aPN7mJNIXwRNB3+RvC9tGcu/Ex0c7DdDf87
Z33JfRORy6BVYBEbCw6R51S5FabCdhZ0J3z5EGLE9yJyPva50HX4F9Et5K5l
7DcH/md0/2V7jahW3kRXi+0YNEB7QTtHQODZ0Nvzc2SkWQH6ufALe5l9iM9B
1ieh+wd+MXjEueP8yGtEtXIMfRu1epZ8pMF/AHWY76G92oixBKxmgf9K8vcA
d1weHCNhpZgUm0G3YL/CtwV8Xxe+rFsVc166FO4S4w4d6N8WIf+Afy0+W6Bf
4PPQtXb5V+Jbynmrg2MkrG6kmL2FPBt5ButfifvdFUMN/bYH/93Yt0Fx1q5C
robvhFI5Owef8fjmQMPhcyOP7xo9Oxl+AGec43sUyiWXuzPdpjXtYFGZTF33
c3xi4L082bGWbgjyKc4bhu8VzjtObhbFvNY0I65Se0VDzfZhexp6IctzrFwr
RsW6g/WLg2MibIrIcUtf+reb2QVqair6G8j5xPt58B5Tr8lHvsn4ZCOPhZKw
JaIrDF6jqtWpad676uFpaV4zqh3p6tj/IPHUsL5Ce7LXfnzOILdDjfDr6JF9
2PZCl7C/j64heEyKbT35+Az+ZWglti+gXpHXjGqnL2t2wp/VTMzyHlIvaUZp
Vp0I3mut3K85eA+qFw/AV8c9J8qNYlSsf6pH4Buxl2P/ljMq4E+o5rN9hmmW
qeZV+z0jr2Xlcyb6jdTE9eAzUbNRM1ez91xXLXyEfCT4jNSs1AzRLClBfgbb
BOgacjvUk/VLsa+JfAZoFjwUPP+aOS3opmg29PX5VaC5Q420qjbRn8zyGa1Z
vQzd5ME+kzSb1kFV2Z4D5UIzU7NTNaZaK4VWYDsM9dYsQw7Yf0IejjwCaoVP
TfXZq5pNg58QvLZUY3mRz3jVg2ZKCvyz+CwIfkfdtQG5LXhNqDbGc0ZxcJ1s
+epx+GR8m/UWQMdDVw2qtpl/lfAnsV/L9pmn2ScMhaUwFbaqQdWiZoJmg94Y
vTV7sb+LbRNUCd895lgK08ZMx0hYqQZUC38Hj+UyMf8Fv4j3Y3N/n3HfDfQe
Ua/cnAn4dkI/Rn5H3bWAnF6O/E3T2zYt+HumNzkB/atx70X1ZP9kf1P1tioH
yoVmtGa1MBJWpey/AjlCnoF9DbQRfpfwhd8HvRc8RsWqmlJt6c3Q23E0+L+F
/jHy4C8xczMirznVnjAVtnoT9TYq58q91mjtRXL+Pbb10Gps2zP8bdWbqrf1
dLr3nnrwHnrzcPC3WzEfgt8SvHZUQ2Pgl7HHfcF7Wr19IfLZrRlu4FvI/a9G
jqGwVIw3Yw0+qzVDNUuVkwrwGx18b/0jXA3+T6R/o9/wT4HPgc5H/o+kf6Wl
zPjtwTETdqoJ1UadMISvgDYEfzP0dnRkei2oJjoz/c3W2603Um+lek69Nwk5
Dyx3oXsneI6UK/WUeqsJ+hj5f7ukgkY=
         "]], PolygonBox[CompressedData["
1:eJwlk1tIlFEUhZdK3srQ/y9Nc7RBK2QygpKysnyw0qCHjCCoHiwlKlLBDI2w
0aSgG0pJr0ZjoUZl2UUNIeiGlyQrYwLNcN4s0CIvJdH3cx4W7L3O2pez9znu
QyX5xcGSNoB5YP0qaa0trQOzkVJGnDQN9wHfD57FSO/gotyI8c9b0qYF0kyq
FJ0sNUZIX+DqwRmPlEJsOrp9YA6dezF1wCx2PlwK+IzuLrhHzH2QFybdRvMJ
zsV5IigPkZrI74PzoXkLHoRLmUukMrgC/EnQQ/0xeutFW0VMErHJYAhNaaJ0
MFS6gO4R3AS9tcO/xx8E16lrx0p7XSb3G6cXcBRNYgLn2COggxo+8g+j9TOP
X+T6CXLSmSM5N2NngVHytaPxrpTS6GUjsa3w1fg5S6WiIOkJ3FPn3tQoXMas
nbnZZj7/lktr0DWQ5yb8LnAcXRY1dqDZbpv7zNBbObyX826QTe/13CGwSDpM
jVtwv0Es+V1gCrsa+OdL29hb5AqzGy/5/sBfRtOeJoVztz64BmdWaDqpEeDc
BQKsP4zeCumlkvMK29yxK5768K303OzUdPohbpz4pihmiC4PbCGuLt7sdSea
MrgCuCvsfbWzf7gmcIfYXHp8zJ168GvAKY/px+krzjJ5J/Fj2HsubzYIfgB+
nBkMu82+vuIfAKXEVoBa7DmQgb6M/OeSpP3ohuAugUo0L9ndGL28xn8FHsJd
Jec3ejmL/xzU8qYi0F1D14/f57wtdFXwndh1ltnBafwa0IV/0TK1qqmZzZsZ
p1+xq1HmXcJ7LgJd2CPwg2CKuUynmn+2Ff8F8W3OOwA2dqNl3kgoc/+OtgVN
v232F0eu3fzXEHadARcKuokbSDZ/ZYLYG+AIb+gjfDzneyzzd5rZz0m4Y/gt
ltnpD2oUc48O/ATL/HeLXAvR/qVGJvHRoNdjenR6DbbNXk6w2/8Vba+3
         "]]}]}, 
     {Hue[0.07209064879974347], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1ln9M1HUYx59K+RFZG+Idxx13HNyJ7Y7IFgs0CkuduVWm/eFaprDKFgSa
RQob+aPWHxWLWv5Tf5QBYQWp0DLX7I90q+WPram5mm392JwulzYDnFvr9e75
9Af7PPd8n5/v5xfptq6Vndea2Zf8XcffNRGzNwvNarJma2vN5paYnY2avZQw
u7vIrL/SbFPG7A/4m3NmUeR3Iv9Ptdlktcv/zduH7vAss0Z09yPXjfHPeWel
zZZeb7Ygb9bM7x8KzFqhI/h7Dbo3ZrYdX3fh6074FRVm9djfncIe335BZnnc
LMHvNdh8B3vHysxKkVk3z2yA+H5F93lsL0FuFP6n0In/7UAfyHnMJXH3rRje
wHZz3nO/iuxv2B0izk3ILsLXOnwNkPfuEMMJ+EuD/bdrzI4g822x2Sn469Ff
Bv84vAvIXIZ+Dv5F7DcR2wbym1/j+dbzHib3/ejuQv6ZOWZjFGQv8q/gaw38
l5Nm0+iumGG2EjxfSLidLt63iPMB+E9jYy84HEB+WHbQuR/6NuyPJjyep4jr
MfRXIb+8zqwj+DpHjO2BPg9+NVWel/LLxl3+FPZO5tz+CPbfT3nMH/C2YOvG
mWad5WZHsf8u8n3E+xP+WqAfyXqdVK8i+mVV1HNRTseC/BT0aNpxFt535F33
dr5/lXPdQulWua+r2LyCTDH04+X+J3oS3sa40w3IjpV5nMK4Ieo2ZfuGuNd9
AIwPVnuOa/l+X9SxFcaKW/Kbiasj6Xx9V6+rf4qwsSXmdVT/dmY9r1b441nP
az30ajBtRrc34fEptifKHXdhLuw7Mj4XJWmfE83LLRHvD9nvwU8TMdSSS2PS
6626Xwbj2RHHbQK97czdBeauAvttSbdTH3HshOE4MvFaj1PxlgbdQznHVNgO
xx135b6aeI+HGnVTl6kw49oN24Kvrbx/zfV519x/nPN+0xw8GPXchUEddj/D
1x7q8jV+v4Heh+xExPmNeZ9V9d5iZEfCrN0T9xkTfxGye8CxFPlBcHsyzJp6
/JOc83tzjoXyUn6KW/GrJppPzel38M4S8yAxn+NdEXU8D/K9nb8hbN6K36Nh
rg/TR4vp89PYPIPN2UmPvwj/dRHHWXhrP2pP7iCeSwGTi7xbw057kXdBqGMD
+S2ELkD3VXIZyTndk3Md6U7czPyH3dtGjP0x71v1b1moneYmid9+ZCp5U4Ge
QQ8UVfre0x7VPKj35lf5LhBu+xI+t6r7TPIby3mO99b5DlJ/TmU8T+XbDj0d
elW7PJr13TtJXN3I/0hvLON7HB+XyDHJ+3CYd/Xd9+B5BP5J4Vrm9ImU+5Nf
YfxexvEUriXhXtyU9r5Rn+T5vgFfu+Cfgf9suEcbM94T6oEYeacz3vO6Fdpf
mnHNum6JMIlVOO7CvBD5Ldh8lHh2JL3n1Hu6OduSXjvdpdKU74FO6J6E93Zf
wmsmOx/ylmd993ahO5Tynand2Rv686Oc3w/Zb+E9X+ZYLcn47//4cf8tfmWV
z4ZyH4+4D/l6fY73q/r2ITAeDrlrDgZDjrp742G+voA/L+w99dHCvOuq9zvD
TdGNGg/7thi9giCvW61ZVQ8cgt+Ud1pzfDritevHZyb0j3hdoa90H/T/hG7r
lQrfg8ItVuU6kv8Z+ekKl9Ed1m7Vjh1L+W3Q/Oq2lKHzJ5iU8hYGGd1z3TPV
txWZSJD5HVz/BQAZQjQ=
         "]], PolygonBox[CompressedData["
1:eJwtll1slFUQhqelLf1RfprubrvL1t12KdDdUsFEBKVotAVja7QIMREBSatA
i5goJWgRgiSYWDWCoVwq0qTVQFAwEfQCLkCNXMCNKFD51YhtMSAVEAWfl/ku
nuTsd86ZM2dmzjubXLKy+eVsM9sKOTAlYVaQa/YUP56JmDVVmDXCR2Gzj2Fp
xuwlCE8yi8CKtFk7HCgzOwi1MbOekdiDCOv742anYF3IbD0UYCsfarAxGd7l
vC44hI3DsArO5ZvNgo3jzOazdx4s4/tySEbNEpDGdgYmp7AFRzn3GFRVmY2H
w9j+FhbXmC2CRmiq8W+a2wN7YRF3nMtd+8ea3Yv9BmydKDK7XGAWw68L1Wbn
4TnOWhB2n+V7JaRgLDbHwFRicR+cwefTsJi1L8DrxKQrz6xY8Rjva7S2jL1R
uAn/ZDyGiuUbwfomzi9l/TJsL4UnmGuET6F4hNkc7H3GOIvYGHRw1mp4gG/T
ZIdxJwwSiwGo44xZcIEcnIer5WbD8CJ7W+EyXIGTrDmR8RgqllH8ybmLMTG5
Rt6Kk9wZBlg7GPecKXfvsLYLiqCwynOq3B7D1tHApmxnk6MsqMBGJeRyt1G5
Hv9a7KxmbwccYHxQMSEG7dDN2m3wEDbqqI0nydmDjP9m7XBwR901xp4oTILq
tOdAubhCDv+CbYy7YfYEYgjzWTMPxrE3XuUxVCxlIxbEXLFXjpXrWs0T/y+h
hnv0MVdLLvL43Zt2H+Vr30RyBY+x/lFYSM0uggiEYSaxr4OLnLnjbrOHuc9J
vq/Dxpuwgbu9BV+M81wr57sZ/8eaf6GKOp2Q8ppX7f9CrE/DccY/QgjbYXg2
47Z1xu+c9RO2j8MZOAt5+JYLefeYjYTX+HaV83ZCPXbOUStnYRV36kj6m9Hb
+YB1mwMbsjXI3FDSa1q1rTeut54K3koSGxVwCR+Ggpwpd6+yt6fQ7Hvq/Qjn
PxL2s+XDYMxrWLWsGletj2CcDfuwvR9ifIvCcmLSBsMVXquq2d3Ep4Gz6zOe
c+VePspXaZi0rCjmWiXNasOXEDEugYES1kEDPtfDz8T2RMI1TlrXwt5WGBn3
3KsG8hmvZW1nyDVP2ncTnzYzt4D7rcF+N9+2xt2mbMcTrjXSnA7mF090rZAG
rOGcNu7wHfYbiFF7ys/U2V8z9w1MrXSt0PopjDeS8+cL/MzrUdc8aV8UYnAN
G7uy3d51xjNKzaaXusZKa6Vx0jpp2B0tS3htzcHXxwM01h10l9+I0a/wNONm
6OEOO9JuU7blo3ydyVxd3GOoWKqGVcs3gvjI501lrgnSBsVQsdSb1NtUDpXL
HGy+l+93XlHuGiGtaMFmKwyxZhAirCst9TN19k5s7Qp5DauW70f3p0GacXXS
34zezp/YuJRwTZQ26g3qLUojpBXNEe+N6pE3+N5Lze7Hl+3E8xXm96VdG6QR
X+l9cWZuyN+c3l4r+1sgge9JGMv+MdDJ3FrYSyz3QL/edMx7pnqnfJSvb5OT
TTCKWI0ucxuypW+aG5303CrH7SHXfGn/RcZ/SPejrp3S0PWsP1Tib09v8FzS
e4J6g9683r56orRZGj03iLFifQtNvg2nkn53xeDzEtdwrVdPXcg9l0S8l6un
vx/3Hq5efgufbkMf77W3wnuSetNkarQm6HnqfTMyfh+9gekZv7Pu/gM2jqRd
U6QthUHv+ZCa3pLyHqNeIx/lq3KgXGwo97eomsuizleWeS2ppsrj/h9H/3XU
s9S7pInSRmmOtOdK0CsbqK3Zpe6DfNnOmZ+kXPOl/Xc0Nez/kfRfSf9B9F/k
f6pjX7A=
         "]], PolygonBox[CompressedData["
1:eJwtk0tIVGEUx//08FEUqeOM46QzU+bko2wjaeEoJCrRS91mZfSASs0Ckyif
ueqhYrQKMnVEF06BBuWmjVTSQ4iiiBRSy1JHsaJFQfW73Lv4cQ7fd87/nO/c
c71Hq0oql0nyw0rwJUnJEGmXypZLXnx/opQD12OlMM524h+Olw7Bc7c0Gim9
xMbFSQ4YSpF610jfk6W29VIrZJHjI24H9kcqd3Cc2EiKVrukBs7roRkOEteE
tUMsjNDLM+rG4LcmSJMRUjv2mAMNCFL7VrgUjs6gjfqQmialwDi578lNws90
mj1kG9r07oB/6dJfKEendIW0CY1yOIBfytlv7v5ACzll5F7BVqBTCfepcw/G
vVLXKukj9i29vCBulPNB3j0Eveit5Z1VvHc7fWRBhDXfx/g1zOkCnKafU/DG
0niNnSf3J28LYf3k5MI1Yq/CCLlH0LBx1kvsMDkBrAcNL2Q5zO+wRGwIFmDC
mkeQ3D0bpL1QzTeeXy2dxy54pEVIhCX0ZnmHjTfEgp3cWNhGLwF6ysCmk/MA
vSHOt+BvNbT4NnNQm2bqnuNsktkEmNEU9gmaT2Ee5iAfnQH0NlJzN/6nMKmf
+e5CM996s/H2POuuj7tuNLuMepzXUL8Tv5u3P6TnoM3cOWP3JsgZh2b8XPam
BVsPfvxGa+eM3Ztlt7/BV2bUw8xmsO1J5nxjqNGBfxPaqf2OHsJc5iyMmVSh
l41eNPXXQZTb3A9jT85ad2eoEc/3D6Hd6OPt7FQIgtQcgAafedeELYJCqOP+
Nns4xncsJLcAiujhAzMtwM4y4yA/bwX5Ucw1Gi4z80tQR90c6u53mLM2Zj5G
X0XM+QS74SQ3mrf1khuP74ISKIZpYheZo43vEe0xfTu2B90AOD2m9kVqfCb2
CzjRzEC7x23+E8a/cdJl9v+KHqb436chnXmlQZs1x83E1NJ3HnGZxPWxj/0w
DI+gmLN93HV4zX/J+KcS6PEG9d3YGe6TmccvYu9Qu9PC8LusfbiL/Q/b07xk

         "]]}]}, 
     {Hue[0.12245486444027037`], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlFtolHcQxac2mkSt183ufrtJ1m+z2WxJ0FYRQUVbL3iJl9biBZRS8yCo
SdQqKqJ4wxsoNIigb4l5EYmXBH2TvhV9EJRCUYvQopCUELXVh7Ya0d9h/g/L
TCbnP3PmzMwXt+xY0z7CzDr4fcrvRY3ZfxVmw9jWKrMlo83Gx2av+Pt/4i+x
I9NmvWVm+2vNxsWOmYC9VW32LZjfcmbHU+7H4G8S/wa/D3s05X4v/q2E2Z1K
s+vgczWOV46enMdvYN8S3zrS7CE1q/HPgXlHjvlJs4MQHsqaNVL7Ozgcge8M
OE3mbR77ODJ7xNt52PPkfU5/uYxZaorZ32Ay2BLvu8vNmsj3jDxDYH6B19PY
8Tfx+xOOj8DvJr6fWruwaTg9QYcXTWZbAs9XYGZSuwf/AXVn4y+E80/Ub6af
zXB+nzebQ7xEznnYWZH7c/EfFhzfAb434RzEpYu3XdTqzDknxSN6OV/nOtwj
vjdwe4YO/2Qdo76lkTBf02MFPE+Svxx7tYRm4C/yrjLEB9F2d9Fs0Wf0iM3T
z2u4TcE+5fcF+D+xb/POsx38vYTrFlFrWZVj/gBToO5ltD0Ex6n09esYdMY2
ZFwH6ZGv87lrX7ZkPM9d8s1H03WaLxw2hbjqSGtpnkn7/mkPH0VeQ7Viau6s
N/sZ/3v8dNJrqea0wOFa2mejGZWDbSU+SHw7dnyIn5Zu4RYmoc/9Ro/r/wly
LkWfs3D7seAYYTvxh8nTjS2Qd+1YNAWfwm/GP4D/ocl5biNfQ9i9InbJGMdo
X6dlnXOSOgNVrsMC+HRSby11u7BtgfPztOOE7yD/qKTPVLPVzWgnW2p8TpqX
9ku7KL8b/QdDful9N8xRd/CuyTXcDJcj6LwRzGHe/dDge/gX+a5Evle6xeGc
z2UTmH/ZjT7qZtR74Kae8uE2Z2Et6Tk3gD8W8qtONtx4hG0L8y2jj08CXtiK
ete5q+Czkf6D4A+h6UrwE+GyHdwKam3D1oc9lPb9KeevPlakHL+et6PJsxjd
KmPfIeF/5+2GjPf4FfVbQ872yO9QeQbIURduZAj9+sJt6v5eF10TfSfKeDMO
TKLW+anujmr/XmhGuwq+r9K8Bbun2jHi+CW7vZR+p2MvxD7fC2hwO3xvdUPS
Ufp8YJ5tjZ5HM1wE7xv4y7OeQ3smTbVPmns/+H3h3is0x5LP7nPyDxQdox1Z
FbQSr9XBl96Ta72vZK1/g6SVNNO3QLvUgz2VcR20I7mwA/pO6wak87oa70d9
XaK/N6Gudl9aS/MT4JdlvZdmbCl884ux75zyR+h8pui3eQ77EfxG/JM=
         "]], PolygonBox[CompressedData["
1:eJwtlltQlGUYxx8RA0QvUmGB3WVZ2F3SVUAKDzVTk06gls7koZMViCNBpg5e
KJUHyg7eJHkqm7qQnGC0tCy7KavRi+yio814CMJs7OSMOlOKSST9/j3fxW/m
22/fw/M87//5v1+8cdX8lRlm9iZkwrxSs7nQmc87OBA32w93xsxmwFpYAx8k
zQ7B45PMWuCeNPNgeNgsA8qYk4DpIbNpcDFldgmSjEnAKdY+DR2stQX6eD4D
U4vNxuaYvTPCrIbnpwrN7h5lVpdrVllmdr3I7F8oT5jdBK3s0TbSbADeJu4o
a0Xgdd6/AUvZuxE6omYvwxXmXob2iNkzcMt4s5uhaKJZGOrLzU6MNnuf/a+y
XgH/haCBHJfAlhKzl+BzcjgG02EarCP29dBKTC3M/TvbbDXPg1F/1rsBnj9m
zY9gO7HtgDRzJwQ1UW2OE8N30AO9sI+xe+FcntkvsFw1T3oOymUyc6pgATEt
hGxyz4LhxJIJH7LGIdjGmO1pr4FqsYyaNMEZzqoPnqcWL8D9jLkPopxVMcxh
zGxYy39tcJTzOALLWLMJJrHHIuo1yPnsTvgcza3lvzrB2rWwk7N7Bb7g3bEg
JsU2Zxxxcb7tnN/OuGtIWrqRWo+BIXK/DtmskQN55DgOxsBYaGfsRtjEWs9B
GTUqhVxiGJVyDUvLqqlq28bzWggzJ5L2M9fZ57DHSGhmj8fg3ATqDa8xdhfM
QhezoYzaLyLexcPNhvH+N2rTmemakXZ6OZMeeIhxiyHMcxHs5Uz2QVWZa/kk
ejhFHccnXWua/yjzN0dc++qBOPrfSU13JLyn1FvbeN4avNN/Q3kei2JKJL1H
1asao7GDvPsHupjbDVmMvwFOkfvptGtG2tEYjX2CWJfDcdb4PuY9rl5XTVQb
aUrakoal5VkF5AO17FWX8BqqlhXUtBLOB/q/i/Ndzr6Xqelf0Mpaq6GUOfGE
96x6t7/Qa6OeD7FvhJqEYSXPq5J+BjqLb6j7t7Ar7tqRhlbwfyaxHOQ87mXP
WNQ1IW1I09L2FHKtgclQXeIakVbU0+rtk9T8BHxKDp9BkrmJia4paSsr6ecj
vWfz3EgtluR7TsrtSflR3HtWvXuR5wvQzBotsIiYF4Y8J+WmnlPvyaPkVVND
7mXytDXMyyCHYVHXrLRbRwy18AOx9pS4Z8o75dnybnmsvLYfrqa8B9WL0rC0
3Jnw2NWzu1Pu0fLq9ay5Ic81IW2chZ/hEeY8DD8R41mIR722qvEIan2Ad/uh
Gc20wHnW/CPlPaBekAYqghqqlgO8uwYvcs6b4RM4DLez7h3wIDwAT7PmOihn
rVTKPUPe0cHYLTAK7YyGBYydH3VPkDeo59R7OgOdhTxT3nmFM+0HY62hpPeA
ekF3SHmgQWlRnixvlsfKa38P+nsmOQ9Q3z/Z61rg501R90B54eEgl97AuxWz
Ytcdp7tOd5zuupOFXjt5gLxAOSv3A8Tybp73kHopTC4RaGD/+pB7vLy+mjmz
cn2NFeSzEQ1tKPc7VndtFXtVwiRqUxH2NbX2s4zZVO6akXZ0h+oubeJ5WYnX
RLXRHM19j3cHS/zOVazaczLPu4j11ahrUFqUJqQN9YB6YR6ePRfCEIEp5FsD
IfYqgD0xr6Vq2hlzD5eXv0VuXZATd6+QZ1xgn27GdEGcuaVFPkZjb0V7txX4
HaG7Qne47nLd0Q1BDIplJrnMgC5i6C50jUvrP7J2Hyylho3FXjPVroE96uEr
9vw65j2r3tU3gL4FjrL3kbTXTLX7/w4J7vB00DPqHfW8el+eK++dFnwr7An6
Tx7yJb8ribEi+IbSt5TOXGdfDLEAPedR43z5RNS1Jw1eivqdobtD9fw15HeW
7i71rHpXHiYvk4YaAs+Ud64JvuX0zaJvF3mMvKY68EZ5lLxKHi2vlmfKO/8D
BG15xw==
         "]], PolygonBox[CompressedData["
1:eJwtlFtIlGEQhl/Kcj0WeNhdV9PVdRW0w00FGmFpeeisaEVBaSSVpoUXCklq
kRZpIdGJuumkFWoqdReBQnVVkFFWlEWCoUiEkWHR4fn5/ouHGeeb73vnn5nV
W1ZdWDVLUhbMga1x0oYAaZNT2oa/He7GS3fAHSONktMfKVUnS1VQ6pEeBUqH
8N0u6S13p/zS0RSpAdrw88KkyGip2yv1QH2sdATcCdK3IMmJjVwgheNHYB3o
BEG8rdeHXgf6nTCE3gv4yJ0lwdJ77ArupHI3E3s6SmqFn+hOwySUzJa+Y6+i
fQUc1JJDTTXEmt1ScaiURP0z6P2C5+g8g8foTqK/k1hXrPHL8bvxe+A433cM
YuzvbuHsHTVcpx/J1PgafxgSiXshHd0bnKVwdiFJOg+riNVT3zn8dcTvcZ5D
bBf5u6EdnWyHlME7S6l1GRz2m/prsQNp0iC4yHXCSrsXy8krs2dzkPMB/h6E
Pt7bzHu92Jv06RZMMOtmYg5mHcMbHnjKnSfQas/vlN/MxJpNhY87IbyLfYPG
METb8wtAI4i/HdBDDx8S68JGoxdl9ZCeThFLZG4JCcZPwq4lPxfGosy8vqA3
DhMQRjwU2nm7lDNXtKnbqt9NzW3UHov97TS+B7+COivhK/4MsSlsLnPKg5fW
HsEr2MLZA+qKsXdxjPoKyS2CbnKH+M5FPrNz1u5lEsuAkjgzZ5/H7Ju1d4Fx
po9B2MvsWSP7OZdaA9FxwDQ9+gGfya3jrIacUAiBeZBLLBw7wZvjUEHeGmLB
xEZ48wM0Eisilkqsj5p7Id1n6lyM/WT/LvLJu0j+Jciyd+w2/VvNu9lwgDrW
872V2Hz6VgCjLjPXSp+pyaqtkzsdUGDvZr5l7bnep1cj1m8RmuhhIzTADrSE
Zjlv7gUvGhHkx2P9XlN/mtfsjbU/J3m/BU7YNVVg/ySaWTt55y/+P7jGLhSz
iwuJlZGzB+rQq4XqWPN/ayN68+1eVkaZPlr93M8u7IN+e/+byPN7zO8xFXsG
/bPwHy5euAg=
         "]]}]}, 
     {Hue[0.17281908008079727`], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlntM1mUUx0+JIIRli5f3wvu+8N5AolIsxcqaK8kMy2Va08o1nZqVt82W
uobZhcpagCFu/qVdZGMuh1trzekf/etWslpitmE3FiS6yfKWjj5n3+eP387D
ec5znu853/N8XzIrNy7ecLOZHeObwPdSwmxeiVlLldmjfIdYz600a2wwKypj
P2q2v9bsvWKzA3mz24gp4WBHxOwf9j4rMhvDV89enPgjNWZP1+jsIuzOpFkn
Of/lnplps9pSsybsjLjWs1h/TK67iZnD+hTfLvy/YL+vFjbHOBzuusBd23Jm
Q6ybYmb95F/IuoX90ZTZOxPNSjNmJzl7gjz92EsJYVhObJIzBydRI7G9WXKB
cxvxEbAexv8M/pkxrd/K6W9fJ9ifxnednPdik3wj3DufuptY38B/ucLsJmq5
Us7fBbPfyfMueF4mpow7LoJhBPztaeE8y35pSrV7D66xHueu69i5YP0I/wDY
B+jVVfo/HTxrqHMJ93YQs5ucO8DfiT2a1boI7paz10eeh8h/BExHwdZLHw6Q
awrc7eeuPPhaiR9n/XhMtZzn3JLAnfM/iZhmainBDnj9+H/GNof4Oup4MCYu
DhL/JPgugvM4eDsyyt+O3UfcCmKGseXkegw8q4m5h158QY3TwRwD20/0ZBb+
WzPqWzm2KS6/76+oM1sGnnpyPBEV76+Qc1VaOQ8wp1/Tt178P1Lvh5w9Dp5W
9gcnw1WJ9rx33sNV5MiRtxH/Xs615cS18/9NWjPjs5Ol5mL8lcQsjWoGZuBb
D69ZYkqJuUr/626Be+zphLhzDq8F/99R1eN1/UH+2aFvPsuLKzTza6lrfZ2w
bsCeDrw/X6Fee88XcO4sfRsl/wTObuVMNz15lpglYVa9jkhCczUR31fgWIT/
EHZqQT28E9sY0Zv1t7supRqLwXkmcD2ffSNXPfhH8V9LqJ9t4PoWPI+AZzCh
+r0PFfhawLed+C7OLcgpxmO9Nq9xIC2OndNO8AxFhce53ZTXG7nEPHyaU55u
rFWKC9eSqoR0YIRzx+KatzV34U9qxt7Gv4Nc5+hhHCwvBH1zLZkWNKqP+j6n
h2duR4Nc5wrSt9fj6qn39jx37iH+Chh256U7fq9rnr9n5/FP8r+W0Ez9h7+G
HrbTwyx2YkzrDOtkSrP3Jf38gbMp6u3HbubeLtYL4S7L3ye5ayp2U/BvxPbG
5M/l9f59Hk6B8/2CtGs7M9WZE3fRpN6hz9Ud1HgirjfiGlloUL0N2LGghz7j
SyPi7hw9u4+/C3DUGNfs+Fw5T/1x9WcLNsNds8FTk1M9Xlcf+UdqNfND+B6u
EC+uBwuqpDk9nP01vAuPfSCq2fAZyVcJs2tJNrzHHviKwcFe1pPZ35PU784n
5G+Pa12Lvy0pvgZZ11XprOeooS+L6U8hI831uZqS0aw4tu/I8VdEPfTfgYag
RfVV0g7n1LmtTksrXHe7gt661vp8+L27uH9Z0NvnsK+m9UY+IP9vMem86/28
oOeuDT6jPquui60R4cyT+0KtenK/30V8Mzk3s14bND+f1u+N64Br9ptp8es8
+5vxGtfk1QvHdrhamuWzUc08PEWeOay34usOsz1OnrLwfvd57rQ4XZ1Qj7xX
K8m3M2Bel1BtXqPrwXhW+nAjK613zS8U9BvjvFfSkzHq6uE9Xq6Vvjgen9lo
Sm/zRX/TId5/o97IiBefcZ8D57Q6Ie6dd/8fZEuYSX+7+4IO+yyfDT0fJvf/
5iZCww==
         "]], PolygonBox[CompressedData["
1:eJwtllls1FUUxg9LgZaWEC1Mp7N12llaai0IKhAiEUQoBRpNXQhLkAawEMBS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         "]], PolygonBox[CompressedData["
1:eJwtk0tPU0EYht9oubReEpNiL1I8PW1Bw4J4oy68IEgwoWrSmEiJl4QfAMbL
AmLrQle6UAFR1yZqtFhl6x/AuKBsjEKibkRjxHuUoLU+kzmLJ9+cmff75pt3
5sQHhrKDKyRthxro2ih1wmhSWlolTRC/b5C+wVij1F0vjRNTcSkbkAoN0uuY
9AYekvfUL00Frd7kXQpJFyHO+lVyHeIfqDJeJpbD0ixMOVKEem3sN8n3I5ik
XhFKsFgnvaVeNSr9g03oyvT3AF01bHu9wdxKND5YCzfJCa+XWoweKil0q6W/
xHus34d+znIdndD1Mc7BAeZ7YCIhjVC3l/rNrdL8Os5NfIV2DtqbmOe8O4gz
EfqBLvI7YQFfrlB3P+Mz1DoN7Zyxgj5N/NlMD2ukH8T3aD/AcbTHIMJ+n1jL
t0gueXGYY4/L5GbxNs36gk9KMp+nxwKEyKvFU5faDsRhhDsaxtN31P5F/m/Y
Te4TdDm8P09OHl6gbUM371hvjcdhxiGIQgn9kZj1xnhUpV4B/TXqZ+hnHE9P
4ekJ+jkJt9Hegp4GW/elY+fN+oB5F7XSHpPn+TtGnOaOn4HDeCdzbsK+G/N+
Et5du8QYmiZYcrlX5paJg2iGYBE2M1dlzs8+AfCjrQcf93WBXkbpOWo8hiIc
5mwlYox7bYRW757vkJshrxcqrq0rehpGu4ucQ+x1lvE5qOHefRDEX5c7D0Rt
P6avsukZf2aICbMOae/dbCVnC6QYb/PWjKYD7+6yx15iCQ8fw0FqZeBozN5f
f8y+N/Pu6vC+mz38xBx790EH5y3Syz7vfzD/RdL7Zx3iLOd6zr7TQeuF8eQr
Nb/AZ/jI++rmrfwHnY+Uzg==
         "]]}]}, 
     {Hue[0.22318329572132417`], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lllsVWUQx4dNaFkSoOXe3tt7e9deLNEEYsRUDCBKpHVJjLRSBETAgkoL
BRRkcWtBEKUsasSFRMImKIYYX3zBoCLRaCs+YExDURKpgDEsIiiJv3/m8+Fk
5syZb+Y/63fSjzU/2NTbzH7i6cPTUm5WPcBseoXZxYxZfqBZVd7sYNJsY3+z
7pjZZ4Hvgr/Is5dzU0rMzkXMdvY1+5dzCwtmw5DP03eeG+CHozMQW5MHmRVD
27NmK7C/BdqF38PYXBg32x/0/4BP8m0sOk0F9ye/wvJWwuw0OE+lzC5X+dk5
I8z6lfGtH/HE3Z/syN565HX4zeN3XNTsN3C+hO1NnC8uNhtcaTYTDGOwWYt8
WInjP8zZBfirLTJ7qszzovwsRreFeOux08X3Ot7346wVnU2cP4r+EWysCPms
RXcimCaBcxo2L6NbD54fhJUz63hfDt0R4toOHZV3+wn0K/OuPwCbVdg/i7yG
OOrSZm+D82bkO2JuvwE6KOR5GTY7y9xfEbIOvr2Dfjs1ulbh8Sru3cjrsLkI
nGvI41HsVI+inlHHI1yriLOBuNZAP6zwWhcT0/hytynbXeTzUWI6HnccwrMT
+iQYajg7X7nifR9nr+KrqcT7pxq6H5t/oX+Rs7egV4p+Dnq93PHsQ94dd7/y
P5J4cGXFnP2KeAbTJ0ehD/B8Tk27iWNujlojnwM9kPFctZCzYxVeo23kchHf
zqJzmljvV07wlQPjkLjz7aVmF+KOTRivjnD+cMbzqNifAMMm+O3YvADmZ9Iu
H4f8ZWzNRL+VHm6Ke6+q35eD/xX0f0Z/csA8QTY5O5qcT0OnOWBrghpY96B/
b4XPm/K2Gd3miNfu74zXQ/k5j2xXxnWU4xi2BmCzk7PTQ5+r/rVR76V7OPcF
OGfBt3H241LHPIG678HOu/jti/4jI81eG2I2A7ol7fIi5MkwL0di3suaF9nq
xP4VfP2T8HgUV0O550L25Sc+yGutWXixxGOczfeRMc+/6nAn7z8Oxm7Be0s9
9hG2m9Ieo2J9A34ffC02nsbH7fh6Ff2teZc3I6+OeOyrCz7bwizsmmHNmmbu
ath72n+aGc1OB/17DH+XOPsetWiNeHyprMevPGzH/9Ck60h3ATF/Cj8Fvj3s
mUPonEy4Th5+ftBphGZjjmExtn/HzmZs9kDHRDxvK+HbynzPaN+Uhj1ZB/6H
Er7TovjZHXaIZvdP+E/g50C7sNMK3xd+a8JzeBCdNmJYSryt0DU8i+HHIl8b
MAv7DrD2h58FPzvYnAs9MsrlLezP42HX6Q4Zm/I+X0KtevDbhrxfwvEJ52p0
XueZjPxN6JWkz86z+GlMuU3Z7kn5Pu9N3BHOb0R/BHQgzzr4YuiGSsf5Nfrv
l/rO0a79hRhuolfPFbx3VaNFadeTvnZ/fdhR2p3l5b5PdsV8V00t8l5ej3wi
vl6BNkac3wC/N+576To9crbgvs5D7456fpT71lCv76Df5LzXv4XmQ29r36QS
3kvqKc2J5qUHmk75bEbw9SvPKuRfonMg6rVTDWeFXDVAT6S87robd/2PjXN9
wp2oXI4nz8OJcTo9833O94b2h+qhutyB7VWhB5Yy4/UZ39XX0OmM+AzWEONz
6LSg8wK0IeGzdl/EZ1LYDuFrTJnPdDbpO067rjPndmV/JWcPhr2k/XQh9MDD
1Oi2qNt/Hp1elR6j+qIj3GW3Jv0+132k/Gp/KVfK2SnOnuHs4/g6U+r/DJcq
fRdrJ58g991hBjWvNaHOysuSsJ/1TyHcwj+6zO9m6WQ4Fw+YhX1q1vdYW8zv
TuXzA/i7+FZAZxJ0Xs7xNEJ7o18F3yvr959yqxxrH2kvzUB/bbgvZHtp2nOi
+eiocP0ZMe/N2oA7Hf6R9K80NNxZ6i/d3+oB9aniVx5OIr8x7bFrD+k/Sb1R
QJbIelxF4CqOuVz/U9vK/b7THbgszLj+a/4D/8t21A==
         "]], PolygonBox[CompressedData["
1:eJwtlmlsVGUUho+sU8ENpkxnprN1ZjpdINKKmrgb1AjIIkLZZK3IahFSlKKS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         "]], PolygonBox[CompressedData["
1:eJwtk0tI1FEUh38zPkZHpwfUONZYjvPQhBZJZbhprBhIF0GQi4EsIi0XackI
afbEjEScmUVBM0GpBS1auei5qVWL2vSgrE2TCSVTGRTZJui73Fl8nPO/59zz
O/fc+w8c6tvb65S0GUogXiu53JIjIpWtlsphJCglKqRR7BaftBWe1Uke1i5U
SZl1UhaGiA9CM/ETxIbxa/D9EK2ROl3UWCN9r5c2LpPmWD8aknpCtqapfY49
/ew9i12xVloOKXpoYu9K/CX2/4G4X9pUxjr6V/Fj+FewE+Qm4RX+S2gn3kLs
Nf4RdL5S+xM6SfpNgZNcB/wLcyY0bqNxKmj7P4Ot4ztodL3oQnehRhd2gBkl
oD9iZ3YjgAbnvIdeD7YUbRdEmdVT4nuw09S4Bb3sz1PneMjWNfXNHMw85n02
1offskq6w7384sz36fcBZKg9j8Ysd/UW3sEj1h/CR/LGOcdj/Hbm/MbDHOjh
5HruBpzV0jUu2k1ehvrZkO3R9Jo294duCpulnwy0FWrswB5jDk+o3YzeEn39
hRLmVgwD1I1VShX4rcw6CrNoXKf37fgN1K+n513471n/AA50GtErwv5AaxE6
uIt98K3wRvLYGebqZn5jzHkCkjDN/p30MkXuJP4UnObM8XLeHfY5/byASeI3
wcvMxtH3YQ+g0wlz9DLM2mfzTuihCb+FPnfjt0GYfSHwRKz+KOcO0EsthOE3
+TnqnS+82W0++/7Nf/CTWS1CnnqXyKsgzx22M6rEdtFbd7U9szn7GD20knfZ
b9+leZ856n2h7mHuqJj9I8SLsIPkD0Ga+0xBzmvfV4z3VUr8InkLVVbf9LG/
gbkxy0S1vStzZ+Z/Nf/tAqSZWR7biM4GmOGcB3kjd9H/D9cvmD8=
         "]]}]}, 
     {Hue[0.2735475113618511], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlnls1FUQx18LpdAWAe1Stt1uu0ePFFAE5A9FiYpoUAKBQgE5LKBAgRZB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         "]], PolygonBox[CompressedData["
1:eJwtl3dslVUYxl9AkdtbFPWW0tv20vbeDmlRqIqJMQ6sqDhARssSrWgExVaB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         "]], PolygonBox[CompressedData["
1:eJwtkj9MU1EUh38tbQScigqtQF9faZWExcTRsIkLwYHJQKDErTUq0YHFReNq
wGhCNaTFtFANxKqDmJjCRBPYTEfSpkmHRkddagPG7+a+4cs975zfPf/uc+8+
nH3glxSHIHx2pef90ifOm440BS9j0hp88WLX8f3i+yf4I9Lf89KbhJSHLnZP
xMaMJjIoZc9JoWEpeVm6AhPofqDbDUuvRqXXMI9/DgqQQb9/SaoMSSu9Um1E
egSPYRNtHt5CioY/hK3fxOfp62MfeTh99JAl3kQXikoD0CB3HcrYT9Bduyjt
JaWvkKG/A+p+ww5yPwDLzLvCvE16uefFW9Q5pK8q/CHPb7iDLo2uhi7LbOsg
r/4tx85n5izTa5t5tkzv5FmE6TFpgV0MEtvmETrkKcVtfdNHB1r02nWs3ty7
gP0UXZ66KXa8BAnH7mOHPAnqJ2GS+Z5x93vUzm3mf0HuNndX47Z3M0OMuw7k
XJt307XvZN7rNv735JjhLIza/rc5C9QpQoWZ0+wl772fecdj/EeQ8/6HDc4G
+6pDgLtV9O/Y5ymzlHzsA/sM+x/ciNt4Ed/VCWkcGvjrcB9fEf0J9n92NW8p

         "]]}]}, 
     {Hue[0.323911727002378], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl32Q1VUZxw+sy7p7l1119u7uvbv3/d51GUFXnUpFbIbY1T80ERZWxAEl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         "]], PolygonBox[CompressedData["
1:eJwtl3lwleUVxt/hQqO5IeD03iz3ktzcexMSGlKjoNU6tlNlmwqFhEDYhk0o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         "]], PolygonBox[CompressedData["
1:eJwtkb0vQ2EUxh8fjW8SioriXqnNdiUdmGsXDVbMasXoD5AQW0vRizJJJGoi
uulgKhI3Fon4GDDUgvKT9w6/POee8z7nvOe99nRibK5SUggCsNQnLcLJgHTV
KJ2iNt/bdVLaltqIgzAEDhyR26U2SuwGjSeHZ6ZbmgWXxhlI90iPtdIG2twr
NeFpRS+pFeCW/A1UdJlaC7WViOkdo/cPZ8qQIpeETXDqpSdLmmdOAu7D3J8Z
+U7pnPgMVun5QG4d9cgvE5fJH3D+EI7xF2rYg9hpZy8Y6cdPb68DP7PX/vcP
mT4ufXYgAyk8SRj2z0dRz7/DHVqEa5hiRoB6HK2ifzV88lYlGCT3xY4l3uzV
MjuNU7/Al4d95u5BxP8HFntPUp+ABeK3BuahW/77Zjn7zBu+wAf+d/gOm71/
0T/rtVLc
         "]]}]}, 
     {Hue[0.3742759426429049], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mHlw1OUZx1/OQNhEwN1kN2Sz+W12Y7gEZtRpwE5HDksBUUQqeFakIFbB
jtYZRVoEtOUaRUqnWvECI3hAvam0VMUZqCTghahQrwpY0GmtrRTPfr5+3/7x
y/Pu+z7vc19vkulzz57TOYTwaKcQugBXV4VwZSqECV0Mr4jr24ohHK4M4btN
Ifya9RHWq4HT+TpYXwrs1D+End1DmNMSwhO9Qsiwfw13v2ZvBXRHsP45eG+z
/wvgDXx/ZT0feE5NCLdw/koSwtpcCN/rFsIdWWRqDOHDniF0Bb4JfItvR9cQ
/lPmQ7bP0iFcnvfdKdD4GbzbofkjaD7QI4Sj4AdoXczvnexfBDyfL8P2Bdw9
iUUd+09A/xC405F7BbSOIMen4LSDswM5ZkFjQkMI13U1/WPgtNeFsLAihLOR
5fV6zuC3v956LkVfroYNzfBjvR64DL4HubtcduPufPBeLITwDd9BeH8N3FQK
YTw4NfCfDK0ToXnDCdDrZZwL8dN7wMPofj7rPpxvRjbQw2HkXM56FfZbCY/l
7J3NwVzuP4zcX9eGcDI067lzCrCFL826P/Dz7raP9Bp7XAjDe1nX93uan3jJ
h8uiHwWX8xEO4doq3z8W9V4W9+dim8+72Naze5qecPY0+24t8nxU6bgaxtnU
XualmFkV401xd1revhyZd9wtrjB+ZdaxcB22bG60r/+F0dtYp8Fb3+gYnsO3
LDiWr4zrYwi4GX6/hMbIsnFOKzvWhXcHOEvgtw++S4Hbm63nDuDRnONNcbcv
bZ+shd4EzmrBGQ+cBY2ZfMOgc1nKv7Xejs53IPMV/Wz7LfirL78nwXsw8Cxg
a+8QvsN3RnUI7+acP9Ph05F2TCo213K25TjbdgPnD/KN4P6gsm29psFxJHk2
dbY9pO/fOvme7t8me+H7BcjxMvK3sbeVM0wePiiZ5iDlU3fzEP2rK71ez5cB
8RD0hiPEPHyyBF4pcPLgbOQbjI1ebfb+K8B3wFsK3l789Vqt+f4TGu+yvpt7
C4j/Eay/5O4m9vsWTedp8rord7uznoZPv4kyfwJ8qJ/v7ufe48T5neA8iS7P
cTYNnK7o8cMm53UBX28B5y7W7ezdyu9trI8rWW/pf3tP1y/VsRXYvg34AN+p
8hE+PFBp3T/o5n3Z5O2ibZ5Jm7/yXfFxPzyWQL8NOKPFtG7M+V5bvCt7yb/K
qb5Z58Bo8O+tcm4ozudk7MMVxNtn6DSu0r8zidfpxPmquqQcG83vQdCrKtjP
4iH6qrWPs+7BNyZxfUrz5y30Or3CZ5/2ctyo/nZKeS1e91RZJsmjGnxuhXPv
ZGQdz51TiLtp4E7l6wOv4eBeVGk52tDrIuiNb7CNZCvFqfQTTdX1BdjlXOBM
7NStwrlwO/IdJG7uBudAs2PnxLh/YcF59EKt40Yx8KuC7wpf98fCbwg0fwDc
1WR5njnBNbUt+vSnecv4NDbeBe7KGLeKA+Wl6upV4OzkzlzgQXi8ztkh4NX8
7mB/GfrdSAx8Bc13cs4F2Vy5uRicN8C5CXgCZ+P60HMGhPA77uzXXfZ3JOY7
hjifCWzg7gruTmpy75oGbt+Ua73qxVZyoADen4ADUo4nxaPydGfMTeWgcJSf
rRlD5aviPR913M79snzN+f3RR+uQZzK+WYQOu8jTRfzeC9/fZt3rNB+oRkp2
7asepTl7HZmHg3tmYpstKFrvcowl5bT6q3rrRPWZCveqa1scuzcTF/O4s5+z
64Grap2/d0LzS9at4DRhjz3QGNPLvXNp0fm4RL0i8dmBgvuc+t2X1IZBTcbv
knWMKlbz8NpGfTgP+kewQU2t/fUyMTaOfLmuwj1V/t8Se+ufS16X8eFYaF6g
+Sbr2eRQ7Muyu+RRjE6P8ak4rcg6tx7i7vMZ98VHsO3VGduiLnHfE031vt/3
s23Uz+fX2WZfQKc1cY4NT2wv2W0NOl2RuF+NYG913nZ7Fv32o89v8Nc+4F15
+1d+/rDR88wadNqddU05yHkjsDnGnmqh+pdssC7evQ/ccg/3AOl6Tcq9WHcU
E9dUOjc3Fm2Tzo3u4cpz1Qr1NMW35hLZWL5WLVK9Vt18FT3ui/X8HXzyWcHz
x9GC7SffCf+jgmvGxwX78tv6Iz83OQ4Vj+ck1mNw2nOkYnAj+u6Ms1x1g/WV
fST/TeTevRqA2X8Turs1awIXx/0Z7J9XdM/8iPWDOde5dXXuk8o/1fPJ1aa7
i9+VPTwXaQaqj3vK7WeQI4Xt/lAyb+WaZF1d6RhWbD/KWTdw+uViHoLzWqxR
2v9HcD0QHcVqB/t74n42ZTuovp1EHMxnbwB2GFO2HJoBkx6mKf7H+jkf/wvs
3eIc6NNiPaXv6dhyVNnyjwa+VDav3aoTKfcG9QXVxTdSrgmfNLiGnpVYZ92V
jqr398SaP6POfedS4Kxm94zLmt2zFcOqAeKv3qVeJR01m6rHqX6rX8jm3VO2
i2qa6kRHnDU3DzCOeku+p+uzbDW4xf4azf7Q3qapeiFfXZyyv5QbihPFS4Ke
k9lvBG6L89tV/TzTTah2jig+FCeLapwfwtecpD6kuqn8WJTzXgE6HfHtoDeE
eEtm+U79Sr3mELwP5F2jVsNzWN49d16da6r6tGJab695cc7W+0QytyPzsLJ1
qcFwH5OHJwkPnepzttdjrJ8teQbVO0B6aC1dBtR7Vm1KO09lO9lN84NmBeVi
iPp+pfkUfkeR5xboLS95fWvJNUW15Xhi4JlG950/Ap8qeg6tByfT4pypAX4D
fhe9g4DZnOePh8FZGOcwzVCaAVSDVGP1vuwca6ZsJFuNBP8xenwVNJ8AdkLO
bsrZrGtVEmvc5qLvjq11LVZNvoC90+E1GL4HS84JyaNa/FXsKXpLHa0wTfXU
nySue7MTv+26xRnlixrj/Zs4KajOqu8Az6x2DionBtb7nbSjznmj/FH+yy6y
z9CMdVWtFc3nSp4DngcORc461i+WzF/xpR4wvN7vm9n47vEmv0n3svck+GVw
huYdB4qHqRnnpeqVcnNcjWtQR+K82RlnVMH2uFZPUG/QG+H42PdVd98v+036
Xtm2/Lb2wW9E3nwfhNfkxPV/UuK81myq3Fbv1fr/b5n2OMOo36rGqf8q5lQr
VHOrC86PmWXzUPzrruyh2qe6p7lbb0bNTwG809ifkfMMql72Yc5vNvXtR4r2
n+x4ZeKclT3Vy9S73oz/c5hU4178FHdvLNsGl6Rtk1mxVyomQ5X9t7DoGqha
OCnqPiXx+3hpfEdvrbWP5Cu999Qj1R81J06sdu3WG0w9plj2/06Uk+qDqluq
X5oD5Ids/J+A3op6U6zs7zqleqV3p+idEWmel/X/FB5ocmwpbqWvbCrbHmky
fdUlxb3eh3pz6d2m95vycBq4B4qWX3oo95SDLxBvGxpti6eLrh2qvfJjQ9nv
qM79LbNmcfnrxy1e638emqGF/zawqd5+V6+Q/WQf5c6oxPO85nrNvwOi3wem
PZd8Hz4jyn57nwpsjDm4Hr1b09b18sTve82pqqVTYj8bwnmfZvuxd7NnEc0k
emuKf2uUQfVE+Op9sm1rfLMrX6SjYljvIcWeerrqiuRU7xmYcrxK5r8gW058
c679Q1L2gXAHRhy9ARTLLyWORfWCcnyntMUeNCpn2upvkke1RnJeUvTbUP8b
O1wy/b+X3EtE5/o6zzHKrbUZ6zEx3lVM5WJcbciYp3J6c8bvJr2fNCvtiv3r
5qz/9/cpfvkfUE3Q3A==
         "]], PolygonBox[CompressedData["
1:eJwtmHlw1dUZhk8gRAhBFnOz3pu7JDeBJCyOcUnUWsIigkUBUXYLCta2Qkcc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         "]], 
        PolygonBox[{{9245, 3023, 9248, 5234, 5235}, {8072, 1183, 7074, 8074, 
         8075}, {6635, 6634, 6312, 3023, 9247}, {9360, 3063, 6398, 7640, 
         7641}, {8038, 8037, 7020, 1178, 8034}, {6632, 1374, 7582, 7585, 
         7586}, {7091, 7090, 8372, 2586, 8371}, {7696, 7695, 7694, 1383, 
         6344}, {6283, 2253, 7538, 7090, 7091}, {5246, 5245, 9359, 3063, 
         9356}}]}]}, 
     {Hue[0.4246401582834318], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3m811P+xz/32723273dtbt96259u/slhUFkqYzll71IstbPli36JUJZ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         "]], PolygonBox[CompressedData["
1:eJwtmXmc1+MWx5+WqalmpsXMNL9m5jf7b2Z+Je3ahBIlFCO0kZJLrhYpJDfc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         "]], PolygonBox[CompressedData["
1:eJwtkE2LQWEYhu9Ec2Qxs1BH+crwG+YH8A/sWZCT1UyWdmanmJoyY0OUnZ3C
lqasp4hsCVthmr3rdM7i6n7e5+t+ehOFt+yrR9IT+OAjJTXhE/4MaROVvkyp
BV3iE7kOeniWEgHe6IzaHDLMpGERkcos+w1Je3r/mTmh3/S0wQpLJbDi0sgv
DYJ40vvCzA+zXnb4YJKUxrAlZ1Ar0nPFL4Xvjj015t+h6O4poDnIu3m7Xocp
tSY6DDpxg7iHfx+q5IwHKY5fFGKwYfcaLq7XGa3g/cgNN25ZctMq6fjYfgvT
+YsjfXeLGTYa
         "]]}]}, 
     {Hue[0.4750043739239587], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHeYVdXVxu/MMEObuUWHKQwMw7R7zxk0iiWmKGKJiQ1QwQYWSGKLEhWN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         "]], PolygonBox[CompressedData["
1:eJwtmnmgzdUWx3/kcg33cnSu8brzveec36VXRDMJ9Z7hkSFUCPV61StDiPIq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         "]], 
        PolygonBox[{{11403, 11402, 11101, 3329, 11413}, {9163, 2973, 6256, 
         9154, 9155}, {9223, 9222, 6349, 3031, 9279}, {11073, 4284, 11623, 
         11604, 11605}, {9284, 3032, 6350, 9222, 9223}, {6039, 6038, 9283, 
         3032, 9281}, {6803, 6802, 9162, 2973, 9161}, {9167, 2976, 9170, 6101,
          6102}, {9155, 9154, 6257, 2976, 9168}, {9212, 3003, 9214, 6802, 
         6803}}]}]}, 
     {Hue[0.5253685895644856], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnHm8lnP6x59OnXPaznnOo3PqnNazP899VwzGlhSGzBiFFGLGmm0YZTdF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         "]], PolygonBox[CompressedData["
1:eJwtmndglUXWxl8k1CSQCzdAQEJIu/d9E8Re6LgWdOmKCFYQO0U6q6KgqFQF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         "]], 
        PolygonBox[{{9218, 9217, 9270, 3028, 6326}, {11634, 11633, 11092, 
         4285, 11643}, {9268, 3028, 9267, 6032, 6033}, {6249, 2968, 9150, 
         9136, 9137}, {6794, 6793, 9189, 2990, 9191}, {6325, 3027, 9265, 9217,
          9218}, {9137, 9136, 9145, 2965, 6248}, {9144, 2965, 9143, 6793, 
         6794}, {6081, 6080, 9149, 2968, 9151}, {11102, 3330, 11471, 11452, 
         11453}}]}]}, 
     {Hue[0.5757328052050126], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3l4ldW1xr8ckkDGk2BCEkjgZDgnyUHltiqI4DwwFLVYq2ivBRTHUgWU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         "]], PolygonBox[CompressedData["
1:eJwtmXd41kUSxxcSIKSQRFLeNyQhb5K35A0YVCR0EE9BjiIIEqInzYJKDyVY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         "]], PolygonBox[CompressedData["
1:eJwtj89KAnEUhQ9B2DQuXAQGFeJMj2CMvkZPYLNJSXSlS2NKVwWSK927cBsM
ufMfpBStchO+gGJKPkLfMLP4OPd3ub9z7k27levygaQEHMLnhbQ/kj7QTlLq
wk1KysPGkixT+qJ3z7sODfAN6REdnksuJm+nUuZSuoI2sy/g47fBd4CObWkE
ReZM5pf8WzDzDb9k2GTs0J9kWG+tMCvIbEZ5/RPp6Ux6hmNyDGjh5+A3x+8P
4tR39N7JmkGN2Sr0+PuKRwGv21RYl6Ibg1vX0Z0rdMIOU2jgv2b/Pvt71A+Q
BQc8/IyYlKP+B4+NNe4=
         "]]}]}, 
     {Hue[0.6260970208455394], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFWG1wlNUVvpolye5msynNZt/d7Gaz735kgy20AkJoGxCsGpBiGYtVECdE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         "]], PolygonBox[CompressedData["
1:eJwtmHl0lNUZxi9lSTIJSdSZJBOyzEwyQ0IAQVSgld1qcUM5FCxqkc0iLqCC
gMgmCrYHRRGX1qWKtp4WaBVUQBHPKaCCVFCs7ALBAqcquLWWWk1/T5/vj/fM
vXPf+953X770mElDb/5BCGFgqxDa8Ht65xBOA/KBAmBFXQj3F4bQtm0Ik1lX
NIQwrDiE7ewvzoZwOThDgG65ELoD1zaFMArYwH9vAF9XhTAnP4SnIL6rPISV
0FgMvdG81xwP4XxwBwEjuoRwJfC7GvgAd3RRCGdD/5Ks36qBxqWs/50O4Rvg
E+58Ckzhzm3AncAs4NkMb8ZC6A2N1dB6mzcfZ30H94/By9COIVwBLC9DNmBX
2rItaR3Cz9hvYb+E+9PZn8O+L/wOhd/b2Deyb07CX14IR8BZwFsrkHE58Ayw
DDiGftaXhPBwQQg3cf5SPbpEljO5/yF3G6HXH3oz4WkZvA1IofSY+dsLf0VA
K9aF3P+igreQIZ91a/5rC/5mzq9iXcWdnokQ2nP/0wLrdBT4C+BxGW8tRqZ1
HUI4URvCfs4PAJ+z7od8V0s/7UMYj72WJY2rN9ry1gH2/20XQjFvpKusY+k6
3RhCBphbyfvIfxD8Xdgv8N+lyLeFOy3IPo03bwcm8Nb1QCd00AicCXQDnkMf
38HrSpzuCHjnVofQsbVp9mRdDE8t0CuFx6e