% This Script was developed to calculate the nuclear volume using snake
% ROIs from the FIJI plugin jFilament. The idea is to reconstruct the
% volume, using the coordinates of each Z slice. Then using coordinate
% geometry you can caluclate the area of that polygon in an unbiased manner
% and then multiply each area by the Z height (.1625). Thus you can add all
% these slices together to get the volume. Then you can compare that with
% the theoretical nuclear volume, obtained using the maxium sized Z slice
% and predicting the Volume using V= 4/3pir^3. This was written by Michael
% S. Mauro, graduate student in Shirin Bahmanyar's Lab.


% YOUR FILES NEED TO START AT 001, IF IT DOESNT RENAME THE SNAKE FILES AND
% RECORD THEIR CORRESPONDING NUMBER.
New_Path = '/Users/michaelmauro/Desktop/Snake_Folder/'; % This will automatically set the right directory you need to specifcy this for the right folder.

%The first section here allows you to load the txt files. Due to naming
%issues in matlab (it doesnt like leading 0s) I split it up into files less
%than 10 and greater than 10. If you ever had more than 100 files, you
%would need to add another elseif statement and copy the code. 
filePattern = fullfile(New_Path, 'snakes*.txt'); % This will tell you how many files are in the folder with the certain type.
theFiles = dir(filePattern);
for i = 1:length(theFiles) 
  xyz =i; %This variable simply helps fill out the string to open the correct snake file. 
    if i<=9

%this allows you to read the text file and set up a matrix with the Z,
%point number, x coordinate, and y coordinate
fid = fopen((sprintf('snakes_00%d.txt',xyz)));
c1 = textscan(fid,'%f %f %f %f %f %f','HeaderLines', 11 );
All_information = cell2mat(c1([1 2 3 4]));
fclose(fid);
    Min_Z_section=min(All_information(:,1));
Max_Z_section=max(All_information(:,1));
count=Min_Z_section;
iter=1;
while count<=Max_Z_section

    all_matrix{iter,1}=All_information(All_information(:,1)==count,:);
    count=count+1;
    iter=iter+1;
end

    elseif i>=10
                                                  
fid = fopen((sprintf('snakes_0%d.txt',xyz)));
c1 = textscan(fid,'%f %f %f %f %f %f','HeaderLines', 11 );
All_information = cell2mat(c1([1 2 3 4]));
fclose(fid);
    Min_Z_section=min(All_information(:,1));
Max_Z_section=max(All_information(:,1));
count=Min_Z_section;
iter=1;
while count<=Max_Z_section

    all_matrix{iter,1}=All_information(All_information(:,1)==count,:);
    count=count+1;
    iter=iter+1;
end

    end
    
    n = size(all_matrix,1);

for ii =1:n
Temp_sub_matrix = all_matrix{ii};
Temp_X_coordinate = Temp_sub_matrix(:,3);
Temp_Y_coordinate = Temp_sub_matrix(:,4);

XY_coordinates_together = [Temp_X_coordinate Temp_Y_coordinate];

%This will give you the circumference of the polygon, it should match the
%value from jFilament and then calculates the area of the polygon based on
%the coordinate geometery.
N= size(XY_coordinates_together,1);
D= XY_coordinates_together(2:N,:)-XY_coordinates_together(1:(N-1),:);
D= sqrt(sum(D.^2,2)); % edge lenghts
P(ii)= sum(D); % perimeter
Area(ii)= polyarea(Temp_X_coordinate, Temp_Y_coordinate);


end;

All_perimeters = transpose(P);
All_Z_Section_Areas = transpose(Area);
All_Z_Section_Areas_Times_Thickness = All_Z_Section_Areas * .1625;
Volume_of_Nucleus = sum(All_Z_Section_Areas_Times_Thickness);
Calculated_Volume_of_Nucleus(i) = Volume_of_Nucleus * .1625^2;


%This section calculates the theoretical volume of the nucleus based on the
%mximum slice from the calculated 
Mid_Z_Slice = max(All_Z_Section_Areas_Times_Thickness)*.1625; 
Radius = sqrt( Mid_Z_Slice/pi);
Diameter(i) = Radius *2;
Theoretical_Volume_of_Nucleus(i) = 4/3 * pi * Radius^3; 
Time_Frame(i) = i;

%
% Theoretical_Volume_of_Nucleus*.1625
% .1625:
% Cell1{i} = All_perimeters;

%This next section will print the cicumference data for each slice.
fileID = fopen(sprintf('Circumferences for %d.txt',xyz),'w');
fprintf(fileID, '%s\n', 'circumference');
fprintf(fileID,' %5f\n',All_perimeters);
fclose(fileID);

    clearvars -except Calculated_Volume_of_Nucleus Theoretical_Volume_of_Nucleus Diameter Time_Frame% You need to clear the variables, but these essential ones so that way it runs through the loop smoothly. 

% all = Volumes;
end
% This section of code organizes all the key pieces of data and generates
% them into a table.
Calculated_Volume_of_Nucleus = transpose(Calculated_Volume_of_Nucleus);
Theoretical_Volume_of_Nucleus = transpose(Theoretical_Volume_of_Nucleus);
Diameter = transpose(Diameter);
Time_Frame = transpose(Time_Frame);

Volumes = [Time_Frame  Theoretical_Volume_of_Nucleus Calculated_Volume_of_Nucleus Diameter];
C = array2table(Volumes,'VariableNames',{'Time_Frame','Theoretical_volume','Calculated_Volume', 'Diameter_of_Nucleus'});
D = table2cell(C);
Compiled_data = [C.Properties.VariableNames;D];


%This section of code will write all the data to a single text file, not
%advised because its hard to copy and paste that into Excel.
%vvvv =transpose(Volumes);
% fileID = fopen('all data.txt','w');
% fprintf(fileID,'%6s %12s\n','Time_Frame','Theoretical_volume', 'Calculated_Volume_of_Nucleus','Diameter_of_Nucleus');
% fprintf(fileID,'%5f %5f %5f %5f\n',vvvv);
% fclose(fileID);


%This section of code will write the theoretical and calculated nuclear
%volumes to individual text files.
fileID = fopen('Theoretical Nuclear volume.txt','w');
fprintf(fileID,'%12s\n','Theoretical Nuclear volume');
fprintf(fileID,'%5f\n',Theoretical_Volume_of_Nucleus);
fclose(fileID);

fileID = fopen('Calculated Nuclear volume.txt','w');
fprintf(fileID,'%12s\n','Calculated Nuclear volume');
fprintf(fileID,'%5f\n',Calculated_Volume_of_Nucleus);
fclose(fileID);



%This section of code plots the theoretical and the calculated volumes.
Last_Measurement = ((max(Time_Frame)-1)*20);
Time_interval = transpose(0:20:Last_Measurement);

figure;
plot(Time_interval,Theoretical_Volume_of_Nucleus,'r', 'Marker','s',...
    'MarkerSize', 10, 'MarkerEdgeColor','red', 'LineStyle',':', 'LineWidth', 2);
hold;
plot(Time_interval,Calculated_Volume_of_Nucleus,'r','Marker','s',...
    'MarkerSize', 10, 'MarkerEdgeColor','red', 'MarkerFaceColor', 'red','LineWidth', 2);
xlim([0 (Last_Measurement+20)])
ylim([0 max(Calculated_Volume_of_Nucleus)+40])
ax = gca;
ax.FontSize = 16;
xlabel('Time (seconds) relative to measurement start', 'FontSize',18);
ylabel('Nucleus volume (microns^3)','FontSize',18);
title('Theoretical vs. Calculated Nuclear Volume ','FontSize',20); 
L= legend('Theoretical Data', 'Calculated Data','location','southeast',16);
set(L,'FontSize',16);
 hold off
% 
 %This section saves the graph as a matlab file and a png for use in
 %presentations.
fname = 'Theoretical vs Calculated Nuclear Volume';
saveas(gcf,fname);
print(gcf,'Theoretical vs Calculated Nuclear Volume.png','-dpng','-r300');


