%The purpose of this script is to go thru all the unlesioned (unoperated)
%experiments and make the figure of shock-driven learning based on this
%grouped data

clear all
close all
clc

%This is the name on your computer of the hard drive containing your data:
%drivename = 'E:/'; %on my computer, the E drive is the one with the data

condensed_data = 1; %1 if you're using the condensed data set, 0 if you're using the full data set
%save_condensed_data = 0; %1 if you want to save condensed data files

SH_or_WN_analy = 'SH'; %'SH' for analyzing shock experiments, 'WN' for white noise experiments.
        %There is a different script that specificaly analyzes all the white
        %noise experiments, but if you wanted to you could also do that with
        %this script

Analyze_dur_and_catch = 1; %THIS IS IMPORTANT:   If you want to analyze
%syllable duration and catch vs stim trials, you should set the above value
%to equal 1. However, this will add a lot of time to running the analysis,
%because you have to loop thru every single song file within every folder
%to pull out syllable onsets/offsets and whether a trigger occurred during
%this time. If you just want to quickly go thru and analyze syllable pitch,
%SET THIS VALUE EQUAL TO 0, that way you can avoid these extra loops and
%save a lot of time

listbirds = {'pk75pk76','bk1bk2','rd101wh36','bk23gy23','or101or102','bk67gy65','bl67bl69','pu89pu90','lb60pu60','or167or168','gr60rd55','gr129yw79v2','gr129yw79v1'};
%loop thru individual experiments:
Bird_data_Unlesioned = [];

%Select the folder containing the relevant .mat file
if condensed_data == 1
   pathname = uigetdir('Select the folder containing the condensed data .mat file');
   load([pathname, '/Bird_data_Unlesioned.mat'])
end

  
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%To calculate the error bars for the means (SEMs) and to determine 
%significance, we use the hierarchical bootstrap approach (see Saravanan et
%al., 2019 for detailed explanation).

%Here, we first produce a matrix of bootstrapped values from which
%we resample. Each sample gets its own Hz value of pitch from which the
%semitone values are generated. Therefore, this way explicitly includes the
%error in estimation of the mean during baseline. 1 SD of the bootstrapped
%sample gives an accurate estimate of the SEM of the dataset.

%First step, create a matrix of all your data and convert pitch values (in
%Hz) into semitone change from baseline:
clear P %P is the variable that contains the important data (semitone change values on each day of shock training for each experiment)
for mm = 1:12
    if mm < 12
        P(mm).birdname = listbirds{mm};
        if strcmp('down',Bird_data_Unlesioned{mm}.direction) == 1 %trying to drive pitch down
            P(mm).shift_direction = -1;
        else
            P(mm).shift_direction = 1;
        end

        P(mm).syls = Bird_data_Unlesioned{mm}.syl;
        P(mm).data_hz = Bird_data_Unlesioned{mm}.pitch';
        P(mm).mean_baseline_pitches = mean([Bird_data_Unlesioned{mm}.pitch{1}', Bird_data_Unlesioned{mm}.pitch{2}', Bird_data_Unlesioned{mm}.pitch{3}']');

        if strcmp('down',Bird_data_Unlesioned{mm}.direction) == 1 %trying to drive pitch down

            %Here's where I calculate the semitone pitch change,
            %normalized to the final day of baseline:
            for nn = 1:length(Bird_data_Unlesioned{mm}.pitch)
                P(mm).data(nn,1) = -12*log2((mean(Bird_data_Unlesioned{mm}.pitch{nn}))/mean([Bird_data_Unlesioned{mm}.pitch{3}']'))'; 
            end
        else %trying to drive pitch up

            %Here's where I calculate the semitone pitch change,
            %normalized to the final day of baseline:
            for nn = 1:length(Bird_data_Unlesioned{mm}.pitch)
                P(mm).data(nn,1) = 12*log2((mean(Bird_data_Unlesioned{mm}.pitch{nn}))/mean([Bird_data_Unlesioned{mm}.pitch{3}']'))';
            end
        end
    else %we're on the weird bird with 2 experiments, need to deal with this slightly differently
        P(mm).birdname = 'gr129yw79';
        P(mm).shift_direction = -1;
        P(mm).syls{1} = 'd'; P(mm).syls{2} = 'a';
        P(mm).data_hz = [Bird_data_Unlesioned{12}.pitch' Bird_data_Unlesioned{13}.pitch'];        
        %P(mm).mean_baseline_pitches = [mean([BB{12}.pitch{1}', BB{12}.pitch{2}', BB{12}.pitch{3}']), nanmean([BB{13}.pitch{1}', BB{13}.pitch{2}', BB{13}.pitch{3}'])];
        P(mm).mean_baseline_pitches = [mean(Bird_data_Unlesioned{12}.pitch{3}'),mean(Bird_data_Unlesioned{13}.pitch{3}')];
        
        for xx = 1:12
            tempsemis1{xx} = -12*log2(Bird_data_Unlesioned{12}.pitch{xx}/mean(Bird_data_Unlesioned{12}.pitch{3}));
            tempsemis2{xx} = 12*log2(Bird_data_Unlesioned{13}.pitch{xx}/mean(Bird_data_Unlesioned{13}.pitch{3}));
        end      
        P(mm).data = [tempsemis1', tempsemis2'];
        
    end  
end

%Bootstrapping part. At this point, you have P.data, which has the semitone
%change values for each day of each experiment
nboot = 10000; %No of times to resample for bootstrapping. Varun's paper recommends 10^4
num_days = 6; max_syls = numel(listbirds); birds_to_use = listbirds; 

bootstrapping_matrix = zeros(nboot,num_days,max_syls,numel(birds_to_use));
lesioned_birds = 1;
for i = 1:numel(birds_to_use)-1   %Over all birds
    for j = 1:size(P(i).syls,2) %Over number of syllables for each bird
        for k = 1:num_days      %Over all days
            if lesioned_birds == 1
                temp = P(i).data_hz{k,j}; %Remember to take actual Hz values for this step.
            else
                if i < 12
                    temp = P(i).data(k,j);
                else
                    temp = P(i).data{k,j};
                end
            end
            if isempty(temp)
                bootstrapping_matrix(:,k,j,i) = NaN;
                continue;
            end
            for n = 1:nboot     %For number of times to bootstrap
                bootstrapping_matrix(n,k,j,i) = datasample(temp,1);
            end
        end
        if lesioned_birds == 1
            for n = 1:nboot
                temp_mean = [];
                temp_mean = nanmean(bootstrapping_matrix(n,3,j,i)); %Normalize each row to the mean of the 3 baseline days of that row.
                bootstrapping_matrix(n,:,j,i) = P(i).shift_direction*12*log2(bootstrapping_matrix(n,:,j,i)/temp_mean);
            end
        end
    end
end

%Now do the actual bootstrapping: 
nboot2 = 300; %Only repeating 300 times since the actual variance is in the previous step.
bootstats1 = zeros(nboot2,num_days);
bootstats2 = zeros(nboot2,num_days);
bootstats3 = zeros(nboot2,num_days);

unlesioned_birds = 1:12;

for n = 1:nboot2
    
    temp_UL_birds = datasample(unlesioned_birds,length(unlesioned_birds));
    temp_data = [];
    for t = 1:length(temp_UL_birds)
        temp_syls = datasample(1:size(P(temp_UL_birds(t)).data,2),size(P(temp_UL_birds(t)).data,2));
        for s = 1:length(temp_syls)
            temp_pulls = datasample(1:nboot,nboot);
            temp_data = vertcat(temp_data,bootstrapping_matrix(temp_pulls,:,temp_syls(s),temp_UL_birds(t)));
        end
    end
    bootstats1(n,:) = nanmean(temp_data,1);
end


% for n = 1:nboot2
%     
%     temp_neg_birds = datasample(neg_shift_birds,length(neg_shift_birds));
%     temp_data = [];
%     for t = 1:length(temp_neg_birds)
%         temp_syls = datasample(1:size(P(temp_neg_birds(t)).data,2),size(P(temp_neg_birds(t)).data,2));
%         for s = 1:length(temp_syls)
%             temp_pulls = datasample(1:nboot,nboot);
%             temp_data = vertcat(temp_data,bootstrapping_matrix(temp_pulls,:,temp_syls(s),temp_neg_birds(t)));
%         end
%     end
%     bootstats1(n,:) = nanmean(temp_data,1);
%     
%     temp_pos_birds = datasample(pos_shift_birds,length(pos_shift_birds));
%     temp_data = [];
%     for t = 1:length(temp_pos_birds)
%         temp_syls = datasample(1:size(P(temp_pos_birds(t)).data,2),size(P(temp_pos_birds(t)).data,2));
%         for s = 1:length(temp_syls)
%             temp_pulls = datasample(1:nboot,nboot);
%             temp_data = vertcat(temp_data,bootstrapping_matrix(temp_pulls,:,temp_syls(s),temp_pos_birds(t)));
%         end
%     end
%     bootstats2(n,:) = nanmean(temp_data,1);
%     
%     if lesioned_birds
%         temp_no_birds = datasample(no_shift_birds,length(no_shift_birds));
%         temp_data = [];
%         for t = 1:length(temp_no_birds)
%             temp_syls = datasample(1:size(P(temp_no_birds(t)).data,2),size(P(temp_no_birds(t)).data,2));
%             for s = 1:length(temp_syls)
%                 temp_pulls = datasample(1:nboot,nboot);
%                 temp_data = vertcat(temp_data,bootstrapping_matrix(temp_pulls,:,temp_syls(s),temp_no_birds(t)));
%             end
%         end
%         bootstats3(n,:) = nanmean(temp_data,1);
%     end
% end

std_UL_pitch_shift = nanstd(bootstats1,0,1);
% std_pos_pitch_shift = nanstd(bootstats2,0,1);
% if lesioned_birds
%     std_no_pitch_shift = nanstd(bootstats3,0,1);
% end

for pp = 1:6
    pboot(pp) = numel(find(bootstats1(:,pp) >= 0))/(numel(bootstats1(:,pp)));
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
clear S1
for pp = 1:length(listbirds)
    BLall = []; BL3 = []; thisBL = []; 
    BLall = nanmean( [Bird_data_Unlesioned{pp}.pitch{1}' Bird_data_Unlesioned{pp}.pitch{2}' Bird_data_Unlesioned{pp}.pitch{3}']);
    BL3 = mean(Bird_data_Unlesioned{pp}.pitch{3});
    for qq = 1:6
        if strcmp(Bird_data_Unlesioned{pp}.direction,'up') %driving pitch up
            S1(pp,qq) = 12* log2(mean(Bird_data_Unlesioned{pp}.pitch{(qq)})/BL3);
        else
            S1(pp,qq) = -12* log2(mean(Bird_data_Unlesioned{pp}.pitch{(qq)})/BL3);
        end
    end
end

if strcmp(SH_or_WN_analy,'SH') == 1
    h1 = plot([0 nanmean(S1(:,4:end))],'-o'); hold on;
    h3 = errorbar([0 nanmean(S1(:,4:end))],[0 std_UL_pitch_shift(4:end)],'k'); hold on;
    set(gca,'XTick',(1:4),'XTickLabel',{'0','1','2','3'});
    h1.LineWidth = 3; h3.LineWidth = 3;
    ylim([-0.05 0.35]);
    xlabel('Days since feedback onset');
    ylabel('Pitch difference from baseline (semitones)');
    set(gcf,'color','white');
else
    h1 = plot([0 nanmean(S1(:,4:end))],'k'); hold on;
    h3 = errorbar([0 nanmean(S1(:,4:end))],[0 std_UL_pitch_shift(4:end)],'k'); hold on;
    set(gca,'XTick',(1:4),'XTickLabel',{'0','1','2','3'});
    h1.LineWidth = 3; h3.LineWidth = 3;
    ylim([-0.05 0.8]);
    xlabel('Days since feedback onset');
    ylabel('Pitch difference from baseline (semitones)');
    set(gcf,'color','white');
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
clear Sup Sdown
upcount = 0; downcount = 0;
for pp = 1:length(listbirds)
    BLall = []; BL3 = []; thisBL = [];
    BLall = nanmean( [Bird_data_Unlesioned{pp}.pitch{1}' Bird_data_Unlesioned{pp}.pitch{2}' Bird_data_Unlesioned{pp}.pitch{3}']);
    BL3 = mean(Bird_data_Unlesioned{pp}.pitch{3});
    if strcmp(Bird_data_Unlesioned{pp}.direction,'up') %driving pitch up
        upcount = upcount + 1;
        for qq = 1:6
            Sup(upcount,qq) = 12* log2(mean(Bird_data_Unlesioned{pp}.pitch{(qq)})/BL3);
            tempsemis = [];
            tempsemis = 12* log2((Bird_data_Unlesioned{pp}.pitch{(qq)})/BL3);
            Sup_SEM(upcount,qq) = std(tempsemis)/sqrt(numel(tempsemis));
        end
    else
        downcount = downcount + 1;
        for qq = 1:6
            Sdown(downcount,qq) = 12* log2(mean(Bird_data_Unlesioned{pp}.pitch{(qq)})/BL3);
            tempsemis = [];
            tempsemis = -12* log2((Bird_data_Unlesioned{pp}.pitch{(qq)})/BL3);
            Sdown_SEM(downcount,qq) = std(tempsemis)/sqrt(numel(tempsemis));
        end
    end
end

figure(12032)
for ii = 1:length(Sup)
    h1 = plot(Sup(ii,3:end),'-o','Markersize',5); hold on;
    h1.LineWidth = 2; hold on;
    h1.Color = [255/255 128/255 0/255]; hold on;
    set(h1, 'MarkerFaceColor', get(h1,'Color'));
    h2 = errorbar((2:4),Sup(ii,4:end),Sup_SEM(ii,4:end),'r'); hold on;
    h2.LineWidth = 2; hold on;
    h2.Color = [255/255 128/255 0/255]; hold on;
end
hold on
for ii = 1:length(Sdown)
    h2 = plot(Sdown(ii,3:end),'-o'); hold on;
    h2.LineWidth = 2; hold on;
    h2.Color = [128/255 128/255 128/255]; hold on;
    set(h2, 'MarkerFaceColor', get(h2,'Color'));
    h2 = errorbar((2:4),Sdown(ii,4:end),Sdown_SEM(ii,4:end)); hold on;
    h2.LineWidth = 2; hold on;
    h2.Color = [128/255 128/255 128/255]; hold on;
end
hold on
legend('Up','Down','Location','Northwest');
%xtick([1 2 3 4]);
%xticklabels({'0', '1', '2', '3'});
ylim([-1 0.5]);
xlabel('Days since feedback onset');
ylabel('Pitch change from baseline (semitones)');
set(gcf,'color','white');
set(gca,'box','off')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% figure(432293)
% for ii = 1:length(Sup)
%     h1 = plot(((.84+.02*ii):(3.84+.02*ii)),Sup(ii,3:end),'r'), hold on;
%     h1.LineWidth = 2, hold on;
%     h2 = errorbar(((1.84+.02*ii):3.84+.02*ii),Sup(ii,4:end),Sup_SEM(ii,4:end),'r'), hold on;
%     h2.LineWidth = 2, hold on;
% end
% hold on
% for ii = 1:length(Sdown)
%     h1 = plot(((1+.02*ii):(4+.02*ii)),Sdown(ii,3:end),'b'), hold on;
%     h1.LineWidth = 2, hold on;
%     h2 = errorbar(((2+.02*ii):4+.02*ii),Sdown(ii,4:end),Sdown_SEM(ii,4:end),'b'), hold on;
%     h2.LineWidth = 2, hold on;
% end
% %legend('Up','Down');
% xticks([1 2 3 4]);
% xticklabels({'0', '1', '2', '3'});
% xlabel('Days since feedback onset');
% ylabel('Pitch change from baseline (semitones)');
% set(gcf,'color','white');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
% 
% figure(194329)
% normpitches = []; meancatches = []; SEMcatches = [];
% for ii = 1:length(listbirds)
%     if ii == 2 %this bird has issues with catch trials aligning with weighted avg
%     else
%     catchtemp = []; stimtemp = []; normcatches = []; semitonecatches = [];
%     for jj = 1:3
%         catchtemp = [catchtemp, (Bird_data_Unlesioned{ii}.pitch{3+jj}(find(Bird_data_Unlesioned{ii}.catchtrials{3+jj}')))'];
%         stimtemp = [stimtemp, (Bird_data_Unlesioned{ii}.pitch{3+jj}(find(Bird_data_Unlesioned{ii}.stimtrials{3+jj}')))'];
%         
%         stimmean = []; 
%         stimmean = mean((Bird_data_Unlesioned{ii}.pitch{3+jj}(find(Bird_data_Unlesioned{ii}.stimtrials{3+jj}))));
%         normcatches = [normcatches, Bird_data_Unlesioned{ii}.pitch{3+jj}(find(Bird_data_Unlesioned{ii}.catchtrials{3+jj}))'/stimmean];
%         semitonecatches = [semitonecatches, 12*log2(Bird_data_Unlesioned{ii}.pitch{3+jj}(find(Bird_data_Unlesioned{ii}.catchtrials{3+jj}))'/stimmean)];
%     end
%     end
%     normpitches{ii} = normcatches;
%     semitonepitches{ii} = semitonecatches;
%     meancatches(ii) = mean(normcatches);
%     SEMcatches(ii) = std(normcatches)/sqrt(numel(normcatches));
%     
%     meansemi(ii) = mean(semitonecatches);
%     SEMsemi(ii) = std(semitonecatches)/sqrt(numel(semitonecatches));
% end
% 
% plot(meancatches), hold on;
% errorbar(meancatches,SEMcatches,'.'), hold on;

% plot(meansemi), hold on;
% errorbar(meansemi,SEMsemi,'.'), hold on;





