%The purpose of this script is to go thru all the data from birds who
%underwent LMAN lesions and LMAN sham operations, analyze the CV of
%syllable pitch on the final day of baseline recording pre- vs postlesion
%and pre- vs postsham.

clear all
close all
clc

%First, define the bird names, hard drive names, folders with the data
%(just baseline days), and the names of the labelled syllables (both target
%syllables and non-target syls)

condensed_data = 1; %1 if you're using the condensed data set, 0 if you're using the full data set

pathname = uigetdir('Select the folder containing the condensed data .mat file');
load([pathname, '/CV_6OHDA_data.mat'])

preL = []; postL = []; preCVcount = 0; postCVcount = 0; PreSH = []; postSH = []; preSHCV = [];

for aa = 1:length(CV_6OHDA_data.PreLesion)
    for bb = 1:length(CV_6OHDA_data.PreLesion{aa}.syl)
        thispitch = [];
        thispitch = CV_6OHDA_data.PreLesion{aa}.syl{bb};
        preCVcount = preCVcount+1;
        preLCV(preCVcount) = std(thispitch)/mean(thispitch)*100; %this is where you calculate CV
    end
    for bb = 1:length(CV_6OHDA_data.PostLesion{aa}.syl)
        thispitch = [];
        thispitch = CV_6OHDA_data.PostLesion{aa}.syl{bb};
        postCVcount = postCVcount+1;
        postLCV(postCVcount) = std(thispitch)/mean(thispitch)*100; %this is where you calculate CV
    end
end

preSHCVcount = 0; postSHCVcount = 0;
for aa = 1:length(CV_6OHDA_data.PreSham)
    for bb = 1:length(CV_6OHDA_data.PreSham{aa}.syl)
        thispitch = [];
        thispitch = CV_6OHDA_data.PreSham{aa}.syl{bb};
        preSHCVcount = preSHCVcount+1;
        preSHCV(preSHCVcount) = std(thispitch)/mean(thispitch)*100; %this is where you calculate CV
    end
    for bb = 1:length(CV_6OHDA_data.PostSham{aa}.syl)
        thispitch = [];
        thispitch = CV_6OHDA_data.PostSham{aa}.syl{bb};
        postSHCVcount = postSHCVcount+1;
        postSHCV(postSHCVcount) = std(thispitch)/mean(thispitch)*100; %this is where you calculate CV
    end
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Make plots:
%%
%Make scatter plot (each dot represents one syllable) of pre-vs post, unity
%line
figure(1)
scatter(preLCV, postLCV,100,[153/255 85/255.8 255/255],'filled'), hold on;
scatter(preSHCV, postSHCV,100,[42/255 255/255 42/255],'filled'), hold on;
ylim([0.5 3.5]);
plot([0.5:3.5],[0.5:3.5],'k'), hold on;
%legend('6OHDA lesion','Sham','Location','Northwest');
set(gcf,'color','white');

%%
%Make scatter plot (each dot represents one syllable) of pre divided by
%post:
%figure(2)
%scatter(ones(1,length(preLCV)),postLCV./preLCV,'b'), hold on;
%scatter(2*ones(1,length(preSHCV)),postSHCV./preSHCV,'r'), hold on;
%xlim([0.5, 2.5]);
%ylim([0, 1.5]);
%set(gcf,'color','white');

%Make scatter plot (each dot represents one syllable) of pre minus post
%%
figure(3)
h1 = scatter(ones(1,length(preLCV)),postLCV - preLCV,50,[102/255 0/255 128/255]), hold on;
h2 = scatter(2*ones(1,length(preSHCV)),postSHCV - preSHCV,50,[42/255 255/255 42/255]), hold on;
xlim([0.5, 2.5]);
ylim([-2.5, 1]);
set(gcf,'color','white');
ylabel('postL CV - preL CV');
xlabel('Lesion vs Sham');
set(gcf,'color','white');


%If you want to run stats:
[h1,p1] = ttest(preLCV,postLCV);
[h2,p2] = ttest2(preLCV,postLCV);

[h3,p3] = ttest(preSHCV,postSHCV);
[h4,p4] = ttest2(preSHCV,postSHCV);

[h5,p5] = ttest2((postLCV./preLCV),(postSHCV./preSHCV));
[h6,p6] = kstest2((postLCV./preLCV),(postSHCV./preSHCV));

[h7,p7] = ttest2((postLCV - preLCV),(postSHCV - preSHCV));
[h8,p8] = kstest2((postLCV - preLCV),(postSHCV - preSHCV));


% cdfplot(PreL{2}.syl{1}), hold on
% cdfplot(PostL{2}.syl{1})











