%The purpose of this script is to go thru one individual shock experiment
%from pk75pk76 to make the example figures for Fig 2 (scatter plot showing
%learning, example spectrograms, etc

clear all
close all
clc

condensed_data =1; %0 for doing full analysis from entire data set, 1 for
%doing analysis based on the condensed data set

%This is the name on your computer of the hard drive containing your data:
pathroot = 'E:/'; %on my computer, the E drive is the one with the data

%TO MAKE FIGURE 2 B EXAMPLE SPECTROGRAMS:
cd([pathroot, 'Shock Unlesioned birds/pk75pk76/Analysis/10to12/Baseline_equal_mean']);
%run evsonganaly, the labeled syllable is the one I used that equals the mean

cd([pathroot, 'Shock Unlesioned birds/pk75pk76/Analysis/10to12/Baseline_minus_1_SD']);
%run evsonganaly, the labeled syllable is the one I used that equals the mean
%minus 1 SD

cd([pathroot, 'Shock Unlesioned birds/pk75pk76/Analysis/10to12/Baseline_plus_1_SD']);
%run evsonganaly, the labeled syllable is the one I used that equals the mean
%plus 1 SD

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%TO MAKE FIGURE 2 B histogram inset, FIG 2 C, and FIG 2 D:

%First, define the bird's name, the target syllable, and the folder
%directories:
this_bird   = 'pk75pk76';
this_syll   = 'y';

%Now, loop thru the folders of interest, load the file containing the pitch
%info, and save the pitches of the target syllable

if condensed_data == 1
    path = [];
    path = [pathroot, 'Condensed data/Unlesioned/pk75pk76/Shock'];
    cd(path);
    these_files = [];
    these_files = dir(['*_syl_', this_syll, '.mat']);
    for aa = 1:length(these_files)
        load(these_files(aa).name);
        pitches{aa} = weighted_avg;
        pitchmean(aa) = mean(weighted_avg);
        pitchsem(aa) =  std(weighted_avg)/sqrt(numel(weighted_avg));
    end
else
    
    folder{1} = [pathroot 'Shock Unlesioned birds/pk75pk76/Analysis/10to12/050917_redo_SHBL1'];
    folder{2} = [pathroot 'Shock Unlesioned birds/pk75pk76/Analysis/10to12/051017_redo_SHBL2'];
    folder{3} = [pathroot 'Shock Unlesioned birds/pk75pk76/Analysis/10to12/051117_redo_SHBL3'];
    folder{4} = [pathroot 'Shock Unlesioned birds/pk75pk76/Analysis/10to12/051217_redo_SHSH1'];
    folder{5} = [pathroot 'Shock Unlesioned birds/pk75pk76/Analysis/10to12/051317_redo_SHSH2'];
    folder{6} = [pathroot 'Shock Unlesioned birds/pk75pk76/Analysis/10to12/051417_redo_SHSH3'];
    folder{7} = [pathroot 'Shock Unlesioned birds/pk75pk76/Analysis/10to12/051517_redo_SHWO1'];
    folder{8} = [pathroot 'Shock Unlesioned birds/pk75pk76/Analysis/10to12/051617_redo_SHWO2'];
    folder{9} = [pathroot 'Shock Unlesioned birds/pk75pk76/Analysis/10to12/051717_redo_SHWO3'];
    folder{10} = [pathroot 'Shock Unlesioned birds/pk75pk76/Analysis/10to12/051817_redo_SHWO4'];
    folder{11} = [pathroot 'Shock Unlesioned birds/pk75pk76/Analysis/10to12/051917_redo_SHWO5'];
    folder{12} = [pathroot 'Shock Unlesioned birds/pk75pk76/Analysis/10to12/052017_redo_SHWO6'];
    
    for aa = 1:length(folder)
        cd(folder{aa});
        this_file = dir(['*_syl_', this_syll, '.mat']);
        load(this_file.name);
        pitches{aa} = weighted_avg;
        pitchmean(aa) = mean(weighted_avg);
        pitchsem(aa) =  std(weighted_avg)/sqrt(numel(weighted_avg));
    end
end

%Here's where I make the histogram figure (inset of Fig 2 B)
figure(1)
data = pitches{3}; %// example data
num_bars = 10; %// specify number of bars
[n, x] = hist(data,num_bars); %// use two-output version of hist to get values
n_normalized = n/numel(data)/(x(2)-x(1)); %// normalize to unit area
%bar(x, n_normalized, 1); %// plot histogram (with unit-width bars)
%hold on
plot(x, n_normalized, 'r'); %// plot line, in red (or change color)
plot(x, n/numel(data), 'r'); %// plot line, in red (or change color)
set(gcf,'color','white');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%Now, make the scatter plot figure (Fig 2 C):
figure(2)

spacing = 150;

temppitches = [];
temppitches = pitches{1};
xs = [];
xs = 1:numel(temppitches);
holdxval = max(xs);
scatter(xs,temppitches,'filled','k'), hold on;

temppitches = [];
temppitches = pitches{2};
xs = [];
xs = holdxval+spacing:holdxval+spacing+numel(temppitches)-1;
holdxval = max(xs);
scatter(xs,temppitches,'filled','k')

temppitches = [];
temppitches = pitches{3};
xs = [];
xs = holdxval+spacing:holdxval+spacing+numel(temppitches)-1;
holdxval = max(xs);
scatter(xs,temppitches,'filled','k')

temppitches = [];
temppitches = pitches{4};
xs = [];
xs = holdxval+spacing:holdxval+spacing+numel(temppitches)-1;
holdxval = max(xs);
scatter(xs,temppitches,'filled','k')

temppitches = [];
temppitches = pitches{5};
xs = [];
xs = holdxval+spacing:holdxval+spacing+numel(temppitches)-1;
holdxval = max(xs);
scatter(xs,temppitches,'filled','k')

temppitches = [];
temppitches = pitches{6};
xs = [];
xs = holdxval+spacing:holdxval+spacing+numel(temppitches)-1;
holdxval = max(xs);
scatter(xs,temppitches,'filled','k')

temppitches = [];
temppitches = pitches{7};
xs = [];
xs = holdxval+spacing:holdxval+spacing+numel(temppitches)-1;
holdxval = max(xs);
scatter(xs,temppitches,'filled','k')

temppitches = [];
temppitches = pitches{8};
xs = [];
xs = holdxval+spacing:holdxval+spacing+numel(temppitches)-1;
holdxval = max(xs);
scatter(xs,temppitches,'filled','k')

temppitches = [];
temppitches = pitches{9};
xs = [];
xs = holdxval+spacing:holdxval+spacing+numel(temppitches)-1;
holdxval = max(xs);
scatter(xs,temppitches,'filled','k')

temppitches = [];
temppitches = pitches{10};
xs = [];
xs = holdxval+spacing:holdxval+spacing+numel(temppitches)-1;
holdxval = max(xs);
scatter(xs,temppitches,'filled','k')

temppitches = [];
temppitches = pitches{11};
xs = [];
xs = holdxval+spacing:holdxval+spacing+numel(temppitches)-1;
holdxval = max(xs);
scatter(xs,temppitches,'filled','k')

temppitches = [];
temppitches = pitches{12};
xs = [];
xs = holdxval+spacing:holdxval+spacing+numel(temppitches)-1;
holdxval = max(xs);
scatter(xs,temppitches,'filled','k')

xlabel('arbitrary here, I set the x axis to days in inkscape');
ylabel('Pitch (Hz)');
ylim([1980 2230])
set(gcf,'color','white');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%Now, make the CDFplot figure (Fig 2 D)

%PLOT 3: CDFplot of pitches BL3 vs SH3 vs WO6
figure(3);
h1 = []; h2 = []; h3 = [];
h1 = cdfplot(pitches{3}); hold on; %plot the data from end of baseline
set(h1,'Color','b'), hold on;
h2 = cdfplot(pitches{6}); hold on; %plot the data from end of shock training
set(h2,'Color','r'), hold on;
h3 = cdfplot(pitches{end}); hold on;  %plot the data from end of washout
set(h3,'Color','g'), hold on;
legend('BL3','SH3','WOend');
xlabel('Pitch (Hz)');
set(gcf,'color','white');

%To run statistical tests (kstest2 is a 2 sample KS test)
[H,p] = kstest2(pitches{3},pitches{6}); %to test for significance between baseline and end of shock
[H2,p2] = kstest2(pitches{3},pitches{end}); %to test for significance between baseline and end of washout

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
s = -12* log2(mean(pitches{5})/mean(pitches{3}))




