%The purpose of this script is to go thru all the unlesioned (unoperated)
%experiments and make the figure of shock-driven learning based on this
%grouped data

clear all
close all
clc

%This is the name on your computer of the hard drive containing your data:
drivename = 'E:/'; %on my computer, the E drive is the one with the data

condensed_data = 1; %1 if you're using the condensed data set, 0 if you're using the full data set
save_condensed_data = 0; %1 if you want to save condensed data files

SH_or_WN_analy = 'SH'; %'SH' for analyzing shock experiments, 'WN' for white noise experiments.
        %There is a different script that specificaly analyzes all the white
        %noise experiments, but if you wanted to you could also do that with
        %this script

Analyze_dur_and_catch = 0; %THIS IS IMPORTANT:   If you want to analyze
%syllable duration and catch vs stim trials, you should set the above value
%to equal 1. However, this will add a lot of time to running the analysis,
%because you have to loop thru every single song file within every folder
%to pull out syllable onsets/offsets and whether a trigger occurred during
%this time. If you just want to quickly go thru and analyze syllable pitch,
%SET THIS VALUE EQUAL TO 0, that way you can avoid these extra loops and
%save a lot of time

listbirds = {'bk1bk2','rd101wh36','bk23gy23','or101or102','bk67gy65','bl67bl69','pu89pu90','lb60pu60','or167or168','gr60rd55','gr129yw79v2','gr129yw79v1'};
%loop thru individual experiments:
Bird_data_Unlesioned = [];

if condensed_data == 1
    path = [drivename, 'Condensed data/Unlesioned'];
    cd(path);
    if strcmp(SH_or_WN_analy,'SH') == 1 %load shock data
        load('Bird_data_Unlesioned_Abi_CDFplots.mat');
        Bird_data_Unlesioned = Bird_data_Unlesioned_Abi_CDFplots;
    else %load white noise data
        load('Bird_data_Unlesioned_WHITENOISE.mat');
    end
else
    for aa = 1:12 %can't just use length of listbirds because there are multiple experiments in one bird
        
        birdname = listbirds{aa};
        
        SHFOLDERS = []; WNFOLDERS = []; INFO = [];
        [SHFOLDERS, WNFOLDERS, INFO] = Define_folders_for_grouped_analy(birdname, drivename);
        
        this_syll = INFO.targetsyl; %Target syllable
        SH_threshold = INFO.SHthreshold; %Pitch threshold for targeting
        WN_threshold = INFO.WNthreshold; %Pitch threshold for targeting
        direction = INFO.direction; %Did we try to drive the pitch up or down
        
        FF = []; VOL = []; ENT = []; DUR = []; Nsyl = []; pitchM = []; volM = [];
        entM = []; durM = []; pitchS = []; volS = []; entS =[]; durS = [];
        stimpitches = []; catchpitches = []; Precision = []; Sensitivity = [];
        
        theseFolders = []; thisthreshold = [];
        if strcmp(SH_or_WN_analy,'SH') == 1
            theseFolders = SHFOLDERS;
            thisthreshold = SH_threshold;
            thesedays = {'BL','BL','SH','SH','SH'};
        else
            theseFolders = WNFOLDERS;
            thisthreshold = WN_threshold;
            thesedays = {'BL','BL','BL','WN','WN','WN','WO','WO','WO','WO','WO','WO'};
        end
                
        Bird_data_Unlesioned{aa}.direction = direction;
        Bird_data_Unlesioned{aa}.syl = this_syll;
        Bird_data_Unlesioned{aa}.birdname = birdname;
        
        %Now I have the list of folders with data for one individual
        %experiment. Now loop thru each folder and pull out the data for
        %the target syllable:
        clear iii
        for iii = 1:length(theseFolders)
            try
                cd(theseFolders{iii});
                this_file = [];
                this_file = dir(['*_syl_', this_syll, '.mat']);
                load(this_file.name);
                
                Bird_data_Unlesioned{aa}.pitch{iii} = weighted_avg;
                Bird_data_Unlesioned{aa}.volume{iii} = amp_at_pitchquant;
                Bird_data_Unlesioned{aa}.spectentropy{iii} = spect_entropy;
                Bird_data_Unlesioned{aa}.wienentropy{iii} = wiener_entropy;
                Bird_data_Unlesioned{aa}.foldername{iii} = theseFolders{iii};
                %Bird_data_Unlesioned{aa}.experimental_day{iii} = thesedays{iii};
                
                if Analyze_dur_and_catch == 1 %Do the analysis of duration and catch vs stim trials
                    
                    notmatfiles = []; cbinfile = []; tsylinstances = []; counter = 0;
                    recfilenames = []; catchcount = []; stimcount = []; syltrigcount = [];
                    sylcount = [];
                    
                    notmatfiles = dir('*.not.mat');
                    recfilenames = dir('*.rec');
                    
                    for bb = 1:length(notmatfiles)
                        cbinfile = load(notmatfiles(bb).name);
                        recfile = readrecf(recfilenames(bb).name);
                        tsylinstances = find(cbinfile.labels == this_syll); %tsylinstances is important, it's
                        %the index of when I labeled the target syllable
                        if isempty(tsylinstances) == 0 %an instance of the target syllable occurs in this cbin file
                            for cc = 1:length(tsylinstances) %loop thru instances of the target syllable
                                counter = counter + 1;
                                sylcount(counter) = counter; %syllable number index
                                catchcount(counter) = 0; %set this to 0 for now, change to 1 later if a catch trial occurred
                                stimcount(counter) = 0; %set this to 0 for now, change to 1 later if a stim trial occurred
                                syl_start = []; syl_stop = [];
                                syl_start = cbinfile.onsets(tsylinstances(cc));
                                syl_stop  = cbinfile.offsets(tsylinstances(cc));
                                syl_DUR(counter) = syl_stop - syl_start; %this will calculate syllable duration, in ms
                                
                                if isempty(recfile.ttimes) == 0 %check to see if any triggers occurred
                                    for dd = 1:length(recfile.ttimes) %loop thru occurrences of triggers
                                        if recfile.ttimes(dd) > syl_start && recfile.ttimes(dd) < syl_stop == 1 %a trigger occurred during this rendition of the targey syl
                                            syltrigcount(counter) = 1; %this syl had a trigger occur
                                            if recfile.catch(dd) == 1 %this trigger was a catch
                                                catchcount(counter) = 1;
                                                %stimcount(counter) = 0;
                                            else %this trigger was for real (not a catch)
                                                %catchcount(counter) = 0;
                                                stimcount(counter) = 1;
                                            end
                                        else %no trigger occurred on this rendition of the target syllable
                                            syltrigcount(counter) = 0; %this syl did NOT have trigger occur
                                        end
                                    end
                                else %no trigger occurred within this cbin file
                                    syltrigcount(counter) = 0; %this syl did NOT have trigger occur
                                end
                            end %stop looping thru syls within this cbin file
                        else %no instances of the target syl in this cbin file
                        end
                    end %stop looping thru cbin files
                    
                    Bird_data_Unlesioned{aa}.syl_duration{iii} = syl_DUR;
                    Bird_data_Unlesioned{aa}.syltrigs{iii} = syltrigcount;
                    Bird_data_Unlesioned{aa}.catchtrials{iii} = catchcount;
                    Bird_data_Unlesioned{aa}.stimtrials{iii} = stimcount;
                    
                    if isequal(numel(catchcount),numel(weighted_avg))
                    else %mismatch occurred between number in weighted_avg and number of sylcount!
                        disp(['Mismatch between catch trial number and syl renditions, experiment number ', num2str(aa), ', birdname is ' birdname ', folder number ' num2str(iii)]);
                        %keyboard
                        
                        %                     if aa == 2
                        %                        Bird_data{aa}.catchtrials{iii}(end) = [];
                        %                        Bird_data{aa}.stimtrials{iii}(end) = [];
                        %                     else
                        %                     end
                    end
                else %just skip doing the analysis of duration and catch vs stim
                end
                
            catch
                Bird_data_Unlesioned{aa}.pitch{iii} = NaN;
                %Bird_data{aa}.syl{iii} = NaN;
                %Bird_data{aa}.direction{iii} = NaN;
                Bird_data_Unlesioned{aa}.duration{iii} = NaN;
                Bird_data_Unlesioned{aa}.volume{iii} = NaN;
                Bird_data_Unlesioned{aa}.spectentropy{iii} = NaN;
                Bird_data_Unlesioned{aa}.wienentropy{iii} = NaN;
                
                if Analyze_dur_and_catch == 1 %Do the analysis of duration and catch vs stim trials
                    Bird_data_Unlesioned{aa}.syl_duration{iii} = NaN;
                    Bird_data_Unlesioned{aa}.syltrigs{iii} = NaN;
                    Bird_data_Unlesioned{aa}.catchtrials{iii} = NaN;
                    Bird_data_Unlesioned{aa}.stimtrials{iii} = NaN;
                else
                end
                
                disp(['Could not analyze experiment number ', num2str(aa), ', birdname is ' birdname ', folder number ' num2str(iii)]);
                
            end
        end
    end
    
    if save_condensed_data == 1
        Bird_data_Unlesioned_Abi_CDFplots = Bird_data_Unlesioned;
        path = [drivename, 'Condensed data/Unlesioned'];
        cd(path);
        if strcmp(SH_or_WN_analy,'SH') == 1
            save('Bird_data_Unlesioned_Abi_CDFplots','Bird_data_Unlesioned_Abi_CDFplots');
        else
            save('Bird_data_Unlesioned_WHITENOISE','Bird_data_Unlesioned');
        end
    end
    
end

%%

listofexp = [1:12];

y = datasample(listofexp,6, 'Replace', false);

%y = [5     8     4     3    11    2]
%y = sort(y)

for ii = 1:6
    i = y(ii);
    pitchBL = [];
    pitchBLall = [];
    pitchSH = [];
    pitchWO = [];

    Bird_data_Unlesioned{i};

    Bird_data_Unlesioned{i}.pitch

    pitchBL = Bird_data_Unlesioned{i}.pitch{3};
    pitchBLall = [Bird_data_Unlesioned{i}.pitch{3}', Bird_data_Unlesioned{i}.pitch{2}', Bird_data_Unlesioned{i}.pitch{1}'];
    pitchSH = Bird_data_Unlesioned{i}.pitch{6};

    if ~isnan(Bird_data_Unlesioned{i}.pitch{12}) == 1
        pitchWO = Bird_data_Unlesioned{i}.pitch{12};
    elseif ~isnan(Bird_data_Unlesioned{i}.pitch{11}) == 1
        pitchWO = Bird_data_Unlesioned{i}.pitch{11};
    elseif ~isnan(Bird_data_Unlesioned{i}.pitch{10}) == 1
        pitchWO = Bird_data_Unlesioned{i}.pitch{10};
    elseif ~isnan(Bird_data_Unlesioned{i}.pitch{9}) == 1
        pitchWO = Bird_data_Unlesioned{i}.pitch{9};
    end


    %PLOT 3: CDFplot of pitches BL3 vs SH3 vs WO6
    subplot(3,2,ii)
    h1 = []; h2 = []; h3 = [];
    h1 = cdfplot(pitchBLall); hold on; %plot the data from end of baseline
    set(h1,'Color','b'), hold on;
    h2 = cdfplot(pitchSH); hold on; %plot the data from end of shock training
    set(h2,'Color','r'), hold on;
    h3 = cdfplot(pitchWO); hold on;  %plot the data from end of washout
    set(h3,'Color','g'), hold on;
    legend('BLall','SH3','WOend');
    xlabel('Pitch (Hz)');
    title(listbirds{y(ii)});
    set(gcf,'color','white');
    
end



%%

sz = 10;
%Now, make the scatter plot figure (Fig 2 C):
figure(2)

for ii = 1:6
    i = y(ii);

    subplot(3,2,ii)
    temppitches = [];
    temppitches = Bird_data_Unlesioned{i}.pitch{1};
    xs = [];
    xs = 1:numel(temppitches);
    holdxval = max(xs);
    scatter(xs,temppitches,sz,'filled','k'), hold on;

    temppitches = [];
    temppitches = Bird_data_Unlesioned{i}.pitch{2};
    xs = [];
    xs = holdxval+100:holdxval+100+numel(temppitches)-1;
    holdxval = max(xs);
    scatter(xs,temppitches,sz,'filled','k')

    temppitches = [];
    temppitches = Bird_data_Unlesioned{i}.pitch{3};
    xs = [];
    xs = holdxval+100:holdxval+100+numel(temppitches)-1;
    holdxval = max(xs);
    scatter(xs,temppitches,sz,'filled','k')

    temppitches = [];
    temppitches = Bird_data_Unlesioned{i}.pitch{4};
    xs = [];
    xs = holdxval+100:holdxval+100+numel(temppitches)-1;
    holdxval = max(xs);
    scatter(xs,temppitches,sz,'filled','k')

    temppitches = [];
    temppitches = Bird_data_Unlesioned{i}.pitch{5};
    xs = [];
    xs = holdxval+100:holdxval+100+numel(temppitches)-1;
    holdxval = max(xs);
    scatter(xs,temppitches,sz,'filled','k')
    temppitches = [];
    temppitches = Bird_data_Unlesioned{i}.pitch{6};
    xs = [];
    xs = holdxval+100:holdxval+100+numel(temppitches)-1;
    holdxval = max(xs);
    scatter(xs,temppitches,sz,'filled','k')
    %xlabel('arbitrary here, I set the x axis to days in inkscape');
    ylabel('Pitch (Hz)');
    title(listbirds{y(ii)});
    
    set(gcf,'color','white');

end










%%


STOPHERE = 1;
if STOPHERE == 1
    a = 0
else
    
    i = y(1);
    pitchBL = [];
    pitchBLall = [];
    pitchSH = [];
    pitchWO = [];
    
    Bird_data_Unlesioned{i};
    
    Bird_data_Unlesioned{i}.pitch
    
    pitchBL = Bird_data_Unlesioned{i}.pitch{3};
    pitchBLall = [Bird_data_Unlesioned{i}.pitch{3}', Bird_data_Unlesioned{i}.pitch{2}', Bird_data_Unlesioned{i}.pitch{1}'];
    pitchSH = Bird_data_Unlesioned{i}.pitch{6};
    
    if ~isnan(Bird_data_Unlesioned{i}.pitch{12}) == 1
        pitchWO = Bird_data_Unlesioned{i}.pitch{12};
    elseif ~isnan(Bird_data_Unlesioned{i}.pitch{11}) == 1
        pitchWO = Bird_data_Unlesioned{i}.pitch{11};
    elseif ~isnan(Bird_data_Unlesioned{i}.pitch{10}) == 1
        pitchWO = Bird_data_Unlesioned{i}.pitch{10};
    elseif ~isnan(Bird_data_Unlesioned{i}.pitch{9}) == 1
        pitchWO = Bird_data_Unlesioned{i}.pitch{9};
    end
    
    
    %PLOT 3: CDFplot of pitches BL3 vs SH3 vs WO6
    figure(3);
    h1 = []; h2 = []; h3 = [];
    h1 = cdfplot(pitchBLall); hold on; %plot the data from end of baseline
    set(h1,'Color','b'), hold on;
    h2 = cdfplot(pitchSH); hold on; %plot the data from end of shock training
    set(h2,'Color','r'), hold on;
    h3 = cdfplot(pitchWO); hold on;  %plot the data from end of washout
    set(h3,'Color','g'), hold on;
    legend('BLall','SH3','WOend');
    xlabel('Pitch (Hz)');
    set(gcf,'color','white');
    
    %To run statistical tests (kstest2 is a 2 sample KS test)
    [H,p] = kstest2(pitchBLall,pitchSH); %to test for significance between baseline and end of shock
    
    p
    %[H2,p2] = kstest2(pitchBLall,pitchWO); %to test for significance between baseline and end of washout
    
    
    
    
    %%
    
    %Now, make the scatter plot figure (Fig 2 C):
    figure(2)
    
    i = 4;
    
    temppitches = [];
    temppitches = Bird_data_Unlesioned{i}.pitch{1};
    xs = [];
    xs = 1:numel(temppitches);
    holdxval = max(xs);
    scatter(xs,temppitches,'filled','k'), hold on;
    
    temppitches = [];
    temppitches = Bird_data_Unlesioned{i}.pitch{2};
    xs = [];
    xs = holdxval+100:holdxval+100+numel(temppitches)-1;
    holdxval = max(xs);
    scatter(xs,temppitches,'filled','k')
    
    temppitches = [];
    temppitches = Bird_data_Unlesioned{i}.pitch{3};
    xs = [];
    xs = holdxval+100:holdxval+100+numel(temppitches)-1;
    holdxval = max(xs);
    scatter(xs,temppitches,'filled','k')
    
    temppitches = [];
    temppitches = Bird_data_Unlesioned{i}.pitch{4};
    xs = [];
    xs = holdxval+100:holdxval+100+numel(temppitches)-1;
    holdxval = max(xs);
    scatter(xs,temppitches,'filled','k')
    
    temppitches = [];
    temppitches = Bird_data_Unlesioned{i}.pitch{5};
    xs = [];
    xs = holdxval+100:holdxval+100+numel(temppitches)-1;
    holdxval = max(xs);
    scatter(xs,temppitches,'filled','k')
    temppitches = [];
    temppitches = Bird_data_Unlesioned{i}.pitch{6};
    xs = [];
    xs = holdxval+100:holdxval+100+numel(temppitches)-1;
    holdxval = max(xs);
    scatter(xs,temppitches,'filled','k')
    xlabel('arbitrary here, I set the x axis to days in inkscape');
    ylabel('Pitch (Hz)');
    set(gcf,'color','white');
    
    
end