%The purpose of this script is to go thru all the unlesioned (unoperated)
%experiments and make the figure of shock-driven learning based on this
%grouped data

clear all
close all
clc

listbirds = {'pk75pk76','rd101wh36','bk23gy23','or101or102','bk67gy65','bl67bl69','pu89pu90','lb60pu60','or167or168','gr60rd55','gr129yw79','gr129yw79_v1'};
rootdir = 'F:\labeled_songs_evening\';
drivename = 'E:/';
condensed_data = 1;

Bird_data_Evening = [];

if condensed_data == 1
    path = [drivename, 'Condensed data/Unlesioned/'];
    cd(path);
    load('Bird_data_Evening.mat');
else
    for a = 1:numel(listbirds)

        thispath = [];
        thispath = [rootdir, listbirds{a}];
        cd(thispath)
        folders = [];
        folders = dir('*g');

        [shfolders wnfolders info] = Define_folders_for_grouped_analy(listbirds{a},'F:/');
        Bird_data_Evening{a}.direction = info.direction;
        Bird_data_Evening{a}.syl = info.targetsyl;

        for b = 1:numel(folders)
            try
                cd([thispath, '\', folders(b).name])
                this_file = [];
                this_file = dir(['*_syl_*.mat']);
                load(this_file.name);

                temp_WA = [];
                temp_WA = weighted_avg;
                %temp_WA(temp_WA < (mean(temp_WA) - 2.5*std(temp_WA))) = [];
                %temp_WA(temp_WA > (mean(temp_WA) + 2.5*std(temp_WA))) = [];

                Bird_data_Evening{a}.pitch{b} = temp_WA;
            catch
                Bird_data_Evening{a}.pitch{b} = NaN;
            end
        end
    end
end

%%
%save_condensed_data = 1
save_condensed_data = 0
if save_condensed_data == 1
    path = 'E:/Condensed data/Unlesioned/'
    %path = [drivename, 'Condensed data/Unlesioned'];
    cd(path);
    save('Bird_data_Evening','Bird_data_Evening');
end


%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%To calculate the error bars for the means (SEMs) and to determine 
%significance, we use the hierarchical bootstrap approach (see Saravanan et
%al., 2019 for detailed explanation).

%Here, we first produce a matrix of bootstrapped values from which
%we resample. Each sample gets its own Hz value of pitch from which the
%semitone values are generated. Therefore, this way explicitly includes the
%error in estimation of the mean during baseline. 1 SD of the bootstrapped
%sample gives an accurate estimate of the SEM of the dataset.

%First step, create a matrix of all your data and convert pitch values (in
%Hz) into semitone change from baseline:
clear P %P is the variable that contains the important data (semitone change values on each day of shock training for each experiment)
for mm = 1:numel(listbirds)-1
    if mm < 11
        P(mm).birdname = listbirds{mm};
        if strcmp('down',Bird_data_Evening{mm}.direction) == 1 %trying to drive pitch down
            P(mm).shift_direction = -1;
        else
            P(mm).shift_direction = 1;
        end

        P(mm).syls = Bird_data_Evening{mm}.syl;
        P(mm).data_hz = Bird_data_Evening{mm}.pitch';
        P(mm).mean_baseline_pitches = mean(Bird_data_Evening{mm}.pitch{1});

        if strcmp('down',Bird_data_Evening{mm}.direction) == 1 %trying to drive pitch down

            %Here's where I calculate the semitone pitch change,
            %normalized to the final day of baseline:
            for nn = 1:length(Bird_data_Evening{mm}.pitch)
                P(mm).data(nn,1) = -12*log2((mean(Bird_data_Evening{mm}.pitch{nn}))/mean([Bird_data_Evening{mm}.pitch{1}']'))'; 
            end
        else %trying to drive pitch up

            %Here's where I calculate the semitone pitch change,
            %normalized to the final day of baseline:
            for nn = 1:length(Bird_data_Evening{mm}.pitch)
                P(mm).data(nn,1) = 12*log2((mean(Bird_data_Evening{mm}.pitch{nn}))/mean([Bird_data_Evening{mm}.pitch{1}']'))';
            end
        end
    else %we're on the weird bird with 2 experiments, need to deal with this slightly differently
        P(mm).birdname = 'gr129yw79';
        P(mm).shift_direction(1) = -1;
        P(mm).shift_direction(2) = 1;
        P(mm).syls{1} = 'd'; P(mm).syls{2} = 'a';
        P(mm).data_hz = [Bird_data_Evening{11}.pitch' Bird_data_Evening{12}.pitch'];        
        %P(mm).mean_baseline_pitches = [mean([BB{12}.pitch{1}', BB{12}.pitch{2}', BB{12}.pitch{3}']), nanmean([BB{13}.pitch{1}', BB{13}.pitch{2}', BB{13}.pitch{3}'])];
        P(mm).mean_baseline_pitches = [mean(Bird_data_Evening{11}.pitch{1}'),mean(Bird_data_Evening{12}.pitch{1}')];
        
        for xx = 1:4
            tempsemis1{xx} = -12*log2(Bird_data_Evening{11}.pitch{xx}/mean(Bird_data_Evening{11}.pitch{1}));
            tempsemis2{xx} = 12*log2(Bird_data_Evening{12}.pitch{xx}/mean(Bird_data_Evening{12}.pitch{1}));
        end      
        P(mm).data = [tempsemis1', tempsemis2'];
        
    end  
end

%P(7).data_hz{4} = NaN;
%Bootstrapping part. At this point, you have P.data, which has the semitone
%change values for each day of each experiment
nboot = 10000; %No of times to resample for bootstrapping. Varun's paper recommends 10^4
num_days = 4; max_syls = numel(listbirds); birds_to_use = listbirds; 

bootstrapping_matrix = zeros(nboot,num_days,max_syls,numel(birds_to_use));
lesioned_birds = 1;
for i = 1:numel(birds_to_use)-1   %Over all birds
    for j = 1:size(P(i).syls,2) %Over number of syllables for each bird
        for k = 1:num_days      %Over all days
            if lesioned_birds == 1
                temp = P(i).data_hz{k,j}; %Remember to take actual Hz values for this step.
            else
                if i < 12
                    temp = P(i).data(k,j);
                else
                    temp = P(i).data{k,j};
                end
            end
            if isempty(temp)
                bootstrapping_matrix(:,k,j,i) = NaN;
                continue;
            end
            for n = 1:nboot     %For number of times to bootstrap
                bootstrapping_matrix(n,k,j,i) = datasample(temp,1);
            end
        end
        if lesioned_birds == 1
            for n = 1:nboot
                temp_mean = [];
                temp_mean = nanmean(bootstrapping_matrix(n,1,j,i)); %Normalize each row to the mean of the 3 baseline days of that row.
                bootstrapping_matrix(n,:,j,i) = P(i).shift_direction(j)*12*log2(bootstrapping_matrix(n,:,j,i)/temp_mean);
            end
        end
    end
end

%Now do the actual bootstrapping: 
nboot2 = 300; %Only repeating 300 times since the actual variance is in the previous step.
bootstats1 = zeros(nboot2,num_days);

unlesioned_birds = 1:11;

for n = 1:nboot2
    
    temp_UL_birds = datasample(unlesioned_birds,length(unlesioned_birds));
    temp_data = [];
    for t = 1:length(temp_UL_birds)
        temp_syls = datasample(1:size(P(temp_UL_birds(t)).data,2),size(P(temp_UL_birds(t)).data,2));
        for s = 1:length(temp_syls)
            temp_pulls = datasample(1:nboot,nboot);
            temp_data = vertcat(temp_data,bootstrapping_matrix(temp_pulls,:,temp_syls(s),temp_UL_birds(t)));
        end
    end
    bootstats1(n,:) = nanmean(temp_data,1);
end


std_UL_pitch_shift = nanstd(bootstats1,0,1);
% std_pos_pitch_shift = nanstd(bootstats2,0,1);
% if lesioned_birds
%     std_no_pitch_shift = nanstd(bootstats3,0,1);
% end

for pp = 1:4
    pboot(pp) = numel(find(bootstats1(:,pp) >= 0))/(numel(bootstats1(:,pp)));
end

save_P = P;
save_bootstats = bootstats1;
save_std_UL_pitch_shift = std_UL_pitch_shift;

%%


clear S0
for pp = 1:length(listbirds)
    BLall = []; BL3 = []; thisBL = [];
    BL3 = mean(Bird_data_Evening{pp}.pitch{1});
    for qq = 1:4
        try
            if strcmp(Bird_data_Evening{pp}.direction,'up') %driving pitch up
                S1(pp,qq) = 12* log2(mean(Bird_data_Evening{pp}.pitch{(qq)})/BL3);
            else
                S1(pp,qq) = -12* log2(mean(Bird_data_Evening{pp}.pitch{(qq)})/BL3);
            end
        catch
            S1(pp,qq) = NaN;
        end
    end
end

S1(12,:) = -1*S1(12,:);
S1(8,4) = NaN;


nanmean(S1)

% SH_or_WN_analy = 'SH'
% if strcmp(SH_or_WN_analy,'SH') == 1
%     h1 = plot([0 nanmean(S1(:,1:end))],'-o'); hold on;
%     h3 = errorbar([0 nanmean(S1(:,1:end))],[0 std_UL_pitch_shift(1:end)],'k'); hold on;
%     set(gca,'XTick',(1:4),'XTickLabel',{'0','1','2','3'});
%     h1.LineWidth = 3; h3.LineWidth = 3;
%     ylim([-0.05 0.35]);
%     xlabel('Days since feedback onset');
%     ylabel('Pitch difference from baseline (semitones)');
%     set(gcf,'color','white');
% else
%     h1 = plot([0 nanmean(S1(:,4:end))],'k'); hold on;
%     h3 = errorbar([0 nanmean(S1(:,4:end))],[0 std_UL_pitch_shift(4:end)],'k'); hold on;
%     set(gca,'XTick',(1:4),'XTickLabel',{'0','1','2','3'});
%     h1.LineWidth = 3; h3.LineWidth = 3;
%     ylim([-0.05 0.8]);
%     xlabel('Days since feedback onset');
%     ylabel('Pitch difference from baseline (semitones)');
%     set(gcf,'color','white');
% end

%%

%The purpose of this script is to go thru all the unlesioned (unoperated)
%experiments and make the figure of shock-driven learning based on this
%grouped data

%This is the name on your computer of the hard drive containing your data:
drivename = 'E:/'; %on my computer, the E drive is the one with the data

condensed_data = 1; %1 if you're using the condensed data set, 0 if you're using the full data set
save_condensed_data = 0; %1 if you want to save condensed data files

SH_or_WN_analy = 'SH'; %'SH' for analyzing shock experiments, 'WN' for white noise experiments.
        %There is a different script that specificaly analyzes all the white
        %noise experiments, but if you wanted to you could also do that with
        %this script

Analyze_dur_and_catch = 0; %THIS IS IMPORTANT:   If you want to analyze
%syllable duration and catch vs stim trials, you should set the above value
%to equal 1. However, this will add a lot of time to running the analysis,
%because you have to loop thru every single song file within every folder
%to pull out syllable onsets/offsets and whether a trigger occurred during
%this time. If you just want to quickly go thru and analyze syllable pitch,
%SET THIS VALUE EQUAL TO 0, that way you can avoid these extra loops and
%save a lot of time

listbirds = {'pk75pk76','bk1bk2','rd101wh36','bk23gy23','or101or102','bk67gy65','bl67bl69','pu89pu90','lb60pu60','or167or168','gr60rd55','gr129yw79v2','gr129yw79v1'};
%loop thru individual experiments:
Bird_data_Unlesioned = [];

if condensed_data == 1
    path = [drivename, 'Condensed data/Unlesioned'];
    cd(path);
    if strcmp(SH_or_WN_analy,'SH') == 1 %load shock data
        load('Bird_data_Unlesioned.mat');
    else %load white noise data
        load('Bird_data_Unlesioned_WHITENOISE.mat');
    end
else
    for aa = 1:13 %can't just use length of listbirds because there are multiple experiments in one bird
        
        birdname = listbirds{aa};
        
        SHFOLDERS = []; WNFOLDERS = []; INFO = [];
        [SHFOLDERS, WNFOLDERS, INFO] = Define_folders_for_grouped_analy(birdname, drivename);
        
        this_syll = INFO.targetsyl; %Target syllable
        SH_threshold = INFO.SHthreshold; %Pitch threshold for targeting
        WN_threshold = INFO.WNthreshold; %Pitch threshold for targeting
        direction = INFO.direction; %Did we try to drive the pitch up or down
        
        FF = []; VOL = []; ENT = []; DUR = []; Nsyl = []; pitchM = []; volM = [];
        entM = []; durM = []; pitchS = []; volS = []; entS =[]; durS = [];
        stimpitches = []; catchpitches = []; Precision = []; Sensitivity = [];
        
        theseFolders = []; thisthreshold = [];
        if strcmp(SH_or_WN_analy,'SH') == 1
            theseFolders = SHFOLDERS;
            thisthreshold = SH_threshold;
            thesedays = {'BL','BL','BL','SH','SH','SH','WO','WO','WO','WO','WO','WO'};
        else
            theseFolders = WNFOLDERS;
            thisthreshold = WN_threshold;
            thesedays = {'BL','BL','BL','WN','WN','WN','WO','WO','WO','WO','WO','WO'};
        end
                
        Bird_data_Unlesioned{aa}.direction = direction;
        Bird_data_Unlesioned{aa}.syl = this_syll;
        Bird_data_Unlesioned{aa}.birdname = birdname;
        
        %Now I have the list of folders with data for one individual
        %experiment. Now loop thru each folder and pull out the data for
        %the target syllable:
        clear iii
        for iii = 1:length(theseFolders)
            try
                cd(theseFolders{iii});
                this_file = [];
                this_file = dir(['*_syl_', this_syll, '.mat']);
                load(this_file.name);
                
                Bird_data_Unlesioned{aa}.pitch{iii} = weighted_avg;
                Bird_data_Unlesioned{aa}.volume{iii} = amp_at_pitchquant;
                Bird_data_Unlesioned{aa}.spectentropy{iii} = spect_entropy;
                Bird_data_Unlesioned{aa}.wienentropy{iii} = wiener_entropy;
                Bird_data_Unlesioned{aa}.foldername{iii} = theseFolders{iii};
                Bird_data_Unlesioned{aa}.experimental_day{iii} = thesedays{iii};
                
                if Analyze_dur_and_catch == 1 %Do the analysis of duration and catch vs stim trials
                    
                    notmatfiles = []; cbinfile = []; tsylinstances = []; counter = 0;
                    recfilenames = []; catchcount = []; stimcount = []; syltrigcount = [];
                    sylcount = [];
                    
                    notmatfiles = dir('*.not.mat');
                    recfilenames = dir('*.rec');
                    
                    for bb = 1:length(notmatfiles)
                        cbinfile = load(notmatfiles(bb).name);
                        recfile = readrecf(recfilenames(bb).name);
                        tsylinstances = find(cbinfile.labels == this_syll); %tsylinstances is important, it's
                        %the index of when I labeled the target syllable
                        if isempty(tsylinstances) == 0 %an instance of the target syllable occurs in this cbin file
                            for cc = 1:length(tsylinstances) %loop thru instances of the target syllable
                                counter = counter + 1;
                                sylcount(counter) = counter; %syllable number index
                                catchcount(counter) = 0; %set this to 0 for now, change to 1 later if a catch trial occurred
                                stimcount(counter) = 0; %set this to 0 for now, change to 1 later if a stim trial occurred
                                syl_start = []; syl_stop = [];
                                syl_start = cbinfile.onsets(tsylinstances(cc));
                                syl_stop  = cbinfile.offsets(tsylinstances(cc));
                                syl_DUR(counter) = syl_stop - syl_start; %this will calculate syllable duration, in ms
                                
                                if isempty(recfile.ttimes) == 0 %check to see if any triggers occurred
                                    for dd = 1:length(recfile.ttimes) %loop thru occurrences of triggers
                                        if recfile.ttimes(dd) > syl_start && recfile.ttimes(dd) < syl_stop == 1 %a trigger occurred during this rendition of the targey syl
                                            syltrigcount(counter) = 1; %this syl had a trigger occur
                                            if recfile.catch(dd) == 1 %this trigger was a catch
                                                catchcount(counter) = 1;
                                                %stimcount(counter) = 0;
                                            else %this trigger was for real (not a catch)
                                                %catchcount(counter) = 0;
                                                stimcount(counter) = 1;
                                            end
                                        else %no trigger occurred on this rendition of the target syllable
                                            syltrigcount(counter) = 0; %this syl did NOT have trigger occur
                                        end
                                    end
                                else %no trigger occurred within this cbin file
                                    syltrigcount(counter) = 0; %this syl did NOT have trigger occur
                                end
                            end %stop looping thru syls within this cbin file
                        else %no instances of the target syl in this cbin file
                        end
                    end %stop looping thru cbin files
                    
                    Bird_data_Unlesioned{aa}.syl_duration{iii} = syl_DUR;
                    Bird_data_Unlesioned{aa}.syltrigs{iii} = syltrigcount;
                    Bird_data_Unlesioned{aa}.catchtrials{iii} = catchcount;
                    Bird_data_Unlesioned{aa}.stimtrials{iii} = stimcount;
                    
                    if isequal(numel(catchcount),numel(weighted_avg))
                    else %mismatch occurred between number in weighted_avg and number of sylcount!
                        disp(['Mismatch between catch trial number and syl renditions, experiment number ', num2str(aa), ', birdname is ' birdname ', folder number ' num2str(iii)]);
                        %keyboard
                        
                        %                     if aa == 2
                        %                        Bird_data{aa}.catchtrials{iii}(end) = [];
                        %                        Bird_data{aa}.stimtrials{iii}(end) = [];
                        %                     else
                        %                     end
                    end
                else %just skip doing the analysis of duration and catch vs stim
                end
                
            catch
                Bird_data_Unlesioned{aa}.pitch{iii} = NaN;
                %Bird_data{aa}.syl{iii} = NaN;
                %Bird_data{aa}.direction{iii} = NaN;
                Bird_data_Unlesioned{aa}.duration{iii} = NaN;
                Bird_data_Unlesioned{aa}.volume{iii} = NaN;
                Bird_data_Unlesioned{aa}.spectentropy{iii} = NaN;
                Bird_data_Unlesioned{aa}.wienentropy{iii} = NaN;
                
                if Analyze_dur_and_catch == 1 %Do the analysis of duration and catch vs stim trials
                    Bird_data_Unlesioned{aa}.syl_duration{iii} = NaN;
                    Bird_data_Unlesioned{aa}.syltrigs{iii} = NaN;
                    Bird_data_Unlesioned{aa}.catchtrials{iii} = NaN;
                    Bird_data_Unlesioned{aa}.stimtrials{iii} = NaN;
                else
                end
                
                disp(['Could not analyze experiment number ', num2str(aa), ', birdname is ' birdname ', folder number ' num2str(iii)]);
                
            end
        end
    end
    
    if save_condensed_data == 1
        path = [drivename, 'Condensed data/Unlesioned'];
        cd(path);
        if strcmp(SH_or_WN_analy,'SH') == 1
            save('Bird_data_Unlesioned','Bird_data_Unlesioned');
        else
            save('Bird_data_Unlesioned_WHITENOISE','Bird_data_Unlesioned');
        end
    end
    
end

  
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%To calculate the error bars for the means (SEMs) and to determine 
%significance, we use the hierarchical bootstrap approach (see Saravanan et
%al., 2019 for detailed explanation).

%Here, we first produce a matrix of bootstrapped values from which
%we resample. Each sample gets its own Hz value of pitch from which the
%semitone values are generated. Therefore, this way explicitly includes the
%error in estimation of the mean during baseline. 1 SD of the bootstrapped
%sample gives an accurate estimate of the SEM of the dataset.

%First step, create a matrix of all your data and convert pitch values (in
%Hz) into semitone change from baseline:
clear P %P is the variable that contains the important data (semitone change values on each day of shock training for each experiment)
for mm = 1:12
    if mm < 12
        P(mm).birdname = listbirds{mm};
        if strcmp('down',Bird_data_Unlesioned{mm}.direction) == 1 %trying to drive pitch down
            P(mm).shift_direction = -1;
        else
            P(mm).shift_direction = 1;
        end

        P(mm).syls = Bird_data_Unlesioned{mm}.syl;
        P(mm).data_hz = Bird_data_Unlesioned{mm}.pitch';
        P(mm).mean_baseline_pitches = mean([Bird_data_Unlesioned{mm}.pitch{1}', Bird_data_Unlesioned{mm}.pitch{2}', Bird_data_Unlesioned{mm}.pitch{3}']');

        if strcmp('down',Bird_data_Unlesioned{mm}.direction) == 1 %trying to drive pitch down

            %Here's where I calculate the semitone pitch change,
            %normalized to the final day of baseline:
            for nn = 1:length(Bird_data_Unlesioned{mm}.pitch)
                P(mm).data(nn,1) = -12*log2((mean(Bird_data_Unlesioned{mm}.pitch{nn}))/mean([Bird_data_Unlesioned{mm}.pitch{3}']'))'; 
            end
        else %trying to drive pitch up

            %Here's where I calculate the semitone pitch change,
            %normalized to the final day of baseline:
            for nn = 1:length(Bird_data_Unlesioned{mm}.pitch)
                P(mm).data(nn,1) = 12*log2((mean(Bird_data_Unlesioned{mm}.pitch{nn}))/mean([Bird_data_Unlesioned{mm}.pitch{3}']'))';
            end
        end
    else %we're on the weird bird with 2 experiments, need to deal with this slightly differently
        P(mm).birdname = 'gr129yw79';
        P(mm).shift_direction = -1;
        P(mm).syls{1} = 'd'; P(mm).syls{2} = 'a';
        P(mm).data_hz = [Bird_data_Unlesioned{12}.pitch' Bird_data_Unlesioned{13}.pitch'];        
        %P(mm).mean_baseline_pitches = [mean([BB{12}.pitch{1}', BB{12}.pitch{2}', BB{12}.pitch{3}']), nanmean([BB{13}.pitch{1}', BB{13}.pitch{2}', BB{13}.pitch{3}'])];
        P(mm).mean_baseline_pitches = [mean(Bird_data_Unlesioned{12}.pitch{3}'),mean(Bird_data_Unlesioned{13}.pitch{3}')];
        
        for xx = 1:12
            tempsemis1{xx} = -12*log2(Bird_data_Unlesioned{12}.pitch{xx}/mean(Bird_data_Unlesioned{12}.pitch{3}));
            tempsemis2{xx} = 12*log2(Bird_data_Unlesioned{13}.pitch{xx}/mean(Bird_data_Unlesioned{13}.pitch{3}));
        end      
        P(mm).data = [tempsemis1', tempsemis2'];
        
    end  
end

P(12).shift_direction(2) = 1;
%Bootstrapping part. At this point, you have P.data, which has the semitone
%change values for each day of each experiment
nboot = 10000; %No of times to resample for bootstrapping. Varun's paper recommends 10^4
num_days = 6; max_syls = numel(listbirds); birds_to_use = listbirds; 

bootstrapping_matrix = zeros(nboot,num_days,max_syls,numel(birds_to_use));
lesioned_birds = 1;
for i = 1:numel(birds_to_use)-1   %Over all birds
    for j = 1:size(P(i).syls,2) %Over number of syllables for each bird
        for k = 1:num_days      %Over all days
            if lesioned_birds == 1
                temp = P(i).data_hz{k,j}; %Remember to take actual Hz values for this step.
            else
                if i < 12
                    temp = P(i).data(k,j);
                else
                    temp = P(i).data{k,j};
                end
            end
            if isempty(temp)
                bootstrapping_matrix(:,k,j,i) = NaN;
                continue;
            end
            for n = 1:nboot     %For number of times to bootstrap
                bootstrapping_matrix(n,k,j,i) = datasample(temp,1);
            end
        end
        if lesioned_birds == 1
            for n = 1:nboot
                temp_mean = [];
                temp_mean = nanmean(bootstrapping_matrix(n,3,j,i)); %Normalize each row to the mean of the 3 baseline days of that row.
                bootstrapping_matrix(n,:,j,i) = P(i).shift_direction(j)*12*log2(bootstrapping_matrix(n,:,j,i)/temp_mean);
            end
        end
    end
end

%Now do the actual bootstrapping: 
nboot2 = 300; %Only repeating 300 times since the actual variance is in the previous step.
bootstats1 = zeros(nboot2,num_days);
bootstats2 = zeros(nboot2,num_days);
bootstats3 = zeros(nboot2,num_days);

unlesioned_birds = 1:12;

for n = 1:nboot2
    
    temp_UL_birds = datasample(unlesioned_birds,length(unlesioned_birds));
    temp_data = [];
    for t = 1:length(temp_UL_birds)
        temp_syls = datasample(1:size(P(temp_UL_birds(t)).data,2),size(P(temp_UL_birds(t)).data,2));
        for s = 1:length(temp_syls)
            temp_pulls = datasample(1:nboot,nboot);
            temp_data = vertcat(temp_data,bootstrapping_matrix(temp_pulls,:,temp_syls(s),temp_UL_birds(t)));
        end
    end
    bootstats1(n,:) = nanmean(temp_data,1);
end


% for n = 1:nboot2
%     
%     temp_neg_birds = datasample(neg_shift_birds,length(neg_shift_birds));
%     temp_data = [];
%     for t = 1:length(temp_neg_birds)
%         temp_syls = datasample(1:size(P(temp_neg_birds(t)).data,2),size(P(temp_neg_birds(t)).data,2));
%         for s = 1:length(temp_syls)
%             temp_pulls = datasample(1:nboot,nboot);
%             temp_data = vertcat(temp_data,bootstrapping_matrix(temp_pulls,:,temp_syls(s),temp_neg_birds(t)));
%         end
%     end
%     bootstats1(n,:) = nanmean(temp_data,1);
%     
%     temp_pos_birds = datasample(pos_shift_birds,length(pos_shift_birds));
%     temp_data = [];
%     for t = 1:length(temp_pos_birds)
%         temp_syls = datasample(1:size(P(temp_pos_birds(t)).data,2),size(P(temp_pos_birds(t)).data,2));
%         for s = 1:length(temp_syls)
%             temp_pulls = datasample(1:nboot,nboot);
%             temp_data = vertcat(temp_data,bootstrapping_matrix(temp_pulls,:,temp_syls(s),temp_pos_birds(t)));
%         end
%     end
%     bootstats2(n,:) = nanmean(temp_data,1);
%     
%     if lesioned_birds
%         temp_no_birds = datasample(no_shift_birds,length(no_shift_birds));
%         temp_data = [];
%         for t = 1:length(temp_no_birds)
%             temp_syls = datasample(1:size(P(temp_no_birds(t)).data,2),size(P(temp_no_birds(t)).data,2));
%             for s = 1:length(temp_syls)
%                 temp_pulls = datasample(1:nboot,nboot);
%                 temp_data = vertcat(temp_data,bootstrapping_matrix(temp_pulls,:,temp_syls(s),temp_no_birds(t)));
%             end
%         end
%         bootstats3(n,:) = nanmean(temp_data,1);
%     end
% end

std_UL_pitch_shift = nanstd(bootstats1,0,1);
% std_pos_pitch_shift = nanstd(bootstats2,0,1);
% if lesioned_birds
%     std_no_pitch_shift = nanstd(bootstats3,0,1);
% end

for pp = 1:6
    pboot(pp) = numel(find(bootstats1(:,pp) >= 0))/(numel(bootstats1(:,pp)));
end


tempbootstats = bootstats1(:,3:end);
savePboot = []; %for determining significant difference between preL vs postL
for bb = 1:size(tempbootstats,2)
    a = []; b = [];
    [a b] = get_direct_prob( tempbootstats(:,bb), save_bootstats(:,bb) ); %get direct prob is a function Varun wrote to calculate significance
    savePboot(bb) = a;
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
clear S1
for pp = 1:length(listbirds)
    BLall = []; BL3 = []; thisBL = []; 
    BLall = nanmean( [Bird_data_Unlesioned{pp}.pitch{1}' Bird_data_Unlesioned{pp}.pitch{2}' Bird_data_Unlesioned{pp}.pitch{3}']);
    BL3 = mean(Bird_data_Unlesioned{pp}.pitch{3});
    for qq = 1:6
        if strcmp(Bird_data_Unlesioned{pp}.direction,'up') %driving pitch up
            S1(pp,qq) = 12* log2(mean(Bird_data_Unlesioned{pp}.pitch{(qq)})/BL3);
        else
            S1(pp,qq) = -12* log2(mean(Bird_data_Unlesioned{pp}.pitch{(qq)})/BL3);
        end
    end
end

if strcmp(SH_or_WN_analy,'SH') == 1
    h1 = plot([0 nanmean(S1(:,4:end))],'-o'); hold on;
    h3 = errorbar([0 nanmean(S1(:,4:end))],[0 std_UL_pitch_shift(4:end)],'k'); hold on;
    set(gca,'XTick',(1:4),'XTickLabel',{'0','1','2','3'});
    h1.LineWidth = 3; h3.LineWidth = 3;
    ylim([-0.05 0.35]);
    xlabel('Days since feedback onset');
    ylabel('Pitch difference from baseline (semitones)');
    set(gcf,'color','white');
else
    h1 = plot([0 nanmean(S1(:,4:end))],'k'); hold on;
    h3 = errorbar([0 nanmean(S1(:,4:end))],[0 std_UL_pitch_shift(4:end)],'k'); hold on;
    set(gca,'XTick',(1:4),'XTickLabel',{'0','1','2','3'});
    h1.LineWidth = 3; h3.LineWidth = 3;
    ylim([-0.05 0.8]);
    xlabel('Days since feedback onset');
    ylabel('Pitch difference from baseline (semitones)');
    set(gcf,'color','white');
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%
clear S1
for pp = 1:length(listbirds)
    BLall = []; BL3 = []; thisBL = []; 
    BLall = nanmean( [Bird_data_Unlesioned{pp}.pitch{1}' Bird_data_Unlesioned{pp}.pitch{2}' Bird_data_Unlesioned{pp}.pitch{3}']);
    BL3 = mean(Bird_data_Unlesioned{pp}.pitch{3});
    for qq = 1:6
        if strcmp(Bird_data_Unlesioned{pp}.direction,'up') %driving pitch up
            S1(pp,qq) = 12* log2(mean(Bird_data_Unlesioned{pp}.pitch{(qq)})/BL3);
        else
            S1(pp,qq) = -12* log2(mean(Bird_data_Unlesioned{pp}.pitch{(qq)})/BL3);
        end
    end
end


listbirds = {'pk75pk76','rd101wh36','bk23gy23','or101or102','bk67gy65','bl67bl69','pu89pu90','lb60pu60','or167or168','gr60rd55','gr129yw79','gr129yw79_v1'};

clear S2
for pp = 1:length(listbirds)
    BLall = []; BL3 = []; thisBL = [];
    BL3 = mean(Bird_data_Evening{pp}.pitch{1});
    for qq = 1:4
        try
            if strcmp(Bird_data_Evening{pp}.direction,'up') %driving pitch up
                S2(pp,qq) = 12* log2(mean(Bird_data_Evening{pp}.pitch{(qq)})/BL3);
            else
                S2(pp,qq) = -12* log2(mean(Bird_data_Evening{pp}.pitch{(qq)})/BL3);
            end
        catch
            S2(pp,qq) = NaN;
        end
    end
end

S2(12,:) = -1*S2(12,:);
%S2(8,4) = NaN;


h1 = plot([0 nanmean(S1(:,4:end))],'-o'); hold on;
h3 = errorbar([0 nanmean(S1(:,4:end))],[0 std_UL_pitch_shift(4:end)],'k'); hold on;
set(gca,'XTick',(1:4),'XTickLabel',{'0','1','2','3'});
hold on
h1.LineWidth = 3; h3.LineWidth = 3;
h1 = plot([0 nanmean(S2(:,2:end))],'-o'); hold on;
h3 = errorbar([0 nanmean(S2(:,2:end))],[0 save_std_UL_pitch_shift(2:end)],'k'); hold on;
h1.LineWidth = 3; h3.LineWidth = 3;
ylim([-0.05 0.35]);
xlabel('Days since feedback onset');
ylabel('Pitch difference from baseline (semitones)');
set(gcf,'color','white');




%[p, h] = ttest(S1(:,6),S2(:,4))

%[p, h] = ttest(S1(:,5),S2(:,3))

%[p, h] = ttest(S1(:,4),S2(:,2))

