%The purpose of this script is to go thru all the LMAN lesioned
%experiments and make the figure of shock-driven learning based on this
%grouped data, for both pre- and postlesion

clear all
close all
clc

%This is the name on your computer of the hard drive containing your data:
%drivename = 'E:/'; %on my computer, the E drive is the one with the data

condensed_data = 1; %1 if you're using the condensed data set, 0 if you're using the full data set
%save_condensed_data = 0; %1 if you want to save condensed data files

%Analyze_dur_and_catch = 1; %THIS IS IMPORTANT:   If you want to analyze
%syllable duration and catch vs stim trials, you should set the above value
%to equal 1. However, this will add a lot of time to running the analysis,
%because you have to loop thru every single song file within every folder
%to pull out syllable onsets/offsets and whether a trigger occurred during
%this time. If you just want to quickly go thru and analyze syllable pitch,
%SET THIS VALUE EQUAL TO 0, that way you can avoid these extra loops and
%save a lot of time

listbirds = {'bl39lb19','bl41lb41','gr19pu26','wh32wh133','pu17pu32','yw41yw44'};
%listbirds = {'bl41lb41','gr19pu26','wh32wh133','pu17pu32','bl39lb19'};

%First, loop thru all birds and collect all the pitch data for each day of
%each experiment
Bird_data_LMAN_lesioned = [];

%Select the folder containing the relevant .mat file
if condensed_data == 1
   pathname = uigetdir('Select the folder containing the condensed data .mat file');
   load([pathname, '/Bird_data_LMAN_lesioned.mat'])
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%To calculate the error bars for the means (SEMs), we use bootstrapping.
%Note that this implemenation differs substantially from our previous
%version. Here, we first produce a matrix of bootstrapped values from which
%we resample. Each sample gets its own Hz value of pitch from which the
%semitone values are generated. Therefore, this way explicitly includes the
%error in estimation of the mean during baseline. 1 SD of the bootstrapped
%sample gives an accurate estimate of the SEM of the dataset.

% load('C:\Users\jnmcgre\Downloads\workspace_variables_for_gordon.mat')


%clear P %Save bootstrapping info in a variable called "P" just because that's what Varun used
clear P1; clear P2; clear P3 %P1 is prelesion, P2 is postlesion, P3 is postL white noise
%I'm commenting out P3 for now, because I don't analyze postL white noise
%in this script, but if you wanted to look at postL white noise you could
%uncomment everywhere you see P3

for mm = 1:length(listbirds)
    P1(mm).birdname = listbirds{mm};
    P2(mm).birdname = listbirds{mm};
    %P3(mm).birdname = listbirds{mm};
    
    if strcmp('down',Bird_data_LMAN_lesioned{mm}.direction) == 1 %trying to drive pitch down
        P1(mm).shift_direction = -1;
        P2(mm).shift_direction = -1;
        %P3(mm).shift_direction = -1;
    else
        P1(mm).shift_direction = 1;
        P2(mm).shift_direction = 1;
        %P3(mm).shift_direction = 1;
    end
    
    P1(mm).syls = Bird_data_LMAN_lesioned{mm}.syl;
    P2(mm).syls = Bird_data_LMAN_lesioned{mm}.syl;
    %P3(mm).syls = Bird_data{mm}.syl;
    P1(mm).data_hz = Bird_data_LMAN_lesioned{mm}.pre.pitch';
    P2(mm).data_hz = Bird_data_LMAN_lesioned{mm}.post.pitch';
    %P3(mm).data_hz = BIRDS{mm}.postWN.pitch';
    P1(mm).mean_baseline_pitches = mean([Bird_data_LMAN_lesioned{mm}.pre.pitch{1}', Bird_data_LMAN_lesioned{mm}.pre.pitch{2}', Bird_data_LMAN_lesioned{mm}.pre.pitch{3}']');
    P2(mm).mean_baseline_pitches = mean([Bird_data_LMAN_lesioned{mm}.post.pitch{1}', Bird_data_LMAN_lesioned{mm}.post.pitch{2}', Bird_data_LMAN_lesioned{mm}.post.pitch{3}']');
    
    %Here, I'm converting the pitches of the renditions of the target
    %syllable
    if strcmp('down',Bird_data_LMAN_lesioned{mm}.direction) == 1 %trying to drive pitch down
        for nn = 1:length(Bird_data_LMAN_lesioned{mm}.pre.pitch)
            %P1(mm).data(nn,1) = -12*log2((mean(BIRDS{mm}.pre.pitch{nn}))/mean([BIRDS{mm}.pre.pitch{1}', BIRDS{mm}.pre.pitch{2}',BIRDS{mm}.pre.pitch{3}']'))';
            %P2(mm).data(nn,1) = -12*log2((mean(BIRDS{mm}.post.pitch{nn}))/mean([BIRDS{mm}.post.pitch{1}', BIRDS{mm}.post.pitch{2}',BIRDS{mm}.post.pitch{3}']'))';
            P1(mm).data(nn,1) = -12*log2((mean(Bird_data_LMAN_lesioned{mm}.pre.pitch{nn}))/mean([Bird_data_LMAN_lesioned{mm}.pre.pitch{3}']'))';
            P2(mm).data(nn,1) = -12*log2((mean(Bird_data_LMAN_lesioned{mm}.post.pitch{nn}))/mean([Bird_data_LMAN_lesioned{mm}.post.pitch{3}']'))';
        end
    else %trying to drive pitch up
        for nn = 1:length(Bird_data_LMAN_lesioned{mm}.pre.pitch)
            %P1(mm).data(nn,1) = 12*log2((mean(BIRDS{mm}.pre.pitch{nn}))/mean([BIRDS{mm}.pre.pitch{1}', BIRDS{mm}.pre.pitch{2}', BIRDS{mm}.pre.pitch{3}']'))';
            %P2(mm).data(nn,1) = 12*log2((mean(BIRDS{mm}.post.pitch{nn}))/mean([BIRDS{mm}.post.pitch{1}', BIRDS{mm}.post.pitch{2}',BIRDS{mm}.post.pitch{3}']'))';
            P1(mm).data(nn,1) = 12*log2((mean(Bird_data_LMAN_lesioned{mm}.pre.pitch{nn}))/mean([Bird_data_LMAN_lesioned{mm}.pre.pitch{3}']'))';
            P2(mm).data(nn,1) = 12*log2((mean(Bird_data_LMAN_lesioned{mm}.post.pitch{nn}))/mean([Bird_data_LMAN_lesioned{mm}.post.pitch{3}']'))';
        end
    end
end
%P1 is prelesion data, P2 is postlesion. P3 is postlesion white noise data,
%I don't currently analyze that below but it would be easy to add

%Bootstrapping part
nboot = 10000; %No of times to resample for bootstrapping (Varun recommends using 10^4)
num_days = 8; max_syls = numel(listbirds); birds_to_use = listbirds;

bootstrapping_matrix1 = zeros(nboot,num_days,numel(birds_to_use)); %bootstrap matrix #1 is for prelesion data
bootstrapping_matrix2 = zeros(nboot,num_days,numel(birds_to_use)); %bootstrap matrix #2 is for postlesion data

for i = 1:numel(birds_to_use)   %Over all birds
    for k = 1:num_days      %Over all days
        temp = [];
        temp = P1(i).data_hz{k};
        for n = 1:nboot     %For number of times to bootstrap
            bootstrapping_matrix1(n,k,i) = datasample(temp,1);
        end
        if isempty(temp)
            bootstrapping_matrix1(:,k,i) = NaN;
            continue;
        end
    end
    for n = 1:nboot
        temp_mean = [];
        temp_mean = nanmean(bootstrapping_matrix1(n,3,i)); %Normalize each row to the mean of the 3 baseline days of that row.
        bootstrapping_matrix1(n,:,i) = P1(i).shift_direction*12*log2(bootstrapping_matrix1(n,:,i)/temp_mean);
    end
end

for i = 1:numel(birds_to_use)   %Over all birds
    for k = 1:num_days      %Over all days
        temp = P2(i).data_hz{k};
        for n = 1:nboot     %For number of times to bootstrap
            bootstrapping_matrix2(n,k,i) = datasample(temp,1);
        end
        if isempty(temp)
            bootstrapping_matrix2(:,k,i) = NaN;
            continue;
        end
    end
    for n = 1:nboot
        temp_mean = [];
        temp_mean = nanmean(bootstrapping_matrix2(n,3,i)); %Normalize each row to the mean of the 3 baseline days of that row.
        bootstrapping_matrix2(n,:,i) = P2(i).shift_direction*12*log2(bootstrapping_matrix2(n,:,i)/temp_mean);
    end
end

%Now do the actual bootstrapping:
nboot2 = 300; %Only repeating 300 times since the actual variance is in the previous step.
bootstats1 = zeros(nboot2,num_days);
bootstats2 = zeros(nboot2,num_days);
%bootstats3 = zeros(nboot2,num_days); this is for white noise analysis

unlesioned_birds = 1:length(listbirds);

for n = 1:nboot2
    
    temp_UL_birds = datasample(unlesioned_birds,length(unlesioned_birds));
    temp_data = [];
    for t = 1:length(temp_UL_birds)
        temp_syls = datasample(1:size(P1(temp_UL_birds(t)).data,2),size(P1(temp_UL_birds(t)).data,2));
        for s = 1:length(temp_syls)
            temp_pulls = datasample(1:nboot,nboot);
            temp_data = vertcat(temp_data,bootstrapping_matrix1(temp_pulls,:,temp_UL_birds(t)));
        end
    end
    bootstats1(n,:) = nanmean(temp_data,1); %prelesion
end

unlesioned_birds = 1:length(listbirds);

for n = 1:nboot2
    temp_UL_birds = datasample(unlesioned_birds,length(unlesioned_birds));
    temp_data = [];
    for t = 1:length(temp_UL_birds)
        temp_syls = datasample(1:size(P2(temp_UL_birds(t)).data,2),size(P2(temp_UL_birds(t)).data,2));
        for s = 1:length(temp_syls)
            temp_pulls = datasample(1:nboot,nboot);
            temp_data = vertcat(temp_data,bootstrapping_matrix2(temp_pulls,:,temp_UL_birds(t)));
        end
    end
    bootstats2(n,:) = nanmean(temp_data,1); %postlesion
end

%savePboot = []; %for determining significant difference between preL vs postL
%for bb = 1:size(bootstats1,2)
%    a = []; b = [];
%    [a b] = get_direct_prob( bootstats1(:,bb), bootstats2(:,bb) ); %get direct prob is a function Varun wrote to calculate significance
%    savePboot(bb) = a;
%end

%These values are the error bars!!!!! (because std dev of bootstrapped data
%is a good way to measure the standard error of the mean)
std_UL_pitch_shift1 = nanstd(bootstats1,0,1);
std_UL_pitch_shift2 = nanstd(bootstats2,0,1);

%Pboot1 is for testing significance between preL data and 0
for pp = 1:8
    pboot1(pp) = numel(find(bootstats1(:,pp) >= 0))/(numel(bootstats1(:,pp)));
end

%Pboot2 is for testing significance between postL data and 0
for pp = 1:8
    pboot2(pp) = numel(find(bootstats2(:,pp) >= 0))/(numel(bootstats2(:,pp)));
end

%Here, I'm just calculating semitone change from baseline for plotting:
clear S1 S2
for pp = 1:length(listbirds)
    for qq = 1:8
        if strcmp(Bird_data_LMAN_lesioned{pp}.direction,'up') %driving pitch up
            S1(pp,qq) = 12* log2(mean(Bird_data_LMAN_lesioned{pp}.pre.pitch{(qq)})/(mean(Bird_data_LMAN_lesioned{pp}.pre.pitch{3})));
            S2(pp,qq) = 12* log2(mean(Bird_data_LMAN_lesioned{pp}.post.pitch{(qq)})/(mean(Bird_data_LMAN_lesioned{pp}.post.pitch{3})));
        else %driving pitch down
            S1(pp,qq) = -12* log2(mean(Bird_data_LMAN_lesioned{pp}.pre.pitch{(qq)})/(mean(Bird_data_LMAN_lesioned{pp}.pre.pitch{3})));
            S2(pp,qq) = -12* log2(mean(Bird_data_LMAN_lesioned{pp}.post.pitch{(qq)})/(mean(Bird_data_LMAN_lesioned{pp}.post.pitch{3})));
        end
    end
end

h1 = plot([0 nanmean(S1(:,4:end))], '-o'); hold on;
h1.Color = [0 217/255 1]; hold on;
h2 = plot([1.1:6.1],[0 nanmean(S2(:,4:end))], '-o'); hold on;
h2.Color = [0 0 128/255]; hold on;
h3 = errorbar([0 nanmean(S1(:,4:end))],[0 std_UL_pitch_shift1(4:end)],'color',[0 217/255 1]); hold on;
h4 = errorbar([1.1:6.1],[0 nanmean(S2(:,4:end))],[0 std_UL_pitch_shift2(4:end)],'color',[0 0 128/255]); hold on;
set(gca,'XTick',(1:6),'XTickLabel',{'0','1','2','3','4','5'});
h1.LineWidth = 3; h2.LineWidth = 3; h3.LineWidth = 3; h4.LineWidth = 3;
ylim([-0.2 1.1]);
legend('Prelesion','Postlesion','Location','Northwest');
xlabel('Days since feedback onset');
ylabel('Pitch difference from baseline (semitones)');
set(gcf,'color','white');
set(gca,'box','off')


%figure(140321)
%for ii = 2:6
%    plot(S1(ii,3:end),'b'), hold on;
%end
%for ii = 1:6
%    plot(S2(ii,3:end),'r'), hold on;
%end
%legend('Prelesion','Postlesion');
%xlabel('Days since feedback onset');
%ylabel('Pitch difference from baseline (semitones)');
%set(gcf,'color','white');



clear S_pre S_pre_SEM
for pp = 1:length(listbirds)
    preBLall = []; preBL3 = [];
    preBLall = nanmean( [Bird_data_LMAN_lesioned{pp}.pre.pitch{1}' Bird_data_LMAN_lesioned{pp}.pre.pitch{2}' Bird_data_LMAN_lesioned{pp}.pre.pitch{3}']);
    preBL3 = mean(Bird_data_LMAN_lesioned{pp}.pre.pitch{3});
    for qq = 1:6
        if strcmp(Bird_data_LMAN_lesioned{pp}.direction,'up') == 1
            S_pre(pp,qq) = 12*log2(mean(Bird_data_LMAN_lesioned{pp}.pre.pitch{(qq+2)})/preBL3);
        else
            S_pre(pp,qq) = -12*log2(mean(Bird_data_LMAN_lesioned{pp}.pre.pitch{(qq+2)})/preBL3);
        end
        tempsemis = [];
        tempsemis = 12*log2((Bird_data_LMAN_lesioned{pp}.pre.pitch{(qq+2)})/preBL3);
        S_pre_SEM(pp,qq) = std(tempsemis)/sqrt(numel(tempsemis));
    end
end
clear S_post S_post_SEM
for pp = 1:length(listbirds)
    postBLall = []; postBL3 = [];
    postBLall = nanmean( [Bird_data_LMAN_lesioned{pp}.post.pitch{1}' Bird_data_LMAN_lesioned{pp}.post.pitch{2}' Bird_data_LMAN_lesioned{pp}.post.pitch{3}']);
    postBL3 = mean(Bird_data_LMAN_lesioned{pp}.post.pitch{3});
    for qq = 1:6
        if strcmp(Bird_data_LMAN_lesioned{pp}.direction,'up') == 1
            S_post(pp,qq) = 12*log2(mean(Bird_data_LMAN_lesioned{pp}.post.pitch{(qq+2)})/postBL3);
        else
            S_post(pp,qq) = -12*log2(mean(Bird_data_LMAN_lesioned{pp}.post.pitch{(qq+2)})/postBL3);
        end
        tempsemis = [];
        tempsemis = 12*log2((Bird_data_LMAN_lesioned{pp}.post.pitch{(qq+2)})/postBL3);
        S_post_SEM(pp,qq) = std(tempsemis)/sqrt(numel(tempsemis));
    end
end

S_pre_SEM(:,1) = 0;
S_post_SEM(:,1) = 0;

figure(12032)
for ii = 1:length(S_pre)
    h1 = plot(S_pre(ii,1:end),'-o','Markersize',5); hold on;
    h1.LineWidth = 2; hold on;
    h1.Color = [0 217/255 255/255]; hold on;
    set(h1, 'MarkerFaceColor', get(h1,'Color'));
    h2 = errorbar(S_pre(ii,1:end),S_pre_SEM(ii,1:end)); hold on;
    h2.LineWidth = 2; hold on;
    h2.Color = [0 217/255 255/255]; hold on;
end
hold on
for ii = 1:length(S_post)
    h3 = plot(S_post(ii,1:end),'-o','Markersize',5); hold on;
    h3.LineWidth = 2; hold on;
    h3.Color = [0 0 128/255]; hold on;
    set(h3, 'MarkerFaceColor', get(h3,'Color'));
    h4 = errorbar(S_post(ii,1:end),S_post_SEM(ii,1:end)); hold on;
    h4.LineWidth = 2; hold on;
    h4.Color = [0 0 128/255]; hold on;
end
legend('Prelesion','Postlesion','Location','Northwest');
%xticks([1 2 3 4 5 6]);
%xticklabels({'0', '1', '2', '3', '4', '5'});
ylim([-0.4 1.6]);
xlabel('Days since feedback onset');
ylabel('Pitch change from baseline (semitones)');
set(gcf,'color','white');
set(gca,'box','off')



