C
C     essdyn_maxv.f
C     
C     modified from essdyn_abc.f and previously
C     factor.f to identify principal components of conformational
C     change ala Berendsen
C
C     program to do principal component analysis of a set of coordinates
C
C     NEW up to 600 residues   3*600 = 1800; 1800x1800 = 3,240,000  NEW
C     NEW   and update dimension in the following line
C     NEW                 call mstr(factor,temp,750,0,1)
C     OLD up to 250 residues.... 3*250=750;  750x750 = 562500 OLD
C     currently for 100 coordinate sets  (increased from 80 from 30 )
C     and 10 eigenvectors analyzed
C
C     allows eigenvectors to be determined for nfile coordinate sets
C     and then applied to nextra sets that weren't used in the analysis
C
C     in calculating the rigid body vector - uses the large eigenvalue
C
      CHARACTER ATOM*6,ATNAM*4,RES*3,FILNAM*40,LABEL*6,hetatm*6
      character chain*1
      dimension xcoord(100,1800),factor(1800,1800),xrms(100,100)
      dimension avex(1800)
      dimension temp(3240000),temp2(3240000),eigv(1800)
      dimension eigvec(1800,1800)
      dimension fn_eigv(1800,100),proj(10),xlen(100),xproj(3)
      dimension rmsproj(100),evalcoef(100,100)
      dimension xin(3,600),yin(3,600),yrot(3,600),rot(3,3),d(3),yax(3)
      character*3 reslist(600)
      character catom*4,filout*40,chout*1
      dimension ireslist(600),xpdb(10,3,600)
      dimension iwork1(9),iwork2(9),ibigat(40)
      data atom /'ATOM  '/,hetatm/'HETATM'/,catom/' CA '/,chout/'V'/
C
      WRITE(6,1000)
      READ(5,1010) nfile,nextra,idiag
      ntotal = nfile + nextra
      write(6,1012) nfile,nextra,ntotal,idiag
C
      do 200 if = 1,ntotal
      read(5,1020) filnam
      WRITE(6,1030) if,FILNAM
      OPEN(UNIT=8,NAME=FILNAM,TYPE='OLD',FORM='FORMATTED')
C
      natom=0
  100 READ(8,1100,END=120,ERR=100) LABEL,IATOM,ATNAM,RES,chain,
     1 IRES,X,Y,Z,PO,BI
      if(label.ne.ATOM.and.label.ne.hetatm) goto 100
C      if(ires.lt.ires1(ir)) goto 100
C      if(ires.gt.ires2(ir)) goto 120
      if(atnam.ne.' CA ') goto 100
      if(atnam.eq.' CA ') iat = 3*natom
      natom=natom+1
      reslist(natom)=res
      ireslist(natom)=ires
      xcoord(if,iat+1)=x
      xcoord(if,iat+2)=y
      xcoord(if,iat+3)=z
      goto 100
  120 continue
      write(6,1050) natom
  200 continue
C
      npt = 3*natom
      fnpt = npt
C
C     use the either the average or the first molecule as the reference
C
      do 210 iat=1,npt
      avex(iat)=0
      do 220 jf = 1,nfile
  220 avex(iat) = avex(iat) + xcoord(jf,iat)
  210 avex(iat) = avex(iat)/float(nfile)
C
C     comment accordingly to use average coords
C     include the write statement, but not the two following cards for "ave"
C     comment out the write card and include the next two cards to use x1
C
CX      write(6,1060)
      do 230 iat=1,npt
  230 avex(iat)=xcoord(1,iat)
C
C     need ntotal here so ALL coordinates have same reference state,
C     even though avex calculated from nfile coords
C
      do 300 iat = 1,npt
      do 320 if = 1,ntotal
  320 xcoord(if,iat) = xcoord(if,iat)-avex(iat)
  300 continue
C
C     calculate "length" of each vector
C
      do 330 if = 1,nfile
      xlen(if)=0.
      do 340 iat = 1,npt
  340 xlen(if) = xlen(if) + xcoord(if,iat)**2
      total = total + xlen(if)
      xlen(if) = sqrt(xlen(if)/float(natom))
  330 continue
      write(6, 1120) total,(xlen(if),if=1,nfile) 
C
C     calculate sum of distance squared between atoms
C
      do 500 ifile = 2,ntotal
      do 500 jfile = 1,ifile-1
      xrms(ifile,jfile)=0.
      do 510 iat = 1,npt
      del = (xcoord(ifile,iat)-xcoord(jfile,iat))
C
C     the following line shouldn't be needed with changes to use average x
C      if(jfile.eq.1) del=xcoord(ifile,iat)
C
  510 xrms(ifile,jfile) = xrms(ifile,jfile) + del**2
      xrms(ifile,jfile) = sqrt(xrms(ifile,jfile)/float(natom))
  500 continue
      write(6,1130)  
      do 520 ifile=2,ntotal
  520 write(6,1140) ifile,(xrms(ifile,j),j=1,ifile-1)     
      
C
C     now set up correlation matrix
C
      do 350 if1 = 1,npt
      do 350 if2 = 1,npt
      factor(if1,if2)=0.
      do 350 imol = 1,nfile
  350 factor(if1,if2) = factor(if1,if2) + 
     1 xcoord(imol,if1)*xcoord(imol,if2)
CZZ
      write(6,7100) npt,nfile
 7100 format(' *****correlation matrix set up (npt,nfile)', 2i8)
C
C     now get eigenvalues and eigenvectors
C     need to change to when arrays are redimensioned!!!!
C
      call mstr(factor,temp,1800,0,1)
      write(6,7110)
 7110 format(' *****mstr calculated')
      call eigen(temp,temp2,npt,0)
      write(6,7120)
 7120 format(' *****eigen calculated')
      call mstr(temp,eigv,npt,1,2)
      write(6,7130)
 7130 format(' *****eigenvecs calculated')
C
C     get eigenvectors sorted out
C
      do 360 i=1,npt
      do 360 j=1,npt
      ind = (j-1)*npt + i
  360 eigvec(i,j) = temp2(ind)
C
C     OK, now write out the first 20 eigenvalues 
C     and first 20 elements of first 5 ev
C
      write(6,1200) (eigv(i),i=1,20)
      total=0.
      do 370 i=1,npt
  370 total = total + eigv(i)
      write(6,1205) total
      if(idiag.ne.0) write(6,1210) ((eigvec(i,j),j=1,5),i=1,20)         
C
C     now, normalize first few eigenvectors 
C
      do 410 iv = 1,10
      fn = 0.
      do 420 jv = 1,npt
  420 fn = fn + eigvec(jv,iv)**2
      fn = sqrt(fn)
      do 430 jv = 1,npt
  430 fn_eigv(jv,iv) = eigvec(jv,iv)/fn
  410 continue
C
C     calculate average of first few eigenvectors onto xyz
C
      if(idiag.ne.0) write(6,1150)
      do 440 iv = 1,10
      do 442 i=1,3
  442 xproj(i) = 0.
      do 444 jv = 0,npt-3,3
      do 445 ind = 1,3      
  445 xproj(ind) = xproj(ind) + fn_eigv(jv+ind,iv)
  444 continue
      do 441 i = 1,3
  441 xproj(i) = xproj(i)/float(npt/3)
  440 if(idiag.ne.0) write(6,1160) iv,xproj
C
C     now, calculate projection of conformational change along these directions
C
      write(6,1300)
      do 450 ip = 1,ntotal
      do 460 iv = 1,10
      proj(iv) = 0.
      do 470 jv = 1,npt
  470 proj(iv) = proj(iv)+fn_eigv(jv,iv)*xcoord(ip,jv)
  460 continue
      if(ip.eq.nfile+1) write(6,1315)
      write(6,1310) ip,proj
      do 451 i=1,10
  451 evalcoef(ip,i)= proj(i)
  450 continue
C
C     now calculate rotation axis corresponding to transformation
C     for first ten eigenvectors
C
C     use the shift corresponding to the largest eigenvalue/vector
C
      trms = 0.
      ijmax = nfile+1
      xsft = 0.
      facts = 0.
      do 481 ij = 1,nfile
      if(xrms(ij,1).lt.trms) goto 481
      ijmax = ij
      xsft = xrms(ij,1)
      trms = xrms(ij,1)
      facts = evalcoef(ij,1)
  481 continue
      if(ijmax.eq.nfile+1.or.xsft.eq.0.) stop ' screwed up xsft...'
C      
      write(6,1400) xsft,facts
      iat=0
      do 590 i=1,natom
      do 590 j=1,3
      iat=iat+1
CX  590 yin(j,i) = xcoord(1,iat)
  590 yin(j,i) = avex(iat)
C
CZZ      do 600 iv=1,nfile-1
      do 600 iv = 1,10
      iat=0
      do 610 i=1,natom
      do 610 j=1,3
      iat=iat+1
      xin(j,i) = yin(j,i)+facts*fn_eigv(iat,iv)
      xpdb(iv,j,i)=xin(j,i)
  610 continue
      call rigid(natom,xin,yin,yrot,rot,d)
      call sphang(rot,phi,psi,cappa)
      rms=0.
      do 612 i=1,natom
      do 612 j=1,3
  612 rms = rms + (yin(j,i)-yrot(j,i))**2
      rms = sqrt(rms/float(natom))
C
      nbig=0
      do 620 i=1,natom
      del2=0.
      do 630 j=1,3
  630 del2 = del2 + (yin(j,i)-yrot(j,i))**2
      if(iv.gt.5.or.del2.lt.4.*rms) goto 620
      nbig=nbig+1
      if(nbig.gt.40) goto 620
      ibigat(nbig)=i
  620 continue
      call poldir(phi,psi,yax)
      screw = dot(yax,d)
      write(6,1410) iv,phi,psi,cappa,yax,d,rms,screw
C
C     output res with biggest deviations from rigid body rot
C
      if(iv.gt.5) goto 600
      if(nbig.gt.40) nbig = 40
      write(6,1420) nbig,(ireslist(ibigat(k)),k=1,nbig)
C
  600 continue
C
C     output selected number (.le.10) of eigenvector adjusted coords as PDB
C
      nv = 0
      nfirst=0
      occ=1.
      biso=50.
  700 write(6,1500)
      read(5,1020,end=799) filout
      write(6,1032) filout
      open(unit=9,name=filout,type='new',form='formatted')
C
C     output reference structure first
C
      if(nfirst.gt.0) goto 705
      do 706 i=1,natom
      x=yin(1,i)
      y=yin(2,i)
      z=yin(3,i)
      write(9,1100) atom,i,catom,reslist(i),chout,
     1 ireslist(i),x,y,z,occ,biso
  706 continue
      nfirst=1
      close(unit=9)
      goto 700
C      
C     output eigenvectors
C
  705 nv=nv+1
      do 710 i=1,natom
      x=xpdb(nv,1,i)
      y=xpdb(nv,2,i)
      z=xpdb(nv,3,i)
      write(9,1100) atom,i,catom,reslist(i),chout,
     1 ireslist(i),x,y,z,occ,biso
  710 continue
      close(unit=9)
      goto 700
  799 continue
C  
C     now calculate rms coord differences from eigenvector components
C     for the diagonal components, calculate the rms
C
      if(idiag.eq.0) goto 910
      write(6,1600)
      do 800 i=1,ntotal
      do 805 j=1,i
      rmsproj(j)=0.
      if(i.ne.j) goto 820
      do 810 k=1,10
  810 rmsproj(j) = rmsproj(j) + evalcoef(i,k)**2
      goto 802
  820 do 830 k=1,10
  830 rmsproj(j) = rmsproj(j) + (evalcoef(i,k) - evalcoef(j,k))**2
  802 rmsproj(j) = sqrt(rmsproj(j))*abs(xsft/facts)
  805 continue
      write(6,1610) i,(rmsproj(j),j=1,i)
  800 continue
      write(6,1620)
      do 840 i=1,ntotal
      do 845 j=1,i
      rmsproj(j)=0.
      if(i.ne.j) goto 860
      do 850 k=1,2
  850 rmsproj(j) = rmsproj(j) + evalcoef(i,k)**2
      goto 842
  860 do 870 k=1,2
  870 rmsproj(j) = rmsproj(j) + (evalcoef(i,k) - evalcoef(j,k))**2
  842 rmsproj(j) = sqrt(rmsproj(j))*abs(xsft/facts)
  845 continue
      write(6,1610) i,(rmsproj(j),j=1,i)
  840 continue
C
  910 continue
C  
 1000 FORMAT(' ESSDYN_BIG:  do principal component analysis:',/,
     1 ' input numbers of files for essdyn and extra analysis')
 1010 FORMAT(3i6)
 1012 format(' nfile, nextra, ntotal:',3i6,/,
     1 ' idiag (.ne.0 = yes)',i6,/)
 1020 format(a40)
 1030 FORMAT(' file',i4,2x,A40)
 1032 format(5x,a40)
 1040 format(2i8)
 1050 format(' atoms processed:',i8)
 1060 format(/,' ***** REFERENCE COORD = AVERAGE *****',/)
 1100 FORMAT(A6,I5,1X,A4,1x,A3,1x,a1,I4,4X,3F8.3,2F6.2)
 1120 format(' length of vectors (total sq/individual): ',
     1 f12.2,/,5(10f7.2,/))
 1130 format(/,' rms differences between coords:')
 1140 format(i5,20f5.1,/,3(5x,20f5.1,/))
 1150 format(' AVERAGE SHIFT in first 10 eigevectors along xyz:')
 1160 format(i6,3f8.4)
 1200 format(/,' EIGENVALUES:',/,10f12.1,/,10f12.1)
 1205 format(' sum of eigenvalues:',f12.1,/)
 1210 format(' EIGENVECTORS (first 20 elements of first 5 evs:',/,
     1 20(5f8.2,/))
 1300 format(/,' PROJECTIONS along first eigenvectors:')
 1310 format(i6,10f8.2)
 1315 format(/,' the following coordinates were not used in essdyn:',/)
 1400 format(//,' rotation corresponding to ',f5.1,' A rms; factor=:',
     1 f8.2,/,' vec, spherical angs, axis, d vec,  rms,   screw:')
 1410 format(/,i3,2x,3f7.2,2x,3f7.3,2x,3f7.1,2x,f5.2,2x,f6.2)
 1420 format(' bigdel (',i2,')',20i4,/,12x,20i4)
 1500 format(/,' OUTPUT PDB file corresponding to ESSDYN vectors:')
 1600 format(//,' test of rms dev calculation from all eigenvalues:',/)
 1620 format(//,' test of rms dev calculation from top2 eigenvalues:',/)
 1610 format(i4,20f5.1,/4x,20f5.1)
      stop
      end
C
C
C     subroutine rigid(npt,x,y,yr,rot,d)
C
C     given a model coordinate set x, with npt atoms
C     and a target set y, calculates the rotation matrix
C     rot and the translation vector d to minimize
C        y  =  rot*x  +  d
C
C       yr is the actual rotated/translated coordinates
C
C     based on Kabsch's algorithm
C
      subroutine rigid(npt,x,y,yr,rot,d)
      dimension y(3,400),yp(3,400),ycm(3),yr(3,400)
      dimension x(3,400),xp(3,400),xcm(3)
      dimension r(3,3),rtr(3,3),b(3,3),eigv(3),eigvec(3,3)
      dimension rot(3,3),d(3)
      dimension temp(9),b1(3),b2(3),b3(3)
      do 10 j=1,3
      xcm(j)=0.
      ycm(j)=0.
      do 15 i=1,npt
      xcm(j) = xcm(j) + x(j,i)
   15 ycm(j) = ycm(j) + y(j,i)
      xcm(j) = xcm(j)/float(npt)
   10 ycm(j) = ycm(j)/float(npt)
      do 20 i=1,npt
      do 20 j=1,3
      yp(j,i) = y(j,i) - ycm(j)
   20 xp(j,i) = x(j,i) - xcm(j)
C
C     set up R matrix and RTR
C
      do 30 i=1,3
      do 30 j=1,3
      r(i,j)=0.
      do 35 k=1,npt
   35 r(i,j) = r(i,j) + yp(i,k)*xp(j,k)
   30 continue
      do 40 i=1,3
      do 40 j=1,3
      rtr(i,j)=0.
      do 45 k=1,3
   45 rtr(i,j) = rtr(i,j) + r(k,i)*r(k,j)
   40 continue
C
C     now get eigenvalues and eigenvectors
C
      call mstr(rtr,temp,3,0,1)
      call eigen(temp,eigvec,3,0)
      call mstr(temp,eigv,3,1,2)
C
C     EIGEN returns eigenvalues sorted in descending fashion
C     set up a3 = a1 x a2
C
      if(eigv(3).le.0.00001) eigv(3) = 1.
      eigvec(1,3) = eigvec(2,1)*eigvec(3,2) - eigvec(2,2)*eigvec(3,1)
      eigvec(2,3) = eigvec(3,1)*eigvec(1,2) - eigvec(1,1)*eigvec(3,2)
      eigvec(3,3) = eigvec(1,1)*eigvec(2,2) - eigvec(2,1)*eigvec(1,2)
C
C     Now, get b vectors  = R ak / sqrt(eigval)
C
      do 50 k=1,3
      do 60 i=1,3
      b(i,k)=0.
      do 60 j=1,3
   60 b(i,k) = b(i,k) + r(i,j)*eigvec(j,k)/sqrt(eigv(k))
   50 continue
C
C     now, get b3 = b1 x b2
C
      dis1=0.
      dis2=0.
      do 76 i = 1,3
      b1(i) = b(i,1)
      dis1 = dis1 + b1(i)*b1(i)
      b2(i) = b(i,2)
      dis2 = dis2 + b2(i)*b2(i)
   76 b3(i) = b(i,3)
      dis1 = sqrt(dis1)
      dis2 = sqrt(dis2)
      do 75 i=1,3
      b1(i) = b1(i)/dis1
   75 b2(i) = b2(i)/dis2
      b3(1) = b1(2)*b2(3) - b2(2)*b1(3)
      b3(2) = b1(3)*b2(1) - b1(1)*b2(3)
      b3(3) = b1(1)*b2(2) - b1(2)*b2(1)
C
C     check b3 * Ra3
C
      dot = 0.
      do 77 i = 1,3
   77 dot = dot + b(i,3)*b3(i)
      if(dot.gt.0) goto 79
      do 78 i=1,3
   78 b(i,3) = -b(i,3)      
   79 continue
C
C     now, get u = b*a
C
      do 80 i = 1,3
      do 80 j = 1,3
      rot(i,j)=0.
      do 85 k = 1,3
   85 rot(i,j) = rot(i,j) + b(i,k)*eigvec(j,k)
   80 continue
C
C     translation vector
C
      do 90 i = 1,3
      d(i)=0.
      do 95 j = 1,3
   95 d(i) = d(i) - rot(i,j)*xcm(j)
   90 d(i) = d(i) + ycm(i)
      do 200 in = 1,npt
      do 220 i = 1,3
      yr(i,in) = d(i)
      do 220 j = 1,3
  220 yr(i,in)  = yr(i,in) + rot(i,j)*x(j,in)
  200 continue
      return
      end
      subroutine sphang(u,phi,psi,cappa)
      dimension u(3,3)
      dtor = 3.1415926/180.
C
C     CALCULATE SPHERICAL ANGLES from u matrix
C
      r1=u(1,1)
      r2=u(2,2)
      r3=u(3,3)
      if(abs(r1).gt.0.99999.and.abs(r2).gt.0.99999.
     1 and.abs(r3).gt.0.99999) goto 480
      A=U(2,1)-U(1,2)
      BB=U(2,3)-U(3,2)
      if(abs(a).lt.0.0001.and.abs(bb).lt.0.0001) goto 100
      CALL ARCTAN(PHI,A,BB)
      goto 110
  100 continue
      a = -u(2,3)
      bb = u(1,2)
      call arctan(phi,a,bb)
  110 continue
      SINPHI=SIN(PHI*3.14159/180.)
      IF(abs(SINPHI).lt.0.0001) GOTO 430
      A=(U(2,1)-U(1,2))/SINPHI
      BB=U(3,1)-U(1,3)
      if(abs(a).lt.0.0001.and.abs(bb).lt.0.0001) goto 200
      CALL ARCTAN(PSI,A,BB)
      GOTO 440
  430 A=(U(2,3)-U(3,2))/COS(PHI*DTOR)
      BB=U(3,1)-U(1,3)
      CALL ARCTAN(PSI,A,BB)
      goto 210
  200 continue
      if(abs(sin(phi*dtor)).lt.0.0001) goto 202
      a = u(3,1)/sin(phi*dtor)
      bb = -u(1,2)
      goto 204
  202 a = u(3,1)/cos(phi*dtor)
      bb = u(2,3)
  204 call arctan(psi,a,bb)
  210 continue
  440 DEN=U(1,1)+U(2,2)+U(3,3)-1.
      IF(abs(COS(PSI*DTOR)).lt.0.0001) GOTO 450
      A=-(U(3,1)-U(1,3))/COS(PSI*DTOR)
      CALL ARCTAN(CAPPA,A,DEN)
      GOTO 490
  450 IF(abs(SIN(PSI*DTOR)*SIN(PHI*DTOR)).lt.0.0001) GOTO 460
      A=-(U(2,1)-U(1,2))/(SIN(PSI*DTOR)*SIN(PHI*DTOR))
      CALL ARCTAN(CAPPA,A,DEN)
      GOTO 490
  460 IF(abs(SIN(PSI*DTOR)*COS(PHI*DTOR)).lt.0.0001) GOTO 470
      A=-(U(2,3)-U(3,2))/(SIN(PSI*DTOR)*COS(PHI*DTOR))
      CALL ARCTAN(CAPPA,A,DEN)
      GOTO 490
  470 CAPPA = -999.
      goto 490
  480 continue
      if(r1.lt.0.or.r2.lt.0.or.r3.lt.0) goto 485
      phi=0.
      psi=0.
      cappa=0.
      goto 490
  485 if(r1.lt.0) goto 486
      phi=0.
      psi=90.
      cappa=180.
      goto 490
  486 if(r2.lt.0) goto 487
      phi=0.
      psi=0.
      cappa=180.
      goto 490
  487 if(r3.lt.0) stop ' sphang has a problem'
      phi=90.
      psi=90.
      cappa=180.
  490 continue
      return
      end
C
      FUNCTION DOT(A,B)
C
C     GIVES DOT PRODUCT OF A AND B
C
      DIMENSION A(3),B(3)
      DOT=0.0
      DO 10 I=1,3
   10 DOT=DOT+A(I)*B(I)
      RETURN
      END
C
      subroutine poldir(a1,a2,x)
C
C     convert phi, psi to x,y,z components of normal vector
C     note: since psi is measured from y and phi from x,
C     z corresponds to phi = -90, psi = 90
C     this is why x(3) has a negative sign in its expression
C
C     a1 is phi (equatorial) from X
C     a2 is psi (polar)  from Y
C
      dimension x(3)
      dtor = 3.1415926/180.
      ca1 = cos(a1*dtor)
      sa1 = sin(a1*dtor)
      ca2 = cos(a2*dtor)
      sa2 = sin(a2*dtor)
      x(1) = ca1*sa2
      x(2) = ca2
      x(3) = -sa1*sa2
      return
      end
C
C     SUBROUTINE ARCTAN(ANG,A,B)
C
C     CALCULATES THE ARCTAN OF A/B, PLACES IN PROPER QUADRANT,
C     AND RETURNS THE ANGLE IN DEGREES
C
      SUBROUTINE ARCTAN(ANG,A,B)
      DATA RTOD/57.2958/
      X=ABS(A)
      Y=ABS(B)
      IF(A.EQ.0.0.OR.B.EQ.0.0) GOTO 100
      ANG=ATAN2(X,Y)
      ANG=ANG*RTOD
      IF(B.LT.0.) GOTO 50
      IF(A.LT.0.) ANG=360.-ANG
      RETURN
   50 IF(A.LT.0.) ANG=180.+ANG
      IF(A.GT.0.) ANG=180.-ANG
      RETURN
  100 IF(A.EQ.0.AND.B.EQ.0.) GOTO 200
      IF(B.EQ.0.) GOTO 150
      IF(B.GT.0.) ANG=0.
      IF(B.LT.0.) ANG=180.
      RETURN
  150 IF(A.GT.0.) ANG=90.
      IF(A.LT.0.) ANG=270.
      RETURN
  200 WRITE(6,1000)
      ANG=0.
 1000 FORMAT(' ERROR IN ARCTAN: A AND B EQUAL 0.')
      RETURN
      END
C
C     ..................................................................
C
C        SUBROUTINE EIGEN
C
C        PURPOSE
C           COMPUTE EIGENVALUES AND EIGENVECTORS OF A REAL SYMMETRIC
C           MATRIX
C
C        USAGE
C           CALL EIGEN(A,R,N,MV)
C
C        DESCRIPTION OF PARAMETERS
C           A - ORIGINAL MATRIX (SYMMETRIC), DESTROYED IN COMPUTATION.
C               RESULTANT EIGENVALUES ARE DEVELOPED IN DIAGONAL OF
C               MATRIX A IN DESCENDING ORDER.
C           R - RESULTANT MATRIX OF EIGENVECTORS (STORED COLUMNWISE,
C               IN SAME SEQUENCE AS EIGENVALUES)
C           N - ORDER OF MATRICES A AND R
C           MV- INPUT CODE
C                   0   COMPUTE EIGENVALUES AND EIGENVECTORS
C                   1   COMPUTE EIGENVALUES ONLY (R NEED NOT BE
C                       DIMENSIONED BUT MUST STILL APPEAR IN CALLING
C                       SEQUENCE)
C
C        REMARKS
C           ORIGINAL MATRIX A MUST BE REAL SYMMETRIC (STORAGE MODE=1)
C           MATRIX A CANNOT BE IN THE SAME LOCATION AS MATRIX R
C
C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED
C           NONE
C
C        METHOD
C           DIAGONALIZATION METHOD ORIGINATED BY JACOBI AND ADAPTED
C           BY VON NEUMANN FOR LARGE COMPUTERS AS FOUND IN 'MATHEMATICAL
C           METHODS FOR DIGITAL COMPUTERS', EDITED BY A. RALSTON AND
C           H.S. WILF, JOHN WILEY AND SONS, NEW YORK, 1962, CHAPTER 7
C
C     ..................................................................
C
      SUBROUTINE EIGEN(A,R,N,MV)
      DIMENSION A(1),R(1)
C
C        ...............................................................
C
C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THE
C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION
C        STATEMENT WHICH FOLLOWS.
C
C      DOUBLE PRECISION A,R,ANORM,ANRMX,THR,X,Y,SINX,SINX2,COSX,
C     1                 COSX2,SINCS,RANGE
C
C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTS
C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS
C        ROUTINE.
C
C        THE DOUBLE PRECISION VERSION OF THIS SUBROUTINE MUST ALSO
C        CONTAIN DOUBLE PRECISION FORTRAN FUNCTIONS.  SQRT IN STATEMENTS
C        40, 68, 75, AND 78 MUST BE CHANGED TO DSQRT.  ABS IN STATEMENT
C        62 MUST BE CHANGED TO DABS. THE CONSTANT IN STATEMENT 5 SHOULD
C        BE CHANGED TO 1.0D-12.
C
C        ...............................................................
C
C        GENERATE IDENTITY MATRIX
C
    5 RANGE=1.0E-6
      IF(MV-1) 10,25,10
   10 IQ=-N
      DO 20 J=1,N
      IQ=IQ+N
      DO 20 I=1,N
      IJ=IQ+I
      R(IJ)=0.0
      IF(I-J) 20,15,20
   15 R(IJ)=1.0
   20 CONTINUE
C
C        COMPUTE INITIAL AND FINAL NORMS (ANORM AND ANORMX)
C
   25 ANORM=0.0
      DO 35 I=1,N
      DO 35 J=I,N
      IF(I-J) 30,35,30
   30 IA=I+(J*J-J)/2
      ANORM=ANORM+A(IA)*A(IA)
   35 CONTINUE
      IF(ANORM) 165,165,40
   40 ANORM=1.414*SQRT(ANORM)
      ANRMX=ANORM*RANGE/FLOAT(N)
C
C        INITIALIZE INDICATORS AND COMPUTE THRESHOLD, THR
C
      IND=0
      THR=ANORM
   45 THR=THR/FLOAT(N)
   50 L=1
   55 M=L+1
C
C        COMPUTE SIN AND COS
C
   60 MQ=(M*M-M)/2
      LQ=(L*L-L)/2
      LM=L+MQ
   62 IF(ABS(A(LM))-THR) 130,65,65
   65 IND=1
      LL=L+LQ
      MM=M+MQ
      X=0.5*(A(LL)-A(MM))
   68 Y=-A(LM)/SQRT(A(LM)*A(LM)+X*X)
      IF(X) 70,75,75
   70 Y=-Y
   75 SINX=Y/SQRT(2.0*(1.0+( SQRT(1.0-Y*Y))))
      SINX2=SINX*SINX
   78 COSX=SQRT(1.0-SINX2)
      COSX2=COSX*COSX
      SINCS =SINX*COSX
C
C        ROTATE L AND M COLUMNS
C
      ILQ=N*(L-1)
      IMQ=N*(M-1)
      DO 125 I=1,N
      IQ=(I*I-I)/2
      IF(I-L) 80,115,80
   80 IF(I-M) 85,115,90
   85 IM=I+MQ
      GO TO 95
   90 IM=M+IQ
   95 IF(I-L) 100,105,105
  100 IL=I+LQ
      GO TO 110
  105 IL=L+IQ
  110 X=A(IL)*COSX-A(IM)*SINX
      A(IM)=A(IL)*SINX+A(IM)*COSX
      A(IL)=X
  115 IF(MV-1) 120,125,120
  120 ILR=ILQ+I
      IMR=IMQ+I
      X=R(ILR)*COSX-R(IMR)*SINX
      R(IMR)=R(ILR)*SINX+R(IMR)*COSX
      R(ILR)=X
  125 CONTINUE
      X=2.0*A(LM)*SINCS
      Y=A(LL)*COSX2+A(MM)*SINX2-X
      X=A(LL)*SINX2+A(MM)*COSX2+X
      A(LM)=(A(LL)-A(MM))*SINCS+A(LM)*(COSX2-SINX2)
      A(LL)=Y
      A(MM)=X
C
C        TESTS FOR COMPLETION
C
C        TEST FOR M = LAST COLUMN
C
  130 IF(M-N) 135,140,135
  135 M=M+1
      GO TO 60
C
C        TEST FOR L = SECOND FROM LAST COLUMN
C
  140 IF(L-(N-1)) 145,150,145
  145 L=L+1
      GO TO 55
  150 IF(IND-1) 160,155,160
  155 IND=0
      GO TO 50
C
C        COMPARE THRESHOLD WITH FINAL NORM
C
  160 IF(THR-ANRMX) 165,165,45
C
C        SORT EIGENVALUES AND EIGENVECTORS
C
  165 IQ=-N
      DO 185 I=1,N
      IQ=IQ+N
      LL=I+(I*I-I)/2
      JQ=N*(I-2)
      DO 185 J=I,N
      JQ=JQ+N
      MM=J+(J*J-J)/2
      IF(A(LL)-A(MM)) 170,185,185
  170 X=A(LL)
      A(LL)=A(MM)
      A(MM)=X
      IF(MV-1) 175,185,175
  175 DO 180 K=1,N
      ILR=IQ+K
      IMR=JQ+K
      X=R(ILR)
      R(ILR)=R(IMR)
  180 R(IMR)=X
  185 CONTINUE
      RETURN
      END


C
C     ..................................................................
C
C        SUBROUTINE MSTR
C
C        PURPOSE
C           CHANGE STORAGE MODE OF A MATRIX
C
C        USAGE
C           CALL MSTR(A,R,N,MSA,MSR)
C
C        DESCRIPTION OF PARAMETERS
C           A - NAME OF INPUT MATRIX
C           R - NAME OF OUTPUT MATRIX
C           N - NUMBER OF ROWS AND COLUMNS IN A AND R
C           MSA - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A
C                  0 - GENERAL
C                  1 - SYMMETRIC
C                  2 - DIAGONAL
C           MSR - SAME AS MSA EXCEPT FOR MATRIX R
C
C        REMARKS
C           MATRIX R CANNOT BE IN THE SAME LOCATION AS MATRIX A
C           MATRIX A MUST BE A SQUARE MATRIX
C
C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED
C           LOCa
C
C        METHOD
C           MATRIX A IS RESTRUCTURED TO FORM MATRIX R.
C            MSA MSR
C             0   0  MATRIX A IS MOVED TO MATRIX R
C             0   1  THE UPPER TRIANGLE ELEMENTS OF A GENERAL MATRIX
C                    ARE USED TO FORM A SYMMETRIC MATRIX
C             0   2  THE DIAGONAL ELEMENTS OF A GENERAL MATRIX ARE USED
C                    TO FORM A DIAGONAL MATRIX
C             1   0  A SYMMETRIC MATRIX IS EXPANDED TO FORM A GENERAL
C                    MATRIX
C             1   1  MATRIX A IS MOVED TO MATRIX R
C             1   2  THE DIAGONAL ELEMENTS OF A SYMMETRIC MATRIX ARE
C                    USED TO FORM A DIAGONAL MATRIX
C             2   0  A DIAGONAL MATRIX IS EXPANDED BY INSERTING MISSING
C                    ZERO ELEMENTS TO FORM A GENERAL MATRIX
C             2   1  A DIAGONAL MATRIX IS EXPANDED BY INSERTING MISSING
C                    ZERO ELEMENTS TO FORM A SYMMETRIC MATRIX
C             2   2  MATRIX A IS MOVED TO MATRIX R
C
C     ..................................................................
C
      SUBROUTINE MSTR(A,R,N,MSA,MSR)
C      IMPLICIT DOUBLE PRECISION (A-H),(O-Z)
      DIMENSION A(1),R(1)
C
      DO 20 I=1,N
      DO 20 J=1,N
C
C        IF R IS GENERAL, FORM ELEMENT
C
      IF(MSR) 5,10,5
C
C        IF IN LOWER TRIANGLE OF SYMMETRIC OR DIAGONAL R, BYPASS
C
    5 IF(I-J) 10,10,20
   10 CALL LOCa(I,J,IR,N,N,MSR)
C
C        IF IN UPPER AND OFF DIAGONAL  OF DIAGONAL R, BYPASS
C
      IF(IR) 20,20,15
C
C        OTHERWISE, FORM R(I,J)
C
   15 R(IR)=0.0
      CALL LOCa(I,J,IA,N,N,MSA)
C
C        IF THERE IS NO A(I,J), LEAVE R(I,J) AT 0.0
C
      IF(IA) 20,20,18
   18 R(IR)=A(IA)
   20 CONTINUE
      RETURN
      END


C
C     ..................................................................
C
C        SUBROUTINE LOCa
C
C        PURPOSE
C           COMPUTE A VECTOR SUBSCRIPT FOR AN ELEMENT IN A MATRIX OF
C           SPECIFIED STORAGE MODE
C
C        USAGE
C           CALL LOCa (I,J,IR,N,M,MS)
C
C        DESCRIPTION OF PARAMETERS
C           I   - ROW NUMBER OF ELEMENT
C           J   - COLUMN NUMBER  OF ELEMENT
C           IR  - RESULTANT VECTOR SUBSCRIPT
C           N   - NUMBER OF ROWS IN MATRIX
C           M   - NUMBER OF COLUMNS IN MATRIX
C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX
C                  0 - GENERAL
C                  1 - SYMMETRIC
C                  2 - DIAGONAL
C
C        REMARKS
C           NONE
C
C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED
C           NONE
C
C        METHOD
C           MS=0   SUBSCRIPT IS COMPUTED FOR A MATRIX WITH N*M ELEMENTS
C                  IN STORAGE (GENERAL MATRIX)
C           MS=1   SUBSCRIPT IS COMPUTED FOR A MATRIX WITH N*(N+1)/2 IN
C                  STORAGE (UPPER TRIANGLE OF SYMMETRIC MATRIX). IF
C                  ELEMENT IS IN LOWER TRIANGULAR PORTION, SUBSCRIPT IS
C                  CORRESPONDING ELEMENT IN UPPER TRIANGLE.
C           MS=2   SUBSCRIPT IS COMPUTED FOR A MATRIX WITH N ELEMENTS
C                  IN STORAGE (DIAGONAL ELEMENTS OF DIAGONAL MATRIX).
C                  IF ELEMENT IS NOT ON DIAGONAL (AND THEREFORE NOT IN
C                  STORAGE), IR IS SET TO ZERO.
C
C     ..................................................................
C
      SUBROUTINE LOCa(I,J,IR,N,M,MS)
C
C      IMPLICIT DOUBLE PRECISION (A-H),(O-Z)
      IX=I
      JX=J
      IF(MS-1) 10,20,30
   10 IRX=N*(JX-1)+IX
      GO TO 36
   20 IF(IX-JX) 22,24,24
   22 IRX=IX+(JX*JX-JX)/2
      GO TO 36
   24 IRX=JX+(IX*IX-IX)/2
      GO TO 36
   30 IRX=0
      IF(IX-JX) 36,32,36
   32 IRX=IX
   36 IR=IRX
      RETURN
      END
