function [inst_speed,msd]=CellMigrationQuantification(cell)

global upper_t dt;

%% Instantaneous speed distribution
mat1=cell(:,2:upper_t,:)-cell(:,1:upper_t-1,:);
inst_dist=sqrt(dot(mat1,mat1,3)); % instantaneous displacement
speed_mean=nanmean(inst_dist,2)/dt;

[id tmax]=size(inst_dist);
inst_speed(1:id*tmax,1:tmax)=nan;

for t=1:tmax
    mat=reshape(inst_dist(:,1:t)/dt,[],1);
    len=length(mat);
    inst_speed(1:len,t)=mat;
end


%% MSD
msd_dist=dot(cell,cell,3);
msd=nanmean(msd_dist,1);

end
