function GraphMSD(msd0, msd1)

global dt;

fittrange=11; % corresponding to first 5 min
graphrange=12;

%% MSD fitting
tlen0=length(msd0);
tlen1=length(msd1);
t0=[0:tlen0-1]*dt; % 30sec/frame
t1=[0:tlen1-1]*dt; % 30sec/frame

xinit = [1 1]; % initial values of parameters

ft0=t0(1:fittrange);
fmsd0=msd0(1:fittrange);
F = @(x0,xdata) x0(1)*(xdata).^x0(2);
[x0,resnorm,~,exitflag,output] = lsqcurvefit(F,xinit,ft0,fmsd0);

ft1=t1(1:fittrange);
fmsd1=msd1(1:fittrange);
F = @(x1,xdata) x1(1)*(xdata).^x1(2);
[x1,resnorm,~,exitflag,output] = lsqcurvefit(F,xinit,ft1,fmsd1);

x1;
x0;

figure,
hold on
plot(ft0,F(x0,ft0), '--b', 'LineWidth',2.0)
plot(ft0,fmsd0, '-b', 'LineWidth',2.0)
plot(t0(1:graphrange),msd0(1:graphrange),'-b', 'LineWidth',2.0)
plot(ft1,F(x1,ft1), '--r',  'LineWidth',2.0)
plot(ft1,fmsd1, '-r', 'LineWidth',2.0);
plot(t1(1:graphrange),msd1(1:graphrange),'-r', 'LineWidth',2.0)
hold off
title('MSD (linear scale)')

figure,
hold on
%        plot(log10(ft0),log10(F(x0,ft0)), '--b', 'LineWidth',2.0)
plot(log10(ft0),log10(fmsd0), '-b', 'LineWidth',2.0)
plot(log10(t0(1:graphrange)),log10(msd0(1:graphrange)),'-b', 'LineWidth',2.0)
%       plot(log10(ft1),log10(F(x1,ft1)), '--r',  'LineWidth',2.0)
plot(log10(ft1),log10(fmsd1), '-r', 'LineWidth',2.0)
plot(log10(t1(1:graphrange)),log10(msd1(1:graphrange)),'-r', 'LineWidth',2.0)
hold off
xlim([-0.5 1.0])
ylim([2.0 3.5])
axis square
title('MSD (log scale)')

end