function VisualizeTrajectory(ncell, indx)

global upper_t;

sample_numb=size(ncell,1);
idx = randperm(sample_numb, sample_numb);

tmp_cell=ncell(idx,:,:);

figure,
tmax=upper_t;
tsize=30;
tstep=round((tmax-1)/tsize);
cmap=colormap(cool);
len=length(cmap);

hold on
for tindx=1:tsize
    t1=1+(tindx-1)*tstep;
    t2=1+(tindx)*tstep;
    if t2>tmax
        t2=tmax;
    end
    
    for id=1:sample_numb
        p=plot(tmp_cell(id,t1:t2,1),tmp_cell(id,t1:t2,2),'-');
        p.Color=cmap(round(tindx/tsize*len),:);
        p.LineWidth=1.0;
    end
    
    tmp=150;
    xlim([-tmp tmp])
    ylim([-tmp tmp])
    axis square
    colorbar
end
hold off

switch indx
    case 0
        title('Trajectory of NK cells without cancers')
    case 1
        title('Trajectory of NK cells with cancers')
    case 2
        title('Trajectory of cancers')
end

end