%% Supplementary Table. Ichise et al. 20191018

% Units [m, g, min, cell].  '_cu' stands for conventional unit.

clear;
% Field of View
    FOV = 2.5e-7;        % Area of Field of View (FOV); 0.5x0.5 mm, 
    
% Lung and blood
    Bv = 1.7e-6;        % blood volume; Davies, 1993. Table II
    Lv = 3.73e-7;       % lung volume; Gomes, 2019. Fig. 2A
    
% Cardiac output: Janssen, 2001
    CO_cu = 20; % mL/min
    CO = CO_cu*1e-6; % cardiac output of a mouse
 
%%
% Platelet velocity: used as blood flow speed [m/min], determined according to Sano, 2017.
    PL_speed_cu = 945;              % flow speed of platelets in lung capillaries [um/sec]
    Pl_speed = PL_speed_cu*1e-6*60; % flow speed of platelets in lung capillaries  
    
% Pulmonary caplillary: 
    Cp_l = 1.13e3;                  % capillary length, total [m] Knust, 2009  
    Cp_r = 3.4e-6;                  % capillary radius [m]
    Cp_fr = Pl_speed*pi*Cp_r^2;     % capillary flow rate [m^3/min]

% NK cells: This study
    NK_d = 10e-6;                   % mean diameter of NK cells determined on the images.
    NK_bl_cu = 5.1e4;               % total number of CD3-NK1.1+ cells. Mean of three C57BL/6 mice. [/mL] 
    NK_bl = NK_bl_cu*1e6;           % NK cell density in peripheral blood [cells/m^3]
    NK_wbl = NK_bl*Bv;              % NK cell number in whole blood.
    NK_FOV = 16;                    % the number of NK cells in an FOV. Mean of three C57BL/6 mice.    
    NK_speed_cu = 4.8;              % instantaneous speed cum tumor (Fig. 4E). [um/min]
    NK_speed= NK_speed_cu*1e-6;     % instantaneous speed cum tumor (Fig. 4E). [um/min]
    NK_hit_obs= 0.0080;             % Observed NK cell hit probabillity (Fig. 4); calcurated by Main.m [cells/min]
    NK_kill = 0.5;                  % NK cell killing probability (Fig. 5D) []
    
% NK cells: Calculated    
    NK_density = NK_FOV/FOV/NK_d;   % NK cell density in the lung [cells/m^3]
    NK_lung = NK_density*Lv;        % Total number of lung NK cells per a mouse [cell]
    NK_in = CO*NK_bl;               % NK cell influx into the lung [cells/min]
    NK_out = NK_in/NK_lung;         % NK cell decay constant in lung [/min]
    NK_hl = log(2)/NK_out;          % NK cell half-life in lung [min]
    NK_fr = NK_bl*Cp_fr;            % NK cell flow rate in a capillary [cells/min/capillary]    
    NK_dcp = NK_lung/Cp_l;          % NK cells density on the capillary [cells/m]
    NK_hit_cr = NK_dcp*NK_speed;    % Crawling NK cell hit probability [cells/min/capillary]
    NK_hit_cr_cu = NK_hit_cr*60;    % Crawling NK cell hit probability [cells/hour/capillary]
     
% Melanoma cells: 
    Ml_t_BLI = 4.7e-3;              % Melanoma decay constant. Melanoma decreased (Fig.1)
    Ml_hl_BLI = log(2)/Ml_t_BLI;    %  Melanoma half life basd on BLI data. [min]
    Ml_t_2P_obs = NK_kill * NK_hit_obs;     % Melanoma decay constant calculated from observed hit probability. [/min]
    Ml_hl_2P_obs = log(2)/Ml_t_2P_obs;      % Melanoma half life calculated. calculated from observed hit probability. [min]
    Ml_t_2P_crsp = NK_kill * NK_hit_cr;     % Melanoma decay constant based on crawling speed. [/mim]
    Ml_hl_2P_crsp = log(2)/Ml_t_2P_crsp;    % Melanoma half life based on crawling speed. [min]%