function cnt_in=HitCancer(nk, cancer, inner, outer)

[m1, ~, ~]=size(nk);
[m2, max_time, ~]=size(cancer);

% Initial settings
flag_in=zeros(m2,m1); % 1: within cancer territory, 0: otherwise
cnt_mat=zeros(m2,m1); % count matrix

%% 191014 added
for t=1:max_time
    %    disp(t)
    
    % Distance matrix between NK and cancer cells
    tmp_nk(1:m1,1:3)=nk(1:m1,t,1:3);
    tmp_cancer(1:m2,1:3)=cancer(1:m2,t,1:3);
    
    for r=1:3  % x, y, z
        mat1(:,:,r) = repmat(tmp_nk(1:m1,r),[1 m2]);
        mat2(:,:,r) = repmat(tmp_cancer(1:m2,r)',[m1 1]);
    end
    distmat=sqrt((mat1(:,:,1)-mat2(:,:,1)).^2 + (mat1(:,:,2)-mat2(:,:,2)).^2 + (mat1(:,:,3)-mat2(:,:,3)).^2);
    distmat=distmat';
    
    inside_mat=distmat<=inner; % Note that the nk cell is inside of "inner domain" of a cancer cell.
    outside_mat=distmat>outer; % Note that the nk cell is outside of "outer domain" of a cancer cell.
    
    %    if cancer_numb>0 % This is for the data #7
    
    % For the cells outside, go in or not
    mat_in=(flag_in==0 & inside_mat==1);  % Moved from outside (flag_in==0) to inside (inside_mat==0)
    flag_in(logical(mat_in))=1;
    cnt_mat=cnt_mat+double(mat_in); % Updating the NK-hit in each cancer
    
    % For the cells inside, go out or not
    mat_out=(flag_in==1 & outside_mat==1); % Moved from inside (flag_in==1) to outside (outside_mat==1)
    flag_in(logical(mat_out))=0;
    
    %    end
end

cnt_in=sum(cnt_mat,2); % sum up NK cells that hit a tumor cell
%sort(cnt_in)
%figure, bar(sort(cnt_in))

end
