load('f6.mat')

figure

x1 = 1;
x2 = 2;
x3 = 3;
tilt = 0.1;

npoints = length(simpl_pomdp);
m  = mean(simpl_pomdp([1:npoints],:));
sd = std(simpl_pomdp([1:npoints],:));
se = sd / (npoints-1);
    
plot([x1 x1],[m(1)-se(1) m(1)-sd(1)],'--','color',[0 0.45 0.7],'linewidth',4)    
hold all 
plot([x1 x1],[m(1)+se(1) m(1)+sd(1)],'--','color',[0 0.45 0.7],'linewidth',4)    
patch([x1-tilt x1+tilt x1+tilt x1-tilt],[m(1)-se(1) m(1)-se(1) m(1)+se(1) m(1)+se(1)],[0 0.45 0.74],'facecolor','none','linestyle','-','linewidth',3,'edgecolor',[0 0.45 0.74])       
plot([x1-tilt x1+tilt],[m(1) m(1)],'-','color',[0 0.45 0.74],'markersize',10,'linewidth',2)   

plot([x2 x2],[m(2)-se(2) m(2)-sd(2)],'--','color',[0 0.45 0.7],'linewidth',4)    
plot([x2 x2],[m(2)+se(2) m(2)+sd(2)],'--','color',[0 0.45 0.7],'linewidth',4)    
patch([x2-tilt x2+tilt x2+tilt x2-tilt],[m(2)-se(2) m(2)-se(2) m(2)+se(2) m(2)+se(2)],[0 0.45 0.74],'facecolor','none','linestyle','-','linewidth',3,'edgecolor',[0 0.45 0.74])       
plot([x2-tilt x2+tilt],[m(2) m(2)],'-','color',[0 0.45 0.74],'markersize',10,'linewidth',2)   

plot([x3 x3],[m(3)-se(3) m(3)-sd(3)],'--','color',[0 0.45 0.7],'linewidth',4)    
plot([x3 x3],[m(3)+se(3) m(3)+sd(3)],'--','color',[0 0.45 0.7],'linewidth',4)    
patch([x3-tilt x3+tilt x3+tilt x3-tilt],[m(3)-se(3) m(3)-se(3) m(3)+se(3) m(3)+se(3)],[0 0.45 0.74],'facecolor','none','linestyle','-','linewidth',3,'edgecolor',[0 0.45 0.74])       
plot([x3-tilt x3+tilt],[m(3) m(3)],'-','color',[0 0.45 0.74],'markersize',10,'linewidth',2)   

xlim([0 4])
ylim([0 700])
xticks([1 2 3])
title("simplified POMDP")
set(gca,'fontsize',28)


figure

x1 = 1;
x2 = 2;
x3 = 3;
tilt = 0.1;

npoints = length(full_pomdp);
m  = mean(full_pomdp([1:npoints],:));
sd = std(full_pomdp([1:npoints],:));
se = sd / (npoints-1);


    
plot([x1 x1],[m(1)-se(1) m(1)-sd(1)],'--','color',[0.9,0.69,0.13],'linewidth',4)    
hold all 
plot([x1 x1],[m(1)+se(1) m(1)+sd(1)],'--','color',[0.9,0.69,0.13],'linewidth',4)    
patch([x1-tilt x1+tilt x1+tilt x1-tilt],[m(1)-se(1) m(1)-se(1) m(1)+se(1) m(1)+se(1)],[0.93,0.69,0.13],'facecolor','none','linestyle','-','linewidth',3,'edgecolor',[0.93,0.69,0.13])       
plot([x1-tilt x1+tilt],[m(1) m(1)],'-','color',[0.93,0.69,0.13],'markersize',10,'linewidth',2)   

plot([x2 x2],[m(2)-se(2) m(2)-sd(2)],'--','color',[0.9,0.69,0.13],'linewidth',4)    
plot([x2 x2],[m(2)+se(2) m(2)+sd(2)],'--','color',[0.9,0.69,0.13],'linewidth',4)    
patch([x2-tilt x2+tilt x2+tilt x2-tilt],[m(2)-se(2) m(2)-se(2) m(2)+se(2) m(2)+se(2)],[0.93,0.69,0.13],'facecolor','none','linestyle','-','linewidth',3,'edgecolor',[0.93,0.69,0.13])       
plot([x2-tilt x2+tilt],[m(2) m(2)],'-','color',[0.93,0.69,0.13],'markersize',10,'linewidth',2)   

plot([x3 x3],[m(3)-se(3) m(3)-sd(3)],'--','color',[0.9,0.69,0.13],'linewidth',4)    
plot([x3 x3],[m(3)+se(3) m(3)+sd(3)],'--','color',[0.9,0.69,0.13],'linewidth',4)    
patch([x3-tilt x3+tilt x3+tilt x3-tilt],[m(3)-se(3) m(3)-se(3) m(3)+se(3) m(3)+se(3)],[0.93,0.69,0.13],'facecolor','none','linestyle','-','linewidth',3,'edgecolor',[0.93,0.69,0.13])       
plot([x3-tilt x3+tilt],[m(3) m(3)],'-','color',[0.93,0.69,0.13],'markersize',10,'linewidth',2)   

xlim([0 4])
ylim([0 700])
xticks([1 2 3])
title("Full POMDP")
set(gca,'fontsize',28)