"""
Figures 10 b,e - dynamic input signals
"""

import os
import sys
import pickle as pkl
from matplotlib import pyplot as plt
import numpy as np
import seaborn as sns

import helper

assert sys.version_info < (3, 0), "Please run this script using Python2.7"


def plot_fig10_input(data, filename, plot_raw_signal=False):
    """

    :param data: pickled data from simulation
    :param filename: where to save
    :param plot_raw_signal:
    :return:
    """
    helper.usetex_font()

    # figure params
    cmap_name = 'Greys'
    figure, ax = plt.subplots(1, 1, figsize=(5, 3))

    signal = data['encoded_input']
    input_signal_gen_cont = data['raw_signal']

    ax.imshow(signal, cmap=cmap_name, interpolation='none')
    if plot_raw_signal:
        ax.plot(np.arange(len(input_signal_gen_cont)), input_signal_gen_cont, color='tomato', alpha=0.3)

    ax.set_yticklabels([])
    ax.set_xticks([])
    ax.set_yticks([])
    ax.set_aspect('auto')
    ax.set_frame_on(False)
    sns.despine(ax=ax)
    ax.grid(False)

    figure.tight_layout()
    figure.savefig(os.path.join('plots/', filename))
    # plt.show()

if __name__ == "__main__":
    with open('data/fig_10b_fast_dynamic_input.pkl', 'rb') as f:
        data_b = pkl.load(f)
    with open('data/fig_10e_slow_dynamic_input.pkl', 'rb') as f:
        data_e = pkl.load(f)

    plot_fig10_input(data_b, 'fig10_b.pdf', plot_raw_signal=False)
    plot_fig10_input(data_e, 'fig10_e.pdf', plot_raw_signal=False)
