"""
Figure 10 c,f (top panels) - raster plots for dynamic input
"""

import os
import sys
import pickle as pkl
from matplotlib import pyplot as plt
from matplotlib.gridspec import GridSpec

assert sys.version_info < (3, 0), "Please run this script using Python2.7"


def plot_raster(data, filename):
    """

    :param data: pickled data from simulation
    :param filename: where to save
    :return:
    """
    figure = plt.figure(figsize=(20, 5))

    for idx, pop in enumerate(['E0', 'E2', 'E5']):
        axes_spikes = plt.subplot2grid((1, 3), (0, idx))

        times_exc = data[pop][:, 0]
        times_inh = data[pop.replace('E', 'I')][:, 0]
        neurons_exc = data[pop][:, 1] + 2000
        neurons_inh = data[pop.replace('E', 'I')][:, 1] - 8000
        c_exc = 'royalblue'
        c_inh = 'tab:red'

        axes_spikes.plot(times_exc, neurons_exc, '.', color=c_exc, markersize=4)
        axes_spikes.plot(times_inh, neurons_inh, '.', color=c_inh, markersize=4)
        n_neurons = 10000
        base = 100
        pop_idx = int(pop[1])
        axes_spikes.set(ylim=[pop_idx * n_neurons - 100, (pop_idx + 1) * n_neurons + 100],
                        xlim=[base * round(min(min(times_exc), min(times_inh)) / base) - 10,
                              base * round(max(max(times_exc), max(times_inh)) / base) + 10])

        axes_spikes.set_xticklabels([''])
        axes_spikes.set_yticklabels([''])
        axes_spikes.tick_params(labelsize=24)
        axes_spikes.tick_params(axis='x', which='both', bottom=False)
        axes_spikes.grid(False)
        axes_spikes.set_yticks([])
        axes_spikes.set_frame_on(False)

    figure.tight_layout()
    figure.subplots_adjust(wspace=0.2)
    figure.savefig(os.path.join('plots/', filename))


if __name__ == "__main__":
    with open('data/fig_10c_fast_raster.pkl') as f:
        data_1 = pkl.load(f)
    with open('data/fig_10f_slow_raster.pkl') as f:
        data_2 = pkl.load(f)

    plot_raster(data_1, 'fig10_c_raster.pdf')
    plot_raster(data_2, 'fig10_f_raster.pdf')
