"""
Figures 10 - d,g (bottom panel) - performance gain over SSNs as a function of modularity, for different noise values
"""

import os
import sys
import pickle as pkl
import seaborn as sns
from matplotlib import pyplot as plt
import numpy as np

assert sys.version_info < (3, 0), "Please run this script using Python2.7"

colors = ['skyblue', 'cornflowerblue', 'navy']

def plot_performance(data, filename):
    """

    :param data: pickled data from simulation
    :param filename: where to save
    :return:
    """
    p1_values = [0.8, 0.9, 1.]
    p2_values = data.keys()
    populations = sorted(data.values()[0].keys())

    ticksize = 36
    lw = 6.
    labelsize = 48

    for p2_idx, p2v in enumerate(p2_values):
        figure = plt.figure(figsize=(6, 5))

        ax = plt.subplot2grid((1, 1), (0, 0))
        ax.plot(np.arange(len(p1_values)), [0] * len(p1_values), '--', color='grey', label=None, linewidth=lw, ms=14,
                alpha=0.5)

        for idx, pop in enumerate(populations):
            mean = np.array(data[p2v][pop])
            ax.plot(np.arange(len(p1_values)), mean, '-o', color=colors[idx], label=None, linewidth=lw, ms=14)

        ax.grid(False)
        ax.set_ylim(-50, 70)
        ax.set_xticks(np.arange(len(p1_values)))
        ax.set_xticklabels(p1_values)
        ax.tick_params(axis='both', labelsize=ticksize, direction='out')
        ax.spines['right'].set_visible(False)
        ax.spines['top'].set_visible(False)

        # ax.set_ylabel('% gain', fontsize=labelsize)
        # ax.set_xlabel('m', fontsize=labelsize)

        figure.tight_layout()
        figure.savefig(os.path.join('plots/', filename))

if __name__ == "__main__":
    with open('data/fig_10d_fast_perf_noise.pkl') as f:
        data_1 = pkl.load(f)
    with open('data/fig_10g_slow_perf_noise.pkl') as f:
        data_2 = pkl.load(f)

    plot_performance(data_1, 'fig10_d_perf_noise.pdf')
    plot_performance(data_2, 'fig10_g_perf_noise.pdf')
