"""
Figures 10 - d, g (top panel) - performance gain over SSNs as a function of modularity
"""

import os
import sys
import pickle as pkl
import seaborn as sns
from matplotlib import pyplot as plt
import numpy as np

assert sys.version_info < (3, 0), "Please run this script using Python2.7"

color_palette = sns.cubehelix_palette(20, start=.5, rot=-.75)[::2]


def plot_performance(data, filename, percentage=False):
    """

    :param data: pickled data from simulation
    :param filename: where to save
    :param percentage: gain in %
    :return:
    """
    p1_values = [0.8, 0.9, 1.]
    p2_values = data.keys()
    populations = sorted(data.values()[0].keys())

    ticksize = 36
    lw = 6.
    labelsize = 48

    for p2_idx, p2v in enumerate(p2_values):
        figure = plt.figure(figsize=(6, 5))

        ax = plt.subplot2grid((1, 1), (0, 0))
        ax.plot(np.arange(len(p1_values)), [0] * len(p1_values), '--', color='grey', label=None, linewidth=lw, ms=14,
                alpha=0.5)

        for idx, pop in enumerate(populations):
            mean = np.array(data[p2v][pop])
            pop_ssn_id = int(pop[-1])
            ax.plot(np.arange(len(p1_values)), mean, 'o-', color=color_palette[pop_ssn_id], label=None, linewidth=lw, ms=14)

        ax.grid(False)
        ax.set_ylim(-50, 70)
        ax.set_xticks(np.arange(len(p1_values)))
        ax.set_xticklabels(p1_values)
        ax.tick_params(axis='both', labelsize=ticksize, direction='out')
        ax.spines['right'].set_visible(False)
        ax.spines['top'].set_visible(False)

        # ax.set_ylabel('% gain', fontsize=labelsize)
        # ax.set_xlabel('m', fontsize=labelsize)

        figure.tight_layout()
        figure.savefig(os.path.join('plots/', filename))

if __name__ == "__main__":
    with open('data/fig_10d_fast_perf_module.pkl') as f:
        data_1 = pkl.load(f)
    with open('data/fig_10g_slow_perf_module.pkl') as f:
        data_2 = pkl.load(f)

    plot_performance(data_1, 'fig10_d_perf_modules.pdf')
    plot_performance(data_2, 'fig10_g_perf_modules.pdf')
