"""
Figure 2b, noise amplification and suppression.
"""

import os
import sys
import pickle as pkl
from matplotlib import pyplot as plt
import numpy as np
import helper

assert sys.version_info < (3, 0), "Please run this script using Python2.7"


def plot_amp_supp(data, filename):
    """

    :param data: pickled data from simulation
    :param filename: where to save
    :return:
    """
    p1_values = np.around(np.arange(0.75, 1.01, 0.025), decimals=3)

    pop_base = 'E0'
    pop_tgt = 'E5'
    helper.usetex_font()
    noise = [0., 3.]

    ticksize = 32
    labelsize = 38

    figure = plt.figure(figsize=(16, 7))

    for idx, subpop in enumerate(['active', 'non_active']):
        ax = plt.subplot2grid((1, 2), (0, idx))

        for gwn_idx, gwn in enumerate(noise):
            rate_base_mean = data[pop_base][subpop]['mean_rates'][0][:, gwn_idx]
            rate_tgt_mean = data[pop_tgt][subpop]['mean_rates'][0][:, gwn_idx]

            lw = 4.
            color = ['cornflowerblue', 'tab:orange'][gwn_idx]
            lstyle = '-' if subpop == 'active' else '--'
            ax.plot(p1_values, rate_tgt_mean / rate_base_mean, lstyle, color=color,
                    label=r'$\sigma_\xi = {}$'.format(gwn), lw=lw)

            ax.grid(False)
            ax.tick_params(axis='both', labelsize=ticksize)
            ax.set_xticks([0.75, 0.8, 0.85, 0.9, 0.95, 1.0])
            ax.set_yscale('log')
            ax.spines['right'].set_visible(False)
            ax.spines['top'].set_visible(False)

            if subpop == 'active':
                plt.legend(loc='best', prop={'size': 34}, handleheight=1.2, handlelength=2.5)
                ax.plot(p1_values, [1] * len(p1_values), '--', color='k', alpha=0.5, lw=lw)
                ax.set_ylabel(r'$\nu_5^\mathrm{S} / \nu_0^\mathrm{S}$', fontsize=labelsize)
            else:
                ax.set_ylim([10 ** -3, 1])
                ax.set_ylabel(r'$\nu_5^\mathrm{NS} / \nu_0^\mathrm{NS}$', fontsize=labelsize)

    figure.tight_layout()
    figure.savefig(os.path.join('plots/', filename))


if __name__ == "__main__":
    with open('data/fig_2_amp_supp.pkl') as f:
        data = pkl.load(f)

    plot_amp_supp(data, 'fig2_b.pdf')
