import numpy as np

dataset_energy = {
    # >>> _1-500_highRes2000 <<<
    '_1-500_highRes2000': {
        'rates_Ax': np.array([1.] + np.arange(2., 500.1, 1.).tolist()),  # values of rAx for which to calculate U
        'dr_grid_samples': 2000
    },
    '_0-500_highResX4_direct': {
        'rates_Ax': np.arange(0., 500.1, 5.),  # values of rAx for which to calculate U
    },
    '_0-2_ultraResX4_direct': {
        'rates_Ax': np.arange(0., 2.5001, 0.01),  # values of rAx for which to calculate U
    },
    '_0-3_ULTRAResX4_direct': {
        'rates_Ax': np.arange(0., 3.001, 0.001),  # values of rAx for which to calculate U
    },
    '_0-3_ULTRA=0,0025_ResX4_direct': {
        'rates_Ax': np.arange(0., 3.001, 0.0025),  # values of rAx for which to calculate U
    },
    '_0-3_ULTRA=0,001_ResX4_direct': {
        'rates_Ax': np.arange(0., 3.001, 0.001),  # values of rAx for which to calculate U
    },
    '_0-4_ULTRA=0,0025_ResX4_direct': {
        'rates_Ax': np.arange(0., 4.001, 0.0025),  # values of rAx for which to calculate U
    },
    '_0-5_ULTRA=0,0025_ResX4_direct': {
        'rates_Ax': np.arange(0., 5.001, 0.0025),  # values of rAx for which to calculate U
    },

    '_0,2-500_ultraRes5000': {
        'rates_Ax': np.arange(0.2, 500.1, 0.2),
        'dr_grid_samples': 5 * 500 * 2
    },

    '_0,1-30_highRes': {
        'rates_Ax': np.arange(0.1, 30.001, 0.1),
        'dr_grid_samples': 300
    },
    '_0,1-3_ultraRes': {
        'rates_Ax': np.arange(0.1, 3.001, 0.1),
        'dr_grid_samples': 1200
    },
    '_0,001-2-0,005_ultra2Res': {
        'rates_Ax': np.arange(0.001, 2.001, 0.005),
        'dr_grid_samples': 1200
    },
    '_SG_1-500-1': {
        'rates_Ax': np.arange(1., 500.01, 1.),  # range of rA for which to calculate U
        'dr_grid_samples': 1000
    },

    ##### TEST #########
    '__TEST_MultiSmall': {
        # 'rates_Ax': np.arange(0., 30.1, .5).tolist()),  # values of rAx for which to calculate U
        'rates_Ax': np.array([10.]),  # values of rAx for which to calculate U
    },
}