"""
Figure 8a.
"""
import sys
import os
sys.path.append(os.environ.get('NEST_PYTHON_PREFIX'))
sys.path.append('../')
sys.path.append('../../')
sys.path.append('../../../')

assert sys.version_info >= (3, 0), "Please run this script using Python3"
import numpy as np
import pickle as pkl

from mft_helpers import mft_parameters as parameters
from mft_helpers import calc
from mft_helpers import mft_plotting
from mft_helpers import siegert
from mft_helpers.siegert import piecewise_linear_approx as pla_
from matplotlib import pyplot as plt
import seaborn as sns

recompute = False  # change to run fixed point search again, otherwise use stored data

if __name__ == "__main__":
    pars = parameters.set_parameter_space()  # create parameter set
    pars = calc.derived_parameters(pars)
    siegert.experiment_pars = pars

    if pars['method'] == 'nu0_fb433':
        siegert_func = siegert.nu0_fb433
    else:
        siegert_func = siegert.nu0_fb

    mus = np.arange(-200, 1000, 10)
    sigmas = [1., 10., 50.]
    siegert_arr = np.zeros((len(sigmas), len(mus)))
    plas = np.zeros(len(mus))

    for s, sigma in enumerate(sigmas):
        print(sigma)
        for m, mu in enumerate(mus):
            siegert_arr[s, m] = siegert_func(pars['tau_m'], pars['tau_s'], pars['tau_r'], pars['V_th'],
                                             pars['V_reset'], mu, sigma) * 1e3

    pla = lambda x: pla_(pars['tau_m'], pars['tau_s'], pars['tau_r'], pars['V_th'], pars['V_reset'], x, None) * 1e3
    for m, mu in enumerate(mus):
        plas[m] = pla(mu)

    mft_plotting.usetex_font()
    fig = plt.figure(figsize=(7, 4))
    # fig = plt.figure(figsize=plt.figaspect(0.6))

    lw = 3.5
    labelsize = mft_plotting.fig_defaults['labelsize']['main_fp'] * 1.2
    ticksize = mft_plotting.fig_defaults['ticksize']['main_fp'] * 1.2
    legendsize = mft_plotting.fig_defaults['legendsize']['main_fp'] * 1.3
    plt.plot(mus, siegert_arr[0], color='0.0', label=r'LIF with $\sigma=1$', lw=lw)
    plt.plot(mus, siegert_arr[1], color='0.3', label=r'LIF with $\sigma=10$', lw=lw)
    plt.plot(mus, siegert_arr[2], color='0.6', label=r'LIF with $\sigma=50$', lw=lw)
    plt.plot(mus, plas, '--', color='tomato', label='Piecewise linear', lw=lw)
    plt.xlabel(r'$\mu$', fontsize=labelsize)
    plt.ylabel(r'$\nu$', fontsize=labelsize)
    plt.tick_params('both', labelsize=ticksize)
    sns.despine()

    plt.legend(fontsize=legendsize)
    plt.tight_layout()
    fig.savefig(f'plots/fig8_a.pdf')
