"""
Figure 8h
"""
import sys
import os
sys.path.append(os.environ.get('NEST_PYTHON_PREFIX'))
sys.path.append('../')
sys.path.append('../../')
sys.path.append('../../../')

assert sys.version_info >= (3, 0), "Please run this script using Python3"
import numpy as np
import pickle as pkl

from mft_helpers import mft_parameters as parameters
from mft_helpers import calc
from mft_helpers import mft_plotting
from matplotlib import pyplot as plt
import seaborn as sns

recompute = False  # change to run fixed point search again, otherwise use stored data
method = 'nu0_fb433'
round_rates = 'manual'  # previously working version


if __name__ == "__main__":
    pars = parameters.set_parameter_space()  # create parameter set
    pars = calc.derived_parameters(pars)
    pars['method'] = method
    pars['nuX'] = 12.
    pars['g'] = 3.

    stability_analysis = 'matrix'
    filename = f"data/fig_8h_data.pkl"
    print(f'Processing Fig 8h for dataset: {filename}')

    if recompute:
        ## compute self-consistent stationary state (firing rate, mean and SD of input; "working point")
        # new stability analysis (currently disabled for siegert)
        results = calc.fixed_points(pars, modularity_values=np.arange(.0, 1., 0.01), round_rates=round_rates,
                                    stability_analysis=stability_analysis, multithreaded=True)

        with open(filename, 'wb') as f:
            pkl.dump(results, f)
    else:
        with open(filename, 'rb') as f:
            results = pkl.load(f)

    print('Finished calculating the fixed points. Will plot now.')
    filename_suffix = f'_round-nu={round_rates}_g={pars["g"]}__narrow'

    # sparsify data
    modularity_values = np.arange(.0, 1.01, 0.05)
    results = {k: v for k, v in results.items() if np.any(np.isclose(modularity_values, k))}

    fig, ax, fig_filename = mft_plotting.plot_fixed_points(results, pars, stability_analysis=stability_analysis,
                                                           filename_suffix=filename_suffix, save=False,
                                                           overlapping=True, frameon=False, figsize="narrow",
                                                           # loc_legend_stability='lower right',
                                                           loc_legend_stability=None,
                                                           loc_legend_stimulated='lower left', )
    mft_plotting.sns.despine(ax=ax)
    ax.set_ylim(1e-1, 700)
    ax.set_xticks([0, 0.5, 1.])
    ax.set_title(None)
    fig.savefig(f"{pars['figure_root_path']}/fig8_h.pdf")
    # plt.show()
