"""
Figure 3b.
"""
import sys
import os
sys.path.append(os.environ.get('NEST_PYTHON_PREFIX'))
sys.path.append('../')
sys.path.append('../../')
sys.path.append('../../../')

assert sys.version_info < (3, 0), "Please run this script using Python2"

import numpy as np
from matplotlib import pyplot as plt
from matplotlib import ticker
import seaborn as sns
import pickle as pkl

import helper


class OOMFormatter(ticker.ScalarFormatter):
    def __init__(self, order=0, fformat="%1.1f", offset=True, mathText=True):
        self.oom = order
        self.fformat = fformat
        ticker.ScalarFormatter.__init__(self, useOffset=offset, useMathText=mathText)

    def _set_orderOfMagnitude(self, nothing=None):
        self.orderOfMagnitude = self.oom

    def _set_format(self, vmin=None, vmax=None):
        self.format = self.fformat
        if self._useMathText:
            self.format = '$%s$' % ticker._mathdefault(self.format)


if __name__ == "__main__":
    with open('data/fig_3_effective_coupling.pkl', 'rb') as f:
        data = pkl.load(f)

    helper.usetex_font()
    n_modules = 6
    modularity = np.round(np.arange(0.8, .881, 0.01), decimals=3)
    color_palette = sns.cubehelix_palette(20, start=.5, rot=-.75)[::2]

    key = 'w_recEA'
    non_active_key = key.replace('A', '0')

    fig = plt.figure(figsize=plt.figaspect(0.7))
    # fig = plt.figure(figsize=(7, 5))
    ax = plt.subplot2grid((1, 1), (0, 0))
    lw = 4.
    for module_idx in range(n_modules):
        ax.plot(modularity, data[key][module_idx], '-', lw=lw,
                color=color_palette[module_idx], label='stimulated' if module_idx == 5 else None)
        ax.plot(modularity, data[non_active_key][module_idx], '--', lw=lw,
                color=color_palette[module_idx], label='non-stimulated' if module_idx == 5 else None)

    ax.yaxis.set_major_formatter(OOMFormatter(-3, "%1d"))
    ax.ticklabel_format(style='sci', scilimits=(0, 0), axis='y', useOffset=True)
    ax.yaxis.offsetText.set_fontsize(22)
    ax.grid(False)
    ax.spines['right'].set_visible(False)
    ax.spines['top'].set_visible(False)
    ax.tick_params(axis='both', labelsize=26, direction='out')
    fig.tight_layout()
    fig.savefig("plots/fig3_b.pdf")



