"""
Figure 7f.
"""
import sys
sys.path.append('../')
sys.path.append('../../')
sys.path.append('../../../')

assert sys.version_info >= (3, 0)

import numpy as np
import pickle as pkl

from mft_helpers import mft_parameters as parameters
from mft_helpers import calc
from mft_helpers import mft_plotting

recompute = False  # change to run fixed point search again, otherwise use stored data

if __name__ == "__main__":
    pars = parameters.set_parameter_space()  # create parameter set
    pars = calc.derived_parameters(pars)

    data_full_path = './data/fix_points_vs_lambda.pkl'
    modularity_values = np.arange(0.73, 0.93, 0.01)

    if recompute:
        results = calc.fixed_points(pars, modularity_values=np.arange(0.6, 1.001, 0.01))

        ## compute limits rates for three different stimulus strengths
        results_low_input, _, limits_low_input = calc.nu_vs_layers(pars, modularity_values,
                                                                   rates_initial_layer=results[0.01])
        results_standard_input, _, limits_standard_input = calc.nu_vs_layers(pars, modularity_values,
                                                                             rates_initial_layer=results[0.05])
        results_high_input, _, limits_high_input = calc.nu_vs_layers(pars, modularity_values,
                                                                     rates_initial_layer=results[0.25])

    else:
        with open(data_full_path, 'rb') as f:
            results = pkl.load(f)
        limits_low_input, limits_standard_input, limits_high_input = results['low'][1], results['standard'][1], \
                                                                     results['high'][1]

    mft_plotting.plot_fixed_points_vs_lambda(modularity_values, limits_low_input, limits_standard_input,
                                             limits_high_input, pars)