"""
Figure 6c
"""

import os
import sys
import pickle as pkl
import seaborn as sns
from matplotlib import pyplot as plt
from matplotlib.ticker import MaxNLocator
import numpy as np
import helper
import seaborn as sns

assert sys.version_info < (3, 0), "Please run this script using Python2.7"


def plot_performance(data_, filename, percentage=False):
    """

    :param data_: pickled data from simulation
    :param filename: where to save
    :return:
    """
    ticksize = 24
    labelsize = 26
    lw = 3.
    d2 = True

    populations = ['E5']
    p1_values = [.84, .86, .88, 0.9, .92]
    p2_values = [0.04]
    p1_values = np.array(p1_values)

    for p2_idx, p2v in enumerate(p2_values):
        helper.usetex_font()
        figure = plt.figure(figsize=(6, 6 * 0.8))

        ax = plt.subplot2grid((1, 1), (0, 0))
        for idx, pop in enumerate(populations):
            if pop == 'E0':
                continue

            res_0vs0 = np.divide((data_['E0'][0] - data_[pop][0]), np.abs(data_['E0'][0])) * 100.
            res_1vs0 = np.divide((data_['E0'][0] - data_[pop][1]), np.abs(data_['E0'][0])) * 100.
            res_2vs0 = np.divide((data_['E0'][2] - data_[pop][2]), np.abs(data_['E0'][2])) * 100.

            colors = sns.color_palette('Blues', 6)[::2]

            ax.plot(p1_values, [0.] * len(p1_values), '--', color='tab:red', linewidth=lw)
            ax.plot(p1_values, res_0vs0[:, p2_idx], '-', color=colors[0], label=r'$\delta$=0.', lw=lw)
            ax.plot(p1_values, res_1vs0[:, p2_idx], '-', color=colors[1], label=r'$\delta$=0.01', lw=lw)
            ax.plot(p1_values, res_2vs0[:, p2_idx], '-', color=colors[2], label=r'$\delta$=0.02', lw=lw)

        ax.set_ylabel('% gain', fontsize=labelsize)
        ax.set_xlabel('m', fontsize=labelsize)
        ax.set_xticks(p1_values[::2])
        ax.set_yticks([-20., 0., 20., 40.])
        ax.spines['right'].set_visible(False)
        ax.spines['top'].set_visible(False)
        ax.grid(False)
        ax.tick_params(axis='both', labelsize=ticksize, direction='out')
        figure.tight_layout()
        plt.legend(loc='best', prop={'size': 'x-large'}, handlelength=3.)

        figure.savefig(os.path.join('plots/', filename))


if __name__ == "__main__":
    with open('data/fig_6_performance_increasing_mapsize.pkl') as f:
        data = pkl.load(f)

    plot_performance(data, 'fig6_c.pdf')
