"""
Figure 6 S1 a
"""
import sys
import os
sys.path.append(os.environ.get('NEST_PYTHON_PREFIX'))
sys.path.append('../')
sys.path.append('../../')
sys.path.append('../../../')

assert sys.version_info < (3, 0), "Please run this script using Python2.7"

import pickle as pkl
import numpy as np
import matplotlib
from mpl_toolkits.axes_grid1 import make_axes_locatable
from matplotlib.ticker import MaxNLocator
from matplotlib import pyplot as plt
import seaborn as sns

import helper
# from mft_helpers import mft_parameters as parameters
# from mft_helpers import calc


def plot_rates(data_, filename):
    """

    :param data_:
    :param filename:
    :return:
    """
    modularity = np.round(np.arange(0.7, .921, 0.01), decimals=3)
    populations = ['E{}'.format(i) for i in range(6)]

    ticksize = 20
    labelsize= 24
    lw = 4.
    helper.usetex_font()
    
    figure = plt.figure(figsize=(6, 4))
    ax = figure.add_subplot(111)
    color_palette = sns.cubehelix_palette(20, start=.5, rot=-.75)[::2]

    for p_idx, p_ in enumerate(populations):
        # ax_active.plot(np.arange(len(modularity)), data_[p_]['active'], '-', lw=lw,
        ax.plot(modularity, data_[p_]['active'], '-', lw=lw,
                       color=color_palette[p_idx], label=r'$\mathrm{SSN}_' + str(p_[-1]) + '{}$')

    ax.xaxis.set_major_locator(MaxNLocator(nbins=5))
    ax.grid(False)
    ax.spines['right'].set_visible(False)
    ax.spines['top'].set_visible(False)
    ax.tick_params(axis='both', labelsize=20, direction='out')

    ax.legend(loc='upper left', prop={'size': 16}, handleheight=1.1, handlelength=2)

    ax.set_ylabel(r"spks/sec", fontsize=labelsize)
    ax.set_xlabel("m", fontsize=labelsize)

    ax.tick_params(axis='both', direction='out', labelsize=ticksize)
    figure.tight_layout()
    figure.savefig(os.path.join('plots/', filename))


if __name__ == "__main__":
    with open('data/fig_6_rates_mapsize=0.05.pkl', 'rb') as f:
        data = pkl.load(f)
    plot_rates(data, 'fig6_s1_b_d=0.05.pdf')

    with open('data/fig_6_rates_mapsize=0.2.pkl', 'rb') as f:
        data = pkl.load(f)
    plot_rates(data, 'fig6_s1_b_d=0.2.pdf')
