"""

"""
import matplotlib
from matplotlib import pyplot as plt
import numpy as np


def usetex_font():
    import shutil
    import matplotlib.font_manager
    # shutil.rmtree(matplotlib.font_manager.get_cachedir())

    # pl.rc('text.latex', preamble='\usepackage{sfmath}')
    # plt.rc('font', **{'family': 'sans-serif', 'sans-serif': ['Helvetica']})
    # plt.rc('font', **{'family': 'sans-serif', 'sans-serif': ['DejaVu Sans']})
    plt.rc('font', **{'family': 'sans-serif', 'sans-serif': ['Liberation Sans']})
    # plt.rc('font', **{'family': 'sans-serif'})

    # for f in matplotlib.font_manager.fontManager.ttflist:
    #     print(f.name)

    # matplotlib.rcParams['mathtext.fontset'] = 'stixsans'
    # matplotlib.rcParams['mathtext.fontset'] = 'cm'
    matplotlib.rcParams['mathtext.default'] = 'it'
    matplotlib.rcParams['mathtext.fontset'] = 'custom'
    matplotlib.rcParams['mathtext.bf'] = 'Liberation Sans:bold'
    matplotlib.rcParams['mathtext.it'] = 'Liberation Sans:italic'
    matplotlib.rcParams['mathtext.rm'] = 'Liberation Sans'
    matplotlib.rcParams['mathtext.cal'] = 'Liberation Sans'

    # matplotlib.rcParams['mathtext.bf'] = 'Helvetica:bold'
    # matplotlib.rcParams['mathtext.it'] = 'Helvetica:italic'
    # matplotlib.rcParams['mathtext.rm'] = 'Helvetica'
    # matplotlib.rcParams['mathtext.cal'] = 'Helvetica'


def shiftedColorMap(cmap, start=0, midpoint=0.5, stop=1.0, name='shiftedcmap'):
    '''
    Function to offset the "center" of a colormap. Useful for
    data with a negative min and positive max and you want the
    middle of the colormap's dynamic range to be at zero.

    Input
    -----
      cmap : The matplotlib colormap to be altered
      start : Offset from lowest point in the colormap's range.
          Defaults to 0.0 (no lower offset). Should be between
          0.0 and `midpoint`.
      midpoint : The new center of the colormap. Defaults to
          0.5 (no shift). Should be between 0.0 and 1.0. In
          general, this should be  1 - vmax / (vmax + abs(vmin))
          For example if your data range from -15.0 to +5.0 and
          you want the center of the colormap at 0.0, `midpoint`
          should be set to  1 - 5/(5 + 15)) or 0.75
      stop : Offset from highest point in the colormap's range.
          Defaults to 1.0 (no upper offset). Should be between
          `midpoint` and 1.0.
    '''
    cdict = {
        'red': [],
        'green': [],
        'blue': [],
        'alpha': []
    }

    # regular index to compute the colors
    reg_index = np.linspace(start, stop, 257)

    # shifted index to match the data
    shift_index = np.hstack([
        np.linspace(0.0, midpoint, 128, endpoint=False),
        np.linspace(midpoint, 1.0, 129, endpoint=True)
    ])

    for ri, si in zip(reg_index, shift_index):
        r, g, b, a = cmap(ri)

        cdict['red'].append((si, r, r))
        cdict['green'].append((si, g, g))
        cdict['blue'].append((si, b, b))
        cdict['alpha'].append((si, a, a))

    newcmap = matplotlib.colors.LinearSegmentedColormap(name, cdict)
    plt.register_cmap(cmap=newcmap)

    return newcmap