import NeuroTools.parameters as para
import os

def set_parameter_space():
    """

    :return:
    """
    p=para.ParameterSpace({})

    ########################
    p['parameterspace_label'] = 'testing'

    ########################
    ## network parameters
    p['N']=10000                                      ## number of neurons
    p['KE']=800                                       ## total number of recurrent excitatory synapses onto one neuron
    p['fixed_degree']='in'                            ## fixed in-degree: 'in', fixed out-degree: 'out'
    p['beta']=0.8                                     ## fraction of excitatory neurons

    p['J']=32.28

    p['g']= 12.0 # 6.0, 4.0                           ## relative weight of inhibitory synapses, g=-JEI/JEE
    #p['g']= 7.0#, 4.0                           ## relative weight of inhibitory synapses, g=-JEI/JEE
    p['q']=1.0                                        ## relative weight of synapses on inhibitory target neurons, q=JIE/JEE=JII/JEI

    ########################
    ## external input
    p['noise_alpha'] = 0.25
    p['ext_K'] = 800       ## outdegree of external sources = number of (randomly chosen) targets in the network per external-input channel
    p['nuX'] = 12. # 200., 350., 500., 750., 1700.                      ## rate of Poissonian external-input channels (spikes/s)
    p['JX']  = 32.28 ## 32., 70., 100., 150., 230.     ## weight of external inputs (pA)

    ########################
    ## neuron parameters
    p['neuron_model'] = 'iaf_psc_exp'
    p['V_rest'] = 0.0                 ## resting membrane potential (mV)
    p['C_m'] = 250.                   ## membrane capacitance (pF? nF?)
    p['tau_m'] = 20.                  ## membrane time constant (ms)
    p['tau_r'] = 2.0                  ## refractory period (ms)
    p['tau_s'] = 2.0                  ## synaptic time constant (ms)
    p['V_th'] = 15.0                  ## spike threshold (mV)
    p['V_reset'] = 0.0                ## reset potential (mV)
    p['V_m'] = 0.0                    ## initial potential (mV)


    p['n_initial_weights'] = 1                 ## number of (random) initial weights for  homeostasis fixed-point search
    p['intv_initial_weight_factor'] = [1.,10.]  ## initial weight-factor interval for homeostasis fixed-point search (1=weight before homeostasis)
    p['seed_initial_weights'] = 0               ## RNG seed for choosing initial weights in fixed-point search

    ########################
    ## evaluation method
    # p['method']='theory'        ## diffusion approximation, mean-field theory
    # p['method']='nu0_fb'        ## diffusion approximation, mean-field theory

    # DO NOT CHANGE THIS (as it will lead to different results)!!
    p['method']='nu0_fb433'        ## diffusion approximation, mean-field theory

    ########################
    ## self-consistent state search    
    p['n_initial_rates'] = 1000         # # number of (random) initial rates for fixed-point search
    #p['intv_initial_ratesA'] = [50., 500.] ## initial rate interval for fixed-point search
    p['intv_initial_ratesA'] = [0., 500.] ## initial rate interval for fixed-point search
    #p['intv_initial_ratesNA'] = [0., 10.] ## initial rate interval for fixed-point search
    p['intv_initial_ratesNA'] = [0., 500.] ## initial rate interval for fixed-point search
    p['max_error'] = 1e-16             ## maximum tolerable error (Euclidean distance) for fixed-point search (1/s^2)
    #p['max_error'] = 1e-3             ## maximum tolerable error (Euclidean distance) for fixed-point search (1/s^2)
    p['rate_precision'] = 1e-2         ## precision of fixed point rates (1/s)
    p['seed_initial_rates'] = 0        ## RNG seed for choosing initial rates in fixed-point search

    p['store_data'] =  True
    p['max_cpu_threads_2Dpotentials'] = 4


    p['figure_root_path'] = './'
    return p
