from matplotlib import pyplot as plt
from matplotlib.colors import ListedColormap
import seaborn as sns
import numpy as np
import os

import mft_parameters

pars=parameters.set_parameter_space()  ## create parameter set

def colorbar_nu_vs_layers():
    n_colors = 15
    color_offset = 3
    cmap_xlim = color_offset / float((n_colors + 2*color_offset))
    # cmap = sns.diverging_palette(250, 15, s=75, l=40, sep=1, n=n_colors, center="light", as_cmap=True)
    cmap = 'twilight_shifted'

    a = np.array([[0, 1]])
    plt.figure(figsize=(9, 2))
    img = plt.imshow(a, cmap=cmap)
    plt.gca().set_visible(False)
    cax = plt.axes([0.1, 0.3, 0.8, 0.5])
    cbar = plt.colorbar(orientation="horizontal", cax=cax, ticks=[cmap_xlim, 1-cmap_xlim])
    # cbar = plt.colorbar(orientation="horizontal", cax=cax)
    cbar.ax.set_xlim([cmap_xlim, 1-cmap_xlim])
    cbar.ax.set_xticklabels([0.75, 0.9])
    cbar.ax.tick_params(labelsize=36)
    # sns.despine(ax=cbar.ax, top=True, left=True, bottom=True, right=True)
    cbar.outline.set_visible(False)
    plt.savefig(os.path.join(pars['data_root_path'], "colorbar_nu_vs_layers.pdf"))

colorbar_nu_vs_layers()