"""
Figure 4 a,b,c - inhibition.
"""

import os
import sys
import pickle as pkl
from matplotlib import pyplot as plt
from matplotlib.gridspec import GridSpec

assert sys.version_info < (3, 0), "Please run this script using Python2.7"


def plot_fig4_raster(data_, dataset, filename):
    """

    :param data_: pickled data from simulation
    :param dataset: name of dataset as stored (baseline, no_noise, with_noise, sync)
    :param filename: where to save
    :return:
    """
    figure = plt.figure(figsize=plt.figaspect(0.7))
    spikes_exc, spikes_inh = data_[dataset]

    axes_spikes = plt.subplot2grid((1, 1), (0, 0))
    times_exc = spikes_exc[:, 0]
    times_inh = spikes_inh[:, 0]
    neurons_exc = spikes_exc[:, 1] + 2000
    neurons_inh = spikes_inh[:, 1] - 8000
    c_exc = 'royalblue'
    c_inh = 'tab:red'

    axes_spikes.plot(times_exc, neurons_exc, '.', color=c_exc, markersize=2)
    axes_spikes.plot(times_inh, neurons_inh, '.', color=c_inh, markersize=2)
    n_neurons = 10000
    base = 100
    pop_idx = 5
    axes_spikes.set(ylim=[pop_idx * n_neurons - 100, (pop_idx + 1) * n_neurons + 100],
                    xlim=[base * round(min(min(times_exc), min(times_inh)) / base) - 10,
                          base * round(max(max(times_exc), max(times_inh)) / base) + 10])

    axes_spikes.set_xticklabels([''])
    axes_spikes.set_yticklabels([''])
    axes_spikes.tick_params(labelsize=24)
    axes_spikes.tick_params(axis='x', which='both', bottom=False)
    axes_spikes.grid(False)
    axes_spikes.set_yticks([])
    axes_spikes.set_frame_on(False)

    figure.tight_layout()
    figure.savefig(os.path.join('plots/', filename))


if __name__ == "__main__":
    with open('data/inhibition_spiking_data.pkl') as f:
        data = pkl.load(f)

    plot_fig4_raster(data, 'baseline', 'fig4_a.pdf')
    plot_fig4_raster(data, 'sync', 'fig4_b.pdf')
    plot_fig4_raster(data, 'no_noise', 'fig4_c_left.pdf')
    plot_fig4_raster(data, 'with_noise', 'fig4_c_right.pdf')
