"""
Figure 3d - eigenclouds
"""

import os
import sys
import pickle as pkl
from matplotlib import pyplot as plt
import seaborn as sns
import numpy as np
import helper

assert sys.version_info < (3, 0), "Please run this script using Python2.7"


def plot_eigencloud(data_, m_, filename):
    """

    :param data_: pickled data from simulation
    :param filename: where to save
    :return:
    """
    helper.usetex_font()

    set_name = 'evs_tgt_rec'
    trial = 0
    truncate = True
    ticksize = 26
    module_idx = 4

    figure = plt.figure(figsize=plt.figaspect(1.))

    if truncate:
        eigenvals = data_[set_name][m_][module_idx][trial]
        eigenvals = eigenvals[np.where(np.absolute(eigenvals) <= 1)]
    else:
        eigenvals = data_[set_name][m_][module_idx][trial]

    ax = figure.add_subplot(111)

    ax.scatter(eigenvals.real, eigenvals.imag, s=3, color='k')
    # if not truncate and spectral_radius <= 1:
    if truncate:
        ax.set_xlim(left=-1.2, right=1)
        ax.set_ylim(bottom=-1.2, top=1)
    ax.set_xticks([-1., 0., 1.])
    ax.set_yticks([-1., 0., 1.])
    ax.tick_params(axis='both', which='major', labelsize=ticksize, direction='out', left=True)

    ax.spines['right'].set_visible(False)
    ax.spines['top'].set_visible(False)

    ax.grid(False)
    figure.tight_layout()

    figure.savefig(os.path.join('plots/', filename))


if __name__ == "__main__":
    with open('data/fig_3_eigenvalues.pkl') as f:
        data = pkl.load(f)

    plot_eigencloud(data, 0.8, 'fig3_d_m=0.8.pdf')
    plot_eigencloud(data, 0.9, 'fig3_d_m=0.9.pdf')
