"""
Figure 8d
"""
import sys
import os
sys.path.append(os.environ.get('NEST_PYTHON_PREFIX'))
sys.path.append('../')
sys.path.append('../../')
sys.path.append('../../../')

import pickle as pkl
import numpy as np
import matplotlib
from mpl_toolkits.axes_grid1 import make_axes_locatable
from matplotlib import pyplot as plt
from matplotlib.ticker import MaxNLocator
import seaborn as sns

import helper
# from mft_helpers import mft_parameters as parameters
# from mft_helpers import calc


def plot_scan(data_, plot_labels=False, filename=None):
    """

    :param data_:
    :param filename:
    :return:
    """
    # figure parameters
    helper.usetex_font()
    lw = 3.
    ticksize = 28
    labelsize = 32
    ms = 13
    mew = 2.
    
    n_modules = 12

    figure = plt.figure(figsize=(6, 6 * 0.7))
    ax_cc = plt.subplot2grid((1, 1), (0, 0))

    ax_cc.plot(np.arange(n_modules).astype(int), data_, 'o-', color='k', lw=lw,
               mfc='white', mew=mew, ms=ms)
    ax_cc.plot(np.arange(n_modules).astype(int), [0] * n_modules, '--', color='k')
    ax_cc.grid(False)
    ax_cc.tick_params(axis='both', labelsize=ticksize)
    ax_cc.set_xticks(np.arange(n_modules).astype(int)[::2])
    ax_cc.set_xticklabels(np.arange(n_modules).astype(int)[::2] + 1)
    ax_cc.set_yticks(np.arange(-0.2, 0.61, 0.2))
    ax_cc.set_ylim([-0.22, 0.62])
    ax_cc.set_xlabel('Sub-networks', fontsize=labelsize)
    ax_cc.set_ylabel('Similarity score', fontsize=labelsize)

    sns.despine()

    figure.tight_layout()
    figure.savefig(os.path.join('plots/', filename))


if __name__ == "__main__":
    with open('data/fig_8_coex_layerwise.pkl', 'rb') as f:
        data = pkl.load(f)
    plot_scan(data, filename='fig8_d.pdf')
