"""
Figure 8d
"""
import sys
import os
sys.path.append(os.environ.get('NEST_PYTHON_PREFIX'))
sys.path.append('../')
sys.path.append('../../')
sys.path.append('../../../')

import pickle as pkl
import numpy as np
import matplotlib
from mpl_toolkits.axes_grid1 import make_axes_locatable
from matplotlib import pyplot as plt
from matplotlib.ticker import MaxNLocator
import seaborn as sns

import helper
# from mft_helpers import mft_parameters as parameters
# from mft_helpers import calc


def plot_scan(data_, plot_labels=False, filename=None):
    """

    :param data_:
    :param filename:
    :return:
    """
    results_duration, results_switches = data_
    p1_values = np.around(np.arange(0.8, 1.01, 0.02), decimals=3)

    # figure parameters
    helper.usetex_font()
    lw = 3.
    ticksize = 28
    labelsize = 32
    ms = 13
    mew = 2.
    plot_switches = True
    n_modules = 12
    figure = plt.figure(figsize=(6, 6 * 0.7))
    # figure = plt.figure(figsize=plt.figaspect(0.7))
    ax = plt.subplot2grid((1, 1), (0, 0))

    color = 'k'
    # l1, = ax.plot(p1_values, [results_duration[p1v][0] for p1v in p1_values], 'o-', color=color, lw=lw)

    if plot_switches:
        l1_sw, = ax.plot(p1_values, [results_switches[np.float32(p1v)][0] for p1v in p1_values],
                         'o-', color=color, lw=lw, mfc='white', mew=mew, ms=ms)

    ax.set_xlabel('m', fontsize=labelsize)
    ax.set_ylabel('State switches', fontsize=labelsize)

    ax.grid(False)
    ax.tick_params(axis='both', labelsize=ticksize)
    ax.yaxis.set_major_locator(MaxNLocator(4))
    sns.despine()

    figure.tight_layout()
    figure.savefig(os.path.join('plots/', filename))


if __name__ == "__main__":
    with open('data/fig_8_switching.pkl', 'rb') as f:
        data = pkl.load(f)
    plot_scan(data, filename='fig8_f.pdf')
