"""
Figure 9 - figure supplement 2 - potential landscape for two input streams
"""
import sys
import os
sys.path.append(os.environ.get('NEST_PYTHON_PREFIX'))
sys.path.append('../')
sys.path.append('../../')
sys.path.append('../../../')

assert sys.version_info >= (3, 0), "Please run this script using Python3"
import numpy as np
import pickle as pkl

from mft_helpers import mft_parameters as parameters
from mft_helpers import calc
from mft_helpers import mft_plotting

# change to run fixed point search again, otherwise use stored data. Note that these computations take a long time.
recompute = False

if __name__ == "__main__":
    pars = parameters.set_parameter_space()  # create parameter set
    pars = calc.derived_parameters(pars)

    modularities = [0.85, 0.9, 1.]
    rates_Ax = np.arange(0., 500.01, 5.)  # range of rA for which to calculate U
    pars['output_label'] = 'potential_multi'

    potentials = calc.energy_multi_trapezoid_direct_path(rates_Ax, modularities, pars, recompute,
                                                         data_full_path='data/fig_9_potential_multi.h5')
    mft_plotting.plot_energy_multi(pars, rates_Ax, potentials)